/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "../game/q_shared.h"
#include "../gameshared/gs_public.h"
#include "ui_public.h"
#include "../cgame/ref.h"
#include "ui_syscalls.h"
#include "ui_atoms.h"
#include "ui_keycodes.h"
#include "ui_boneposes.h"	// skelmod

extern char *gametype_names[];
extern char *gametype_filternames[];
extern char *noyes_names[];
extern char *offon_names[];

typedef struct
{
	int		vidWidth;
	int		vidHeight;

	unsigned int	time;

	float	scaleX;
	float	scaleY;

	int		cursorX;
	int		cursorY;

	int		clientState;
	int		serverState;

	struct shader_s *whiteShader;

	struct mufont_s *fontSystemSmall;
	struct mufont_s *fontSystemMedium;
	struct mufont_s *fontSystemBig;

	qboolean backGround; // has to draw the ui background
} ui_local_t;

extern ui_local_t uis;

#define MENU_DEFAULT_WIDTH		640
#define MENU_DEFAULT_HEIGHT		480
#define UI_WIDTHSCALE ( (float)uis.vidWidth / (float)MENU_DEFAULT_WIDTH )
#define UI_HEIGHTSCALE ( (float)uis.vidHeight / (float)MENU_DEFAULT_HEIGHT )
#define UI_SCALED_WIDTH(w) ( (float)w * UI_WIDTHSCALE )
#define UI_SCALED_HEIGHT(h) ( (float)h * UI_HEIGHTSCALE )

extern struct mempool_s *uipool;

void UI_Error ( char *fmt, ... );
void UI_Printf ( char *fmt, ... );
void UI_FillRect ( int x, int y, int w, int h, vec4_t color );

#define UI_MemAlloc(pool,size) trap_Mem_Alloc(pool, size, __FILE__, __LINE__)
#define UI_MemFree(mem) trap_Mem_Free(mem, __FILE__, __LINE__)
#define UI_MemAllocPool(name) trap_Mem_AllocPool(name, __FILE__, __LINE__)
#define UI_MemFreePool(pool) trap_Mem_FreePool(pool, __FILE__, __LINE__)
#define UI_MemEmptyPool(pool) trap_Mem_EmptyPool(pool, __FILE__, __LINE__)

#define UI_Malloc(size) UI_MemAlloc(uipool,size)
#define UI_Free(data) UI_MemFree(data)

char *UI_CopyString( const char *in );

#define NUM_CURSOR_FRAMES 15

const char *Default_MenuKey( menuframework_s *m, int key );
const char *Default_MenuCharEvent( menuframework_s *m, int key );

extern char *menu_in_sound;
extern char *menu_move_sound;
extern char *menu_out_sound;

extern qboolean	m_entersound;

float M_ClampCvar( float min, float max, float value );

void M_PopMenu (void);
void M_PushMenu ( menuframework_s *m, void (*draw) (void), const char *(*key) (int k), const char *(*charevent) (int k) );
void M_ForceMenuOff (void);
void M_genericBackFunc( menucommon_t *menuitem );

void M_Menu_Main_f (void);
void M_AddToServerList (char *adr, char *info);
void M_ForceMenuOff (void);

void M_Menu_Failed_f( void );

int UI_API(void);
void UI_Init( int vidWidth, int vidHeight );
void UI_Shutdown( void );
void UI_Refresh( unsigned int time, int clientState, int serverState, qboolean backGround );
void UI_DrawConnectScreen( char *serverName, char *rejectmessage, char *downloadfilename, int connectCount, qboolean backGround );
void UI_Keydown( int key );
void UI_CharEvent( int key );
void UI_MouseMove( int dx, int dy );

// ui_playermodels.c
typedef struct
{
	int		nskins;
	char	**skinnames;
	char	directory[MAX_QPATH];
}playermodelinfo_s;
extern m_itemslisthead_t playermodelsItemsList;
extern byte_vec4_t playerColor;
void UI_ColorRedCallback( menucommon_t *menuitem );
void UI_ColorGreenCallback( menucommon_t *menuitem );
void UI_ColorBlueCallback( menucommon_t *menuitem );
void UI_Playermodel_Init( void );
void UI_FindIndexForModelAndSkin( char *model, char *skin, int *modelindex, int *skinindex );
void UI_DrawPlayerModel( char *model, char *skin, byte_vec4_t color, int xpos, int ypos, int width, int height );

