/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include <string.h>
#include "ui_local.h"

/*
=============================================================================

DEMOS MENU

=============================================================================
*/
void Demos_MenuInit( void );

static menuframework_s	s_mods_menu;



//=====================================================================
// Items list
//=====================================================================

static int MAX_MENU_LIST_ITEMS = 15;

m_itemslisthead_t modsItemsList;


//==================
//M_Mods_CreateFolderList
//==================
void M_Mods_CreateFolderList( void )
{
	char	*s, *cleanname;
	char	buffer[8*1024];
	int		numfolders;
	int		length;
	int		i;
	char	foldername[MAX_QPATH];

	if( (numfolders = FS_GetGamedirectoryList( buffer, sizeof(buffer) )) == 0 )
		return;

	s = buffer;
	length = 0;
	for ( i = 0; i < numfolders; i++, s += length+1 )
	{
		length = strlen( s );
		cleanname = s;
		if( cleanname[0] == '.' && cleanname[1] == '/' )
			cleanname++;
		while( *cleanname == '/' )
			cleanname++;
		Q_strncpyz( foldername, cleanname, sizeof(foldername) );
		// HACK (filter out browser and docs dirs included with the install)
		if( Q_stricmp("docs", foldername) && Q_stricmp("browser", foldername) )
			UI_AddItemToScrollList( &modsItemsList, foldername, NULL );
	}
}

//==================
//M_Mods_CreateItemList
//==================
void M_Mods_CreateItemList( void )
{
	// first free the current list
	UI_FreeScrollItemList( &modsItemsList );

	// get all the folders
	M_Mods_CreateFolderList();
}


//=====================================================================
// Buttons & actions
//=====================================================================
#define	NO_ITEM_STRING	""
static int	scrollbar_curvalue = 0;

//==================
//M_Mods_UpdateScrollbar
//==================
void M_Mods_UpdateScrollbar( menucommon_t *menuitem ) 
{
	scrollbar_curvalue = menuitem->curvalue;
	menuitem->maxvalue = max( 0, modsItemsList.numItems - MAX_MENU_LIST_ITEMS );
}

//==================
//M_Mods_LoadMod
//==================
void M_Mods_LoadMod( menucommon_t *menuitem ) 
{
	m_listitem_t *item;

	menuitem->localdata[1] = menuitem->localdata[0] + scrollbar_curvalue;
	item = UI_FindItemInScrollListWithId( &modsItemsList, menuitem->localdata[1] );
	if( item && item->name ) 
	{
		UI_Printf( "fs_game \"%s\"\n", item->name );
		trap_Cmd_ExecuteText( EXEC_APPEND, va("fs_game \"%s\"", item->name) );
	}
}

//==================
//M_Mods_DemoButton
//==================
void M_Mods_UpdateButton( menucommon_t *menuitem ) 
{
	m_listitem_t *item;

	menuitem->localdata[1] = menuitem->localdata[0] + scrollbar_curvalue;
	item = UI_FindItemInScrollListWithId( &modsItemsList, menuitem->localdata[1] );
	if( item ) {
		Q_snprintfz(menuitem->title, MAX_STRING_CHARS, item->name);
	} else
		Q_snprintfz(menuitem->title, MAX_STRING_CHARS, NO_ITEM_STRING);
}

//==================
//Mods_MenuInit
//==================
void Mods_MenuInit( void )
{

	menucommon_t *menuitem;
	int i;
	int y = 0;
	int yoffset;
	int scrollwindow_width, scrollwindow_height;

	yoffset = UI_SCALED_HEIGHT(56); // left space for the logo

	// scroll window width
	if( uis.vidWidth < 800 )
		scrollwindow_width = uis.vidWidth * 0.85;
	else if( uis.vidWidth < 1024 )
		scrollwindow_width = uis.vidWidth * 0.75;
	else
		scrollwindow_width = uis.vidWidth * 0.65;

	s_mods_menu.x = uis.vidWidth / 2;
	s_mods_menu.nitems = 0;

	// build the list folder and demos
	M_Mods_CreateItemList();

	// title
	menuitem = UI_InitMenuItem( "m_mods_title1", "MODS", 0, y+yoffset, MTYPE_SEPARATOR, ALIGN_CENTER_TOP, uis.fontSystemBig, NULL );
	Menu_AddItem( &s_mods_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	yoffset += trap_SCR_strHeight( menuitem->font );

	// scrollbar

	scrollwindow_height = uis.vidHeight - ( yoffset + ( 2 * trap_SCR_strHeight( uis.fontSystemBig ) ) );
	MAX_MENU_LIST_ITEMS = ( scrollwindow_height / trap_SCR_strHeight( uis.fontSystemSmall ) ) - 6; // 6 lines left for back button
	if( MAX_MENU_LIST_ITEMS < 5 ) MAX_MENU_LIST_ITEMS = 5;

	menuitem = UI_InitMenuItem( "m_mods_scrollbar", NULL, -((scrollwindow_width*0.5)+16), y+yoffset, MTYPE_SCROLLBAR, ALIGN_CENTER_TOP, uis.fontSystemSmall, M_Mods_UpdateScrollbar );
	UI_SetupScrollbar( menuitem, MAX_MENU_LIST_ITEMS-1, 0, 0, 0 );
	Menu_AddItem( &s_mods_menu, menuitem );
	
	// window buttons
	for( i = 0; i < MAX_MENU_LIST_ITEMS; i++ )
	{
		menuitem = UI_InitMenuItem( va("m_mods_button_%i", i), NO_ITEM_STRING, -(scrollwindow_width*0.5), y+yoffset, MTYPE_ACTION, ALIGN_LEFT_TOP, uis.fontSystemSmall, M_Mods_LoadMod );
		//menuitem->statusbar = "press ENTER to play demos/enter folder, BACKSPACE for previous folder";
		menuitem->ownerdraw = M_Mods_UpdateButton;
		menuitem->localdata[0] = i; // line in the window
		menuitem->localdata[1] = i;  // line in list
		menuitem->width = scrollwindow_width; // adjust strings to this width
		Menu_AddItem( &s_mods_menu, menuitem );

		// create an associated picture to the items to act as window background
		menuitem->pict.shader = uis.whiteShader;
		menuitem->pict.shaderHigh = uis.whiteShader;
		Vector4Copy( colorWhite, menuitem->pict.colorHigh );
		Vector4Copy( ( i & 1 )?colorDkGrey:colorMdGrey, menuitem->pict.color );
		menuitem->pict.color[3] = menuitem->pict.colorHigh[3] = 0.65f;
		menuitem->pict.yoffset = 0;
		menuitem->pict.xoffset = 0;
		menuitem->pict.width = scrollwindow_width;
		menuitem->pict.height = trap_SCR_strHeight( menuitem->font );

		yoffset += trap_SCR_strHeight( menuitem->font );
	}

	yoffset += trap_SCR_strHeight( menuitem->font );

	// back (to previous menu)
	menuitem = UI_InitMenuItem( "m_mods_back", "back", 0, y+yoffset, MTYPE_ACTION, ALIGN_CENTER_TOP, uis.fontSystemBig, M_genericBackFunc );
	Menu_AddItem( &s_mods_menu, menuitem );
	yoffset += trap_SCR_strHeight( menuitem->font );

	Menu_Center( &s_mods_menu );
	Menu_Init( &s_mods_menu );
}

void Mods_MenuDraw(void)
{
	Menu_Draw( &s_mods_menu );
}

const char *Mods_MenuKey( int key )
{
	menucommon_t *item;

	item = Menu_ItemAtCursor( &s_mods_menu );

	if ( key == K_ESCAPE || ( (key == K_MOUSE2) && (item->type != MTYPE_SPINCONTROL) &&
		(item->type != MTYPE_SLIDER)) )
	{
		UI_FreeScrollItemList( &modsItemsList );
	}
	
	return Default_MenuKey( &s_mods_menu, key );
}

const char *Mods_MenuCharEvent( int key )
{
	return Default_MenuCharEvent( &s_mods_menu, key );
}

void M_Menu_Mods_f( void )
{
	Mods_MenuInit();
	M_PushMenu( &s_mods_menu, Mods_MenuDraw, Mods_MenuKey, Mods_MenuCharEvent );
}
