/*
	File:		IVAD.h

	Contains:	xxx put contents here xxx

	Version:	xxx put version here xxx

	Copyright:	 1999 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				xxx put dri here xxx

		Other Contact:		xxx put other contact here xxx

		Technology:			xxx put technology here xxx

	Writers:

		(chp)	Craig Prouse

	Change History (most recent first):

	   <CS3>	  7/2/99	chp		Add specific IVAD control bits and user preferences template.
	   <CS2>	 6/27/99	chp		Support new EEPROM version mechanism.
	   <CS1>	 6/17/99	chp		first checked in
*/

#ifndef __IVAD__
#define __IVAD__

#include <libkern/OSTypes.h>


/*	
	IIC device addresses, subaddresses, and register constants
	
*/

enum {
	iicIVAD				=	0x8C,
	iicEEPROM			=	0xA6
};

enum {
	kIVAD1SupportedModes	= 3,
};

enum {
	kIVADContrast		=	0x00,
	kIVADDrive1			=	0x01,
	kIVADDrive2			=	0x02,
	kIVADDrive3			=	0x03,
	kIVADCutoff1		=	0x04,
	kIVADCutoff2		=	0x05,
	kIVADCutoff3		=	0x06,
	kIVADHPhase			=	0x07,
	kIVADVRamp			=	0x08,
	kIVADVPosition		=	0x09,
	kIVADSCorrection	=	0x0A,
	kIVADKeystone		=	0x0B,
	kIVADEWAmplitude	=	0x0C,
	kIVADHAmplitude		=	0x0D,
	kIVADSidePinBalance	=	0x0E,
	kIVADParallelogram	=	0x0F,
	kIVADVBLDCLevel		=	0x10,
	kIVADBrightness		=	0x11,
	kIVADTilt			=	0x12,
	kIVADPLL1			=	0x13,
	kNumIVADRegisters
};


enum {
	kVideoEnable		=	0x80,				// (R00)	master enable
	kGainWin			= 	0x40,				// (R10)	gain (brightness) boost
	kDegauss			=	0x80				// (R12)	degauss control
};


struct IVAD {
	UInt8				contrast;
	UInt8				drive1;
	UInt8				drive2;
	UInt8				drive3;
	UInt8				cutoff1;
	UInt8				cutoff2;
	UInt8				cutoff3;
	UInt8				hPhase;					// parameter a.k.a. horizontal position
	UInt8				vRamp;					// parameter a.k.a. vertical size
	UInt8				vPosition;
	UInt8				sCorrection;
	UInt8				keystone;				// parameter a.k.a. trapezoid
	UInt8				ewAmplitude;			// parameter a.k.a. pincushion
	UInt8				hAmplitude;				// parameter a.k.a. horizontal size
	UInt8				sidePinBalance;
	UInt8				parallelogram;
	UInt8				vblDCLevel;
	UInt8				brightness;
	UInt8				tilt;					// parameter a.k.a. rotation
	UInt8				pll1FVC;
};
typedef struct IVAD IVAD;


/*	
	EEPROM memory map template
	
*/

enum {
	kIVADStdTemplateID = 0x5A
};


struct ModalDisplayParams {
	UInt8				horizontalPosition;
	UInt8				horizontalSize;
	UInt8				verticalPosition;
	UInt8				verticalSize;
	UInt8				keystone;
	UInt8				pincushion;
};
typedef struct ModalDisplayParams ModalDisplayParams;


struct IVAD1_AmodalDisplayParams {
	UInt8				contrast;
	UInt8				brightness;
	UInt8				drive1;
	UInt8				drive2;
	UInt8				drive3;
	UInt8				cutoff1;
	UInt8				cutoff2;
	UInt8				cutoff3;
	UInt8				sCorrection;
	UInt8				sidePinBalance;
	UInt8				parallelogram;
	UInt8				tilt;
	UInt8				vblDCLevel;
	UInt8				pll1FVC;
};
typedef struct IVAD1_AmodalDisplayParams IVAD1_AmodalDisplayParams;


struct BriteScreenParams {
	UInt8				contrast;
	UInt8				brightness;
	UInt8				drive1;
	UInt8				drive2;
	UInt8				drive3;
	UInt8				cutoff1;
	UInt8				cutoff2;
	UInt8				cutoff3;
	Boolean				gainBoost;
};
typedef struct BriteScreenParams BriteScreenParams;


struct AdjustmentRange {
	UInt8				min;
	UInt8				max;
};
typedef struct AdjustmentRange AdjustmentRange;

struct AdjustmentLimits {
	AdjustmentRange		contrast;
	AdjustmentRange		brightness;
	AdjustmentRange		horizontalPosition;
	AdjustmentRange		horizontalSize;
	AdjustmentRange		verticalPosition;
	AdjustmentRange		verticalSize;
	AdjustmentRange		keystone;
	AdjustmentRange		pincushion;
	AdjustmentRange		parallelogram;
	AdjustmentRange		tilt;
};
typedef struct AdjustmentLimits AdjustmentLimits;


struct IVAD1_EEPROM {
	ModalDisplayParams					modeParams[ kIVAD1SupportedModes ];
	AdjustmentLimits					userLimits;
	IVAD1_AmodalDisplayParams			stdParams;
	BriteScreenParams					briteParams;
	UInt8								id;
};
typedef struct IVAD1_EEPROM IVAD1_EEPROM;



/*	
	IVAD user preferences template (for persistent NameRegistry property)
	
*/

struct IVAD1UserPrefs {
	ModalDisplayParams		modeParams[ kIVAD1SupportedModes ];
	UInt8					contrast;
	UInt8					brightness;
	UInt8					parallelogram;
	UInt8					tilt;
};
typedef struct IVAD1UserPrefs IVAD1UserPrefs;


#endif /* __IVAD__ */
