/*
	File:		IVAD.h

	Contains:	xxx put contents here xxx

	Version:	xxx put version here xxx

	Copyright:	 1999 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				xxx put dri here xxx

		Other Contact:		xxx put other contact here xxx

		Technology:			xxx put technology here xxx

	Writers:

		(chp)	Craig Prouse

	Change History (most recent first):

	   <CS3>	  7/2/99	chp		Add specific IVAD control bits and user preferences template.
	   <CS2>	 6/27/99	chp		Support new EEPROM version mechanism.
	   <CS1>	 6/17/99	chp		first checked in
*/

#ifndef __IVAD__
#define __IVAD__

#include <libkern/OSTypes.h>


/*	
	IIC device addresses, subaddresses, and register constants
	
*/

enum {
	iicIVAD				=	0x8C,
	iicEEPROM			=	0xA6
};


enum {
	kIVADContrast		=	0x00,
	kIVADDrive1			=	0x01,
	kIVADDrive2			=	0x02,
	kIVADDrive3			=	0x03,
	kIVADCutoff1		=	0x04,
	kIVADCutoff2		=	0x05,
	kIVADCutoff3		=	0x06,
	kIVADHPhase			=	0x07,
	kIVADVRamp			=	0x08,
	kIVADVPosition		=	0x09,
	kIVADSCorrection	=	0x0A,
	kIVADKeystone		=	0x0B,
	kIVADEWAmplitude	=	0x0C,
	kIVADHAmplitude		=	0x0D,
	kIVADSidePinBalance	=	0x0E,
	kIVADParallelogram	=	0x0F,
	kIVADVBLDCLevel		=	0x10,
	kIVADBrightness		=	0x11,
	kIVADTilt			=	0x12,
	kIVADPLL1			=	0x13,
	kNumIVADRegisters
};


enum {
	kVideoEnable		=	0x80,				// (R00)	master enable
	kGainWin			= 	0x40,				// (R10)	gain (brightness) boost
	kDegauss			=	0x80				// (R12)	degauss control
};


struct IVAD {
	unsigned char		contrast;
	unsigned char		drive1;
	unsigned char		drive2;
	unsigned char		drive3;
	unsigned char		cutoff1;
	unsigned char		cutoff2;
	unsigned char		cutoff3;
	unsigned char		hPhase;					// parameter a.k.a. horizontal position
	unsigned char		vRamp;					// parameter a.k.a. vertical size
	unsigned char		vPosition;
	unsigned char		sCorrection;
	unsigned char		keystone;				// parameter a.k.a. trapezoid
	unsigned char		ewAmplitude;			// parameter a.k.a. pincushion
	unsigned char		hAmplitude;				// parameter a.k.a. horizontal size
	unsigned char		sidePinBalance;
	unsigned char		parallelogram;
	unsigned char		vblDCLevel;
	unsigned char		brightness;
	unsigned char		tilt;					// parameter a.k.a. rotation
	unsigned char		pll1FVC;
};
typedef struct IVAD IVAD;


/*	
	EEPROM memory map template
	
*/

enum {
	kIVADStdTemplateID = 0x5A
};


struct ModalDisplayParams {
	unsigned char		horizontalPosition;
	unsigned char		horizontalSize;
	unsigned char		verticalPosition;
	unsigned char		verticalSize;
	unsigned char		keystone;
	unsigned char		pincushion;
};
typedef struct ModalDisplayParams ModalDisplayParams;

struct AmodalDisplayParams {
	unsigned char		contrast;
	unsigned char		brightness;
	unsigned char		drive1;
	unsigned char		drive2;
	unsigned char		drive3;
	unsigned char		cutoff1;
	unsigned char		cutoff2;
	unsigned char		cutoff3;
	unsigned char		sCorrection;
	unsigned char		sidePinBalance;
	unsigned char		parallelogram;
	unsigned char		tilt;
	unsigned char		vblDCLevel;
	unsigned char		pll1FVC;
};
typedef struct AmodalDisplayParams AmodalDisplayParams;

struct BriteScreenParams {
	unsigned char		contrast;
	unsigned char		brightness;
	unsigned char		drive1;
	unsigned char		drive2;
	unsigned char		drive3;
	unsigned char		cutoff1;
	unsigned char		cutoff2;
	unsigned char		cutoff3;
	Boolean				gainBoost;
};
typedef struct BriteScreenParams BriteScreenParams;


struct AdjustmentRange {
	unsigned char		min;
	unsigned char		max;
};
typedef struct AdjustmentRange AdjustmentRange;

struct AdjustmentLimits {
	AdjustmentRange		contrast;
	AdjustmentRange		brightness;
	AdjustmentRange		horizontalPosition;
	AdjustmentRange		horizontalSize;
	AdjustmentRange		verticalPosition;
	AdjustmentRange		verticalSize;
	AdjustmentRange		keystone;
	AdjustmentRange		pincushion;
	AdjustmentRange		parallelogram;
	AdjustmentRange		tilt;
};
typedef struct AdjustmentLimits AdjustmentLimits;


struct EEPROM {
	ModalDisplayParams	modeParams [3];
	AdjustmentLimits	userLimits;
	AmodalDisplayParams	stdParams;
	BriteScreenParams	briteParams;
	unsigned char		id;
};
typedef struct EEPROM EEPROM;


/*	
	IVAD user preferences template (for persistent NameRegistry property)
	
*/

struct IVADUserPrefs {
	ModalDisplayParams	modeParams [3];
	unsigned char		contrast;
	unsigned char		brightness;
	unsigned char		parallelogram;
	unsigned char		tilt;
};
typedef struct IVADUserPrefs IVADUserPrefs;


#endif /* __IVAD__ */
