/*
 *  AppleTexasEQPrefs.cpp
 *  AppleOnboardAudio
 *
 *  Created by mcookson on Mon Jul 16 2001.
 *  Copyright (c) 2001 Apple Computer, Inc. All rights reserved.
 *
 */
#ifndef __TEXAS_EQ_PREFS__
#define __TEXAS_EQ_PREFS__
 

#include "texas_hw.h"

EQPrefs         theEQPrefs = 
{
    0x00000001,                         // structVersionNumber
    0x72617720,                         // genreType = 'raw '
    0x00000006,                         // eqCount
    0x00000000,                         // nameID
    {                                   // eq
        {                               // ----------     Equalization Set #1     ----------
            /*44100.0*/ 44100,          // filterSampleRate
            /*3.0*/ 3,                  // drcCompressionRatioNumerator
            /*1.0*/ 1,                  // drcCompressionRatioDenominator
            /*-15.3*/   -15330,         // drcThreshold
            /*5.090000*/    10,         // drcMaximumVolume
            0x00000001,                 // drcEnable    = ENABLED
            0x0000000E,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000001,                 // speakerID    = External Ball
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xE1, 0x43 }, { 0xE0, 0x52, 0x04 }, { 0x0F, 0xCC, 0xC5 }, { 0xE0, 0x52, 0x66 }, { 0x0F, 0xAE, 0x6B }}},
                {{{ 0x10, 0x23, 0x83 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xA3, 0x25 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xC6, 0xA8 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x54, 0x4D }, { 0xE3, 0x59, 0x71 }, { 0x0D, 0x8F, 0x3A }, { 0xE3, 0x59, 0x71 }, { 0x0C, 0xE3, 0x88 }}},
                {{{ 0x13, 0xE1, 0xD3 }, { 0xF3, 0xEC, 0xB5 }, { 0x04, 0x22, 0x27 }, { 0xF3, 0xEC, 0xB5 }, { 0x08, 0x03, 0xFA }}},
                {{{ 0x0A, 0xC1, 0x19 }, { 0x03, 0x41, 0x81 }, { 0x07, 0x8A, 0xB1 }, { 0x03, 0x41, 0x81 }, { 0x02, 0x4B, 0xCA }}},
                {{{ 0x0F, 0xE1, 0x43 }, { 0xE0, 0x52, 0x04 }, { 0x0F, 0xCC, 0xC5 }, { 0xE0, 0x52, 0x66 }, { 0x0F, 0xAE, 0x6B }}},
                {{{ 0x10, 0x23, 0x83 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xA3, 0x25 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xC6, 0xA8 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x54, 0x4D }, { 0xE3, 0x59, 0x71 }, { 0x0D, 0x8F, 0x3A }, { 0xE3, 0x59, 0x71 }, { 0x0C, 0xE3, 0x88 }}},
                {{{ 0x13, 0xE1, 0xD3 }, { 0xF3, 0xEC, 0xB5 }, { 0x04, 0x22, 0x27 }, { 0xF3, 0xEC, 0xB5 }, { 0x08, 0x03, 0xFA }}},
                {{{ 0x0A, 0xC1, 0x19 }, { 0x03, 0x41, 0x81 }, { 0x07, 0x8A, 0xB1 }, { 0x03, 0x41, 0x81 }, { 0x02, 0x4B, 0xCA }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #2     ----------
            /*44100.0*/ 44100,          // filterSampleRate
            /*3.0*/ 3,                  // drcCompressionRatioNumerator
            /*1.0*/ 1,                  // drcCompressionRatioDenominator
            /*-12.5*/   -12460,         // drcThreshold
            /*4.550000*/    9,          // drcMaximumVolume
            0x00000001,                 // drcEnable    = ENABLED
            0x00000010,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x4A, 0x12 }, { 0xE1, 0x6B, 0xDA }, { 0x0F, 0x4A, 0x12 }, { 0xE1, 0x73, 0xF0 }, { 0x0E, 0x9C, 0x3A }}},
                {{{ 0x02, 0xDD, 0x54 }, { 0x05, 0xBA, 0xA8 }, { 0x02, 0xDD, 0x54 }, { 0xF8, 0x00, 0x1D }, { 0x03, 0x75, 0x32 }}},
                {{{ 0x0E, 0x2F, 0xC7 }, { 0xE4, 0xD5, 0xDC }, { 0x0D, 0x74, 0x77 }, { 0xE4, 0xD5, 0xDC }, { 0x0B, 0xA4, 0x3F }}},
                {{{ 0x0E, 0x78, 0x99 }, { 0xE6, 0x7C, 0xCA }, { 0x0D, 0x0E, 0x93 }, { 0xE6, 0x7C, 0xCA }, { 0x0B, 0x87, 0x2D }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x0F, 0x4A, 0x12 }, { 0xE1, 0x6B, 0xDA }, { 0x0F, 0x4A, 0x12 }, { 0xE1, 0x73, 0xF0 }, { 0x0E, 0x9C, 0x3A }}},
                {{{ 0x02, 0xDD, 0x54 }, { 0x05, 0xBA, 0xA8 }, { 0x02, 0xDD, 0x54 }, { 0xF8, 0x00, 0x1D }, { 0x03, 0x75, 0x32 }}},
                {{{ 0x0E, 0x2F, 0xC7 }, { 0xE4, 0xD5, 0xDC }, { 0x0D, 0x74, 0x77 }, { 0xE4, 0xD5, 0xDC }, { 0x0B, 0xA4, 0x3F }}},
                {{{ 0x0E, 0x78, 0x99 }, { 0xE6, 0x7C, 0xCA }, { 0x0D, 0x0E, 0x93 }, { 0xE6, 0x7C, 0xCA }, { 0x0B, 0x87, 0x2D }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #3     ----------
            /*44100.0*/ 44100,          // filterSampleRate
            /*3.0*/ 3,                  // drcCompressionRatioNumerator
            /*1.0*/ 1,                  // drcCompressionRatioDenominator
            /*-15.3*/   -15330,         // drcThreshold
            /*5.090000*/    10,         // drcMaximumVolume
            0x00000001,                 // drcEnable    = ENABLED
            0x00000015,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000001,                 // speakerID    = External Ball
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xE1, 0x43 }, { 0xE0, 0x52, 0x04 }, { 0x0F, 0xCC, 0xC5 }, { 0xE0, 0x52, 0x66 }, { 0x0F, 0xAE, 0x6B }}},
                {{{ 0x10, 0x23, 0x83 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xA3, 0x25 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xC6, 0xA8 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x54, 0x4D }, { 0xE3, 0x59, 0x71 }, { 0x0D, 0x8F, 0x3A }, { 0xE3, 0x59, 0x71 }, { 0x0C, 0xE3, 0x88 }}},
                {{{ 0x13, 0xE1, 0xD3 }, { 0xF3, 0xEC, 0xB5 }, { 0x04, 0x22, 0x27 }, { 0xF3, 0xEC, 0xB5 }, { 0x08, 0x03, 0xFA }}},
                {{{ 0x0A, 0xC1, 0x19 }, { 0x03, 0x41, 0x81 }, { 0x07, 0x8A, 0xB1 }, { 0x03, 0x41, 0x81 }, { 0x02, 0x4B, 0xCA }}},
                {{{ 0x0F, 0xE1, 0x43 }, { 0xE0, 0x52, 0x04 }, { 0x0F, 0xCC, 0xC5 }, { 0xE0, 0x52, 0x66 }, { 0x0F, 0xAE, 0x6B }}},
                {{{ 0x10, 0x23, 0x83 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xA3, 0x25 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xC6, 0xA8 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x54, 0x4D }, { 0xE3, 0x59, 0x71 }, { 0x0D, 0x8F, 0x3A }, { 0xE3, 0x59, 0x71 }, { 0x0C, 0xE3, 0x88 }}},
                {{{ 0x13, 0xE1, 0xD3 }, { 0xF3, 0xEC, 0xB5 }, { 0x04, 0x22, 0x27 }, { 0xF3, 0xEC, 0xB5 }, { 0x08, 0x03, 0xFA }}},
                {{{ 0x0A, 0xC1, 0x19 }, { 0x03, 0x41, 0x81 }, { 0x07, 0x8A, 0xB1 }, { 0x03, 0x41, 0x81 }, { 0x02, 0x4B, 0xCA }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #4     ----------
            /*44100.0*/ 44100,          // filterSampleRate
            /*3.0*/ 3,                  // drcCompressionRatioNumerator
            /*1.0*/ 1,                  // drcCompressionRatioDenominator
            /*0.0*/ 0,          // drcThreshold
            /*-1.680000*/   -3,         // drcMaximumVolume
            0x00000001,                 // drcEnable    = ENABLED
            0x00000015,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xAD, 0x08 }, { 0xE0, 0xA5, 0xEF }, { 0x0F, 0xAD, 0x08 }, { 0xE0, 0xA7, 0x9D }, { 0x0F, 0x5B, 0xBE }}},
                {{{ 0x04, 0xB3, 0x8D }, { 0x09, 0x67, 0x1B }, { 0x04, 0xB3, 0x8D }, { 0x00, 0x0F, 0x71 }, { 0x02, 0xBE, 0xC5 }}},
                {{{ 0x0F, 0xDD, 0x32 }, { 0xE0, 0xA5, 0x6F }, { 0x0F, 0x8A, 0x69 }, { 0xE0, 0xA5, 0x6F }, { 0x0F, 0x67, 0x9C }}},
                {{{ 0x0F, 0xD2, 0x84 }, { 0xE1, 0x35, 0xFB }, { 0x0F, 0x21, 0x61 }, { 0xE1, 0x35, 0xFB }, { 0x0E, 0xF3, 0xE5 }}},
                {{{ 0x0E, 0x81, 0xB1 }, { 0xE6, 0x28, 0x3F }, { 0x0C, 0xE4, 0x9D }, { 0xE6, 0x28, 0x3F }, { 0x0B, 0x66, 0x4F }}},
                {{{ 0x0F, 0x2D, 0x62 }, { 0xE9, 0x87, 0x97 }, { 0x0D, 0x1E, 0x19 }, { 0xE9, 0x87, 0x97 }, { 0x0C, 0x4B, 0x7B }}},
                {{{ 0x0F, 0xAD, 0x08 }, { 0xE0, 0xA5, 0xEF }, { 0x0F, 0xAD, 0x08 }, { 0xE0, 0xA7, 0x9D }, { 0x0F, 0x5B, 0xBE }}},
                {{{ 0x04, 0xB3, 0x8D }, { 0x09, 0x67, 0x1B }, { 0x04, 0xB3, 0x8D }, { 0x00, 0x0F, 0x71 }, { 0x02, 0xBE, 0xC5 }}},
                {{{ 0x0F, 0xDD, 0x32 }, { 0xE0, 0xA5, 0x6F }, { 0x0F, 0x8A, 0x69 }, { 0xE0, 0xA5, 0x6F }, { 0x0F, 0x67, 0x9C }}},
                {{{ 0x0F, 0xD2, 0x84 }, { 0xE1, 0x35, 0xFB }, { 0x0F, 0x21, 0x61 }, { 0xE1, 0x35, 0xFB }, { 0x0E, 0xF3, 0xE5 }}},
                {{{ 0x0E, 0x81, 0xB1 }, { 0xE6, 0x28, 0x3F }, { 0x0C, 0xE4, 0x9D }, { 0xE6, 0x28, 0x3F }, { 0x0B, 0x66, 0x4F }}},
                {{{ 0x0F, 0x2D, 0x62 }, { 0xE9, 0x87, 0x97 }, { 0x0D, 0x1E, 0x19 }, { 0xE9, 0x87, 0x97 }, { 0x0C, 0x4B, 0x7B }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #5     ----------
            /*44100.0*/ 44100,          // filterSampleRate
            /*3.0*/ 3,                  // drcCompressionRatioNumerator
            /*1.0*/ 1,                  // drcCompressionRatioDenominator
            /*-15.3*/   -15330,         // drcThreshold
            /*5.090000*/    10,         // drcMaximumVolume
            0x00000001,                 // drcEnable    = ENABLED
            0x0000000F,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000001,                 // speakerID    = External Ball
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xE1, 0x43 }, { 0xE0, 0x52, 0x04 }, { 0x0F, 0xCC, 0xC5 }, { 0xE0, 0x52, 0x66 }, { 0x0F, 0xAE, 0x6B }}},
                {{{ 0x10, 0x23, 0x83 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xA3, 0x25 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xC6, 0xA8 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x54, 0x4D }, { 0xE3, 0x59, 0x71 }, { 0x0D, 0x8F, 0x3A }, { 0xE3, 0x59, 0x71 }, { 0x0C, 0xE3, 0x88 }}},
                {{{ 0x13, 0xE1, 0xD3 }, { 0xF3, 0xEC, 0xB5 }, { 0x04, 0x22, 0x27 }, { 0xF3, 0xEC, 0xB5 }, { 0x08, 0x03, 0xFA }}},
                {{{ 0x0A, 0xC1, 0x19 }, { 0x03, 0x41, 0x81 }, { 0x07, 0x8A, 0xB1 }, { 0x03, 0x41, 0x81 }, { 0x02, 0x4B, 0xCA }}},
                {{{ 0x0F, 0xE1, 0x43 }, { 0xE0, 0x52, 0x04 }, { 0x0F, 0xCC, 0xC5 }, { 0xE0, 0x52, 0x66 }, { 0x0F, 0xAE, 0x6B }}},
                {{{ 0x10, 0x23, 0x83 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xA3, 0x25 }, { 0xE0, 0x3A, 0x03 }, { 0x0F, 0xC6, 0xA8 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x54, 0x4D }, { 0xE3, 0x59, 0x71 }, { 0x0D, 0x8F, 0x3A }, { 0xE3, 0x59, 0x71 }, { 0x0C, 0xE3, 0x88 }}},
                {{{ 0x13, 0xE1, 0xD3 }, { 0xF3, 0xEC, 0xB5 }, { 0x04, 0x22, 0x27 }, { 0xF3, 0xEC, 0xB5 }, { 0x08, 0x03, 0xFA }}},
                {{{ 0x0A, 0xC1, 0x19 }, { 0x03, 0x41, 0x81 }, { 0x07, 0x8A, 0xB1 }, { 0x03, 0x41, 0x81 }, { 0x02, 0x4B, 0xCA }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #6     ----------
            /*44100.0*/ 44100,          // filterSampleRate
            /*3.0*/ 3,                  // drcCompressionRatioNumerator
            /*1.0*/ 1,                  // drcCompressionRatioDenominator
            /*-12.0*/   -11980,         // drcThreshold
            /*6.960000*/    13,         // drcMaximumVolume
            0x00000001,                 // drcEnable    = ENABLED
            0x00000012,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x4A, 0x37 }, { 0xE1, 0x6B, 0x90 }, { 0x0F, 0x4A, 0x37 }, { 0xE1, 0x73, 0xA2 }, { 0x0E, 0x9C, 0x82 }}},
                {{{ 0x03, 0xA5, 0xBE }, { 0x07, 0x4B, 0x7D }, { 0x03, 0xA5, 0xBE }, { 0xFB, 0xA2, 0x2A }, { 0x02, 0xF4, 0xD1 }}},
                {{{ 0x0F, 0xDB, 0xF2 }, { 0xE3, 0x48, 0x4D }, { 0x0E, 0x77, 0x78 }, { 0xE3, 0x48, 0x4D }, { 0x0E, 0x53, 0x6B }}},
                {{{ 0x0F, 0xB0, 0x5C }, { 0xE1, 0x2B, 0xE6 }, { 0x0F, 0x58, 0xC4 }, { 0xE1, 0x2B, 0xE6 }, { 0x0F, 0x09, 0x21 }}},
                {{{ 0x0E, 0x9A, 0xE9 }, { 0xE3, 0xBC, 0x0B }, { 0x0E, 0x12, 0x8C }, { 0xE3, 0xBC, 0x0B }, { 0x0C, 0xAD, 0x76 }}},
                {{{ 0x0E, 0xEA, 0xD6 }, { 0xFC, 0x28, 0xEC }, { 0x09, 0xDE, 0x62 }, { 0xFC, 0x28, 0xEC }, { 0x08, 0xC9, 0x38 }}},
                {{{ 0x0F, 0x4A, 0x37 }, { 0xE1, 0x6B, 0x90 }, { 0x0F, 0x4A, 0x37 }, { 0xE1, 0x73, 0xA2 }, { 0x0E, 0x9C, 0x82 }}},
                {{{ 0x03, 0xA5, 0xBE }, { 0x07, 0x4B, 0x7D }, { 0x03, 0xA5, 0xBE }, { 0xFB, 0xA2, 0x2A }, { 0x02, 0xF4, 0xD1 }}},
                {{{ 0x0F, 0xDB, 0xF2 }, { 0xE3, 0x48, 0x4D }, { 0x0E, 0x77, 0x78 }, { 0xE3, 0x48, 0x4D }, { 0x0E, 0x53, 0x6B }}},
                {{{ 0x0F, 0xB0, 0x5C }, { 0xE1, 0x2B, 0xE6 }, { 0x0F, 0x58, 0xC4 }, { 0xE1, 0x2B, 0xE6 }, { 0x0F, 0x09, 0x21 }}},
                {{{ 0x0E, 0x9A, 0xE9 }, { 0xE3, 0xBC, 0x0B }, { 0x0E, 0x12, 0x8C }, { 0xE3, 0xBC, 0x0B }, { 0x0C, 0xAD, 0x76 }}},
                {{{ 0x0E, 0xEA, 0xD6 }, { 0xFC, 0x28, 0xEC }, { 0x09, 0xDE, 0x62 }, { 0xFC, 0x28, 0xEC }, { 0x08, 0xC9, 0x38 }}}
            }                           // end of filter set
        }
    }
};

#endif