/*
 *  AppleTexas2EQPrefs.cpp
 *  AppleOnboardAudio
 *
 *  Created by mcookson on Mon Jul 16 2001.
 *  Copyright (c) 2001 Apple Computer, Inc. All rights reserved.
 *
 */
#ifndef __TEXAS2_EQ_PREFS__
#define __TEXAS2_EQ_PREFS__
 

#include "Texas2_hw.h"

EQPrefs         theEQPrefs = 
{
    0x00000001,                         // structVersionNumber
    0x72617720,                         // genreType = 'raw '
    0x00000004,                         // eqCount
    0x00000000,                         // nameID
    {                                   // eq
        {                               // ----------     Equalization Set #1     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -10.8  */  -10750,     // drcThreshold     (X1000)
            /*     2.2  */       4,     // drcMaximumVolume (X2)
            0x00000000,                 // drcEnable    = ENABLED
            0x0000001A,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xB8, 0xFD }, { 0xE0, 0x8E, 0x04 }, { 0x0F, 0xB8, 0xFD }, { 0xE0, 0x8F, 0x40 }, { 0x0F, 0x73, 0x36 }}},
                {{{ 0x06, 0x37, 0x1D }, { 0x0C, 0x6E, 0x3A }, { 0x06, 0x37, 0x1D }, { 0x05, 0xBF, 0xD3 }, { 0x03, 0x1C, 0xA2 }}},
                {{{ 0x0F, 0xA1, 0xC0 }, { 0xE1, 0x86, 0x92 }, { 0x0F, 0x03, 0x0E }, { 0xE1, 0x86, 0x92 }, { 0x0E, 0xA4, 0xCE }}},
                {{{ 0x0F, 0xE4, 0x95 }, { 0xE1, 0x7E, 0xFF }, { 0x0F, 0x04, 0x52 }, { 0xE1, 0x7E, 0xFF }, { 0x0E, 0xE8, 0xE7 }}},
                {{{ 0x10, 0x08, 0x57 }, { 0xE7, 0xE7, 0x1C }, { 0x0E, 0x95, 0x99 }, { 0xE7, 0xE7, 0x1C }, { 0x0E, 0x9D, 0xF1 }}},
                {{{ 0x0F, 0xB2, 0x6E }, { 0x06, 0xA8, 0x2C }, { 0x0D, 0xB2, 0xB4 }, { 0x06, 0xA8, 0x2C }, { 0x0D, 0x65, 0x22 }}},
                {{{ 0x11, 0x41, 0x9D }, { 0xF0, 0x6C, 0xBF }, { 0x0A, 0x4F, 0x6E }, { 0xF0, 0x6C, 0xBF }, { 0x0B, 0x91, 0x0C }}},
                {{{ 0x0F, 0xB8, 0xFD }, { 0xE0, 0x8E, 0x04 }, { 0x0F, 0xB8, 0xFD }, { 0xE0, 0x8F, 0x40 }, { 0x0F, 0x73, 0x36 }}},
                {{{ 0x06, 0x37, 0x1D }, { 0x0C, 0x6E, 0x3A }, { 0x06, 0x37, 0x1D }, { 0x05, 0xBF, 0xD3 }, { 0x03, 0x1C, 0xA2 }}},
                {{{ 0x0F, 0xA1, 0xC0 }, { 0xE1, 0x86, 0x92 }, { 0x0F, 0x03, 0x0E }, { 0xE1, 0x86, 0x92 }, { 0x0E, 0xA4, 0xCE }}},
                {{{ 0x0F, 0xE4, 0x95 }, { 0xE1, 0x7E, 0xFF }, { 0x0F, 0x04, 0x52 }, { 0xE1, 0x7E, 0xFF }, { 0x0E, 0xE8, 0xE7 }}},
                {{{ 0x10, 0x08, 0x57 }, { 0xE7, 0xE7, 0x1C }, { 0x0E, 0x95, 0x99 }, { 0xE7, 0xE7, 0x1C }, { 0x0E, 0x9D, 0xF1 }}},
                {{{ 0x0F, 0xB2, 0x6E }, { 0x06, 0xA8, 0x2C }, { 0x0D, 0xB2, 0xB4 }, { 0x06, 0xA8, 0x2C }, { 0x0D, 0x65, 0x22 }}},
                {{{ 0x11, 0x41, 0x9D }, { 0xF0, 0x6C, 0xBF }, { 0x0A, 0x4F, 0x6E }, { 0xF0, 0x6C, 0xBF }, { 0x0B, 0x91, 0x0C }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #2     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -19.1  */  -19120,     // drcThreshold     (X1000)
            /*     4.1  */       8,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000017,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xD0, 0xD4 }, { 0xE0, 0x5E, 0x56 }, { 0x0F, 0xD0, 0xD4 }, { 0xE0, 0x5E, 0xE1 }, { 0x0F, 0xA2, 0x34 }}},
                {{{ 0x09, 0x10, 0xD7 }, { 0x08, 0x8E, 0x1A }, { 0x03, 0x06, 0x51 }, { 0x01, 0xDC, 0xB1 }, { 0x02, 0xC8, 0x92 }}},
                {{{ 0x0F, 0xF8, 0x95 }, { 0xE0, 0x97, 0x0B }, { 0x0F, 0x7F, 0x00 }, { 0xE0, 0x97, 0x0B }, { 0x0F, 0x77, 0x95 }}},
                {{{ 0x0F, 0xD1, 0xC4 }, { 0xE1, 0xAC, 0x22 }, { 0x0E, 0xC8, 0xCF }, { 0xE1, 0xAC, 0x22 }, { 0x0E, 0x9A, 0x94 }}},
                {{{ 0x0F, 0x7C, 0x1C }, { 0xE3, 0xCC, 0x03 }, { 0x0D, 0xF7, 0x86 }, { 0xE3, 0xCC, 0x03 }, { 0x0D, 0x73, 0xA2 }}},
                {{{ 0x11, 0xFB, 0x92 }, { 0xF5, 0xA1, 0xA0 }, { 0x07, 0x3C, 0xD2 }, { 0xF5, 0xA1, 0xA0 }, { 0x09, 0x38, 0x65 }}},
                {{{ 0x0E, 0x17, 0xA9 }, { 0x06, 0x8B, 0x6C }, { 0x08, 0xA0, 0xE5 }, { 0x06, 0x8B, 0x6C }, { 0x06, 0xB8, 0x8E }}},
                {{{ 0x0F, 0xD0, 0xD4 }, { 0xE0, 0x5E, 0x56 }, { 0x0F, 0xD0, 0xD4 }, { 0xE0, 0x5E, 0xE1 }, { 0x0F, 0xA2, 0x34 }}},
                {{{ 0x09, 0x10, 0xD7 }, { 0x08, 0x8E, 0x1A }, { 0x03, 0x06, 0x51 }, { 0x01, 0xDC, 0xB1 }, { 0x02, 0xC8, 0x92 }}},
                {{{ 0x0F, 0xF8, 0x95 }, { 0xE0, 0x97, 0x0B }, { 0x0F, 0x7F, 0x00 }, { 0xE0, 0x97, 0x0B }, { 0x0F, 0x77, 0x95 }}},
                {{{ 0x0F, 0xD1, 0xC4 }, { 0xE1, 0xAC, 0x22 }, { 0x0E, 0xC8, 0xCF }, { 0xE1, 0xAC, 0x22 }, { 0x0E, 0x9A, 0x94 }}},
                {{{ 0x0F, 0x7C, 0x1C }, { 0xE3, 0xCC, 0x03 }, { 0x0D, 0xF7, 0x86 }, { 0xE3, 0xCC, 0x03 }, { 0x0D, 0x73, 0xA2 }}},
                {{{ 0x11, 0xFB, 0x92 }, { 0xF5, 0xA1, 0xA0 }, { 0x07, 0x3C, 0xD2 }, { 0xF5, 0xA1, 0xA0 }, { 0x09, 0x38, 0x65 }}},
                {{{ 0x0E, 0x17, 0xA9 }, { 0x06, 0x8B, 0x6C }, { 0x08, 0xA0, 0xE5 }, { 0x06, 0x8B, 0x6C }, { 0x06, 0xB8, 0x8E }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #3     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -13.1  */  -13140,     // drcThreshold     (X1000)
            /*     4.5  */       9,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000018,                 // layoutID     = 
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x55, 0x14 }, { 0xE1, 0x55, 0xD7 }, { 0x0F, 0x55, 0x14 }, { 0xE1, 0x5C, 0xFA }, { 0x0E, 0xB1, 0x4B }}},
                {{{ 0x06, 0xEC, 0x33 }, { 0x02, 0xAB, 0xE3 }, { 0x01, 0x5E, 0xEF }, { 0xF7, 0x64, 0xD9 }, { 0x03, 0x92, 0x2D }}},
                {{{ 0x0E, 0xF5, 0xF2 }, { 0xE6, 0x7D, 0x1F }, { 0x0B, 0xCF, 0x37 }, { 0xE6, 0x7D, 0x1F }, { 0x0A, 0xC5, 0x29 }}},
                {{{ 0x0D, 0xB0, 0x50 }, { 0xE5, 0xBE, 0x4D }, { 0x0D, 0x0C, 0x78 }, { 0xE5, 0xBE, 0x4D }, { 0x0A, 0xBC, 0xC8 }}},
                {{{ 0x0F, 0x12, 0x98 }, { 0xE6, 0x4E, 0xC6 }, { 0x0C, 0xC0, 0x3E }, { 0xE6, 0x4E, 0xC6 }, { 0x0B, 0xD2, 0xD7 }}},
                {{{ 0x0C, 0x64, 0x1A }, { 0x06, 0x53, 0x7A }, { 0x08, 0xD1, 0x55 }, { 0x06, 0x53, 0x7A }, { 0x05, 0x35, 0x70 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x0F, 0x55, 0x14 }, { 0xE1, 0x55, 0xD7 }, { 0x0F, 0x55, 0x14 }, { 0xE1, 0x5C, 0xFA }, { 0x0E, 0xB1, 0x4B }}},
                {{{ 0x06, 0xEC, 0x33 }, { 0x02, 0xAB, 0xE3 }, { 0x01, 0x5E, 0xEF }, { 0xF7, 0x64, 0xD9 }, { 0x03, 0x92, 0x2D }}},
                {{{ 0x0E, 0xF5, 0xF2 }, { 0xE6, 0x7D, 0x1F }, { 0x0B, 0xCF, 0x37 }, { 0xE6, 0x7D, 0x1F }, { 0x0A, 0xC5, 0x29 }}},
                {{{ 0x0D, 0xB0, 0x50 }, { 0xE5, 0xBE, 0x4D }, { 0x0D, 0x0C, 0x78 }, { 0xE5, 0xBE, 0x4D }, { 0x0A, 0xBC, 0xC8 }}},
                {{{ 0x0F, 0x12, 0x98 }, { 0xE6, 0x4E, 0xC6 }, { 0x0C, 0xC0, 0x3E }, { 0xE6, 0x4E, 0xC6 }, { 0x0B, 0xD2, 0xD7 }}},
                {{{ 0x0C, 0x64, 0x1A }, { 0x06, 0x53, 0x7A }, { 0x08, 0xD1, 0x55 }, { 0x06, 0x53, 0x7A }, { 0x05, 0x35, 0x70 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}}
            }                           // end of filter set
		},
        {                               // ----------     Equalization Set #4     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -14.3  */  -14340,     // drcThreshold     (X1000)
            /*     4.5  */       9,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000001C,                 // layoutID     = 
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x4F, 0x95 }, { 0xE1, 0x60, 0xD4 }, { 0x0F, 0x4F, 0x95 }, { 0xE1, 0x68, 0x6E }, { 0x0E, 0xA6, 0xC5 }}},
                {{{ 0x06, 0x6B, 0x92 }, { 0x02, 0x90, 0xD4 }, { 0x01, 0x48, 0xA0 }, { 0xF6, 0x85, 0x3F }, { 0x03, 0xBF, 0xC7 }}},
                {{{ 0x0F, 0x57, 0xDC }, { 0xE5, 0x1C, 0x91 }, { 0x0D, 0xD1, 0xCB }, { 0xE5, 0x1C, 0x91 }, { 0x0D, 0x29, 0xA8 }}},
                {{{ 0x0D, 0xF1, 0xCB }, { 0xE4, 0xFA, 0x84 }, { 0x0D, 0x7C, 0xDC }, { 0xE4, 0xFA, 0x84 }, { 0x0B, 0x6E, 0xA7 }}},
                {{{ 0x0E, 0xBA, 0x36 }, { 0xE6, 0xAA, 0x48 }, { 0x0B, 0x9F, 0x52 }, { 0xE6, 0xAA, 0x48 }, { 0x0A, 0x59, 0x89 }}},
                {{{ 0x0C, 0xAF, 0x02 }, { 0x05, 0xEF, 0x9D }, { 0x08, 0x4B, 0xEB }, { 0x05, 0xEF, 0x9D }, { 0x04, 0xFA, 0xEE }}},
                {{{ 0x0F, 0xC6, 0x86 }, { 0xE2, 0x29, 0x47 }, { 0x0E, 0x4B, 0x5D }, { 0xE2, 0x29, 0x47 }, { 0x0E, 0x11, 0xE4 }}},
                {{{ 0x0F, 0x4F, 0x95 }, { 0xE1, 0x60, 0xD4 }, { 0x0F, 0x4F, 0x95 }, { 0xE1, 0x68, 0x6E }, { 0x0E, 0xA6, 0xC5 }}},
                {{{ 0x06, 0x6B, 0x92 }, { 0x02, 0x90, 0xD4 }, { 0x01, 0x48, 0xA0 }, { 0xF6, 0x85, 0x3F }, { 0x03, 0xBF, 0xC7 }}},
                {{{ 0x0F, 0x57, 0xDC }, { 0xE5, 0x1C, 0x91 }, { 0x0D, 0xD1, 0xCB }, { 0xE5, 0x1C, 0x91 }, { 0x0D, 0x29, 0xA8 }}},
                {{{ 0x0D, 0xF1, 0xCB }, { 0xE4, 0xFA, 0x84 }, { 0x0D, 0x7C, 0xDC }, { 0xE4, 0xFA, 0x84 }, { 0x0B, 0x6E, 0xA7 }}},
                {{{ 0x0E, 0xBA, 0x36 }, { 0xE6, 0xAA, 0x48 }, { 0x0B, 0x9F, 0x52 }, { 0xE6, 0xAA, 0x48 }, { 0x0A, 0x59, 0x89 }}},
                {{{ 0x0C, 0xAF, 0x02 }, { 0x05, 0xEF, 0x9D }, { 0x08, 0x4B, 0xEB }, { 0x05, 0xEF, 0x9D }, { 0x04, 0xFA, 0xEE }}},
                {{{ 0x0F, 0xC6, 0x86 }, { 0xE2, 0x29, 0x47 }, { 0x0E, 0x4B, 0x5D }, { 0xE2, 0x29, 0x47 }, { 0x0E, 0x11, 0xE4 }}}
            }                           // end of filter set
		}
    }
};

#endif
