/*
 *  AppleTexas2EQPrefs.cpp
 *  AppleOnboardAudio
 *
 *  Created by mcookson on Mon Jul 16 2001.
 *  Copyright (c) 2001 Apple Computer, Inc. All rights reserved.
 *
 */
 
#ifndef __TEXAS2_EQ_PREFS__
#define __TEXAS2_EQ_PREFS__
 

#include "Texas2_hw.h"

EQPrefs         theEQPrefs = 
{
    0x00000001,                         // structVersionNumber
    0x72617720,                         // genreType = 'raw '
    0x0000000D,                         // eqCount	(update EQPrefsElement array size in AppleTexas2EQPrefs.cpp when updating eqCount!)
    0x00000000,                         // nameID
    {                                   // eq
        {                               // ----------     Equalization Set #1     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -10.8  */  -10750,     // drcThreshold     (X1000)
            /*     2.2  */       4,     // drcMaximumVolume (X2)
            0x00000000,                 // drcEnable    = ENABLED
            0x0000001A,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xB8, 0xFD }, { 0xE0, 0x8E, 0x04 }, { 0x0F, 0xB8, 0xFD }, { 0xE0, 0x8F, 0x40 }, { 0x0F, 0x73, 0x36 }}},
                {{{ 0x06, 0x37, 0x1D }, { 0x0C, 0x6E, 0x3A }, { 0x06, 0x37, 0x1D }, { 0x05, 0xBF, 0xD3 }, { 0x03, 0x1C, 0xA2 }}},
                {{{ 0x0F, 0xA1, 0xC0 }, { 0xE1, 0x86, 0x92 }, { 0x0F, 0x03, 0x0E }, { 0xE1, 0x86, 0x92 }, { 0x0E, 0xA4, 0xCE }}},
                {{{ 0x0F, 0xE4, 0x95 }, { 0xE1, 0x7E, 0xFF }, { 0x0F, 0x04, 0x52 }, { 0xE1, 0x7E, 0xFF }, { 0x0E, 0xE8, 0xE7 }}},
                {{{ 0x10, 0x08, 0x57 }, { 0xE7, 0xE7, 0x1C }, { 0x0E, 0x95, 0x99 }, { 0xE7, 0xE7, 0x1C }, { 0x0E, 0x9D, 0xF1 }}},
                {{{ 0x0F, 0xB2, 0x6E }, { 0x06, 0xA8, 0x2C }, { 0x0D, 0xB2, 0xB4 }, { 0x06, 0xA8, 0x2C }, { 0x0D, 0x65, 0x22 }}},
                {{{ 0x11, 0x41, 0x9D }, { 0xF0, 0x6C, 0xBF }, { 0x0A, 0x4F, 0x6E }, { 0xF0, 0x6C, 0xBF }, { 0x0B, 0x91, 0x0C }}},
                {{{ 0x0F, 0xB8, 0xFD }, { 0xE0, 0x8E, 0x04 }, { 0x0F, 0xB8, 0xFD }, { 0xE0, 0x8F, 0x40 }, { 0x0F, 0x73, 0x36 }}},
                {{{ 0x06, 0x37, 0x1D }, { 0x0C, 0x6E, 0x3A }, { 0x06, 0x37, 0x1D }, { 0x05, 0xBF, 0xD3 }, { 0x03, 0x1C, 0xA2 }}},
                {{{ 0x0F, 0xA1, 0xC0 }, { 0xE1, 0x86, 0x92 }, { 0x0F, 0x03, 0x0E }, { 0xE1, 0x86, 0x92 }, { 0x0E, 0xA4, 0xCE }}},
                {{{ 0x0F, 0xE4, 0x95 }, { 0xE1, 0x7E, 0xFF }, { 0x0F, 0x04, 0x52 }, { 0xE1, 0x7E, 0xFF }, { 0x0E, 0xE8, 0xE7 }}},
                {{{ 0x10, 0x08, 0x57 }, { 0xE7, 0xE7, 0x1C }, { 0x0E, 0x95, 0x99 }, { 0xE7, 0xE7, 0x1C }, { 0x0E, 0x9D, 0xF1 }}},
                {{{ 0x0F, 0xB2, 0x6E }, { 0x06, 0xA8, 0x2C }, { 0x0D, 0xB2, 0xB4 }, { 0x06, 0xA8, 0x2C }, { 0x0D, 0x65, 0x22 }}},
                {{{ 0x11, 0x41, 0x9D }, { 0xF0, 0x6C, 0xBF }, { 0x0A, 0x4F, 0x6E }, { 0xF0, 0x6C, 0xBF }, { 0x0B, 0x91, 0x0C }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #2     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -19.1  */  -19120,     // drcThreshold     (X1000)
            /*     4.1  */       8,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000017,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xD0, 0xD4 }, { 0xE0, 0x5E, 0x56 }, { 0x0F, 0xD0, 0xD4 }, { 0xE0, 0x5E, 0xE1 }, { 0x0F, 0xA2, 0x34 }}},
                {{{ 0x09, 0x10, 0xD7 }, { 0x08, 0x8E, 0x1A }, { 0x03, 0x06, 0x51 }, { 0x01, 0xDC, 0xB1 }, { 0x02, 0xC8, 0x92 }}},
                {{{ 0x0F, 0xF8, 0x95 }, { 0xE0, 0x97, 0x0B }, { 0x0F, 0x7F, 0x00 }, { 0xE0, 0x97, 0x0B }, { 0x0F, 0x77, 0x95 }}},
                {{{ 0x0F, 0xD1, 0xC4 }, { 0xE1, 0xAC, 0x22 }, { 0x0E, 0xC8, 0xCF }, { 0xE1, 0xAC, 0x22 }, { 0x0E, 0x9A, 0x94 }}},
                {{{ 0x0F, 0x7C, 0x1C }, { 0xE3, 0xCC, 0x03 }, { 0x0D, 0xF7, 0x86 }, { 0xE3, 0xCC, 0x03 }, { 0x0D, 0x73, 0xA2 }}},
                {{{ 0x11, 0xFB, 0x92 }, { 0xF5, 0xA1, 0xA0 }, { 0x07, 0x3C, 0xD2 }, { 0xF5, 0xA1, 0xA0 }, { 0x09, 0x38, 0x65 }}},
                {{{ 0x0E, 0x17, 0xA9 }, { 0x06, 0x8B, 0x6C }, { 0x08, 0xA0, 0xE5 }, { 0x06, 0x8B, 0x6C }, { 0x06, 0xB8, 0x8E }}},
                {{{ 0x0F, 0xD0, 0xD4 }, { 0xE0, 0x5E, 0x56 }, { 0x0F, 0xD0, 0xD4 }, { 0xE0, 0x5E, 0xE1 }, { 0x0F, 0xA2, 0x34 }}},
                {{{ 0x09, 0x10, 0xD7 }, { 0x08, 0x8E, 0x1A }, { 0x03, 0x06, 0x51 }, { 0x01, 0xDC, 0xB1 }, { 0x02, 0xC8, 0x92 }}},
                {{{ 0x0F, 0xF8, 0x95 }, { 0xE0, 0x97, 0x0B }, { 0x0F, 0x7F, 0x00 }, { 0xE0, 0x97, 0x0B }, { 0x0F, 0x77, 0x95 }}},
                {{{ 0x0F, 0xD1, 0xC4 }, { 0xE1, 0xAC, 0x22 }, { 0x0E, 0xC8, 0xCF }, { 0xE1, 0xAC, 0x22 }, { 0x0E, 0x9A, 0x94 }}},
                {{{ 0x0F, 0x7C, 0x1C }, { 0xE3, 0xCC, 0x03 }, { 0x0D, 0xF7, 0x86 }, { 0xE3, 0xCC, 0x03 }, { 0x0D, 0x73, 0xA2 }}},
                {{{ 0x11, 0xFB, 0x92 }, { 0xF5, 0xA1, 0xA0 }, { 0x07, 0x3C, 0xD2 }, { 0xF5, 0xA1, 0xA0 }, { 0x09, 0x38, 0x65 }}},
                {{{ 0x0E, 0x17, 0xA9 }, { 0x06, 0x8B, 0x6C }, { 0x08, 0xA0, 0xE5 }, { 0x06, 0x8B, 0x6C }, { 0x06, 0xB8, 0x8E }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #3     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -13.1  */  -13140,     // drcThreshold     (X1000)
            /*     4.5  */       9,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000018,                 // layoutID     = 
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x55, 0x14 }, { 0xE1, 0x55, 0xD7 }, { 0x0F, 0x55, 0x14 }, { 0xE1, 0x5C, 0xFA }, { 0x0E, 0xB1, 0x4B }}},
                {{{ 0x06, 0xEC, 0x33 }, { 0x02, 0xAB, 0xE3 }, { 0x01, 0x5E, 0xEF }, { 0xF7, 0x64, 0xD9 }, { 0x03, 0x92, 0x2D }}},
                {{{ 0x0E, 0xF5, 0xF2 }, { 0xE6, 0x7D, 0x1F }, { 0x0B, 0xCF, 0x37 }, { 0xE6, 0x7D, 0x1F }, { 0x0A, 0xC5, 0x29 }}},
                {{{ 0x0D, 0xB0, 0x50 }, { 0xE5, 0xBE, 0x4D }, { 0x0D, 0x0C, 0x78 }, { 0xE5, 0xBE, 0x4D }, { 0x0A, 0xBC, 0xC8 }}},
                {{{ 0x0F, 0x12, 0x98 }, { 0xE6, 0x4E, 0xC6 }, { 0x0C, 0xC0, 0x3E }, { 0xE6, 0x4E, 0xC6 }, { 0x0B, 0xD2, 0xD7 }}},
                {{{ 0x0C, 0x64, 0x1A }, { 0x06, 0x53, 0x7A }, { 0x08, 0xD1, 0x55 }, { 0x06, 0x53, 0x7A }, { 0x05, 0x35, 0x70 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x0F, 0x55, 0x14 }, { 0xE1, 0x55, 0xD7 }, { 0x0F, 0x55, 0x14 }, { 0xE1, 0x5C, 0xFA }, { 0x0E, 0xB1, 0x4B }}},
                {{{ 0x06, 0xEC, 0x33 }, { 0x02, 0xAB, 0xE3 }, { 0x01, 0x5E, 0xEF }, { 0xF7, 0x64, 0xD9 }, { 0x03, 0x92, 0x2D }}},
                {{{ 0x0E, 0xF5, 0xF2 }, { 0xE6, 0x7D, 0x1F }, { 0x0B, 0xCF, 0x37 }, { 0xE6, 0x7D, 0x1F }, { 0x0A, 0xC5, 0x29 }}},
                {{{ 0x0D, 0xB0, 0x50 }, { 0xE5, 0xBE, 0x4D }, { 0x0D, 0x0C, 0x78 }, { 0xE5, 0xBE, 0x4D }, { 0x0A, 0xBC, 0xC8 }}},
                {{{ 0x0F, 0x12, 0x98 }, { 0xE6, 0x4E, 0xC6 }, { 0x0C, 0xC0, 0x3E }, { 0xE6, 0x4E, 0xC6 }, { 0x0B, 0xD2, 0xD7 }}},
                {{{ 0x0C, 0x64, 0x1A }, { 0x06, 0x53, 0x7A }, { 0x08, 0xD1, 0x55 }, { 0x06, 0x53, 0x7A }, { 0x05, 0x35, 0x70 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}}
            }                           // end of filter set
		},
        {                               // ----------     Equalization Set #4     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -14.3  */  -14340,     // drcThreshold     (X1000)
            /*     4.5  */       9,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000001C,                 // layoutID     = 
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x4F, 0x95 }, { 0xE1, 0x60, 0xD4 }, { 0x0F, 0x4F, 0x95 }, { 0xE1, 0x68, 0x6E }, { 0x0E, 0xA6, 0xC5 }}},
                {{{ 0x06, 0x6B, 0x92 }, { 0x02, 0x90, 0xD4 }, { 0x01, 0x48, 0xA0 }, { 0xF6, 0x85, 0x3F }, { 0x03, 0xBF, 0xC7 }}},
                {{{ 0x0F, 0x57, 0xDC }, { 0xE5, 0x1C, 0x91 }, { 0x0D, 0xD1, 0xCB }, { 0xE5, 0x1C, 0x91 }, { 0x0D, 0x29, 0xA8 }}},
                {{{ 0x0D, 0xF1, 0xCB }, { 0xE4, 0xFA, 0x84 }, { 0x0D, 0x7C, 0xDC }, { 0xE4, 0xFA, 0x84 }, { 0x0B, 0x6E, 0xA7 }}},
                {{{ 0x0E, 0xBA, 0x36 }, { 0xE6, 0xAA, 0x48 }, { 0x0B, 0x9F, 0x52 }, { 0xE6, 0xAA, 0x48 }, { 0x0A, 0x59, 0x89 }}},
                {{{ 0x0C, 0xAF, 0x02 }, { 0x05, 0xEF, 0x9D }, { 0x08, 0x4B, 0xEB }, { 0x05, 0xEF, 0x9D }, { 0x04, 0xFA, 0xEE }}},
                {{{ 0x0F, 0xC6, 0x86 }, { 0xE2, 0x29, 0x47 }, { 0x0E, 0x4B, 0x5D }, { 0xE2, 0x29, 0x47 }, { 0x0E, 0x11, 0xE4 }}},
                {{{ 0x0F, 0x4F, 0x95 }, { 0xE1, 0x60, 0xD4 }, { 0x0F, 0x4F, 0x95 }, { 0xE1, 0x68, 0x6E }, { 0x0E, 0xA6, 0xC5 }}},
                {{{ 0x06, 0x6B, 0x92 }, { 0x02, 0x90, 0xD4 }, { 0x01, 0x48, 0xA0 }, { 0xF6, 0x85, 0x3F }, { 0x03, 0xBF, 0xC7 }}},
                {{{ 0x0F, 0x57, 0xDC }, { 0xE5, 0x1C, 0x91 }, { 0x0D, 0xD1, 0xCB }, { 0xE5, 0x1C, 0x91 }, { 0x0D, 0x29, 0xA8 }}},
                {{{ 0x0D, 0xF1, 0xCB }, { 0xE4, 0xFA, 0x84 }, { 0x0D, 0x7C, 0xDC }, { 0xE4, 0xFA, 0x84 }, { 0x0B, 0x6E, 0xA7 }}},
                {{{ 0x0E, 0xBA, 0x36 }, { 0xE6, 0xAA, 0x48 }, { 0x0B, 0x9F, 0x52 }, { 0xE6, 0xAA, 0x48 }, { 0x0A, 0x59, 0x89 }}},
                {{{ 0x0C, 0xAF, 0x02 }, { 0x05, 0xEF, 0x9D }, { 0x08, 0x4B, 0xEB }, { 0x05, 0xEF, 0x9D }, { 0x04, 0xFA, 0xEE }}},
                {{{ 0x0F, 0xC6, 0x86 }, { 0xE2, 0x29, 0x47 }, { 0x0E, 0x4B, 0x5D }, { 0xE2, 0x29, 0x47 }, { 0x0E, 0x11, 0xE4 }}}
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #5     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     3.1  */       6,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000016,                 // layoutID     = [fill me in]
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000002,                 // speakerID    = External Ball 2
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x09, 0x5A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB5, 0xBC }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xCA, 0x5B }, { 0xE2, 0x18, 0x58 }, { 0x0E, 0x96, 0xE9 }, { 0xE2, 0x18, 0x58 }, { 0x0E, 0x61, 0x45 }}},
                {{{ 0x0F, 0x2B, 0x1E }, { 0xE6, 0x0E, 0x3D }, { 0x0D, 0x49, 0x4C }, { 0xE6, 0x0E, 0x3D }, { 0x0C, 0x74, 0x6A }}},
                {{{ 0x13, 0x3F, 0x74 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0x9E, 0xF7 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x09, 0x5A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB5, 0xBC }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xCA, 0x5B }, { 0xE2, 0x18, 0x58 }, { 0x0E, 0x96, 0xE9 }, { 0xE2, 0x18, 0x58 }, { 0x0E, 0x61, 0x45 }}},
                {{{ 0x0F, 0x2B, 0x1E }, { 0xE6, 0x0E, 0x3D }, { 0x0D, 0x49, 0x4C }, { 0xE6, 0x0E, 0x3D }, { 0x0C, 0x74, 0x6A }}},
                {{{ 0x13, 0x3F, 0x74 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0x9E, 0xF7 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}}
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #6     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     2.6  */       5,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000016,                 // layoutID     = [fill me in]
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000001,                 // speakerID    = External Ball
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0xDD }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB2, 0x3A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xB9, 0xFB }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x95, 0xB4 }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x4F, 0xB0 }}},
                {{{ 0x0F, 0x39, 0xA7 }, { 0xE5, 0xF5, 0xE7 }, { 0x0D, 0x61, 0xD5 }, { 0xE5, 0xF5, 0xE7 }, { 0x0C, 0x9B, 0x7C }}},
                {{{ 0x13, 0x14, 0xD6 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0xC9, 0x95 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}},
                {{{ 0x10, 0x02, 0x82 }, { 0xE0, 0x6F, 0x60 }, { 0x0F, 0x92, 0xE8 }, { 0xE0, 0x6F, 0x60 }, { 0x0F, 0x95, 0x6B }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0xDD }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB2, 0x3A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xB9, 0xFB }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x95, 0xB4 }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x4F, 0xB0 }}},
                {{{ 0x0F, 0x39, 0xA7 }, { 0xE5, 0xF5, 0xE7 }, { 0x0D, 0x61, 0xD5 }, { 0xE5, 0xF5, 0xE7 }, { 0x0C, 0x9B, 0x7C }}},
                {{{ 0x13, 0x14, 0xD6 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0xC9, 0x95 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}},
                {{{ 0x10, 0x02, 0x82 }, { 0xE0, 0x6F, 0x60 }, { 0x0F, 0x92, 0xE8 }, { 0xE0, 0x6F, 0x60 }, { 0x0F, 0x95, 0x6B }}}
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #7     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -20.3  */  -20300,     // drcThreshold     (X1000)
            /*    -12.5  */    -25,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000016,                 // layoutID     = (as appropriate)
            0x00000001,                 // deviceID     = none = internal
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x9D, 0x6A }, { 0xE0, 0xC5, 0x2A }, { 0x0F, 0x9D, 0x6A }, { 0xE0, 0xC7, 0x8A }, { 0x0F, 0x3D, 0x34 }}},
                {{{ 0x03, 0xCF, 0x34 }, { 0x07, 0x9E, 0x69 }, { 0x03, 0xCF, 0x34 }, { 0xFC, 0x58, 0x34 }, { 0x02, 0xE4, 0x9E }}},
                {{{ 0x0E, 0x0F, 0x12 }, { 0xE9, 0x58, 0xD3 }, { 0x0B, 0xA1, 0xF9 }, { 0xE9, 0x58, 0xD3 }, { 0x09, 0xB1, 0x0B }}},
                {{{ 0x0F, 0x08, 0xA0 }, { 0xE9, 0x3D, 0x7B }, { 0x0D, 0xAD, 0xD3 }, { 0xE9, 0x3D, 0x7B }, { 0x0C, 0xB6, 0x73 }}},
                {{{ 0x0F, 0xD6, 0x09 }, { 0xEE, 0xC8, 0x5E }, { 0x0E, 0x18, 0xD2 }, { 0xEE, 0xC8, 0x5E }, { 0x0D, 0xEE, 0xDC }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x0F, 0x9D, 0x6A }, { 0xE0, 0xC5, 0x2A }, { 0x0F, 0x9D, 0x6A }, { 0xE0, 0xC7, 0x8A }, { 0x0F, 0x3D, 0x34 }}},
                {{{ 0x03, 0xCF, 0x34 }, { 0x07, 0x9E, 0x69 }, { 0x03, 0xCF, 0x34 }, { 0xFC, 0x58, 0x34 }, { 0x02, 0xE4, 0x9E }}},
                {{{ 0x0E, 0x0F, 0x12 }, { 0xE9, 0x58, 0xD3 }, { 0x0B, 0xA1, 0xF9 }, { 0xE9, 0x58, 0xD3 }, { 0x09, 0xB1, 0x0B }}},
                {{{ 0x0F, 0x08, 0xA0 }, { 0xE9, 0x3D, 0x7B }, { 0x0D, 0xAD, 0xD3 }, { 0xE9, 0x3D, 0x7B }, { 0x0C, 0xB6, 0x73 }}},
                {{{ 0x0F, 0xD6, 0x09 }, { 0xEE, 0xC8, 0x5E }, { 0x0E, 0x18, 0xD2 }, { 0xEE, 0xC8, 0x5E }, { 0x0D, 0xEE, 0xDC }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}}
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #8     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*    -9.0  */   -9000,     // drcThreshold     (X1000)
            /*    -0.0  */       0,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000001F,                 // layoutID     = (as appropriate)
            0x00000001,                 // deviceID     = internal speaker
            0x00000000,                 // speakerID    = (as appropriate)
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
				{{{ 0x0F, 0x9D, 0x90 }, { 0xE0, 0xC4, 0xDF }, { 0x0F, 0x9D, 0x90 }, { 0xE0, 0xC7, 0x3C }, { 0x0F, 0x3D, 0x7E }}},
				{{{ 0x10, 0x52, 0x4F }, { 0xE2, 0x03, 0x59 }, { 0x0D, 0xDD, 0xA6 }, { 0xE1, 0xF8, 0x58 }, { 0x0E, 0x24, 0xF4 }}},
				{{{ 0x0F, 0xDC, 0x22 }, { 0xF9, 0xD7, 0x33 }, { 0x0E, 0x35, 0x83 }, { 0xF9, 0xD7, 0x33 }, { 0x0E, 0x11, 0xA6 }}},
				{{{ 0x0F, 0xB6, 0xEE }, { 0xE0, 0xF2, 0xD6 }, { 0x0F, 0x6E, 0x2D }, { 0xE0, 0xF2, 0xD6 }, { 0x0F, 0x25, 0x1B }}},
				{{{ 0x0F, 0x90, 0x6B }, { 0xEF, 0x92, 0xF7 }, { 0x0D, 0x52, 0x87 }, { 0xEF, 0x92, 0xF7 }, { 0x0C, 0xE2, 0xF2 }}},
				{{{ 0x0F, 0xDF, 0xC6 }, { 0xE0, 0x97, 0xE6 }, { 0x0F, 0xB3, 0x55 }, { 0xE0, 0x97, 0xE6 }, { 0x0F, 0x93, 0x1B }}},
				{{{ 0x0F, 0xCE, 0x04 }, { 0xE2, 0xBB, 0x2D }, { 0x0E, 0xBA, 0x16 }, { 0xE2, 0xBB, 0x2D }, { 0x0E, 0x88, 0x1A }}},
				{{{ 0x0F, 0x9D, 0x90 }, { 0xE0, 0xC4, 0xDF }, { 0x0F, 0x9D, 0x90 }, { 0xE0, 0xC7, 0x3C }, { 0x0F, 0x3D, 0x7E }}},
				{{{ 0x10, 0x52, 0x4F }, { 0xE2, 0x03, 0x59 }, { 0x0D, 0xDD, 0xA6 }, { 0xE1, 0xF8, 0x58 }, { 0x0E, 0x24, 0xF4 }}},
				{{{ 0x0F, 0xDC, 0x22 }, { 0xF9, 0xD7, 0x33 }, { 0x0E, 0x35, 0x83 }, { 0xF9, 0xD7, 0x33 }, { 0x0E, 0x11, 0xA6 }}},
				{{{ 0x0F, 0xB6, 0xEE }, { 0xE0, 0xF2, 0xD6 }, { 0x0F, 0x6E, 0x2D }, { 0xE0, 0xF2, 0xD6 }, { 0x0F, 0x25, 0x1B }}},
				{{{ 0x0F, 0x90, 0x6B }, { 0xEF, 0x92, 0xF7 }, { 0x0D, 0x52, 0x87 }, { 0xEF, 0x92, 0xF7 }, { 0x0C, 0xE2, 0xF2 }}},
				{{{ 0x0F, 0xDF, 0xC6 }, { 0xE0, 0x97, 0xE6 }, { 0x0F, 0xB3, 0x55 }, { 0xE0, 0x97, 0xE6 }, { 0x0F, 0x93, 0x1B }}},
				{{{ 0x0F, 0xCE, 0x04 }, { 0xE2, 0xBB, 0x2D }, { 0x0E, 0xBA, 0x16 }, { 0xE2, 0xBB, 0x2D }, { 0x0E, 0x88, 0x1A }}},
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #9     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     5.5  */      11,     // drcMaximumVolume (X2)		[3142219]
            0x00000001,                 // drcEnable    = ENABLED
            0x00000021,                 // layoutID     = (as appropriate)
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000001,                 // speakerID    = External Ball P43
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0xDD }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB2, 0x3A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xB9, 0xFB }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x95, 0xB4 }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x4F, 0xB0 }}},
                {{{ 0x0F, 0x46, 0xC0 }, { 0xE7, 0x71, 0x2C }, { 0x0D, 0x6A, 0xB6 }, { 0xE7, 0x71, 0x2C }, { 0x0C, 0xB1, 0x77 }}},
                {{{ 0x13, 0x14, 0xD6 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0xC9, 0x95 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0xDD }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB2, 0x3A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xB9, 0xFB }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x95, 0xB4 }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x4F, 0xB0 }}},
                {{{ 0x0F, 0x46, 0xC0 }, { 0xE7, 0x71, 0x2C }, { 0x0D, 0x6A, 0xB6 }, { 0xE7, 0x71, 0x2C }, { 0x0C, 0xB1, 0x77 }}},
                {{{ 0x13, 0x14, 0xD6 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0xC9, 0x95 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #10     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     5.5  */      11,     // drcMaximumVolume (X2)		[3142219]
            0x00000001,                 // drcEnable    = ENABLED
            0x00000021,                 // layoutID     = (as appropriate)
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000002,                 // speakerID    = External Ball P74
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0x73 }, { 0xE0, 0x6C, 0xE6 }, { 0x0F, 0x87, 0x6A }, { 0xE0, 0x6C, 0xE6 }, { 0x0F, 0x93, 0xDD }}},
                {{{ 0x0F, 0x91, 0x22 }, { 0xE5, 0x77, 0x0C }, { 0x0D, 0x15, 0xBF }, { 0xE5, 0x77, 0x0C }, { 0x0C, 0xA6, 0xE2 }}},
                {{{ 0x0F, 0x88, 0xC3 }, { 0xE2, 0x7C, 0x05 }, { 0x0E, 0x4E, 0x1F }, { 0xE2, 0x7C, 0x05 }, { 0x0D, 0xD6, 0xE2 }}},
                {{{ 0x13, 0xF5, 0x9B }, { 0xF7, 0x8B, 0xF2 }, { 0x05, 0x83, 0x47 }, { 0xF7, 0x8B, 0xF2 }, { 0x09, 0x78, 0xE3 }}},
                {{{ 0x0A, 0xCE, 0x4E }, { 0x04, 0xC8, 0x40 }, { 0x06, 0xBA, 0xA5 }, { 0x04, 0xC8, 0x40 }, { 0x01, 0x88, 0xF4 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0x73 }, { 0xE0, 0x6C, 0xE6 }, { 0x0F, 0x87, 0x6A }, { 0xE0, 0x6C, 0xE6 }, { 0x0F, 0x93, 0xDD }}},
                {{{ 0x0F, 0x91, 0x22 }, { 0xE5, 0x77, 0x0C }, { 0x0D, 0x15, 0xBF }, { 0xE5, 0x77, 0x0C }, { 0x0C, 0xA6, 0xE2 }}},
                {{{ 0x0F, 0x88, 0xC3 }, { 0xE2, 0x7C, 0x05 }, { 0x0E, 0x4E, 0x1F }, { 0xE2, 0x7C, 0x05 }, { 0x0D, 0xD6, 0xE2 }}},
                {{{ 0x13, 0xF5, 0x9B }, { 0xF7, 0x8B, 0xF2 }, { 0x05, 0x83, 0x47 }, { 0xF7, 0x8B, 0xF2 }, { 0x09, 0x78, 0xE3 }}},
                {{{ 0x0A, 0xCE, 0x4E }, { 0x04, 0xC8, 0x40 }, { 0x06, 0xBA, 0xA5 }, { 0x04, 0xC8, 0x40 }, { 0x01, 0x88, 0xF4 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #11     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*    -7.7  */   -7670,     // drcThreshold     (X1000)
            /*     5.5  */      11,     // drcMaximumVolume (X2)		[3138116,3076505]
            0x00000001,                 // drcEnable    = ENABLED
            0x00000021,                 // layoutID     = (as appropriate)
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x72, 0xD2 }, { 0xE1, 0x1A, 0x5A }, { 0x0F, 0x72, 0xBB }, { 0xE1, 0x1C, 0xD4 }, { 0x0E, 0xE8, 0x1F }}},
                {{{ 0x03, 0xDD, 0x20 }, { 0x07, 0xBA, 0x41 }, { 0x03, 0xDD, 0x20 }, { 0xFC, 0x94, 0xA0 }, { 0x02, 0xDF, 0xE1 }}},
                {{{ 0x0F, 0x07, 0x47 }, { 0xE6, 0x96, 0x9C }, { 0x0D, 0x29, 0xC5 }, { 0xE6, 0x96, 0x9C }, { 0x0C, 0x31, 0x0D }}},
                {{{ 0x0F, 0x25, 0xE3 }, { 0xE2, 0x8A, 0xFD }, { 0x0E, 0x7A, 0xB1 }, { 0xE2, 0x8A, 0xFD }, { 0x0D, 0xA0, 0x95 }}},
                {{{ 0x0F, 0x85, 0x9F }, { 0xE7, 0x72, 0x0E }, { 0x0E, 0x12, 0x8C }, { 0xE7, 0x72, 0x0E }, { 0x0D, 0x98, 0x2B }}},
                {{{ 0x10, 0x59, 0x92 }, { 0xF5, 0xA3, 0x79 }, { 0x09, 0xEA, 0x3F }, { 0xF5, 0xA3, 0x79 }, { 0x0A, 0x43, 0xD2 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x0F, 0x72, 0xD2 }, { 0xE1, 0x1A, 0x5A }, { 0x0F, 0x72, 0xBB }, { 0xE1, 0x1C, 0xD4 }, { 0x0E, 0xE8, 0x1F }}},
                {{{ 0x03, 0xDD, 0x20 }, { 0x07, 0xBA, 0x41 }, { 0x03, 0xDD, 0x20 }, { 0xFC, 0x94, 0xA0 }, { 0x02, 0xDF, 0xE1 }}},
                {{{ 0x0F, 0x07, 0x47 }, { 0xE6, 0x96, 0x9C }, { 0x0D, 0x29, 0xC5 }, { 0xE6, 0x96, 0x9C }, { 0x0C, 0x31, 0x0D }}},
                {{{ 0x0F, 0x25, 0xE3 }, { 0xE2, 0x8A, 0xFD }, { 0x0E, 0x7A, 0xB1 }, { 0xE2, 0x8A, 0xFD }, { 0x0D, 0xA0, 0x95 }}},
                {{{ 0x0F, 0x85, 0x9F }, { 0xE7, 0x72, 0x0E }, { 0x0E, 0x12, 0x8C }, { 0xE7, 0x72, 0x0E }, { 0x0D, 0x98, 0x2B }}},
                {{{ 0x10, 0x59, 0x92 }, { 0xF5, 0xA3, 0x79 }, { 0x09, 0xEA, 0x3F }, { 0xF5, 0xA3, 0x79 }, { 0x0A, 0x43, 0xD2 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #12    ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*    -7.7  */   -9000,     // drcThreshold     (X1000)
            /*    -1.0  */      -2,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000001E,                 // layoutID     = (as appropriate)
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
				{{{ 0x0F, 0xB2, 0x5C }, { 0xE0, 0x9B, 0x46 }, { 0x0F, 0xB2, 0x5C }, { 0xE0, 0x9C, 0xBE }, { 0x0F, 0x66, 0x32 }}}, // Left Biquad 0
				{{{ 0x08, 0x5E, 0x67 }, { 0x00, 0xE9, 0x4D }, { 0x01, 0x74, 0x12 }, { 0xF7, 0x1B, 0x0F }, { 0x03, 0xA0, 0xB7 }}}, // Left Biquad 1
				{{{ 0x0F, 0xD7, 0x89 }, { 0xE3, 0x8C, 0x1C }, { 0x0F, 0x03, 0x6A }, { 0xE3, 0x8C, 0x1C }, { 0x0E, 0xDA, 0xF3 }}}, // Left Biquad 2
				{{{ 0x0F, 0xC5, 0x4E }, { 0xE0, 0xE8, 0x30 }, { 0x0F, 0x6E, 0xA8 }, { 0xE0, 0xE8, 0x30 }, { 0x0F, 0x33, 0xF7 }}}, // Left Biquad 3
				{{{ 0x0F, 0xCB, 0xED }, { 0xE1, 0x16, 0x59 }, { 0x0F, 0x59, 0x4B }, { 0xE1, 0x16, 0x59 }, { 0x0F, 0x25, 0x39 }}}, // Left Biquad 4
				{{{ 0x0F, 0xB5, 0x30 }, { 0xE2, 0xEE, 0x7E }, { 0x0E, 0xB2, 0x7F }, { 0xE2, 0xEE, 0x7E }, { 0x0E, 0x67, 0xAF }}}, // Left Biquad 5
				{{{ 0x0E, 0xE5, 0x9D }, { 0x00, 0xF4, 0xC1 }, { 0x0C, 0x33, 0x61 }, { 0x00, 0xF4, 0xC1 }, { 0x0B, 0x18, 0xFE }}}, // Left Biquad 6
				{{{ 0x0F, 0xB2, 0x5C }, { 0xE0, 0x9B, 0x46 }, { 0x0F, 0xB2, 0x5C }, { 0xE0, 0x9C, 0xBE }, { 0x0F, 0x66, 0x32 }}}, // Right Biquad 0
				{{{ 0x08, 0x5E, 0x67 }, { 0x00, 0xE9, 0x4D }, { 0x01, 0x74, 0x12 }, { 0xF7, 0x1B, 0x0F }, { 0x03, 0xA0, 0xB7 }}}, // Right Biquad 1
				{{{ 0x0F, 0xD7, 0x89 }, { 0xE3, 0x8C, 0x1C }, { 0x0F, 0x03, 0x6A }, { 0xE3, 0x8C, 0x1C }, { 0x0E, 0xDA, 0xF3 }}}, // Right Biquad 2
				{{{ 0x0F, 0xC5, 0x4E }, { 0xE0, 0xE8, 0x30 }, { 0x0F, 0x6E, 0xA8 }, { 0xE0, 0xE8, 0x30 }, { 0x0F, 0x33, 0xF7 }}}, // Right Biquad 3
				{{{ 0x0F, 0xCB, 0xED }, { 0xE1, 0x16, 0x59 }, { 0x0F, 0x59, 0x4B }, { 0xE1, 0x16, 0x59 }, { 0x0F, 0x25, 0x39 }}}, // Right Biquad 4
				{{{ 0x0F, 0xB5, 0x30 }, { 0xE2, 0xEE, 0x7E }, { 0x0E, 0xB2, 0x7F }, { 0xE2, 0xEE, 0x7E }, { 0x0E, 0x67, 0xAF }}}, // Right Biquad 5
				{{{ 0x0E, 0xE5, 0x9D }, { 0x00, 0xF4, 0xC1 }, { 0x0C, 0x33, 0x61 }, { 0x00, 0xF4, 0xC1 }, { 0x0B, 0x18, 0xFE }}}, // Right Biquad 6
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #13     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*    -7.7  */   -9000,     // drcThreshold     (X1000)
            /*    +4.0  */       8,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000022,                 // layoutID     = (as appropriate)
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
				{{{ 0x0F, 0xCA, 0x56 }, { 0xE0, 0x6B, 0x52 }, { 0x0F, 0xCA, 0x56 }, { 0xE0, 0x6C, 0x06 }, { 0x0F, 0x95, 0x61 }}}, // Left Biquad 0
				{{{ 0x08, 0x38, 0x45 }, { 0xF0, 0xAE, 0xD4 }, { 0x07, 0x2B, 0x4D }, { 0xE1, 0x8D, 0x67 }, { 0x0E, 0x85, 0x00 }}}, // Left Biquad 1
				{{{ 0x10, 0x13, 0xB0 }, { 0xE0, 0xAD, 0xB3 }, { 0x0F, 0x48, 0x9F }, { 0xE0, 0xAD, 0xB3 }, { 0x0F, 0x5C, 0x4F }}}, // Left Biquad 2
				{{{ 0x0F, 0xBE, 0x34 }, { 0xE1, 0x1F, 0xC9 }, { 0x0F, 0x3D, 0xCE }, { 0xE1, 0x1F, 0xC9 }, { 0x0E, 0xFC, 0x03 }}}, // Left Biquad 3
				{{{ 0x0E, 0x92, 0x4C }, { 0xE6, 0xDC, 0x31 }, { 0x0D, 0x01, 0x97 }, { 0xE6, 0xDC, 0x31 }, { 0x0B, 0x93, 0xE3 }}}, // Left Biquad 4
				{{{ 0x0F, 0xB9, 0xAC }, { 0xE1, 0xBA, 0xFA }, { 0x0E, 0xE5, 0xFE }, { 0xE1, 0xBA, 0xFA }, { 0x0E, 0x9F, 0xAA }}}, // Left Biquad 5
				{{{ 0x0D, 0x4B, 0x33 }, { 0x03, 0x63, 0x8F }, { 0x0A, 0xE0, 0xD2 }, { 0x03, 0x63, 0x8F }, { 0x08, 0x2C, 0x06 }}}, // Left Biquad 6
				{{{ 0x0F, 0xCA, 0x56 }, { 0xE0, 0x6B, 0x52 }, { 0x0F, 0xCA, 0x56 }, { 0xE0, 0x6C, 0x06 }, { 0x0F, 0x95, 0x61 }}}, // Right Biquad 0
				{{{ 0x08, 0x38, 0x45 }, { 0xF0, 0xAE, 0xD4 }, { 0x07, 0x2B, 0x4D }, { 0xE1, 0x8D, 0x67 }, { 0x0E, 0x85, 0x00 }}}, // Right Biquad 1
				{{{ 0x10, 0x13, 0xB0 }, { 0xE0, 0xAD, 0xB3 }, { 0x0F, 0x48, 0x9F }, { 0xE0, 0xAD, 0xB3 }, { 0x0F, 0x5C, 0x4F }}}, // Right Biquad 2
				{{{ 0x0F, 0xBE, 0x34 }, { 0xE1, 0x1F, 0xC9 }, { 0x0F, 0x3D, 0xCE }, { 0xE1, 0x1F, 0xC9 }, { 0x0E, 0xFC, 0x03 }}}, // Right Biquad 3
				{{{ 0x0E, 0x92, 0x4C }, { 0xE6, 0xDC, 0x31 }, { 0x0D, 0x01, 0x97 }, { 0xE6, 0xDC, 0x31 }, { 0x0B, 0x93, 0xE3 }}}, // Right Biquad 4
				{{{ 0x0F, 0xB9, 0xAC }, { 0xE1, 0xBA, 0xFA }, { 0x0E, 0xE5, 0xFE }, { 0xE1, 0xBA, 0xFA }, { 0x0E, 0x9F, 0xAA }}}, // Right Biquad 5
				{{{ 0x0D, 0x4B, 0x33 }, { 0x03, 0x63, 0x8F }, { 0x0A, 0xE0, 0xD2 }, { 0x03, 0x63, 0x8F }, { 0x08, 0x2C, 0x06 }}}, // Right Biquad 6
            }                           // end of filter set
		}
    }
};

#endif
