/*
 *  AppleTexas2EQPrefs.cpp
 *  AppleLegacyAudio
 *
 *  Created by mcookson on Mon Jul 16 2001.
 *  Copyright (c) 2001 Apple Computer, Inc. All rights reserved.
 *
 */
 
#ifndef __TAS3004_EQ_PREFS__
#define __TAS3004_EQ_PREFS__
 

#include "TAS_hw.h"

EQPrefs         theEQPrefs = 
{
    0x00000001,                         // structVersionNumber
    0x72617720,                         // genreType = 'raw '
    0x00000002,                         // eqCount	(update EQPrefsElement array size in TAS_hw.h when updating eqCount!)
    0x00000000,                         // nameID
    {                                   // eq
        {                               // ----------     Equalization Set #1     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -10.8  */  -10750,     // drcThreshold     (X1000)
            /*     2.2  */      24,     // drcMaximumVolume (X2)
            0x00000000,                 // drcEnable    = ENABLED
            0x00000024,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #1     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -10.8  */  -10750,     // drcThreshold     (X1000)
            /*     2.2  */      4,     	// drcMaximumVolume (X2)
            0x00000000,                 // drcEnable    = ENABLED
            0x00000025,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = legacy
            0x00000000,                 // reserved     = 0 
            0x0000000E,                 // filterCount  = 14
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
            }                           // end of filter set
        }
    }
};

#endif
