/*
 * Copyright (c) 2002 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Copyright (c) 1999-2003 Apple Computer, Inc.  All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*******************************************************************************
*                                                                              *
*      File tanatantable.c,                                                    *
*                                                                              *
*      This file contains the unsigned long array TanTable, which is used in   *
*      the approximations for the functions tan and atan.  Provided by         *
*      Taligent, Inc. who received if from IBM.                                *
*                                                                              *
*     Copyright  1995-2001 Apple Computer, Inc.  All rights reserved.         *
*                                                                              *
*     Written by Ali Sazegari, started on January 1995.                        *
*                                                                              *
*     A MathLib v4 file.                                                       *
*                                                                              *
*     November  06 2001: commented out warning about Intel architectures.      *
*     September 09 2001: added more comments.                                  *
*     September 10 2001: added macros to detect PowerPC and correct compiler.  *
*     October   08 2001: changed compiler errors to warnings.                  *
*                                                                              *
*      atan(x+T5[i][0]) = T5(i,1) * x**5 + T5(i,2)] * x**4 + T5(i,3) * x**3    *
*                       + T5(i,4) * x**2 + T5(i,5) * x + T5(i,6)               *
*      for x in the intervals [(i+16)/256-1/512,(i+16)/256+1/512], i=1,...,250.*
*      or for x in the interval [1/16,1/16+1/512].                             *
*      relative error E is E <= 1.7E-18 for all i.                             *
*                                                                              *
*******************************************************************************/

#ifdef      __APPLE_CC__
#if         __APPLE_CC__ > 930

__private_extern__
const unsigned long tanatantable[] = 
      {
      0x3FB0000B,   0x6EA05B24,      /* index runs 16-256  */
      0x3FC814DB,   0x31B98EDB,
      0x3FAF61EC,   0x1900B708,
      0xBFD4D692,   0x5132F463,
      0xBFAFC075,   0xD603C117,
      0x3FEFE01F,   0xB2C03B47,
      0x3FAFF572,   0x7DA729C0,
      /* end for i=16 */
      0x3FB0FFFA,   0x4B8746CD,
      0x3FC7F0DF,   0x6CD60F68,
      0x3FB0A12C,   0x049E47F5,
      0xBFD4C66A,   0x301D1DE9,
      0xBFB0D9D9,   0x0F66244D,
      0x3FEFDC08,   0xB2526DAE,
      0x3FB0F998,   0xF90E1680,
      /* end for i=17 */
      0x3FB1FFF4,   0x70E9D0F2,
      0x3FC7BE9E,   0x0856338C,
      0x3FB18F96,   0x403B22E8,
      0xBFD4B552,   0x02E755F4,
      0xBFB1D2BA,   0xB5EAFD63,
      0x3FEFD7B3,   0x34F34D97,
      0x3FB1F862,   0x3E80A080,
      /* end for i=18 */
      0x3FB3000D,   0xE222ED39,
      0x3FC789C3,   0x24EE2FFD,
      0x3FB27C19,   0xC4AC0E85,
      0xBFD4A34A,   0x2DA5CB7C,
      0xBFB2CAE7,   0xF3651F57,
      0x3FEFD31F,   0x07A8722D,
      0x3FB2F727,   0x0034BB40,
      /* end for i=19 */
      0x3FB3FFF7,   0x07939C1A,
      0x3FC75259,   0xFAD65D55,
      0x3FB36653,   0x7EEC8496,
      0xBFD4905A,   0x72DCC718,
      0xBFB3C208,   0xA789AF26,
      0x3FEFCE4D,   0xD2FAC467,
      0x3FB3F596,   0x23FE5060,
      /* end for i=20 */
      0x3FB4FFFD,   0xD98DB5B1,
      0x3FC7186E,   0x430C287C,
      0x3FB44E71,   0xB23F0C72,
      0xBFD47C7F,   0x51575301,
      0xBFB4B85D,   0x3A22668E,
      0x3FEFC93E,   0x5EC544B5,
      0x3FB4F3FB,   0x44AE2CA0,
      /* end for i=21 */
      0x3FB60004,   0x20591D48,
      0x3FC6DC0C,   0x335E489F,
      0x3FB5343F,   0xBAC74D4A,
      0xBFD467BD,   0x3C798545,
      0xBFB5ADBD,   0x8F41368F,
      0x3FEFC3F1,   0x74F787AD,
      0x3FB5F236,   0x686D6F40,
      /* end for i=22 */
      0x3FB6FFFC,   0x9A3DF07F,
      0x3FC69D40,   0x7A539ADD,
      0x3FB61799,   0x84428983,
      0xBFD45217,   0xB69127EA,
      0xBFB6A212,   0x41C2138F,
      0x3FEFBE67,   0x9F40F9A0,
      0x3FB6F038,   0x7E1F1C60,
      /* end for i=23 */
      0x3FB7FFF8,   0x1D7476B1,
      0x3FC65C18,   0x3AEEA2FC,
      0x3FB6F876,   0x4BAFD937,
      0xBFD43B8F,   0xD55668CC,
      0xBFB79560,   0xCBFC3300,
      0x3FEFB8A0,   0xC52A1A1D,
      0x3FB7EE10,   0x550D8A20,
      /* end for i=24 */
      0x3FB8FFFF,   0x0ED3D82C,
      0x3FC618A1,   0x084FBEC9,
      0x3FB7D6C5,   0xE01A4D4B,
      0xBFD42427,   0x54154043,
      0xBFB887A6,   0x872DAFBD,
      0x3FEFB29C,   0xF4A3D2AC,
      0x3FB8EBC4,   0x55941020,
      /* end for i=25 */
      0x3FBA0007,   0xB7BBF805,
      0x3FC5D2E8,   0xE1382657,
      0x3FB8B268,   0xCD98937A,
      0xBFD40BE1,   0xA7C0102A,
      0xBFB978CF,   0xC0E09367,
      0x3FEFAC5C,   0xA9A8CEC7,
      0x3FB9E948,   0xF75FE6A0,
      /* end for i=26 */
      0x3FBB0003,   0x762C95EC,
      0x3FC58AFE,   0x2B6FDEEE,
      0x3FB98B3C,   0x71AA59E4,
      0xBFD3F2C2,   0xFB21C6A9,
      0xBFBA68C4,   0x782B2658,
      0x3FEFA5E0,   0x8C742935,
      0x3FBAE68D,   0xDE33F580,
      /* end for i=27 */
      0x3FBBFFF1,   0x47A4EDD9,
      0x3FC540EF,   0xAF10D05C,
      0x3FBA612A,   0xB3A34582,
      0xBFD3D8CE,   0x58AB2EF5,
      0xBFBB5779,   0xC0AB2446,
      0x3FEF9F28,   0xF859FB4A,
      0x3FBBE390,   0x32A00820,
      /* end for i=28 */
      0x3FBCFFF2,   0xC4E538E1,
      0x3FC4F4CC,   0x91B93501,
      0x3FBB343A,   0x771AC35A,
      0xBFD3BE03,   0x35373621,
      0xBFBC4504,   0xDED1B4A3,
      0x3FEF9835,   0x5778EF7D,
      0x3FBCE06F,   0x4C0C1F60,
      /* end for i=29 */
      0x3FBDFFF7,   0x9DA0AB48,
      0x3FC4A6A4,   0x51A7A41D,
      0x3FBC0449,   0x622E9F7F,
      0xBFD3A266,   0x228F117B,
      0xBFBD314C,   0xA006B2D7,
      0x3FEF9106,   0x6391A3A3,
      0x3FBDDD19,   0x2AD2FBE0,
      /* end for i=30 */
      0x3FBF0005,   0x77E895FD,
      0x3FC45686,   0xC0C2FBAA,
      0x3FBCD147,   0xED493EA2,
      0xBFD385F9,   0x836E2EE2,
      0xBFBE1C4C,   0x61A15B75,
      0x3FEF899C,   0x42A54E17,
      0x3FBED991,   0x853D68C0,
      /* end for i=31 */
      0x3FBFFFFE,   0xBF33FE04,
      0x3FC40483,   0xFF907361,
      0x3FBD9B0B,   0x5AB99951,
      0xBFD368C3,   0xCF8FDE64,
      0xBFBF05DF,   0x792FB49A,
      0x3FEF81F8,   0x2939FC5E,
      0x3FBFD5B9,   0x5ECF9F80,
      /* end for i=32 */
      0x3FC07FFA,   0x24396400,
      0x3FC3B0AC,   0x781A257F,
      0x3FBE618E,   0xC1CE7A2C,
      0xBFD34AC6,   0x6C09A284,
      0xBFBFEE0B,   0xFF3CD21C,
      0x3FEF7A19,   0xF6A393A1,
      0x3FC068CF,   0xC0DE26A0,
      /* end for i=33 */
      0x3FC0FFFC,   0xD6BC8115,
      0x3FC35B10,   0xD8C85B4E,
      0x3FBF24CF,   0x1ED2ED32,
      0xBFD32C02,   0x45167E88,
      0xBFC06A6D,   0x29D58085,
      0x3FEF7201,   0x667C3722,
      0x3FC0E6AA,   0xB1B78440,
      /* end for i=34 */
      0x3FC17FFD,   0x1B1F3B3A,
      0x3FC303C2,   0x0F2FEBB0,
      0x3FBFE4AB,   0x197D19DF,
      0xBFD30C7D,   0x23775AEA,
      0xBFC0DD17,   0x45404902,
      0x3FEF69AF,   0x790D3297,
      0x3FC16462,   0x69BD6BC0,
      /* end for i=35 */
      0x3FC1FFFE,   0x2AB37BE6,
      0x3FC2AAD1,   0x42D7F898,
      0x3FC0508B,   0x767BD76D,
      0xBFD2EC39,   0xA8C304CD,
      0xBFC14F02,   0xB98E57B1,
      0x3FEF6124,   0x585C3D3D,
      0x3FC1E1F9,   0x2ED17320,
      /* end for i=36 */
      0x3FC28006,   0x7215C8A6,
      0x3FC2504F,   0xCFF955C6,
      0x3FC0AD05,   0xDDF126D2,
      0xBFD2CB39,   0x9E649388,
      0xBFC1C030,   0xC16A2CE7,
      0x3FEF585F,   0xF21C4283,
      0x3FC25F74,   0x676C88A0,
      /* end for i=37 */
      0x3FC30002,   0xAF594C55,
      0x3FC1F44F,   0x4239DF29,
      0x3FC107AF,   0x4C15792E,
      0xBFD2A985,   0x8E999923,
      0xBFC2308C,   0x0C6BB7C6,
      0x3FEF4F63,   0xFE10D199,
      0x3FC2DCC0,   0x53836E40,
      /* end for i=38 */
      0x3FC38005,   0xD799F94F,
      0x3FC196E1,   0x4F660010,
      0x3FC1608D,   0xFA85CFEB,
      0xBFD2871C,   0x1E803140,
      0xBFC2A021,   0x0AD79CE6,
      0x3FEF462F,   0x90123C3D,
      0x3FC359EE,   0xA3991CE0,
      /* end for i=39 */
      0x3FC3FFFD,   0x6CF7A711,
      0x3FC13817,   0xD22AA5D4,
      0x3FC1B78E,   0x3687A3F0,
      0xBFD26405,   0xF6464584,
      0xBFC30EDB,   0x7FAFEB6F,
      0x3FEF3CC4,   0x66C05237,
      0x3FC3D6EC,   0x6572D1C0,
      /* end for i=40 */
      0x3FC47FFB,   0x734CF99F,
      0x3FC0D804,   0xC4D1D0E9,
      0x3FC20CB5,   0xBF8F75AF,
      0xBFD24041,   0xE38D707D,
      0xBFC37CC6,   0xFA1F8171,
      0x3FEF3321,   0x9B42AF37,
      0x3FC453CA,   0x5676BE40,
      /* end for i=41 */
      0x3FC50004,   0x507E226E,
      0x3FC076BA,   0x3C03EE4C,
      0x3FC26000,   0xDED1BEF5,
      0xBFD21BD2,   0x49E41B81,
      0xBFC3E9E3,   0x17C14898,
      0x3FEF2947,   0x3900C817,
      0x3FC4D08B,   0xDD654220,
      /* end for i=42 */
      0x3FC58000,   0x666AF138,
      0x3FC0144A,   0x61901950,
      0x3FC2B15A,   0x59F241E0,
      0xBFD1F6C1,   0xB28E2C90,
      0xBFC45617,   0xD5D6C398,
      0x3FEF1F37,   0x7FC88140,
      0x3FC54D19,   0x1DACDA00,
      /* end for i=43 */
      0x3FC60008,   0x26D882E8,
      0x3FBF618E,   0xDE7AB4E8,
      0x3FC300CC,   0x333CA839,
      0xBFD1D10C,   0xE42A8F7B,
      0xBFC4C176,   0x113D73DC,
      0x3FEF14F0,   0xF39C4EC1,
      0x3FC5C989,   0x09363F80,
      /* end for i=44 */
      0x3FC68004,   0x67BBBF20,
      0x3FBE9887,   0x534DD7CF,
      0x3FC34E42,   0xD84BCD38,
      0xBFD1AABE,   0x93DF6BDC,
      0xBFC52BE6,   0xA37366FC,
      0x3FEF0A75,   0xE1668BA6,
      0x3FC645C4,   0x45A23700,
      /* end for i=45 */
      0x3FC6FFFC,   0x1EF77762,
      0x3FBDCDA2,   0xB64AFDE7,
      0x3FC399BE,   0x07CB2F42,
      0xBFD183D8,   0xB6758144,
      0xBFC5956B,   0xE0071B14,
      0x3FEEFFC6,   0x34265101,
      0x3FC6C1D0,   0xC78FF620,
      /* end for i=46 */
      0x3FC78007,   0x038B1D13,
      0x3FBD0105,   0x9D8EDF00,
      0x3FC3E346,   0xECB82521,
      0xBFD15C57,   0xF3171165,
      0xBFC5FE15,   0xA2FB63A6,
      0x3FEEF4E0,   0x5C8DE469,
      0x3FC73DC4,   0xB1A68000,
      /* end for i=47 */
      0x3FC7FFFF,   0x035478A4,
      0x3FBC32D4,   0x96B38770,
      0x3FC42AC3,   0x88F1793A,
      0xBFD1344C,   0x06D62F4D,
      0xBFC665C1,   0x5B11EF24,
      0x3FEEE9C8,   0x0E60BA8C,
      0x3FC7B97A,   0x57B79FE0,
      /* end for i=48 */
      0x3FC88006,   0x81884CD9,
      0x3FBB6334,   0x1D078BF1,
      0x3FC47043,   0x6221C5EB,
      0xBFD10BAE,   0x3BDB57A1,
      0xBFC6CC87,   0x932FB0B2,
      0x3FEEDE7A,   0xC8A88FF1,
      0x3FC83512,   0x2A445B20,
      /* end for i=49 */
      0x3FC90000,   0xFAF40156,
      0x3FBA9248,   0x8FEDED0C,
      0x3FC4B3B3,   0x86076EEF,
      0xBFD0E28B,   0xA78B9F98,
      0xBFC7324E,   0x1F5366A0,
      0x3FEED2FB,   0x88084356,
      0x3FC8B06F,   0xD442F3A0,
      /* end for i=50 */
      0x3FC97FFD,   0x52AA491F,
      0x3FB9C036,   0x296A0216,
      0x3FC4F519,   0x02C33923,
      0xBFD0B8E3,   0xA71B9DAE,
      0xBFC7971D,   0xCD254631,
      0x3FEEC749,   0x7832AE92,
      0x3FC92BA0,   0xE9D89720,
      /* end for i=51 */
      0x3FCA0006,   0x77732109,
      0x3FB8ED20,   0xF4DA9FC4,
      0x3FC53476,   0x601B4A83,
      0xBFD08EB6,   0xAF76E5A7,
      0xBFC7FAFB,   0xFD5B19D0,
      0x3FEEBB64,   0x0DB6E727,
      0x3FC9A6AF,   0x1F46C5A0,
      /* end for i=52 */
      0x3FCA7FFC,   0x01279FB3,
      0x3FB8192C,   0xC5E788EA,
      0x3FC571B9,   0x64560EAA,
      0xBFD06413,   0x969E49B4,
      0xBFC85DCC,   0x852539EE,
      0x3FEEAF4E,   0xCDD6BC1F,
      0x3FCA217A,   0x8B422740,
      /* end for i=53 */
      0x3FCB0004,   0xFBCF1A61,
      0x3FB7447D,   0x2FA41197,
      0x3FC5ACF2,   0xC11837F3,
      0xBFD038F1,   0x7E216A16,
      0xBFC8BFAA,   0xACAE3341,
      0x3FEEA306,   0x88BEE82F,
      0x3FCA9C27,   0xE0B61040,
      /* end for i=54 */
      0x3FCB8002,   0x865F184F,
      0x3FB66F35,   0x7BE9B54C,
      0x3FC5E612,   0x53B48F0C,
      0xBFD00D5E,   0xE925BC50,
      0xBFC9207B,   0xFAE0217F,
      0x3FEE968E,   0xB1818E74,
      0x3FCB1698,   0xC127C160,
      /* end for i=55 */
      0x3FCBFFFA,   0x86BE3035,
      0x3FB59978,   0xA2ED38FB,
      0x3FC61D19,   0xD7A10F0D,
      0xBFCFC2BC,   0x2D64E0F8,
      0xBFC98042,   0x6C64112F,
      0x3FEE89E7,   0x41627660,
      0x3FCB90D2,   0x194E0980,
      /* end for i=56 */
      0x3FCC8005,   0x12E0381C,
      0x3FB4C369,   0x4310C862,
      0x3FC65212,   0x5D655F04,
      0xBFCF69D5,   0xB50079FB,
      0xBFC9DF0D,   0x4B305884,
      0x3FEE7D0E,   0x5369E007,
      0x3FCC0AEA,   0x22FCC4C0,
      /* end for i=57 */
      0x3FCCFFFC,   0x4849451F,
      0x3FB3ED29,   0x98F554F7,
      0x3FC684EB,   0x9A4FA3E9,
      0xBFCF102D,   0x14B31F3B,
      0xBFCA3CBE,   0x126D8EEA,
      0x3FEE7008,   0x3A6C6B5F,
      0x3FCC84BC,   0x0134F0A0,
      /* end for i=58 */
      0x3FCD8000,   0x341253A4,
      0x3FB316DB,   0x77CD529E,
      0x3FC6B5B2,   0x25F98390,
      0xBFCEB5B4,   0x4660C5C3,
      0xBFCA9969,   0xEBE41FD4,
      0x3FEE62D2,   0x3D86C014,
      0x3FCCFE65,   0x7F8F5040,
      /* end for i=59 */
      0x3FCDFFFC,   0x43E78450,
      0x3FB240A0,   0x41F2C3FA,
      0x3FC6E45E,   0x110A42D0,
      0xBFCE5A82,   0x270DB478,
      0xBFCAF4FF,   0x9AC32AB9,
      0x3FEE556F,   0x01345B40,
      0x3FCD77D2,   0x54D0D380,
      /* end for i=60 */
      0x3FCE7FFF,   0x4796C55E,
      0x3FB16A98,   0xE1C25DCC,
      0x3FC710F5,   0x207B5E53,
      0xBFCDFE94,   0x895BF964,
      0xBFCB4F87,   0x8B21CD83,
      0x3FEE47DD,   0x8221DA21,
      0x3FCDF10F,   0xD7CBD0E0,
      /* end for i=61 */
      0x3FCEFFFE,   0x06C78364,
      0x3FB094E5,   0xC2BD5E0C,
      0x3FC73B74,   0x0525BCE1,
      0xBFCDA1FB,   0xD25DD8CE,
      0xBFCBA8F7,   0xADFE7D84,
      0x3FEE3A1F,   0x79324080,
      0x3FCE6A12,   0xB15C51E0,
      /* end for i=62 */
      0x3FCF7FF8,   0x45A04CC7,
      0x3FAF7F4D,   0x95E711A9,
      0x3FC763DB,   0xDCA42D02,
      0xBFCD44C0,   0x977CB1C9,
      0xBFCC014D,   0xF8297CCE,
      0x3FEE2C35,   0x7C4BF768,
      0x3FCEE2D9,   0xFBB6CBE0,
      /* end for i=63 */
      0x3FD00003,   0x598B10A3,
      0x3FADD5F6,   0xA96D2589,
      0x3FC78A35,   0x59D32E98,
      0xBFCCE6D9,   0x14ACCC60,
      0xBFCC5899,   0x5AD30C85,
      0x3FEE1E1D,   0x60362EAA,
      0x3FCF5B7C,   0x475F5F20,
      /* end for i=64 */
      0x3FD04002,   0x0D4036D2,
      0x3FAC2E04,   0x51302C1C,
      0x3FC7AE76,   0xDC098525,
      0xBFCC8868,   0xDB81C387,
      0xBFCCAEBE,   0xA2ACCF72,
      0x3FEE0FDB,   0xC86F702A,
      0x3FCFD3D5,   0xD721E580,
      /* end for i=65 */
      0x3FD07FFF,   0xDEF46757,
      0x3FAA87B2,   0xEF660B35,
      0x3FC7D0A7,   0x0E2671E7,
      0xBFCC296D,   0x120BC9CD,
      0xBFCD03C6,   0x9FE471F8,
      0x3FEE016F,   0x9914519F,
      0x3FD025FA,   0x320A0B00,
      /* end for i=66 */
      0x3FD0BFFC,   0x71D7FAEE,
      0x3FA8E33D,   0xAC82D016,
      0x3FC7F0C8,   0x06FA909F,
      0xBFCBC9EE,   0x877CC966,
      0xBFCD57AF,   0x4B36CC5E,
      0x3FEDF2D9,   0x779CC9A3,
      0x3FD061EB,   0x4C6DF1A0,
      /* end for i=67 */
      0x3FD10002,   0x24F319B4,
      0x3FA740DE,   0x6CFDF6CD,
      0x3FC80EE1,   0x121754D2,
      0xBFCB69E5,   0xE00A2BA4,
      0xBFCDAA84,   0x87BDD6CA,
      0x3FEDE417,   0x8E5101BD,
      0x3FD09DC7,   0x989D8F20,
      /* end for i=68 */
      0x3FD14003,   0x0084E87F,
      0x3FA5A0CD,   0xC7B273C7,
      0x3FC82AEE,   0x2914DA71,
      0xBFCB0970,   0x2F47D9A8,
      0xBFCDFC32,   0xBD18A348,
      0x3FEDD52D,   0xA1472641,
      0x3FD0D981,   0xB181E460,
      /* end for i=69 */
      0x3FD17FFC,   0x711C36F7,
      0x3FA40342,   0xFCDA211D,
      0x3FC844F1,   0xC544C0C2,
      0xBFCAA899,   0x97845269,
      0xBFCE4CB5,   0xA43D2E8D,
      0x3FEDC61C,   0xE69147E4,
      0x3FD11516,   0xE69E7780,
      /* end for i=70 */
      0x3FD1C003,   0xD64C6E7E,
      0x3FA26873,   0xEDA4E352,
      0x3FC85CF7,   0x91B15283,
      0xBFCA4749,   0xC28ECC6D,
      0xBFCE9C26,   0xBE36865C,
      0x3FEDB6E0,   0xE0DA7D6E,
      0x3FD1509A,   0xCAC00140,
      /* end for i=71 */
      0x3FD20003,   0xD8F221C6,
      0x3FA0D095,   0x146B8D3A,
      0x3FC872FA,   0xC92980EF,
      0xBFC9E5A9,   0x165EE361,
      0xBFCEEA6A,   0x43BBBFC7,
      0x3FEDA77F,   0x2FC305D4,
      0x3FD18BF9,   0x33CAE8C0,
      /* end for i=72 */
      0x3FD24002,   0xAB8FF74F,
      0x3F9E77B2,   0xFAFC813C,
      0x3FC88701,   0xC083D46E,
      0xBFC983B6,   0x28AB0C40,
      0xBFCF3786,   0xFB78C05A,
      0x3FED97F6,   0xF05B05BE,
      0x3FD1C737,   0x995681E0,
      /* end for i=73 */
      0x3FD27FFC,   0x73448976,
      0x3F9B54E5,   0x811B8202,
      0x3FC8990F,   0x9783220B,
      0xBFC9217E,   0xD24405A5,
      0xBFCF8377,   0x7AED8AD8,
      0x3FED8849,   0xAAA639D2,
      0x3FD20252,   0x213C5CE0,
      /* end for i=74 */
      0x3FD2BFFE,   0xF1A9D16A,
      0x3F983921,   0xF55DD00F,
      0x3FC8A92C,   0x4CD36C4D,
      0xBFC8BEF5,   0xC50C4FC5,
      0xBFCFCE4B,   0x2435100D,
      0x3FED7874,   0x8FC58540,
      0x3FD23D55,   0x32405B40,
      /* end for i=75 */
      0x3FD30001,   0x4A400179,
      0x3F9524C5,   0x91EE4E90,
      0x3FC8B759,   0xC4F4C9B4,
      0xBFC85C30,   0x5D3C057E,
      0xBFD00BFB,   0x4F68BF35,
      0x3FED687A,   0x5D120375,
      0x3FD27838,   0x4FD83120,
      /* end for i=76 */
      0x3FD34003,   0x4087F882,
      0x3F92182A,   0x876183E0,
      0x3FC8C39C,   0xB5F5FFD5,
      0xBFC7F936,   0xAC8999F7,
      0xBFD0303C,   0x7F510390,
      0x3FED585B,   0xB64C5F72,
      0x3FD2B2FA,   0xF9116BC0,
      /* end for i=77 */
      0x3FD37FFF,   0xAABBAE79,
      0x3F8E274F,   0xE894A79D,
      0x3FC8CDF9,   0x5AB330F2,
      0xBFC79618,   0x551EDECC,
      0xBFD053E6,   0x00390DD2,
      0x3FED481A,   0x81D0B30B,
      0x3FD2ED98,   0x2C7C32E0,
      /* end for i=78 */
      0x3FD3BFFE,   0x3421C71D,
      0x3F882F23,   0xBBEEBEDB,
      0x3FC8D676,   0x4162046E,
      0xBFC732D1,   0x0401F76C,
      0xBFD076FB,   0xE61924F7,
      0x3FED37B5,   0x646D66A5,
      0x3FD32816,   0xABD39460,
      /* end for i=79 */
      0x3FD3FFFD,   0x76BC2781,
      0x3F824872,   0x54A9EBD2,
      0x3FC8DD18,   0x776F523E,
      0xBFC6CF6A,   0x57C7E737,
      0xBFD0997D,   0x2FD1341F,
      0x3FED272D,   0x4C62744A,
      0x3FD36274,   0xE7879480,
      /* end for i=80 */
      0x3FD43FFE,   0x187E097E,
      0x3F78E7AE,   0x6BBC4F67,
      0x3FC8E1E5,   0x85913853,
      0xBFC66BEA,   0xAD856714,
      0xBFD0BB6A,   0x07B9638A,
      0x3FED1682,   0xA2372EFC,
      0x3FD39CB3,   0x30516260,
      /* end for i=81 */
      0x3FD48003,   0x69B2C803,
      0x3F6AC79E,   0x48743285,
      0x3FC8E4E3,   0x2820694F,
      0xBFC60854,   0x26123F70,
      0xBFD0DCC3,   0xFD748FD8,
      0x3FED05B5,   0x197DC032,
      0x3FD3D6D4,   0x418CF740,
      /* end for i=82 */
      0x3FD4C002,   0xDAFF3065,
      0x3F403324,   0x5D7C8360,
      0x3FC8E616,   0xDA26E53E,
      0xBFC5A4BE,   0x61DAA358,
      0xBFD0FD85,   0x82EA5306,
      0x3FECF4C8,   0x0E08B495,
      0x3FD410CE,   0x42E38400,
      /* end for i=83 */
      0x3FD4FFFF,   0xA6A3E6A6,
      0xBF625F00,   0xB06A6A26,
      0x3FC8E587,   0x1DDB8407,
      0xBFC5412B,   0x76AB97E8,
      0xBFD11DB0,   0x559D9178,
      0x3FECE3BB,   0x4141F23E,
      0x3FD44AA3,   0xE61628C0,
      /* end for i=84 */
      0x3FD53FFD,   0x46588041,
      0xBF743CDB,   0x37C52A8E,
      0x3FC8E33A,   0x3F5FDB61,
      0xBFC4DD9C,   0xFCE57FCF,
      0xBFD13D46,   0x3E8D420F,
      0x3FECD28E,   0x5CCB463E,
      0x3FD48458,   0x106FBF60,
      /* end for i=85 */
      0x3FD57FFD,   0x7A7512C8,
      0xBF7F20B4,   0x780BB5C9,
      0x3FC8DF36,   0x73D28B34,
      0xBFC47A17,   0x237A08B2,
      0xBFD15C48,   0x1CE2D324,
      0x3FECC141,   0x7B169FD9,
      0x3FD4BDEC,   0x14547160,
      /* end for i=86 */
      0x3FD5BFFE,   0x44FF6C97,
      0xBF84ED10,   0x96CA9C11,
      0x3FC8D982,   0x4977D436,
      0xBFC416A3,   0xD2D45BF1,
      0xBFD17AB5,   0x0689AE30,
      0x3FECAFD5,   0xB8F53D4A,
      0x3FD4F75D,   0xE663E1E0,
      /* end for i=87 */
      0x3FD60002,   0x2966868E,
      0xBF8A3421,   0x89AE252C,
      0x3FC8D224,   0x14E71C06,
      0xBFC3B345,   0xD9866FE6,
      0xBFD1988E,   0x42B411FB,
      0x3FEC9E4A,   0xF9D9347E,
      0x3FD530AF,   0x883D0300,
      /* end for i=88 */
      0x3FD63FFE,   0xDDC2492C,
      0xBF8F6524,   0x3EFD1EAF,
      0x3FC8C924,   0x0201C854,
      0xBFC35013,   0xC60AD617,
      0xBFD1B5CF,   0x3FB8E323,
      0x3FEC8CA4,   0xA76667ED,
      0x3FD569D7,   0x8B29AAE0,
      /* end for i=89 */
      0x3FD68003,   0x84D6D63D,
      0xBF923FDB,   0x12CE16E7,
      0x3FC8BE86,   0xDD1614A3,
      0xBFC2ECFC,   0xA01986F5,
      0xBFD1D27F,   0x1C7186E8,
      0x3FEC7ADF,   0x292F9FA8,
      0x3FD5A2E3,   0x391D15E0,
      /* end for i=90 */
      0x3FD6C000,   0x5C9A12D0,
      0xBF94C1BD,   0x73880E00,
      0x3FC8B256,   0x53216046,
      0xBFC28A1F,   0x2CC39BD7,
      0xBFD1EE97,   0x0858E953,
      0x3FEC68FF,   0x7386956E,
      0x3FD5DBC4,   0x4DF51F20,
      /* end for i=91 */
      0x3FD70000,   0xB28CA9BA,
      0xBF97380E,   0x2DEA84CA,
      0x3FC8A497,   0x93910872,
      0xBFC22770,   0x356BBFC6,
      0xBFD20A1C,   0x51F82D8C,
      0x3FEC5702,   0xF55C159C,
      0x3FD61484,   0xA12A63E0,
      /* end for i=92 */
      0x3FD73FFD,   0x12FE974B,
      0xBF99A2A5,   0x3F0A4120,
      0x3FC89553,   0x83497C06,
      0xBFC1C501,   0x5DFFF182,
      0xBFD2250C,   0x190A1B78,
      0x3FEC44EC,   0x5B0FCAF2,
      0x3FD64D1D,   0x608750A0,
      /* end for i=93 */
      0x3FD78000,   0xB26ECA0A,
      0xBF9C015D,   0xAD6548C9,
      0x3FC8848E,   0xB8068DFC,
      0xBFC162C7,   0x7905883B,
      0xBFD23F6B,   0x655D558E,
      0x3FEC32B9,   0x0B587397,
      0x3FD68598,   0x3C9B6D40,
      /* end for i=94 */
      0x3FD7BFFE,   0xEC82C8D5,
      0xBF9E5415,   0x80B51900,
      0x3FC87253,   0xE6B4EA6D,
      0xBFC100DB,   0xDBE64D50,
      0xBFD25935,   0x5FD1F6FF,
      0x3FEC206D,   0x3080B555,
      0x3FD6BDE9,   0xD7A71F40,
      /* end for i=95 */
      0x3FD80002,   0xC41F7A09,
      0xBFA04D56,   0xDC8468D0,
      0x3FC85EA7,   0x7564D189,
      0xBFC09F33,   0x7D01031E,
      0xBFD2726E,   0xE513AFF7,
      0x3FEC0E06,   0x3766C976,
      0x3FD6F61B,   0xAEB6C9E0,
      /* end for i=96 */
      0x3FD84002,   0x971A203F,
      0xBFA16A85,   0x2297D704,
      0x3FC84993,   0xE92EA187,
      0xBFC03DE2,   0xC2136829,
      0xBFD28B14,   0x99E28410,
      0x3FEBFB87,   0x767FF102,
      0x3FD72E25,   0x1914E1A0,
      /* end for i=97 */
      0x3FD87FFC,   0x4BFD3715,
      0xBFA28188,   0xFC3E1A45,
      0x3FC83321,   0xF4B8C048,
      0xBFBFB9E4,   0xB3F449D5,
      0xBFD2A326,   0x505B3A99,
      0x3FEBE8F2,   0x20EB6352,
      0x3FD76604,   0x17AA1220,
      /* end for i=98 */
      0x3FD8C000,   0xF5A9E443,
      0xBFA39257,   0x3FF44795,
      0x3FC81B53,   0x2F155DA4,
      0xBFBEF89B,   0xC5DF77C5,
      0xBFD2BAAA,   0xEB23E33E,
      0x3FEBD641,   0xCFC07E6A,
      0x3FD79DC7,   0x5F454BE0,
      /* end for i=99 */
      0x3FD90002,   0x14E95313,
      0xBFA49CE6,   0x2B5242A0,
      0x3FC80234,   0x8A302AEF,
      0xBFBE3821,   0x47AAA0EF,
      0xBFD2D19D,   0x8C764A40,
      0x3FEBC37B,   0x4B397470,
      0x3FD7D562,   0x19C00A40,
      /* end for i=100 */
      0x3FD94003,   0xB8B9BEA1,
      0xBFA5A12D,   0x5D0AC72B,
      0x3FC7E7CC,   0x5B61D743,
      0xBFBD7873,   0x6164D33A,
      0xBFD2E800,   0x49D4B6D5,
      0x3FEBB09D,   0xF497C878,
      0x3FD80CD7,   0xA27BD760,
      /* end for i=101 */
      0x3FD97FFE,   0x262AA3B2,
      0xBFA69F25,   0xCEA8B928,
      0x3FC7CC25,   0xE3EA2BB8,
      0xBFBCB9B3,   0x426BDBEF,
      0xBFD2FDD1,   0x240F5ED1,
      0x3FEB9DAC,   0xA65594F3,
      0x3FD84421,   0x1FF4D8C0,
      /* end for i=102 */
      0x3FD9BFFF,   0x298E6DE8,
      0xBFA796C9,   0xCE0DF17C,
      0x3FC7AF43,   0x17C29F48,
      0xBFBBFBC1,   0xAF5ADA9E,
      0xBFD31315,   0x77A8999D,
      0x3FEB8AA3,   0xDA045CF3,
      0x3FD87B4A,   0x538DD8A0,
      /* end for i=103 */
      0x3FDA0002,   0x5DBA5EBF,
      0xBFA88814,   0xF6B7B720,
      0x3FC7912D,   0x9F46D7D5,
      0xBFBB3EB5,   0x8EFAD5FB,
      0xBFD327CC,   0x5EBCBF35,
      0x3FEB7785,   0x6850E036,
      0x3FD8B24F,   0x4135CC20,
      /* end for i=104 */
      0x3FDA3FFC,   0xF36181DE,
      0xBFA97304,   0x2ACD0C60,
      0x3FC771F2,   0xAD5162A3,
      0xBFBA82B8,   0x1648C3F4,
      0xBFD33BF3,   0x2395EFC7,
      0x3FEB6455,   0x1C9C9628,
      0x3FD8E926,   0x7AC09320,
      /* end for i=105 */
      0x3FDA8001,   0x817BA6A8,
      0xBFAA5795,   0x8BFAEDBB,
      0x3FC75191,   0x1A49FCD2,
      0xBFB9C79B,   0xDBC1B869,
      0xBFD34F90,   0x582550DC,
      0x3FEB510D,   0xF00486F6,
      0x3FD91FDF,   0xC5E186A0,
      /* end for i=106 */
      0x3FDABFFC,   0x89D665D4,
      0xBFAB35C8,   0x74229447,
      0x3FC7301A,   0xB431AF38,
      0xBFB90DA2,   0xC7FF1FB4,
      0xBFD3629E,   0xC427B22E,
      0x3FEB3DB6,   0x4D47DFA8,
      0x3FD9566A,   0x514345C0,
      /* end for i=107 */
      0x3FDB0003,   0x187116E8,
      0xBFAC0D9D,   0x6DDDBFDF,
      0x3FC70D8C,   0x62DFA6B2,
      0xBFB85498,   0x6953E837,
      0xBFD37525,   0x6EC6F36F,
      0x3FEB2A48,   0x6237DFD9,
      0x3FD98CD7,   0xE603F700,
      /* end for i=108 */
      0x3FDB3FFF,   0x6600FD9C,
      0xBFACDF16,   0x2CDCFE74,
      0x3FC6E9F9,   0xD360B957,
      0xBFB79CC4,   0x26E7D59C,
      0xBFD3871E,   0xD5D75898,
      0x3FEB16CB,   0x54DC2AF8,
      0x3FD9C315,   0xDA68A5A0,
      /* end for i=109 */
      0x3FDB8002,   0xE1312A99,
      0xBFADAA35,   0x8623D519,
      0x3FC6C561,   0x5A2F49D9,
      0xBFB6E5FC,   0x06CEB224,
      0xBFD39890,   0xBE78E24E,
      0x3FEB033A,   0x613EF691,
      0x3FD9F932,   0xD46263A0,
      /* end for i=110 */
      0x3FDBC000,   0x6A8A61D3,
      0xBFAE6EFF,   0x68269DA3,
      0x3FC69FD2,   0x5D70B420,
      0xBFB6306D,   0x78B69046,
      0xBFD3A978,   0x6CA6BED5,
      0x3FEAEF9A,   0x12BD87A3,
      0x3FDA2F23,   0x980C7D40,
      /* end for i=111 */
      0x3FDC0002,   0x6A1E5325,
      0xBFAF2D78,   0xD2CDD83C,
      0x3FC6794E,   0xB257AB45,
      0xBFB57C02,   0x9BEB8350,
      0xBFD3B9D9,   0x8654FDD7,
      0x3FEADBE7,   0xC1109E16,
      0x3FDA64F0,   0xCA9C8AE0,
      /* end for i=112 */
      0x3FDC4000,   0xD9772DF4,
      0xBFAFE5A7,   0xCF629BEE,
      0x3FC651E3,   0x08A764BA,
      0xBFB4C8D9,   0x863473E5,
      0xBFD3C9B2,   0xE1F2049B,
      0x3FEAC826,   0x6B59233F,
      0x3FDA9A93,   0x8B9F9D00,
      /* end for i=113 */
      0x3FDC8001,   0x3854B25F,
      0xBFB04BC9,   0xB433DDC5,
      0x3FC62993,   0xDEDF5939,
      0xBFB416E9,   0xF854FAED,
      0xBFD3D906,   0xCDD1D654,
      0x3FEAB454,   0xE6020D2D,
      0x3FDAD010,   0x58C6F160,
      /* end for i=114 */
      0x3FDCBFFD,   0x0ED73A27,
      0xBFB0A1A1,   0xD0B18ED4,
      0x3FC6006D,   0x240A2551,
      0xBFB3664C,   0xCCE2A142,
      0xBFD3E7D4,   0xB74218D1,
      0x3FEAA075,   0xB820B839,
      0x3FDB0561,   0xADFCDEC0,
      /* end for i=115 */
      0x3FDCFFFD,   0xE2FA6105,
      0xBFB0F460,   0xB74D5781,
      0x3FC5D670,   0x7A4F5CCF,
      0xBFB2B6EE,   0x728BF731,
      0xBFD3F61F,   0xC7DB0F69,
      0x3FEA8C86,   0x70D869BF,
      0x3FDB3A8F,   0x5CC9F740,
      /* end for i=116 */
      0x3FDD4001,   0xC161AB30,
      0xBFB1440B,   0x56641EF1,
      0x3FC5ABA6,   0xBB558890,
      0xBFB208DA,   0xF7C183ED,
      0xBFD403E8,   0x733E1B52,
      0x3FEA7888,   0x2C8638EB,
      0x3FDB6F97,   0xA22F8480,
      /* end for i=117 */
      0x3FDD7FFC,   0x0F8A3078,
      0xBFB190A7,   0x0C63BA3A,
      0x3FC58020,   0x1E04351E,
      0xBFB15C3A,   0xA730F904,
      0xBFD4112D,   0x17420274,
      0x3FEA647F,   0x5F7C569A,
      0x3FDBA46F,   0xF7C76140,
      /* end for i=118 */
      0x3FDDBFFC,   0x7DC21E40,
      0xBFB1DA39,   0xA3A086DD,
      0x3FC553D9,   0xA37F8F20,
      0xBFB0B0E9,   0x0C1DA6FE,
      0xBFD41DF2,   0x047F3BCD,
      0x3FEA5067,   0xA29F2823,
      0x3FDBD925,   0x3BAF51E0,
      /* end for i=119 */
      0x3FDE0001,   0xDF71EF3E,
      0xBFB220C9,   0x4E2B2353,
      0x3FC526DB,   0x7B1D6E45,
      0xBFB006EF,   0x669450F5,
      0xBFD42A37,   0xE7444F61,
      0x3FEA3C41,   0xD1783997,
      0x3FDC0DB6,   0x52623080,
      /* end for i=120 */
      0x3FDE4002,   0xC52FCA98,
      0xBFB2645C,   0xA1A7B8FA,
      0x3FC4F933,   0xC44CF181,
      0xBFAEBCD8,   0x965D0FCD,
      0xBFD435FD,   0xFD15CAAE,
      0x3FEA2811,   0x63858A09,
      0x3FDC421B,   0x639FFA20,
      /* end for i=121 */
      0x3FDE7FFF,   0xB2BB43AF,
      0xBFB2A4FA,   0x93283D05,
      0x3FC4CAE9,   0xB1282469,
      0xBFAD6EC6,   0xBD02E1F9,
      0xBFD44145,   0x892F8247,
      0x3FEA13D6,   0xAFF40914,
      0x3FDC7654,   0xCBB5B1E0,
      /* end for i=122 */
      0x3FDEBFFF,   0x6E03863D,
      0xBFB2E2AA,   0x730B003C,
      0x3FC49BFF,   0xBBEDB6FC,
      0xBFAC238F,   0xE8C743DC,
      0xBFD44C10,   0xD6628FFE,
      0x3FE9FF90,   0x102FEA3C,
      0x3FDCAA67,   0xFC583F40,
      /* end for i=123 */
      0x3FDF0003,   0x15A394CA,
      0xBFB31D73,   0xE8DED776,
      0x3FC46C7C,   0x43EC698B,
      0xBFAADB38,   0x6859544E,
      0xBFD45661,   0x1AEC6C5B,
      0x3FE9EB3D,   0xA3EDED63,
      0x3FDCDE55,   0xC2C0C600,
      /* end for i=124 */
      0x3FDF4002,   0x29118307,
      0xBFB3555E,   0xEF4E188A,
      0x3FC43C6C,   0xD13922B4,
      0xBFA995F4,   0xFBBC0F5A,
      0xBFD46036,   0x170F5C30,
      0x3FE9D6E2,   0x996A3AAE,
      0x3FDD1217,   0x254F9880,
      /* end for i=125 */
      0x3FDF8001,   0xD0B11AC3,
      0xBFB38A73,   0xD011998B,
      0x3FC40BD4,   0xB371DB4F,
      0xBFA853B3,   0xE11FE39F,
      0xBFD46991,   0xC180889E,
      0x3FE9C27D,   0xC795767C,
      0x3FDD45B0,   0x3FFF3B80,
      /* end for i=126 */
      0x3FDFBFFE,   0x02421E0F,
      0xBFB3BCBB,   0x1FECD1C7,
      0x3FC3DABE,   0x10F67EC3,
      0xBFA71491,   0x8670D207,
      0xBFD47274,   0xAEA4FFB3,
      0x3FE9AE10,   0xF1732E28,
      0x3FDD791D,   0xC1010D20,
      /* end for i=127 */
      0x3FDFFFFD,   0x77860B71,
      0xBFB3EC3D,   0xBAB42E12,
      0x3FC3A92A,   0xB7E659E5,
      0xBFA5D874,   0x3753338E,
      0xBFD47AE0,   0xF4ACA54F,
      0x3FE9999A,   0x691CC77F,
      0x3FDDAC64,   0xFE99BC40,
      /* end for i=128 */
      0x3FE01FFF,   0x820960E7,
      0xBFB41904,   0xBF5E9BA9,
      0x3FC37722,   0x622B7D28,
      0xBFA49F69,   0x8F63651D,
      0xBFD482D7,   0x8692FFCB,
      0x3FE9851B,   0x0418558C,
      0x3FDDDF84,   0xF2192B60,
      /* end for i=129 */
      0x3FE04001,   0x522FCE4F,
      0xBFB44319,   0x8C233F19,
      0x3FC344AB,   0xD16550F2,
      0xBFA36978,   0xEDD26166,
      0xBFD48A59,   0x84AD67DA,
      0x3FE97093,   0x3829CCC6,
      0x3FDE127D,   0x84BD7660,
      /* end for i=130 */
      0x3FE06000,   0xEEBF6E5C,
      0xBFB46A85,   0xBAA43E83,
      0x3FC311D2,   0xD90FECFE,
      0xBFA236C8,   0x1A777197,
      0xBFD49167,   0x6186C2B0,
      0x3FE95C05,   0x8E00835C,
      0x3FDE4549,   0x80D535A0,
      /* end for i=131 */
      0x3FE07FFE,   0xB5ABB81A,
      0xBFB48F53,   0x1C2778DB,
      0x3FC2DE9D,   0x8FAEC973,
      0xBFA10759,   0x1FCDAB57,
      0xBFD49802,   0x78A6CB8B,
      0x3FE94772,   0x3D9A23C0,
      0x3FDE77E9,   0x7530A5E0,
      /* end for i=132 */
      0x3FE0A001,   0x407D077D,
      0xBFB4B18B,   0xB5DDF61E,
      0x3FC2AB07,   0xD8CFA7A6,
      0xBF9FB5E7,   0x2B6A0A2A,
      0xBFD49E2D,   0x4A9FFE0F,
      0x3FE932D5,   0x793EB836,
      0x3FDEAA67,   0xC08CC740,
      /* end for i=133 */
      0x3FE0C002,   0x024228BD,
      0xBFB4D139,   0xBD3ACEE9,
      0x3FC27722,   0x9E4337DA,
      0xBF9D63B5,   0x835DE6CF,
      0xBFD4A3E7,   0xBA0BF659,
      0x3FE91E33,   0xE888CE3B,
      0x3FDEDCB9,   0xFB91B920,
      /* end for i=134 */
      0x3FE0DFFF,   0xA4F8E941,
      0xBFB4EE67,   0x945A3C9C,
      0x3FC242F6,   0x6A7F39C1,
      0xBF9B183E,   0x7E71514B,
      0xBFD4A932,   0xDAAFF8AB,
      0x3FE9098E,   0xD8AE12ED,
      0x3FDF0EDE,   0x0A822040,
      /* end for i=135 */
      0x3FE0FFFE,   0x049B29C2,
      0xBFB5091F,   0xC679761E,
      0x3FC20E83,   0x2D2AD5C1,
      0xBF98D343,   0xA112171F,
      0xBFD4AE10,   0x95569918,
      0x3FE8F4E4,   0x3AD6D4A4,
      0x3FDF40D9,   0xF3E6DFA0,
      /* end for i=136 */
      0x3FE11FFF,   0x6E501DB6,
      0xBFB5216D,   0x047FF072,
      0x3FC1D9CB,   0x2CE95233,
      0xBF9694A4,   0xA30FB1EA,
      0xBFD4B282,   0x6AFAD8A5,
      0x3FE8E032,   0xFE81A9E7,
      0x3FDF72B1,   0x3F23A420,
      /* end for i=137 */
      0x3FE13FFF,   0x64EC83C7,
      0xBFB5375A,   0x219A8DCB,
      0x3FC1A4DB,   0xC7DA1BF5,
      0xBF945CBA,   0x324C9A5D,
      0xBFD4B688,   0xF038BB5D,
      0x3FE8CB7E,   0x7607A2C2,
      0x3FDFA45C,   0xE2B10900,
      /* end for i=138 */
      0x3FE16000,   0x1EEF57DF,
      0xBFB54AF2,   0x0FE9396D,
      0x3FC16FB7,   0x39B94854,
      0xBF922B63,   0xAD49154A,
      0xBFD4BA25,   0xAD719DF6,
      0x3FE8B6C5,   0x9D81BCC4,
      0x3FDFD5E0,   0x47284400,
      /* end for i=139 */
      0x3FE17FFE,   0x66CFD682,
      0xBFB55C3F,   0xDD3F62CD,
      0x3FC13A68,   0xA1881ABC,
      0xBF9000DE,   0xF754112D,
      0xBFD4BD59,   0x8CFC5352,
      0x3FE8A20A,   0xF2655545,
      0x3FE0039B,   0x38C57BC0,
      /* end for i=140 */
      0x3FE19FFE,   0xBD5BCAF1,
      0xBFB56B4E,   0xAFF7BEE5,
      0x3FC104EE,   0x2A9FF924,
      0xBF8BB9C6,   0x9A3A5936,
      0xBFD4C026,   0x44077BAE,
      0x3FE88D4B,   0xF1D15745,
      0x3FE01C33,   0x26F67D40,
      /* end for i=141 */
      0x3FE1BFFE,   0x4EC3D7CD,
      0xBFB57829,   0xC3DBAC54,
      0x3FC0CF52,   0x1B61CFDC,
      0xBF877F4C,   0x69AAF237,
      0xBFD4C28C,   0xCDD1EEDD,
      0x3FE8788A,   0xD78EE232,
      0x3FE034B5,   0xBDD7F480,
      /* end for i=142 */
      0x3FE1E000,   0x03F898B9,
      0xBFB582DC,   0x671E8F0D,
      0x3FC09995,   0x053D46F9,
      0xBF8351F5,   0xD2847A7C,
      0xBFD4C48E,   0x9D774739,
      0x3FE863C6,   0x25CCE9B0,
      0x3FE04D25,   0x344A1720,
      /* end for i=143 */
      0x3FE20000,   0xDAC75EC3,
      0xBFB58B71,   0xF76D7AD5,
      0x3FC063C1,   0x4AF7C500,
      0xBF7E645D,   0xACD8681F,
      0xBFD4C62C,   0xBF20396F,
      0x3FE84F00,   0x34708774,
      0x3FE0657F,   0x3B0CD760,
      /* end for i=144 */
      0x3FE22001,   0xB8398888,
      0xBFB591F5,   0xDF13BCB5,
      0x3FC02DDA,   0xA73029A7,
      0xBF763FBD,   0x9006E719,
      0xBFD4C768,   0x855883A4,
      0x3FE83A38,   0xD1E2335D,
      0x3FE07DC4,   0x7F9ABF40,
      /* end for i=145 */
      0x3FE24001,   0x90783656,
      0xBFB59673,   0x9236D31E,
      0x3FBFEFCF,   0xF7A8CC68,
      0xBF6C6CAC,   0xB3498475,
      0xBFD4C843,   0x2DC70F45,
      0x3FE82571,   0x0DD0677F,
      0x3FE095F4,   0x36906680,
      /* end for i=146 */
      0x3FE25FFF,   0x3AF1FA81,
      0xBFB598F6,   0x8C52F5FA,
      0x3FBF83E0,   0x7EEB4F1B,
      0xBF5921D0,   0x5FC335BE,
      0xBFD4C8BE,   0x0295837E,
      0x3FE810AA,   0x095F4C87,
      0x3FE0AE0D,   0x820865C0,
      /* end for i=147 */
      0x3FE27FFF,   0xC06D5AC0,
      0xBFB5998A,   0x51ED9C5E,
      0x3FBF17DF,   0xAFDA1185,
      0x3F38B24A,   0x4AF9BBF4,
      0xBFD4C8DA,   0x57E7AECA,
      0x3FE7FBE0,   0xDEAB80F2,
      0x3FE0C614,   0x2BB57840,
      /* end for i=148 */
      0x3FE2A001,   0x768E94A4,
      0xBFB5983A,   0x550AC744,
      0x3FBEABDC,   0xB833BE5F,
      0x3F62880B,   0x7CA0EED5,
      0xBFD4C899,   0x5E6DB132,
      0x3FE7E717,   0x00859D34,
      0x3FE0DE06,   0xEF71D260,
      /* end for i=149 */
      0x3FE2BFFF,   0xAF7006EB,
      0xBFB59512,   0x271CC69E,
      0x3FBE3FF0,   0xB783B1D4,
      0x3F70E112,   0xBD204381,
      0xBFD4C7FC,   0x6D99CD56,
      0x3FE7D24F,   0xD59725DA,
      0x3FE0F5E2,   0x4F6EEE00,
      /* end for i=150 */
      0x3FE2E001,   0x5B082EDE,
      0xBFB5901D,   0x4153F658,
      0x3FBDD40D,   0x63E09B04,
      0x3F7863F6,   0x417FD1FA,
      0xBFD4C704,   0xA77B5EBF,
      0x3FE7BD87,   0x37E0064E,
      0x3FE10DAB,   0x78A5C340,
      /* end for i=151 */
      0x3FE30001,   0x02352FC5,
      0xBFB58967,   0x1CF68398,
      0x3FBD684E,   0x0DCDE47F,
      0x3F7FCB6C,   0x545152CD,
      0xBFD4C5B3,   0x73E44871,
      0x3FE7A8C1,   0x0E158227,
      0x3FE1255E,   0x5AE3BCA0,
      /* end for i=152 */
      0x3FE32000,   0xF0C6A9A1,
      0xBFB580FB,   0x2C0603BB,
      0x3FBCFCB3,   0xA13D2D7F,
      0x3F838C03,   0xC6FFAD7B,
      0xBFD4C40A,   0x052E1F1E,
      0x3FE793FC,   0x335CB7FF,
      0x3FE13CFC,   0xAC834BE0,
      /* end for i=153 */
      0x3FE34001,   0x247A472C,
      0xBFB576E4,   0xD7119319,
      0x3FBC9146,   0x974110A8,
      0x3F8724E8,   0x9FAB7065,
      0xBFD4C209,   0x9C01F372,
      0x3FE77F39,   0x00CEDE64,
      0x3FE15486,   0x6CFA1940,
      /* end for i=154 */
      0x3FE36000,   0xAE54FC73,
      0xBFB56B2F,   0x7B2902C9,
      0x3FBC2612,   0x48965836,
      0x3F8AB050,   0x63C22778,
      0xBFD4BFB3,   0x8B2941BA,
      0x3FE76A78,   0x67C41214,
      0x3FE16BFA,   0xEEE25800,
      /* end for i=155 */
      0x3FE38001,   0x5F83007B,
      0xBFB55DE6,   0x67E5E562,
      0x3FBBBB18,   0x9F139D55,
      0x3F8E2E75,   0x9CD56DE7,
      0xBFD4BD08,   0xF05F01C3,
      0x3FE755B9,   0x8FAEE8E6,
      0x3FE1835B,   0x891253A0,
      /* end for i=156 */
      0x3FE39FFE,   0x9ED50685,
      0xBFB54F14,   0xDD894E52,
      0x3FBB5070,   0xB847D3A6,
      0x3F90CF70,   0xC65982D5,
      0xBFD4BA0B,   0x777FA230,
      0x3FE740FF,   0xC729E938,
      0x3FE19AA4,   0xE4856460,
      /* end for i=157 */
      0x3FE3C000,   0x86383818,
      0xBFB53EC6,   0x0B2DE8F4,
      0x3FBAE607,   0x242682C5,
      0x3F92813D,   0xD5C96EFA,
      0xBFD4B6BB,   0x9A16414F,
      0x3FE72C46,   0x2142B68F,
      0x3FE1B1DC,   0xE8C25F00,
      /* end for i=158 */
      0x3FE3DFFF,   0x46D24D3B,
      0xBFB52D05,   0x0D0E28BF,
      0x3FBA7BFD,   0x33D244C0,
      0x3F942C3C,   0xC9DFF3CD,
      0xBFD4B31B,   0x6047FE8D,
      0x3FE71791,   0xFDC78FBA,
      0x3FE1C8FD,   0xEDA0B980,
      /* end for i=159 */
      0x3FE40001,   0x7F7709DF,
      0xBFB519DC,   0xEADE5617,
      0x3FBA1244,   0x1798380E,
      0x3F95D0CB,   0x709DBC5C,
      0xBFD4AF2B,   0x471D2FF2,
      0x3FE702DF,   0x642E0085,
      0x3FE1E00C,   0xBF9F0000,
      /* end for i=160 */
      0x3FE41FFF,   0x7F8D1EED,
      0xBFB50558,   0x963A3882,
      0x3FB9A8FC,   0x1A3AAF65,
      0x3F976E8A,   0xF8764C1D,
      0xBFD4AAED,   0x8090A898,
      0x3FE6EE33,   0x9C167C69,
      0x3FE1F703,   0xD94BF3E0,
      /* end for i=161 */
      0x3FE44001,   0x0D38CD9C,
      0xBFB4EF82,   0xE9261AED,
      0x3FB94012,   0x55982537,
      0x3F9905E6,   0x89DC3C90,
      0xBFD4A662,   0x433B9990,
      0x3FE6D989,   0xED1B5177,
      0x3FE20DE8,   0xD4256580,
      /* end for i=162 */
      0x3FE46000,   0xB76716BC,
      0xBFB4D866,   0xA4A2E2AA,
      0x3FB8D79F,   0x24216E77,
      0x3F9A969F,   0x31C5B43F,
      0xBFD4A18B,   0x898FA692,
      0x3FE6C4E6,   0x274CF7FE,
      0x3FE224B7,   0xCE9C78A0,
      /* end for i=163 */
      0x3FE47FFE,   0x7D6E9046,
      0xBFB4C00E,   0x6F54EE0B,
      0x3FB86FA8,   0xB99EC021,
      0x3F9C20BD,   0x485EE16C,
      0xBFD49C6A,   0x9A482B1D,
      0x3FE6B048,   0x955E76B3,
      0x3FE23B70,   0xD0B71AC0,
      /* end for i=164 */
      0x3FE4A001,   0xB7D5558B,
      0xBFB4A684,   0xD43D6BA0,
      0x3FB8081D,   0x5CC3DED8,
      0x3F9DA4A1,   0xD28E33E3,
      0xBFD496FF,   0x739704FA,
      0x3FE69BAC,   0xC64502B7,
      0x3FE25219,   0x13D64F80,
      /* end for i=165 */
      0x3FE4BFFF,   0x55CDEB15,
      0xBFB48BD4,   0x4185D7F4,
      0x3FB7A126,   0xB3BCF406,
      0x3F9F21CE,   0xC1EC48DD,
      0xBFD4914D,   0x2BED2E4C,
      0x3FE6871A,   0x224E4FB3,
      0x3FE268A8,   0xC8987220,
      /* end for i=166 */
      0x3FE4DFFE,   0x17C35D92,
      0xBFB47007,   0x075D4C73,
      0x3FB73AB4,   0x909F55EF,
      0x3FA04C4F,   0x1C9E2C02,
      0xBFD48B53,   0xD37C3352,
      0x3FE6728C,   0x9840D980,
      0x3FE27F24,   0xBBF67240,
      /* end for i=167 */
      0x3FE4FFFE,   0x9270AC2D,
      0xBFB45327,   0x56E74758,
      0x3FB6D4CA,   0x9F0E29B9,
      0x3FA1048F,   0x6CFB8E30,
      0xBFD48514,   0x785478C7,
      0x3FE65E04,   0x0FA2498C,
      0x3FE2958D,   0x59AC0660,
      /* end for i=168 */
      0x3FE52001,   0x393F6102,
      0xBFB4353F,   0x413B91F2,
      0x3FB66F6C,   0xCD401C9A,
      0x3FA1B9AE,   0xD8D61B78,
      0xBFD47E90,   0x291BD66F,
      0x3FE64980,   0x84A496DA,
      0x3FE2ABE2,   0xF509E9A0,
      /* end for i=169 */
      0x3FE54001,   0x9CE0E00F,
      0xBFB41658,   0xB676E858,
      0x3FB60AAE,   0x374E5528,
      0x3FA26B98,   0xF85915A7,
      0xBFD477C8,   0xFD5A7E38,
      0x3FE63505,   0x12BD79D4,
      0x3FE2C222,   0x7C88FB00,
      /* end for i=170 */
      0x3FE56000,   0x34220B09,
      0xBFB3F67D,   0x84DC0382,
      0x3FB5A692,   0x29CA698E,
      0x3FA31A55,   0xCD92C41A,
      0xBFD470C0,   0x16E102EC,
      0x3FE62091,   0xAF53EECD,
      0x3FE2D84C,   0x4D6E5BA0,
      /* end for i=171 */
      0x3FE57FFE,   0xE778ED88,
      0xBFB3D5B7,   0x5804A50F,
      0x3FB54317,   0x4E6DA643,
      0x3FA3C5F4,   0xFD72061D,
      0xBFD46976,   0x3BC50F19,
      0x3FE60C25,   0x6325FF59,
      0x3FE2EE61,   0xC2BF77C0,
      /* end for i=172 */
      0x3FE59FFF,   0x46DE128A,
      0xBFB3B40F,   0xB8224263,
      0x3FB4E03D,   0x5601CDBB,
      0x3FA46E83,   0xC5752C82,
      0xBFD461EC,   0x35F0611B,
      0x3FE5F7BF,   0x6FDA310A,
      0x3FE30463,   0xF6237520,
      /* end for i=173 */
      0x3FE5C000,   0x70A6DB74,
      0xBFB39190,   0x094DEB7E,
      0x3FB47E0B,   0x5CC23600,
      0x3FA51402,   0x67CEFD28,
      0xBFD45A23,   0x5BCC1B0F,
      0x3FE5E360,   0xA55C7A6A,
      0x3FE31A52,   0x51966920,
      /* end for i=174 */
      0x3FE5E001,   0x1E520C68,
      0xBFB36E41,   0x8AE708DF,
      0x3FB41C89,   0x704F9ECE,
      0x3FA5B66F,   0xA5175F94,
      0xBFD4521D,   0x227D023D,
      0x3FE5CF0A,   0x11AB4BF4,
      0x3FE3302B,   0xFCD9E080,
      /* end for i=175 */
      0x3FE5FFFF,   0x1DF0F31D,
      0xBFB34A2D,   0x57008AC8,
      0x3FB3BBC2,   0x19CE7B0D,
      0x3FA655C6,   0x5111FB16,
      0xBFD449DB,   0x446DB5EE,
      0x3FE5BABD,   0x559B211E,
      0x3FE345EF,   0x834D2840,
      /* end for i=176 */
      0x3FE61FFF,   0x63F74E34,
      0xBFB3255C,   0x61DC23B4,
      0x3FB35BAA,   0x1EAF6060,
      0x3FA6F224,   0xCAFB6405,
      0xBFD4415D,   0x9DBDD585,
      0x3FE5A677,   0x87EAB5FF,
      0x3FE35BA0,   0x4C7D6520,
      /* end for i=177 */
      0x3FE63FFF,   0xA211711B,
      0xBFB2FFD7,   0x79732726,
      0x3FB2FC4C,   0x1877E68A,
      0x3FA78B85,   0x3DA8E526,
      0xBFD438A5,   0xE5198CB7,
      0x3FE5923A,   0x5A1779E9,
      0x3FE3713C,   0xCEA4FBE0,
      /* end for i=178 */
      0x3FE66001,   0xEED45BAF,
      0xBFB2D9A7,   0x450CA5D9,
      0x3FB29DA5,   0x4E3822B6,
      0x3FA821F7,   0x400B3046,
      0xBFD42FB4,   0xA19AB0FC,
      0x3FE57E04,   0xB4661368,
      0x3FE386C6,   0x7995C3A0,
      /* end for i=179 */
      0x3FE68001,   0xD5CC5D8E,
      0xBFB2B2D4,   0x44E0600D,
      0x3FB23FC6,   0x2C9F20BB,
      0x3FA8B56B,   0xE5CAE9A9,
      0xBFD4268C,   0x2EB5C668,
      0x3FE569D9,   0x9F2908FD,
      0x3FE39C3A,   0x57343E80,
      /* end for i=180 */
      0x3FE6A000,   0x3FEAF53E,
      0xBFB28B66,   0xD1C626E1,
      0x3FB1E2AE,   0xFE174D8C,
      0x3FA945ED,   0xFA1AB24F,
      0xBFD41D2D,   0x6D764404,
      0x3FE555B8,   0xBD31B80B,
      0x3FE3B199,   0x107FC080,
      /* end for i=181 */
      0x3FE6C000,   0x59570695,
      0xBFB26367,   0x1CF145C4,
      0x3FB18659,   0x78F27ECD,
      0x3FA9D391,   0xF32785C6,
      0xBFD41398,   0x86C7A4F9,
      0x3FE541A0,   0x45D388A5,
      0x3FE3C6E4,   0xCD1FE2A0,
      /* end for i=182 */
      0x3FE6E000,   0x66D2465C,
      0xBFB23ADD,   0x2FB78D64,
      0x3FB12ACD,   0x72783C45,
      0x3FAA5E56,   0x2DE45F83,
      0xBFD409CF,   0x103EDA66,
      0x3FE52D91,   0x853EA748,
      0x3FE3DC1C,   0x6E24EEE0,
      /* end for i=183 */
      0x3FE70000,   0xF3530494,
      0xBFB211D0,   0xEB639A20,
      0x3FB0D00C,   0x00C714E4,
      0x3FAAE643,   0x4B18E2F4,
      0xBFD3FFD1,   0xF0EC8E18,
      0x3FE5198C,   0x5898E9D3,
      0x3FE3F140,   0x590F5840,
      /* end for i=184 */
      0x3FE72001,   0x68DF92F1,
      0xBFB1E84A,   0x0911F070,
      0x3FB07619,   0x4980E413,
      0x3FAB6B5D,   0x29F65CF3,
      0xBFD3F5A2,   0x66EF9268,
      0x3FE50591,   0x50DF94A8,
      0x3FE40650,   0x34682660,
      /* end for i=185 */
      0x3FE73FFD,   0xEC892672,
      0xBFB1BE50,   0x19988AB0,
      0x3FB01D02,   0x4D487076,
      0x3FABED9A,   0xC623ABFB,
      0xBFD3EB42,   0xC394AB20,
      0x3FE4F1A3,   0x063D9D57,
      0x3FE41B49,   0x84988260,
      /* end for i=186 */
      0x3FE75FFF,   0x02B5277B,
      0xBFB193EA,   0x85787474,
      0x3FAF8963,   0x0BE666E1,
      0x3FAC6D25,   0x476F0845,
      0xBFD3E0B1,   0x4DA20F2B,
      0x3FE4DDBC,   0x5B3F208E,
      0x3FE43031,   0xE9214220,
      /* end for i=187 */
      0x3FE78001,   0xFD8C09FD,
      0xBFB16920,   0x8CD9109D,
      0x3FAEDA61,   0x40BA8D74,
      0x3FACE9F7,   0xCA6F1FC0,
      0xBFD3D5EF,   0xE1FE406B,
      0x3FE4C9DF,   0x2D643CE9,
      0x3FE44507,   0xA67F64C0,
      /* end for i=188 */
      0x3FE79FFF,   0x4E520438,
      0xBFB13DF9,   0x478CA883,
      0x3FAE2D2C,   0x0700902F,
      0x3FAD63FC,   0x0264F12B,
      0xBFD3CB02,   0x196B6C7E,
      0x3FE4B610,   0x5A1E9DFD,
      0x3FE459C5,   0xDFBB3800,
      /* end for i=189 */
      0x3FE7BFFE,   0x8ABBCA8A,
      0xBFB1127B,   0xA51DE3A9,
      0x3FAD819D,   0x83C97F23,
      0x3FADDB56,   0x153B105E,
      0xBFD3BFE6,   0x687C30E8,
      0x3FE4A24B,   0x5AFB15C7,
      0x3FE46E71,   0x8E4E92A0,
      /* end for i=190 */
      0x3FE7E001,   0x49874A57,
      0xBFB0E6AE,   0x6CE5C8C6,
      0x3FACD7B0,   0xDE84233D,
      0x3FAE5012,   0x0CE62892,
      0xBFD3B49D,   0x37EE4412,
      0x3FE48E8F,   0x6440E964,
      0x3FE4830B,   0xBF101B80,
      /* end for i=191 */
      0x3FE7FFFE,   0x829E26E2,
      0xBFB0BA98,   0x3E29EA50,
      0x3FAC2F98,   0xD9B8DE31,
      0x3FAEC216,   0x119A78C3,
      0xBFD3A92A,   0xB9CD241B,
      0x3FE47AE2,   0x3200542B,
      0x3FE4978E,   0xAF10EFC0,
      /* end for i=192 */
      0x3FE82001,   0xFBE033DC,
      0xBFB08E3F,   0x90426213,
      0x3FAB891A,   0x60F51D42,
      0x3FAF3192,   0xE6CD29C5,
      0xBFD39D8B,   0xB27D87CE,
      0x3FE4673C,   0xB192C0A1,
      0x3FE4AC01,   0xF599BE60,
      /* end for i=193 */
      0x3FE84001,   0x8D9AFCFB,
      0xBFB061AA,   0xB2C74104,
      0x3FAAE46C,   0xEE8F2D6B,
      0x3FAF9E6B,   0xD3701093,
      0xBFD391C4,   0xC6BB02C0,
      0x3FE453A5,   0x49732853,
      0x3FE4C05F,   0x1F6EC8A0,
      /* end for i=194 */
      0x3FE85FFE,   0x2835EA86,
      0xBFB034DF,   0xCDC519EC,
      0x3FAA418D,   0x58AE455A,
      0x3FB00455,   0xEA457699,
      0xBFD385D6,   0xA234E051,
      0x3FE4401B,   0x8B77AC6D,
      0x3FE4D4A6,   0xD7A4A580,
      /* end for i=195 */
      0x3FE88001,   0x1FF4A22C,
      0xBFB007E4,   0xE1F84F4A,
      0x3FA9A04E,   0x64012A9B,
      0x3FB0383C,   0x3F81292E,
      0xBFD379BE,   0xB836CBF8,
      0x3FE42C99,   0xEE98324F,
      0x3FE4E8DF,   0x11412E00,
      /* end for i=196 */
      0x3FE89FFE,   0x8C7D3A7B,
      0xBFAFB57F,   0x921D9CE5,
      0x3FA900ED,   0xDF5CC4B0,
      0x3FB06AD9,   0x11EA148D,
      0xBFD36D82,   0x7888816A,
      0x3FE41927,   0xDBB45126,
      0x3FE4FD00,   0x52280E40,
      /* end for i=197 */
      0x3FE8BFFE,   0xF853D6CB,
      0xBFAF5AEC,   0x6BDFC742,
      0x3FA86342,   0x90A7ADA7,
      0x3FB09C3D,   0x91FC377C,
      0xBFD3611F,   0x92982729,
      0x3FE405C0,   0x4634CC64,
      0x3FE51110,   0x08CAF320,
      /* end for i=198 */
      0x3FE8DFFE,   0x466BE198,
      0xBFAF001B,   0x6A13A91E,
      0x3FA7C762,   0x34DC608E,
      0x3FB0CC66,   0xD3F53711,
      0xBFD35498,   0x871D95AA,
      0x3FE3F265,   0xD2C05D3B,
      0x3FE5250B,   0xABB111E0,
      /* end for i=199 */
      0x3FE90000,   0xF00B0365,
      0xBFAEA517,   0x5949E1C1,
      0x3FA72D38,   0x4AB6092A,
      0x3FB0FB5E,   0xFF5774C9,
      0xBFD347EC,   0x7BD19F46,
      0x3FE3DF15,   0xF2156E48,
      0x3FE538F6,   0x109903A0,
      /* end for i=200 */
      0x3FE92001,   0x90E94F2E,
      0xBFAE49EA,   0xBA77932E,
      0x3FA694DF,   0xCAE7BF78,
      0x3FB12921,   0xA610B481,
      0xBFD33B1E,   0x782A65F5,
      0x3FE3CBD4,   0x08F1CA92,
      0x3FE54CCB,   0xE83A6200,
      /* end for i=201 */
      0x3FE94001,   0x2EC0BC8C,
      0xBFADEE9F,   0xC3B08538,
      0x3FA5FE54,   0x479C4A1C,
      0x3FB155B3,   0xF9ED527E,
      0xBFD32E2E,   0xFCEB79B4,
      0x3FE3B89F,   0x9A57C4ED,
      0x3FE5608D,   0xE45C39C0,
      /* end for i=202 */
      0x3FE96001,   0x6F663781,
      0xBFAD9340,   0x60EA66A7,
      0x3FA5698E,   0x76F6ECB5,
      0x3FB1811B,   0xDCC974DF,
      0xBFD3211E,   0x41FD4492,
      0x3FE3A577,   0xCA4F6D23,
      0x3FE5743D,   0x16BBB000,
      /* end for i=203 */
      0x3FE98000,   0x8301021F,
      0xBFAD37D6,   0x34C89A20,
      0x3FA4D697,   0x07B7D065,
      0x3FB1AB5A,   0x7294D1BE,
      0xBFD313ED,   0xE4B251B3,
      0x3FE3925D,   0xCEB85C66,
      0x3FE587D8,   0x6F92FE40,
      /* end for i=204 */
      0x3FE99FFE,   0xB2A4BC0B,
      0xBFACDC6A,   0x9970006E,
      0x3FA4456C,   0x9C5DC4E2,
      0x3FB1D473,   0xCA1C8861,
      0xBFD3069E,   0xA665A4A9,
      0x3FE37F51,   0x9A58F155,
      0x3FE59B60,   0x2AB32B00,
      /* end for i=205 */
      0x3FE9C002,   0x06244CE6,
      0xBFAC8106,   0xA162358B,
      0x3FA3B5F4,   0x2355E3F3,
      0x3FB1FC72,   0xFB13B1E3,
      0xBFD2F92E,   0xD885110F,
      0x3FE36C4F,   0xB787E6CF,
      0x3FE5AED8,   0x000FF1C0,
      /* end for i=206 */
      0x3FE9E001,   0x9C09640D,
      0xBFAC25B3,   0x185FB9BD,
      0x3FA32855,   0x4B22FD14,
      0x3FB22350,   0x6C1E9F32,
      0xBFD2EBA3,   0x0A75D266,
      0x3FE3595D,   0x8AFB8DE0,
      0x3FE5C23A,   0x95488A80,
      /* end for i=207 */
      0x3FEA0001,   0x77B9EAFC,
      0xBFABCA78,   0x845083FE,
      0x3FA29C7D,   0x9EC5F24A,
      0x3FB24914,   0xBCC0BE59,
      0xBFD2DDFA,   0x628B5867,
      0x3FE34678,   0xCF592387,
      0x3FE5D58A,   0x696874E0,
      /* end for i=208 */
      0x3FEA1FFE,   0xD6CF0E35,
      0xBFAB6F5F,   0x26327EB4,
      0x3FA21278,   0x6C85F539,
      0x3FB26DC0,   0x58299359,
      0xBFD2D036,   0xE2EA8AD1,
      0x3FE333A3,   0x409B5C7C,
      0x3FE5E8C5,   0xE1BBA540,
      /* end for i=209 */
      0x3FEA3FFF,   0xAD35CCF3,
      0xBFAB146E,   0xFB0D73B4,
      0x3FA18A2B,   0x602F69A4,
      0x3FB2915D,   0x9363F012,
      0xBFD2C256,   0xC9B35BD6,
      0x3FE320D9,   0x79ACC1BF,
      0x3FE5FBF0,   0x9F58C160,
      /* end for i=210 */
      0x3FEA5FFD,   0xFFC148D5,
      0xBFAAB9AF,   0xBCEBF051,
      0x3FA103AF,   0x25F0E083,
      0x3FB2B3E9,   0x47430995,
      0xBFD2B45D,   0x79E5C4D7,
      0x3FE30E1F,   0x18C659B8,
      0x3FE60F07,   0x1A3F9FC0,
      /* end for i=211 */
      0x3FEA7FFE,   0x53C0345E,
      0xBFAA5F28,   0xE3D8AE24,
      0x3FA07EEF,   0xAACC401B,
      0x3FB2D56B,   0xE745DF5C,
      0xBFD2A649,   0xC469555B,
      0x3FE2FB71,   0x9208A409,
      0x3FE6220C,   0x13549B40,
      /* end for i=212 */
      0x3FEAA000,   0xE3911BCA,
      0xBFAA04E1,   0xA6E010FB,
      0x3F9FF7D6,   0x54D3D00D,
      0x3FB2F5E9,   0x052B5E8D,
      0xBFD2981C,   0x51B73B9B,
      0x3FE2E8D0,   0xDF514164,
      0x3FE634FF,   0xB7A66A20,
      /* end for i=213 */
      0x3FEAC001,   0x16071E0A,
      0xBFA9AAE0,   0xFD154E21,
      0x3F9EF566,   0x49157FA5,
      0x3FB3155F,   0x7ED5980C,
      0xBFD289D7,   0xEFDF5013,
      0x3FE2D63F,   0xC5F20A95,
      0x3FE647DF,   0x5C8B88E0,
      /* end for i=214 */
      0x3FEAE001,   0x0A8FDDF7,
      0xBFA9512D,   0x9E9AD507,
      0x3F9DF67A,   0xBBDE0D6E,
      0x3FB333D5,   0x0E77B0AB,
      0xBFD27B7C,   0x71609809,
      0x3FE2C3BD,   0x207BF97E,
      0x3FE65AAC,   0x530FEE80,
      /* end for i=215 */
      0x3FEB0001,   0x239C079E,
      0xBFA8F7CE,   0x05AD94ED,
      0x3F9CFB0D,   0x733C3FD5,
      0x3FB3514D,   0x93F9C193,
      0xBFD26D0A,   0x695E438C,
      0x3FE2B148,   0xCCC53789,
      0x3FE66D66,   0xE37B3640,
      /* end for i=216 */
      0x3FEB2001,   0x14DB8807,
      0xBFA89EC8,   0x6FB2BEF6,
      0x3F9C031D,   0x611FDB0B,
      0x3FB36DCC,   0x46F13A65,
      0xBFD25E82,   0xB6DFFCB7,
      0x3FE29EE3,   0x0CE862BD,
      0x3FE6800E,   0xEF984FE0,
      /* end for i=217 */
      0x3FEB3FFE,   0xBB15DCB7,
      0xBFA84622,   0xDE47A787,
      0x3F9B0EB7,   0x0D3D8754,
      0x3FB38952,   0xD677164D,
      0xBFD24FE7,   0x0EB98B6B,
      0x3FE28C8D,   0x2F349300,
      0x3FE692A3,   0x49003160,
      /* end for i=218 */
      0x3FEB6001,   0x2F97689F,
      0xBFA7EDE3,   0x18536D98,
      0x3F9A1DA0,   0xC713B6D0,
      0x3FB3A3EA,   0xB7EC8A6C,
      0xBFD24134,   0xE80408F1,
      0x3FE27A43,   0x38758EFD,
      0x3FE6A528,   0x1B982280,
      /* end for i=219 */
      0x3FEB8001,   0xDDD60CDB,
      0xBFA7960E,   0xAB1A11EE,
      0x3F993008,   0x859037DF,
      0x3FB3BD91,   0xC40FEBB8,
      0xBFD2326F,   0xFA11B664,
      0x3FE26809,   0x012BED07,
      0x3FE6B799,   0xA4E52AE0,
      /* end for i=220 */
      0x3FEBA001,   0x14C4569B,
      0xBFA73EAA,   0xEB50ABC8,
      0x3F9845E7,   0x2C8A9425,
      0x3FB3D64B,   0xCCCA9CEF,
      0xBFD22398,   0xD59B8B1B,
      0x3FE255DE,   0x6D60CC3F,
      0x3FE6C9F8,   0x23F15240,
      /* end for i=221 */
      0x3FEBC001,   0x3EFF98A1,
      0xBFA6E7BC,   0xF6326BF7,
      0x3F975F26,   0x77BC7CC5,
      0x3FB3EE1E,   0x1FBD4DD3,
      0xBFD214AF,   0x0BC85F8B,
      0x3FE243C2,   0x300C79B9,
      0x3FE6DC45,   0x0B289400,
      /* end for i=222 */
      0x3FEBDFFF,   0xC5DDE582,
      0xBFA69149,   0xB2962293,
      0x3F967BD4,   0x4341A0B6,
      0x3FB4050A,   0x3C157E86,
      0xBFD205B4,   0x7F0128A9,
      0x3FE231B5,   0xD196EAEE,
      0x3FE6EE7E,   0xEF12CDA0,
      /* end for i=223 */
      0x3FEC0001,   0x162090A0,
      0xBFA63B55,   0xD203FEEB,
      0x3F959BCC,   0x6AB4D46A,
      0x3FB41B16,   0xA1AE870E,
      0xBFD1F6A7,   0xC68E8312,
      0x3FE21FB6,   0xE500DFDA,
      0x3FE700A8,   0x62FE3F60,
      /* end for i=224 */
      0x3FEC2002,   0x06AC6D5F,
      0xBFA5E5E5,   0xD1CB445E,
      0x3F94BF20,   0x5E56C99E,
      0x3FB43044,   0x655D9B96,
      0xBFD1E78B,   0x050A5635,
      0x3FE20DC7,   0x43788377,
      0x3FE712BF,   0xA8C9AC20,
      /* end for i=225 */
      0x3FEC3FFF,   0xA360B88C,
      0xBFA590FD,   0xFC17B222,
      0x3F93E5DE,   0xAB485D31,
      0x3FB44495,   0x0F5CC2F4,
      0xBFD1D860,   0x47BD0BFF,
      0x3FE1FBE8,   0xA203CAE3,
      0x3FE724C3,   0x2741EE20,
      /* end for i=226 */
      0x3FEC5FFF,   0x25E8C1DF,
      0xBFA53CA2,   0x69065EE4,
      0x3F930FDE,   0x3622E9C8,
      0x3FB4580F,   0x5097E5D1,
      0xBFD1C925,   0xB87000DE,
      0x3FE1EA18,   0x23A65E28,
      0x3FE736B5,   0xDFFF6820,
      /* end for i=227 */
      0x3FEC8000,   0x796F7C28,
      0xBFA4E8D6,   0xFFB9CC49,
      0x3F923D1A,   0x8F154CDF,
      0x3FB46AB6,   0x428666E1,
      0xBFD1B9DB,   0xFEFD6863,
      0x3FE1D855,   0xE53B71C6,
      0x3FE74897,   0xD372BF00,
      /* end for i=228 */
      0x3FEC9FFE,   0x26DF3181,
      0xBFA4959F,   0x776CF951,
      0x3F916DB1,   0xB78CC43E,
      0x3FB47C8A,   0x0D9F3DDA,
      0xBFD1AA86,   0x56E994B1,
      0x3FE1C6A4,   0xFBBEE7BC,
      0x3FE75A66,   0x04B07060,
      /* end for i=229 */
      0x3FECBFFE,   0x28A59222,
      0xBFA442FF,   0x58853D67,
      0x3F90A176,   0xE1382444,
      0x3FB48D91,   0x53AE8A28,
      0xBFD19B22,   0x7F06E4CD,
      0x3FE1B502,   0x25491085,
      0x3FE76C23,   0xD7F48CC0,
      /* end for i=230 */
      0x3FECDFFF,   0x02BE78AB,
      0xBFA3F0F9,   0xFDA2B8CB,
      0x3F8FB0DC,   0x0B40D796,
      0x3FB49DCE,   0x662DD05C,
      0xBFD18BB1,   0xC55729B1,
      0x3FE1A36E,   0x42591333,
      0x3FE77DD0,   0x8751E6A0,
      /* end for i=231 */
      0x3FED0001,   0x3ECE9747,
      0xBFA39F92,   0x94AF29AC,
      0x3F8E251B,   0xFAFEA4F4,
      0x3FB4AD44,   0xAA79FBDC,
      0xBFD17C34,   0x7CFE2A45,
      0x3FE191E9,   0x1520F5F3,
      0x3FE78F6C,   0x6C689F60,
      /* end for i=232 */
      0x3FED2000,   0x8B157699,
      0xBFA34ECC,   0x1FEAF80F,
      0x3F8C9FD6,   0x0C56D357,
      0x3FB4BBF5,   0x4712F509,
      0xBFD16CAD,   0x5251834A,
      0x3FE18075,   0x0556A219,
      0x3FE7A0F5,   0x37ADD3C0,
      /* end for i=233 */
      0x3FED4001,   0xFABD7A50,
      0xBFA2FEA9,   0x76F84D0E,
      0x3F8B20BF,   0x943F76DB,
      0x3FB4C9E5,   0xBFC99308,
      0xBFD15D1A,   0x614EBCB3,
      0x3FE16F0F,   0x58C54E72,
      0x3FE7B26D,   0xC141B6C0,
      /* end for i=234 */
      0x3FED6001,   0xF02EF389,
      0xBFA2AF2D,   0x47E40CAD,
      0x3F89A7F7,   0x2404AC43,
      0x3FB4D717,   0x9CF11AB7,
      0xBFD14D7D,   0xFBAC23CC,
      0x3FE15DBA,   0x117B8FEF,
      0x3FE7C3D4,   0x1EEC5040,
      /* end for i=235 */
      0x3FED7FFF,   0xB3B9D727,
      0xBFA2605A,   0x182C8BC6,
      0x3F883577,   0x02376C5F,
      0x3FB4E38D,   0xCDFAE39F,
      0xBFD13DD9,   0x0A020D51,
      0x3FE14C75,   0x9A2E0253,
      0x3FE7D527,   0xFF641C20,
      /* end for i=236 */
      0x3FEDA000,   0xE882F9E7,
      0xBFA21232,   0x45C5DE1C,
      0x3F86C8F0,   0xF5E1F451,
      0x3FB4EF4D,   0x8E695F0E,
      0xBFD12E29,   0x5502BA3A,
      0x3FE13B3E,   0xF22E7D4A,
      0x3FE7E66C,   0x7EF52660,
      /* end for i=237 */
      0x3FEDBFFF,   0x348D49C4,
      0xBFA1C4B8,   0x081B9AC9,
      0x3F8562A0,   0x05436A0B,
      0x3FB4FA57,   0x9201C8DC,
      0xBFD11E72,   0x8205F5DC,
      0x3FE12A19,   0x8D36CB45,
      0x3FE7F79E,   0x3F98E020,
      /* end for i=238 */
      0x3FEDDFFE,   0x5DD58EE4,
      0xBFA177ED,   0x710FF794,
      0x3F84024B,   0xB4EDB3B6,
      0x3FB504B0,   0x3DEDB16F,
      0xBFD10EB3,   0x3DC1EDB6,
      0x3FE11903,   0x6C5A7939,
      0x3FE808BF,   0x59D30500,
      /* end for i=239 */
      0x3FEDFFFF,   0x9FEFB7D6,
      0xBFA12BD4,   0x6DF81DD3,
      0x3F82A7D9,   0x7B1844E8,
      0x3FB50E5A,   0xDF90CC58,
      0xBFD0FEEB,   0x6FF1B396,
      0x3FE107FB,   0xF1067852,
      0x3FE819D0,   0x83F4EC60,
      /* end for i=240 */
      0x3FEE2000,   0x561F7340,
      0xBFA0E06E,   0xC8959DA3,
      0x3F815358,   0x71CE8CD6,
      0x3FB51759,   0x96FCFBE1,
      0xBFD0EF1C,   0xE7A4C200,
      0x3FE0F704,   0x8BB4862E,
      0x3FE82AD0,   0x63A888E0,
      /* end for i=241 */
      0x3FEE3FFE,   0x14DCB113,
      0xBFA095BE,   0x280CE640,
      0x3F8004D3,   0x4C98E859,
      0x3FB51FAE,   0xC404EC9B,
      0xBFD0DF49,   0x57A3187A,
      0x3FE0E61E,   0x88FBB84C,
      0x3FE83BBD,   0xC2706C00,
      /* end for i=242 */
      0x3FEE6001,   0xE94F2E9A,
      0xBFA04BC4,   0x11D8AC27,
      0x3F7D77BC,   0x161B7C9F,
      0x3FB5275F,   0x94EE7D5B,
      0xBFD0CF6C,   0xC236DE83,
      0x3FE0D545,   0x29741BEF,
      0x3FE84C9D,   0x77B8AF80,
      /* end for i=243 */
      0x3FEE7FFF,   0x0E00020B,
      0xBFA00281,   0xEABA27C0,
      0x3F7AF1DA,   0xDB73CAB3,
      0x3FB52E6B,   0xE08156E1,
      0xBFD0BF8D,   0xF6A55BBE,
      0x3FE0C47F,   0x2B1D999D,
      0x3FE85D68,   0xD89EC400,
      /* end for i=244 */
      0x3FEEA001,   0x9DC9D10E,
      0xBF9F73F1,   0xEF4C31D4,
      0x3F7876F0,   0xF76EA565,
      0x3FB534D9,   0x381B9634,
      0xBFD0AFA7,   0x6D0EAE15,
      0x3FE0B3C6,   0x396D46A5,
      0x3FE86E26,   0x50F20D00,
      /* end for i=245 */
      0x3FEEBFFF,   0xFE1AA344,
      0xBF9EE454,   0xBD5CFB43,
      0x3F7607A0,   0x8A163AFD,
      0x3FB53AA8,   0x7A053C82,
      0xBFD09FBE,   0x616707D3,
      0x3FE0A31F,   0x5E8326FD,
      0x3FE87ED0,   0xE9E001A0,
      /* end for i=246 */
      0x3FEEE001,   0x774771E0,
      0xBF9E562E,   0x4FD1D75A,
      0x3F73A33D,   0xE942C59E,
      0x3FB53FDD,   0xCF1251CD,
      0xBFD08FCF,   0xA9B7992A,
      0x3FE09286,   0xD396DEED,
      0x3FE88F6C,   0x7F5C51A0,
      /* end for i=247 */
      0x3FEF0001,   0x72AB3885,
      0xBF9DC980,   0x7CA2FD85,
      0x3F714A04,   0x5C95C2B3,
      0x3FB5447B,   0x33484D8E,
      0xBFD07FDE,   0x013DE21D,
      0x3FE081FE,   0xFED93D7D,
      0x3FE89FF6,   0xBE8F5E80,
      /* end for i=248 */
      0x3FEF1FFE,   0x3E53D422,
      0xBF9D3E4C,   0xE1549C95,
      0x3F6DF7E7,   0xB2DD0036,
      0x3FB54883,   0x4841EE2E,
      0xBFD06FEA,   0xB1A79979,
      0x3FE07188,   0xC06C8C33,
      0x3FE8B06E,   0xDABDC4C0,
      /* end for i=249 */
      0x3FEF3FFF,   0xD2F3CD76,
      0xBF9CB494,   0xE4AEBE82,
      0x3F6970B9,   0x14D26C8C,
      0x3FB54BF9,   0xBC124230,
      0xBFD05FF2,   0x2FCFE7EC,
      0x3FE06120,   0x02523DF5,
      0x3FE8C0D8,   0xFD4E2160,
      /* end for i=250 */
      0x3FEF5FFF,   0x8D6B5356,
      0xBF9C2C59,   0xB86E1091,
      0x3F64FF34,   0xD1604C40,
      0x3FB54EE0,   0x735C989E,
      0xBFD04FF8,   0x37D29A0A,
      0x3FE050C8,   0x30735FB5,
      0x3FE8D131,   0xCC8D2E60,
      /* end for i=251 */
      0x3FEF7FFF,   0x9866415D,
      0xBF9BA59C,   0x5AED7E89,
      0x3F60A2D0,   0xC20F3E91,
      0x3FB5513A,   0x53F41BFB,
      0xBFD03FFC,   0x1F92F5F6,
      0x3FE04080,   0x308BE5EF,
      0x3FE8E17A,   0x74FF0EE0,
      /* end for i=252 */
      0x3FEFA000,   0xFFC9D6C0,
      0xBF9B205D,   0x98C8927E,
      0x3F58B65C,   0xA19F682C,
      0x3FB5530A,   0x085EFA8B,
      0xBFD02FFD,   0xC9C97E5A,
      0x3FE03047,   0x7D53A3DB,
      0x3FE8F1B3,   0x8DABC900,
      /* end for i=253 */
      0x3FEFBFFE,   0x3898807A,
      0xBF9A9C9E,   0x0E768D19,
      0x3F505199,   0x5609B80F,
      0x3FB55451,   0xEC7CA2A2,
      0xBFD02000,   0x62677B8B,
      0x3FE02020,   0xE53AA5E7,
      0x3FE901DA,   0x5971FC80,
      /* end for i=254 */
      0x3FEFDFFE,   0x7C843684,
      0xBF9A1A5E,   0x29DE2CC8,
      0x3F4029F0,   0x8C22699B,
      0x3FB55514,   0xE43D2DE1,
      0xBFD01000,   0xB1A79BC1,
      0x3FE01008,   0xC27BA273,
      0x3FE911F2,   0x8F197B20,
      /* end for i=255 */
      0x3FF00000,   0x1E14A044,
      0xBF99999E,   0x2125550E,
      0x3E7C3D6B,   0x3D18482F,
      0x3FB55555,   0x55558E3F,
      0xBFCFFFFF,   0xC3D6D778,
      0x3FDFFFFF,   0xC3D6BFB1,
      0x3FE921FB,   0x7258CD40
      /* end for i=256 */
      };

#else       /* __APPLE_CC__ version */
#warning A higher version than gcc-932 is required.
#endif      /* __APPLE_CC__ version */
#endif      /* __APPLE_CC__ */
