/*
 *  AppleTexasEQPrefs.cpp
 *  Apple02Audio
 *
 *  Created by mcookson on Mon Jul 16 2001.
 *  Copyright (c) 2001 Apple Computer, Inc. All rights reserved.
 *
 */
 
/*
 *
 *	REVISION HISTORY (most recent first):
 *
 *	7 July 2002		rbm		[2975812, 2975825, 2963521, 2924106, 2924110, 2924115, 2924124] 
 *
 */
#ifndef __TEXAS_EQ_PREFS__
#define __TEXAS_EQ_PREFS__

#include "texas_hw.h"

EQPrefs         theEQPrefs = 
{
    0x00000001,                         // structVersionNumber
    0x72617720,                         // genreType = 'raw '
    0x00000013,                         // eqCount
    0x00000000,                         // nameID
    {                                   // eq
        {                               // ----------     Equalization Set #1     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     5.0  */      10,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000000E,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000001,                 // speakerID    = External Ball
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x20, 0x25 }, { 0xE0, 0x41, 0x45 }, { 0x0F, 0x9F, 0x41 }, { 0xE0, 0x41, 0x45 }, { 0x0F, 0xBF, 0x66 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x82, 0x5E }, { 0xE2, 0x31, 0xF1 }, { 0x0E, 0x91, 0x2D }, { 0xE2, 0x31, 0xF1 }, { 0x0E, 0x13, 0x8C }}},
                {{{ 0x13, 0x53, 0x5B }, { 0xF2, 0x38, 0x8C }, { 0x04, 0xF5, 0x87 }, { 0xF2, 0x38, 0x8C }, { 0x08, 0x48, 0xE3 }}},
                {{{ 0x0B, 0x5A, 0x7B }, { 0x05, 0xF0, 0x7F }, { 0x06, 0xFB, 0x81 }, { 0x05, 0xF0, 0x7F }, { 0x02, 0x55, 0xFC }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x20, 0x25 }, { 0xE0, 0x41, 0x45 }, { 0x0F, 0x9F, 0x41 }, { 0xE0, 0x41, 0x45 }, { 0x0F, 0xBF, 0x66 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x82, 0x5E }, { 0xE2, 0x31, 0xF1 }, { 0x0E, 0x91, 0x2D }, { 0xE2, 0x31, 0xF1 }, { 0x0E, 0x13, 0x8C }}},
                {{{ 0x13, 0x53, 0x5B }, { 0xF2, 0x38, 0x8C }, { 0x04, 0xF5, 0x87 }, { 0xF2, 0x38, 0x8C }, { 0x08, 0x48, 0xE3 }}},
                {{{ 0x0B, 0x5A, 0x7B }, { 0x05, 0xF0, 0x7F }, { 0x06, 0xFB, 0x81 }, { 0x05, 0xF0, 0x7F }, { 0x02, 0x55, 0xFC }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #2     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     5.0  */      10,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000000E,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000002,                 // speakerID    = External Ball 2
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x27, 0x81 }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0x89, 0x1C }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0xB0, 0x9D }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x7D, 0xF7 }, { 0xE2, 0x52, 0x42 }, { 0x0E, 0x78, 0xAA }, { 0xE2, 0x52, 0x42 }, { 0x0D, 0xF6, 0xA2 }}},
                {{{ 0x13, 0x53, 0x5B }, { 0xF2, 0x38, 0x8C }, { 0x04, 0xF5, 0x87 }, { 0xF2, 0x38, 0x8C }, { 0x08, 0x48, 0xE3 }}},
                {{{ 0x0A, 0xAF, 0x63 }, { 0x05, 0x80, 0xFB }, { 0x06, 0x94, 0x68 }, { 0x05, 0x80, 0xFB }, { 0x01, 0x43, 0xCC }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x27, 0x81 }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0x89, 0x1C }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0xB0, 0x9D }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x7D, 0xF7 }, { 0xE2, 0x52, 0x42 }, { 0x0E, 0x78, 0xAA }, { 0xE2, 0x52, 0x42 }, { 0x0D, 0xF6, 0xA2 }}},
                {{{ 0x13, 0x53, 0x5B }, { 0xF2, 0x38, 0x8C }, { 0x04, 0xF5, 0x87 }, { 0xF2, 0x38, 0x8C }, { 0x08, 0x48, 0xE3 }}},
                {{{ 0x0A, 0xAF, 0x63 }, { 0x05, 0x80, 0xFB }, { 0x06, 0x94, 0x68 }, { 0x05, 0x80, 0xFB }, { 0x01, 0x43, 0xCC }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #3     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.5  */  -12460,     // drcThreshold     (X1000)
            /*     4.5  */       9,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000010,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x4A, 0x12 }, { 0xE1, 0x6B, 0xDA }, { 0x0F, 0x4A, 0x12 }, { 0xE1, 0x73, 0xF0 }, { 0x0E, 0x9C, 0x3A }}},
                {{{ 0x02, 0xDD, 0x54 }, { 0x05, 0xBA, 0xA8 }, { 0x02, 0xDD, 0x54 }, { 0xF8, 0x00, 0x1D }, { 0x03, 0x75, 0x32 }}},
                {{{ 0x0E, 0x2F, 0xC7 }, { 0xE4, 0xD5, 0xDC }, { 0x0D, 0x74, 0x77 }, { 0xE4, 0xD5, 0xDC }, { 0x0B, 0xA4, 0x3F }}},
                {{{ 0x0E, 0x78, 0x99 }, { 0xE6, 0x7C, 0xCA }, { 0x0D, 0x0E, 0x93 }, { 0xE6, 0x7C, 0xCA }, { 0x0B, 0x87, 0x2D }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x0F, 0x4A, 0x12 }, { 0xE1, 0x6B, 0xDA }, { 0x0F, 0x4A, 0x12 }, { 0xE1, 0x73, 0xF0 }, { 0x0E, 0x9C, 0x3A }}},
                {{{ 0x02, 0xDD, 0x54 }, { 0x05, 0xBA, 0xA8 }, { 0x02, 0xDD, 0x54 }, { 0xF8, 0x00, 0x1D }, { 0x03, 0x75, 0x32 }}},
                {{{ 0x0E, 0x2F, 0xC7 }, { 0xE4, 0xD5, 0xDC }, { 0x0D, 0x74, 0x77 }, { 0xE4, 0xD5, 0xDC }, { 0x0B, 0xA4, 0x3F }}},
                {{{ 0x0E, 0x78, 0x99 }, { 0xE6, 0x7C, 0xCA }, { 0x0D, 0x0E, 0x93 }, { 0xE6, 0x7C, 0xCA }, { 0x0B, 0x87, 0x2D }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #4     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     5.0  */      10,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000015,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000001,                 // speakerID    = External Ball
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x20, 0x25 }, { 0xE0, 0x41, 0x45 }, { 0x0F, 0x9F, 0x41 }, { 0xE0, 0x41, 0x45 }, { 0x0F, 0xBF, 0x66 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x82, 0x5E }, { 0xE2, 0x31, 0xF1 }, { 0x0E, 0x91, 0x2D }, { 0xE2, 0x31, 0xF1 }, { 0x0E, 0x13, 0x8C }}},
                {{{ 0x13, 0x53, 0x5B }, { 0xF2, 0x38, 0x8C }, { 0x04, 0xF5, 0x87 }, { 0xF2, 0x38, 0x8C }, { 0x08, 0x48, 0xE3 }}},
                {{{ 0x0B, 0x5A, 0x7B }, { 0x05, 0xF0, 0x7F }, { 0x06, 0xFB, 0x81 }, { 0x05, 0xF0, 0x7F }, { 0x02, 0x55, 0xFC }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x20, 0x25 }, { 0xE0, 0x41, 0x45 }, { 0x0F, 0x9F, 0x41 }, { 0xE0, 0x41, 0x45 }, { 0x0F, 0xBF, 0x66 }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x82, 0x5E }, { 0xE2, 0x31, 0xF1 }, { 0x0E, 0x91, 0x2D }, { 0xE2, 0x31, 0xF1 }, { 0x0E, 0x13, 0x8C }}},
                {{{ 0x13, 0x53, 0x5B }, { 0xF2, 0x38, 0x8C }, { 0x04, 0xF5, 0x87 }, { 0xF2, 0x38, 0x8C }, { 0x08, 0x48, 0xE3 }}},
                {{{ 0x0B, 0x5A, 0x7B }, { 0x05, 0xF0, 0x7F }, { 0x06, 0xFB, 0x81 }, { 0x05, 0xF0, 0x7F }, { 0x02, 0x55, 0xFC }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #5     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*     0.0  */       0,     // drcThreshold     (X1000)
            /*     5.5  */      11,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000015,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x83, 0x05 }, { 0xE0, 0xF9, 0xF5 }, { 0x0F, 0x83, 0x05 }, { 0xE0, 0xFD, 0xC6 }, { 0x0F, 0x09, 0xDA }}},
                {{{ 0x01, 0xA6, 0x5D }, { 0x03, 0x4C, 0xBB }, { 0x01, 0xA6, 0x5D }, { 0xF1, 0x73, 0xCA }, { 0x05, 0x25, 0xAD }}},
                {{{ 0x0F, 0x24, 0xC8 }, { 0xE5, 0xD9, 0xB2 }, { 0x0D, 0x89, 0x42 }, { 0xE5, 0xD9, 0xB2 }, { 0x0C, 0xAE, 0x0B }}},
                {{{ 0x0E, 0x13, 0x27 }, { 0xE4, 0x61, 0x09 }, { 0x0D, 0xA2, 0xCB }, { 0xE4, 0x61, 0x09 }, { 0x0B, 0xB5, 0xF2 }}},
                {{{ 0x0D, 0x61, 0x60 }, { 0xE7, 0xAE, 0x3D }, { 0x0B, 0xA6, 0x4E }, { 0xE7, 0xAE, 0x3D }, { 0x09, 0x07, 0xAF }}},
                {{{ 0x0D, 0xAF, 0x38 }, { 0xEB, 0x1F, 0x94 }, { 0x0B, 0xD6, 0x6C }, { 0xEB, 0x1F, 0x94 }, { 0x09, 0x85, 0xA5 }}},
                {{{ 0x0F, 0x83, 0x05 }, { 0xE0, 0xF9, 0xF5 }, { 0x0F, 0x83, 0x05 }, { 0xE0, 0xFD, 0xC6 }, { 0x0F, 0x09, 0xDA }}},
                {{{ 0x01, 0xA6, 0x5D }, { 0x03, 0x4C, 0xBB }, { 0x01, 0xA6, 0x5D }, { 0xF1, 0x73, 0xCA }, { 0x05, 0x25, 0xAD }}},
                {{{ 0x0F, 0x24, 0xC8 }, { 0xE5, 0xD9, 0xB2 }, { 0x0D, 0x89, 0x42 }, { 0xE5, 0xD9, 0xB2 }, { 0x0C, 0xAE, 0x0B }}},
                {{{ 0x0E, 0x13, 0x27 }, { 0xE4, 0x61, 0x09 }, { 0x0D, 0xA2, 0xCB }, { 0xE4, 0x61, 0x09 }, { 0x0B, 0xB5, 0xF2 }}},
                {{{ 0x0D, 0x61, 0x60 }, { 0xE7, 0xAE, 0x3D }, { 0x0B, 0xA6, 0x4E }, { 0xE7, 0xAE, 0x3D }, { 0x09, 0x07, 0xAF }}},
                {{{ 0x0D, 0xAF, 0x38 }, { 0xEB, 0x1F, 0x94 }, { 0x0B, 0xD6, 0x6C }, { 0xEB, 0x1F, 0x94 }, { 0x09, 0x85, 0xA5 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #6     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     7.0  */      13,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000012,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x4A, 0x37 }, { 0xE1, 0x6B, 0x90 }, { 0x0F, 0x4A, 0x37 }, { 0xE1, 0x73, 0xA2 }, { 0x0E, 0x9C, 0x82 }}},
                {{{ 0x03, 0xA5, 0xBE }, { 0x07, 0x4B, 0x7D }, { 0x03, 0xA5, 0xBE }, { 0xFB, 0xA2, 0x2A }, { 0x02, 0xF4, 0xD1 }}},
                {{{ 0x0F, 0xDB, 0xF2 }, { 0xE3, 0x48, 0x4D }, { 0x0E, 0x77, 0x78 }, { 0xE3, 0x48, 0x4D }, { 0x0E, 0x53, 0x6B }}},
                {{{ 0x0F, 0xB0, 0x5C }, { 0xE1, 0x2B, 0xE6 }, { 0x0F, 0x58, 0xC4 }, { 0xE1, 0x2B, 0xE6 }, { 0x0F, 0x09, 0x21 }}},
                {{{ 0x0E, 0x9A, 0xE9 }, { 0xE3, 0xBC, 0x0B }, { 0x0E, 0x12, 0x8C }, { 0xE3, 0xBC, 0x0B }, { 0x0C, 0xAD, 0x76 }}},
                {{{ 0x0E, 0xEA, 0xD6 }, { 0xFC, 0x28, 0xEC }, { 0x09, 0xDE, 0x62 }, { 0xFC, 0x28, 0xEC }, { 0x08, 0xC9, 0x38 }}},
                {{{ 0x0F, 0x4A, 0x37 }, { 0xE1, 0x6B, 0x90 }, { 0x0F, 0x4A, 0x37 }, { 0xE1, 0x73, 0xA2 }, { 0x0E, 0x9C, 0x82 }}},
                {{{ 0x03, 0xA5, 0xBE }, { 0x07, 0x4B, 0x7D }, { 0x03, 0xA5, 0xBE }, { 0xFB, 0xA2, 0x2A }, { 0x02, 0xF4, 0xD1 }}},
                {{{ 0x0F, 0xDB, 0xF2 }, { 0xE3, 0x48, 0x4D }, { 0x0E, 0x77, 0x78 }, { 0xE3, 0x48, 0x4D }, { 0x0E, 0x53, 0x6B }}},
                {{{ 0x0F, 0xB0, 0x5C }, { 0xE1, 0x2B, 0xE6 }, { 0x0F, 0x58, 0xC4 }, { 0xE1, 0x2B, 0xE6 }, { 0x0F, 0x09, 0x21 }}},
                {{{ 0x0E, 0x9A, 0xE9 }, { 0xE3, 0xBC, 0x0B }, { 0x0E, 0x12, 0x8C }, { 0xE3, 0xBC, 0x0B }, { 0x0C, 0xAD, 0x76 }}},
                {{{ 0x0E, 0xEA, 0xD6 }, { 0xFC, 0x28, 0xEC }, { 0x09, 0xDE, 0x62 }, { 0xFC, 0x28, 0xEC }, { 0x08, 0xC9, 0x38 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #7     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     5.0  */      10,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000000F,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000002,                 // speakerID    = External Ball 2
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x02, 0xEC, 0xAE }, { 0x05, 0xD9, 0x5C }, { 0x02, 0xEC, 0xA5 }, { 0xFB, 0x5C, 0xAE }, { 0x00, 0x56, 0x0A }}},
                {{{ 0x0F, 0xF9, 0x5A }, { 0xE0, 0x82, 0x03 }, { 0x0F, 0x8C, 0x61 }, { 0xE0, 0x82, 0x03 }, { 0x0F, 0x85, 0xBB }}},
                {{{ 0x10, 0x09, 0x23 }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0xA7, 0x79 }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0xB0, 0x9D }}},
                {{{ 0x0F, 0x9F, 0x7C }, { 0xE2, 0x51, 0xDA }, { 0x0E, 0x69, 0x0E }, { 0xE2, 0x51, 0xDA }, { 0x0E, 0x08, 0x8A }}},
                {{{ 0x14, 0x36, 0x79 }, { 0xF3, 0xAC, 0x86 }, { 0x03, 0xB2, 0xFF }, { 0xF3, 0xAC, 0x86 }, { 0x07, 0xE9, 0x78 }}},
                {{{ 0x0D, 0x3A, 0x3A }, { 0x06, 0xFD, 0xB0 }, { 0x08, 0x5A, 0xCA }, { 0x06, 0xFD, 0xB0 }, { 0x05, 0x95, 0x05 }}},
                {{{ 0x02, 0xEC, 0xAE }, { 0x05, 0xD9, 0x5C }, { 0x02, 0xEC, 0xA5 }, { 0xFB, 0x5C, 0xAE }, { 0x00, 0x56, 0x0A }}},
                {{{ 0x0F, 0xF9, 0x5A }, { 0xE0, 0x82, 0x03 }, { 0x0F, 0x8C, 0x61 }, { 0xE0, 0x82, 0x03 }, { 0x0F, 0x85, 0xBB }}},
                {{{ 0x10, 0x09, 0x23 }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0xA7, 0x79 }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0xB0, 0x9D }}},
                {{{ 0x0F, 0x9F, 0x7C }, { 0xE2, 0x51, 0xDA }, { 0x0E, 0x69, 0x0E }, { 0xE2, 0x51, 0xDA }, { 0x0E, 0x08, 0x8A }}},
                {{{ 0x14, 0x36, 0x79 }, { 0xF3, 0xAC, 0x86 }, { 0x03, 0xB2, 0xFF }, { 0xF3, 0xAC, 0x86 }, { 0x07, 0xE9, 0x78 }}},
                {{{ 0x0D, 0x3A, 0x3A }, { 0x06, 0xFD, 0xB0 }, { 0x08, 0x5A, 0xCA }, { 0x06, 0xFD, 0xB0 }, { 0x05, 0x95, 0x05 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #8     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.5  */  -12460,     // drcThreshold     (X1000)
            /*     4.5  */       9,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000014,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x47, 0x4F }, { 0xE1, 0x71, 0x61 }, { 0x0F, 0x47, 0x4F }, { 0xE1, 0x79, 0xB6 }, { 0x0E, 0x96, 0xF3 }}},
                {{{ 0x02, 0xBD, 0x3A }, { 0x05, 0x7A, 0x75 }, { 0x02, 0xBD, 0x3A }, { 0xF7, 0x62, 0x3B }, { 0x03, 0x92, 0xAF }}},
                {{{ 0x0C, 0xFD, 0x7E }, { 0xE7, 0x01, 0x64 }, { 0x0C, 0x58, 0xB4 }, { 0xE7, 0x01, 0x64 }, { 0x09, 0x56, 0x33 }}},
                {{{ 0x0F, 0x3F, 0xEC }, { 0xEF, 0x04, 0xDD }, { 0x0D, 0x82, 0x51 }, { 0xEF, 0x04, 0xDD }, { 0x0C, 0xC2, 0x3E }}},
                {{{ 0x0F, 0x2C, 0x3D }, { 0xE6, 0x4D, 0xF0 }, { 0x0D, 0x27, 0x92 }, { 0xE6, 0x4D, 0xF0 }, { 0x0C, 0x53, 0xCF }}},
                {{{ 0x0D, 0x49, 0x49 }, { 0xFF, 0x4F, 0x3F }, { 0x07, 0x4A, 0xCA }, { 0xFF, 0x4F, 0x3F }, { 0x04, 0x94, 0x14 }}},
                {{{ 0x0F, 0x47, 0x4F }, { 0xE1, 0x71, 0x61 }, { 0x0F, 0x47, 0x4F }, { 0xE1, 0x79, 0xB6 }, { 0x0E, 0x96, 0xF3 }}},
                {{{ 0x02, 0xBD, 0x3A }, { 0x05, 0x7A, 0x75 }, { 0x02, 0xBD, 0x3A }, { 0xF7, 0x62, 0x3B }, { 0x03, 0x92, 0xAF }}},
                {{{ 0x0C, 0xFD, 0x7E }, { 0xE7, 0x01, 0x64 }, { 0x0C, 0x58, 0xB4 }, { 0xE7, 0x01, 0x64 }, { 0x09, 0x56, 0x33 }}},
                {{{ 0x0F, 0x3F, 0xEC }, { 0xEF, 0x04, 0xDD }, { 0x0D, 0x82, 0x51 }, { 0xEF, 0x04, 0xDD }, { 0x0C, 0xC2, 0x3E }}},
                {{{ 0x0F, 0x2C, 0x3D }, { 0xE6, 0x4D, 0xF0 }, { 0x0D, 0x27, 0x92 }, { 0xE6, 0x4D, 0xF0 }, { 0x0C, 0x53, 0xCF }}},
                {{{ 0x0D, 0x49, 0x49 }, { 0xFF, 0x4F, 0x3F }, { 0x07, 0x4A, 0xCA }, { 0xFF, 0x4F, 0x3F }, { 0x04, 0x94, 0x14 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #9     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*     0.0  */       0,     // drcThreshold     (X1000)
            /*     2.6  */       5,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000000F,                 // layoutID
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x01, 0x2F }, { 0xE1, 0xFD, 0xA1 }, { 0x0F, 0x01, 0x19 }, { 0xE2, 0x05, 0xD0 }, { 0x0E, 0x0A, 0x8D }}},
                {{{ 0x03, 0x40, 0xD8 }, { 0x06, 0x81, 0xB0 }, { 0x03, 0x40, 0xD8 }, { 0xF9, 0xD9, 0x11 }, { 0x03, 0x2A, 0x4F }}},
                {{{ 0x0C, 0xAC, 0x8A }, { 0xE7, 0x86, 0xB0 }, { 0x0B, 0xF6, 0x70 }, { 0xE7, 0x86, 0xB0 }, { 0x08, 0xA2, 0xFB }}},
                {{{ 0x0F, 0xB1, 0xA3 }, { 0xE3, 0x9C, 0x50 }, { 0x0E, 0x51, 0xCF }, { 0xE3, 0x9C, 0x50 }, { 0x0E, 0x03, 0x73 }}},
                {{{ 0x0A, 0xB5, 0xCB }, { 0x01, 0x15, 0xFC }, { 0x06, 0x21, 0xFD }, { 0x01, 0x15, 0xFC }, { 0x00, 0xD7, 0xC9 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}},
                {{{ 0x0F, 0x01, 0x2F }, { 0xE1, 0xFD, 0xA1 }, { 0x0F, 0x01, 0x19 }, { 0xE2, 0x05, 0xD0 }, { 0x0E, 0x0A, 0x8D }}},
                {{{ 0x03, 0x40, 0xD8 }, { 0x06, 0x81, 0xB0 }, { 0x03, 0x40, 0xD8 }, { 0xF9, 0xD9, 0x11 }, { 0x03, 0x2A, 0x4F }}},
                {{{ 0x0C, 0xAC, 0x8A }, { 0xE7, 0x86, 0xB0 }, { 0x0B, 0xF6, 0x70 }, { 0xE7, 0x86, 0xB0 }, { 0x08, 0xA2, 0xFB }}},
                {{{ 0x0F, 0xB1, 0xA3 }, { 0xE3, 0x9C, 0x50 }, { 0x0E, 0x51, 0xCF }, { 0xE3, 0x9C, 0x50 }, { 0x0E, 0x03, 0x73 }}},
                {{{ 0x0A, 0xB5, 0xCB }, { 0x01, 0x15, 0xFC }, { 0x06, 0x21, 0xFD }, { 0x01, 0x15, 0xFC }, { 0x00, 0xD7, 0xC9 }}},
                {{{ 0x10, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }, { 0x00, 0x00, 0x00 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #10     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     4.1  */       8,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000000F,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000001,                 // speakerID    = External Ball
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0xDD }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB2, 0x3A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xB9, 0xFB }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x95, 0xB4 }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x4F, 0xB0 }}},
                {{{ 0x0F, 0x46, 0xC0 }, { 0xE7, 0x71, 0x2C }, { 0x0D, 0x6A, 0xB6 }, { 0xE7, 0x71, 0x2C }, { 0x0C, 0xB1, 0x77 }}},
                {{{ 0x13, 0x14, 0xD6 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0xC9, 0x95 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0xDD }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB2, 0x3A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xB9, 0xFB }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x95, 0xB4 }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x4F, 0xB0 }}},
                {{{ 0x0F, 0x46, 0xC0 }, { 0xE7, 0x71, 0x2C }, { 0x0D, 0x6A, 0xB6 }, { 0xE7, 0x71, 0x2C }, { 0x0C, 0xB1, 0x77 }}},
                {{{ 0x13, 0x14, 0xD6 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0xC9, 0x95 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #11     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     5.0  */      10,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x00000015,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000002,                 // speakerID    = External Ball 2
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x27, 0x81 }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0x89, 0x1C }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0xB0, 0x9D }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x7D, 0xF7 }, { 0xE2, 0x52, 0x42 }, { 0x0E, 0x78, 0xAA }, { 0xE2, 0x52, 0x42 }, { 0x0D, 0xF6, 0xA2 }}},
                {{{ 0x13, 0x53, 0x5B }, { 0xF2, 0x38, 0x8C }, { 0x04, 0xF5, 0x87 }, { 0xF2, 0x38, 0x8C }, { 0x08, 0x48, 0xE3 }}},
                {{{ 0x0A, 0xAF, 0x63 }, { 0x05, 0x80, 0xFB }, { 0x06, 0x94, 0x68 }, { 0x05, 0x80, 0xFB }, { 0x01, 0x43, 0xCC }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x27, 0x81 }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0x89, 0x1C }, { 0xE0, 0x50, 0x40 }, { 0x0F, 0xB0, 0x9D }}},
                {{{ 0x0F, 0xF2, 0xAB }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xB2, 0x0A }, { 0xE0, 0x62, 0x85 }, { 0x0F, 0xA4, 0xB5 }}},
                {{{ 0x0F, 0x7D, 0xF7 }, { 0xE2, 0x52, 0x42 }, { 0x0E, 0x78, 0xAA }, { 0xE2, 0x52, 0x42 }, { 0x0D, 0xF6, 0xA2 }}},
                {{{ 0x13, 0x53, 0x5B }, { 0xF2, 0x38, 0x8C }, { 0x04, 0xF5, 0x87 }, { 0xF2, 0x38, 0x8C }, { 0x08, 0x48, 0xE3 }}},
                {{{ 0x0A, 0xAF, 0x63 }, { 0x05, 0x80, 0xFB }, { 0x06, 0x94, 0x68 }, { 0x05, 0x80, 0xFB }, { 0x01, 0x43, 0xCC }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #12     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     4.1  */       8,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000001D,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000002,                 // speakerID    = External Ball 2
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0x73 }, { 0xE0, 0x6C, 0xE6 }, { 0x0F, 0x87, 0x6A }, { 0xE0, 0x6C, 0xE6 }, { 0x0F, 0x93, 0xDD }}},
                {{{ 0x0F, 0x91, 0x22 }, { 0xE5, 0x77, 0x0C }, { 0x0D, 0x15, 0xBF }, { 0xE5, 0x77, 0x0C }, { 0x0C, 0xA6, 0xE2 }}},
                {{{ 0x0F, 0x88, 0xC3 }, { 0xE2, 0x7C, 0x05 }, { 0x0E, 0x4E, 0x1F }, { 0xE2, 0x7C, 0x05 }, { 0x0D, 0xD6, 0xE2 }}},
                {{{ 0x13, 0xF5, 0x9B }, { 0xF7, 0x8B, 0xF2 }, { 0x05, 0x83, 0x47 }, { 0xF7, 0x8B, 0xF2 }, { 0x09, 0x78, 0xE3 }}},
                {{{ 0x0A, 0xCE, 0x4E }, { 0x04, 0xC8, 0x40 }, { 0x06, 0xBA, 0xA5 }, { 0x04, 0xC8, 0x40 }, { 0x01, 0x88, 0xF4 }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0x73 }, { 0xE0, 0x6C, 0xE6 }, { 0x0F, 0x87, 0x6A }, { 0xE0, 0x6C, 0xE6 }, { 0x0F, 0x93, 0xDD }}},
                {{{ 0x0F, 0x91, 0x22 }, { 0xE5, 0x77, 0x0C }, { 0x0D, 0x15, 0xBF }, { 0xE5, 0x77, 0x0C }, { 0x0C, 0xA6, 0xE2 }}},
                {{{ 0x0F, 0x88, 0xC3 }, { 0xE2, 0x7C, 0x05 }, { 0x0E, 0x4E, 0x1F }, { 0xE2, 0x7C, 0x05 }, { 0x0D, 0xD6, 0xE2 }}},
                {{{ 0x13, 0xF5, 0x9B }, { 0xF7, 0x8B, 0xF2 }, { 0x05, 0x83, 0x47 }, { 0xF7, 0x8B, 0xF2 }, { 0x09, 0x78, 0xE3 }}},
                {{{ 0x0A, 0xCE, 0x4E }, { 0x04, 0xC8, 0x40 }, { 0x06, 0xBA, 0xA5 }, { 0x04, 0xC8, 0x40 }, { 0x01, 0x88, 0xF4 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #13     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*    -7.7  */   -7670,     // drcThreshold     (X1000)
            /*     1.7  */       3,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000001D,                 // layoutID 
            0x00000001,                 // deviceID     = kSndHWInternalSpeaker
            0x00000000,                 // speakerID    = Built In
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0x72, 0xD2 }, { 0xE1, 0x1A, 0x5A }, { 0x0F, 0x72, 0xBB }, { 0xE1, 0x1C, 0xD4 }, { 0x0E, 0xE8, 0x1F }}},
                {{{ 0x03, 0xDD, 0x20 }, { 0x07, 0xBA, 0x41 }, { 0x03, 0xDD, 0x20 }, { 0xFC, 0x94, 0xA0 }, { 0x02, 0xDF, 0xE1 }}},
                {{{ 0x0F, 0x07, 0x47 }, { 0xE6, 0x96, 0x9C }, { 0x0D, 0x29, 0xC5 }, { 0xE6, 0x96, 0x9C }, { 0x0C, 0x31, 0x0D }}},
                {{{ 0x0F, 0x25, 0xE3 }, { 0xE2, 0x8A, 0xFD }, { 0x0E, 0x7A, 0xB1 }, { 0xE2, 0x8A, 0xFD }, { 0x0D, 0xA0, 0x95 }}},
                {{{ 0x0F, 0x85, 0x9F }, { 0xE7, 0x72, 0x0E }, { 0x0E, 0x12, 0x8C }, { 0xE7, 0x72, 0x0E }, { 0x0D, 0x98, 0x2B }}},
                {{{ 0x10, 0x59, 0x92 }, { 0xF5, 0xA3, 0x79 }, { 0x09, 0xEA, 0x3F }, { 0xF5, 0xA3, 0x79 }, { 0x0A, 0x43, 0xD2 }}},
                {{{ 0x0F, 0x72, 0xD2 }, { 0xE1, 0x1A, 0x5A }, { 0x0F, 0x72, 0xBB }, { 0xE1, 0x1C, 0xD4 }, { 0x0E, 0xE8, 0x1F }}},
                {{{ 0x03, 0xDD, 0x20 }, { 0x07, 0xBA, 0x41 }, { 0x03, 0xDD, 0x20 }, { 0xFC, 0x94, 0xA0 }, { 0x02, 0xDF, 0xE1 }}},
                {{{ 0x0F, 0x07, 0x47 }, { 0xE6, 0x96, 0x9C }, { 0x0D, 0x29, 0xC5 }, { 0xE6, 0x96, 0x9C }, { 0x0C, 0x31, 0x0D }}},
                {{{ 0x0F, 0x25, 0xE3 }, { 0xE2, 0x8A, 0xFD }, { 0x0E, 0x7A, 0xB1 }, { 0xE2, 0x8A, 0xFD }, { 0x0D, 0xA0, 0x95 }}},
                {{{ 0x0F, 0x85, 0x9F }, { 0xE7, 0x72, 0x0E }, { 0x0E, 0x12, 0x8C }, { 0xE7, 0x72, 0x0E }, { 0x0D, 0x98, 0x2B }}},
                {{{ 0x10, 0x59, 0x92 }, { 0xF5, 0xA3, 0x79 }, { 0x09, 0xEA, 0x3F }, { 0xF5, 0xA3, 0x79 }, { 0x0A, 0x43, 0xD2 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #14     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*   -12.0  */  -11980,     // drcThreshold     (X1000)
            /*     4.1  */       8,     // drcMaximumVolume (X2)
            0x00000001,                 // drcEnable    = ENABLED
            0x0000001D,                 // layoutID
            0x00000004,                 // deviceID     = kSndHWCPUExternalSpeaker
            0x00000001,                 // speakerID    = External Ball
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0xDD }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB2, 0x3A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xB9, 0xFB }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x95, 0xB4 }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x4F, 0xB0 }}},
                {{{ 0x0F, 0x46, 0xC0 }, { 0xE7, 0x71, 0x2C }, { 0x0D, 0x6A, 0xB6 }, { 0xE7, 0x71, 0x2C }, { 0x0C, 0xB1, 0x77 }}},
                {{{ 0x13, 0x14, 0xD6 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0xC9, 0x95 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}},
                {{{ 0x03, 0xD3, 0xD3 }, { 0x07, 0xA7, 0xA7 }, { 0x03, 0xD3, 0xD3 }, { 0xFC, 0x6C, 0x4D }, { 0x02, 0xE3, 0x01 }}},
                {{{ 0x10, 0x0C, 0xDD }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xB2, 0x3A }, { 0xE0, 0x41, 0xC7 }, { 0x0F, 0xBF, 0x17 }}},
                {{{ 0x0F, 0xB9, 0xFB }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x95, 0xB4 }, { 0xE2, 0x0A, 0x1C }, { 0x0E, 0x4F, 0xB0 }}},
                {{{ 0x0F, 0x46, 0xC0 }, { 0xE7, 0x71, 0x2C }, { 0x0D, 0x6A, 0xB6 }, { 0xE7, 0x71, 0x2C }, { 0x0C, 0xB1, 0x77 }}},
                {{{ 0x13, 0x14, 0xD6 }, { 0xF4, 0x40, 0x0B }, { 0x04, 0xC9, 0x95 }, { 0xF4, 0x40, 0x0B }, { 0x07, 0xDE, 0x6C }}},
                {{{ 0x0D, 0x4B, 0x9B }, { 0x06, 0x86, 0xF2 }, { 0x08, 0x37, 0xCD }, { 0x06, 0x86, 0xF2 }, { 0x05, 0x83, 0x68 }}}
            }                           // end of filter set
        },
        {                               // ----------     Equalization Set #15     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*     0.0  */       0,     // drcThreshold     (X1000)
            /*    -0.2  */       0,     // drcMaximumVolume (X2)
            0x00000000,                 // drcEnable    = DISABLED
            0x0000001B,                 // layoutID     = (as appropriate)
            0x00000004,                 // deviceID     = external speaker
            0x00000003,                 // speakerID    = (as appropriate)
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}},
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}}
            }                           // end of filter set
		},
        {                               // ----------     Equalization Set #16     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*     0.0  */       0,     // drcThreshold     (X1000)
            /*    -0.2  */       0,     // drcMaximumVolume (X2)
            0x00000000,                 // drcEnable    = DISABLED
            0x0000001D,                 // layoutID     = (as appropriate)
            0x00000004,                 // deviceID     = external speaker
            0x00000003,                 // speakerID    = (as appropriate)
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}},
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}}
            }                           // end of filter set
		},
        {                               // ----------     Equalization Set #17     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*     0.0  */       0,     // drcThreshold     (X1000)
            /*    -0.2  */       0,     // drcMaximumVolume (X2)
            0x00000000,                 // drcEnable    = DISABLED
            0x0000000F,                 // layoutID     = (as appropriate)
            0x00000004,                 // deviceID     = external speaker
            0x00000003,                 // speakerID    = (as appropriate)
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}},
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}}
            }                           // end of filter set
		},
		{                               // ----------     Equalization Set #18     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*     0.0  */       0,     // drcThreshold     (X1000)
            /*    -0.2  */       0,     // drcMaximumVolume (X2)
            0x00000000,                 // drcEnable    = DISABLED
            0x0000000E,                 // layoutID     = [fill me in]
            0x00000004,                 // deviceID     = [fill me in]
            0x00000003,                 // speakerID    = [fill me in]
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}},
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}}
            }                           // end of filter set
		},
        {                               // ----------     Equalization Set #19     ----------
            /*  44100.0 */   44100,     // filterSampleRate
            /*     3.0  */       3,     // drcCompressionRatioNumerator
            /*     1.0  */       1,     // drcCompressionRatioDenominator
            /*     0.0  */       0,     // drcThreshold     (X1000)
            /*    -0.2  */       0,     // drcMaximumVolume (X2)
            0x00000000,                 // drcEnable    = DISABLED
            0x00000015,                 // layoutID     = (as appropriate)
            0x00000004,                 // deviceID     = external speaker
            0x00000003,                 // speakerID    = (as appropriate)
            0x00000000,                 // reserved     = 0 
            0x0000000C,                 // filterCount  = 12
            {                           // filter coefficients in sets of:  b0, b1, b2, a1, a2 and are in 4.20 format
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}},
                {{{ 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0x41 }, { 0x0F, 0xD5, 0xDF }, { 0xE0, 0x54, 0xB0 }, { 0x0F, 0xAC, 0x2D }}},
                {{{ 0x0F, 0xD9, 0xD4 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0xA1, 0xA2 }, { 0xE4, 0xAD, 0xC5 }, { 0x0E, 0x7B, 0x77 }}},
                {{{ 0x0F, 0x25, 0x80 }, { 0xE4, 0xF2, 0x09 }, { 0x0D, 0x36, 0xF8 }, { 0xE4, 0xF2, 0x09 }, { 0x0C, 0x5C, 0x78 }}},
                {{{ 0x0F, 0xDF, 0x40 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xFC, 0x07 }, { 0xE1, 0x83, 0x10 }, { 0x0E, 0xDB, 0x48 }}},
                {{{ 0x10, 0xEB, 0x1C }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0x05, 0xD9 }, { 0xF7, 0x7C, 0x0E }, { 0x09, 0xF0, 0xF5 }}},
                {{{ 0x0E, 0xC8, 0xEA }, { 0xF9, 0xEE, 0xBB }, { 0x0D, 0x9A, 0x24 }, { 0xF9, 0xEE, 0xBB }, { 0x0C, 0x63, 0x0E }}}
            }                           // end of filter set
		}
	}
};

#endif
