//--------------------------------------------------------------------------------
//
//	File:		AppleUSBAudioDevice.h
//
//	Contains:	Support for the USB Audio Class Control Interface.
//
//	Technology:	OS X
//
//--------------------------------------------------------------------------------

#ifndef _APPLEUSBAUDIODEVICE_H
#define _APPLEUSBAUDIODEVICE_H

#include <IOKit/audio/IOAudioDevice.h>
#include <IOKit/audio/IOAudioEngine.h>
#include <IOKit/audio/IOAudioPort.h>
#include <IOKit/audio/IOAudioControl.h>

#include "AppleUSBAudioCommon.h"
#include "USBAudioObject.h"

#include <IOKit/usb/IOUSBInterface.h>

#include <IOKit/IOLocks.h>

#define kStringBufferSize				255

class IOUSBInterface;
class AppleUSBAudioEngine;

/*
 * @class AppleUSBAudioDevice
 * @abstract : universal Apple USB driver
 * @discussion : Current version of the driver deals with outputing stereo 16 bits data at 44100kHz
 * It's gonna create an AppleUSBAudioEngine, and a serie
 */

class AppleUSBAudioDevice : public IOAudioDevice {
    OSDeclareDefaultStructors (AppleUSBAudioDevice);

    USBAudioConfigObject *	usbAudio;
    IOUSBInterface *		controlInterface;
    IOUSBInterface *		previousInterface;
    IORecursiveLock *		interfaceLock;
    IONotifier *			deviceNotifier;
    OSObject *				interfaceVendor;
    OSObject *				interfaceProduct;
    OSObject *				deviceReleaseNumber;
    OSObject *				configurationValue;
    OSObject *				interfaceNumber;
#if TIMERSTREAM
    bool					hasBeenUnattached;
#endif
    
public:
    virtual bool init (OSDictionary *properties);
    virtual void free ();
    virtual bool start (IOService *provider);
    virtual void stop (IOService *provider);
    virtual void performStop (IOService *provider);
#if DOUBLEPARENT
	virtual bool requestTerminate (IOService * provider, IOOptionBits options);
#endif
    virtual bool terminate (IOOptionBits options = 0);
    virtual bool finalize(IOOptionBits options);
    virtual IOReturn message (UInt32 type, IOService * provider, void * arg);
    virtual IOReturn activateAudioEngine (IOAudioEngine *audioEngine, bool shouldStartAudioEngine, UInt8 interfaceNum, UInt8 altInterfaceNum);
	static	IOReturn deviceRequest (IOUSBDevRequest * request, AppleUSBAudioDevice * self, IOUSBCompletion * completion = 0);
    virtual bool allStreamsStopped ();
#if 0
    virtual UInt32 getNumAttachedAudioDevices ();
#endif
    virtual USBAudioConfigObject * GetUSBAudioConfigObject (void) {return usbAudio;}
    virtual void streamStopped (IOAudioEngine *audioEngine);
#if TIMERSTREAM
    virtual bool isUnattachedDeviceRegistered ();
    virtual void registerUnattachedDevice ();
    virtual void unregisterUnattachedDevice ();
	static bool interfacePublished (AppleUSBAudioDevice *device, void *ref, IOService *newService);
    virtual bool reinitWithInterface (IOUSBInterface *interface);
    static IOReturn performUnattachedDeviceRegistrationAction (OSObject *owner, void *arg1, void *arg2, void *arg3, void *arg4);
    virtual bool performUnattachedDeviceRegistration ();
    static IOReturn reinitWithInterfaceAction (OSObject *owner, void *arg1, void *arg2, void *arg3, void *arg4);
#endif
    
#ifdef DEBUG
    virtual void retain() const;
    virtual void release() const;
#endif
};

#endif /* _APPLEUSBAUDIODEVICE_H */
