#ifndef _APPLEUSBAUDIOLEVELCONTROL_H
#define _APPLEUSBAUDIOLEVELCONTROL_H

#include <IOKit/audio/IOAudioLevelControl.h>
#include <IOKit/usb/IOUSBInterface.h>

class AppleUSBAudioDevice;
typedef struct call_entry *thread_call_t;

typedef IOReturn (*USBDeviceRequest)(IOUSBDevRequest * request, void * refCon = 0, IOUSBCompletion * completion = 0);

class AppleUSBAudioLevelControl : public IOAudioLevelControl
{
    OSDeclareDefaultStructors(AppleUSBAudioLevelControl);

    UInt8					unitID;
    UInt8					interfaceNumber;
    UInt8					controlSelector;
    UInt8					channelNumber;
    SInt16					offset;
	SInt16					volRes;
    thread_call_t			setValueThreadCall;
    USBDeviceRequest		usbDeviceRequest;
	void *					callerRefCon;

public:
	static AppleUSBAudioLevelControl *create(UInt8 theUnitID, UInt8 theInterfaceNumber, UInt8 theControlSelector, UInt8 theChannelNumber, USBDeviceRequest theUSBDeviceRequest, void *theCallerRefCon, UInt32 subType, UInt32 usage);

	virtual bool init(UInt8 theUnitID, UInt8 theInterfaceNumber, UInt8 theControlSelector, UInt8 theChannelNumber, USBDeviceRequest theUSBDeviceRequest, void *theCallerRefCon, UInt32 subType, UInt32 usage, OSDictionary *properties = NULL);
	virtual void free();

	virtual IOReturn performValueChange(OSObject * newValue);
	virtual void updateUSBValue();
	virtual void updateUSBValue(SInt32 newValue);

	static void updateValueCallback(void *arg1, void *arg2);

private:
	SInt16	GetCurVolume (UInt8 interfaceNumber, UInt8 channelNumber, IOReturn * error);
	SInt16	GetMaxVolume (UInt8 interfaceNumber, UInt8 channelNumber, IOReturn * error);
	SInt16	GetMinVolume (UInt8 interfaceNumber, UInt8 channelNumber, IOReturn * error);
	UInt16	GetVolumeResolution (UInt8 interfaceNumber, UInt8 channelNumber, IOReturn * error);
	IOReturn	SetCurVolume (UInt8 interfaceNumber, UInt8 channelNumber, SInt16 volume);
	IOFixed		ConvertUSBVolumeTodB (SInt16 volume);
	IORegistryEntry * FindEntryByNameAndProperty (const IORegistryEntry * start, const char * name, const char * key, UInt32 value);
};

#endif
