#include "AppleiSubDevice.h"

#define super IOService

OSDefineMetaClassAndStructors (AppleiSubDevice, super)

bool AppleiSubDevice::init (OSDictionary * properties) {
	bool							resultCode;

	debug3IOLog ("+AppleiSubDevice[%p]::init (%p)\n", this, properties);

	resultCode = super::init ();

	debug4IOLog ("-AppleiSubDevice[%p]::init (%p) = %d\n", this, properties, resultCode);
	return resultCode;
}

void AppleiSubDevice::free (void) {
	debug2IOLog ("+AppleiSubEngine[%p]::free ()\n", this);

	super::free ();

	debug2IOLog ("-AppleiSubEngine[%p]::free ()\n", this);
	return;
}

bool AppleiSubDevice::start (IOService * provider) {
	bool							resultCode;

	debug3IOLog ("+AppleiSubDevice[%p]::start (%p)\n", this, provider);

	resultCode = super::start (provider);

	debug4IOLog ("-AppleiSubDevice[%p]::start (%p) = %d\n", this, provider, resultCode);
	return resultCode;
}

void AppleiSubDevice::stop (IOService * provider) {
	debug2IOLog("+AppleiSubDevice[%p]::stop ()\n", this);

	super::stop (provider);

	debug2IOLog("-AppleiSubDevice[%p]::stop ()\n", this);
	return;
}

bool AppleiSubDevice::terminate (IOOptionBits options) {
	bool							resultCode;

	debug4IOLog ("+AppleiSubDevice[%p]::terminate (0x%x), rc=%d\n", this, options, getRetainCount ());

	resultCode = super::terminate (options);

	debug5IOLog ("-AppleiSubDevice[%p]::terminate (0x%x) = %d, rc=%d\n", this, options, resultCode, getRetainCount ());
	return resultCode;
}

bool AppleiSubDevice::finalize (IOOptionBits options) {
	bool							resultCode;

	debug4IOLog ("+AppleiSubDevice[%p]::finalize (%p), rc=%d\n", this, options, getRetainCount ());

	resultCode = super::finalize (options);

	debug5IOLog ("-AppleiSubDevice[%p]::finalize (%p) = %d, rc=%d\n", this, options, resultCode, getRetainCount ());
	return resultCode;
}
