#ifndef _APPLEUSBAUDIOCLIP_H
#define _APPLEUSBAUDIOCLIP_H

#include <libkern/OSTypes.h>

extern "C" {
//	floating point types
typedef	float				Float32;
typedef double				Float64;

typedef struct _sPreviousValues {
    Float32	xl_1;
    Float32	xr_1;
    Float32	xl_2;
    Float32	xr_2;
    Float32	yl_1;
    Float32	yr_1;
    Float32	yl_2;
    Float32	yr_2;
} PreviousValues;

// aml 2.21.02 added structure for 1st order phase compensator
// use in case of 2nd order crossover filter
typedef struct _sPreviousValues1stOrder {
    Float32	xl_1;
    Float32	xr_1;
    Float32	yl_1;
    Float32	yr_1;
} PreviousValues1stOrder;

UInt32 CalculateOffset (UInt64 nanoseconds, UInt32 sampleRate);

IOReturn clipAppleUSBAudioToOutputStreamiSub (const void *mixBuf,
											 void *sampleBuf,
											 PreviousValues *filterState,
                                                                                         // aml 2.21.02 adding extra state for 4th order filter and
                                                                                         // phase compensator
											 PreviousValues *filterState2,
											 PreviousValues *phaseCompState,
											 float *low,
											 float *high,
											 UInt32 firstSampleFrame,
											 UInt32 numSampleFrames,
											 UInt32 sampleRate,
											 const IOAudioStreamFormat *streamFormat,
											 SInt16 * iSubBufferMemory,
											 UInt32 *loopCount,
											 SInt32 *iSubBufferOffset,
											 UInt32 iSubBufferLen);

IOReturn	clipAppleUSBAudioToOutputStream (const void *mixBuf,
											void *sampleBuf,
											UInt32 firstSampleFrame,
											UInt32 numSampleFrames,
											const IOAudioStreamFormat *streamFormat);

IOReturn	convertFromAppleUSBAudioInputStream_NoWrap (const void *sampleBuf,
														void *destBuf,
														UInt32 firstSampleFrame,
														UInt32 numSampleFrames,
														const IOAudioStreamFormat *streamFormat);
}

#endif
