#ifndef _APPLEUSBAUDIOMUTECONTROL_H
#define _APPLEUSBAUDIOMUTECONTROL_H

#include <IOKit/audio/IOAudioToggleControl.h>
#include <IOKit/audio/IOAudioTypes.h>
#include <IOKit/usb/IOUSBInterface.h>

class AppleUSBAudioDevice;
typedef struct call_entry *thread_call_t;

typedef IOReturn (*USBDeviceRequest)(IOUSBDevRequest * request, void * refCon = 0, IOUSBCompletion * completion = 0);

class AppleUSBAudioMuteControl : public IOAudioToggleControl
{
    OSDeclareDefaultStructors (AppleUSBAudioMuteControl);

    UInt8					unitID;
    UInt8					interfaceNumber;
    UInt8					channelNumber;
    AppleUSBAudioDevice *	audioDevice;
    thread_call_t			setValueThreadCall;
    USBDeviceRequest		usbDeviceRequest;
	void *					callerRefCon;

public:
    static AppleUSBAudioMuteControl *create (UInt8 theUnit, UInt8 theInterfaceNumber, UInt8 theChannelNumber, USBDeviceRequest theUSBDeviceRequest, void *theCallerRefCon, UInt32 usage, UInt32 subType = kIOAudioToggleControlSubTypeMute, UInt32 controlID = 0);

    virtual bool init (UInt8 theUnit, UInt8 theInterfaceNumber, UInt8 theChannelNumber, USBDeviceRequest theUSBDeviceRequest, void *theCallerRefCon, UInt32 usage, UInt32 subType, UInt32 controlID = 0, OSDictionary *properties = NULL);
    virtual void free ();

    virtual IOReturn performValueChange (OSObject * newValue);
    virtual void updateUSBValue ();
    virtual void updateUSBValue (SInt32 newValue);

    static void updateValueCallback (void *arg1, void *arg2);

private:
	UInt8		GetCurMute (UInt8 interfaceNumber, UInt8 channelNumber, IOReturn * error);
	IOReturn	SetCurMute (UInt8 interfaceNumber, UInt8 channelNumber, UInt8 theMuteState);
//	IORegistryEntry * FindEntryByNameAndProperty (const IORegistryEntry * start, const char * name, const char * key, UInt32 value);
};

#endif
