//--------------------------------------------------------------------------------
//
//	File:		AppleUSBAudioStream.h
//
//	Contains:	Support for the USB Audio Class Stream Interface.
//
//	Technology:	OS X
//
//--------------------------------------------------------------------------------

#ifndef _APPLEUSBAUDIOCOMMON_H
#define _APPLEUSBAUDIOCOMMON_H

#include <libkern/OSTypes.h>

//	-----------------------------------------------------------------
#define SoundAssertionMessage( cond, file, line, handler ) \
    "Sound assertion \"" #cond "\" failed in " #file " at line " #line " goto " #handler "\n"

#define SoundAssertionFailed( cond, file, line, handler ) \
    IOLog( SoundAssertionMessage( cond, file, line, handler ));

//	-----------------------------------------------------------------
#ifdef DEBUG
#define	FailIf( cond, handler )										\
    if( cond ){														\
        SoundAssertionFailed( cond, __FILE__, __LINE__, handler )	\
        goto handler; 												\
    }
#else
#define	FailIf( cond, handler )										\
    if( cond ){														\
        goto handler; 												\
    }
#endif

//	-----------------------------------------------------------------
#ifdef DEBUG
#define	FailWithAction( cond, action, handler )						\
    if( cond ){														\
        SoundAssertionFailed( cond, __FILE__, __LINE__, handler )	\
            { action; }												\
        goto handler; 												\
    }
#else
#define	FailWithAction( cond, action, handler )						\
    if( cond ){														\
            { action; }												\
        goto handler; 												\
    }
#endif

//	-----------------------------------------------------------------
#ifdef DEBUG
#define FailMessage(cond, handler)									\
	if (cond) {														\
		SoundAssertionFailed(cond, __FILE__, __LINE__, handler)		\
		goto handler;												\
	}
#else
#define FailMessage(cond, handler)									\
	if (cond) {														\
		goto handler;												\
	}
#endif

//	-----------------------------------------------------------------
#ifdef DEBUGLOG
#define SLEEPTIME		20
//#define SLEEPTIME		0
#define debugIOLog( message ) \
	{IOLog( message ); IOSleep(SLEEPTIME);}
#define debug2IOLog( message, arg2 ) \
	{IOLog( message, arg2 ); IOSleep(SLEEPTIME);}
#define debug3IOLog( message, arg2, arg3 ) \
	{IOLog( message, arg2, arg3 ); IOSleep(SLEEPTIME);}
#define debug4IOLog( message, arg2, arg3, arg4 ) \
	{IOLog( message, arg2, arg3, arg4 ); IOSleep(SLEEPTIME);}
#define debug5IOLog( message, arg2, arg3, arg4, arg5 ) \
	{IOLog( message, arg2, arg3, arg4, arg5 ); IOSleep(SLEEPTIME);}
#define debug6IOLog( message, arg2, arg3, arg4, arg5, arg6 ) \
	{IOLog( message, arg2, arg3, arg4, arg5, arg6 ); IOSleep(SLEEPTIME);}
#define debug7IOLog( message, arg2, arg3, arg4, arg5, arg6, arg7 ) \
	{IOLog( message, arg2, arg3, arg4, arg5, arg6, arg7 ); IOSleep(SLEEPTIME);}
#define debug8IOLog( message, arg2, arg3, arg4, arg5, arg6, arg7, arg8 ) \
	{IOLog( message, arg2, arg3, arg4, arg5, arg6, arg7, arg8 ); IOSleep(SLEEPTIME);}
#else
#define debugIOLog( message ) ;
#define debug2IOLog( message, arg2 ) ;
#define debug3IOLog( message, arg2, arg3 ) ;
#define debug4IOLog( message, arg2, arg3, arg4 ) ;
#define debug5IOLog( message, arg2, arg3, arg4, arg5 ) ;
#define debug6IOLog( message, arg2, arg3, arg4, arg5, arg6 ) ;
#define debug7IOLog( message, arg2, arg3, arg4, arg5, arg6, arg7 ) ;
#define debug8IOLog( message, arg2, arg3, arg4, arg5, arg6, arg7, arg8 ) ;
#endif

#define	AudioByteSwap16(x)	(((x>>8) & 0x00FF) | ((x<<8) & 0xFF00))

//	---------------------<< begin TRINTIY >>-------------------------
//#define	kForTRINITY
#define	kTrinityVendorID					0x05AC		/*	big endian	*/
#define	kTrinityProductID					0x1101		/*	big endian	*/
#define	kTrinityVendorProductID				(( kTrinityVendorID << 16 ) | kTrinityProductID )
#define kTrinityStreamAlternateSetting		2
#define	kTrinityMinimumVolume				0xD000
#define	kTrinityMaximumVolume				0x0000
#define	kTrinityMinumumBass					0xD0
#define	kTrinityMaximumBass					0x30
#define	kTrinityMinumumTreble				0xD0
#define	kTrinityMaximumTreble				0x30
//	----------------------<< end TRINTIY >>---------------------------


// #define	kUSBAudioClass					1
#define	kUSBAudioControlInterfaceSubclass	1
#define	kUSBAudioStreamInterfaceSubclass	2
#define	kRootAlternateSetting				0

#define kMasterVolumeControlID				0
#define kMuteControlID						1

#endif /* _APPLEUSBAUDIOCOMMON_H */
