//--------------------------------------------------------------------------------
//
//	File:		AppleUSBAudioStream.h
//
//	Contains:	Support for the USB Audio Class Stream Interface.
//
//	Technology:	OS X
//
//--------------------------------------------------------------------------------

#ifndef _APPLEUSBAUDIOCOMMON_H
#define _APPLEUSBAUDIOCOMMON_H

#define DEBUG_LEVEL DEBUG_LEVEL_FINAL

#include <libkern/OSTypes.h>
#include "IOKit/usb/IOUSBLog.h"

//	-----------------------------------------------------------------
#define SoundAssertionMessage( cond, file, line, handler ) \
    "Sound assertion \"" #cond "\" failed in " #file " at line " #line " goto " #handler ""

#define SoundAssertionFailed( cond, file, line, handler ) \
    debugIOLog( SoundAssertionMessage( cond, file, line, handler ));

//	-----------------------------------------------------------------
#ifdef DEBUG
#define	FailIf( cond, handler )										\
    if( cond ){														\
        SoundAssertionFailed( cond, __FILE__, __LINE__, handler )	\
        goto handler; 												\
    }
#else
#define	FailIf( cond, handler )										\
    if( cond ){														\
        goto handler; 												\
    }
#endif

//	-----------------------------------------------------------------
#ifdef DEBUG
#define	FailWithAction( cond, action, handler )						\
    if( cond ){														\
        SoundAssertionFailed( cond, __FILE__, __LINE__, handler )	\
            { action; }												\
        goto handler; 												\
    }
#else
#define	FailWithAction( cond, action, handler )						\
    if( cond ){														\
            { action; }												\
        goto handler; 												\
    }
#endif

//	-----------------------------------------------------------------
#ifdef DEBUG
#define FailMessage(cond, handler)									\
	if (cond) {														\
		SoundAssertionFailed(cond, __FILE__, __LINE__, handler)		\
		goto handler;												\
	}
#else
#define FailMessage(cond, handler)									\
	if (cond) {														\
		goto handler;												\
	}
#endif

//	-----------------------------------------------------------------
#if 0
#ifdef DEBUGLOG
#define debugIOLog( message... ) \
	do {IOLog( message ); IOSleep(20);} while (0)
#else
#define debugIOLog( message... ) ;
#endif
#endif

#ifdef DEBUGLOG
#define debugIOLog( message... ) \
	do {USBLog( DEBUG_LEVEL_DEVELOPMENT, message );} while (0)
#else
#define debugIOLog( message... ) ;
#endif

#define	AudioByteSwap16(x)	(((x>>8) & 0x00FF) | ((x<<8) & 0xFF00))

//	---------------------<< begin TRINTIY >>-------------------------
//#define	kForTRINITY
#define	kTrinityVendorID					0x05AC		/*	big endian	*/
#define	kTrinityProductID					0x1101		/*	big endian	*/
#define	kTrinityVendorProductID				(( kTrinityVendorID << 16 ) | kTrinityProductID )
#define kTrinityStreamAlternateSetting		2
#define	kTrinityMinimumVolume				0xD000
#define	kTrinityMaximumVolume				0x0000
#define	kTrinityMinumumBass					0xD0
#define	kTrinityMaximumBass					0x30
#define	kTrinityMinumumTreble				0xD0
#define	kTrinityMaximumTreble				0x30
//	----------------------<< end TRINTIY >>---------------------------


// #define	kUSBAudioClass					1
#define	kUSBAudioControlInterfaceSubclass	1
#define	kUSBAudioStreamInterfaceSubclass	2
#define	kRootAlternateSetting				0

#define kMasterVolumeControlID				0
#define kMuteControlID						1

#endif /* _APPLEUSBAUDIOCOMMON_H */
