//--------------------------------------------------------------------------------
//
//	File:		AppleUSBAudioDevice.h
//
//	Contains:	Support for the USB Audio Class Control Interface.
//
//	Technology:	OS X
//
//--------------------------------------------------------------------------------

#ifndef _APPLEUSBAUDIODEVICE_H
#define _APPLEUSBAUDIODEVICE_H

#include <libkern/c++/OSCollectionIterator.h>

#include <IOKit/IOLocks.h>
#include <IOKit/IOLib.h>
#include <IOKit/IOKitKeys.h>
#include <IOKit/IORegistryEntry.h>
#include <IOKit/IOMessage.h>

#include <IOKit/audio/IOAudioDevice.h>
#include <IOKit/audio/IOAudioEngine.h>
#include <IOKit/audio/IOAudioPort.h>
#include <IOKit/audio/IOAudioControl.h>
#include <IOKit/audio/IOAudioStream.h>
#include <IOKit/audio/IOAudioDefines.h>

#include <IOKit/usb/USB.h>
#include <IOKit/usb/IOUSBInterface.h>
#include <IOKit/usb/IOUSBRootHubDevice.h>

#include "AppleUSBAudioMuteControl.h"
#include "AppleUSBAudioLevelControl.h"
#include "AppleUSBAudioEngine.h"
#include "AppleUSBAudioCommon.h"
#include "USBAudioObject.h"

#define kStringBufferSize				255

enum {
	kIOUSBVendorIDHaronKardon			= 0x074D,
	kIOUSBVendorMicronas				= 0x05FC
};

enum {
	kStudioDisplay15CRT					= 0x9115,
	kStudioDisplay17CRT					= 0x9113,
	kCinemaDisplay						= 0x9116,
	kStudioDisplay17FP					= 0x9117
};

class IOUSBInterface;
class AppleUSBAudioEngine;

/*
 * @class AppleUSBAudioDevice
 * @abstract : universal Apple USB driver
 * @discussion : Current version of the driver deals with outputing stereo 16 bits data at 44100kHz
 * It's gonna create an AppleUSBAudioEngine, and a serie
 */

class AppleUSBAudioDevice : public IOAudioDevice {
    OSDeclareDefaultStructors (AppleUSBAudioDevice);

public:
    IOUSBInterface *					controlInterface;

protected:
    USBAudioConfigObject *				usbAudio;
    IORecursiveLock *					interfaceLock;
	Boolean								terminatingDriver;
	thread_call_t						mInitHardwareThread;

public:
    virtual bool			init (OSDictionary *properties);
	virtual bool			start (IOService * provider);
    virtual void			free ();
    virtual void			stop (IOService *provider);
    virtual void			performStop (IOService *provider);
	virtual bool			initHardware (IOService * provider);
	static void				initHardwareThread (AppleUSBAudioDevice * aua, void * provider);
	static IOReturn			initHardwareThreadAction (OSObject * owner, void * provider, void * arg2, void * arg3, void * arg4);
	virtual IOReturn		protectedInitHardware (IOService * provider);
	virtual Boolean			ShouldUpdatePRAM (void);
			Boolean			FindSoundNode (void);
	virtual bool			requestTerminate (IOService * provider, IOOptionBits options);
    virtual bool			terminate (IOOptionBits options = 0);
    virtual bool			finalize(IOOptionBits options);
    virtual IOReturn		message (UInt32 type, IOService * provider, void * arg);
	virtual bool ControlsStreamNumber (UInt8 streamNumber);
	virtual IOReturn		createControlsForInterface (IOAudioEngine *audioEngine, UInt8 interfaceNum, UInt8 altInterfaceNum);
    virtual IOReturn		activateAudioEngine (IOAudioEngine *audioEngine, bool shouldStartAudioEngine, UInt8 interfaceNum, UInt8 altInterfaceNum);
	static	IOReturn		deviceRequest (IOUSBDevRequest * request, AppleUSBAudioDevice * self, IOUSBCompletion * completion = 0);
//    virtual bool			allStreamsStopped ();
	virtual IOReturn		performPowerStateChange (IOAudioDevicePowerState oldPowerState, IOAudioDevicePowerState newPowerState, UInt32 *microSecsUntilComplete);
    virtual USBAudioConfigObject * GetUSBAudioConfigObject (void) {return usbAudio;}
//    virtual void			streamStopped (IOAudioEngine *audioEngine);
	virtual bool			willTerminate (IOService * provider, IOOptionBits options);

#ifdef DEBUG
    virtual void			retain() const;
    virtual void			release() const;
#endif
};

#endif /* _APPLEUSBAUDIODEVICE_H */
