/*
 * Copyright (c) 1998-2003 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Copyright (c) 1999-2003 Apple Computer, Inc.  All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

#include "AppleUSBAudioPlugin.h"

#include <IOKit/IOLib.h>

#define super IOService

OSDefineMetaClassAndStructors (AppleUSBAudioPlugin, IOService)

OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 0);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 1);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 2);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 3);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 4);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 5);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 6);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 7);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 8);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 9);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 10);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 11);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 12);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 13);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 14);
OSMetaClassDefineReservedUnused(AppleUSBAudioPlugin, 15);

// Standard IOService.h function methods
bool AppleUSBAudioPlugin::start (IOService * provider) {
	if (!super::start (provider)) {
		return FALSE;
	}

	mOurProvider = (AppleUSBAudioEngine *)provider;

	// Tell AppleUSBAudio that we're loaded
	mOurProvider->registerPlugin (this);

	return TRUE;
}

void AppleUSBAudioPlugin::stop (IOService * provider) {
	// Tell the system that we're not an available resource anymore
	publishResource ("AppleUSBAudioPlugin", NULL);

	super::stop (provider);
}

IOReturn AppleUSBAudioPlugin::pluginDeviceRequest (IOUSBDevRequest * request, IOUSBCompletion * completion) {
	IOReturn						result;

	result = kIOReturnError;
	if (mOurProvider) {
		result = mOurProvider->pluginDeviceRequest (request, completion);
	}

	return result;
}

// Methods that the plugin will override
IOReturn AppleUSBAudioPlugin::pluginInit (IOService * provider, UInt16 vendorID, UInt16 modelID) {
	return kIOReturnSuccess;
}

IOReturn AppleUSBAudioPlugin::pluginStart () {
	return kIOReturnSuccess;
}

IOReturn AppleUSBAudioPlugin::pluginSetFormat (const IOAudioStreamFormat * const newFormat, const IOAudioSampleRate * const newSampleRate) {
	return kIOReturnSuccess;
}

IOReturn AppleUSBAudioPlugin::pluginReset () {
	return kIOReturnSuccess;
}

IOReturn AppleUSBAudioPlugin::pluginProcess (float * mixBuf, UInt32 numSampleFrames, UInt32 numChannels) {
	return kIOReturnSuccess;
}

IOReturn AppleUSBAudioPlugin::pluginStop () {
	return kIOReturnSuccess;
}
