//--------------------------------------------------------------------------------
//
//	File:		AppleUSBAudioStream.h
//
//	Contains:	Support for the USB Audio Class Stream Interface.
//
//	Technology:	OS X
//
//--------------------------------------------------------------------------------

#ifndef _APPLEUSBAUDIOCOMMON_H
#define _APPLEUSBAUDIOCOMMON_H

#ifdef DEBUGLOGGING
#define DEBUG_LEVEL 1
#endif

#include <libkern/OSTypes.h>
#include <IOKit/usb/IOUSBLog.h>

//	-----------------------------------------------------------------
#define SoundAssertionMessage( cond, file, line, handler ) \
    "Sound assertion \"" #cond "\" failed in " #file " at line " #line " goto " #handler ""

#define SoundAssertionFailed( cond, file, line, handler ) \
	{IOLog( SoundAssertionMessage( cond, file, line, handler )); IOSleep(20);};

//	-----------------------------------------------------------------
#define	FailIf( cond, handler )										\
    if( cond ){														\
        SoundAssertionFailed( cond, __FILE__, __LINE__, handler )	\
        goto handler; 												\
    }

//	-----------------------------------------------------------------
#define	FailWithAction( cond, action, handler )						\
    if( cond ){														\
        SoundAssertionFailed( cond, __FILE__, __LINE__, handler )	\
            { action; }												\
        goto handler; 												\
    }

//	-----------------------------------------------------------------
#define FailMessage(cond, handler)									\
	if (cond) {														\
		SoundAssertionFailed(cond, __FILE__, __LINE__, handler)		\
		goto handler;												\
	}

//	-----------------------------------------------------------------
#if 0
#ifdef DEBUGLOGGING
#define debugIOLog( message... ) \
	do {IOLog( message ); IOSleep(20);} while (0)
#else
#define debugIOLog( message... ) ;
#endif
#endif

#ifdef DEBUGLOGGING
#define debugIOLog( message... ) \
	do {USBLog( DEBUG_LEVEL_DEVELOPMENT, message );} while (0)
#else
#define debugIOLog( message... ) ;
#endif

#endif /* _APPLEUSBAUDIOCOMMON_H */
