//--------------------------------------------------------------------------------
//
//	File:		AppleUSBAudioStream.h
//
//	Contains:	Support for the USB Audio Class Stream Interface.
//
//	Technology:	OS X
//
//--------------------------------------------------------------------------------

#ifndef _APPLEUSBAUDIOCOMMON_H
#define _APPLEUSBAUDIOCOMMON_H

#ifdef DEBUGLOGGING
#define DEBUG_LEVEL 1
#endif

#include <libkern/OSTypes.h>
#include <IOKit/usb/IOUSBLog.h>

//	-----------------------------------------------------------------
#define SoundAssertionMessage( cond, file, line, handler ) \
    "Sound assertion \"" #cond "\" failed in " #file " at line " #line " goto " #handler ""

#define SoundAssertionFailed( cond, file, line, handler ) \
	{debugIOLog( SoundAssertionMessage( cond, file, line, handler )); IOSleep(20);};

//	-----------------------------------------------------------------
#define	FailIf( cond, handler )										\
    if( cond ){														\
        SoundAssertionFailed( cond, __FILE__, __LINE__, handler )	\
        goto handler; 												\
    }

//	-----------------------------------------------------------------
#define	FailWithAction( cond, action, handler )						\
    if( cond ){														\
        SoundAssertionFailed( cond, __FILE__, __LINE__, handler )	\
            { action; }												\
        goto handler; 												\
    }

//	-----------------------------------------------------------------
#define FailMessage(cond, handler)									\
	if (cond) {														\
		SoundAssertionFailed(cond, __FILE__, __LINE__, handler)		\
		goto handler;												\
	}

//  -----------------------------------------------------------------
//
// System Logging or USB Prober Logging
//
//#define sleepTime 20
#define sleepTime 0

#ifdef DEBUGLOGGING /* { */
	#ifdef CONSOLELOGGING /* { */
		#define debugIOLog( message... ) \
			do {IOLog( #message "\n", message ); IOSleep(sleepTime);} while (0)
	#elif defined (DEBUGLOG_TO_KPRINTF) /* }{ */
			#define debugIOLog( message... ) \
				do { kprintf ( message ); kprintf ( "\n" ); } while (0)
	#else /* }{ */
		#define debugIOLog( message... ) \
			do {USBLog( DEBUG_LEVEL_DEVELOPMENT, message );} while (0)
	#endif /* } */
#else /* }{ */
	#define debugIOLog( message... ) ;
#endif /* } */

#endif /* _APPLEUSBAUDIOCOMMON_H */
