#ifndef _APPLEUSBAUDIOLEVELCONTROL_H
#define _APPLEUSBAUDIOLEVELCONTROL_H

#include <sys/cdefs.h>

__BEGIN_DECLS
#include <kern/thread_call.h>
__END_DECLS

#include <libkern/OSByteOrder.h>

#include <IOKit/IOLib.h>
#include <IOKit/IOPlatformExpert.h>

#include <IOKit/usb/USB.h>
#include <IOKit/usb/IOUSBInterface.h>

#include <IOKit/audio/IOAudioLevelControl.h>
#include <IOKit/audio/IOAudioTypes.h>
#include <IOKit/audio/IOAudioDefines.h>

#include "AppleUSBAudioCommon.h"
#include "USBAudioObject.h"

class AppleUSBAudioDevice;
typedef struct call_entry *thread_call_t;

typedef IOReturn (*USBDeviceRequest)(IOUSBDevRequest * request, void * refCon = 0, IOUSBCompletion * completion = 0);

// PRAM read write values
enum{
	kMaximumPRAMVolume 	= 	7,
	kMinimumPRAMVolume	= 	0,
	KNumPramVolumeSteps	= 	(kMaximumPRAMVolume - kMinimumPRAMVolume + 1),
	kPRamVolumeAddr	= 		8,

	kDefaultVolume	= 0x006E006E,
	kInvalidVolumeMask	= 0xFE00FE00
};

#define kiSubMaxVolume		60
#define kiSubVolumePercent	92

class AppleUSBAudioLevelControl : public IOAudioLevelControl
{
    OSDeclareDefaultStructors(AppleUSBAudioLevelControl);

    UInt8					unitID;
    UInt8					interfaceNumber;
    UInt8					controlSelector;
    UInt8					channelNumber;
    SInt16					offset;
	UInt16					volRes;
    thread_call_t			setValueThreadCall;
    USBDeviceRequest		usbDeviceRequest;
	void *					callerRefCon;
	Boolean					gExpertMode;
    UInt32					fMaxVolume;
    UInt32					fMinVolume;
	Boolean					fShouldUpdatePRAM;

public:
	static AppleUSBAudioLevelControl *create(UInt8 theUnitID, UInt8 theInterfaceNumber, UInt8 theControlSelector, UInt8 theChannelNumber, Boolean shouldUpdatePRAM, USBDeviceRequest theUSBDeviceRequest, void *theCallerRefCon, UInt32 subType, UInt32 usage);

	virtual bool init(UInt8 theUnitID, UInt8 theInterfaceNumber, UInt8 theControlSelector, UInt8 theChannelNumber, Boolean shouldUpdatePRAM, USBDeviceRequest theUSBDeviceRequest, void *theCallerRefCon, UInt32 subType, UInt32 usage, OSDictionary *properties = NULL);
	virtual void free();

	virtual IOReturn performValueChange(OSObject * newValue);
	virtual void updateUSBValue();
	virtual void updateUSBValue(SInt32 newValue);

	static void updateValueCallback(void *arg1, void *arg2);

private:
	IOReturn	GetCurVolume (UInt8 interfaceNumber, UInt8 channelNumber, SInt16 * target);
	IOReturn	GetMaxVolume (UInt8 interfaceNumber, UInt8 channelNumber, SInt16 * target);
	IOReturn	GetMinVolume (UInt8 interfaceNumber, UInt8 channelNumber, SInt16 * target);
	IOReturn	GetVolumeResolution (UInt8 interfaceNumber, UInt8 channelNumber, UInt16 * target);
	IOReturn	SetCurVolume (UInt8 interfaceNumber, UInt8 channelNumber, SInt16 volume);
	IOFixed		ConvertUSBVolumeTodB (SInt16 volume);
//	IORegistryEntry * FindEntryByNameAndProperty (const IORegistryEntry * start, const char * name, const char * key, UInt32 value);
	UInt8 VolumeToPRAMValue (SInt32 leftVol, SInt32 rightVol);
	void WritePRAMVol (SInt32 leftVol, SInt32 rightVol);
};

#endif
