#ifndef _APPLEUSBTRINITYAUDIODEVICE_H
#define _APPLEUSBTRINITYAUDIODEVICE_H

#include "AppleUSBAudioDevice.h"

#define V8_WRITE_START_ADDR			0xb042
#define V8_PLUGIN_START_ADDR		0x8120
#define XDFP_STARTING_EQ_ADDR		0x50

#define EQ_TABLE_SIZE				16

#define kMicronasSetMemReq			4
#define kMicronasGetMemReq			5

#define MAX_EQ_DOWNLOAD_RETRIES		200

class AppleUSBTrinityAudioDevice : public AppleUSBAudioDevice {
    OSDeclareDefaultStructors (AppleUSBTrinityAudioDevice);

    UInt32					mEQRetryCount;

public:
    virtual bool			start (IOService * provider);

	virtual IOReturn		performPowerStateChange (IOAudioDevicePowerState oldPowerState, IOAudioDevicePowerState newPowerState, UInt32 *microSecsUntilComplete);

protected:

    virtual IOReturn		xdfpGetMem (UInt8 * buf, UInt16 length, UInt16 xdfpAddr);
    virtual IOReturn		xdfpSetMem (UInt8 * buf, UInt16 length, UInt16 xdfpAddr);

    virtual IOReturn		xdfpWrite (UInt16 xdfpAddr, SInt32 value);

    virtual IOReturn		disablePlugin ();
    virtual IOReturn		downloadEQ ();
    virtual IOReturn		downloadEQ (SInt32 * eqSettings);
    virtual IOReturn		downloadPlugin ();
    virtual IOReturn		enablePlugin ();

    virtual SInt32 *		getProperEQSettings ();

    virtual void			attemptEQDownload ();
    virtual void			scheduleEQDownloadRetry ();

    static void				retryEQDownload (void *arg);
};

#endif
