#include "AppleiSubDevice.h"

#define super IOService

OSDefineMetaClassAndStructors (AppleiSubDevice, super)

bool AppleiSubDevice::init (OSDictionary * properties) {
	bool							resultCode;

	debugIOLog ("+ AppleiSubDevice[%p]::init (%p)", this, properties);

	resultCode = super::init ();

	debugIOLog ("- AppleiSubDevice[%p]::init (%p) = %d", this, properties, resultCode);
	return resultCode;
}

void AppleiSubDevice::free (void) {
	debugIOLog ("+ AppleiSubEngine[%p]::free ()", this);

	super::free ();

	debugIOLog ("- AppleiSubEngine[%p]::free ()", this);
	return;
}

bool AppleiSubDevice::start (IOService * provider) {
	bool							resultCode;

	debugIOLog ("+ AppleiSubDevice[%p]::start (%p)", this, provider);

	resultCode = super::start (provider);

	debugIOLog ("- AppleiSubDevice[%p]::start (%p) = %d", this, provider, resultCode);
	return resultCode;
}

void AppleiSubDevice::stop (IOService * provider) {
	debugIOLog("+ AppleiSubDevice[%p]::stop ()", this);

	super::stop (provider);

	debugIOLog("- AppleiSubDevice[%p]::stop ()", this);
	return;
}

bool AppleiSubDevice::terminate (IOOptionBits options) {
	bool							resultCode;

	debugIOLog ("+ AppleiSubDevice[%p]::terminate (0x%x), rc=%d", this, options, getRetainCount ());

	resultCode = super::terminate (options);

	debugIOLog ("- AppleiSubDevice[%p]::terminate (0x%x) = %d, rc=%d", this, options, resultCode, getRetainCount ());
	return resultCode;
}

bool AppleiSubDevice::finalize (IOOptionBits options) {
	bool							resultCode;

	debugIOLog ("+ AppleiSubDevice[%p]::finalize (%p), rc=%d", this, options, getRetainCount ());

	resultCode = super::finalize (options);

	debugIOLog ("- AppleiSubDevice[%p]::finalize (%p) = %d, rc=%d", this, options, resultCode, getRetainCount ());
	return resultCode;
}
