/*
	File:		AppleUSBProKbd.h
	Contains:	Driver for second Apple Pro USB Keyboard interface (multimedia keys)
	Version:	1.0
	Copyright:	 2000 by Apple, all rights reserved.

	File Ownership:

		DRI:				Jason Giles
		Other Contact:		Bob Bradley
		Technology:			Apple Pro Keyboard (USB)

	Writers:

		(JG)	Jason Giles

	Change History (most recent first):
		
		 <2>	 12/4/00	JG		Inherit from IOHIKeyboard. Remove unused member vars.
		 <1>	 7/25/00	JG		First checked in.
*/

// Misc IOKit action.

#include <IOKit/IOBufferMemoryDescriptor.h>
#include <IOKit/IOLib.h>
#include <IOKit/IOService.h>

// HID system includes.

#include <IOKit/hidsystem/IOHIDDescriptorParser.h>
#include <IOKit/hidsystem/IOHIDShared.h>
#include <IOKit/hidsystem/IOHIKeyboard.h>

// usb includes.

#include <IOKit/usb/IOUSBBus.h>
#include <IOKit/usb/IOUSBDevice.h>
#include <IOKit/usb/IOUSBInterface.h>
#include <IOKit/usb/IOUSBPipe.h>
#include <IOKit/usb/USB.h>

// extra includes.

#include <libkern/OSByteOrder.h>

//====================================================================================================
//	AppleUSBProKbd
//	Driver for the Apple Pro USB Keyboard's second interface (#1).
//====================================================================================================

class AppleUSBProKbd : public IOHIKeyboard
{
    OSDeclareDefaultStructors(AppleUSBProKbd)

public:

	// Overrides of IOService.
		  
    virtual	bool	start( IOService * provider );
    virtual	void 	stop( IOService *  provider );
    virtual IOReturn 	message( UInt32 type, IOService * provider,  void * argument = 0 );
   
   	// Overrides of IOHIKeyboard.

	const unsigned char *	defaultKeymapOfLength( UInt32 * length );
	unsigned 				eventFlags();
	bool 					alphaLock();
	
	// Our implementation specific stuff.
		  
			bool					VerifyNewDevice( void );
	static	void 					ReadHandler( OSObject*	inTarget,
												 void * 	inParameter,
												 IOReturn	inStatus,
												 UInt32		inBufferSizeRemaining );
			void 					HandleSpecialButtons( UInt8 *	inBufferData,
														  UInt32	bufferSize		);
			UInt32					FindKeyboardsAndGetModifiers();

protected:

	IOUSBInterface *				mInterface;
	IOUSBPipe *						mInterruptPipe;
	HIDPreparsedDataRef				mPreparsedReportDescriptorData;
	IOBufferMemoryDescriptor *		mReadDataBuffer;
	IOUSBCompletion					mCompletionRoutine;
	UInt16							mMaxPacketSize;
	
	Boolean							mSoundUpIsPressed;
	Boolean							mSoundDownIsPressed;
	
	unsigned						mEventFlags;
	bool							mCapsLockOn;

private:
	bool			fTerminating;
};
