/*
	File:		AppleUSBProKbd.h
	Contains:	Driver for second Apple Pro USB Keyboard interface (multimedia keys)
	Version:	1.0
	Copyright:	 2000 by Apple, all rights reserved.

	File Ownership:

		DRI:				Jason Giles
		Other Contact:		Bob Bradley
		Technology:			Apple Pro Keyboard (USB)

	Writers:

		(JG)	Jason Giles

	Change History (most recent first):
		
		 <2>	 12/4/00	JG		Inherit from IOHIKeyboard. Remove unused member vars.
		 <1>	 7/25/00	JG		First checked in.
*/

// Misc IOKit action.

#include <IOKit/IOBufferMemoryDescriptor.h>
#include <IOKit/IOLib.h>
#include <IOKit/IOService.h>

// HID system includes.

#include <IOKit/hidsystem/IOHIDDescriptorParser.h>
#include <IOKit/hidsystem/IOHIDShared.h>
#include <IOKit/hidsystem/IOHIKeyboard.h>

// usb includes.

#include <IOKit/usb/IOUSBBus.h>
#include <IOKit/usb/IOUSBDevice.h>
#include <IOKit/usb/IOUSBInterface.h>
#include <IOKit/usb/IOUSBPipe.h>
#include <IOKit/usb/USB.h>

// extra includes.

#include <libkern/OSByteOrder.h>

//====================================================================================================
//	AppleUSBProKbd
//	Driver for the Apple Pro USB Keyboard's second interface (#1).
//====================================================================================================

class AppleUSBProKbd : public IOHIKeyboard
{
    OSDeclareDefaultStructors(AppleUSBProKbd)

    IOUSBInterface *				mInterface;
    IOUSBPipe *					mInterruptPipe;
    IOBufferMemoryDescriptor *			mReadDataBuffer;
    IOCommandGate *				mGate;

    IOUSBCompletion				mCompletionRoutine;
    HIDPreparsedDataRef				mPreparsedReportDescriptorData;
    
    UInt32					mOutstandingIO;
    
    UInt16					mMaxPacketSize;
    
    Boolean					mSoundUpIsPressed;
    Boolean					mSoundDownIsPressed;
    
    unsigned					mEventFlags;
    bool					mCapsLockOn;
    bool					mNeedToClose;

    // IOService methods
    virtual bool	init(OSDictionary *properties);
    virtual bool	start( IOService * provider );
    virtual void 	stop( IOService *  provider );
    virtual IOReturn 	message( UInt32 type, IOService * provider,  void * argument = 0 );
    virtual bool 	willTerminate( IOService * provider, IOOptionBits options );
    virtual bool 	didTerminate( IOService * provider, IOOptionBits options, bool * defer );
   
    // IOHIKeyboard methods
    virtual const unsigned char*	defaultKeymapOfLength( UInt32 * length );
    virtual unsigned 			eventFlags();
    virtual bool 			alphaLock();
	
    // Our implementation specific stuff.
    bool	VerifyNewDevice( void );
    void	HandleSpecialButtons( UInt8 *inBufferData, UInt32 bufferSize);
    UInt32	FindKeyboardsAndGetModifiers();
    void	DecrementOutstandingIO(void);
    void	IncrementOutstandingIO(void);
    void 	InterruptReadHandler(IOReturn status, UInt32 bufferSizeRemaining);
    
    // static methods for callbacks and gated calls
    static void 	InterruptReadHandlerEntry(OSObject* inTarget, void *inParameter, IOReturn inStatus, UInt32 inBufferSizeRemaining );
    static IOReturn	ChangeOutstandingIO(OSObject *owner, void *arg0, void *arg1, void *arg2, void *arg3);

};
