/*
 *  CNBPPlugin.h
 *
 *  Created by imlucid on Wed Aug 15 2001.
 *  Copyright (c) 2001 Apple Computer. All rights reserved.
 *
 */

#ifndef _CNBPPlugin_
#define _CNBPPlugin_

#include "CNSLPlugin.h"

#define kProtocolPrefixPlainStr		"AppleTalk"
#define kProtocolPrefixStr			"/AppleTalk"
#define kProtocolPrefixSlashStr		"/AppleTalk/"

#define kNoZoneLabel					"*"

#define kNBPThreadUSleepOnCount					25				// thread yield after reporting this number of items
#define kNBPThreadUSleepInterval				2500			// number of microseconds to pause the thread

#define kMaxZonesOnTryOne			1000
#define kMaxServicesOnTryOne		1000

class CNBPPlugin : public CNSLPlugin
{
public:
                                CNBPPlugin				( void );
                                ~CNBPPlugin				( void );
    
    virtual sInt32				InitPlugin				( void );
	virtual sInt32				SetServerIdleRunLoopRef	( CFRunLoopRef idleRunLoopRef );

            Boolean				IsScopeInReturnList		( const char* scope );
            void				AddResult				( const char* url );
    
            uInt32				fSignature;

            void				SetLocalZone			( const char* zone );
    const	char*				GetLocalZone			( void ) { return mLocalNodeString; }
protected:
    virtual CFStringRef			GetBundleIdentifier		( void );
    virtual const char*			GetProtocolPrefixString	( void );		// this is used for top of the node's path "NSL"
    virtual Boolean 			IsLocalNode				( const char *inNode );
    
    virtual void				NewNodeLookup			( void );		// this should fire off some threads in the subclass
    virtual	void				NewServiceLookup		( char* serviceType, CNSLDirNodeRep* nodeDirRep );
            Boolean				OKToSearchThisType		( char* serviceType );
    virtual Boolean				OKToOpenUnPublishedNode	( const char* parentNodeName );    

private:
            char*				mLocalNodeString;		
            SCDynamicStoreRef	mNBPSCRef;

};

#endif


