/*
 * Copyright (c) 2002 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

/*!
 * @header DirServicesConst
 */

#ifndef __DirServicesConst_h__
#define	__DirServicesConst_h__	1

/*!
 * @header DirectoryServices
 * This header contains well known attribute and record type constants.
 * They can be used with dsDataNodeAllocateString() to create a data node to pass to a
 * Directory Services API call.
 * Legend:
 *
 *		eDS1xxxxxx  Single Valued Attribute
 *
 *		eDSNxxxxxx  Multi-Valued Attribute
 *
 *	NOTE: Access controls may prevent any particular client from reading/writting
 *			various attributes.  In addition some attributes may not be stored at
 *			all and could represent "real-time" data generated by the directory node
 *			plug-in.
 *
 *	NOTE #2: Attributes in the model are available for records & directory nodes.
 */

// all records
#define		kDSRecordsAll					"dsRecordsAll"
#define		kDSRecordsStandardAll			"dsRecordsStandardAll"
#define		kDSRecordsNativeAll				"dsRecordsNativeAll"

// all attributes
#define		kDSAttributesAll				"dsAttributesAll"
#define		kDSAttributesStandardAll		"dsAttributesStandardAll"
#define		kDSAttributesNativeAll			"dsAttributesNativeAll"

// well known Record types
#define		kDSStdRecordTypePrefix			"dsRecTypeStandard:"
#define		kDSNativeRecordTypePrefix		"dsRecTypeNative:"

#define		kDSStdRecordTypeUsers			"dsRecTypeStandard:Users"
#define		kDSStdRecordTypeUserAliases		"dsRecTypeStandard:UserAliases"
#define		kDSStdRecordTypeGroups			"dsRecTypeStandard:Groups"
#define		kDSStdRecordTypeGroupAliases	"dsRecTypeStandard:GroupAliases"
#define		kDSStdRecordTypeMachines		"dsRecTypeStandard:Machines"
#define		kDSStdRecordTypeAliases			"dsRecTypeStandard:Aliases"
#define		kDSStdRecordTypeHosts			"dsRecTypeStandard:Hosts"
#define		kDSStdRecordTypePrinters		"dsRecTypeStandard:Printers"
#define		kDSStdRecordTypeNetworks		"dsRecTypeStandard:Networks"
#define		kDSStdRecordTypeServices		"dsRecTypeStandard:Services"
#define		kDSStdRecordTypeServer			"dsRecTypeStandard:Server"
#define		kDSStdRecordTypProtocols		"dsRecTypeStandard:Protocols"
#define		kDSStdRecordTypeProtocols		"dsRecTypeStandard:Protocols"
#define		kDSStdRecordTypRPC				"dsRecTypeStandard:RPC"
#define		kDSStdRecordTypeRPC				"dsRecTypeStandard:RPC"
#define		kDSStdRecordTypePrintService	"dsRecTypeStandard:PrintService"
#define		kDSStdRecordTypeConfig			"dsRecTypeStandard:Config"
#define		kDSStdRecordTypeAFPServer		"dsRecTypeStandard:AFPServer"
#define		kDSStdRecordTypeSMBServer		"dsRecTypeStandard:SMBServer"
#define		kDSStdRecordTypeFTPServer		"dsRecTypeStandard:FTPServer"
#define		kDSStdRecordTypeNFS				"dsRecTypeStandard:NFS"
#define		kDSStdRecordTypeWebServer		"dsRecTypeStandard:WebServer"
#define		kDSStdRecordTypeLDAPServer		"dsRecTypeStandard:LDAPServer"
#define		kDSStdRecordTypeQTSServer		"dsRecTypeStandard:QTSServer"
#define		kDSStdRecordTypMounts			"dsRecTypeStandard:Mounts"
#define		kDSStdRecordTypeMounts			"dsRecTypeStandard:Mounts"

#define		kDSStdRecordTypeComputers		"dsRecTypeStandard:Computers"
#define		kDSStdRecordTypeComputerLists	"dsRecTypeStandard:ComputerLists"

#define		kDSStdRecordTypePresetUsers		"dsRecTypeStandard:PresetUsers"
#define		kDSStdRecordTypePresetGroups	"dsRecTypeStandard:PresetGroups"
#define		kDSStdRecordTypePresetComputerLists	"dsRecTypeStandard:PresetComputerLists"

/*!
 * @defined kDSStdRecordTypePrintServiceUser
 * @discussion Record in the local node for storing quota usage for a user.
 */
#define		kDSStdRecordTypePrintServiceUser	"dsRecTypeStandard:PrintServiceUser"

#define		kDSStdRecordTypeAFPUserAliases	"dsRecTypeStandard:AFPUserAliases"

/*!
 * @defined kDSStdRecordTypeBootp
 * @discussion Record in the local node for storing bootp info.
 */
#define		kDSStdRecordTypeBootp	"dsRecTypeStandard:Bootp"

/*!
 * @defined kDSStdRecordTypeNetDomains
 * @discussion Record in the local node for storing net domains.
 */
#define		kDSStdRecordTypeNetDomains	"dsRecTypeStandard:NetDomains"

/*!
 * @defined kDSStdRecordTypeEthernets
 * @discussion Record in the local node for storing ethernets.
 */
#define		kDSStdRecordTypeEthernets	"dsRecTypeStandard:Ethernets"

/*!
 * @defined kDSStdRecordTypeNetGroups
 * @discussion Record in the local node for storing net groups.
 */
#define		kDSStdRecordTypeNetGroups	"dsRecTypeStandard:NetGroups"

/*!
 * @defined kDSStdRecordTypeHostServices
 * @discussion Record in the local node for storing host services.
 */
#define		kDSStdRecordTypeHostServices	"dsRecTypeStandard:HostServices"

#define		kDSStdUserNamesMeta				"dsRecTypeStandard:MetaUserNames"
#define		kDSStdRecordTypeMeta			"dsRecTypeStandard:AppleMetaRecord"

// well known Attribute Types...
#define		kDSStdAttrTypePrefix			"dsAttrTypeStandard:"
#define		kDSNativeAttrTypePrefix			"dsAttrTypeNative:"

#define		kDSAttrNone						"dsNone"

// authentication methods
#define		kDSStdAuthMethodPrefix				"dsAuthMethodStandard:"
#define		kDSNativeAuthMethodPrefix			"dsAuthMethodNative:"

#define		kDSStdAuthClearText					"dsAuthMethodStandard:dsAuthClearText"

/*!
 * @defined kDSStdAuthCrypt
 * @discussion Use a crypt password stored in the user record if available to
 *     do the authentication. The buffer is packed as follows:
 *
 *     4 byte length of username,
 *     username in UTF8 encoding,
 *     4 byte length of password,
 *     password in UTF8 encoding
 *
 *     This method may not be supported by all plug-ins or for all users.
 */
#define		kDSStdAuthCrypt						"dsAuthMethodStandard:dsAuthCrypt"

#define		kDSStdAuthSetPasswd					"dsAuthMethodStandard:dsAuthSetPasswd"

/*!
 * @defined kDSStdAuthChangePasswd
 * @discussion Change the password for a user. Does not require prior authentication.
 *     The buffer is packed as follows:
 *
 *     4 byte length of username,
 *     username in UTF8 encoding,
 *     4 byte length of old password,
 *     old password in UTF8 encoding,
 *     4 byte length of new password,
 *     new password in UTF8 encoding
 */
#define		kDSStdAuthChangePasswd				"dsAuthMethodStandard:dsAuthChangePasswd"

#define		kDSStdAuthSetPasswdAsRoot			"dsAuthMethodStandard:dsAuthSetPasswdAsRoot"

/*!
 * @defined kDSStdAuth2WayRandomChangePasswd
 * @discussion Change the password for a user using the two-way random method.
 *     Does not require prior authentication.
 *     The buffer is packed as follows:
 *
 *     4 byte length of username,
 *     username in UTF8 encoding,
 *     4 byte length of old password encrypted with new (should be 8),
 *     old password encrypted with new,
 *     4 byte length of new password encrypted with old (should be 8),
 *     new password encrypted with old
 */
#define		kDSStdAuth2WayRandomChangePasswd	"dsAuthMethodStandard:dsAuth2WayRandomChangePasswd"

#define		kDSStdAuthAPOP						"dsAuthMethodStandard:dsAuthAPOP"
#define		kDSStdAuth2WayRandom				"dsAuthMethodStandard:dsAuth2WayRandom"

/*!
 * @defined kDSStdAuthNodeNativeClearTextOK
 * @discussion The plug-in should determine which specific authentication method to use.
 *     The buffer is packed as follows:
 *
 *     4 byte length of username,
 *     username in UTF8 encoding,
 *     4 byte length of password,
 *     password in UTF8 encoding
 *
 *     The plug-in may choose to use a cleartext authentication method if necessary.
 */
#define		kDSStdAuthNodeNativeClearTextOK		"dsAuthMethodStandard:dsAuthNodeNativeCanUseClearText"

/*!
 * @defined kDSStdAuthNodeNativeNoClearText
 * @discussion The plug-in should determine which specific authentication method to use.
 *     The buffer is packed as follows:
 *
 *     4 byte length of username,
 *     username in UTF8 encoding,
 *     4 byte length of password,
 *     password in UTF8 encoding
 *
 *     The plug-in must not use an authentication method that sends the password in cleartext.
 */
#define		kDSStdAuthNodeNativeNoClearText		"dsAuthMethodStandard:dsAuthNodeNativeCannotUseClearText"

#define		kDSStdAuthSMB_NT_Key				"dsAuthMethodStandard:dsAuthSMBNTKey"
#define		kDSStdAuthSMB_LM_Key				"dsAuthMethodStandard:dsAuthSMBLMKey"
#define		kDSStdAuthCRAM_MD5					"dsAuthMethodStandard:dsAuthNodeCRAM-MD5"
#define		kDSStdAuthDIGEST_MD5				"dsAuthMethodStandard:dsAuthNodeDIGEST-MD5"

/*!
 * @defined kDSStdAuthMSCHAP2
 * @discussion
 *     MS-CHAP2 is a mutual authentication method. The plug-in will generate the data to
 *     send back to the client and put it in the step buffer.
 *
 *     The input buffer format:
 *     4 byte length,
 *     username,
 *     4 byte length,
 *     server challenge,
 *     4 byte length,
 *     peer challenge,
 *     4 byte length,
 *     client's digest,
 *
 *     The output buffer format:
 *     4 byte length,
 *     return digest for the client's challenge
 */
#define		kDSStdAuthMSCHAP2				"dsAuthMethodStandard:dsAuthMSCHAP2"

#define		kDSStdAuthMASKE_A				"dsAuthMethodStandard:dsAuthMASKE-A"
#define		kDSStdAuthMASKE_B				"dsAuthMethodStandard:dsAuthMASKE-B"

/*!
 * @defined kDSStdAuthNewUser
 * @discussion
 *     Create a new user record with the authentication authority
 *     The buffer is packed as follows:
 *
 *     4 byte length of authenticator's UserID,
 *     authenticator's UserID in UTF8 encoding,
 *     4 byte length of authenticator's password,
 *     authenticator's password in UTF8 encoding
 *     4 byte length of new user's short-name,
 *     user's short-name,
 *     4 byte length of new user's password,
 *     user's password
 */
#define		kDSStdAuthNewUser					"dsAuthMethodStandard:dsAuthNewUser"

/*!
 * @defined kDSStdAuthGetPolicy
 * @discussion The plug-in should determine which specific authentication method to use.
 *     The buffer is packed as follows:
 *
 *     4 byte length of authenticator's UserID,
 *     authenticator's UserID in UTF8 encoding,
 *     4 byte length of authenticator's password,
 *     authenticator's password in UTF8 encoding
 *     4 byte length of UserID of the account to get policies,
 *     UserID of the account to get policies in UTF8 encoding
 *
 *     The Password Server does not require authentication for this auth method.
 *       The first two fields are to cover us for future policy changes and to keep the buffer
 *       format as standardized as possible.
 */
#define		kDSStdAuthGetPolicy					"dsAuthMethodStandard:dsAuthGetPolicy"

/*!
 * @defined kDSStdAuthSetPolicy
 * @discussion The plug-in should determine which specific authentication method to use.
 *     The buffer is packed as follows:
 *
 *     4 byte length of authenticator's UserID,
 *     authenticator's UserID in UTF8 encoding,
 *     4 byte length of authenticator's password,
 *     authenticator's password in UTF8 encoding
 *     4 byte length of UserID of the account to set policies,
 *     UserID of the account to set policies in UTF8 encoding
 *     4 byte length of policy data,
 *     policy data
 *
 */
#define		kDSStdAuthSetPolicy					"dsAuthMethodStandard:dsAuthSetPolicy"

#define		kDSStdAuthGetGlobalPolicy			"dsAuthMethodStandard:dsAuthGetGlobalPolicy"
#define		kDSStdAuthSetGlobalPolicy			"dsAuthMethodStandard:dsAuthSetGlobalPolicy"
#define		kDSStdAuthGetUserName				"dsAuthMethodStandard:dsAuthGetUserName"
#define		kDSStdAuthSetUserName				"dsAuthMethodStandard:dsAuthSetUserName"
#define		kDSStdAuthGetUserData				"dsAuthMethodStandard:dsAuthGetUserData"
#define		kDSStdAuthSetUserData				"dsAuthMethodStandard:dsAuthSetUserData"
#define		kDSStdAuthDeleteUser				"dsAuthMethodStandard:dsAuthDeleteUser"

// Users distinguished or real name
#define		kDS1AttrDistinguishedName		"dsAttrTypeStandard:RealName"

#define		kDS1AttrFirstName				"dsAttrTypeStandard:FirstName"
#define		kDS1AttrMiddleName				"dsAttrTypeStandard:MiddleName"
#define		kDS1AttrLastName				"dsAttrTypeStandard:LastName"

// All possible names for a record
#define		kDSNAttrAllNames				"dsAttrTypeStandard:AllNames"

// set password methods
#define		kDSSetPasswdBestOf				"dsSetPasswdBestOf"

/*!
 * @defined kDSNAttrAuthenticationAuthority
 * @discussion Determines what mechanism is used to verify or set a user's password.
 *     If multiple values are present, the first attributes returned take precedence.
 *     Typically found in User records (kDSStdRecordTypeUsers).
 */
#define		kDSNAttrAuthenticationAuthority	"dsAttrTypeStandard:AuthenticationAuthority"

/*!
 * @defined kDSValueDefaultAuthAuthority
 * @discussion The default value to use for the kDSNAttrAuthenticationAuthority attribute.
 *     When creating a user record, set this value for authentication authority before
 *     setting the password with dsDoDirNodeAuth.
 */
#define		kDSValueAuthAuthorityDefault			kDSValueAuthAuthorityBasic

#define		kDSValueAuthAuthorityBasic				";basic;"
#define		kDSValueAuthAuthorityLocalWindowsHash	";LocalWindowsHash;"
#define		kDSValueAuthAuthorityPasswordServerPrefix	";ApplePasswordServer;"

//	Single Valued Attribute
#define		kDS1AttrPassword				"dsAttrTypeStandard:Password"
#define		kDS1AttrPasswordPlus			"dsAttrTypeStandard:PasswordPlus"
#define		kDS1AttrAuthenticationHint 		"dsAttrTypeStandard:AuthenticationHint"
#define		kDS1AttrInternetAlias  			"dsAttrTypeStandard:InetAlias"
#define		kDS1AttrNFSHomeDirectory		"dsAttrTypeStandard:NFSHomeDirectory"
#define		kDS1AttrUniqueID				"dsAttrTypeStandard:UniqueID"
#define		kDS1AttrPrimaryGroupID			"dsAttrTypeStandard:PrimaryGroupID"
#define		kDS1AttrMailAttribute			"dsAttrTypeStandard:MailAttribute"
#define		kDS1AttrComment					"dsAttrTypeStandard:Comment"
#define		kDS1AttrRARA					"dsAttrTypeStandard:RARA"
#define		kDS1AttrGeneratedUID			"dsAttrTypeStandard:GeneratedUID"
#define		kDS1AttrAdminStatus				"dsAttrTypeStandard:AdminStatus"
#define		kDS1AttrPwdAgingPolicy			"dsAttrTypeStandard:PwdAgingPolicy"
#define		kDS1AttrUserShell				"dsAttrTypeStandard:UserShell"
#define		kDS1AttrVFSType					"dsAttrTypeStandard:VFSType"
#define		kDS1AttrVFSPassNo				"dsAttrTypeStandard:VFSPassNo"
#define		kDS1AttrVFSDumpFreq				"dsAttrTypeStandard:VFSDumpFreq"
#define		kDS1AttrVFSLinkDir				"dsAttrTypeStandard:VFSLinkDir"
#define		kDS1AttrChange					"dsAttrTypeStandard:Change"
#define		kDS1AttrExpire					"dsAttrTypeStandard:Expire"

#define		kDSNAttrRecordAlias				"dsAttrTypeStandard:RecordAlias"
#define		kDSNAttrGroupMembership			"dsAttrTypeStandard:GroupMembership"
#define		kDSNAttrHomeDirectory			"dsAttrTypeStandard:HomeDirectory"

/*!
 *	@defined kDS1AttrHomeDirectoryQuota
 *	@discussion Represents the allowed usage for a user's home directory in bytes.
 *		Found in user records (kDSStdRecordTypeUsers).
 */
#define		kDS1AttrHomeDirectoryQuota		"dsAttrTypeStandard:HomeDirectoryQuota"

/*!
 *	@defined kDS1AttrAdminLimits
 *	@discussion XML plist indicating what an admin user can edit.
 *		Found in kDSStdRecordTypeUsers records.
 */
#define		kDS1AttrAdminLimits				"dsAttrTypeStandard:AdminLimits"

/*!
 *	@defined kDS1AttrPresetUserIsAdmin
 *	@discussion Flag to indicate whether users created from this preset are administrators
 *		by default. Found in kDSStdRecordTypePresetUsers records.
 */
#define		kDS1AttrPresetUserIsAdmin		"dsAttrTypeStandard:PresetUserIsAdmin"

#define		kDS1StandardAttrHomeLocOwner	kDS1AttrHomeLocOwner

/*!
 *	@defined kDS1AttrHomeLocOwner
 *	@discussion Represents the owner of a workgroup's shared home directory.
 *		Typically found in kDSStdRecordTypeGroups records.
 */
#define		kDS1AttrHomeLocOwner			"dsAttrTypeStandard:HomeLocOwner"

#define		kDSNAttrProtocols				"dsAttrTypeStandard:Protocols"
#define		kDSNAttrVFSOpts					"dsAttrTypeStandard:VFSOpts"

/*!
 *	@defined kDS1AttrPasswordServerLocation
 *	@discussion Specifies the IP address or domain name of the Password Server associated
 *		with a given directory node. Found in a config record named PasswordServer.
 */
#define		kDS1AttrPasswordServerLocation	"dsAttrTypeStandard:PasswordServerLocation"

/*!
 * @defined kDS1AttrPort
 * @discussion Represents the port number a service is available on.
 *     Typically found in service record types including kDSStdRecordTypeAFPServer,
 *     kDSStdRecordTypeLDAPServer, and kDSStdRecordTypeWebServer.
 */
#define		kDS1AttrPort					"dsAttrTypeStandard:Port"

/*!
 * @defined kDS1AttrLocation
 * @discussion Represents the location a service is available from (usually domain name).
 *     Typically found in service record types including kDSStdRecordTypeAFPServer,
 *     kDSStdRecordTypeLDAPServer, and kDSStdRecordTypeWebServer.
 */
#define		kDS1AttrLocation				"dsAttrTypeStandard:Location"

/*!
 * @defined kDS1AttrServiceType
 * @discussion Represents the service type for the service.  This is the raw service type of the
 *     service.  For example a service record type of kDSStdRecordTypeWebServer 
 *     might have a service type of "http" or "https".
 */
#define		kDS1AttrServiceType				"dsAttrTypeStandard:ServiceType"

/*!
 * @defined kDS1AttrPicture
 * @discussion Represents the path of the picture for each user displayed in the login window.
 * Found in user records (kDSStdRecordTypeUsers).
 */
#define		kDS1AttrPicture					"dsAttrTypeStandard:Picture"

// Mutivalued meta attribute data
#define		kDSNAttrMetaNodeLocation		"dsAttrTypeStandard:AppleMetaNodeLocation"
#define		kStandardTargetAlias			"dsAttrTypeStandard:AppleMetaAliasTarget"
#define		kStandardSourceAlias			"dsAttrTypeStandard:AppleMetaAliasSource"

#define		kDS1AttrAliasData				"dsAttrTypeStandard:AppleAliasData"

//	Single Valued - checksum/meta data
#define		kDS1AttrDataStamp				"dsAttrTypeStandard:DataStamp"
#define		kDS1AttrTotalSize				"dsAttrTypeStandard:TotalSize"

//	Single Valued - data of Create, Modify, Backup time in UTC
#define		kDS1AttrTimePackage				"dsAttrTypeStandard:TimePackage"

//  Single Valued - alias attribute, contain pointer to another node/record/attribute
#define		kDS1AttrAlias					"dsAttrTypeStandard:Alias"

//	Single valued - used to get a "auth" credential, to be used to authenticate
//		to other Directory nodes.
#define		kDS1AttrAuthCredential		"dsAttrTypeStandard:AuthCredential"

//	used with directory nodes so that clients can "discover" the
//	API capabilities for this Directory Node.
#define		kDS1AttrCapabilities		"dsAttrTypeStandard:Capabilities"

// can be found using dsGetDirNodeInfo and will return one of
// ReadOnly, ReadWrite, or WriteOnly strings
// note that ReadWrite does not imply fully readable or writable
#define		kDS1AttrReadOnlyNode		"dsAttrTypeStandard:ReadOnlyNode"

//	used with Search Node to  "discover" the search path for this node
#define		kDS1AttrSearchPath			"dsAttrTypeStandard:SearchPath"
#define		kDSNAttrSearchPath			"dsAttrTypeStandard:SearchPath"
//	used with Search Node to "discover" the search policy for this node
#define		kDS1AttrSearchPolicy			"dsAttrTypeStandard:SearchPolicy"
//	used with Search Node to "discover" the possible search paths for this node
#define		kDS1AttrNSPSearchPath			"dsAttrTypeStandard:NSPSearchPath"
#define		kDSNAttrNSPSearchPath			"dsAttrTypeStandard:NSPSearchPath"
#define		kDS1AttrLSPSearchPath			"dsAttrTypeStandard:LSPSearchPath"
#define		kDSNAttrLSPSearchPath			"dsAttrTypeStandard:LSPSearchPath"
#define		kDS1AttrCSPSearchPath			"dsAttrTypeStandard:CSPSearchPath"
#define		kDSNAttrCSPSearchPath			"dsAttrTypeStandard:CSPSearchPath"

//	force the directory service to generate a binary image of the
//	record and all it's attributes.
#define		kDS1AttrRecordImage			"dsAttrTypeStandard:RecordImage"

//	Information (version, signature, about, credits..ect.) about the plug-in that
//	is actually servicing a particular directory node.
#define		kDSNAttrPlugInInfo			"dsAttrTypeStandard:PlugInInfo"

//	Multivalued Attribute, list of names/keys for this record
#define		kDSNAttrRecordName			"dsAttrTypeStandard:RecordName"

//	Multivalued - list of attribute types
#define		kDSNAttrSchema				"dsAttrTypeStandard:Scheama"

//	Single Valued for a Record, Multi-valued for a Directory Node
#define		kDSNAttrRecordType			"dsAttrTypeStandard:RecordType"

#define		kDSNAttrNodePath			"dsAttrTypeStandard:NodePath"

#define		kDSNAttrAuthMethod			"dsAttrTypeStandard:AuthMethod"

#define		kDSNAttrSetPasswdMethod		"dsAttrTypeStandard:SetPasswdMethod"

//	Multivalued - list of group records
#define		kDSNAttrGroup				"dsAttrTypeStandard:Group"

//	Multivalued - list of member records
#define		kDSNAttrMember				"dsAttrTypeStandard:Member"

#define		kDSNAttrURL					"dsAttrTypeStandard:URL"

//	data contained in this attribute type is a fully qualified MIME Type.
#define		kDSNAttrMIME				"dsAttrTypeStandard:MIME"
#define		kDSNAttrHTML				"dsAttrTypeStandard:HTML"

#define		kDSNAttrNBPEntry			"dsAttrTypeStandard:NBPEntry"
#define		kDSNAttrDNSName				"dsAttrTypeStandard:DNSName"
#define		kDSNAttrIPAddress			"dsAttrTypeStandard:IPAddress"

/*!
 * @defined kDS1AttrENetAddress
 * @discussion Single-valued attribute for hardware Ethernet address (MAC address).
 *		Found in machine records (kDSStdRecordTypeMachines) and computer records
 *		(kDSStdRecordTypeComputers).
 */
#define		kDS1AttrENetAddress			"dsAttrTypeStandard:ENetAddress"

/*!
 * @defined kDSNAttrBootParams
 * @discussion Attribute type in host or machine records for storing boot params.
 */
#define		kDSNAttrBootParams			"dsAttrTypeStandard:BootParams"

/*!
 * @defined kDSNAttrNetGroups
 * @discussion Attribute type that indicates which netgroups its record is a member of.
 *		Found in user, host, and netdomain records.
 */
#define		kDSNAttrNetGroups			"dsAttrTypeStandard:NetGroups"


#define		kDSNAttrPGPPublicKey		"dsAttrTypeStandard:PGPPublicKey"
#define		kDSNAttrEMailAddress		"dsAttrTypeStandard:EMailAddress"

#define		kDSNAttrAreaCode			"dsAttrTypeStandard:AreaCode"
#define		kDSNAttrPhoneNumber			"dsAttrTypeStandard:PhoneNumber"
#define		kDSNAttrPostalAddress		"dsAttrTypeStandard:PostalAddress"

#define		kDSNAttrOrganizationName	"dsAttrTypeStandard:OrganizationName"
#define		kDSNAttrAddressLine1		"dsAttrTypeStandard:AddressLine1"
#define		kDSNAttrAddressLine2		"dsAttrTypeStandard:AddressLine2"
#define		kDSNAttrAddressLine3		"dsAttrTypeStandard:AddressLine3"
#define		kDSNAttrCity				"dsAttrTypeStandard:City"
#define		kDSNAttrState				"dsAttrTypeStandard:State"
#define		kDSNAttrPostalCode			"dsAttrTypeStandard:PostalCode"

// used for Setup Assistant automatic population
#define		kDS1AttrSetupOccupation		"dsAttrTypeStandard:Occupation"
#define		kDS1AttrSetupLocation		"dsAttrTypeStandard:SetupAssistantLocation"
#define		kDS1AttrSetupAdvertising	"dsAttrTypeStandard:SetupAssistantAdvertising"
#define		kDS1AttrSetupAutoRegister	"dsAttrTypeStandard:SetupAssistantAutoRegister"

#define		kDS1AttrMCXSettings			"dsAttrTypeStandard:MCXSettings"
#define		kDS1AttrMCXFlags			"dsAttrTypeStandard:MCXFlags"
#define		kDSNAttrComputers			"dsAttrTypeStandard:Computers"

// NSL
#define		kDSNAttrURLForNSL			"dsAttrTypeStandard:URLForNSL"

// Print
#define		kDS1AttrPrintServiceInfoXML		"dsAttrTypeStandard:PrintServiceInfoXML"
#define		kDS1AttrPrintServiceInfoText	"dsAttrTypeStandard:PrintServiceInfoText"

/*!
 * @defined kDS1AttrPrintServiceUserData
 * @discussion Single-valued attribute for print quota configuration or statistics
 *		(XML data). Found in user records (kDSStdRecordTypeUsers) or print service
 *		statistics records (kDSStdRecordTypePrintServiceUser).
 */
#define		kDS1AttrPrintServiceUserData	"dsAttrTypeStandard:PrintServiceUserData"

#endif
