/*
 * Copyright (c) 2003 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Copyright (c) 1999-2003 Apple Computer, Inc.  All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

#ifndef _VSDB_H_
#define _VSDB_H_

#define	_PATH_VSDB	"/var/db/volinfo.database"

#define	VSDB_PERM	0x00000001		/* enable permissions */

struct vsdb {
	char	*vs_spec;		/* volume uuid */
	int	vs_ops;		/* volume options */
};

#include <sys/cdefs.h>

__BEGIN_DECLS
struct vsdb *getvsent __P((void));
struct vsdb *getvsspec __P((const char *));
int setvsent __P((void));
void endvsent __P((void));
__END_DECLS

#endif /* !_VSDB_H_ */
