/*
 * Copyright (c) 1998-2001 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Copyright (c) 1999-2003 Apple Computer, Inc.  All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
#include <IOKit/firewire/IOFireWireUnit.h>
#include <IOKit/firewire/IOFireWireBus.h>
#include <IOKit/firewire/IOFWAddressSpace.h>
#include <IOKit/firewire/IOFireWireDevice.h>
#include <IOKit/firewire/IOFireWireBus.h>
#include "IOIPPort.h"

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
OSDefineMetaClassAndStructors(IOIPPort, IOFWLocalIsochPort)


bool IOIPPort::init(IODCLProgram *program, IOFireWireController *control, UInt32 channel)
{
	//IOLog("    IOIPPort called %d\n", __LINE__);
	if(!IOFWLocalIsochPort::init(program, control))
		return false;

	fChannel = channel ;
	
	//IOLog("    IOIPPort return true %d\n", __LINE__);

	return true;
}

IOReturn IOIPPort::getSupported(IOFWSpeed &maxSpeed, UInt64 &chanSupported)
{
	IOFWLocalIsochPort::getSupported( maxSpeed, chanSupported ) ;
	
	if ((chanSupported & ((UInt64)1) << (63 - fChannel)) == 0)	// make sure desired channel is supported by hardware
		return kIOReturnNoChannels ;
		
	chanSupported = ((UInt64)1) << (63 - fChannel) ;	// we want channel 31 (standard for async streaming packets)
	
	//IOLog("    IOIPPort %d\n", __LINE__);
    return kIOReturnSuccess;
}

