/*
 * Copyright (c) 2002 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * "Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.0 (the 'License').  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License."
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 * History:
 *  2002-02-26 	gvdl	Initial implementation of the gcc 2.95 -> gcc 3.x
 *			symbol remangler.
 */

#include <sys/cdefs.h>

typedef enum Rem3Return {
    kR3NotRemangled = 0,	// Wasn't a 2.95 C++ symbol but otherwise OK
    kR3Remangled,		// Was sucessfully remangled from 2.95 -> 3.x
    kR3InternalNotRemangled,	// Symbol is too big to be parsed
    kR3BufferTooSmallRemangled,	// Is 2.95 symbol but insufficent output space
    kR3BadArgument,		// One of the pointers are NULL
} Rem3Return;

__BEGIN_DECLS

extern Rem3Return
rem3_remangle_name(char *gcc3, int *gcc3size, const char *gcc295);

__END_DECLS
