/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
#pragma CC_NO_MACH_TEXT_SECTIONS
/*
 * Copyright 1990, NeXT, Inc.
 */

/*
 * This file contains global data and the size of the global data can NOT
 * change or otherwise it would make the shared library incompatable.  This
 * file has NOT been padded to allow more data to be added to it because the
 * sizeof(char) is not expected to change.
 */
 
#include "NXCType.h"

const unsigned int _NX_CTypeTable_[1 + 256] = {

/* One extra char in table: */	0,
/*    0	.notdef */	_CTYPE_C,
/*    1	.notdef */	_CTYPE_C,
/*    2	.notdef */	_CTYPE_C,
/*    3	.notdef */	_CTYPE_C,
/*    4	.notdef */	_CTYPE_C,
/*    5	.notdef */	_CTYPE_C,
/*    6	.notdef */	_CTYPE_C,
/*    7	.notdef */	_CTYPE_C,

/*    8	.notdef */	_CTYPE_C,
/*    9	.notdef */	_CTYPE_C|_CTYPE_S,
/*   10	.notdef */	_CTYPE_C|_CTYPE_S,
/*   11	.notdef */	_CTYPE_C|_CTYPE_S,
/*   12	.notdef */	_CTYPE_C|_CTYPE_S,
/*   13	.notdef */	_CTYPE_C|_CTYPE_S,
/*   14	.notdef */	_CTYPE_C,
/*   15	.notdef */	_CTYPE_C,

/*   16	.notdef */	_CTYPE_C,
/*   17	.notdef */	_CTYPE_C,
/*   18	.notdef */	_CTYPE_C,
/*   19	.notdef */	_CTYPE_C,
/*   20	.notdef */	_CTYPE_C,
/*   21	.notdef */	_CTYPE_C,
/*   22	.notdef */	_CTYPE_C,
/*   23	.notdef */	_CTYPE_C,

/*   24	.notdef */	_CTYPE_C,
/*   25	.notdef */	_CTYPE_C,
/*   26	.notdef */	_CTYPE_C,
/*   27	.notdef */	_CTYPE_C,
/*   28	.notdef */	_CTYPE_C,
/*   29	.notdef */	_CTYPE_C,
/*   30	.notdef */	_CTYPE_C,
/*   31	.notdef */	_CTYPE_C,

/*   32	space */	_CTYPE_S|_CTYPE_B,
/*   33	exclam */	_CTYPE_P,
/*   34	quotedbl */	_CTYPE_P,
/*   35	numbersign */	_CTYPE_P,
/*   36	dollar */	_CTYPE_P,
/*   37	percent */	_CTYPE_P,
/*   38	ampersand */	_CTYPE_P,
/*   39	quoteright */	_CTYPE_P,

/*   40	parenleft */	_CTYPE_P,
/*   41	parenright */	_CTYPE_P,
/*   42	asterisk */	_CTYPE_P,
/*   43	plus */		_CTYPE_P,
/*   44	comma */	_CTYPE_P,
/*   45	hyphen */	_CTYPE_P,
/*   46	period */	_CTYPE_P,
/*   47	slash */	_CTYPE_P,

/*   48	zero */		_CTYPE_D,
/*   49	one */		_CTYPE_D,
/*   50	two */		_CTYPE_D,
/*   51	three */	_CTYPE_D,
/*   52	four */		_CTYPE_D,
/*   53	five */		_CTYPE_D,
/*   54	six */		_CTYPE_D,
/*   55	seven */	_CTYPE_D,

/*   56	eight */	_CTYPE_D,
/*   57	nine */		_CTYPE_D,
/*   58	colon */	_CTYPE_P,
/*   59	semicolon */	_CTYPE_P,
/*   60	less */		_CTYPE_P,
/*   61	equal */	_CTYPE_P,
/*   62	greater */	_CTYPE_P,
/*   63	question */	_CTYPE_P,

/*   64	at */		_CTYPE_P,
/*   65	A */		_CTYPE_U|_CTYPE_X,
/*   66	B */		_CTYPE_U|_CTYPE_X,
/*   67	C */		_CTYPE_U|_CTYPE_X,
/*   68	D */		_CTYPE_U|_CTYPE_X,
/*   69	E */		_CTYPE_U|_CTYPE_X,
/*   70	F */		_CTYPE_U|_CTYPE_X,
/*   71	G */		_CTYPE_U,

/*   72	H */	_CTYPE_U,
/*   73	I */	_CTYPE_U,
/*   74	J */	_CTYPE_U,
/*   75	K */	_CTYPE_U,
/*   76	L */	_CTYPE_U,
/*   77	M */	_CTYPE_U,
/*   78	N */	_CTYPE_U,
/*   79	O */	_CTYPE_U,

/*   80	P */	_CTYPE_U,
/*   81	Q */	_CTYPE_U,
/*   82	R */	_CTYPE_U,
/*   83	S */	_CTYPE_U,
/*   84	T */	_CTYPE_U,
/*   85	U */	_CTYPE_U,
/*   86	V */	_CTYPE_U,
/*   87	W */	_CTYPE_U,

/*   88	X */	_CTYPE_U,
/*   89	Y */	_CTYPE_U,
/*   90	Z */	_CTYPE_U,
/*   91	bracketleft */	_CTYPE_P,
/*   92	backslash */	_CTYPE_P,
/*   93	bracketright */	_CTYPE_P,
/*   94	asciicircum */	_CTYPE_P,
/*   95	underscore */	_CTYPE_P,

/*   96	quoteleft */	_CTYPE_P,
/*   97	a */	_CTYPE_L|_CTYPE_X,
/*   98	b */	_CTYPE_L|_CTYPE_X,
/*   99	c */	_CTYPE_L|_CTYPE_X,
/*  100	d */	_CTYPE_L|_CTYPE_X,
/*  101	e */	_CTYPE_L|_CTYPE_X,
/*  102	f */	_CTYPE_L|_CTYPE_X,
/*  103	g */	_CTYPE_L,

/*  104	h */	_CTYPE_L,
/*  105	i */	_CTYPE_L,
/*  106	j */	_CTYPE_L,
/*  107	k */	_CTYPE_L,
/*  108	l */	_CTYPE_L,
/*  109	m */	_CTYPE_L,
/*  110	n */	_CTYPE_L,
/*  111	o */	_CTYPE_L,

/*  112	p */	_CTYPE_L,
/*  113	q */	_CTYPE_L,
/*  114	r */	_CTYPE_L,
/*  115	s */	_CTYPE_L,
/*  116	t */	_CTYPE_L,
/*  117	u */	_CTYPE_L,
/*  118	v */	_CTYPE_L,
/*  119	w */	_CTYPE_L,

/*  120	x */	_CTYPE_L,
/*  121	y */	_CTYPE_L,
/*  122	z */	_CTYPE_L,
/*  123	braceleft */	_CTYPE_P,
/*  124	bar */		_CTYPE_P,
/*  125	braceright */	_CTYPE_P,
/*  126	asciitilde */	_CTYPE_P,
/*  127	.notdef */	_CTYPE_C,

/*  128	.notdef */	_CTYPE_C,
/*  129	Agrave */	_CTYPE_U,
/*  130	Aacute */	_CTYPE_U,
/*  131	Acircumflex */	_CTYPE_U,
/*  132	Atilde */	_CTYPE_U,
/*  133	Adieresis */	_CTYPE_U,
/*  134	Aring */	_CTYPE_U,
/*  135	Ccedilla */	_CTYPE_U,

/*  136	Egrave */	_CTYPE_U,
/*  137	Eacute */	_CTYPE_U,
/*  138	Ecircumflex */	_CTYPE_U,
/*  139	Edieresis */	_CTYPE_U,
/*  140	Igrave */	_CTYPE_U,
/*  141	Iacute */	_CTYPE_U,
/*  142	Icircumflex */	_CTYPE_U,
/*  143	Idieresis */	_CTYPE_U,

/*  144	Eth */		_CTYPE_U,
/*  145	Ntilde */	_CTYPE_U,
/*  146	Ograve */	_CTYPE_U,
/*  147	Oacute */	_CTYPE_U,
/*  148	Ocircumflex */	_CTYPE_U,
/*  149	Otilde */	_CTYPE_U,
/*  150	Odieresis */	_CTYPE_U,
/*  151	Ugrave */	_CTYPE_U,

/*  152	Uacute */	_CTYPE_U,
/*  153	Ucircumflex */	_CTYPE_U,
/*  154	Udieresis */	_CTYPE_U,
/*  155	Yacute */	_CTYPE_U,
/*  156	Thorn */	_CTYPE_U,
/*  157	mu */		_CTYPE_P,
/*  158	multiply */	_CTYPE_P,
/*  159	divide */	_CTYPE_P,

/*  160	copyright */	_CTYPE_P,
/*  161	exclamdown */	_CTYPE_P,
/*  162	cent */		_CTYPE_P,
/*  163	sterling */	_CTYPE_P,
/*  164	fraction */	_CTYPE_P,
/*  165	yen */		_CTYPE_P,
/*  166	florin */	_CTYPE_P,
/*  167	section */	_CTYPE_P,

/*  168	currency */	_CTYPE_P,
/*  169	quotesingle */	_CTYPE_P,
/*  170	quotedblleft */	_CTYPE_P,
/*  171	guillemotleft */ _CTYPE_P,
/*  172	guilsinglleft */ _CTYPE_P,
/*  173	guilsinglright */ _CTYPE_P,
/*  174	fi */		_CTYPE_L,
/*  175	fl */		_CTYPE_L,

/*  176	registered */	_CTYPE_P,
/*  177	endash */	_CTYPE_P,
/*  178	dagger */	_CTYPE_P,
/*  179	daggerdbl */	_CTYPE_P,
/*  180	periodcentered */ _CTYPE_P,
/*  181	brokenbar */	_CTYPE_P,
/*  182	paragraph */	_CTYPE_P,
/*  183	bullet */	_CTYPE_P,

/*  184	quotesinglbase */ _CTYPE_P,
/*  185	quotedblbase */	_CTYPE_P,
/*  186	quotedblright */ _CTYPE_P,
/*  187	guillemotright */ _CTYPE_P,
/*  188	ellipsis */	_CTYPE_P,
/*  189	perthousand */	_CTYPE_P,
/*  190	logicalnot */	_CTYPE_P,
/*  191	questiondown */	_CTYPE_P,

/*  192	onesuperior */	_CTYPE_P,
/*  193	grave */	_CTYPE_P,
/*  194	acute */	_CTYPE_P,
/*  195	circumflex */	_CTYPE_P,
/*  196	tilde */	_CTYPE_P,
/*  197	macron */	_CTYPE_P,
/*  198	breve */	_CTYPE_P,
/*  199	dotaccent */	_CTYPE_P,

/*  200	dieresis */	_CTYPE_P,
/*  201	twosuperior */	_CTYPE_P,
/*  202	ring */		_CTYPE_P,
/*  203	cedilla */	_CTYPE_P,
/*  204	threesuperior */ _CTYPE_P,
/*  205	hungarumlaut */	_CTYPE_P,
/*  206	ogonek */	_CTYPE_P,
/*  207	caron */	_CTYPE_P,

/*  208	emdash */	_CTYPE_P,
/*  209	plusminus */	_CTYPE_P,
/*  210	onequarter */	_CTYPE_P,
/*  211	onehalf */	_CTYPE_P,
/*  212	threequarters */ _CTYPE_P,
/*  213	agrave */	_CTYPE_L,
/*  214	aacute */	_CTYPE_L,
/*  215	acircumflex */	_CTYPE_L,

/*  216	atilde */	_CTYPE_L,
/*  217	adieresis */	_CTYPE_L,
/*  218	aring */	_CTYPE_L,
/*  219	ccedilla */	_CTYPE_L,
/*  220	egrave */	_CTYPE_L,
/*  221	eacute */	_CTYPE_L,
/*  222	ecircumflex */	_CTYPE_L,
/*  223	edieresis */	_CTYPE_L,

/*  224	igrave */	_CTYPE_L,
/*  225	AE */		_CTYPE_U,
/*  226	iacute */	_CTYPE_L,
/*  227	ordfeminine */	_CTYPE_P,
/*  228	icircumflex */	_CTYPE_L,
/*  229	idieresis */	_CTYPE_L,
/*  230	eth */		_CTYPE_L,
/*  231	ntilde */	_CTYPE_L,

/*  232	Lslash */	_CTYPE_U,
/*  233	Oslash */	_CTYPE_U,
/*  234	OE */		_CTYPE_U,
/*  235	ordmasculine */	_CTYPE_P,
/*  236	ograve */	_CTYPE_L,
/*  237	oacute */	_CTYPE_L,
/*  238	ocircumflex */	_CTYPE_L,
/*  239	otilde */	_CTYPE_L,

/*  240	odieresis */	_CTYPE_L,
/*  241	ae */		_CTYPE_L,
/*  242	ugrave */	_CTYPE_L,
/*  243	uacute */	_CTYPE_L,
/*  244	ucircumflex */	_CTYPE_L,
/*  245	dotlessi */	_CTYPE_L,
/*  246	udieresis */	_CTYPE_L,
/*  247	yacute */	_CTYPE_L,

/*  248	lslash */	_CTYPE_L,
/*  249	oslash */	_CTYPE_L,
/*  250	oe */		_CTYPE_L,
/*  251	germandbls */	_CTYPE_L,
/*  252	thorn */	_CTYPE_L,
/*  253	ydieresis */	_CTYPE_L,
/*  254	.notdef */	_CTYPE_C,
/*  255	.notdef */	_CTYPE_C,
};

/*
 * Upper to lower and lower to upper table for NeXTStep encoding (256
 * characters).  An entry of zero means it's not an upper or lower case
 * thing (i.e., isn't alphabetic).  Otherwise, the value at a given
 * position is the opposite case equivalent.  E.g., the entry for the
 * "A" position is "a" and the entry for position "a" is "A".
 *
 * There are some pathological cases: ydieresis, germandbls, and the
 * fi & fl ligatures don't have "other case" equivalents; therefore
 * they're entered as themselves because they are in fact "lower case"
 * and the Type table lists them as _CTYPE_L.
 */
const unsigned char _NX_ULTable_[256] = {
/*    0	.notdef */	0,
/*    1	.notdef */	0,
/*    2	.notdef */	0,
/*    3	.notdef */	0,
/*    4	.notdef */	0,
/*    5	.notdef */	0,
/*    6	.notdef */	0,
/*    7	.notdef */	0,
/*    8	.notdef */	0,
/*    9	.notdef */	0,
/*   10	.notdef */	0,
/*   11	.notdef */	0,
/*   12	.notdef */	0,
/*   13	.notdef */	0,
/*   14	.notdef */	0,
/*   15	.notdef */	0,
/*   16	.notdef */	0,
/*   17	.notdef */	0,
/*   18	.notdef */	0,
/*   19	.notdef */	0,
/*   20	.notdef */	0,
/*   21	.notdef */	0,
/*   22	.notdef */	0,
/*   23	.notdef */	0,
/*   24	.notdef */	0,
/*   25	.notdef */	0,
/*   26	.notdef */	0,
/*   27	.notdef */	0,
/*   28	.notdef */	0,
/*   29	.notdef */	0,
/*   30	.notdef */	0,
/*   31	.notdef */	0,
/*   32	space */	0,
/*   33	exclam */	0,
/*   34	quotedbl */	0,
/*   35	numbersign */	0,
/*   36	dollar */	0,
/*   37	percent */	0,
/*   38	ampersand */	0,
/*   39	quoteright */	0,
/*   40	parenleft */	0,
/*   41	parenright */	0,
/*   42	asterisk */	0,
/*   43	plus */		0,
/*   44	comma */	0,
/*   45	hyphen */	0,
/*   46	period */	0,
/*   47	slash */	0,
/*   48	zero */		0,
/*   49	one */		0,
/*   50	two */		0,
/*   51	three */	0,
/*   52	four */		0,
/*   53	five */		0,
/*   54	six */		0,
/*   55	seven */	0,
/*   56	eight */	0,
/*   57	nine */		0,
/*   58	colon */	0,
/*   59	semicolon */	0,
/*   60	less */		0,
/*   61	equal */	0,
/*   62	greater */	0,
/*   63	question */	0,
/*   64	at */		0,
/*   65	A */		97,
/*   66	B */		98,
/*   67	C */		99,
/*   68	D */		100,
/*   69	E */		101,
/*   70	F */		102,
/*   71	G */		103,
/*   72	H */		104,
/*   73	I */	105,
/*   74	J */	106,
/*   75	K */	107,
/*   76	L */	108,
/*   77	M */	109,
/*   78	N */	110,
/*   79	O */	111,
/*   80	P */	112,
/*   81	Q */	113,
/*   82	R */	114,
/*   83	S */	115,
/*   84	T */	116,
/*   85	U */	117,
/*   86	V */	118,
/*   87	W */	119,
/*   88	X */	120,
/*   89	Y */	121,
/*   90	Z */	122,
/*   91	bracketleft */	0,
/*   92	backslash */	0,
/*   93	bracketright */	0,
/*   94	asciicircum */	0,
/*   95	underscore */	0,
/*   96	quoteleft */	0,
/*   97	a */	65,
/*   98	b */	66,
/*   99	c */	67,
/*  100	d */	68,
/*  101	e */	69,
/*  102	f */	70,
/*  103	g */	71,
/*  104	h */	72,
/*  105	i */	73,
/*  106	j */	74,
/*  107	k */	75,
/*  108	l */	76,
/*  109	m */	77,
/*  110	n */	78,
/*  111	o */	79,
/*  112	p */	80,
/*  113	q */	81,
/*  114	r */	82,
/*  115	s */	83,
/*  116	t */	84,
/*  117	u */	85,
/*  118	v */	86,
/*  119	w */	87,
/*  120	x */	88,
/*  121	y */	89,
/*  122	z */	90,
/*  123	braceleft */	0,
/*  124	bar */		0,
/*  125	braceright */	0,
/*  126	asciitilde */	0,
/*  127	.notdef */	0,
/*  128	.notdef */	0,
/*  129	Agrave */	213,
/*  130	Aacute */	214,
/*  131	Acircumflex */	215,
/*  132	Atilde */	216,
/*  133	Adieresis */	217,
/*  134	Aring */	218,
/*  135	Ccedilla */	219,
/*  136	Egrave */	220,
/*  137	Eacute */	221,
/*  138	Ecircumflex */	222,
/*  139	Edieresis */	223,
/*  140	Igrave */	224,
/*  141	Iacute */	226,
/*  142	Icircumflex */	228,
/*  143	Idieresis */	229,
/*  144	Eth */		230,
/*  145	Ntilde */	231,
/*  146	Ograve */	236,
/*  147	Oacute */	237,
/*  148	Ocircumflex */	238,
/*  149	Otilde */	239,
/*  150	Odieresis */	240,
/*  151	Ugrave */	242,
/*  152	Uacute */	243,
/*  153	Ucircumflex */	244,
/*  154	Udieresis */	246,
/*  155	Yacute */	247,
/*  156	Thorn */	252,
/*  157	mu */		0,
/*  158	multiply */	0,
/*  159	divide */	0,
/*  160	copyright */	0,
/*  161	exclamdown */	0,
/*  162	cent */		0,
/*  163	sterling */	0,
/*  164	fraction */	0,
/*  165	yen */		0,
/*  166	florin */	0,
/*  167	section */	0,
/*  168	currency */	0,
/*  169	quotesingle */	0,
/*  170	quotedblleft */	0,
/*  171	guillemotleft */ 0,
/*  172	guilsinglleft */ 0,
/*  173	guilsinglright */ 0,
/*  174	fi */		174,	/* is self */
/*  175	fl */		175,	/* is self */
/*  176	registered */	0,
/*  177	endash */	0,
/*  178	dagger */	0,
/*  179	daggerdbl */	0,
/*  180	periodcentered */ 0,
/*  181	brokenbar */	0,
/*  182	paragraph */	0,
/*  183	bullet */	0,
/*  184	quotesinglbase */ 0,
/*  185	quotedblbase */	0,
/*  186	quotedblright */ 0,
/*  187	guillemotright */ 0,
/*  188	ellipsis */	0,
/*  189	perthousand */	0,
/*  190	logicalnot */	0,
/*  191	questiondown */	0,
/*  192	onesuperior */	0,
/*  193	grave */	0,
/*  194	acute */	0,
/*  195	circumflex */	0,
/*  196	tilde */	0,
/*  197	macron */	0,
/*  198	breve */	0,
/*  199	dotaccent */	0,
/*  200	dieresis */	0,
/*  201	twosuperior */	0,
/*  202	ring */		0,
/*  203	cedilla */	0,
/*  204	threesuperior */ 0,
/*  205	hungarumlaut */	0,
/*  206	ogonek */	0,
/*  207	caron */	0,
/*  208	emdash */	0,
/*  209	plusminus */	0,
/*  210	onequarter */	0,
/*  211	onehalf */	0,
/*  212	threequarters */ 0,
/*  213	agrave */	129,
/*  214	aacute */	130,
/*  215	acircumflex */	131,
/*  216	atilde */	132,
/*  217	adieresis */	133,
/*  218	aring */	134,
/*  219	ccedilla */	135,
/*  220	egrave */	136,
/*  221	eacute */	137,
/*  222	ecircumflex */	138,
/*  223	edieresis */	139,
/*  224	igrave */	140,
/*  225	AE */		241,
/*  226	iacute */	141,
/*  227	ordfeminine */	0,
/*  228	icircumflex */	142,
/*  229	idieresis */	143,
/*  230	eth */		144,
/*  231	ntilde */	145,
/*  232	Lslash */	248,
/*  233	Oslash */	249,
/*  234	OE */		250,
/*  235	ordmasculine */	0,
/*  236	ograve */	146,
/*  237	oacute */	147,
/*  238	ocircumflex */	148,
/*  239	otilde */	149,
/*  240	odieresis */	150,
/*  241	ae */		225,
/*  242	ugrave */	151,
/*  243	uacute */	152,
/*  244	ucircumflex */	153,
/*  245	dotlessi */	245,	/* is self */
/*  246	udieresis */	154,
/*  247	yacute */	155,
/*  248	lslash */	232,
/*  249	oslash */	233,
/*  250	oe */		234,
/*  251	germandbls */	251,	/* is self */
/*  252	thorn */	156,
/*  253	ydieresis */	253,	/* is self */
/*  254	.notdef */	0,
/*  255	.notdef */	0
};

