/*
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * Copyright (c) 1999-2001 Apple Computer, Inc.  All Rights Reserved. The
 * contents of this file constitute Original Code as defined in and are
 * subject to the Apple Public Source License Version 1.2 (the 'License').
 * You may not use this file except in compliance with the License.  Please
 * obtain a copy of the License at http://www.apple.com/publicsource and
 * read it before using this file.
 *
 * This Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.  Please
 * see the License for the specific language governing rights and
 * limitations under the License.
 *
 *
 * @APPLE_LICENSE_HEADER_END@
 *
 */

/*
 * defaultPaths.h - define the default paths to hardcode into the executables
 * 
 * IMPORTANT NOTE : The trailering directory separators are required on all 
 *                  DEFAULTPATHS_*_DIR* defines
 */

#ifdef __Win32__

# define DEFAULTPATHS_DIRECTORY_SEPARATOR	"\\"

# define DEFAULTPATHS_ETC_DIR			"c:\\Program Files\\Darwin Streaming Server\\"
# define DEFAULTPATHS_ETC_DIR_OLD		"c:\\Program Files\\Darwin Streaming Server\\"
# define DEFAULTPATHS_SSM_DIR			"c:\\Program Files\\Darwin Streaming Server\\QTSSModules\\"
# define DEFAULTPATHS_LOG_DIR			"c:\\Program Files\\Darwin Streaming Server\\Logs\\"

#elif __MACOS__

# define DEFAULTPATHS_DIRECTORY_SEPARATOR	":"

# define DEFAULTPATHS_ETC_DIR			""
# define DEFAULTPATHS_ETC_DIR_OLD		""
# define DEFAULTPATHS_SSM_DIR			""
# define DEFAULTPATHS_LOG_DIR			""

#elif __MacOSX__

# define DEFAULTPATHS_DIRECTORY_SEPARATOR	"/"

# define DEFAULTPATHS_ETC_DIR			"/Library/QuickTimeStreaming/Config/"
# define DEFAULTPATHS_ETC_DIR_OLD		"/etc/"
# define DEFAULTPATHS_SSM_DIR			"/Library/QuickTimeStreaming/Modules/"
# define DEFAULTPATHS_LOG_DIR			"/Library/QuickTimeStreaming/Logs/"

#else

# define DEFAULTPATHS_DIRECTORY_SEPARATOR	"/"

# define DEFAULTPATHS_ETC_DIR			"/etc/streaming/"
# define DEFAULTPATHS_ETC_DIR_OLD		"/etc/"
# define DEFAULTPATHS_SSM_DIR			"/usr/local/sbin/StreamingServerModules/"
# define DEFAULTPATHS_LOG_DIR			"/var/streaming/logs/"

/*

# define DEFAULTPATHS_ETC_DIR			"/usr/local/etc/streaming/"
# define DEFAULTPATHS_ETC_DIR_OLD		"/etc/"
# define DEFAULTPATHS_SSM_DIR			"/usr/local/sbin/StreamingServerModules/"
# define DEFAULTPATHS_LOG_DIR			"/var/streaming/logs/"

*/

#endif
