/*
 * Copyright (c) 2000-2001 Apple Computer, Inc. All Rights Reserved.
 * 
 * The contents of this file constitute Original Code as defined in and are
 * subject to the Apple Public Source License Version 1.2 (the 'License').
 * You may not use this file except in compliance with the License. Please obtain
 * a copy of the License at http://www.apple.com/publicsource and read it before
 * using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS
 * OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see the License for the
 * specific language governing rights and limitations under the License.
 */


/*
	File:		KCEventObserver.cpp

	Contains:	OS X CF Observer for Keychain Events

	Written by:	Craig Mortensen

	Copyright:	2000 by Apple Computer, Inc., All rights reserved.

	Change History (most recent first):

	To Do:
*/

#include "KCEventObserver.h"

using namespace Security;

void Observer::EventReceived (Listener::Domain domain, Listener::Event event, const void* data, size_t dataLength)
{
    secdebug("kcnotify", "Security::Observer::EventReceived got event %u", (unsigned int) event);

	// make a NameValueDictionary from the data we received
	CssmData dt ((void*) data, dataLength);
	NameValueDictionary nvd (dt);
	Event (domain, event, nvd);
}



Observer::Observer (Listener::Domain whichDomain, Listener::EventMask whichEvents)
{
	RequestEvents (whichDomain, whichEvents);
}



Observer::~Observer ()
{
}
