/*
 * Copyright (c) 2000-2001 Apple Computer, Inc. All Rights Reserved.
 * 
 * The contents of this file constitute Original Code as defined in and are
 * subject to the Apple Public Source License Version 1.2 (the 'License').
 * You may not use this file except in compliance with the License. Please obtain
 * a copy of the License at http://www.apple.com/publicsource and read it before
 * using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS
 * OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see the License for the
 * specific language governing rights and limitations under the License.
 */


/*
	File:		sslRootCerts.c

	Contains:	embedded SSL root certs - subject name and public keys 

	Written by:	Doug Mitchell. 

	Copyright:	Copyright 2000 by Apple Computer, Inc., all rights reserved.

*/

#include <Security/cssmtype.h>
#include "rootCerts.h"

#if		TP_ROOT_CERT_ENABLE 

/***********************
Cert File Name: Class1_PCA_G2_v2.cer
Subject Name       :
    Country        : US
    Org            : VeriSign, Inc.
    OrgUnit        : Class 1 Public Primary Certification Authority - G2
    OrgUnit        : (c) 1998 VeriSign, Inc. - For authorized use only
    OrgUnit        : VeriSign Trust Network
 ***********************/
static const uint8 Class1_PCA_G2_v2_subject_bytes[] = {
   0x30,  0x81,  0xc1,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  
   0x31,  0x17,  0x30,  0x15,  0x06,  0x03,  0x55,  0x04,  
   0x0a,  0x13,  0x0e,  0x56,  0x45,  0x52,  0x49,  0x53,  
   0x49,  0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  
   0x2e,  0x31,  0x3c,  0x30,  0x3a,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x33,  0x43,  0x4c,  0x41,  0x53,  
   0x53,  0x20,  0x31,  0x20,  0x50,  0x55,  0x42,  0x4c,  
   0x49,  0x43,  0x20,  0x50,  0x52,  0x49,  0x4d,  0x41,  
   0x52,  0x59,  0x20,  0x43,  0x45,  0x52,  0x54,  0x49,  
   0x46,  0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  
   0x20,  0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  
   0x54,  0x59,  0x20,  0x2d,  0x20,  0x47,  0x32,  0x31,  
   0x3a,  0x30,  0x38,  0x06,  0x03,  0x55,  0x04,  0x0b,  
   0x13,  0x31,  0x28,  0x43,  0x29,  0x20,  0x31,  0x39,  
   0x39,  0x38,  0x20,  0x56,  0x45,  0x52,  0x49,  0x53,  
   0x49,  0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  
   0x2e,  0x20,  0x2d,  0x20,  0x46,  0x4f,  0x52,  0x20,  
   0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  0x5a,  
   0x45,  0x44,  0x20,  0x55,  0x53,  0x45,  0x20,  0x4f,  
   0x4e,  0x4c,  0x59,  0x31,  0x1f,  0x30,  0x1d,  0x06,  
   0x03,  0x55,  0x04,  0x0b,  0x13,  0x16,  0x56,  0x45,  
   0x52,  0x49,  0x53,  0x49,  0x47,  0x4e,  0x20,  0x54,  
   0x52,  0x55,  0x53,  0x54,  0x20,  0x4e,  0x45,  0x54,  
   0x57,  0x4f,  0x52,  0x4b
};
static const CSSM_DATA Class1_PCA_G2_v2_subject = { 196, (uint8 *)Class1_PCA_G2_v2_subject_bytes };
static const uint8 Class1_PCA_G2_v2_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xaa,  
   0xd0,  0xba,  0xbe,  0x16,  0x2d,  0xb8,  0x83,  0xd4,  
   0xca,  0xd2,  0x0f,  0xbc,  0x76,  0x31,  0xca,  0x94,  
   0xd8,  0x1d,  0x93,  0x8c,  0x56,  0x02,  0xbc,  0xd9,  
   0x6f,  0x1a,  0x6f,  0x52,  0x36,  0x6e,  0x75,  0x56,  
   0x0a,  0x55,  0xd3,  0xdf,  0x43,  0x87,  0x21,  0x11,  
   0x65,  0x8a,  0x7e,  0x8f,  0xbd,  0x21,  0xde,  0x6b,  
   0x32,  0x3f,  0x1b,  0x84,  0x34,  0x95,  0x05,  0x9d,  
   0x41,  0x35,  0xeb,  0x92,  0xeb,  0x96,  0xdd,  0xaa,  
   0x59,  0x3f,  0x01,  0x53,  0x6d,  0x99,  0x4f,  0xed,  
   0xe5,  0xe2,  0x2a,  0x5a,  0x90,  0xc1,  0xb9,  0xc4,  
   0xa6,  0x15,  0xcf,  0xc8,  0x45,  0xeb,  0xa6,  0x5d,  
   0x8e,  0x9c,  0x3e,  0xf0,  0x64,  0x24,  0x76,  0xa5,  
   0xcd,  0xab,  0x1a,  0x6f,  0xb6,  0xd8,  0x7b,  0x51,  
   0x61,  0x6e,  0xa6,  0x7f,  0x87,  0xc8,  0xe2,  0xb7,  
   0xe5,  0x34,  0xdc,  0x41,  0x88,  0xea,  0x09,  0x40,  
   0xbe,  0x73,  0x92,  0x3d,  0x6b,  0xe7,  0x75,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA Class1_PCA_G2_v2_pubKey = { 140, (uint8 *)Class1_PCA_G2_v2_pubKey_bytes };


/***********************
Cert File Name: Class2_PCA_G2_v2.cer
Subject Name       :
    Country        : US
    Org            : VeriSign, Inc.
    OrgUnit        : Class 2 Public Primary Certification Authority - G2
    OrgUnit        : (c) 1998 VeriSign, Inc. - For authorized use only
    OrgUnit        : VeriSign Trust Network
 ***********************/
static const uint8 Class2_PCA_G2_v2_subject_bytes[] = {
   0x30,  0x81,  0xc1,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  
   0x31,  0x17,  0x30,  0x15,  0x06,  0x03,  0x55,  0x04,  
   0x0a,  0x13,  0x0e,  0x56,  0x45,  0x52,  0x49,  0x53,  
   0x49,  0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  
   0x2e,  0x31,  0x3c,  0x30,  0x3a,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x33,  0x43,  0x4c,  0x41,  0x53,  
   0x53,  0x20,  0x32,  0x20,  0x50,  0x55,  0x42,  0x4c,  
   0x49,  0x43,  0x20,  0x50,  0x52,  0x49,  0x4d,  0x41,  
   0x52,  0x59,  0x20,  0x43,  0x45,  0x52,  0x54,  0x49,  
   0x46,  0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  
   0x20,  0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  
   0x54,  0x59,  0x20,  0x2d,  0x20,  0x47,  0x32,  0x31,  
   0x3a,  0x30,  0x38,  0x06,  0x03,  0x55,  0x04,  0x0b,  
   0x13,  0x31,  0x28,  0x43,  0x29,  0x20,  0x31,  0x39,  
   0x39,  0x38,  0x20,  0x56,  0x45,  0x52,  0x49,  0x53,  
   0x49,  0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  
   0x2e,  0x20,  0x2d,  0x20,  0x46,  0x4f,  0x52,  0x20,  
   0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  0x5a,  
   0x45,  0x44,  0x20,  0x55,  0x53,  0x45,  0x20,  0x4f,  
   0x4e,  0x4c,  0x59,  0x31,  0x1f,  0x30,  0x1d,  0x06,  
   0x03,  0x55,  0x04,  0x0b,  0x13,  0x16,  0x56,  0x45,  
   0x52,  0x49,  0x53,  0x49,  0x47,  0x4e,  0x20,  0x54,  
   0x52,  0x55,  0x53,  0x54,  0x20,  0x4e,  0x45,  0x54,  
   0x57,  0x4f,  0x52,  0x4b
};
static const CSSM_DATA Class2_PCA_G2_v2_subject = { 196, (uint8 *)Class2_PCA_G2_v2_subject_bytes };
static const uint8 Class2_PCA_G2_v2_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xa7,  
   0x88,  0x01,  0x21,  0x74,  0x2c,  0xe7,  0x1a,  0x03,  
   0xf0,  0x98,  0xe1,  0x97,  0x3c,  0x0f,  0x21,  0x08,  
   0xf1,  0x9c,  0xdb,  0x97,  0xe9,  0x9a,  0xfc,  0xc2,  
   0x04,  0x06,  0x13,  0xbe,  0x5f,  0x52,  0xc8,  0xcc,  
   0x1e,  0x2c,  0x12,  0x56,  0x2c,  0xb8,  0x01,  0x69,  
   0x2c,  0xcc,  0x99,  0x1f,  0xad,  0xb0,  0x96,  0xae,  
   0x79,  0x04,  0xf2,  0x13,  0x39,  0xc1,  0x7b,  0x98,  
   0xba,  0x08,  0x2c,  0xe8,  0xc2,  0x84,  0x13,  0x2c,  
   0xaa,  0x69,  0xe9,  0x09,  0xf4,  0xc7,  0xa9,  0x02,  
   0xa4,  0x42,  0xc2,  0x23,  0x4f,  0x4a,  0xd8,  0xf0,  
   0x0e,  0xa2,  0xfb,  0x31,  0x6c,  0xc9,  0xe6,  0x6f,  
   0x99,  0x27,  0x07,  0xf5,  0xe6,  0xf4,  0x4c,  0x78,  
   0x9e,  0x6d,  0xeb,  0x46,  0x86,  0xfa,  0xb9,  0x86,  
   0xc9,  0x54,  0xf2,  0xb2,  0xc4,  0xaf,  0xd4,  0x46,  
   0x1c,  0x5a,  0xc9,  0x15,  0x30,  0xff,  0x0d,  0x6c,  
   0xf5,  0x2d,  0x0e,  0x6d,  0xce,  0x7f,  0x77,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA Class2_PCA_G2_v2_pubKey = { 140, (uint8 *)Class2_PCA_G2_v2_pubKey_bytes };


/***********************
Cert File Name: Class3_PCA_G2_v2.cer
Subject Name       :
    Country        : US
    Org            : VeriSign, Inc.
    OrgUnit        : Class 3 Public Primary Certification Authority - G2
    OrgUnit        : (c) 1998 VeriSign, Inc. - For authorized use only
    OrgUnit        : VeriSign Trust Network
 ***********************/
static const uint8 Class3_PCA_G2_v2_subject_bytes[] = {
   0x30,  0x81,  0xc1,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  
   0x31,  0x17,  0x30,  0x15,  0x06,  0x03,  0x55,  0x04,  
   0x0a,  0x13,  0x0e,  0x56,  0x45,  0x52,  0x49,  0x53,  
   0x49,  0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  
   0x2e,  0x31,  0x3c,  0x30,  0x3a,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x33,  0x43,  0x4c,  0x41,  0x53,  
   0x53,  0x20,  0x33,  0x20,  0x50,  0x55,  0x42,  0x4c,  
   0x49,  0x43,  0x20,  0x50,  0x52,  0x49,  0x4d,  0x41,  
   0x52,  0x59,  0x20,  0x43,  0x45,  0x52,  0x54,  0x49,  
   0x46,  0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  
   0x20,  0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  
   0x54,  0x59,  0x20,  0x2d,  0x20,  0x47,  0x32,  0x31,  
   0x3a,  0x30,  0x38,  0x06,  0x03,  0x55,  0x04,  0x0b,  
   0x13,  0x31,  0x28,  0x43,  0x29,  0x20,  0x31,  0x39,  
   0x39,  0x38,  0x20,  0x56,  0x45,  0x52,  0x49,  0x53,  
   0x49,  0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  
   0x2e,  0x20,  0x2d,  0x20,  0x46,  0x4f,  0x52,  0x20,  
   0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  0x5a,  
   0x45,  0x44,  0x20,  0x55,  0x53,  0x45,  0x20,  0x4f,  
   0x4e,  0x4c,  0x59,  0x31,  0x1f,  0x30,  0x1d,  0x06,  
   0x03,  0x55,  0x04,  0x0b,  0x13,  0x16,  0x56,  0x45,  
   0x52,  0x49,  0x53,  0x49,  0x47,  0x4e,  0x20,  0x54,  
   0x52,  0x55,  0x53,  0x54,  0x20,  0x4e,  0x45,  0x54,  
   0x57,  0x4f,  0x52,  0x4b
};
static const CSSM_DATA Class3_PCA_G2_v2_subject = { 196, (uint8 *)Class3_PCA_G2_v2_subject_bytes };
static const uint8 Class3_PCA_G2_v2_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xcc,  
   0x5e,  0xd1,  0x11,  0x5d,  0x5c,  0x69,  0xd0,  0xab,  
   0xd3,  0xb9,  0x6a,  0x4c,  0x99,  0x1f,  0x59,  0x98,  
   0x30,  0x8e,  0x16,  0x85,  0x20,  0x46,  0x6d,  0x47,  
   0x3f,  0xd4,  0x85,  0x20,  0x84,  0xe1,  0x6d,  0xb3,  
   0xf8,  0xa4,  0xed,  0x0c,  0xf1,  0x17,  0x0f,  0x3b,  
   0xf9,  0xa7,  0xf9,  0x25,  0xd7,  0xc1,  0xcf,  0x84,  
   0x63,  0xf2,  0x7c,  0x63,  0xcf,  0xa2,  0x47,  0xf2,  
   0xc6,  0x5b,  0x33,  0x8e,  0x64,  0x40,  0x04,  0x68,  
   0xc1,  0x80,  0xb9,  0x64,  0x1c,  0x45,  0x77,  0xc7,  
   0xd8,  0x6e,  0xf5,  0x95,  0x29,  0x3c,  0x50,  0xe8,  
   0x34,  0xd7,  0x78,  0x1f,  0xa8,  0xba,  0x6d,  0x43,  
   0x91,  0x95,  0x8f,  0x45,  0x57,  0x5e,  0x7e,  0xc5,  
   0xfb,  0xca,  0xa4,  0x04,  0xeb,  0xea,  0x97,  0x37,  
   0x54,  0x30,  0x6f,  0xbb,  0x01,  0x47,  0x32,  0x33,  
   0xcd,  0xdc,  0x57,  0x9b,  0x64,  0x69,  0x61,  0xf8,  
   0x9b,  0x1d,  0x1c,  0x89,  0x4f,  0x5c,  0x67,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA Class3_PCA_G2_v2_pubKey = { 140, (uint8 *)Class3_PCA_G2_v2_pubKey_bytes };


/***********************
Cert File Name: Class4_PCA_G2_v2.cer
Subject Name       :
    Country        : US
    Org            : VeriSign, Inc.
    OrgUnit        : Class 4 Public Primary Certification Authority - G2
    OrgUnit        : (c) 1998 VeriSign, Inc. - For authorized use only
    OrgUnit        : VeriSign Trust Network
 ***********************/
static const uint8 Class4_PCA_G2_v2_subject_bytes[] = {
   0x30,  0x81,  0xc1,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  
   0x31,  0x17,  0x30,  0x15,  0x06,  0x03,  0x55,  0x04,  
   0x0a,  0x13,  0x0e,  0x56,  0x45,  0x52,  0x49,  0x53,  
   0x49,  0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  
   0x2e,  0x31,  0x3c,  0x30,  0x3a,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x33,  0x43,  0x4c,  0x41,  0x53,  
   0x53,  0x20,  0x34,  0x20,  0x50,  0x55,  0x42,  0x4c,  
   0x49,  0x43,  0x20,  0x50,  0x52,  0x49,  0x4d,  0x41,  
   0x52,  0x59,  0x20,  0x43,  0x45,  0x52,  0x54,  0x49,  
   0x46,  0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  
   0x20,  0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  
   0x54,  0x59,  0x20,  0x2d,  0x20,  0x47,  0x32,  0x31,  
   0x3a,  0x30,  0x38,  0x06,  0x03,  0x55,  0x04,  0x0b,  
   0x13,  0x31,  0x28,  0x43,  0x29,  0x20,  0x31,  0x39,  
   0x39,  0x38,  0x20,  0x56,  0x45,  0x52,  0x49,  0x53,  
   0x49,  0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  
   0x2e,  0x20,  0x2d,  0x20,  0x46,  0x4f,  0x52,  0x20,  
   0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  0x5a,  
   0x45,  0x44,  0x20,  0x55,  0x53,  0x45,  0x20,  0x4f,  
   0x4e,  0x4c,  0x59,  0x31,  0x1f,  0x30,  0x1d,  0x06,  
   0x03,  0x55,  0x04,  0x0b,  0x13,  0x16,  0x56,  0x45,  
   0x52,  0x49,  0x53,  0x49,  0x47,  0x4e,  0x20,  0x54,  
   0x52,  0x55,  0x53,  0x54,  0x20,  0x4e,  0x45,  0x54,  
   0x57,  0x4f,  0x52,  0x4b
};
static const CSSM_DATA Class4_PCA_G2_v2_subject = { 196, (uint8 *)Class4_PCA_G2_v2_subject_bytes };
static const uint8 Class4_PCA_G2_v2_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xba,  
   0xf0,  0xe4,  0xcf,  0xf9,  0xc4,  0xae,  0x85,  0x54,  
   0xb9,  0x07,  0x57,  0xf9,  0x8f,  0xc5,  0x7f,  0x68,  
   0x11,  0xf8,  0xc4,  0x17,  0xb0,  0x44,  0xdc,  0xe3,  
   0x30,  0x73,  0xd5,  0x2a,  0x62,  0x2a,  0xb8,  0xd0,  
   0xcc,  0x1c,  0xed,  0x28,  0x5b,  0x7e,  0xbd,  0x6a,  
   0xdc,  0xb3,  0x91,  0x24,  0xca,  0x41,  0x62,  0x3c,  
   0xfc,  0x02,  0x01,  0xbf,  0x1c,  0x16,  0x31,  0x94,  
   0x05,  0x97,  0x76,  0x6e,  0xa2,  0xad,  0xbd,  0x61,  
   0x17,  0x6c,  0x4e,  0x30,  0x86,  0xf0,  0x51,  0x37,  
   0x2a,  0x50,  0xc7,  0xa8,  0x62,  0x81,  0xdc,  0x5b,  
   0x4a,  0xaa,  0xc1,  0xa0,  0xb4,  0x6e,  0xeb,  0x2f,  
   0xe5,  0x57,  0xc5,  0xb1,  0x2b,  0x40,  0x70,  0xdb,  
   0x5a,  0x4d,  0xa1,  0x8e,  0x1f,  0xbd,  0x03,  0x1f,  
   0xd8,  0x03,  0xd4,  0x8f,  0x4c,  0x99,  0x71,  0xbc,  
   0xe2,  0x82,  0xcc,  0x58,  0xe8,  0x98,  0x3a,  0x86,  
   0xd3,  0x86,  0x38,  0xf3,  0x00,  0x29,  0x1f,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA Class4_PCA_G2_v2_pubKey = { 140, (uint8 *)Class4_PCA_G2_v2_pubKey_bytes };


/***********************
Cert File Name: PCA1ss_v4.cer
Subject Name       :
    Country        : US
    Org            : VeriSign, Inc.
    OrgUnit        : Class 1 Public Primary Certification Authority
 ***********************/
static const uint8 PCA1ss_v4_subject_bytes[] = {
   0x30,  0x5f,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  0x31,  
   0x17,  0x30,  0x15,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x0e,  0x56,  0x45,  0x52,  0x49,  0x53,  0x49,  
   0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  0x2e,  
   0x31,  0x37,  0x30,  0x35,  0x06,  0x03,  0x55,  0x04,  
   0x0b,  0x13,  0x2e,  0x43,  0x4c,  0x41,  0x53,  0x53,  
   0x20,  0x31,  0x20,  0x50,  0x55,  0x42,  0x4c,  0x49,  
   0x43,  0x20,  0x50,  0x52,  0x49,  0x4d,  0x41,  0x52,  
   0x59,  0x20,  0x43,  0x45,  0x52,  0x54,  0x49,  0x46,  
   0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  0x20,  
   0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  0x54,  
   0x59
};
static const CSSM_DATA PCA1ss_v4_subject = { 97, (uint8 *)PCA1ss_v4_subject_bytes };
static const uint8 PCA1ss_v4_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xe5,  
   0x19,  0xbf,  0x6d,  0xa3,  0x56,  0x61,  0x2d,  0x99,  
   0x48,  0x71,  0xf6,  0x67,  0xde,  0xb9,  0x8d,  0xeb,  
   0xb7,  0x9e,  0x86,  0x80,  0x0a,  0x91,  0x0e,  0xfa,  
   0x38,  0x25,  0xaf,  0x46,  0x88,  0x82,  0xe5,  0x73,  
   0xa8,  0xa0,  0x9b,  0x24,  0x5d,  0x0d,  0x1f,  0xcc,  
   0x65,  0x6e,  0x0c,  0xb0,  0xd0,  0x56,  0x84,  0x18,  
   0x87,  0x9a,  0x06,  0x9b,  0x10,  0xa1,  0x73,  0xdf,  
   0xb4,  0x58,  0x39,  0x6b,  0x6e,  0xc1,  0xf6,  0x15,  
   0xd5,  0xa8,  0xa8,  0x3f,  0xaa,  0x12,  0x06,  0x8d,  
   0x31,  0xac,  0x7f,  0xb0,  0x34,  0xd7,  0x8f,  0x34,  
   0x67,  0x88,  0x09,  0xcd,  0x14,  0x11,  0xe2,  0x4e,  
   0x45,  0x56,  0x69,  0x1f,  0x78,  0x02,  0x80,  0xda,  
   0xdc,  0x47,  0x91,  0x29,  0xbb,  0x36,  0xc9,  0x63,  
   0x5c,  0xc5,  0xe0,  0xd7,  0x2d,  0x87,  0x7b,  0xa1,  
   0xb7,  0x32,  0xb0,  0x7b,  0x30,  0xba,  0x2a,  0x2f,  
   0x31,  0xaa,  0xee,  0xa3,  0x67,  0xda,  0xdb,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA PCA1ss_v4_pubKey = { 140, (uint8 *)PCA1ss_v4_pubKey_bytes };


/***********************
Cert File Name: PCA2ss_v4.cer
Subject Name       :
    Country        : US
    Org            : VeriSign, Inc.
    OrgUnit        : Class 2 Public Primary Certification Authority
 ***********************/
static const uint8 PCA2ss_v4_subject_bytes[] = {
   0x30,  0x5f,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  0x31,  
   0x17,  0x30,  0x15,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x0e,  0x56,  0x45,  0x52,  0x49,  0x53,  0x49,  
   0x47,  0x4e,  0x2c,  0x20,  0x49,  0x4e,  0x43,  0x2e,  
   0x31,  0x37,  0x30,  0x35,  0x06,  0x03,  0x55,  0x04,  
   0x0b,  0x13,  0x2e,  0x43,  0x4c,  0x41,  0x53,  0x53,  
   0x20,  0x32,  0x20,  0x50,  0x55,  0x42,  0x4c,  0x49,  
   0x43,  0x20,  0x50,  0x52,  0x49,  0x4d,  0x41,  0x52,  
   0x59,  0x20,  0x43,  0x45,  0x52,  0x54,  0x49,  0x46,  
   0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  0x20,  
   0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  0x54,  
   0x59
};
static const CSSM_DATA PCA2ss_v4_subject = { 97, (uint8 *)PCA2ss_v4_subject_bytes };
static const uint8 PCA2ss_v4_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xb6,  
   0x5a,  0x8b,  0xa3,  0x0d,  0x6a,  0x23,  0x83,  0x80,  
   0x6b,  0xcf,  0x39,  0x87,  0xf4,  0x21,  0x13,  0x33,  
   0x06,  0x4c,  0x25,  0xa2,  0xed,  0x55,  0x12,  0x97,  
   0xc5,  0xa7,  0x80,  0xb9,  0xfa,  0x83,  0xc1,  0x20,  
   0xa0,  0xfa,  0x2f,  0x15,  0x0d,  0x7c,  0xa1,  0x60,  
   0x6b,  0x7e,  0x79,  0x2c,  0xfa,  0x06,  0x0f,  0x3a,  
   0xae,  0xf6,  0x1b,  0x6f,  0xb1,  0xd2,  0xff,  0x2f,  
   0x28,  0x52,  0x5f,  0x83,  0x7d,  0x4b,  0xc4,  0x7a,  
   0xb7,  0xf8,  0x66,  0x1f,  0x80,  0x54,  0xfc,  0xb7,  
   0xc2,  0x8e,  0x59,  0x4a,  0x14,  0x57,  0x46,  0xd1,  
   0x9a,  0x93,  0xbe,  0x41,  0x91,  0x03,  0xbb,  0x15,  
   0x80,  0x93,  0x5c,  0xeb,  0xe7,  0xcc,  0x08,  0x6c,  
   0x3f,  0x3e,  0xb3,  0x4a,  0xfc,  0xff,  0x4b,  0x6c,  
   0x23,  0xd5,  0x50,  0x82,  0x26,  0x44,  0x19,  0x8e,  
   0x23,  0xc3,  0x71,  0xea,  0x19,  0x24,  0x47,  0x04,  
   0x9e,  0x75,  0xbf,  0xc8,  0xa6,  0x00,  0x1f,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA PCA2ss_v4_pubKey = { 140, (uint8 *)PCA2ss_v4_pubKey_bytes };

/***********************
Cert File Name: RSASecureServer.cer
Subject Name       :
    Country        : US
    Org            : RSA Data Security, Inc.
    OrgUnit        : Secure Server Certification Authority
 ***********************/
static const uint8 RSASecureServer_subject_bytes[] = {
   0x30,  0x5f,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  0x31,  
   0x20,  0x30,  0x1e,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x17,  0x52,  0x53,  0x41,  0x20,  0x44,  0x41,  
   0x54,  0x41,  0x20,  0x53,  0x45,  0x43,  0x55,  0x52,  
   0x49,  0x54,  0x59,  0x2c,  0x20,  0x49,  0x4e,  0x43,  
   0x2e,  0x31,  0x2e,  0x30,  0x2c,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x25,  0x53,  0x45,  0x43,  0x55,  
   0x52,  0x45,  0x20,  0x53,  0x45,  0x52,  0x56,  0x45,  
   0x52,  0x20,  0x43,  0x45,  0x52,  0x54,  0x49,  0x46,  
   0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  0x20,  
   0x41,  0x55,  0x54,  0x48,  0x4f,  0x52,  0x49,  0x54,  
   0x59
};
static const CSSM_DATA RSASecureServer_subject = { 97, (uint8 *)RSASecureServer_subject_bytes };
static const uint8 RSASecureServer_pubKey_bytes[] = {
   0x30,  0x81,  0x85,  0x02,  0x7e,  0x00,  0x92,  0xce,  
   0x7a,  0xc1,  0xae,  0x83,  0x3e,  0x5a,  0xaa,  0x89,  
   0x83,  0x57,  0xac,  0x25,  0x01,  0x76,  0x0c,  0xad,  
   0xae,  0x8e,  0x2c,  0x37,  0xce,  0xeb,  0x35,  0x78,  
   0x64,  0x54,  0x03,  0xe5,  0x84,  0x40,  0x51,  0xc9,  
   0xbf,  0x8f,  0x08,  0xe2,  0x8a,  0x82,  0x08,  0xd2,  
   0x16,  0x86,  0x37,  0x55,  0xe9,  0xb1,  0x21,  0x02,  
   0xad,  0x76,  0x68,  0x81,  0x9a,  0x05,  0xa2,  0x4b,  
   0xc9,  0x4b,  0x25,  0x66,  0x22,  0x56,  0x6c,  0x88,  
   0x07,  0x8f,  0xf7,  0x81,  0x59,  0x6d,  0x84,  0x07,  
   0x65,  0x70,  0x13,  0x71,  0x76,  0x3e,  0x9b,  0x77,  
   0x4c,  0xe3,  0x50,  0x89,  0x56,  0x98,  0x48,  0xb9,  
   0x1d,  0xa7,  0x29,  0x1a,  0x13,  0x2e,  0x4a,  0x11,  
   0x59,  0x9c,  0x1e,  0x15,  0xd5,  0x49,  0x54,  0x2c,  
   0x73,  0x3a,  0x69,  0x82,  0xb1,  0x97,  0x39,  0x9c,  
   0x6d,  0x70,  0x67,  0x48,  0xe5,  0xdd,  0x2d,  0xd6,  
   0xc8,  0x1e,  0x7b,  0x02,  0x03,  0x01,  0x00,  0x01
   
};
static const CSSM_DATA RSASecureServer_pubKey = { 136, (uint8 *)RSASecureServer_pubKey_bytes };


/***********************
Cert File Name: persbasi.crt
Subject Name       :
    Country        : ZA
    State          : Western Cape
    Locality       : Cape Town
    Org            : Thawte Consulting
    OrgUnit        : Certification Services Division
    Common Name    : Thawte Personal Basic CA
    Email addrs    : personal-basic@thawte.com
 ***********************/
static const uint8 persbasi_subject_bytes[] = {
   0x30,  0x81,  0xcb,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x5a,  0x41,  
   0x31,  0x15,  0x30,  0x13,  0x06,  0x03,  0x55,  0x04,  
   0x08,  0x13,  0x0c,  0x57,  0x45,  0x53,  0x54,  0x45,  
   0x52,  0x4e,  0x20,  0x43,  0x41,  0x50,  0x45,  0x31,  
   0x12,  0x30,  0x10,  0x06,  0x03,  0x55,  0x04,  0x07,  
   0x13,  0x09,  0x43,  0x41,  0x50,  0x45,  0x20,  0x54,  
   0x4f,  0x57,  0x4e,  0x31,  0x1a,  0x30,  0x18,  0x06,  
   0x03,  0x55,  0x04,  0x0a,  0x13,  0x11,  0x54,  0x48,  
   0x41,  0x57,  0x54,  0x45,  0x20,  0x43,  0x4f,  0x4e,  
   0x53,  0x55,  0x4c,  0x54,  0x49,  0x4e,  0x47,  0x31,  
   0x28,  0x30,  0x26,  0x06,  0x03,  0x55,  0x04,  0x0b,  
   0x13,  0x1f,  0x43,  0x45,  0x52,  0x54,  0x49,  0x46,  
   0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  0x20,  
   0x53,  0x45,  0x52,  0x56,  0x49,  0x43,  0x45,  0x53,  
   0x20,  0x44,  0x49,  0x56,  0x49,  0x53,  0x49,  0x4f,  
   0x4e,  0x31,  0x21,  0x30,  0x1f,  0x06,  0x03,  0x55,  
   0x04,  0x03,  0x13,  0x18,  0x54,  0x48,  0x41,  0x57,  
   0x54,  0x45,  0x20,  0x50,  0x45,  0x52,  0x53,  0x4f,  
   0x4e,  0x41,  0x4c,  0x20,  0x42,  0x41,  0x53,  0x49,  
   0x43,  0x20,  0x43,  0x41,  0x31,  0x28,  0x30,  0x26,  
   0x06,  0x09,  0x2a,  0x86,  0x48,  0x86,  0xf7,  0x0d,  
   0x01,  0x09,  0x01,  0x16,  0x19,  0x70,  0x65,  0x72,  
   0x73,  0x6f,  0x6e,  0x61,  0x6c,  0x2d,  0x62,  0x61,  
   0x73,  0x69,  0x63,  0x40,  0x74,  0x68,  0x61,  0x77,  
   0x74,  0x65,  0x2e,  0x63,  0x6f,  0x6d
};
static const CSSM_DATA persbasi_subject = { 206, (uint8 *)persbasi_subject_bytes };
static const uint8 persbasi_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xbc,  
   0xbc,  0x93,  0x53,  0x6d,  0xc0,  0x50,  0x4f,  0x82,  
   0x15,  0xe6,  0x48,  0x94,  0x35,  0xa6,  0x5a,  0xbe,  
   0x6f,  0x42,  0xfa,  0x0f,  0x47,  0xee,  0x77,  0x75,  
   0x72,  0xdd,  0x8d,  0x49,  0x9b,  0x96,  0x57,  0xa0,  
   0x78,  0xd4,  0xca,  0x3f,  0x51,  0xb3,  0x69,  0x0b,  
   0x91,  0x76,  0x17,  0x22,  0x07,  0x97,  0x6a,  0xc4,  
   0x51,  0x93,  0x4b,  0xe0,  0x8d,  0xef,  0x37,  0x95,  
   0xa1,  0x0c,  0x4d,  0xda,  0x34,  0x90,  0x1d,  0x17,  
   0x89,  0x97,  0xe0,  0x35,  0x38,  0x57,  0x4a,  0xc0,  
   0xf4,  0x08,  0x70,  0xe9,  0x3c,  0x44,  0x7b,  0x50,  
   0x7e,  0x61,  0x9a,  0x90,  0xe3,  0x23,  0xd3,  0x88,  
   0x11,  0x46,  0x27,  0xf5,  0x0b,  0x07,  0x0e,  0xbb,  
   0xdd,  0xd1,  0x7f,  0x20,  0x0a,  0x88,  0xb9,  0x56,  
   0x0b,  0x2e,  0x1c,  0x80,  0xda,  0xf1,  0xe3,  0x9e,  
   0x29,  0xef,  0x14,  0xbd,  0x0a,  0x44,  0xfb,  0x1b,  
   0x5b,  0x18,  0xd1,  0xbf,  0x23,  0x93,  0x21,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA persbasi_pubKey = { 140, (uint8 *)persbasi_pubKey_bytes };


/***********************
Cert File Name: persfree.crt
Subject Name       :
    Country        : ZA
    State          : Western Cape
    Locality       : Cape Town
    Org            : Thawte Consulting
    OrgUnit        : Certification Services Division
    Common Name    : Thawte Personal Freemail CA
    Email addrs    : personal-freemail@thawte.com
 ***********************/
static const uint8 persfree_subject_bytes[] = {
   0x30,  0x81,  0xd1,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x5a,  0x41,  
   0x31,  0x15,  0x30,  0x13,  0x06,  0x03,  0x55,  0x04,  
   0x08,  0x13,  0x0c,  0x57,  0x45,  0x53,  0x54,  0x45,  
   0x52,  0x4e,  0x20,  0x43,  0x41,  0x50,  0x45,  0x31,  
   0x12,  0x30,  0x10,  0x06,  0x03,  0x55,  0x04,  0x07,  
   0x13,  0x09,  0x43,  0x41,  0x50,  0x45,  0x20,  0x54,  
   0x4f,  0x57,  0x4e,  0x31,  0x1a,  0x30,  0x18,  0x06,  
   0x03,  0x55,  0x04,  0x0a,  0x13,  0x11,  0x54,  0x48,  
   0x41,  0x57,  0x54,  0x45,  0x20,  0x43,  0x4f,  0x4e,  
   0x53,  0x55,  0x4c,  0x54,  0x49,  0x4e,  0x47,  0x31,  
   0x28,  0x30,  0x26,  0x06,  0x03,  0x55,  0x04,  0x0b,  
   0x13,  0x1f,  0x43,  0x45,  0x52,  0x54,  0x49,  0x46,  
   0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  0x20,  
   0x53,  0x45,  0x52,  0x56,  0x49,  0x43,  0x45,  0x53,  
   0x20,  0x44,  0x49,  0x56,  0x49,  0x53,  0x49,  0x4f,  
   0x4e,  0x31,  0x24,  0x30,  0x22,  0x06,  0x03,  0x55,  
   0x04,  0x03,  0x13,  0x1b,  0x54,  0x48,  0x41,  0x57,  
   0x54,  0x45,  0x20,  0x50,  0x45,  0x52,  0x53,  0x4f,  
   0x4e,  0x41,  0x4c,  0x20,  0x46,  0x52,  0x45,  0x45,  
   0x4d,  0x41,  0x49,  0x4c,  0x20,  0x43,  0x41,  0x31,  
   0x2b,  0x30,  0x29,  0x06,  0x09,  0x2a,  0x86,  0x48,  
   0x86,  0xf7,  0x0d,  0x01,  0x09,  0x01,  0x16,  0x1c,  
   0x70,  0x65,  0x72,  0x73,  0x6f,  0x6e,  0x61,  0x6c,  
   0x2d,  0x66,  0x72,  0x65,  0x65,  0x6d,  0x61,  0x69,  
   0x6c,  0x40,  0x74,  0x68,  0x61,  0x77,  0x74,  0x65,  
   0x2e,  0x63,  0x6f,  0x6d
};
static const CSSM_DATA persfree_subject = { 212, (uint8 *)persfree_subject_bytes };
static const uint8 persfree_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xd4,  
   0x69,  0xd7,  0xd4,  0xb0,  0x94,  0x64,  0x5b,  0x71,  
   0xe9,  0x47,  0xd8,  0x0c,  0x51,  0xb6,  0xea,  0x72,  
   0x91,  0xb0,  0x84,  0x5e,  0x7d,  0x2d,  0x0d,  0x8f,  
   0x7b,  0x12,  0xdf,  0x85,  0x25,  0x75,  0x28,  0x74,  
   0x3a,  0x42,  0x2c,  0x63,  0x27,  0x9f,  0x95,  0x7b,  
   0x4b,  0xef,  0x7e,  0x19,  0x87,  0x1d,  0x86,  0xea,  
   0xa3,  0xdd,  0xb9,  0xce,  0x96,  0x64,  0x1a,  0xc2,  
   0x14,  0x6e,  0x44,  0xac,  0x7c,  0xe6,  0x8f,  0xe8,  
   0x4d,  0x0f,  0x71,  0x1f,  0x40,  0x38,  0xa6,  0x00,  
   0xa3,  0x87,  0x78,  0xf6,  0xf9,  0x94,  0x86,  0x5e,  
   0xad,  0xea,  0xc0,  0x5e,  0x76,  0xeb,  0xd9,  0x14,  
   0xa3,  0x5d,  0x6e,  0x7a,  0x7c,  0x0c,  0xa5,  0x4b,  
   0x55,  0x7f,  0x06,  0x19,  0x29,  0x7f,  0x9e,  0x9a,  
   0x26,  0xd5,  0x6a,  0xbb,  0x38,  0x24,  0x08,  0x6a,  
   0x98,  0xc7,  0xb1,  0xda,  0xa3,  0x98,  0x91,  0xfd,  
   0x79,  0xdb,  0xe5,  0x5a,  0xc4,  0x1c,  0xb9,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA persfree_pubKey = { 140, (uint8 *)persfree_pubKey_bytes };


/***********************
Cert File Name: persprem.crt
Subject Name       :
    Country        : ZA
    State          : Western Cape
    Locality       : Cape Town
    Org            : Thawte Consulting
    OrgUnit        : Certification Services Division
    Common Name    : Thawte Personal Premium CA
    Email addrs    : personal-premium@thawte.com
 ***********************/
static const uint8 persprem_subject_bytes[] = {
   0x30,  0x81,  0xcf,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x5a,  0x41,  
   0x31,  0x15,  0x30,  0x13,  0x06,  0x03,  0x55,  0x04,  
   0x08,  0x13,  0x0c,  0x57,  0x45,  0x53,  0x54,  0x45,  
   0x52,  0x4e,  0x20,  0x43,  0x41,  0x50,  0x45,  0x31,  
   0x12,  0x30,  0x10,  0x06,  0x03,  0x55,  0x04,  0x07,  
   0x13,  0x09,  0x43,  0x41,  0x50,  0x45,  0x20,  0x54,  
   0x4f,  0x57,  0x4e,  0x31,  0x1a,  0x30,  0x18,  0x06,  
   0x03,  0x55,  0x04,  0x0a,  0x13,  0x11,  0x54,  0x48,  
   0x41,  0x57,  0x54,  0x45,  0x20,  0x43,  0x4f,  0x4e,  
   0x53,  0x55,  0x4c,  0x54,  0x49,  0x4e,  0x47,  0x31,  
   0x28,  0x30,  0x26,  0x06,  0x03,  0x55,  0x04,  0x0b,  
   0x13,  0x1f,  0x43,  0x45,  0x52,  0x54,  0x49,  0x46,  
   0x49,  0x43,  0x41,  0x54,  0x49,  0x4f,  0x4e,  0x20,  
   0x53,  0x45,  0x52,  0x56,  0x49,  0x43,  0x45,  0x53,  
   0x20,  0x44,  0x49,  0x56,  0x49,  0x53,  0x49,  0x4f,  
   0x4e,  0x31,  0x23,  0x30,  0x21,  0x06,  0x03,  0x55,  
   0x04,  0x03,  0x13,  0x1a,  0x54,  0x48,  0x41,  0x57,  
   0x54,  0x45,  0x20,  0x50,  0x45,  0x52,  0x53,  0x4f,  
   0x4e,  0x41,  0x4c,  0x20,  0x50,  0x52,  0x45,  0x4d,  
   0x49,  0x55,  0x4d,  0x20,  0x43,  0x41,  0x31,  0x2a,  
   0x30,  0x28,  0x06,  0x09,  0x2a,  0x86,  0x48,  0x86,  
   0xf7,  0x0d,  0x01,  0x09,  0x01,  0x16,  0x1b,  0x70,  
   0x65,  0x72,  0x73,  0x6f,  0x6e,  0x61,  0x6c,  0x2d,  
   0x70,  0x72,  0x65,  0x6d,  0x69,  0x75,  0x6d,  0x40,  
   0x74,  0x68,  0x61,  0x77,  0x74,  0x65,  0x2e,  0x63,  
   0x6f,  0x6d
};
static const CSSM_DATA persprem_subject = { 210, (uint8 *)persprem_subject_bytes };
static const uint8 persprem_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xc9,  
   0x66,  0xd9,  0xf8,  0x07,  0x44,  0xcf,  0xb9,  0x8c,  
   0x2e,  0xf0,  0xa1,  0xef,  0x13,  0x45,  0x6c,  0x05,  
   0xdf,  0xde,  0x27,  0x16,  0x51,  0x36,  0x41,  0x11,  
   0x6c,  0x6c,  0x3b,  0xed,  0xfe,  0x10,  0x7d,  0x12,  
   0x9e,  0xe5,  0x9b,  0x42,  0x9a,  0xfe,  0x60,  0x31,  
   0xc3,  0x66,  0xb7,  0x73,  0x3a,  0x48,  0xae,  0x4e,  
   0xd0,  0x32,  0x37,  0x94,  0x88,  0xb5,  0x0d,  0xb6,  
   0xd9,  0xf3,  0xf2,  0x44,  0xd9,  0xd5,  0x88,  0x12,  
   0xdd,  0x76,  0x4d,  0xf2,  0x1a,  0xfc,  0x6f,  0x23,  
   0x1e,  0x7a,  0xf1,  0xd8,  0x98,  0x45,  0x4e,  0x07,  
   0x10,  0xef,  0x16,  0x42,  0xd0,  0x43,  0x75,  0x6d,  
   0x4a,  0xde,  0xe2,  0xaa,  0xc9,  0x31,  0xff,  0x1f,  
   0x00,  0x70,  0x7c,  0x66,  0xcf,  0x10,  0x25,  0x08,  
   0xba,  0xfa,  0xee,  0x00,  0xe9,  0x46,  0x03,  0x66,  
   0x27,  0x11,  0x15,  0x3b,  0xaa,  0x5b,  0xf2,  0x98,  
   0xdd,  0x36,  0x42,  0xb2,  0xda,  0x88,  0x75,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA persprem_pubKey = { 140, (uint8 *)persprem_pubKey_bytes };

/***********************
Cert File Name: GTECyberTrustGlobalRoot.crt
Subject Name       :
    Country        : US
    Org            : GTE Corporation
    OrgUnit        : GTE CyberTrust Solutions, Inc.
    Common Name    : GTE CyberTrust Global Root
 ***********************/
static const uint8 GTECyberTrustGlobalRoot_subject_bytes[] = {
   0x30,  0x75,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  0x31,  
   0x18,  0x30,  0x16,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x0f,  0x47,  0x54,  0x45,  0x20,  0x43,  0x4f,  
   0x52,  0x50,  0x4f,  0x52,  0x41,  0x54,  0x49,  0x4f,  
   0x4e,  0x31,  0x27,  0x30,  0x25,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x1e,  0x47,  0x54,  0x45,  0x20,  
   0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  0x55,  
   0x53,  0x54,  0x20,  0x53,  0x4f,  0x4c,  0x55,  0x54,  
   0x49,  0x4f,  0x4e,  0x53,  0x2c,  0x20,  0x49,  0x4e,  
   0x43,  0x2e,  0x31,  0x23,  0x30,  0x21,  0x06,  0x03,  
   0x55,  0x04,  0x03,  0x13,  0x1a,  0x47,  0x54,  0x45,  
   0x20,  0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x20,  0x47,  0x4c,  0x4f,  0x42,  
   0x41,  0x4c,  0x20,  0x52,  0x4f,  0x4f,  0x54
};
static const CSSM_DATA GTECyberTrustGlobalRoot_subject = { 119, (uint8 *)GTECyberTrustGlobalRoot_subject_bytes };
static const uint8 GTECyberTrustGlobalRoot_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0x95,  
   0x0f,  0xa0,  0xb6,  0xf0,  0x50,  0x9c,  0xe8,  0x7a,  
   0xc7,  0x88,  0xcd,  0xdd,  0x17,  0x0e,  0x2e,  0xb0,  
   0x94,  0xd0,  0x1b,  0x3d,  0x0e,  0xf6,  0x94,  0xc0,  
   0x8a,  0x94,  0xc7,  0x06,  0xc8,  0x90,  0x97,  0xc8,  
   0xb8,  0x64,  0x1a,  0x7a,  0x7e,  0x6c,  0x3c,  0x53,  
   0xe1,  0x37,  0x28,  0x73,  0x60,  0x7f,  0xb2,  0x97,  
   0x53,  0x07,  0x9f,  0x53,  0xf9,  0x6d,  0x58,  0x94,  
   0xd2,  0xaf,  0x8d,  0x6d,  0x88,  0x67,  0x80,  0xe6,  
   0xed,  0xb2,  0x95,  0xcf,  0x72,  0x31,  0xca,  0xa5,  
   0x1c,  0x72,  0xba,  0x5c,  0x02,  0xe7,  0x64,  0x42,  
   0xe7,  0xf9,  0xa9,  0x2c,  0xd6,  0x3a,  0x0d,  0xac,  
   0x8d,  0x42,  0xaa,  0x24,  0x01,  0x39,  0xe6,  0x9c,  
   0x3f,  0x01,  0x85,  0x57,  0x0d,  0x58,  0x87,  0x45,  
   0xf8,  0xd3,  0x85,  0xaa,  0x93,  0x69,  0x26,  0x85,  
   0x70,  0x48,  0x80,  0x3f,  0x12,  0x15,  0xc7,  0x79,  
   0xb4,  0x1f,  0x05,  0x2f,  0x3b,  0x62,  0x99,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA GTECyberTrustGlobalRoot_pubKey = { 140, (uint8 *)GTECyberTrustGlobalRoot_pubKey_bytes };


/***********************
Cert File Name: GTECyberTrustRoot.crt
Subject Name       :
    Country        : US
    Org            : GTE Corporation
    Common Name    : GTE CyberTrust Root
 ***********************/
static const uint8 GTECyberTrustRoot_subject_bytes[] = {
   0x30,  0x45,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  0x31,  
   0x18,  0x30,  0x16,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x0f,  0x47,  0x54,  0x45,  0x20,  0x43,  0x4f,  
   0x52,  0x50,  0x4f,  0x52,  0x41,  0x54,  0x49,  0x4f,  
   0x4e,  0x31,  0x1c,  0x30,  0x1a,  0x06,  0x03,  0x55,  
   0x04,  0x03,  0x13,  0x13,  0x47,  0x54,  0x45,  0x20,  
   0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  0x55,  
   0x53,  0x54,  0x20,  0x52,  0x4f,  0x4f,  0x54
};
static const CSSM_DATA GTECyberTrustRoot_subject = { 71, (uint8 *)GTECyberTrustRoot_subject_bytes };
static const uint8 GTECyberTrustRoot_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xb8,  
   0xe6,  0x4f,  0xba,  0xdb,  0x98,  0x7c,  0x71,  0x7c,  
   0xaf,  0x44,  0xb7,  0xd3,  0x0f,  0x46,  0xd9,  0x64,  
   0xe5,  0x93,  0xc1,  0x42,  0x8e,  0xc7,  0xba,  0x49,  
   0x8d,  0x35,  0x2d,  0x7a,  0xe7,  0x8b,  0xbd,  0xe5,  
   0x05,  0x31,  0x59,  0xc6,  0xb1,  0x2f,  0x0a,  0x0c,  
   0xfb,  0x9f,  0xa7,  0x3f,  0xa2,  0x09,  0x66,  0x84,  
   0x56,  0x1e,  0x37,  0x29,  0x1b,  0x87,  0xe9,  0x7e,  
   0x0c,  0xca,  0x9a,  0x9f,  0xa5,  0x7f,  0xf5,  0x15,  
   0x94,  0xa3,  0xd5,  0xa2,  0x46,  0x82,  0xd8,  0x68,  
   0x4c,  0xd1,  0x37,  0x15,  0x06,  0x68,  0xaf,  0xbd,  
   0xf8,  0xb0,  0xb3,  0xf0,  0x29,  0xf5,  0x95,  0x5a,  
   0x09,  0x16,  0x61,  0x77,  0x0a,  0x22,  0x25,  0xd4,  
   0x4f,  0x45,  0xaa,  0xc7,  0xbd,  0xe5,  0x96,  0xdf,  
   0xf9,  0xd4,  0xa8,  0x8e,  0x42,  0xcc,  0x24,  0xc0,  
   0x1e,  0x91,  0x27,  0x4a,  0xb5,  0x6d,  0x06,  0x80,  
   0x63,  0x39,  0xc4,  0xa2,  0x5e,  0x38,  0x03,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA GTECyberTrustRoot_pubKey = { 140, (uint8 *)GTECyberTrustRoot_pubKey_bytes };


/***********************
Cert File Name: GTECyberTrustRoot2.crt
Subject Name       :
    Country        : US
    Org            : GTE Corporation
    OrgUnit        : GTE CyberTrust Solutions, Inc.
    Common Name    : GTE CyberTrust Root 2
 ***********************/
static const uint8 GTECyberTrustRoot2_subject_bytes[] = {
   0x30,  0x70,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  0x31,  
   0x18,  0x30,  0x16,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x0f,  0x47,  0x54,  0x45,  0x20,  0x43,  0x4f,  
   0x52,  0x50,  0x4f,  0x52,  0x41,  0x54,  0x49,  0x4f,  
   0x4e,  0x31,  0x27,  0x30,  0x25,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x1e,  0x47,  0x54,  0x45,  0x20,  
   0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  0x55,  
   0x53,  0x54,  0x20,  0x53,  0x4f,  0x4c,  0x55,  0x54,  
   0x49,  0x4f,  0x4e,  0x53,  0x2c,  0x20,  0x49,  0x4e,  
   0x43,  0x2e,  0x31,  0x1e,  0x30,  0x1c,  0x06,  0x03,  
   0x55,  0x04,  0x03,  0x13,  0x15,  0x47,  0x54,  0x45,  
   0x20,  0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x20,  0x52,  0x4f,  0x4f,  0x54,  
   0x20,  0x32
};
static const CSSM_DATA GTECyberTrustRoot2_subject = { 114, (uint8 *)GTECyberTrustRoot2_subject_bytes };
static const uint8 GTECyberTrustRoot2_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xd9,  
   0x2c,  0x4c,  0x4e,  0x2f,  0x69,  0x1a,  0x23,  0xe3,  
   0x56,  0xba,  0xf3,  0xce,  0x84,  0xc0,  0x09,  0xc0,  
   0x79,  0xf1,  0x44,  0x5f,  0x33,  0x1f,  0x15,  0x91,  
   0x7f,  0x8a,  0x88,  0x28,  0xb8,  0x24,  0x45,  0xcc,  
   0x8f,  0x18,  0xcd,  0x1f,  0x74,  0xd1,  0xb5,  0x8f,  
   0x71,  0x4c,  0xd6,  0x31,  0xf6,  0x73,  0x96,  0x84,  
   0x94,  0x40,  0xc5,  0xa9,  0x83,  0x60,  0x24,  0x7d,  
   0xaf,  0x6f,  0x34,  0xb7,  0x4b,  0x4c,  0xc2,  0x09,  
   0x80,  0x3b,  0x45,  0x04,  0x9e,  0xc4,  0x3c,  0xc4,  
   0x27,  0x75,  0x7b,  0x00,  0x0c,  0xa1,  0x64,  0x47,  
   0xb5,  0x14,  0x5d,  0x82,  0x4b,  0x51,  0x3a,  0x58,  
   0xbb,  0x44,  0x4c,  0x3d,  0xd3,  0xe5,  0x06,  0x38,  
   0xe8,  0x61,  0x5c,  0x98,  0x78,  0xbb,  0x80,  0xb3,  
   0x9c,  0xda,  0x72,  0x82,  0x62,  0xa0,  0xdf,  0x9c,  
   0x5f,  0xeb,  0xf9,  0x4f,  0x77,  0xc2,  0xcc,  0x60,  
   0x18,  0x00,  0x6b,  0x34,  0x82,  0x25,  0xb3,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA GTECyberTrustRoot2_pubKey = { 140, (uint8 *)GTECyberTrustRoot2_pubKey_bytes };


/***********************
Cert File Name: GTECyberTrustRoot3.crt
Subject Name       :
    Country        : US
    Org            : GTE Corporation
    OrgUnit        : GTE CyberTrust Solutions, Inc.
    Common Name    : GTE CyberTrust Root 3
 ***********************/
static const uint8 GTECyberTrustRoot3_subject_bytes[] = {
   0x30,  0x70,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  0x31,  
   0x18,  0x30,  0x16,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x0f,  0x47,  0x54,  0x45,  0x20,  0x43,  0x4f,  
   0x52,  0x50,  0x4f,  0x52,  0x41,  0x54,  0x49,  0x4f,  
   0x4e,  0x31,  0x27,  0x30,  0x25,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x1e,  0x47,  0x54,  0x45,  0x20,  
   0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  0x55,  
   0x53,  0x54,  0x20,  0x53,  0x4f,  0x4c,  0x55,  0x54,  
   0x49,  0x4f,  0x4e,  0x53,  0x2c,  0x20,  0x49,  0x4e,  
   0x43,  0x2e,  0x31,  0x1e,  0x30,  0x1c,  0x06,  0x03,  
   0x55,  0x04,  0x03,  0x13,  0x15,  0x47,  0x54,  0x45,  
   0x20,  0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x20,  0x52,  0x4f,  0x4f,  0x54,  
   0x20,  0x33
};
static const CSSM_DATA GTECyberTrustRoot3_subject = { 114, (uint8 *)GTECyberTrustRoot3_subject_bytes };
static const uint8 GTECyberTrustRoot3_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xe1,  
   0xf3,  0xb1,  0x2b,  0x0b,  0xce,  0xdc,  0x14,  0xd9,  
   0x34,  0x97,  0x62,  0x50,  0x12,  0x56,  0x63,  0x84,  
   0x4c,  0x53,  0xfa,  0xc0,  0x85,  0xcf,  0xfa,  0xc1,  
   0xdd,  0x0f,  0xde,  0x79,  0x13,  0x7f,  0x53,  0xfb,  
   0xaa,  0x0e,  0x60,  0xdd,  0xe2,  0x62,  0xbf,  0xc6,  
   0xee,  0x4e,  0x99,  0x34,  0xaa,  0x68,  0x43,  0x35,  
   0x99,  0xf8,  0xa3,  0xfd,  0xf3,  0x63,  0xbd,  0x01,  
   0x54,  0x6a,  0x9e,  0xb2,  0x3a,  0x96,  0x2c,  0x7b,  
   0x78,  0x28,  0xc6,  0x5a,  0xb5,  0x8d,  0x1a,  0x15,  
   0x18,  0xfd,  0xe3,  0x8c,  0x2e,  0xa2,  0x50,  0x09,  
   0x5b,  0x71,  0xd6,  0x0d,  0xb5,  0x18,  0x1f,  0x19,  
   0x8e,  0x04,  0x29,  0x93,  0x93,  0x78,  0xab,  0x5f,  
   0x14,  0xe7,  0x73,  0x42,  0xf2,  0x03,  0x0c,  0x57,  
   0xa2,  0x1b,  0x50,  0x3b,  0x0b,  0xbb,  0x59,  0xe0,  
   0xa0,  0x3a,  0x03,  0xee,  0x27,  0x1b,  0x5a,  0x4c,  
   0xb9,  0xb0,  0x08,  0xca,  0xb9,  0x1a,  0x89,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA GTECyberTrustRoot3_pubKey = { 140, (uint8 *)GTECyberTrustRoot3_pubKey_bytes };


/***********************
Cert File Name: GTECyberTrustRoot4.crt
Subject Name       :
    Country        : US
    Org            : GTE Corporation
    OrgUnit        : GTE CyberTrust Solutions, Inc.
    Common Name    : GTE CyberTrust Root 4
 ***********************/
static const uint8 GTECyberTrustRoot4_subject_bytes[] = {
   0x30,  0x70,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  0x31,  
   0x18,  0x30,  0x16,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x0f,  0x47,  0x54,  0x45,  0x20,  0x43,  0x4f,  
   0x52,  0x50,  0x4f,  0x52,  0x41,  0x54,  0x49,  0x4f,  
   0x4e,  0x31,  0x27,  0x30,  0x25,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x1e,  0x47,  0x54,  0x45,  0x20,  
   0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  0x55,  
   0x53,  0x54,  0x20,  0x53,  0x4f,  0x4c,  0x55,  0x54,  
   0x49,  0x4f,  0x4e,  0x53,  0x2c,  0x20,  0x49,  0x4e,  
   0x43,  0x2e,  0x31,  0x1e,  0x30,  0x1c,  0x06,  0x03,  
   0x55,  0x04,  0x03,  0x13,  0x15,  0x47,  0x54,  0x45,  
   0x20,  0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x20,  0x52,  0x4f,  0x4f,  0x54,  
   0x20,  0x34
};
static const CSSM_DATA GTECyberTrustRoot4_subject = { 114, (uint8 *)GTECyberTrustRoot4_subject_bytes };
static const uint8 GTECyberTrustRoot4_pubKey_bytes[] = {
   0x30,  0x82,  0x01,  0x0a,  0x02,  0x82,  0x01,  0x01,  
   0x00,  0xba,  0x9d,  0x22,  0x6e,  0x7f,  0xda,  0x66,  
   0x3c,  0x39,  0x42,  0xb1,  0xa3,  0x2a,  0x6f,  0xd3,  
   0xf7,  0xbc,  0xae,  0xac,  0x31,  0x5a,  0xd7,  0x11,  
   0x90,  0x47,  0xb9,  0x9d,  0x19,  0x2e,  0xf9,  0xf3,  
   0x1b,  0x22,  0xa0,  0xc3,  0xe1,  0xa7,  0xba,  0xc4,  
   0xfc,  0x5e,  0x0a,  0x94,  0x4b,  0x98,  0x5a,  0x4b,  
   0x26,  0xe4,  0x1f,  0xf4,  0xdc,  0xf3,  0xfe,  0x8e,  
   0x88,  0xdc,  0x6c,  0x2d,  0x7c,  0x77,  0x87,  0x26,  
   0x50,  0xc0,  0x5e,  0x4e,  0xa8,  0x28,  0xa1,  0xea,  
   0x17,  0x69,  0x4f,  0x4d,  0xc6,  0x01,  0x0e,  0xda,  
   0x9a,  0x0d,  0x06,  0x56,  0x26,  0x15,  0xb6,  0xa4,  
   0x5d,  0x7a,  0x35,  0xaf,  0x8d,  0xed,  0x78,  0x52,  
   0x86,  0xf9,  0x38,  0xab,  0xb3,  0x01,  0xd3,  0xda,  
   0x05,  0x96,  0xb1,  0xb6,  0x50,  0xab,  0xc0,  0xa1,  
   0xae,  0x17,  0x53,  0xfa,  0x43,  0x39,  0x20,  0x71,  
   0x65,  0x23,  0xdb,  0x6d,  0xc4,  0xb6,  0xed,  0x98,  
   0x45,  0x83,  0xd7,  0xd2,  0xf6,  0xe2,  0xa9,  0x6b,  
   0xfb,  0xf9,  0x75,  0xcc,  0xef,  0xc5,  0xab,  0x71,  
   0x96,  0x35,  0xe8,  0xdf,  0x8e,  0x91,  0x9b,  0xa8,  
   0x10,  0x75,  0x1f,  0xb7,  0xce,  0x13,  0x8e,  0x6b,  
   0xb3,  0x96,  0x77,  0x97,  0x1a,  0x91,  0x2f,  0xc7,  
   0x2c,  0x69,  0x99,  0xf0,  0x0f,  0x2a,  0x68,  0x00,  
   0x98,  0x76,  0x44,  0x1b,  0x8c,  0x28,  0xd2,  0xeb,  
   0x8e,  0xf4,  0x83,  0xb4,  0x7f,  0xa4,  0x25,  0x5e,  
   0x6c,  0x3b,  0xd9,  0xc6,  0x68,  0xd5,  0x61,  0xb8,  
   0xd4,  0x5e,  0x31,  0x07,  0xb5,  0x5b,  0x90,  0x35,  
   0x52,  0x57,  0x7b,  0x17,  0x20,  0xed,  0x2d,  0xb8,  
   0x1e,  0x8e,  0x88,  0x39,  0x3e,  0x52,  0xcb,  0xdf,  
   0xf0,  0x5c,  0xb1,  0x65,  0xbb,  0xa5,  0x12,  0xb4,  
   0x90,  0x63,  0xbf,  0x71,  0x9d,  0x32,  0xc1,  0xda,  
   0xbf,  0x50,  0x4a,  0x95,  0xbe,  0x06,  0x3a,  0xc4,  
   0x2b,  0xeb,  0xcd,  0x98,  0x76,  0x44,  0x4d,  0x0b,  
   0xe5,  0x02,  0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA GTECyberTrustRoot4_pubKey = { 270, (uint8 *)GTECyberTrustRoot4_pubKey_bytes };


/***********************
Cert File Name: GTECyberTrustRoot5.crt
Subject Name       :
    Country        : US
    Org            : GTE Corporation
    OrgUnit        : GTE CyberTrust Solutions, Inc.
    Common Name    : GTE CyberTrust Root 5
 ***********************/
static const uint8 GTECyberTrustRoot5_subject_bytes[] = {
   0x30,  0x70,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x55,  0x53,  0x31,  
   0x18,  0x30,  0x16,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x0f,  0x47,  0x54,  0x45,  0x20,  0x43,  0x4f,  
   0x52,  0x50,  0x4f,  0x52,  0x41,  0x54,  0x49,  0x4f,  
   0x4e,  0x31,  0x27,  0x30,  0x25,  0x06,  0x03,  0x55,  
   0x04,  0x0b,  0x13,  0x1e,  0x47,  0x54,  0x45,  0x20,  
   0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  0x55,  
   0x53,  0x54,  0x20,  0x53,  0x4f,  0x4c,  0x55,  0x54,  
   0x49,  0x4f,  0x4e,  0x53,  0x2c,  0x20,  0x49,  0x4e,  
   0x43,  0x2e,  0x31,  0x1e,  0x30,  0x1c,  0x06,  0x03,  
   0x55,  0x04,  0x03,  0x13,  0x15,  0x47,  0x54,  0x45,  
   0x20,  0x43,  0x59,  0x42,  0x45,  0x52,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x20,  0x52,  0x4f,  0x4f,  0x54,  
   0x20,  0x35
};
static const CSSM_DATA GTECyberTrustRoot5_subject = { 114, (uint8 *)GTECyberTrustRoot5_subject_bytes };
static const uint8 GTECyberTrustRoot5_pubKey_bytes[] = {
   0x30,  0x82,  0x01,  0x0a,  0x02,  0x82,  0x01,  0x01,  
   0x00,  0xbc,  0x12,  0x6e,  0x3f,  0x8a,  0x7c,  0x7a,  
   0x97,  0x01,  0xec,  0x1e,  0xbb,  0x39,  0x5a,  0x02,  
   0xf4,  0x78,  0x44,  0xa2,  0x48,  0x1b,  0x8e,  0x7b,  
   0x49,  0x52,  0x7a,  0xb8,  0x7b,  0x47,  0xb3,  0xaf,  
   0x94,  0x9b,  0x6f,  0xbb,  0x96,  0xfa,  0x2b,  0x6a,  
   0x65,  0x5c,  0xb8,  0x1c,  0x94,  0x73,  0xbe,  0xbf,  
   0x89,  0x0a,  0x22,  0x80,  0xee,  0x57,  0xfc,  0x8c,  
   0x05,  0xbb,  0x70,  0x9f,  0x97,  0x39,  0x04,  0xda,  
   0xa3,  0x87,  0x5c,  0xa8,  0xe5,  0xca,  0xaf,  0xc0,  
   0x33,  0x9a,  0xd5,  0x37,  0x5c,  0x4b,  0xac,  0xe4,  
   0x80,  0xd0,  0xa6,  0x23,  0x60,  0xfb,  0xfd,  0x72,  
   0x2e,  0x94,  0x9d,  0xc7,  0xce,  0xc2,  0x04,  0x32,  
   0xef,  0x78,  0x60,  0x5d,  0xed,  0xad,  0x87,  0x0f,  
   0x45,  0x65,  0x1e,  0x3c,  0x9a,  0x0a,  0x9a,  0xbe,  
   0x5d,  0x1d,  0x99,  0xec,  0xe7,  0xf2,  0xd1,  0xc6,  
   0x7a,  0x17,  0xd9,  0xad,  0x9b,  0x54,  0x96,  0x7f,  
   0xc4,  0x7c,  0x60,  0xbf,  0x85,  0xaa,  0x15,  0x35,  
   0x1d,  0x40,  0xda,  0x11,  0xbc,  0xec,  0x54,  0x21,  
   0x28,  0x2d,  0x23,  0xa1,  0xa8,  0xf0,  0xcf,  0x2d,  
   0xcd,  0xdd,  0xfc,  0x7e,  0x0f,  0x5e,  0xe1,  0x65,  
   0x07,  0x56,  0xcb,  0x07,  0xb4,  0xd2,  0x56,  0xe8,  
   0x5e,  0x31,  0xcc,  0x18,  0x63,  0xc4,  0x86,  0xd2,  
   0x2d,  0x85,  0xcf,  0x93,  0x92,  0xab,  0x6d,  0xfe,  
   0x68,  0x39,  0xfb,  0xde,  0x73,  0xbd,  0x86,  0xf8,  
   0xe4,  0x46,  0x7a,  0xea,  0x9f,  0x0c,  0xcb,  0xf4,  
   0x19,  0xfe,  0x63,  0xbc,  0xd1,  0x2c,  0x7b,  0x88,  
   0x33,  0x36,  0xf6,  0xe4,  0xe1,  0x9c,  0x0c,  0x53,  
   0x81,  0x60,  0x1c,  0xda,  0x2e,  0xab,  0x96,  0xa9,  
   0x16,  0x88,  0x13,  0x50,  0x99,  0xb2,  0xbd,  0x55,  
   0xdf,  0x15,  0x30,  0x7e,  0xe8,  0xe5,  0x98,  0xfb,  
   0x70,  0x7e,  0x6c,  0xb5,  0x07,  0xfc,  0xfc,  0x46,  
   0xb7,  0xd0,  0xed,  0x37,  0x96,  0x7e,  0x32,  0xfe,  
   0x21,  0x02,  0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA GTECyberTrustRoot5_pubKey = { 270, (uint8 *)GTECyberTrustRoot5_pubKey_bytes };


/***********************
Cert File Name: BTCTRoot.uu.raw
Subject Name       :
    Country        : IE
    Org            : Baltimore
    OrgUnit        : CyberTrust
    Common Name    : Baltimore CyberTrust Root
 ***********************/
static const uint8 BTCTRoot_subject_bytes[] = {
   0x30,  0x5a,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x49,  0x45,  0x31,  
   0x12,  0x30,  0x10,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x09,  0x42,  0x41,  0x4c,  0x54,  0x49,  0x4d,  
   0x4f,  0x52,  0x45,  0x31,  0x13,  0x30,  0x11,  0x06,  
   0x03,  0x55,  0x04,  0x0b,  0x13,  0x0a,  0x43,  0x59,  
   0x42,  0x45,  0x52,  0x54,  0x52,  0x55,  0x53,  0x54,  
   0x31,  0x22,  0x30,  0x20,  0x06,  0x03,  0x55,  0x04,  
   0x03,  0x13,  0x19,  0x42,  0x41,  0x4c,  0x54,  0x49,  
   0x4d,  0x4f,  0x52,  0x45,  0x20,  0x43,  0x59,  0x42,  
   0x45,  0x52,  0x54,  0x52,  0x55,  0x53,  0x54,  0x20,  
   0x52,  0x4f,  0x4f,  0x54
};
static const CSSM_DATA BTCTRoot_subject = { 92, (uint8 *)BTCTRoot_subject_bytes };
static const uint8 BTCTRoot_pubKey_bytes[] = {
   0x30,  0x82,  0x01,  0x0a,  0x02,  0x82,  0x01,  0x01,  
   0x00,  0xa3,  0x04,  0xbb,  0x22,  0xab,  0x98,  0x3d,  
   0x57,  0xe8,  0x26,  0x72,  0x9a,  0xb5,  0x79,  0xd4,  
   0x29,  0xe2,  0xe1,  0xe8,  0x95,  0x80,  0xb1,  0xb0,  
   0xe3,  0x5b,  0x8e,  0x2b,  0x29,  0x9a,  0x64,  0xdf,  
   0xa1,  0x5d,  0xed,  0xb0,  0x09,  0x05,  0x6d,  0xdb,  
   0x28,  0x2e,  0xce,  0x62,  0xa2,  0x62,  0xfe,  0xb4,  
   0x88,  0xda,  0x12,  0xeb,  0x38,  0xeb,  0x21,  0x9d,  
   0xc0,  0x41,  0x2b,  0x01,  0x52,  0x7b,  0x88,  0x77,  
   0xd3,  0x1c,  0x8f,  0xc7,  0xba,  0xb9,  0x88,  0xb5,  
   0x6a,  0x09,  0xe7,  0x73,  0xe8,  0x11,  0x40,  0xa7,  
   0xd1,  0xcc,  0xca,  0x62,  0x8d,  0x2d,  0xe5,  0x8f,  
   0x0b,  0xa6,  0x50,  0xd2,  0xa8,  0x50,  0xc3,  0x28,  
   0xea,  0xf5,  0xab,  0x25,  0x87,  0x8a,  0x9a,  0x96,  
   0x1c,  0xa9,  0x67,  0xb8,  0x3f,  0x0c,  0xd5,  0xf7,  
   0xf9,  0x52,  0x13,  0x2f,  0xc2,  0x1b,  0xd5,  0x70,  
   0x70,  0xf0,  0x8f,  0xc0,  0x12,  0xca,  0x06,  0xcb,  
   0x9a,  0xe1,  0xd9,  0xca,  0x33,  0x7a,  0x77,  0xd6,  
   0xf8,  0xec,  0xb9,  0xf1,  0x68,  0x44,  0x42,  0x48,  
   0x13,  0xd2,  0xc0,  0xc2,  0xa4,  0xae,  0x5e,  0x60,  
   0xfe,  0xb6,  0xa6,  0x05,  0xfc,  0xb4,  0xdd,  0x07,  
   0x59,  0x02,  0xd4,  0x59,  0x18,  0x98,  0x63,  0xf5,  
   0xa5,  0x63,  0xe0,  0x90,  0x0c,  0x7d,  0x5d,  0xb2,  
   0x06,  0x7a,  0xf3,  0x85,  0xea,  0xeb,  0xd4,  0x03,  
   0xae,  0x5e,  0x84,  0x3e,  0x5f,  0xff,  0x15,  0xed,  
   0x69,  0xbc,  0xf9,  0x39,  0x36,  0x72,  0x75,  0xcf,  
   0x77,  0x52,  0x4d,  0xf3,  0xc9,  0x90,  0x2c,  0xb9,  
   0x3d,  0xe5,  0xc9,  0x23,  0x53,  0x3f,  0x1f,  0x24,  
   0x98,  0x21,  0x5c,  0x07,  0x99,  0x29,  0xbd,  0xc6,  
   0x3a,  0xec,  0xe7,  0x6e,  0x86,  0x3a,  0x6b,  0x97,  
   0x74,  0x63,  0x33,  0xbd,  0x68,  0x18,  0x31,  0xf0,  
   0x78,  0x8d,  0x76,  0xbf,  0xfc,  0x9e,  0x8e,  0x5d,  
   0x2a,  0x86,  0xa7,  0x4d,  0x90,  0xdc,  0x27,  0x1a,  
   0x39,  0x02,  0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA BTCTRoot_pubKey = { 270, (uint8 *)BTCTRoot_pubKey_bytes };

/***********************
Cert File Name: BTCTcodert.uu.raw
Subject Name       :
    Country        : IE
    Org            : Baltimore
    OrgUnit        : CyberTrust
    Common Name    : Baltimore CyberTrust Code Signing Root
 ***********************/
static const uint8 BTCTcodert_subject_bytes[] = {
   0x30,  0x67,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x49,  0x45,  0x31,  
   0x12,  0x30,  0x10,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x09,  0x42,  0x41,  0x4c,  0x54,  0x49,  0x4d,  
   0x4f,  0x52,  0x45,  0x31,  0x13,  0x30,  0x11,  0x06,  
   0x03,  0x55,  0x04,  0x0b,  0x13,  0x0a,  0x43,  0x59,  
   0x42,  0x45,  0x52,  0x54,  0x52,  0x55,  0x53,  0x54,  
   0x31,  0x2f,  0x30,  0x2d,  0x06,  0x03,  0x55,  0x04,  
   0x03,  0x13,  0x26,  0x42,  0x41,  0x4c,  0x54,  0x49,  
   0x4d,  0x4f,  0x52,  0x45,  0x20,  0x43,  0x59,  0x42,  
   0x45,  0x52,  0x54,  0x52,  0x55,  0x53,  0x54,  0x20,  
   0x43,  0x4f,  0x44,  0x45,  0x20,  0x53,  0x49,  0x47,  
   0x4e,  0x49,  0x4e,  0x47,  0x20,  0x52,  0x4f,  0x4f,  
   0x54
};
static const CSSM_DATA BTCTcodert_subject = { 105, (uint8 *)BTCTcodert_subject_bytes };
static const uint8 BTCTcodert_pubKey_bytes[] = {
   0x30,  0x82,  0x01,  0x0a,  0x02,  0x82,  0x01,  0x01,  
   0x00,  0xc8,  0x71,  0x9a,  0x18,  0x12,  0x8e,  0x7a,  
   0xdb,  0xf9,  0x9a,  0xfc,  0x41,  0xaf,  0xd8,  0xf2,  
   0xf4,  0x09,  0x8e,  0xad,  0x3f,  0xfe,  0x67,  0x37,  
   0x3c,  0xda,  0xc9,  0x26,  0x50,  0xb1,  0xb1,  0x3e,  
   0xcb,  0xe8,  0x4e,  0x73,  0x00,  0xf2,  0xb2,  0xdc,  
   0xf3,  0xc5,  0x46,  0xfb,  0x09,  0xef,  0x18,  0x96,  
   0xce,  0xa7,  0xe0,  0x9c,  0x84,  0x5d,  0x20,  0x0e,  
   0x7a,  0xa0,  0xaa,  0x36,  0x8b,  0xfa,  0x28,  0xb6,  
   0x78,  0x2e,  0xb3,  0xec,  0xe8,  0x47,  0xf3,  0x04,  
   0xf0,  0x90,  0x23,  0xb4,  0xea,  0xaf,  0xe5,  0x53,  
   0xb8,  0x05,  0xf7,  0x47,  0x5d,  0x2b,  0x86,  0xf1,  
   0xa7,  0xa4,  0xc6,  0x3b,  0x35,  0xb6,  0xd2,  0x0d,  
   0x52,  0x41,  0xd7,  0xf4,  0x92,  0x75,  0xe1,  0xa2,  
   0x0a,  0x50,  0x56,  0x87,  0xbe,  0x97,  0x0b,  0x7b,  
   0x33,  0x85,  0x10,  0xb9,  0x28,  0x18,  0xee,  0x33,  
   0xea,  0x48,  0x11,  0xd7,  0x5b,  0x91,  0x47,  0x76,  
   0x22,  0xd4,  0xee,  0xcf,  0x5d,  0xe7,  0xa8,  0x4e,  
   0x1c,  0x9d,  0x96,  0x91,  0xdd,  0x9c,  0xbd,  0x74,  
   0x09,  0xa8,  0x72,  0x61,  0xaa,  0xb0,  0x21,  0x3a,  
   0xf1,  0x3d,  0x2c,  0x03,  0x56,  0x09,  0xd2,  0xc1,  
   0xdc,  0xc3,  0xb5,  0xc7,  0x54,  0x37,  0xab,  0xe6,  
   0x26,  0xa2,  0xb2,  0x46,  0x71,  0x73,  0xca,  0x11,  
   0x88,  0xee,  0xbc,  0xe7,  0x64,  0xf7,  0xd0,  0x11,  
   0x1a,  0x73,  0x40,  0x5a,  0xc8,  0x49,  0x2c,  0x0f,  
   0xb7,  0xef,  0x90,  0x7f,  0x68,  0x80,  0x04,  0x38,  
   0x0b,  0x1b,  0x0f,  0x3b,  0xd4,  0xf5,  0xa0,  0xb3,  
   0xc2,  0x8e,  0xe1,  0x34,  0xb4,  0x80,  0x99,  0x6d,  
   0x9e,  0x76,  0xd4,  0x92,  0x29,  0x40,  0xb1,  0x95,  
   0xd2,  0x37,  0xa4,  0x67,  0x12,  0x7f,  0xe0,  0x62,  
   0xbb,  0xae,  0x35,  0xc5,  0x99,  0x36,  0x82,  0x44,  
   0xb8,  0xe6,  0x78,  0x18,  0x33,  0x61,  0x71,  0x93,  
   0x5b,  0x2d,  0x8d,  0x9f,  0x78,  0x95,  0x82,  0xeb,  
   0x6d,  0x02,  0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA BTCTcodert_pubKey = { 270, (uint8 *)BTCTcodert_pubKey_bytes };


/***********************
Cert File Name: BTCTmort.uu.raw
Subject Name       :
    Country        : IE
    Org            : Baltimore
    OrgUnit        : CyberTrust
    Common Name    : Baltimore CyberTrust Mobile Root
 ***********************/
static const uint8 BTCTmort_subject_bytes[] = {
   0x30,  0x61,  0x31,  0x0b,  0x30,  0x09,  0x06,  0x03,  
   0x55,  0x04,  0x06,  0x13,  0x02,  0x49,  0x45,  0x31,  
   0x12,  0x30,  0x10,  0x06,  0x03,  0x55,  0x04,  0x0a,  
   0x13,  0x09,  0x42,  0x41,  0x4c,  0x54,  0x49,  0x4d,  
   0x4f,  0x52,  0x45,  0x31,  0x13,  0x30,  0x11,  0x06,  
   0x03,  0x55,  0x04,  0x0b,  0x13,  0x0a,  0x43,  0x59,  
   0x42,  0x45,  0x52,  0x54,  0x52,  0x55,  0x53,  0x54,  
   0x31,  0x29,  0x30,  0x27,  0x06,  0x03,  0x55,  0x04,  
   0x03,  0x13,  0x20,  0x42,  0x41,  0x4c,  0x54,  0x49,  
   0x4d,  0x4f,  0x52,  0x45,  0x20,  0x43,  0x59,  0x42,  
   0x45,  0x52,  0x54,  0x52,  0x55,  0x53,  0x54,  0x20,  
   0x4d,  0x4f,  0x42,  0x49,  0x4c,  0x45,  0x20,  0x52,  
   0x4f,  0x4f,  0x54
};
static const CSSM_DATA BTCTmort_subject = { 99, (uint8 *)BTCTmort_subject_bytes };
static const uint8 BTCTmort_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xa3,  
   0x6d,  0xb1,  0x38,  0x56,  0xac,  0xfc,  0xb5,  0x56,  
   0x21,  0xde,  0xc0,  0x90,  0x5d,  0x26,  0x47,  0x82,  
   0xc6,  0x7d,  0x8f,  0x1f,  0xa0,  0x85,  0x8f,  0x2f,  
   0xbb,  0xd4,  0xe1,  0x1c,  0x1d,  0xf2,  0x24,  0x1f,  
   0x28,  0xb0,  0x2f,  0xb9,  0xa4,  0xa5,  0x6f,  0xa2,  
   0x22,  0x20,  0x64,  0xfe,  0x84,  0x47,  0x3c,  0x7e,  
   0x2b,  0x6c,  0x69,  0x6a,  0xb8,  0xd4,  0xc0,  0x96,  
   0x8e,  0x8c,  0x52,  0x0d,  0xcd,  0x6f,  0x41,  0xd4,  
   0xbf,  0x04,  0xae,  0xa7,  0x81,  0x2f,  0x2d,  0x98,  
   0x48,  0xd2,  0xc1,  0x94,  0xa3,  0xb5,  0x19,  0x5d,  
   0x5d,  0x51,  0x64,  0xf4,  0x8e,  0x41,  0xb0,  0x9b,  
   0xc0,  0x2d,  0x22,  0xa0,  0x5e,  0xc6,  0xd8,  0x5a,  
   0x12,  0x63,  0xbc,  0x11,  0x4a,  0x5e,  0x26,  0x12,  
   0x1d,  0xe2,  0x26,  0x05,  0xe6,  0x0f,  0x5f,  0x22,  
   0x1f,  0x7a,  0x5f,  0x76,  0x94,  0xae,  0xcf,  0x5a,  
   0x28,  0x0e,  0xab,  0x45,  0xda,  0x22,  0x31,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA BTCTmort_pubKey = { 140, (uint8 *)BTCTmort_pubKey_bytes };


/***********************
Cert File Name: TC_Class_0.cer
Subject Name       :
    Country        : DE
    State          : Hamburg
    Locality       : Hamburg
    Org            : TC TrustCenter for Security in Data Networks GmbH
    OrgUnit        : TC TrustCenter Class 0 CA
    Email addrs    : certificate@trustcenter.de
 ***********************/
static const uint8 TC_Class_0_subject_bytes[] = {
   0x30,  0x81,  0xbc,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x44,  0x45,  
   0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  0x55,  0x04,  
   0x08,  0x13,  0x07,  0x48,  0x41,  0x4d,  0x42,  0x55,  
   0x52,  0x47,  0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  
   0x55,  0x04,  0x07,  0x13,  0x07,  0x48,  0x41,  0x4d,  
   0x42,  0x55,  0x52,  0x47,  0x31,  0x3a,  0x30,  0x38,  
   0x06,  0x03,  0x55,  0x04,  0x0a,  0x13,  0x31,  0x54,  
   0x43,  0x20,  0x54,  0x52,  0x55,  0x53,  0x54,  0x43,  
   0x45,  0x4e,  0x54,  0x45,  0x52,  0x20,  0x46,  0x4f,  
   0x52,  0x20,  0x53,  0x45,  0x43,  0x55,  0x52,  0x49,  
   0x54,  0x59,  0x20,  0x49,  0x4e,  0x20,  0x44,  0x41,  
   0x54,  0x41,  0x20,  0x4e,  0x45,  0x54,  0x57,  0x4f,  
   0x52,  0x4b,  0x53,  0x20,  0x47,  0x4d,  0x42,  0x48,  
   0x31,  0x22,  0x30,  0x20,  0x06,  0x03,  0x55,  0x04,  
   0x0b,  0x13,  0x19,  0x54,  0x43,  0x20,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x43,  0x45,  0x4e,  0x54,  0x45,  
   0x52,  0x20,  0x43,  0x4c,  0x41,  0x53,  0x53,  0x20,  
   0x30,  0x20,  0x43,  0x41,  0x31,  0x29,  0x30,  0x27,  
   0x06,  0x09,  0x2a,  0x86,  0x48,  0x86,  0xf7,  0x0d,  
   0x01,  0x09,  0x01,  0x16,  0x1a,  0x63,  0x65,  0x72,  
   0x74,  0x69,  0x66,  0x69,  0x63,  0x61,  0x74,  0x65,  
   0x40,  0x74,  0x72,  0x75,  0x73,  0x74,  0x63,  0x65,  
   0x6e,  0x74,  0x65,  0x72,  0x2e,  0x64,  0x65
};
static const CSSM_DATA TC_Class_0_subject = { 191, (uint8 *)TC_Class_0_subject_bytes };
static const uint8 TC_Class_0_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xdf,  
   0x7d,  0xe6,  0xbe,  0xbf,  0xd5,  0xf0,  0x2f,  0x6d,  
   0x4e,  0x0e,  0xd1,  0xe0,  0x8d,  0x0b,  0x7f,  0x3b,  
   0x54,  0xe8,  0x8a,  0xe2,  0xb0,  0x9f,  0x28,  0xc5,  
   0x8a,  0xc6,  0xb9,  0xb3,  0x33,  0x27,  0xf5,  0x27,  
   0xca,  0x1a,  0x4c,  0x54,  0x12,  0x6b,  0xb4,  0xb2,  
   0x46,  0xb3,  0x1d,  0x4b,  0xb3,  0xf4,  0x21,  0x0b,  
   0x4b,  0x02,  0x2e,  0xa1,  0xc2,  0x34,  0x9c,  0x85,  
   0xa0,  0xc4,  0x78,  0x11,  0xdb,  0xdb,  0x6b,  0x27,  
   0x2b,  0x09,  0x2a,  0x18,  0x4e,  0x40,  0xcc,  0x9f,  
   0x71,  0x19,  0x67,  0x99,  0x74,  0xa2,  0x7c,  0x3f,  
   0xc1,  0xd8,  0x8b,  0x23,  0xc8,  0x63,  0x3b,  0x8a,  
   0x21,  0xab,  0x5c,  0xde,  0x1e,  0xf4,  0x8d,  0xdc,  
   0xb4,  0x18,  0xc3,  0x05,  0x73,  0xf4,  0x6a,  0xb4,  
   0xa1,  0xfa,  0x01,  0x08,  0x2b,  0x01,  0x0f,  0x6d,  
   0x37,  0x5b,  0xaa,  0x38,  0x86,  0x67,  0x39,  0xd7,  
   0xe5,  0x5f,  0xfa,  0xe4,  0x7e,  0xcc,  0xa3,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA TC_Class_0_pubKey = { 140, (uint8 *)TC_Class_0_pubKey_bytes };


/***********************
Cert File Name: TC_Class_1.cer
Subject Name       :
    Country        : DE
    State          : Hamburg
    Locality       : Hamburg
    Org            : TC TrustCenter for Security in Data Networks GmbH
    OrgUnit        : TC TrustCenter Class 1 CA
    Email addrs    : certificate@trustcenter.de
 ***********************/
static const uint8 TC_Class_1_subject_bytes[] = {
   0x30,  0x81,  0xbc,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x44,  0x45,  
   0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  0x55,  0x04,  
   0x08,  0x13,  0x07,  0x48,  0x41,  0x4d,  0x42,  0x55,  
   0x52,  0x47,  0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  
   0x55,  0x04,  0x07,  0x13,  0x07,  0x48,  0x41,  0x4d,  
   0x42,  0x55,  0x52,  0x47,  0x31,  0x3a,  0x30,  0x38,  
   0x06,  0x03,  0x55,  0x04,  0x0a,  0x13,  0x31,  0x54,  
   0x43,  0x20,  0x54,  0x52,  0x55,  0x53,  0x54,  0x43,  
   0x45,  0x4e,  0x54,  0x45,  0x52,  0x20,  0x46,  0x4f,  
   0x52,  0x20,  0x53,  0x45,  0x43,  0x55,  0x52,  0x49,  
   0x54,  0x59,  0x20,  0x49,  0x4e,  0x20,  0x44,  0x41,  
   0x54,  0x41,  0x20,  0x4e,  0x45,  0x54,  0x57,  0x4f,  
   0x52,  0x4b,  0x53,  0x20,  0x47,  0x4d,  0x42,  0x48,  
   0x31,  0x22,  0x30,  0x20,  0x06,  0x03,  0x55,  0x04,  
   0x0b,  0x13,  0x19,  0x54,  0x43,  0x20,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x43,  0x45,  0x4e,  0x54,  0x45,  
   0x52,  0x20,  0x43,  0x4c,  0x41,  0x53,  0x53,  0x20,  
   0x31,  0x20,  0x43,  0x41,  0x31,  0x29,  0x30,  0x27,  
   0x06,  0x09,  0x2a,  0x86,  0x48,  0x86,  0xf7,  0x0d,  
   0x01,  0x09,  0x01,  0x16,  0x1a,  0x63,  0x65,  0x72,  
   0x74,  0x69,  0x66,  0x69,  0x63,  0x61,  0x74,  0x65,  
   0x40,  0x74,  0x72,  0x75,  0x73,  0x74,  0x63,  0x65,  
   0x6e,  0x74,  0x65,  0x72,  0x2e,  0x64,  0x65
};
static const CSSM_DATA TC_Class_1_subject = { 191, (uint8 *)TC_Class_1_subject_bytes };
static const uint8 TC_Class_1_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xb0,  
   0x29,  0xeb,  0xb4,  0x76,  0xb3,  0xae,  0xd7,  0xb6,  
   0x5b,  0xb4,  0x5e,  0xe7,  0xbd,  0xe3,  0xb1,  0x9c,  
   0x49,  0x04,  0x57,  0x5b,  0xa1,  0xab,  0xd9,  0x7f,  
   0x13,  0x1b,  0xfd,  0xba,  0x61,  0xab,  0xd8,  0xe7,  
   0x71,  0xdf,  0x2d,  0x00,  0x94,  0x5d,  0x51,  0x48,  
   0x7d,  0x23,  0xef,  0x75,  0x62,  0x84,  0x90,  0x3c,  
   0x0a,  0x1f,  0x59,  0x11,  0x74,  0x2f,  0x8e,  0x80,  
   0xa5,  0xfd,  0x30,  0x02,  0x3d,  0x29,  0x52,  0xcd,  
   0x72,  0x1a,  0x49,  0x21,  0x9c,  0xbc,  0xcb,  0x52,  
   0x8e,  0x48,  0xa1,  0x63,  0x96,  0xc8,  0x10,  0x85,  
   0x30,  0x69,  0x57,  0x74,  0x45,  0xc0,  0x5a,  0x86,  
   0xc6,  0xd5,  0x3d,  0xe0,  0x68,  0x57,  0x7d,  0x31,  
   0x6a,  0x24,  0x8d,  0x45,  0x97,  0x3e,  0x31,  0x7e,  
   0x68,  0x66,  0x32,  0x6e,  0x24,  0x6d,  0xec,  0x32,  
   0x36,  0xc9,  0x41,  0xca,  0xf0,  0x31,  0x44,  0xc8,  
   0xa3,  0x61,  0xca,  0x1b,  0xa0,  0x36,  0x1f,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA TC_Class_1_pubKey = { 140, (uint8 *)TC_Class_1_pubKey_bytes };


/***********************
Cert File Name: TC_Class_2.cer
Subject Name       :
    Country        : DE
    State          : Hamburg
    Locality       : Hamburg
    Org            : TC TrustCenter for Security in Data Networks GmbH
    OrgUnit        : TC TrustCenter Class 2 CA
    Email addrs    : certificate@trustcenter.de
 ***********************/
static const uint8 TC_Class_2_subject_bytes[] = {
   0x30,  0x81,  0xbc,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x44,  0x45,  
   0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  0x55,  0x04,  
   0x08,  0x13,  0x07,  0x48,  0x41,  0x4d,  0x42,  0x55,  
   0x52,  0x47,  0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  
   0x55,  0x04,  0x07,  0x13,  0x07,  0x48,  0x41,  0x4d,  
   0x42,  0x55,  0x52,  0x47,  0x31,  0x3a,  0x30,  0x38,  
   0x06,  0x03,  0x55,  0x04,  0x0a,  0x13,  0x31,  0x54,  
   0x43,  0x20,  0x54,  0x52,  0x55,  0x53,  0x54,  0x43,  
   0x45,  0x4e,  0x54,  0x45,  0x52,  0x20,  0x46,  0x4f,  
   0x52,  0x20,  0x53,  0x45,  0x43,  0x55,  0x52,  0x49,  
   0x54,  0x59,  0x20,  0x49,  0x4e,  0x20,  0x44,  0x41,  
   0x54,  0x41,  0x20,  0x4e,  0x45,  0x54,  0x57,  0x4f,  
   0x52,  0x4b,  0x53,  0x20,  0x47,  0x4d,  0x42,  0x48,  
   0x31,  0x22,  0x30,  0x20,  0x06,  0x03,  0x55,  0x04,  
   0x0b,  0x13,  0x19,  0x54,  0x43,  0x20,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x43,  0x45,  0x4e,  0x54,  0x45,  
   0x52,  0x20,  0x43,  0x4c,  0x41,  0x53,  0x53,  0x20,  
   0x32,  0x20,  0x43,  0x41,  0x31,  0x29,  0x30,  0x27,  
   0x06,  0x09,  0x2a,  0x86,  0x48,  0x86,  0xf7,  0x0d,  
   0x01,  0x09,  0x01,  0x16,  0x1a,  0x63,  0x65,  0x72,  
   0x74,  0x69,  0x66,  0x69,  0x63,  0x61,  0x74,  0x65,  
   0x40,  0x74,  0x72,  0x75,  0x73,  0x74,  0x63,  0x65,  
   0x6e,  0x74,  0x65,  0x72,  0x2e,  0x64,  0x65
};
static const CSSM_DATA TC_Class_2_subject = { 191, (uint8 *)TC_Class_2_subject_bytes };
static const uint8 TC_Class_2_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xda,  
   0x38,  0xe8,  0xed,  0x32,  0x00,  0x29,  0x71,  0x83,  
   0x01,  0x0d,  0xbf,  0x8c,  0x01,  0xdc,  0xda,  0xc6,  
   0xad,  0x39,  0xa4,  0xa9,  0x8a,  0x2f,  0xd5,  0x8b,  
   0x5c,  0x68,  0x5f,  0x50,  0xc6,  0x62,  0xf5,  0x66,  
   0xbd,  0xca,  0x91,  0x22,  0xec,  0xaa,  0x1d,  0x51,  
   0xd7,  0x3d,  0xb3,  0x51,  0xb2,  0x83,  0x4e,  0x5d,  
   0xcb,  0x49,  0xb0,  0xf0,  0x4c,  0x55,  0xe5,  0x6b,  
   0x2d,  0xc7,  0x85,  0x0b,  0x30,  0x1c,  0x92,  0x4e,  
   0x82,  0xd4,  0xca,  0x02,  0xed,  0xf7,  0x6f,  0xbe,  
   0xdc,  0xe0,  0xe3,  0x14,  0xb8,  0x05,  0x53,  0xf2,  
   0x9a,  0xf4,  0x56,  0x8b,  0x5a,  0x9e,  0x85,  0x93,  
   0xd1,  0xb4,  0x82,  0x56,  0xae,  0x4d,  0xbb,  0xa8,  
   0x4b,  0x57,  0x16,  0xbc,  0xfe,  0xf8,  0x58,  0x9e,  
   0xf8,  0x29,  0x8d,  0xb0,  0x7b,  0xcd,  0x78,  0xc9,  
   0x4f,  0xac,  0x8b,  0x67,  0x0c,  0xf1,  0x9c,  0xfb,  
   0xfc,  0x57,  0x9b,  0x57,  0x5c,  0x4f,  0x0d,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA TC_Class_2_pubKey = { 140, (uint8 *)TC_Class_2_pubKey_bytes };


/***********************
Cert File Name: TC_Class_3.cer
Subject Name       :
    Country        : DE
    State          : Hamburg
    Locality       : Hamburg
    Org            : TC TrustCenter for Security in Data Networks GmbH
    OrgUnit        : TC TrustCenter Class 3 CA
    Email addrs    : certificate@trustcenter.de
 ***********************/
static const uint8 TC_Class_3_subject_bytes[] = {
   0x30,  0x81,  0xbc,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x44,  0x45,  
   0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  0x55,  0x04,  
   0x08,  0x13,  0x07,  0x48,  0x41,  0x4d,  0x42,  0x55,  
   0x52,  0x47,  0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  
   0x55,  0x04,  0x07,  0x13,  0x07,  0x48,  0x41,  0x4d,  
   0x42,  0x55,  0x52,  0x47,  0x31,  0x3a,  0x30,  0x38,  
   0x06,  0x03,  0x55,  0x04,  0x0a,  0x13,  0x31,  0x54,  
   0x43,  0x20,  0x54,  0x52,  0x55,  0x53,  0x54,  0x43,  
   0x45,  0x4e,  0x54,  0x45,  0x52,  0x20,  0x46,  0x4f,  
   0x52,  0x20,  0x53,  0x45,  0x43,  0x55,  0x52,  0x49,  
   0x54,  0x59,  0x20,  0x49,  0x4e,  0x20,  0x44,  0x41,  
   0x54,  0x41,  0x20,  0x4e,  0x45,  0x54,  0x57,  0x4f,  
   0x52,  0x4b,  0x53,  0x20,  0x47,  0x4d,  0x42,  0x48,  
   0x31,  0x22,  0x30,  0x20,  0x06,  0x03,  0x55,  0x04,  
   0x0b,  0x13,  0x19,  0x54,  0x43,  0x20,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x43,  0x45,  0x4e,  0x54,  0x45,  
   0x52,  0x20,  0x43,  0x4c,  0x41,  0x53,  0x53,  0x20,  
   0x33,  0x20,  0x43,  0x41,  0x31,  0x29,  0x30,  0x27,  
   0x06,  0x09,  0x2a,  0x86,  0x48,  0x86,  0xf7,  0x0d,  
   0x01,  0x09,  0x01,  0x16,  0x1a,  0x63,  0x65,  0x72,  
   0x74,  0x69,  0x66,  0x69,  0x63,  0x61,  0x74,  0x65,  
   0x40,  0x74,  0x72,  0x75,  0x73,  0x74,  0x63,  0x65,  
   0x6e,  0x74,  0x65,  0x72,  0x2e,  0x64,  0x65
};
static const CSSM_DATA TC_Class_3_subject = { 191, (uint8 *)TC_Class_3_subject_bytes };
static const uint8 TC_Class_3_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xb6,  
   0xb4,  0xc1,  0x35,  0x05,  0x2e,  0x0d,  0x8d,  0xec,  
   0xa0,  0x40,  0x6a,  0x1c,  0x0e,  0x27,  0xa6,  0x50,  
   0x92,  0x6b,  0x50,  0x1b,  0x07,  0xde,  0x2e,  0xe7,  
   0x76,  0xcc,  0xe0,  0xda,  0xfc,  0x84,  0xa8,  0x5e,  
   0x8c,  0x63,  0x6a,  0x2b,  0x4d,  0xd9,  0x4e,  0x02,  
   0x76,  0x11,  0xc1,  0x0b,  0xf2,  0x8d,  0x79,  0xca,  
   0x00,  0xb6,  0xf1,  0xb0,  0x0e,  0xd7,  0xfb,  0xa4,  
   0x17,  0x3d,  0xaf,  0xab,  0x69,  0x7a,  0x96,  0x27,  
   0xbf,  0xaf,  0x33,  0xa1,  0x9a,  0x2a,  0x59,  0xaa,  
   0xc4,  0xb5,  0x37,  0x08,  0xf2,  0x12,  0xa5,  0x31,  
   0xb6,  0x43,  0xf5,  0x32,  0x96,  0x71,  0x28,  0x28,  
   0xab,  0x8d,  0x28,  0x86,  0xdf,  0xbb,  0xee,  0xe3,  
   0x0c,  0x7d,  0x30,  0xd6,  0xc3,  0x52,  0xab,  0x8f,  
   0x5d,  0x27,  0x9c,  0x6b,  0xc0,  0xa3,  0xe7,  0x05,  
   0x6b,  0x57,  0x49,  0x44,  0xb3,  0x6e,  0xea,  0x64,  
   0xcf,  0xd2,  0x8e,  0x7a,  0x50,  0x77,  0x77,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA TC_Class_3_pubKey = { 140, (uint8 *)TC_Class_3_pubKey_bytes };


/***********************
Cert File Name: TC_Class_4.cer
Subject Name       :
    Country        : DE
    State          : Hamburg
    Locality       : Hamburg
    Org            : TC TrustCenter for Security in Data Networks GmbH
    OrgUnit        : TC TrustCenter Class 4 CA
    Email addrs    : certificate@trustcenter.de
 ***********************/
static const uint8 TC_Class_4_subject_bytes[] = {
   0x30,  0x81,  0xbc,  0x31,  0x0b,  0x30,  0x09,  0x06,  
   0x03,  0x55,  0x04,  0x06,  0x13,  0x02,  0x44,  0x45,  
   0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  0x55,  0x04,  
   0x08,  0x13,  0x07,  0x48,  0x41,  0x4d,  0x42,  0x55,  
   0x52,  0x47,  0x31,  0x10,  0x30,  0x0e,  0x06,  0x03,  
   0x55,  0x04,  0x07,  0x13,  0x07,  0x48,  0x41,  0x4d,  
   0x42,  0x55,  0x52,  0x47,  0x31,  0x3a,  0x30,  0x38,  
   0x06,  0x03,  0x55,  0x04,  0x0a,  0x13,  0x31,  0x54,  
   0x43,  0x20,  0x54,  0x52,  0x55,  0x53,  0x54,  0x43,  
   0x45,  0x4e,  0x54,  0x45,  0x52,  0x20,  0x46,  0x4f,  
   0x52,  0x20,  0x53,  0x45,  0x43,  0x55,  0x52,  0x49,  
   0x54,  0x59,  0x20,  0x49,  0x4e,  0x20,  0x44,  0x41,  
   0x54,  0x41,  0x20,  0x4e,  0x45,  0x54,  0x57,  0x4f,  
   0x52,  0x4b,  0x53,  0x20,  0x47,  0x4d,  0x42,  0x48,  
   0x31,  0x22,  0x30,  0x20,  0x06,  0x03,  0x55,  0x04,  
   0x0b,  0x13,  0x19,  0x54,  0x43,  0x20,  0x54,  0x52,  
   0x55,  0x53,  0x54,  0x43,  0x45,  0x4e,  0x54,  0x45,  
   0x52,  0x20,  0x43,  0x4c,  0x41,  0x53,  0x53,  0x20,  
   0x34,  0x20,  0x43,  0x41,  0x31,  0x29,  0x30,  0x27,  
   0x06,  0x09,  0x2a,  0x86,  0x48,  0x86,  0xf7,  0x0d,  
   0x01,  0x09,  0x01,  0x16,  0x1a,  0x63,  0x65,  0x72,  
   0x74,  0x69,  0x66,  0x69,  0x63,  0x61,  0x74,  0x65,  
   0x40,  0x74,  0x72,  0x75,  0x73,  0x74,  0x63,  0x65,  
   0x6e,  0x74,  0x65,  0x72,  0x2e,  0x64,  0x65
};
static const CSSM_DATA TC_Class_4_subject = { 191, (uint8 *)TC_Class_4_subject_bytes };
static const uint8 TC_Class_4_pubKey_bytes[] = {
   0x30,  0x81,  0x89,  0x02,  0x81,  0x81,  0x00,  0xbf,  
   0x2f,  0x63,  0xd6,  0x36,  0x7b,  0xb2,  0x0d,  0xd3,  
   0x55,  0xf5,  0x64,  0x6c,  0xe6,  0x25,  0x5d,  0xc6,  
   0xb4,  0xc8,  0x14,  0xba,  0x25,  0x38,  0x83,  0xeb,  
   0x56,  0x62,  0xa5,  0x55,  0xa9,  0x65,  0xa3,  0xf4,  
   0x23,  0x99,  0xc2,  0x4b,  0xb9,  0xd0,  0xcd,  0x54,  
   0x67,  0xa6,  0xa3,  0xa0,  0xa3,  0xa9,  0x33,  0x2b,  
   0x76,  0xe4,  0xbd,  0xad,  0x77,  0xb2,  0xed,  0x5c,  
   0x12,  0x74,  0xc3,  0xc5,  0xb6,  0x0f,  0x52,  0x9a,  
   0x72,  0x93,  0x43,  0x90,  0x62,  0x66,  0x15,  0x0f,  
   0x45,  0xa5,  0xdd,  0xe0,  0xdd,  0xb8,  0x6f,  0x40,  
   0x6e,  0x57,  0xc1,  0x79,  0x72,  0xa3,  0x60,  0xaa,  
   0xba,  0x76,  0x1d,  0x12,  0x89,  0x53,  0x5a,  0xfc,  
   0x02,  0xbe,  0xe1,  0x09,  0x13,  0xc5,  0x4a,  0x2f,  
   0xdc,  0x3d,  0x8b,  0x19,  0xad,  0xd7,  0x8b,  0x24,  
   0x45,  0xfb,  0x4c,  0xf4,  0xcd,  0x5c,  0x35,  0x1d,  
   0x29,  0x4c,  0x51,  0xf3,  0xf2,  0x6c,  0x55,  0x02,  
   0x03,  0x01,  0x00,  0x01
};
static const CSSM_DATA TC_Class_4_pubKey = { 140, (uint8 *)TC_Class_4_pubKey_bytes };


/* end of static data generated by extractCertFields */

const tpRootCert sslRootCerts[] = 
{
    { &Class1_PCA_G2_v2_subject, &Class1_PCA_G2_v2_pubKey, 1024 },
    { &Class2_PCA_G2_v2_subject, &Class2_PCA_G2_v2_pubKey, 1024 },
    { &Class3_PCA_G2_v2_subject, &Class3_PCA_G2_v2_pubKey, 1024 },
    { &Class4_PCA_G2_v2_subject, &Class4_PCA_G2_v2_pubKey, 1024 },
    { &PCA1ss_v4_subject, &PCA1ss_v4_pubKey, 1024 },
    { &PCA2ss_v4_subject, &PCA2ss_v4_pubKey, 1024 },
    { &PCA3ss_v4_subject, &PCA3ss_v4_pubKey, 1024 },
    { &RSASecureServer_subject, &RSASecureServer_pubKey, 1000 },
    { &persbasi_subject, &persbasi_pubKey, 1024 },
    { &persfree_subject, &persfree_pubKey, 1024 },
    { &persprem_subject, &persprem_pubKey, 1024 },
    { &serverpremium_subject, &serverpremium_pubKey, 1024 },
    { &serverbasic_subject, &serverbasic_pubKey, 1024 },
    { &GTECyberTrustGlobalRoot_subject, &GTECyberTrustGlobalRoot_pubKey, 1024 },
    { &GTECyberTrustRoot_subject, &GTECyberTrustRoot_pubKey, 1024 },
    { &GTECyberTrustRoot2_subject, &GTECyberTrustRoot2_pubKey, 1024 },
    { &GTECyberTrustRoot3_subject, &GTECyberTrustRoot3_pubKey, 1024 },
    { &GTECyberTrustRoot4_subject, &GTECyberTrustRoot4_pubKey, 2048 },
    { &GTECyberTrustRoot5_subject, &GTECyberTrustRoot5_pubKey, 2048 },
    { &BTCTRoot_subject, &BTCTRoot_pubKey, 2048 },
    { &BTCTcodert_subject, &BTCTcodert_pubKey, 2048 },
    { &BTCTmort_subject, &BTCTmort_pubKey, 1024 },
    { &TC_Class_0_subject, &TC_Class_0_pubKey, 1024 },
    { &TC_Class_1_subject, &TC_Class_1_pubKey, 1024 },
    { &TC_Class_2_subject, &TC_Class_2_pubKey, 1024 },
    { &TC_Class_3_subject, &TC_Class_3_pubKey, 1024 },
    { &TC_Class_4_subject, &TC_Class_4_pubKey, 1024 },

};

const unsigned numSslRootCerts = sizeof(sslRootCerts) / sizeof(tpRootCert);

#endif	/* TP_ROOT_CERT_ENABLE */
