//   NOTE: this is a machine generated file--editing not recommended
//
// sm_x411mtsas.cpp - class member functions for ASN.1 module MTSAbstractService
//
//   This file was generated by snacc on Wed Jun 27 16:40:55 2001
//   UBC snacc written by Mike Sample
//   A couple of enhancements made by IBM European Networking Center


#include "asn-incl.h"
#include "sm_vdatypes.h"
#include "sm_x501ud.h"
#include "sm_x411ub.h"
#include "sm_x411mtsas.h"
#include "sm_x501if.h"
#include "sm_x520sa.h"
#include "sm_x509cmn.h"
#include "sm_x509af.h"
#include "sm_x509ce.h"
#include "pkcs1oids.h"
#include "pkcs9oids.h"
#include "sm_cms.h"
#include "sm_ess.h"
#include "pkcs7.h"
#include "pkcs8.h"
#include "appleoids.h"

//------------------------------------------------------------------------------
// value defs


//------------------------------------------------------------------------------
// class member definitions:

CountryName::CountryName()
{
  choiceId = x121_dcc_codeCid;
#if TCL
  x121_dcc_code = new NumericString;
#else
  x121_dcc_code = NULL; // incomplete initialization of mandatory element!
#endif // TCL
}

CountryName::CountryName (const CountryName &)
{
  Asn1Error << "use of incompletely defined CountryName::CountryName (const CountryName &)" << endl;
  abort();
}

CountryName::~CountryName()
{
  switch (choiceId)
  {
    case x121_dcc_codeCid:
      delete x121_dcc_code;
      break;
    case iso_3166_alpha2_codeCid:
      delete iso_3166_alpha2_code;
      break;
  } // end of switch
} // end of destructor

AsnType *CountryName::Clone() const
{
  return new CountryName;
}

AsnType *CountryName::Copy() const
{
  return new CountryName (*this);
}

#if SNACC_DEEP_COPY
CountryName &CountryName::operator = (const CountryName &that)
#else // SNACC_DEEP_COPY
CountryName &CountryName::operator = (const CountryName &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    switch (choiceId)
    {
      case x121_dcc_codeCid:
        delete x121_dcc_code;
        break;
      case iso_3166_alpha2_codeCid:
        delete iso_3166_alpha2_code;
        break;
    }
    switch (choiceId = that.choiceId)
    {
      case x121_dcc_codeCid:
        x121_dcc_code = new NumericString;
        *x121_dcc_code = *that.x121_dcc_code;
        break;
      case iso_3166_alpha2_codeCid:
        iso_3166_alpha2_code = new PrintableString;
        *iso_3166_alpha2_code = *that.iso_3166_alpha2_code;
        break;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined CountryName &CountryName::operator = (const CountryName &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
CountryName::BEncContent (BUF_TYPE b)
{
  AsnLen l;
  switch (choiceId)
  {
    case x121_dcc_codeCid:
      l = x121_dcc_code->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, NUMERICSTRING_TAG_CODE);
      break;

    case iso_3166_alpha2_codeCid:
      l = iso_3166_alpha2_code->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, PRINTABLESTRING_TAG_CODE);
      break;

  } // end switch
  return l;
} // CountryName::BEncContent


void CountryName::BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  switch (tag)
  {
    case MAKE_TAG_ID (UNIV, PRIM, NUMERICSTRING_TAG_CODE):
    case MAKE_TAG_ID (UNIV, CONS, NUMERICSTRING_TAG_CODE):
      choiceId = x121_dcc_codeCid;
      x121_dcc_code = new NumericString;
        x121_dcc_code->BDecContent (b, tag, elmtLen0, bytesDecoded, env);
      break;

    case MAKE_TAG_ID (UNIV, PRIM, PRINTABLESTRING_TAG_CODE):
    case MAKE_TAG_ID (UNIV, CONS, PRINTABLESTRING_TAG_CODE):
      choiceId = iso_3166_alpha2_codeCid;
      iso_3166_alpha2_code = new PrintableString;
        iso_3166_alpha2_code->BDecContent (b, tag, elmtLen0, bytesDecoded, env);
      break;

    default:
      Asn1Error << "ERROR - unexpected tag in CHOICE" << endl;
      longjmp (env, -100);
      break;
  } // end switch
} // CountryName::BDecContent


AsnLen CountryName::BEnc (BUF_TYPE b)
{
    AsnLen l;
    l = BEncContent (b);
    l += BEncConsLen (b, l);
    l += BEncTag1 (b, APPL, CONS, 1);
    return l;
}

void CountryName::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
    AsnLen elmtLen;
    AsnTag tag;
    AsnLen extraLen1;

    if (BDecTag (b, bytesDecoded, env) != MAKE_TAG_ID (APPL, CONS, 1))    {
        Asn1Error << "CountryName::BDec: ERROR - wrong tag" << endl;
        longjmp (env, -101);
    }
    extraLen1 = BDecLen (b, bytesDecoded, env);
    /*  CHOICEs are a special case - grab identifying tag */
    /*  this allows easier handling of nested CHOICEs */
    tag = BDecTag (b, bytesDecoded, env);
    elmtLen = BDecLen (b, bytesDecoded, env);
    BDecContent (b, tag, elmtLen, bytesDecoded, env);
    if (extraLen1 == INDEFINITE_LEN)
        BDecEoc (b, bytesDecoded, env);
}

int CountryName::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int CountryName::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void CountryName::Print (ostream &os) const
{
#ifndef NDEBUG
  switch (choiceId)
  {
    case x121_dcc_codeCid:
      os << "x121-dcc-code ";
      if (x121_dcc_code)
        os << *x121_dcc_code;
      else
        os << "-- void3 --\n";
      break;

    case iso_3166_alpha2_codeCid:
      os << "iso-3166-alpha2-code ";
      if (iso_3166_alpha2_code)
        os << *iso_3166_alpha2_code;
      else
        os << "-- void3 --\n";
      break;

  } // end of switch
#endif /* NDEBUG */
} // CountryName::Print

AdministrationDomainName::AdministrationDomainName()
{
  choiceId = numericCid;
#if TCL
  numeric = new NumericString;
#else
  numeric = NULL; // incomplete initialization of mandatory element!
#endif // TCL
}

AdministrationDomainName::AdministrationDomainName (const AdministrationDomainName &)
{
  Asn1Error << "use of incompletely defined AdministrationDomainName::AdministrationDomainName (const AdministrationDomainName &)" << endl;
  abort();
}

AdministrationDomainName::~AdministrationDomainName()
{
  switch (choiceId)
  {
    case numericCid:
      delete numeric;
      break;
    case printableCid:
      delete printable;
      break;
  } // end of switch
} // end of destructor

AsnType *AdministrationDomainName::Clone() const
{
  return new AdministrationDomainName;
}

AsnType *AdministrationDomainName::Copy() const
{
  return new AdministrationDomainName (*this);
}

#if SNACC_DEEP_COPY
AdministrationDomainName &AdministrationDomainName::operator = (const AdministrationDomainName &that)
#else // SNACC_DEEP_COPY
AdministrationDomainName &AdministrationDomainName::operator = (const AdministrationDomainName &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    switch (choiceId)
    {
      case numericCid:
        delete numeric;
        break;
      case printableCid:
        delete printable;
        break;
    }
    switch (choiceId = that.choiceId)
    {
      case numericCid:
        numeric = new NumericString;
        *numeric = *that.numeric;
        break;
      case printableCid:
        printable = new PrintableString;
        *printable = *that.printable;
        break;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined AdministrationDomainName &AdministrationDomainName::operator = (const AdministrationDomainName &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
AdministrationDomainName::BEncContent (BUF_TYPE b)
{
  AsnLen l;
  switch (choiceId)
  {
    case numericCid:
      l = numeric->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, NUMERICSTRING_TAG_CODE);
      break;

    case printableCid:
      l = printable->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, PRINTABLESTRING_TAG_CODE);
      break;

  } // end switch
  return l;
} // AdministrationDomainName::BEncContent


void AdministrationDomainName::BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  switch (tag)
  {
    case MAKE_TAG_ID (UNIV, PRIM, NUMERICSTRING_TAG_CODE):
    case MAKE_TAG_ID (UNIV, CONS, NUMERICSTRING_TAG_CODE):
      choiceId = numericCid;
      numeric = new NumericString;
        numeric->BDecContent (b, tag, elmtLen0, bytesDecoded, env);
      break;

    case MAKE_TAG_ID (UNIV, PRIM, PRINTABLESTRING_TAG_CODE):
    case MAKE_TAG_ID (UNIV, CONS, PRINTABLESTRING_TAG_CODE):
      choiceId = printableCid;
      printable = new PrintableString;
        printable->BDecContent (b, tag, elmtLen0, bytesDecoded, env);
      break;

    default:
      Asn1Error << "ERROR - unexpected tag in CHOICE" << endl;
      longjmp (env, -102);
      break;
  } // end switch
} // AdministrationDomainName::BDecContent


AsnLen AdministrationDomainName::BEnc (BUF_TYPE b)
{
    AsnLen l;
    l = BEncContent (b);
    l += BEncConsLen (b, l);
    l += BEncTag1 (b, APPL, CONS, 2);
    return l;
}

void AdministrationDomainName::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
    AsnLen elmtLen;
    AsnTag tag;
    AsnLen extraLen1;

    if (BDecTag (b, bytesDecoded, env) != MAKE_TAG_ID (APPL, CONS, 2))    {
        Asn1Error << "AdministrationDomainName::BDec: ERROR - wrong tag" << endl;
        longjmp (env, -103);
    }
    extraLen1 = BDecLen (b, bytesDecoded, env);
    /*  CHOICEs are a special case - grab identifying tag */
    /*  this allows easier handling of nested CHOICEs */
    tag = BDecTag (b, bytesDecoded, env);
    elmtLen = BDecLen (b, bytesDecoded, env);
    BDecContent (b, tag, elmtLen, bytesDecoded, env);
    if (extraLen1 == INDEFINITE_LEN)
        BDecEoc (b, bytesDecoded, env);
}

int AdministrationDomainName::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int AdministrationDomainName::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void AdministrationDomainName::Print (ostream &os) const
{
#ifndef NDEBUG
  switch (choiceId)
  {
    case numericCid:
      os << "numeric ";
      if (numeric)
        os << *numeric;
      else
        os << "-- void3 --\n";
      break;

    case printableCid:
      os << "printable ";
      if (printable)
        os << *printable;
      else
        os << "-- void3 --\n";
      break;

  } // end of switch
#endif /* NDEBUG */
} // AdministrationDomainName::Print

PrivateDomainName::PrivateDomainName()
{
  choiceId = numericCid;
#if TCL
  numeric = new NumericString;
#else
  numeric = NULL; // incomplete initialization of mandatory element!
#endif // TCL
}

PrivateDomainName::PrivateDomainName (const PrivateDomainName &)
{
  Asn1Error << "use of incompletely defined PrivateDomainName::PrivateDomainName (const PrivateDomainName &)" << endl;
  abort();
}

PrivateDomainName::~PrivateDomainName()
{
  switch (choiceId)
  {
    case numericCid:
      delete numeric;
      break;
    case printableCid:
      delete printable;
      break;
  } // end of switch
} // end of destructor

AsnType *PrivateDomainName::Clone() const
{
  return new PrivateDomainName;
}

AsnType *PrivateDomainName::Copy() const
{
  return new PrivateDomainName (*this);
}

#if SNACC_DEEP_COPY
PrivateDomainName &PrivateDomainName::operator = (const PrivateDomainName &that)
#else // SNACC_DEEP_COPY
PrivateDomainName &PrivateDomainName::operator = (const PrivateDomainName &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    switch (choiceId)
    {
      case numericCid:
        delete numeric;
        break;
      case printableCid:
        delete printable;
        break;
    }
    switch (choiceId = that.choiceId)
    {
      case numericCid:
        numeric = new NumericString;
        *numeric = *that.numeric;
        break;
      case printableCid:
        printable = new PrintableString;
        *printable = *that.printable;
        break;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined PrivateDomainName &PrivateDomainName::operator = (const PrivateDomainName &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
PrivateDomainName::BEncContent (BUF_TYPE b)
{
  AsnLen l;
  switch (choiceId)
  {
    case numericCid:
      l = numeric->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, NUMERICSTRING_TAG_CODE);
      break;

    case printableCid:
      l = printable->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, PRINTABLESTRING_TAG_CODE);
      break;

  } // end switch
  return l;
} // PrivateDomainName::BEncContent


void PrivateDomainName::BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  switch (tag)
  {
    case MAKE_TAG_ID (UNIV, PRIM, NUMERICSTRING_TAG_CODE):
    case MAKE_TAG_ID (UNIV, CONS, NUMERICSTRING_TAG_CODE):
      choiceId = numericCid;
      numeric = new NumericString;
        numeric->BDecContent (b, tag, elmtLen0, bytesDecoded, env);
      break;

    case MAKE_TAG_ID (UNIV, PRIM, PRINTABLESTRING_TAG_CODE):
    case MAKE_TAG_ID (UNIV, CONS, PRINTABLESTRING_TAG_CODE):
      choiceId = printableCid;
      printable = new PrintableString;
        printable->BDecContent (b, tag, elmtLen0, bytesDecoded, env);
      break;

    default:
      Asn1Error << "ERROR - unexpected tag in CHOICE" << endl;
      longjmp (env, -104);
      break;
  } // end switch
} // PrivateDomainName::BDecContent


AsnLen PrivateDomainName::BEnc (BUF_TYPE b)
{
    AsnLen l;
    l = BEncContent (b);
    return l;
}

void PrivateDomainName::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
    AsnLen elmtLen;
    AsnTag tag;

    /*  CHOICEs are a special case - grab identifying tag */
    /*  this allows easier handling of nested CHOICEs */
    tag = BDecTag (b, bytesDecoded, env);
    elmtLen = BDecLen (b, bytesDecoded, env);
    BDecContent (b, tag, elmtLen, bytesDecoded, env);
}

int PrivateDomainName::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int PrivateDomainName::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void PrivateDomainName::Print (ostream &os) const
{
#ifndef NDEBUG
  switch (choiceId)
  {
    case numericCid:
      os << "numeric ";
      if (numeric)
        os << *numeric;
      else
        os << "-- void3 --\n";
      break;

    case printableCid:
      os << "printable ";
      if (printable)
        os << *printable;
      else
        os << "-- void3 --\n";
      break;

  } // end of switch
#endif /* NDEBUG */
} // PrivateDomainName::Print

PersonalName::PersonalName()
{
  given_name = NULL;
  initials = NULL;
  generation_qualifier = NULL;
}

PersonalName::PersonalName (const PersonalName &)
{
  Asn1Error << "use of incompletely defined PersonalName::PersonalName (const PersonalName &)" << endl;
  abort();
}

PersonalName::~PersonalName()
{
  delete given_name;
  delete initials;
  delete generation_qualifier;
}

AsnType *PersonalName::Clone() const
{
  return new PersonalName;
}

AsnType *PersonalName::Copy() const
{
  return new PersonalName (*this);
}

#if SNACC_DEEP_COPY
PersonalName &PersonalName::operator = (const PersonalName &that)
#else // SNACC_DEEP_COPY
PersonalName &PersonalName::operator = (const PersonalName &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    surname = that.surname;
    if (that.given_name)
    {
      if (!given_name)
        given_name = new PrintableString;
      *given_name = *that.given_name;
    }
    else
    {
      delete given_name;
      given_name = NULL;
    }
    if (that.initials)
    {
      if (!initials)
        initials = new PrintableString;
      *initials = *that.initials;
    }
    else
    {
      delete initials;
      initials = NULL;
    }
    if (that.generation_qualifier)
    {
      if (!generation_qualifier)
        generation_qualifier = new PrintableString;
      *generation_qualifier = *that.generation_qualifier;
    }
    else
    {
      delete generation_qualifier;
      generation_qualifier = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined PersonalName &PersonalName::operator = (const PersonalName &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen PersonalName::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

      AsnBuf outputBuf;
       int iii=0, tmpCount=0;
      char *lpszBuf = (char *)calloc(1, 1024);
      outputBuf.Init(lpszBuf, 1024);
      outputBuf.ResetInWriteRvsMode();
      CSM_Buffer *tmpEnc[4];
  if (NOT_NULL (generation_qualifier))
  {
    l = generation_qualifier->BEncContent (outputBuf);
    l += BEncDefLen (outputBuf, l);

    l += BEncTag1 (outputBuf, CNTX, PRIM, 3);
    totalLen += l;
        SNACC_BUFRESET_READ(&outputBuf);
        SM_ReadFromAsnBuf(tmpEnc[iii], outputBuf,outputBuf.DataLen(),NULL);
        SNACC_BUFRESET_WRITE(&outputBuf);
        iii++;
  }

  if (NOT_NULL (initials))
  {
    l = initials->BEncContent (outputBuf);
    l += BEncDefLen (outputBuf, l);

    l += BEncTag1 (outputBuf, CNTX, PRIM, 2);
    totalLen += l;
        SNACC_BUFRESET_READ(&outputBuf);
        SM_ReadFromAsnBuf(tmpEnc[iii], outputBuf,outputBuf.DataLen(),NULL);
        SNACC_BUFRESET_WRITE(&outputBuf);
        iii++;
  }

  if (NOT_NULL (given_name))
  {
    l = given_name->BEncContent (outputBuf);
    l += BEncDefLen (outputBuf, l);

    l += BEncTag1 (outputBuf, CNTX, PRIM, 1);
    totalLen += l;
        SNACC_BUFRESET_READ(&outputBuf);
        SM_ReadFromAsnBuf(tmpEnc[iii], outputBuf,outputBuf.DataLen(),NULL);
        SNACC_BUFRESET_WRITE(&outputBuf);
        iii++;
  }

    l = surname.BEncContent (outputBuf);
    l += BEncDefLen (outputBuf, l);

    l += BEncTag1 (outputBuf, CNTX, PRIM, 0);
    totalLen += l;
        SNACC_BUFRESET_READ(&outputBuf);
        SM_ReadFromAsnBuf(tmpEnc[iii], outputBuf,outputBuf.DataLen(),NULL);
        SNACC_BUFRESET_WRITE(&outputBuf);
        iii++;

      vdasnacc_sortSet(tmpEnc, iii);
      tmpCount = iii;  /** REMEMBER how many we have**/
      for (iii=0; iii < tmpCount; iii++)
         SM_WriteToAsnBuf(tmpEnc[iii], b);
      for (iii=0; iii < tmpCount; iii++) delete tmpEnc[iii];
      free(lpszBuf);
  return totalLen;
} // PersonalName::BEncContent


void PersonalName::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen setBytesDecoded = 0;
  unsigned int mandatoryElmtsDecoded = 0;
  AsnLen elmtLen1;

  for (; (setBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN); )
  {
    tag1 = BDecTag (b, setBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, setBytesDecoded, env)
      break; /* exit for loop */
    }
    elmtLen1 = BDecLen (b, setBytesDecoded, env);
    switch (tag1)
    {
      case MAKE_TAG_ID (CNTX, PRIM, 0):
      case MAKE_TAG_ID (CNTX, CONS, 0):
        surname.BDecContent (b, tag1, elmtLen1, setBytesDecoded, env);
          mandatoryElmtsDecoded++;
          break;

      case MAKE_TAG_ID (CNTX, PRIM, 1):
      case MAKE_TAG_ID (CNTX, CONS, 1):
        given_name = new PrintableString;
        given_name->BDecContent (b, tag1, elmtLen1, setBytesDecoded, env);
          break;

      case MAKE_TAG_ID (CNTX, PRIM, 2):
      case MAKE_TAG_ID (CNTX, CONS, 2):
        initials = new PrintableString;
        initials->BDecContent (b, tag1, elmtLen1, setBytesDecoded, env);
          break;

      case MAKE_TAG_ID (CNTX, PRIM, 3):
      case MAKE_TAG_ID (CNTX, CONS, 3):
        generation_qualifier = new PrintableString;
        generation_qualifier->BDecContent (b, tag1, elmtLen1, setBytesDecoded, env);
          break;

       default:
         Asn1Error << "Unexpected Tag on SET elmt." << endl;
         longjmp (env, -105);
    } // end switch
  } // end for loop
  bytesDecoded += setBytesDecoded;
  if (mandatoryElmtsDecoded != 1)
  {
     Asn1Error << "ERROR - non-optional SET element missing." << endl;
     longjmp (env, -106);
  }
} // PersonalName::BDecContent

AsnLen
PersonalName::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SET_TAG_CODE);
  return l;
}

void PersonalName::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SET_TAG_CODE))
  {
    Asn1Error << "PersonalName::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -107);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int PersonalName::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int PersonalName::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void PersonalName::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SET --" << endl;
  indentG += stdIndentG;

  {
    Indent (os, indentG);
    os << "surname ";
    os << surname;
  }

  if (NOT_NULL (given_name))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "given-name ";
    os << *given_name;
  }
  else
    os << "-- void2 --\n";

  if (NOT_NULL (initials))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "initials ";
    os << *initials;
  }
  else
    os << "-- void2 --\n";

  if (NOT_NULL (generation_qualifier))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "generation-qualifier ";
    os << *generation_qualifier;
  }
  else
    os << "-- void2 --\n";

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // PersonalName - operator <<


DomainDefinedAttribute::DomainDefinedAttribute()
{
}

DomainDefinedAttribute::DomainDefinedAttribute (const DomainDefinedAttribute &)
{
  Asn1Error << "use of incompletely defined DomainDefinedAttribute::DomainDefinedAttribute (const DomainDefinedAttribute &)" << endl;
  abort();
}

DomainDefinedAttribute::~DomainDefinedAttribute()
{
}

AsnType *DomainDefinedAttribute::Clone() const
{
  return new DomainDefinedAttribute;
}

AsnType *DomainDefinedAttribute::Copy() const
{
  return new DomainDefinedAttribute (*this);
}

#if SNACC_DEEP_COPY
DomainDefinedAttribute &DomainDefinedAttribute::operator = (const DomainDefinedAttribute &that)
#else // SNACC_DEEP_COPY
DomainDefinedAttribute &DomainDefinedAttribute::operator = (const DomainDefinedAttribute &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    type = that.type;
    value = that.value;
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined DomainDefinedAttribute &DomainDefinedAttribute::operator = (const DomainDefinedAttribute &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
DomainDefinedAttribute::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

    l = value.BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, PRINTABLESTRING_TAG_CODE);
    totalLen += l;

    l = type.BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, PRINTABLESTRING_TAG_CODE);
    totalLen += l;

  return totalLen;
} // DomainDefinedAttribute::BEncContent


void DomainDefinedAttribute::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  tag1 = BDecTag (b, seqBytesDecoded, env);

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, PRINTABLESTRING_TAG_CODE))
    || (tag1 == MAKE_TAG_ID (UNIV, CONS, PRINTABLESTRING_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    type.BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    tag1 = BDecTag (b, seqBytesDecoded, env);
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -108);
  }

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, PRINTABLESTRING_TAG_CODE))
    || (tag1 == MAKE_TAG_ID (UNIV, CONS, PRINTABLESTRING_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    value.BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -109);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -110);
  }
  else
    return;
} // DomainDefinedAttribute::BDecContent

AsnLen DomainDefinedAttribute::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void DomainDefinedAttribute::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "DomainDefinedAttribute::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -111);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int DomainDefinedAttribute::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int DomainDefinedAttribute::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void DomainDefinedAttribute::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  {
    Indent (os, indentG);
    os << "type ";
    os << type;
    os << "," << endl;
  }

  {
    Indent (os, indentG);
    os << "value ";
    os << value;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // DomainDefinedAttribute::Print


ExtensionAttribute::ExtensionAttribute()
{
}

ExtensionAttribute::ExtensionAttribute (const ExtensionAttribute &)
{
  Asn1Error << "use of incompletely defined ExtensionAttribute::ExtensionAttribute (const ExtensionAttribute &)" << endl;
  abort();
}

ExtensionAttribute::~ExtensionAttribute()
{
}

AsnType *ExtensionAttribute::Clone() const
{
  return new ExtensionAttribute;
}

AsnType *ExtensionAttribute::Copy() const
{
  return new ExtensionAttribute (*this);
}

#if SNACC_DEEP_COPY
ExtensionAttribute &ExtensionAttribute::operator = (const ExtensionAttribute &that)
#else // SNACC_DEEP_COPY
ExtensionAttribute &ExtensionAttribute::operator = (const ExtensionAttribute &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    extension_attribute_type = that.extension_attribute_type;
    extension_attribute_value = that.extension_attribute_value;
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined ExtensionAttribute &ExtensionAttribute::operator = (const ExtensionAttribute &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
ExtensionAttribute::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

      BEncEocIfNec (b);
        ENC_LOAD_ANYBUF(&extension_attribute_value, b, l);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 1);
    totalLen += l;

    l = extension_attribute_type.BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, CNTX, PRIM, 0);
    totalLen += l;

  return totalLen;
} // ExtensionAttribute::BEncContent


void ExtensionAttribute::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  tag1 = BDecTag (b, seqBytesDecoded, env);

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    extension_attribute_type.BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    tag1 = BDecTag (b, seqBytesDecoded, env);
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -112);
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
        DEC_LOAD_ANYBUF(&extension_attribute_value, b, seqBytesDecoded, env);
    if (elmtLen1 == INDEFINITE_LEN)
      BDecEoc (b, seqBytesDecoded, env);

  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -113);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -114);
  }
  else
    return;
} // ExtensionAttribute::BDecContent

AsnLen ExtensionAttribute::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void ExtensionAttribute::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "ExtensionAttribute::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -115);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int ExtensionAttribute::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int ExtensionAttribute::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void ExtensionAttribute::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  {
    Indent (os, indentG);
    os << "extension-attribute-type ";
    os << extension_attribute_type;
    os << "," << endl;
  }

  {
    Indent (os, indentG);
    os << "extension-attribute-value ";
    os << extension_attribute_value;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // ExtensionAttribute::Print


TeletexDomainDefinedAttribute::TeletexDomainDefinedAttribute()
{
}

TeletexDomainDefinedAttribute::TeletexDomainDefinedAttribute (const TeletexDomainDefinedAttribute &)
{
  Asn1Error << "use of incompletely defined TeletexDomainDefinedAttribute::TeletexDomainDefinedAttribute (const TeletexDomainDefinedAttribute &)" << endl;
  abort();
}

TeletexDomainDefinedAttribute::~TeletexDomainDefinedAttribute()
{
}

AsnType *TeletexDomainDefinedAttribute::Clone() const
{
  return new TeletexDomainDefinedAttribute;
}

AsnType *TeletexDomainDefinedAttribute::Copy() const
{
  return new TeletexDomainDefinedAttribute (*this);
}

#if SNACC_DEEP_COPY
TeletexDomainDefinedAttribute &TeletexDomainDefinedAttribute::operator = (const TeletexDomainDefinedAttribute &that)
#else // SNACC_DEEP_COPY
TeletexDomainDefinedAttribute &TeletexDomainDefinedAttribute::operator = (const TeletexDomainDefinedAttribute &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    type = that.type;
    value = that.value;
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined TeletexDomainDefinedAttribute &TeletexDomainDefinedAttribute::operator = (const TeletexDomainDefinedAttribute &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
TeletexDomainDefinedAttribute::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

    l = value.BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, TELETEXSTRING_TAG_CODE);
    totalLen += l;

    l = type.BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, TELETEXSTRING_TAG_CODE);
    totalLen += l;

  return totalLen;
} // TeletexDomainDefinedAttribute::BEncContent


void TeletexDomainDefinedAttribute::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  tag1 = BDecTag (b, seqBytesDecoded, env);

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, TELETEXSTRING_TAG_CODE))
    || (tag1 == MAKE_TAG_ID (UNIV, CONS, TELETEXSTRING_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    type.BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    tag1 = BDecTag (b, seqBytesDecoded, env);
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -116);
  }

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, TELETEXSTRING_TAG_CODE))
    || (tag1 == MAKE_TAG_ID (UNIV, CONS, TELETEXSTRING_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    value.BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -117);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -118);
  }
  else
    return;
} // TeletexDomainDefinedAttribute::BDecContent

AsnLen TeletexDomainDefinedAttribute::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void TeletexDomainDefinedAttribute::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "TeletexDomainDefinedAttribute::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -119);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int TeletexDomainDefinedAttribute::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int TeletexDomainDefinedAttribute::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void TeletexDomainDefinedAttribute::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  {
    Indent (os, indentG);
    os << "type ";
    os << type;
    os << "," << endl;
  }

  {
    Indent (os, indentG);
    os << "value ";
    os << value;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // TeletexDomainDefinedAttribute::Print


AsnType *OrganizationUnitNames::Clone() const
{
  return new OrganizationUnitNames;
}

AsnType *OrganizationUnitNames::Copy() const
{
  return new OrganizationUnitNames (*this);
}

AsnLen OrganizationUnitNames::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void OrganizationUnitNames::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "OrganizationUnitNames::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -120);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

OrganizationUnitNames::OrganizationUnitNames (const OrganizationUnitNames &)
{
  Asn1Error << "use of incompletely defined OrganizationUnitNames::OrganizationUnitNames (const OrganizationUnitNames &)" << endl;
  abort();
}

OrganizationUnitNames::~OrganizationUnitNames()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
OrganizationUnitNames &OrganizationUnitNames::operator = (const OrganizationUnitNames &that)
#else // SNACC_DEEP_COPY
OrganizationUnitNames &OrganizationUnitNames::operator = (const OrganizationUnitNames &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined OrganizationUnitNames &OrganizationUnitNames::operator = (const OrganizationUnitNames &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void OrganizationUnitNames::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  OrganizationUnitNames::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // OrganizationUnitNames::SetCurrElmt


unsigned long int  OrganizationUnitNames::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // OrganizationUnitNames::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
OrganizationUnitName *OrganizationUnitNames::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new OrganizationUnitName;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // OrganizationUnitNames::Append


// alloc new list elmt, put at begining of list
//  and return the component type
OrganizationUnitName  *OrganizationUnitNames::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new OrganizationUnitName;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // OrganizationUnitNames::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
OrganizationUnitName  *OrganizationUnitNames::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new OrganizationUnitName;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // OrganizationUnitNames::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
OrganizationUnitName *OrganizationUnitNames::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new OrganizationUnitName;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // OrganizationUnitNames::InsertAfter


OrganizationUnitNames  &OrganizationUnitNames::AppendCopy (OrganizationUnitName &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new OrganizationUnitName;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


OrganizationUnitNames  &OrganizationUnitNames::PrependCopy (OrganizationUnitName &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new OrganizationUnitName;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // OrganizationUnitNames::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
OrganizationUnitNames &OrganizationUnitNames::InsertBeforeAndCopy (OrganizationUnitName &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new OrganizationUnitName;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // OrganizationUnitNames::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
OrganizationUnitNames  &OrganizationUnitNames::InsertAfterAndCopy (OrganizationUnitName &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new OrganizationUnitName;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // OrganizationUnitNames::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void OrganizationUnitNames::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen OrganizationUnitNames::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncDefLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, PRIM, PRINTABLESTRING_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // OrganizationUnitNames::BEncContent


void  OrganizationUnitNames::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    OrganizationUnitName *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, PRIM, PRINTABLESTRING_TAG_CODE))
         && (tag1 != MAKE_TAG_ID (UNIV, CONS, PRINTABLESTRING_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -121);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // OrganizationUnitNames::BDecContent


AsnType *DomainDefinedAttributes::Clone() const
{
  return new DomainDefinedAttributes;
}

AsnType *DomainDefinedAttributes::Copy() const
{
  return new DomainDefinedAttributes (*this);
}

AsnLen DomainDefinedAttributes::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void DomainDefinedAttributes::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "DomainDefinedAttributes::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -122);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

DomainDefinedAttributes::DomainDefinedAttributes (const DomainDefinedAttributes &)
{
  Asn1Error << "use of incompletely defined DomainDefinedAttributes::DomainDefinedAttributes (const DomainDefinedAttributes &)" << endl;
  abort();
}

DomainDefinedAttributes::~DomainDefinedAttributes()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
DomainDefinedAttributes &DomainDefinedAttributes::operator = (const DomainDefinedAttributes &that)
#else // SNACC_DEEP_COPY
DomainDefinedAttributes &DomainDefinedAttributes::operator = (const DomainDefinedAttributes &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined DomainDefinedAttributes &DomainDefinedAttributes::operator = (const DomainDefinedAttributes &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void DomainDefinedAttributes::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  DomainDefinedAttributes::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // DomainDefinedAttributes::SetCurrElmt


unsigned long int  DomainDefinedAttributes::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // DomainDefinedAttributes::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
DomainDefinedAttribute *DomainDefinedAttributes::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new DomainDefinedAttribute;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // DomainDefinedAttributes::Append


// alloc new list elmt, put at begining of list
//  and return the component type
DomainDefinedAttribute  *DomainDefinedAttributes::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DomainDefinedAttribute;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // DomainDefinedAttributes::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
DomainDefinedAttribute  *DomainDefinedAttributes::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DomainDefinedAttribute;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // DomainDefinedAttributes::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
DomainDefinedAttribute *DomainDefinedAttributes::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DomainDefinedAttribute;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // DomainDefinedAttributes::InsertAfter


DomainDefinedAttributes  &DomainDefinedAttributes::AppendCopy (DomainDefinedAttribute &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DomainDefinedAttribute;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


DomainDefinedAttributes  &DomainDefinedAttributes::PrependCopy (DomainDefinedAttribute &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DomainDefinedAttribute;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // DomainDefinedAttributes::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
DomainDefinedAttributes &DomainDefinedAttributes::InsertBeforeAndCopy (DomainDefinedAttribute &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new DomainDefinedAttribute;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // DomainDefinedAttributes::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
DomainDefinedAttributes  &DomainDefinedAttributes::InsertAfterAndCopy (DomainDefinedAttribute &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new DomainDefinedAttribute;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // DomainDefinedAttributes::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void DomainDefinedAttributes::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen DomainDefinedAttributes::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
      BEncEocIfNec (b);
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncConsLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // DomainDefinedAttributes::BEncContent


void  DomainDefinedAttributes::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    DomainDefinedAttribute *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -123);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // DomainDefinedAttributes::BDecContent


AsnType *ExtensionAttributes::Clone() const
{
  return new ExtensionAttributes;
}

AsnType *ExtensionAttributes::Copy() const
{
  return new ExtensionAttributes (*this);
}

AsnLen ExtensionAttributes::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SET_TAG_CODE);
  return l;
}

void ExtensionAttributes::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SET_TAG_CODE))
  {
    Asn1Error << "ExtensionAttributes::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -124);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

ExtensionAttributes::ExtensionAttributes (const ExtensionAttributes &)
{
  Asn1Error << "use of incompletely defined ExtensionAttributes::ExtensionAttributes (const ExtensionAttributes &)" << endl;
  abort();
}

ExtensionAttributes::~ExtensionAttributes()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
ExtensionAttributes &ExtensionAttributes::operator = (const ExtensionAttributes &that)
#else // SNACC_DEEP_COPY
ExtensionAttributes &ExtensionAttributes::operator = (const ExtensionAttributes &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined ExtensionAttributes &ExtensionAttributes::operator = (const ExtensionAttributes &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void ExtensionAttributes::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  ExtensionAttributes::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // ExtensionAttributes::SetCurrElmt


unsigned long int  ExtensionAttributes::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // ExtensionAttributes::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
ExtensionAttribute *ExtensionAttributes::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new ExtensionAttribute;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // ExtensionAttributes::Append


// alloc new list elmt, put at begining of list
//  and return the component type
ExtensionAttribute  *ExtensionAttributes::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new ExtensionAttribute;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // ExtensionAttributes::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
ExtensionAttribute  *ExtensionAttributes::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new ExtensionAttribute;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // ExtensionAttributes::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
ExtensionAttribute *ExtensionAttributes::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new ExtensionAttribute;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // ExtensionAttributes::InsertAfter


ExtensionAttributes  &ExtensionAttributes::AppendCopy (ExtensionAttribute &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new ExtensionAttribute;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


ExtensionAttributes  &ExtensionAttributes::PrependCopy (ExtensionAttribute &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new ExtensionAttribute;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // ExtensionAttributes::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
ExtensionAttributes &ExtensionAttributes::InsertBeforeAndCopy (ExtensionAttribute &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new ExtensionAttribute;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // ExtensionAttributes::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
ExtensionAttributes  &ExtensionAttributes::InsertAfterAndCopy (ExtensionAttribute &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new ExtensionAttribute;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // ExtensionAttributes::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void ExtensionAttributes::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen ExtensionAttributes::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    {
      int iii,icount;
      CSM_Buffer **tmpEnc=NULL;
      for (currElmt = last,icount=0; currElmt != NULL; currElmt = currElmt->prev, icount++);
      tmpEnc = (CSM_Buffer **) calloc(sizeof(CSM_Buffer *), icount);
      for (currElmt = last, iii=0; currElmt != NULL; currElmt = currElmt->prev,iii++,elmtLen=0)
      {
      BEncEocIfNec (b);
        ENCODE_BUF1(currElmt->elmt->BEncContent, elmtLen);
    elmtLen += BEncConsLen (outputBuf, elmtLen);

    elmtLen += BEncTag1 (outputBuf, UNIV, CONS, SEQ_TAG_CODE);
        ENCODE_BUF2(tmpEnc[iii]);
      }
      vdasnacc_sortSetOf(tmpEnc, icount);
      for (iii=0,elmtLen=0; iii < icount; elmtLen+=tmpEnc[iii++]->Length())
            SM_WriteToAsnBuf(tmpEnc[iii], b);
      for (iii=0; iii < icount; iii++) delete tmpEnc[iii];
       free(tmpEnc);
    }
        totalLen += elmtLen;
    return totalLen;
} // ExtensionAttributes::BEncContent


void  ExtensionAttributes::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    ExtensionAttribute *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -125);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // ExtensionAttributes::BDecContent


StandardAttributes::StandardAttributes()
{
  country_name = NULL;
  administration_domain_name = NULL;
  network_address = NULL;
  terminal_identifier = NULL;
  private_domain_name = NULL;
  organization_name = NULL;
  numeric_user_identifier = NULL;
  personal_name = NULL;
  organizational_unit_names = NULL;
}

StandardAttributes::StandardAttributes (const StandardAttributes &)
{
  Asn1Error << "use of incompletely defined StandardAttributes::StandardAttributes (const StandardAttributes &)" << endl;
  abort();
}

StandardAttributes::~StandardAttributes()
{
  delete country_name;
  delete administration_domain_name;
  delete network_address;
  delete terminal_identifier;
  delete private_domain_name;
  delete organization_name;
  delete numeric_user_identifier;
  delete personal_name;
  delete organizational_unit_names;
}

AsnType *StandardAttributes::Clone() const
{
  return new StandardAttributes;
}

AsnType *StandardAttributes::Copy() const
{
  return new StandardAttributes (*this);
}

#if SNACC_DEEP_COPY
StandardAttributes &StandardAttributes::operator = (const StandardAttributes &that)
#else // SNACC_DEEP_COPY
StandardAttributes &StandardAttributes::operator = (const StandardAttributes &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.country_name)
    {
      if (!country_name)
        country_name = new CountryName;
      *country_name = *that.country_name;
    }
    else
    {
      delete country_name;
      country_name = NULL;
    }
    if (that.administration_domain_name)
    {
      if (!administration_domain_name)
        administration_domain_name = new AdministrationDomainName;
      *administration_domain_name = *that.administration_domain_name;
    }
    else
    {
      delete administration_domain_name;
      administration_domain_name = NULL;
    }
    if (that.network_address)
    {
      if (!network_address)
        network_address = new NetworkAddress;
      *network_address = *that.network_address;
    }
    else
    {
      delete network_address;
      network_address = NULL;
    }
    if (that.terminal_identifier)
    {
      if (!terminal_identifier)
        terminal_identifier = new TerminalIdentifier;
      *terminal_identifier = *that.terminal_identifier;
    }
    else
    {
      delete terminal_identifier;
      terminal_identifier = NULL;
    }
    if (that.private_domain_name)
    {
      if (!private_domain_name)
        private_domain_name = new PrivateDomainName;
      *private_domain_name = *that.private_domain_name;
    }
    else
    {
      delete private_domain_name;
      private_domain_name = NULL;
    }
    if (that.organization_name)
    {
      if (!organization_name)
        organization_name = new OrganizationName;
      *organization_name = *that.organization_name;
    }
    else
    {
      delete organization_name;
      organization_name = NULL;
    }
    if (that.numeric_user_identifier)
    {
      if (!numeric_user_identifier)
        numeric_user_identifier = new NumericUserIdentifier;
      *numeric_user_identifier = *that.numeric_user_identifier;
    }
    else
    {
      delete numeric_user_identifier;
      numeric_user_identifier = NULL;
    }
    if (that.personal_name)
    {
      if (!personal_name)
        personal_name = new PersonalName;
      *personal_name = *that.personal_name;
    }
    else
    {
      delete personal_name;
      personal_name = NULL;
    }
    if (that.organizational_unit_names)
    {
      if (!organizational_unit_names)
        organizational_unit_names = new OrganizationUnitNames;
      *organizational_unit_names = *that.organizational_unit_names;
    }
    else
    {
      delete organizational_unit_names;
      organizational_unit_names = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined StandardAttributes &StandardAttributes::operator = (const StandardAttributes &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
StandardAttributes::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (organizational_unit_names))
  {
      BEncEocIfNec (b);
    l = organizational_unit_names->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 6);
    totalLen += l;
  }

  if (NOT_NULL (personal_name))
  {
      BEncEocIfNec (b);
    l = personal_name->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 5);
    totalLen += l;
  }

  if (NOT_NULL (numeric_user_identifier))
  {
    l = numeric_user_identifier->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 4);
    totalLen += l;
  }

  if (NOT_NULL (organization_name))
  {
    l = organization_name->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 3);
    totalLen += l;
  }

  if (NOT_NULL (private_domain_name))
  {
      BEncEocIfNec (b);
    l = private_domain_name->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 2);
    totalLen += l;
  }

  if (NOT_NULL (terminal_identifier))
  {
    l = terminal_identifier->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 1);
    totalLen += l;
  }

  if (NOT_NULL (network_address))
  {
    l = network_address->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 0);
    totalLen += l;
  }

  if (NOT_NULL (administration_domain_name))
  {
      BEncEocIfNec (b);
    l = administration_domain_name->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, APPL, CONS, 2);
    totalLen += l;
  }

  if (NOT_NULL (country_name))
  {
      BEncEocIfNec (b);
    l = country_name->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, APPL, CONS, 1);
    totalLen += l;
  }

  return totalLen;
} // StandardAttributes::BEncContent


void StandardAttributes::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  AsnLen elmtLen2;
  if (elmtLen0 == 0)
    return;
  else
  {
    tag1 = BDecTag (b, seqBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
      bytesDecoded += seqBytesDecoded;
      return;
    }
  }

  if ((tag1 == MAKE_TAG_ID (APPL, CONS, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    tag1 = BDecTag (b, seqBytesDecoded, env);
    elmtLen2 = BDecLen (b, seqBytesDecoded, env);
    country_name = new CountryName;
    country_name->BDecContent (b, tag1, elmtLen2, seqBytesDecoded, env);
    if (elmtLen1 == INDEFINITE_LEN)
      BDecEoc (b, seqBytesDecoded, env);

    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (APPL, CONS, 2)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    tag1 = BDecTag (b, seqBytesDecoded, env);
    elmtLen2 = BDecLen (b, seqBytesDecoded, env);
    administration_domain_name = new AdministrationDomainName;
    administration_domain_name->BDecContent (b, tag1, elmtLen2, seqBytesDecoded, env);
    if (elmtLen1 == INDEFINITE_LEN)
      BDecEoc (b, seqBytesDecoded, env);

    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 0))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    network_address = new NetworkAddress;
    network_address->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 1))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    terminal_identifier = new TerminalIdentifier;
    terminal_identifier->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 2)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    tag1 = BDecTag (b, seqBytesDecoded, env);
    elmtLen2 = BDecLen (b, seqBytesDecoded, env);
    private_domain_name = new PrivateDomainName;
    private_domain_name->BDecContent (b, tag1, elmtLen2, seqBytesDecoded, env);
    if (elmtLen1 == INDEFINITE_LEN)
      BDecEoc (b, seqBytesDecoded, env);

    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 3))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 3)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    organization_name = new OrganizationName;
    organization_name->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 4))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 4)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    numeric_user_identifier = new NumericUserIdentifier;
    numeric_user_identifier->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 5)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    personal_name = new PersonalName;
    personal_name->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 6)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    organizational_unit_names = new OrganizationUnitNames;
    organizational_unit_names->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -126);
  }
  else
    return;
} // StandardAttributes::BDecContent

AsnLen StandardAttributes::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void StandardAttributes::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "StandardAttributes::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -127);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int StandardAttributes::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int StandardAttributes::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void StandardAttributes::Print (ostream &os) const
{
#ifndef NDEBUG
  int nonePrinted = true;
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (country_name))
  {
    nonePrinted = false;
    Indent (os, indentG);
    os << "country-name ";
    os << *country_name;
  }
  else
  {
    Indent (os, indentG);
    os << "country-name ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (administration_domain_name))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "administration-domain-name ";
    os << *administration_domain_name;
  }
  else
  {
    Indent (os, indentG);
    os << "administration-domain-name ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (network_address))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "network-address ";
    os << *network_address;
  }
  else
  {
    Indent (os, indentG);
    os << "network-address ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (terminal_identifier))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "terminal-identifier ";
    os << *terminal_identifier;
  }
  else
  {
    Indent (os, indentG);
    os << "terminal-identifier ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (private_domain_name))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "private-domain-name ";
    os << *private_domain_name;
  }
  else
  {
    Indent (os, indentG);
    os << "private-domain-name ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (organization_name))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "organization-name ";
    os << *organization_name;
  }
  else
  {
    Indent (os, indentG);
    os << "organization-name ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (numeric_user_identifier))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "numeric-user-identifier ";
    os << *numeric_user_identifier;
  }
  else
  {
    Indent (os, indentG);
    os << "numeric-user-identifier ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (personal_name))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "personal-name ";
    os << *personal_name;
  }
  else
  {
    Indent (os, indentG);
    os << "personal-name ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (organizational_unit_names))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "organizational-unit-names ";
    os << *organizational_unit_names;
  }
  else
  {
    Indent (os, indentG);
    os << "organizational-unit-names ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // StandardAttributes::Print


ORAddress::ORAddress()
{
#if TCL
  standard_attributes = new StandardAttributes;
#else
  standard_attributes = NULL; // incomplete initialization of mandatory element!
#endif // TCL
  domain_defined_attributes = NULL;
  extension_attributes = NULL;
}

ORAddress::ORAddress (const ORAddress &)
{
  Asn1Error << "use of incompletely defined ORAddress::ORAddress (const ORAddress &)" << endl;
  abort();
}

ORAddress::~ORAddress()
{
  delete standard_attributes;
  delete domain_defined_attributes;
  delete extension_attributes;
}

AsnType *ORAddress::Clone() const
{
  return new ORAddress;
}

AsnType *ORAddress::Copy() const
{
  return new ORAddress (*this);
}

#if SNACC_DEEP_COPY
ORAddress &ORAddress::operator = (const ORAddress &that)
#else // SNACC_DEEP_COPY
ORAddress &ORAddress::operator = (const ORAddress &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.standard_attributes)
    {
      if (!standard_attributes)
        standard_attributes = new StandardAttributes;
      *standard_attributes = *that.standard_attributes;
    }
    else
    {
      delete standard_attributes;
      standard_attributes = NULL;
    }
    if (that.domain_defined_attributes)
    {
      if (!domain_defined_attributes)
        domain_defined_attributes = new DomainDefinedAttributes;
      *domain_defined_attributes = *that.domain_defined_attributes;
    }
    else
    {
      delete domain_defined_attributes;
      domain_defined_attributes = NULL;
    }
    if (that.extension_attributes)
    {
      if (!extension_attributes)
        extension_attributes = new ExtensionAttributes;
      *extension_attributes = *that.extension_attributes;
    }
    else
    {
      delete extension_attributes;
      extension_attributes = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined ORAddress &ORAddress::operator = (const ORAddress &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
ORAddress::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (extension_attributes))
  {
      BEncEocIfNec (b);
    l = extension_attributes->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, UNIV, CONS, SET_TAG_CODE);
    totalLen += l;
  }

  if (NOT_NULL (domain_defined_attributes))
  {
      BEncEocIfNec (b);
    l = domain_defined_attributes->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
    totalLen += l;
  }

      BEncEocIfNec (b);
    l = standard_attributes->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
    totalLen += l;

  return totalLen;
} // ORAddress::BEncContent


void ORAddress::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  tag1 = BDecTag (b, seqBytesDecoded, env);

  if ((tag1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    standard_attributes = new StandardAttributes;
    standard_attributes->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -128);
  }

  if ((tag1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    domain_defined_attributes = new DomainDefinedAttributes;
    domain_defined_attributes->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (UNIV, CONS, SET_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    extension_attributes = new ExtensionAttributes;
    extension_attributes->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -129);
  }
  else
    return;
} // ORAddress::BDecContent

AsnLen ORAddress::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void ORAddress::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "ORAddress::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -130);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int ORAddress::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int ORAddress::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void ORAddress::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (standard_attributes))
  {
    Indent (os, indentG);
    os << "standard-attributes ";
    os << *standard_attributes;
  }
  else
  {
    Indent (os, indentG);
    os << "standard-attributes ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (domain_defined_attributes))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "domain-defined-attributes ";
    os << *domain_defined_attributes;
  }
  else
  {
    Indent (os, indentG);
    os << "domain-defined-attributes ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (extension_attributes))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "extension-attributes ";
    os << *extension_attributes;
  }
  else
  {
    Indent (os, indentG);
    os << "extension-attributes ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // ORAddress::Print


TeletexPersonalName::TeletexPersonalName()
{
  given_name = NULL;
  initials = NULL;
  generation_qualifier = NULL;
}

TeletexPersonalName::TeletexPersonalName (const TeletexPersonalName &)
{
  Asn1Error << "use of incompletely defined TeletexPersonalName::TeletexPersonalName (const TeletexPersonalName &)" << endl;
  abort();
}

TeletexPersonalName::~TeletexPersonalName()
{
  delete given_name;
  delete initials;
  delete generation_qualifier;
}

AsnType *TeletexPersonalName::Clone() const
{
  return new TeletexPersonalName;
}

AsnType *TeletexPersonalName::Copy() const
{
  return new TeletexPersonalName (*this);
}

#if SNACC_DEEP_COPY
TeletexPersonalName &TeletexPersonalName::operator = (const TeletexPersonalName &that)
#else // SNACC_DEEP_COPY
TeletexPersonalName &TeletexPersonalName::operator = (const TeletexPersonalName &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    surname = that.surname;
    if (that.given_name)
    {
      if (!given_name)
        given_name = new TeletexString;
      *given_name = *that.given_name;
    }
    else
    {
      delete given_name;
      given_name = NULL;
    }
    if (that.initials)
    {
      if (!initials)
        initials = new TeletexString;
      *initials = *that.initials;
    }
    else
    {
      delete initials;
      initials = NULL;
    }
    if (that.generation_qualifier)
    {
      if (!generation_qualifier)
        generation_qualifier = new TeletexString;
      *generation_qualifier = *that.generation_qualifier;
    }
    else
    {
      delete generation_qualifier;
      generation_qualifier = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined TeletexPersonalName &TeletexPersonalName::operator = (const TeletexPersonalName &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen TeletexPersonalName::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

      AsnBuf outputBuf;
       int iii=0, tmpCount=0;
      char *lpszBuf = (char *)calloc(1, 1024);
      outputBuf.Init(lpszBuf, 1024);
      outputBuf.ResetInWriteRvsMode();
      CSM_Buffer *tmpEnc[4];
  if (NOT_NULL (generation_qualifier))
  {
    l = generation_qualifier->BEncContent (outputBuf);
    l += BEncDefLen (outputBuf, l);

    l += BEncTag1 (outputBuf, CNTX, PRIM, 3);
    totalLen += l;
        SNACC_BUFRESET_READ(&outputBuf);
        SM_ReadFromAsnBuf(tmpEnc[iii], outputBuf,outputBuf.DataLen(),NULL);
        SNACC_BUFRESET_WRITE(&outputBuf);
        iii++;
  }

  if (NOT_NULL (initials))
  {
    l = initials->BEncContent (outputBuf);
    l += BEncDefLen (outputBuf, l);

    l += BEncTag1 (outputBuf, CNTX, PRIM, 2);
    totalLen += l;
        SNACC_BUFRESET_READ(&outputBuf);
        SM_ReadFromAsnBuf(tmpEnc[iii], outputBuf,outputBuf.DataLen(),NULL);
        SNACC_BUFRESET_WRITE(&outputBuf);
        iii++;
  }

  if (NOT_NULL (given_name))
  {
    l = given_name->BEncContent (outputBuf);
    l += BEncDefLen (outputBuf, l);

    l += BEncTag1 (outputBuf, CNTX, PRIM, 1);
    totalLen += l;
        SNACC_BUFRESET_READ(&outputBuf);
        SM_ReadFromAsnBuf(tmpEnc[iii], outputBuf,outputBuf.DataLen(),NULL);
        SNACC_BUFRESET_WRITE(&outputBuf);
        iii++;
  }

    l = surname.BEncContent (outputBuf);
    l += BEncDefLen (outputBuf, l);

    l += BEncTag1 (outputBuf, CNTX, PRIM, 0);
    totalLen += l;
        SNACC_BUFRESET_READ(&outputBuf);
        SM_ReadFromAsnBuf(tmpEnc[iii], outputBuf,outputBuf.DataLen(),NULL);
        SNACC_BUFRESET_WRITE(&outputBuf);
        iii++;

      vdasnacc_sortSet(tmpEnc, iii);
      tmpCount = iii;  /** REMEMBER how many we have**/
      for (iii=0; iii < tmpCount; iii++)
         SM_WriteToAsnBuf(tmpEnc[iii], b);
      for (iii=0; iii < tmpCount; iii++) delete tmpEnc[iii];
      free(lpszBuf);
  return totalLen;
} // TeletexPersonalName::BEncContent


void TeletexPersonalName::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen setBytesDecoded = 0;
  unsigned int mandatoryElmtsDecoded = 0;
  AsnLen elmtLen1;

  for (; (setBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN); )
  {
    tag1 = BDecTag (b, setBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, setBytesDecoded, env)
      break; /* exit for loop */
    }
    elmtLen1 = BDecLen (b, setBytesDecoded, env);
    switch (tag1)
    {
      case MAKE_TAG_ID (CNTX, PRIM, 0):
      case MAKE_TAG_ID (CNTX, CONS, 0):
        surname.BDecContent (b, tag1, elmtLen1, setBytesDecoded, env);
          mandatoryElmtsDecoded++;
          break;

      case MAKE_TAG_ID (CNTX, PRIM, 1):
      case MAKE_TAG_ID (CNTX, CONS, 1):
        given_name = new TeletexString;
        given_name->BDecContent (b, tag1, elmtLen1, setBytesDecoded, env);
          break;

      case MAKE_TAG_ID (CNTX, PRIM, 2):
      case MAKE_TAG_ID (CNTX, CONS, 2):
        initials = new TeletexString;
        initials->BDecContent (b, tag1, elmtLen1, setBytesDecoded, env);
          break;

      case MAKE_TAG_ID (CNTX, PRIM, 3):
      case MAKE_TAG_ID (CNTX, CONS, 3):
        generation_qualifier = new TeletexString;
        generation_qualifier->BDecContent (b, tag1, elmtLen1, setBytesDecoded, env);
          break;

       default:
         Asn1Error << "Unexpected Tag on SET elmt." << endl;
         longjmp (env, -131);
    } // end switch
  } // end for loop
  bytesDecoded += setBytesDecoded;
  if (mandatoryElmtsDecoded != 1)
  {
     Asn1Error << "ERROR - non-optional SET element missing." << endl;
     longjmp (env, -132);
  }
} // TeletexPersonalName::BDecContent

AsnLen
TeletexPersonalName::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SET_TAG_CODE);
  return l;
}

void TeletexPersonalName::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SET_TAG_CODE))
  {
    Asn1Error << "TeletexPersonalName::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -133);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int TeletexPersonalName::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int TeletexPersonalName::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void TeletexPersonalName::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SET --" << endl;
  indentG += stdIndentG;

  {
    Indent (os, indentG);
    os << "surname ";
    os << surname;
  }

  if (NOT_NULL (given_name))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "given-name ";
    os << *given_name;
  }
  else
    os << "-- void2 --\n";

  if (NOT_NULL (initials))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "initials ";
    os << *initials;
  }
  else
    os << "-- void2 --\n";

  if (NOT_NULL (generation_qualifier))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "generation-qualifier ";
    os << *generation_qualifier;
  }
  else
    os << "-- void2 --\n";

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // TeletexPersonalName - operator <<


AsnType *TeletexOrganizationUnitNames::Clone() const
{
  return new TeletexOrganizationUnitNames;
}

AsnType *TeletexOrganizationUnitNames::Copy() const
{
  return new TeletexOrganizationUnitNames (*this);
}

AsnLen TeletexOrganizationUnitNames::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void TeletexOrganizationUnitNames::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "TeletexOrganizationUnitNames::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -134);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

TeletexOrganizationUnitNames::TeletexOrganizationUnitNames (const TeletexOrganizationUnitNames &)
{
  Asn1Error << "use of incompletely defined TeletexOrganizationUnitNames::TeletexOrganizationUnitNames (const TeletexOrganizationUnitNames &)" << endl;
  abort();
}

TeletexOrganizationUnitNames::~TeletexOrganizationUnitNames()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
TeletexOrganizationUnitNames &TeletexOrganizationUnitNames::operator = (const TeletexOrganizationUnitNames &that)
#else // SNACC_DEEP_COPY
TeletexOrganizationUnitNames &TeletexOrganizationUnitNames::operator = (const TeletexOrganizationUnitNames &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined TeletexOrganizationUnitNames &TeletexOrganizationUnitNames::operator = (const TeletexOrganizationUnitNames &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void TeletexOrganizationUnitNames::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  TeletexOrganizationUnitNames::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // TeletexOrganizationUnitNames::SetCurrElmt


unsigned long int  TeletexOrganizationUnitNames::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // TeletexOrganizationUnitNames::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
TeletexOrganizationalUnitName *TeletexOrganizationUnitNames::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new TeletexOrganizationalUnitName;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // TeletexOrganizationUnitNames::Append


// alloc new list elmt, put at begining of list
//  and return the component type
TeletexOrganizationalUnitName  *TeletexOrganizationUnitNames::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexOrganizationalUnitName;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // TeletexOrganizationUnitNames::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
TeletexOrganizationalUnitName  *TeletexOrganizationUnitNames::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexOrganizationalUnitName;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // TeletexOrganizationUnitNames::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
TeletexOrganizationalUnitName *TeletexOrganizationUnitNames::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexOrganizationalUnitName;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // TeletexOrganizationUnitNames::InsertAfter


TeletexOrganizationUnitNames  &TeletexOrganizationUnitNames::AppendCopy (TeletexOrganizationalUnitName &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexOrganizationalUnitName;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


TeletexOrganizationUnitNames  &TeletexOrganizationUnitNames::PrependCopy (TeletexOrganizationalUnitName &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexOrganizationalUnitName;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // TeletexOrganizationUnitNames::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
TeletexOrganizationUnitNames &TeletexOrganizationUnitNames::InsertBeforeAndCopy (TeletexOrganizationalUnitName &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexOrganizationalUnitName;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // TeletexOrganizationUnitNames::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
TeletexOrganizationUnitNames  &TeletexOrganizationUnitNames::InsertAfterAndCopy (TeletexOrganizationalUnitName &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexOrganizationalUnitName;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // TeletexOrganizationUnitNames::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void TeletexOrganizationUnitNames::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen TeletexOrganizationUnitNames::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncDefLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, PRIM, TELETEXSTRING_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // TeletexOrganizationUnitNames::BEncContent


void  TeletexOrganizationUnitNames::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    TeletexOrganizationalUnitName *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, PRIM, TELETEXSTRING_TAG_CODE))
         && (tag1 != MAKE_TAG_ID (UNIV, CONS, TELETEXSTRING_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -135);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // TeletexOrganizationUnitNames::BDecContent


AsnType *TeletexDomainDefinedAttributes::Clone() const
{
  return new TeletexDomainDefinedAttributes;
}

AsnType *TeletexDomainDefinedAttributes::Copy() const
{
  return new TeletexDomainDefinedAttributes (*this);
}

AsnLen TeletexDomainDefinedAttributes::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void TeletexDomainDefinedAttributes::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "TeletexDomainDefinedAttributes::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -136);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

TeletexDomainDefinedAttributes::TeletexDomainDefinedAttributes (const TeletexDomainDefinedAttributes &)
{
  Asn1Error << "use of incompletely defined TeletexDomainDefinedAttributes::TeletexDomainDefinedAttributes (const TeletexDomainDefinedAttributes &)" << endl;
  abort();
}

TeletexDomainDefinedAttributes::~TeletexDomainDefinedAttributes()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
TeletexDomainDefinedAttributes &TeletexDomainDefinedAttributes::operator = (const TeletexDomainDefinedAttributes &that)
#else // SNACC_DEEP_COPY
TeletexDomainDefinedAttributes &TeletexDomainDefinedAttributes::operator = (const TeletexDomainDefinedAttributes &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined TeletexDomainDefinedAttributes &TeletexDomainDefinedAttributes::operator = (const TeletexDomainDefinedAttributes &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void TeletexDomainDefinedAttributes::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  TeletexDomainDefinedAttributes::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // TeletexDomainDefinedAttributes::SetCurrElmt


unsigned long int  TeletexDomainDefinedAttributes::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // TeletexDomainDefinedAttributes::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
TeletexDomainDefinedAttribute *TeletexDomainDefinedAttributes::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new TeletexDomainDefinedAttribute;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // TeletexDomainDefinedAttributes::Append


// alloc new list elmt, put at begining of list
//  and return the component type
TeletexDomainDefinedAttribute  *TeletexDomainDefinedAttributes::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexDomainDefinedAttribute;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // TeletexDomainDefinedAttributes::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
TeletexDomainDefinedAttribute  *TeletexDomainDefinedAttributes::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexDomainDefinedAttribute;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // TeletexDomainDefinedAttributes::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
TeletexDomainDefinedAttribute *TeletexDomainDefinedAttributes::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexDomainDefinedAttribute;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // TeletexDomainDefinedAttributes::InsertAfter


TeletexDomainDefinedAttributes  &TeletexDomainDefinedAttributes::AppendCopy (TeletexDomainDefinedAttribute &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexDomainDefinedAttribute;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


TeletexDomainDefinedAttributes  &TeletexDomainDefinedAttributes::PrependCopy (TeletexDomainDefinedAttribute &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexDomainDefinedAttribute;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // TeletexDomainDefinedAttributes::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
TeletexDomainDefinedAttributes &TeletexDomainDefinedAttributes::InsertBeforeAndCopy (TeletexDomainDefinedAttribute &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexDomainDefinedAttribute;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // TeletexDomainDefinedAttributes::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
TeletexDomainDefinedAttributes  &TeletexDomainDefinedAttributes::InsertAfterAndCopy (TeletexDomainDefinedAttribute &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new TeletexDomainDefinedAttribute;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // TeletexDomainDefinedAttributes::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void TeletexDomainDefinedAttributes::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen TeletexDomainDefinedAttributes::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
      BEncEocIfNec (b);
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncConsLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // TeletexDomainDefinedAttributes::BEncContent


void  TeletexDomainDefinedAttributes::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    TeletexDomainDefinedAttribute *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -137);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // TeletexDomainDefinedAttributes::BDecContent


