//   NOTE: this is a machine generated file--editing not recommended
//
// sm_cms.h - class definitions for ASN.1 module CryptographicMessageSyntax
//
//   This file was generated by snacc on Wed Jun 27 16:40:55 2001
//   UBC snacc by Mike Sample
//   A couple of enhancements made by IBM European Networking Center

#ifndef _sm_cms_h_
#define _sm_cms_h_


//------------------------------------------------------------------------------
// class declarations:

class CMSVersion;
class OriginatorPublicKey;
class CertificateRevocationLists;
class IssuerAndSerialNumber;
class OtherKeyAttribute;
class DigestAlgorithmIdentifiers;
class EncapsulatedContentInfo;
class SignerIdentifier;
class EncryptedContentInfo;
class RecipientIdentifier;
class OriginatorIdentifierOrKey;
class RecipientKeyIdentifier;
class KEKIdentifier;
class ExtendedCertificateInfo;
class SignerInfo;
class KeyTransRecipientInfo;
class KeyAgreeRecipientIdentifier;
class KEKRecipientInfo;
class ExtendedCertificate;
class SignerInfos;
class RecipientEncryptedKey;
class CertificateChoices;
class CertificateSet;
class OriginatorInfo;
class RecipientEncryptedKeys;
class KeyAgreeRecipientInfo;
class RecipientInfo;
class RecipientInfos;
class ContentInfo;
class SignedData;
class EnvelopedData;
class DigestedData;
class EncryptedData;
class AuthenticatedData;
class UserKeyingMaterials;
class RC2CBCParameter;
class ExtendedCertificateOrCertificate;
class DigestInfo;

//------------------------------------------------------------------------------
// class definitions:

typedef enum CryptographicMessageSyntaxAnyId
{

} CryptographicMessageSyntaxAnyId;


/* OBJECT IDENTIFIER */
typedef AsnOid ContentType;

/* OCTET STRING */
typedef AsnOcts SignatureValue;

/* OCTET STRING */
typedef AsnOcts EncryptedContent;

/* OCTET STRING */
typedef AsnOcts EncryptedKey;

/* OCTET STRING */
typedef AsnOcts Digest;

/* OCTET STRING */
typedef AsnOcts MessageAuthenticationCode;

/* INTEGER { v0 (0), v1 (1), v2 (2), v3 (3), v4 (4) }  */
class CMSVersion: public AsnInt
{
public:
			CMSVersion(): AsnInt() {}
			CMSVersion (int i): AsnInt (i) {}
  enum
  {
    v0 = 0,
    v1 = 1,
    v2 = 2,
    v3 = 3,
    v4 = 4
  };
};


/* OCTET STRING */
typedef AsnOcts UserKeyingMaterial;

/* OCTET STRING */
typedef AsnOcts MessageDigest;

/* INTEGER */
typedef AsnInt RC2ParameterVersion;

/* OCTET STRING */
typedef AsnOcts IV;

/* BIT STRING */
typedef AsnBits Signature;

class OriginatorPublicKey: public AsnType
{
public:
  AlgorithmIdentifier		*algorithm;
  AsnBits		publicKey;

			OriginatorPublicKey();
			OriginatorPublicKey (const OriginatorPublicKey &);
  virtual		~OriginatorPublicKey();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  OriginatorPublicKey		&operator = (const OriginatorPublicKey &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


/* AlgorithmIdentifier */
typedef AlgorithmIdentifier DigestAlgorithmIdentifier;

/* AlgorithmIdentifier */
typedef AlgorithmIdentifier SignatureAlgorithmIdentifier;

/* AlgorithmIdentifier */
typedef AlgorithmIdentifier KeyEncryptionAlgorithmIdentifier;

/* AlgorithmIdentifier */
typedef AlgorithmIdentifier ContentEncryptionAlgorithmIdentifier;

/* AlgorithmIdentifier */
typedef AlgorithmIdentifier MessageAuthenticationCodeAlgorithm;

class CertificateRevocationLists: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    CertificateList	*elmt;
  }			*first, *curr, *last;

public:
			CertificateRevocationLists() { count = 0; first = curr = last = NULL; }
			CertificateRevocationLists (const CertificateRevocationLists &);
  virtual		~CertificateRevocationLists();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertificateRevocationLists		&operator = (const CertificateRevocationLists &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  CertificateList	*First() const	{ return count > 0 ? first->elmt : NULL; }
  CertificateList	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  CertificateList	*Curr() const	{ return curr ? curr->elmt : NULL; }
  CertificateList	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  CertificateList	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  CertificateList	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  CertificateList	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  CertificateList	*Append();  // add elmt to end of list
  CertificateList	*Prepend(); // add elmt to beginning of list
  CertificateList	*InsertBefore(); //insert elmt before current elmt
  CertificateList	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  CertificateRevocationLists	&AppendCopy (CertificateList &elmt);  // add elmt to end of list
  CertificateRevocationLists	&PrependCopy (CertificateList &elmt); // add elmt to beginning of list
  CertificateRevocationLists	&InsertBeforeAndCopy (CertificateList &elmt); //insert elmt before current elmt
  CertificateRevocationLists	&InsertAfterAndCopy (CertificateList &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class IssuerAndSerialNumber: public AsnType
{
public:
  Name		*issuer;
  CertificateSerialNumber		serialNumber;

			IssuerAndSerialNumber();
			IssuerAndSerialNumber (const IssuerAndSerialNumber &);
  virtual		~IssuerAndSerialNumber();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  IssuerAndSerialNumber		&operator = (const IssuerAndSerialNumber &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class OtherKeyAttribute: public AsnType
{
public:
  AsnOid		keyAttrId;
  AsnAny		*keyAttr;

			OtherKeyAttribute();
			OtherKeyAttribute (const OtherKeyAttribute &);
  virtual		~OtherKeyAttribute();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  OtherKeyAttribute		&operator = (const OtherKeyAttribute &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class DigestAlgorithmIdentifiers: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    DigestAlgorithmIdentifier	*elmt;
  }			*first, *curr, *last;

public:
			DigestAlgorithmIdentifiers() { count = 0; first = curr = last = NULL; }
			DigestAlgorithmIdentifiers (const DigestAlgorithmIdentifiers &);
  virtual		~DigestAlgorithmIdentifiers();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  DigestAlgorithmIdentifiers		&operator = (const DigestAlgorithmIdentifiers &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  DigestAlgorithmIdentifier	*First() const	{ return count > 0 ? first->elmt : NULL; }
  DigestAlgorithmIdentifier	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  DigestAlgorithmIdentifier	*Curr() const	{ return curr ? curr->elmt : NULL; }
  DigestAlgorithmIdentifier	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  DigestAlgorithmIdentifier	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  DigestAlgorithmIdentifier	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  DigestAlgorithmIdentifier	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  DigestAlgorithmIdentifier	*Append();  // add elmt to end of list
  DigestAlgorithmIdentifier	*Prepend(); // add elmt to beginning of list
  DigestAlgorithmIdentifier	*InsertBefore(); //insert elmt before current elmt
  DigestAlgorithmIdentifier	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  DigestAlgorithmIdentifiers	&AppendCopy (DigestAlgorithmIdentifier &elmt);  // add elmt to end of list
  DigestAlgorithmIdentifiers	&PrependCopy (DigestAlgorithmIdentifier &elmt); // add elmt to beginning of list
  DigestAlgorithmIdentifiers	&InsertBeforeAndCopy (DigestAlgorithmIdentifier &elmt); //insert elmt before current elmt
  DigestAlgorithmIdentifiers	&InsertAfterAndCopy (DigestAlgorithmIdentifier &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class EncapsulatedContentInfo: public AsnType
{
public:
  ContentType		eContentType;
  AsnOcts		*eContent;

			EncapsulatedContentInfo();
			EncapsulatedContentInfo (const EncapsulatedContentInfo &);
  virtual		~EncapsulatedContentInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  EncapsulatedContentInfo		&operator = (const EncapsulatedContentInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class SignerIdentifier: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     issuerAndSerialNumberCid = 0,
     subjectKeyIdentifierCid = 1
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     IssuerAndSerialNumber		*issuerAndSerialNumber;
     KeyIdentifier		*subjectKeyIdentifier;
  };


			SignerIdentifier();
			SignerIdentifier (const SignerIdentifier &);
  virtual		~SignerIdentifier();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  SignerIdentifier		&operator = (const SignerIdentifier &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class EncryptedContentInfo: public AsnType
{
public:
  ContentType		contentType;
  ContentEncryptionAlgorithmIdentifier		*contentEncryptionAlgorithm;
  EncryptedContent		*encryptedContent;

			EncryptedContentInfo();
			EncryptedContentInfo (const EncryptedContentInfo &);
  virtual		~EncryptedContentInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  EncryptedContentInfo		&operator = (const EncryptedContentInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class RecipientIdentifier: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     issuerAndSerialNumberCid = 0,
     subjectKeyIdentifierCid = 1
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     IssuerAndSerialNumber		*issuerAndSerialNumber;
     KeyIdentifier		*subjectKeyIdentifier;
  };


			RecipientIdentifier();
			RecipientIdentifier (const RecipientIdentifier &);
  virtual		~RecipientIdentifier();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  RecipientIdentifier		&operator = (const RecipientIdentifier &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class OriginatorIdentifierOrKey: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     issuerAndSerialNumberCid = 0,
     subjectKeyIdentifierCid = 1,
     originatorKeyCid = 2
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     IssuerAndSerialNumber		*issuerAndSerialNumber;
     KeyIdentifier		*subjectKeyIdentifier;
     OriginatorPublicKey		*originatorKey;
  };


			OriginatorIdentifierOrKey();
			OriginatorIdentifierOrKey (const OriginatorIdentifierOrKey &);
  virtual		~OriginatorIdentifierOrKey();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  OriginatorIdentifierOrKey		&operator = (const OriginatorIdentifierOrKey &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class RecipientKeyIdentifier: public AsnType
{
public:
  KeyIdentifier		subjectKeyIdentifier;
  GeneralizedTime		*date;
  OtherKeyAttribute		*other;

			RecipientKeyIdentifier();
			RecipientKeyIdentifier (const RecipientKeyIdentifier &);
  virtual		~RecipientKeyIdentifier();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  RecipientKeyIdentifier		&operator = (const RecipientKeyIdentifier &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class KEKIdentifier: public AsnType
{
public:
  AsnOcts		keyIdentifier;
  GeneralizedTime		*date;
  OtherKeyAttribute		*other;

			KEKIdentifier();
			KEKIdentifier (const KEKIdentifier &);
  virtual		~KEKIdentifier();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  KEKIdentifier		&operator = (const KEKIdentifier &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class ExtendedCertificateInfo: public AsnType
{
public:
  CMSVersion		version;
  Certificate		*certificate;
  Attributes		attributes;

			ExtendedCertificateInfo();
			ExtendedCertificateInfo (const ExtendedCertificateInfo &);
  virtual		~ExtendedCertificateInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  ExtendedCertificateInfo		&operator = (const ExtendedCertificateInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class SignerInfo: public AsnType
{
public:
  CMSVersion		version;
  SignerIdentifier		*sid;
  DigestAlgorithmIdentifier		*digestAlgorithm;
  Attributes		*signedAttrs;
  SignatureAlgorithmIdentifier		*signatureAlgorithm;
  SignatureValue		signature;
  Attributes		*unsignedAttrs;

			SignerInfo();
			SignerInfo (const SignerInfo &);
  virtual		~SignerInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  SignerInfo		&operator = (const SignerInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class KeyTransRecipientInfo: public AsnType
{
public:
  CMSVersion		version;
  RecipientIdentifier		*rid;
  KeyEncryptionAlgorithmIdentifier		*keyEncryptionAlgorithm;
  EncryptedKey		encryptedKey;

			KeyTransRecipientInfo();
			KeyTransRecipientInfo (const KeyTransRecipientInfo &);
  virtual		~KeyTransRecipientInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  KeyTransRecipientInfo		&operator = (const KeyTransRecipientInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class KeyAgreeRecipientIdentifier: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     issuerAndSerialNumberCid = 0,
     rKeyIdCid = 1
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     IssuerAndSerialNumber		*issuerAndSerialNumber;
     RecipientKeyIdentifier		*rKeyId;
  };


			KeyAgreeRecipientIdentifier();
			KeyAgreeRecipientIdentifier (const KeyAgreeRecipientIdentifier &);
  virtual		~KeyAgreeRecipientIdentifier();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  KeyAgreeRecipientIdentifier		&operator = (const KeyAgreeRecipientIdentifier &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class KEKRecipientInfo: public AsnType
{
public:
  CMSVersion		version;
  KEKIdentifier		*kekid;
  KeyEncryptionAlgorithmIdentifier		*keyEncryptionAlgorithm;
  EncryptedKey		encryptedKey;

			KEKRecipientInfo();
			KEKRecipientInfo (const KEKRecipientInfo &);
  virtual		~KEKRecipientInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  KEKRecipientInfo		&operator = (const KEKRecipientInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class ExtendedCertificate: public AsnType
{
public:
  ExtendedCertificateInfo		*extendedCertificateInfo;
  SignatureAlgorithmIdentifier		*signatureAlgorithm;
  Signature		signature;

			ExtendedCertificate();
			ExtendedCertificate (const ExtendedCertificate &);
  virtual		~ExtendedCertificate();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  ExtendedCertificate		&operator = (const ExtendedCertificate &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class SignerInfos: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    SignerInfo	*elmt;
  }			*first, *curr, *last;

public:
			SignerInfos() { count = 0; first = curr = last = NULL; }
			SignerInfos (const SignerInfos &);
  virtual		~SignerInfos();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  SignerInfos		&operator = (const SignerInfos &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  SignerInfo	*First() const	{ return count > 0 ? first->elmt : NULL; }
  SignerInfo	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  SignerInfo	*Curr() const	{ return curr ? curr->elmt : NULL; }
  SignerInfo	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  SignerInfo	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  SignerInfo	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  SignerInfo	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  SignerInfo	*Append();  // add elmt to end of list
  SignerInfo	*Prepend(); // add elmt to beginning of list
  SignerInfo	*InsertBefore(); //insert elmt before current elmt
  SignerInfo	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  SignerInfos	&AppendCopy (SignerInfo &elmt);  // add elmt to end of list
  SignerInfos	&PrependCopy (SignerInfo &elmt); // add elmt to beginning of list
  SignerInfos	&InsertBeforeAndCopy (SignerInfo &elmt); //insert elmt before current elmt
  SignerInfos	&InsertAfterAndCopy (SignerInfo &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class RecipientEncryptedKey: public AsnType
{
public:
  KeyAgreeRecipientIdentifier		*rid;
  EncryptedKey		encryptedKey;

			RecipientEncryptedKey();
			RecipientEncryptedKey (const RecipientEncryptedKey &);
  virtual		~RecipientEncryptedKey();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  RecipientEncryptedKey		&operator = (const RecipientEncryptedKey &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class CertificateChoices: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     certificateCid = 0,
     extendedCertificateCid = 1,
     attrCertCid = 2
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     Certificate		*certificate;
     ExtendedCertificate		*extendedCertificate;
     AttributeCertificate		*attrCert;
  };


			CertificateChoices();
			CertificateChoices (const CertificateChoices &);
  virtual		~CertificateChoices();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertificateChoices		&operator = (const CertificateChoices &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class CertificateSet: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    CertificateChoices	*elmt;
  }			*first, *curr, *last;

public:
			CertificateSet() { count = 0; first = curr = last = NULL; }
			CertificateSet (const CertificateSet &);
  virtual		~CertificateSet();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertificateSet		&operator = (const CertificateSet &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  CertificateChoices	*First() const	{ return count > 0 ? first->elmt : NULL; }
  CertificateChoices	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  CertificateChoices	*Curr() const	{ return curr ? curr->elmt : NULL; }
  CertificateChoices	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  CertificateChoices	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  CertificateChoices	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  CertificateChoices	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  CertificateChoices	*Append();  // add elmt to end of list
  CertificateChoices	*Prepend(); // add elmt to beginning of list
  CertificateChoices	*InsertBefore(); //insert elmt before current elmt
  CertificateChoices	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  CertificateSet	&AppendCopy (CertificateChoices &elmt);  // add elmt to end of list
  CertificateSet	&PrependCopy (CertificateChoices &elmt); // add elmt to beginning of list
  CertificateSet	&InsertBeforeAndCopy (CertificateChoices &elmt); //insert elmt before current elmt
  CertificateSet	&InsertAfterAndCopy (CertificateChoices &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class OriginatorInfo: public AsnType
{
public:
  CertificateSet		*certs;
  CertificateRevocationLists		*crls;

			OriginatorInfo();
			OriginatorInfo (const OriginatorInfo &);
  virtual		~OriginatorInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  OriginatorInfo		&operator = (const OriginatorInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class RecipientEncryptedKeys: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    RecipientEncryptedKey	*elmt;
  }			*first, *curr, *last;

public:
			RecipientEncryptedKeys() { count = 0; first = curr = last = NULL; }
			RecipientEncryptedKeys (const RecipientEncryptedKeys &);
  virtual		~RecipientEncryptedKeys();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  RecipientEncryptedKeys		&operator = (const RecipientEncryptedKeys &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  RecipientEncryptedKey	*First() const	{ return count > 0 ? first->elmt : NULL; }
  RecipientEncryptedKey	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  RecipientEncryptedKey	*Curr() const	{ return curr ? curr->elmt : NULL; }
  RecipientEncryptedKey	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  RecipientEncryptedKey	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  RecipientEncryptedKey	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  RecipientEncryptedKey	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  RecipientEncryptedKey	*Append();  // add elmt to end of list
  RecipientEncryptedKey	*Prepend(); // add elmt to beginning of list
  RecipientEncryptedKey	*InsertBefore(); //insert elmt before current elmt
  RecipientEncryptedKey	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  RecipientEncryptedKeys	&AppendCopy (RecipientEncryptedKey &elmt);  // add elmt to end of list
  RecipientEncryptedKeys	&PrependCopy (RecipientEncryptedKey &elmt); // add elmt to beginning of list
  RecipientEncryptedKeys	&InsertBeforeAndCopy (RecipientEncryptedKey &elmt); //insert elmt before current elmt
  RecipientEncryptedKeys	&InsertAfterAndCopy (RecipientEncryptedKey &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class KeyAgreeRecipientInfo: public AsnType
{
public:
  CMSVersion		version;
  OriginatorIdentifierOrKey		*originator;
  UserKeyingMaterial		*ukm;
  KeyEncryptionAlgorithmIdentifier		*keyEncryptionAlgorithm;
  RecipientEncryptedKeys		recipientEncryptedKeys;

			KeyAgreeRecipientInfo();
			KeyAgreeRecipientInfo (const KeyAgreeRecipientInfo &);
  virtual		~KeyAgreeRecipientInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  KeyAgreeRecipientInfo		&operator = (const KeyAgreeRecipientInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class RecipientInfo: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     ktriCid = 0,
     kariCid = 1,
     kekriCid = 2
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     KeyTransRecipientInfo		*ktri;
     KeyAgreeRecipientInfo		*kari;
     KEKRecipientInfo		*kekri;
  };


			RecipientInfo();
			RecipientInfo (const RecipientInfo &);
  virtual		~RecipientInfo();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  RecipientInfo		&operator = (const RecipientInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class RecipientInfos: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    RecipientInfo	*elmt;
  }			*first, *curr, *last;

public:
			RecipientInfos() { count = 0; first = curr = last = NULL; }
			RecipientInfos (const RecipientInfos &);
  virtual		~RecipientInfos();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  RecipientInfos		&operator = (const RecipientInfos &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  RecipientInfo	*First() const	{ return count > 0 ? first->elmt : NULL; }
  RecipientInfo	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  RecipientInfo	*Curr() const	{ return curr ? curr->elmt : NULL; }
  RecipientInfo	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  RecipientInfo	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  RecipientInfo	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  RecipientInfo	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  RecipientInfo	*Append();  // add elmt to end of list
  RecipientInfo	*Prepend(); // add elmt to beginning of list
  RecipientInfo	*InsertBefore(); //insert elmt before current elmt
  RecipientInfo	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  RecipientInfos	&AppendCopy (RecipientInfo &elmt);  // add elmt to end of list
  RecipientInfos	&PrependCopy (RecipientInfo &elmt); // add elmt to beginning of list
  RecipientInfos	&InsertBeforeAndCopy (RecipientInfo &elmt); //insert elmt before current elmt
  RecipientInfos	&InsertAfterAndCopy (RecipientInfo &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class ContentInfo: public AsnType
{
public:
  ContentType		contentType;
  AsnAny		content;

			ContentInfo();
			ContentInfo (const ContentInfo &);
  virtual		~ContentInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  ContentInfo		&operator = (const ContentInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class SignedData: public AsnType
{
public:
  CMSVersion		version;
  DigestAlgorithmIdentifiers		digestAlgorithms;
  EncapsulatedContentInfo		*encapContentInfo;
  CertificateSet		*certificates;
  CertificateRevocationLists		*crls;
  SignerInfos		signerInfos;

			SignedData();
			SignedData (const SignedData &);
  virtual		~SignedData();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  SignedData		&operator = (const SignedData &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class EnvelopedData: public AsnType
{
public:
  CMSVersion		version;
  OriginatorInfo		*originatorInfo;
  RecipientInfos		recipientInfos;
  EncryptedContentInfo		*encryptedContentInfo;
  Attributes		*unprotectedAttrs;

			EnvelopedData();
			EnvelopedData (const EnvelopedData &);
  virtual		~EnvelopedData();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  EnvelopedData		&operator = (const EnvelopedData &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class DigestedData: public AsnType
{
public:
  CMSVersion		version;
  DigestAlgorithmIdentifier		*digestAlgorithm;
  EncapsulatedContentInfo		*encapContentInfo;
  Digest		digest;

			DigestedData();
			DigestedData (const DigestedData &);
  virtual		~DigestedData();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  DigestedData		&operator = (const DigestedData &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class EncryptedData: public AsnType
{
public:
  CMSVersion		version;
  EncryptedContentInfo		*encryptedContentInfo;

			EncryptedData();
			EncryptedData (const EncryptedData &);
  virtual		~EncryptedData();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  EncryptedData		&operator = (const EncryptedData &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class AuthenticatedData: public AsnType
{
public:
  CMSVersion		version;
  OriginatorInfo		*originatorInfo;
  RecipientInfos		recipientInfos;
  MessageAuthenticationCodeAlgorithm		*macAlgorithm;
  DigestAlgorithmIdentifier		*digestAlgorithm;
  EncapsulatedContentInfo		*encapContentInfo;
  Attributes		*authenctiatedAttributes;
  MessageAuthenticationCode		mac;
  Attributes		*unauthenticatedAttributes;

			AuthenticatedData();
			AuthenticatedData (const AuthenticatedData &);
  virtual		~AuthenticatedData();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AuthenticatedData		&operator = (const AuthenticatedData &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class UserKeyingMaterials: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    UserKeyingMaterial	*elmt;
  }			*first, *curr, *last;

public:
			UserKeyingMaterials() { count = 0; first = curr = last = NULL; }
			UserKeyingMaterials (const UserKeyingMaterials &);
  virtual		~UserKeyingMaterials();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  UserKeyingMaterials		&operator = (const UserKeyingMaterials &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  UserKeyingMaterial	*First() const	{ return count > 0 ? first->elmt : NULL; }
  UserKeyingMaterial	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  UserKeyingMaterial	*Curr() const	{ return curr ? curr->elmt : NULL; }
  UserKeyingMaterial	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  UserKeyingMaterial	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  UserKeyingMaterial	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  UserKeyingMaterial	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  UserKeyingMaterial	*Append();  // add elmt to end of list
  UserKeyingMaterial	*Prepend(); // add elmt to beginning of list
  UserKeyingMaterial	*InsertBefore(); //insert elmt before current elmt
  UserKeyingMaterial	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  UserKeyingMaterials	&AppendCopy (UserKeyingMaterial &elmt);  // add elmt to end of list
  UserKeyingMaterials	&PrependCopy (UserKeyingMaterial &elmt); // add elmt to beginning of list
  UserKeyingMaterials	&InsertBeforeAndCopy (UserKeyingMaterial &elmt); //insert elmt before current elmt
  UserKeyingMaterials	&InsertAfterAndCopy (UserKeyingMaterial &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


/* Time */
typedef Time SigningTime;

/* SignerInfo */
typedef SignerInfo Countersignature;

/* AlgorithmIdentifier */
typedef AlgorithmIdentifier KeyWrapAlgorithm;

/* RC2ParameterVersion */
typedef RC2ParameterVersion RC2wrapParameter;

/* IV */
typedef IV CBCParameter;

class RC2CBCParameter: public AsnType
{
public:
  AsnInt		rc2ParameterVersion;
  AsnOcts		iv;

			RC2CBCParameter();
			RC2CBCParameter (const RC2CBCParameter &);
  virtual		~RC2CBCParameter();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  RC2CBCParameter		&operator = (const RC2CBCParameter &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class ExtendedCertificateOrCertificate: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     certificateCid = 0,
     extendedCertificateCid = 1
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     Certificate		*certificate;
     ExtendedCertificate		*extendedCertificate;
  };


			ExtendedCertificateOrCertificate();
			ExtendedCertificateOrCertificate (const ExtendedCertificateOrCertificate &);
  virtual		~ExtendedCertificateOrCertificate();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  ExtendedCertificateOrCertificate		&operator = (const ExtendedCertificateOrCertificate &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class DigestInfo: public AsnType
{
public:
  DigestAlgorithmIdentifier		*digestAlgorithm;
  Digest		digest;

			DigestInfo();
			DigestInfo (const DigestInfo &);
  virtual		~DigestInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  DigestInfo		&operator = (const DigestInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


//------------------------------------------------------------------------------
// externs for value defs

#define sha_1_arc 1, 3, 14, 3, 2, 26
#define sha_1     AsnOid(sha_1_arc)
#define id_dsa_with_sha1_arc 1, 2, 840, 10040, 4, 3
#define id_dsa_with_sha1     AsnOid(id_dsa_with_sha1_arc)
#define dh_public_number_arc 1, 2, 840, 10046, 2, 1
#define dh_public_number     AsnOid(dh_public_number_arc)
#define id_alg_ESDH_arc 1, 2, 840, 113549, 1, 9, 16, 3, 5
#define id_alg_ESDH     AsnOid(id_alg_ESDH_arc)
#define id_alg_CMS3DESwrap_arc 1, 2, 840, 113549, 1, 9, 16, 3, 6
#define id_alg_CMS3DESwrap     AsnOid(id_alg_CMS3DESwrap_arc)
#define id_alg_CMSRC2wrap_arc 1, 2, 840, 113549, 1, 9, 16, 3, 7
#define id_alg_CMSRC2wrap     AsnOid(id_alg_CMSRC2wrap_arc)
#define des_ede3_cbc_arc 1, 2, 840, 113549, 3, 7
#define des_ede3_cbc     AsnOid(des_ede3_cbc_arc)
#define rc2_cbc_arc 1, 2, 840, 113549, 3, 2
#define rc2_cbc     AsnOid(rc2_cbc_arc)
#define hMAC_SHA1_arc 1, 3, 6, 1, 5, 5, 8, 1, 2
#define hMAC_SHA1     AsnOid(hMAC_SHA1_arc)
#define rc2_ecb_arc 1, 2, 840, 113549, 3, 3
#define rc2_ecb     AsnOid(rc2_ecb_arc)
#define rc4_arc 1, 2, 840, 113549, 3, 4
#define rc4     AsnOid(rc4_arc)
#define rc4WithMAC_arc 1, 2, 840, 113549, 3, 5
#define rc4WithMAC     AsnOid(rc4WithMAC_arc)
#define desx_CBC_arc 1, 2, 840, 113549, 3, 6
#define desx_CBC     AsnOid(desx_CBC_arc)
#define rc5CBC_arc 1, 2, 840, 113549, 3, 8
#define rc5CBC     AsnOid(rc5CBC_arc)
#define rc5_CBCPad_arc 1, 2, 840, 113549, 3, 9
#define rc5_CBCPad     AsnOid(rc5_CBCPad_arc)
#define desCDMF_arc 1, 2, 840, 113549, 3, 10
#define desCDMF     AsnOid(desCDMF_arc)
#define dsa_bsafe_arc 1, 3, 14, 3, 2, 12
#define dsa_bsafe     AsnOid(dsa_bsafe_arc)
#define id_data_arc 1, 2, 840, 113549, 1, 7, 1
#define id_data     AsnOid(id_data_arc)
#define id_signedData_arc 1, 2, 840, 113549, 1, 7, 2
#define id_signedData     AsnOid(id_signedData_arc)
#define id_envelopedData_arc 1, 2, 840, 113549, 1, 7, 3
#define id_envelopedData     AsnOid(id_envelopedData_arc)
#define id_digestedData_arc 1, 2, 840, 113549, 1, 7, 5
#define id_digestedData     AsnOid(id_digestedData_arc)
#define id_encryptedData_arc 1, 2, 840, 113549, 1, 7, 6
#define id_encryptedData     AsnOid(id_encryptedData_arc)
#define id_ct_authData_arc 1, 2, 840, 113549, 1, 9, 16, 1, 2
#define id_ct_authData     AsnOid(id_ct_authData_arc)
#define id_contentType_arc 1, 2, 840, 113549, 1, 9, 3
#define id_contentType     AsnOid(id_contentType_arc)
#define id_messageDigest_arc 1, 2, 840, 113549, 1, 9, 4
#define id_messageDigest     AsnOid(id_messageDigest_arc)
#define id_signingTime_arc 1, 2, 840, 113549, 1, 9, 5
#define id_signingTime     AsnOid(id_signingTime_arc)
#define id_countersignature_arc 1, 2, 840, 113549, 1, 9, 6
#define id_countersignature     AsnOid(id_countersignature_arc)
#define id_macValue_arc 1, 2, 840, 113549, 1, 9, 16, 2, 8
#define id_macValue     AsnOid(id_macValue_arc)
#define id_dsa_arc 1, 2, 840, 10040, 4, 1
#define id_dsa     AsnOid(id_dsa_arc)
//------------------------------------------------------------------------------

#endif /* conditional include of sm_cms.h */
