//   NOTE: this is a machine generated file--editing not recommended
//
// sm_x509af.h - class definitions for ASN.1 module AuthenticationFramework
//
//   This file was generated by snacc on Wed Jun 27 16:40:55 2001
//   UBC snacc by Mike Sample
//   A couple of enhancements made by IBM European Networking Center

#ifndef _sm_x509af_h_
#define _sm_x509af_h_


//------------------------------------------------------------------------------
// class declarations:

class Version;
class AttributeCertificateAssertionSetOf;
class AttributeCertificateInfoSeqOf;
class AlgorithmIdentifier;
class Time;
class Extension;
class AttCertValidityPeriod;
class Validity;
class SubjectPublicKeyInfo;
class Extensions;
class IssuerSerial;
class AttributeCertificateAssertionChoice;
class AttributeCertificateInfoChoice;
class CRLToSignSeqOfSeq;
class CRLToSignSeqOf;
class CertificateToSign;
class CRLToSign;
class AttributeCertificateInfo;
class Certificate;
class CrossCertificates;
class CertificatePair;
class CertificateList;
class AttributeCertificate;
class CertificationPathSeqOf;
class ForwardCertificationPath;
class ACPathData;
class AttributeCertificationPathSeqOf;
class Certificates;
class CertificationPath;
class AttributeCertificationPath;
class AttributeCertificateAssertion;

//------------------------------------------------------------------------------
// class definitions:

typedef enum AuthenticationFrameworkAnyId
{

} AuthenticationFrameworkAnyId;


/* INTEGER { v1 (0), v2 (1), v3 (2) }  */
class Version: public AsnInt
{
public:
			Version(): AsnInt() {}
			Version (int i): AsnInt (i) {}
  enum
  {
    v1 = 0,
    v2 = 1,
    v3 = 2
  };
};


/* OCTET STRING (SIZE (0..ub-password-length)) */
typedef AsnOcts UserPassword;

class AttributeCertificateAssertionSetOf: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    AttributeType	*elmt;
  }			*first, *curr, *last;

public:
			AttributeCertificateAssertionSetOf() { count = 0; first = curr = last = NULL; }
			AttributeCertificateAssertionSetOf (const AttributeCertificateAssertionSetOf &);
  virtual		~AttributeCertificateAssertionSetOf();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributeCertificateAssertionSetOf		&operator = (const AttributeCertificateAssertionSetOf &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  AttributeType	*First() const	{ return count > 0 ? first->elmt : NULL; }
  AttributeType	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  AttributeType	*Curr() const	{ return curr ? curr->elmt : NULL; }
  AttributeType	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  AttributeType	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  AttributeType	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  AttributeType	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  AttributeType	*Append();  // add elmt to end of list
  AttributeType	*Prepend(); // add elmt to beginning of list
  AttributeType	*InsertBefore(); //insert elmt before current elmt
  AttributeType	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  AttributeCertificateAssertionSetOf	&AppendCopy (AttributeType &elmt);  // add elmt to end of list
  AttributeCertificateAssertionSetOf	&PrependCopy (AttributeType &elmt); // add elmt to beginning of list
  AttributeCertificateAssertionSetOf	&InsertBeforeAndCopy (AttributeType &elmt); //insert elmt before current elmt
  AttributeCertificateAssertionSetOf	&InsertAfterAndCopy (AttributeType &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class AttributeCertificateInfoSeqOf: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    Attribute	*elmt;
  }			*first, *curr, *last;

public:
			AttributeCertificateInfoSeqOf() { count = 0; first = curr = last = NULL; }
			AttributeCertificateInfoSeqOf (const AttributeCertificateInfoSeqOf &);
  virtual		~AttributeCertificateInfoSeqOf();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributeCertificateInfoSeqOf		&operator = (const AttributeCertificateInfoSeqOf &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  Attribute	*First() const	{ return count > 0 ? first->elmt : NULL; }
  Attribute	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  Attribute	*Curr() const	{ return curr ? curr->elmt : NULL; }
  Attribute	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  Attribute	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  Attribute	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  Attribute	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  Attribute	*Append();  // add elmt to end of list
  Attribute	*Prepend(); // add elmt to beginning of list
  Attribute	*InsertBefore(); //insert elmt before current elmt
  Attribute	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  AttributeCertificateInfoSeqOf	&AppendCopy (Attribute &elmt);  // add elmt to end of list
  AttributeCertificateInfoSeqOf	&PrependCopy (Attribute &elmt); // add elmt to beginning of list
  AttributeCertificateInfoSeqOf	&InsertBeforeAndCopy (Attribute &elmt); //insert elmt before current elmt
  AttributeCertificateInfoSeqOf	&InsertAfterAndCopy (Attribute &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


/* BigIntegerStr */
typedef BigIntegerStr CertificateSerialNumber;

class AlgorithmIdentifier: public AsnType
{
public:
  AsnOid		algorithm;
  AsnAny		*parameters;

			AlgorithmIdentifier();
			AlgorithmIdentifier (const AlgorithmIdentifier &);
  virtual		~AlgorithmIdentifier();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AlgorithmIdentifier		&operator = (const AlgorithmIdentifier &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class Time: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     utcTimeCid = 0,
     generalizedTimeCid = 1
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     UTCTime		*utcTime;
     GeneralizedTime		*generalizedTime;
  };


			Time();
			Time (const Time &);
  virtual		~Time();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  Time		&operator = (const Time &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class Extension: public AsnType
{
public:
  AsnOid		extnId;
  AsnBool		*critical;
  AsnOcts		extnValue;

			Extension();
			Extension (const Extension &);
  virtual		~Extension();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  Extension		&operator = (const Extension &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class AttCertValidityPeriod: public AsnType
{
public:
  GeneralizedTime		notBeforeTime;
  GeneralizedTime		notAfterTime;

			AttCertValidityPeriod();
			AttCertValidityPeriod (const AttCertValidityPeriod &);
  virtual		~AttCertValidityPeriod();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttCertValidityPeriod		&operator = (const AttCertValidityPeriod &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class Validity: public AsnType
{
public:
  Time		*notBefore;
  Time		*notAfter;

			Validity();
			Validity (const Validity &);
  virtual		~Validity();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  Validity		&operator = (const Validity &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class SubjectPublicKeyInfo: public AsnType
{
public:
  AlgorithmIdentifier		*algorithm;
  AsnBits		subjectPublicKey;

			SubjectPublicKeyInfo();
			SubjectPublicKeyInfo (const SubjectPublicKeyInfo &);
  virtual		~SubjectPublicKeyInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  SubjectPublicKeyInfo		&operator = (const SubjectPublicKeyInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class Extensions: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    Extension	*elmt;
  }			*first, *curr, *last;

public:
			Extensions() { count = 0; first = curr = last = NULL; }
			Extensions (const Extensions &);
  virtual		~Extensions();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  Extensions		&operator = (const Extensions &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  Extension	*First() const	{ return count > 0 ? first->elmt : NULL; }
  Extension	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  Extension	*Curr() const	{ return curr ? curr->elmt : NULL; }
  Extension	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  Extension	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  Extension	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  Extension	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  Extension	*Append();  // add elmt to end of list
  Extension	*Prepend(); // add elmt to beginning of list
  Extension	*InsertBefore(); //insert elmt before current elmt
  Extension	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  Extensions	&AppendCopy (Extension &elmt);  // add elmt to end of list
  Extensions	&PrependCopy (Extension &elmt); // add elmt to beginning of list
  Extensions	&InsertBeforeAndCopy (Extension &elmt); //insert elmt before current elmt
  Extensions	&InsertAfterAndCopy (Extension &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class IssuerSerial: public AsnType
{
public:
  GeneralNames		issuer;
  CertificateSerialNumber		serial;
  UniqueIdentifier		*issuerUID;

			IssuerSerial();
			IssuerSerial (const IssuerSerial &);
  virtual		~IssuerSerial();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  IssuerSerial		&operator = (const IssuerSerial &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class AttributeCertificateAssertionChoice: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     baseCertificateIDCid = 0,
     subjectNameCid = 1
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     IssuerSerial		*baseCertificateID;
     Name		*subjectName;
  };


			AttributeCertificateAssertionChoice();
			AttributeCertificateAssertionChoice (const AttributeCertificateAssertionChoice &);
  virtual		~AttributeCertificateAssertionChoice();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributeCertificateAssertionChoice		&operator = (const AttributeCertificateAssertionChoice &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class AttributeCertificateInfoChoice: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     baseCertificateIDCid = 0,
     subjectNameCid = 1
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     IssuerSerial		*baseCertificateID;
     GeneralNames		*subjectName;
  };


			AttributeCertificateInfoChoice();
			AttributeCertificateInfoChoice (const AttributeCertificateInfoChoice &);
  virtual		~AttributeCertificateInfoChoice();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributeCertificateInfoChoice		&operator = (const AttributeCertificateInfoChoice &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class CRLToSignSeqOfSeq: public AsnType
{
public:
  CertificateSerialNumber		userCertificate;
  Time		*revocationDate;
  Extensions		*crlEntryExtensions;

			CRLToSignSeqOfSeq();
			CRLToSignSeqOfSeq (const CRLToSignSeqOfSeq &);
  virtual		~CRLToSignSeqOfSeq();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CRLToSignSeqOfSeq		&operator = (const CRLToSignSeqOfSeq &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class CRLToSignSeqOf: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    CRLToSignSeqOfSeq	*elmt;
  }			*first, *curr, *last;

public:
			CRLToSignSeqOf() { count = 0; first = curr = last = NULL; }
			CRLToSignSeqOf (const CRLToSignSeqOf &);
  virtual		~CRLToSignSeqOf();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CRLToSignSeqOf		&operator = (const CRLToSignSeqOf &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  CRLToSignSeqOfSeq	*First() const	{ return count > 0 ? first->elmt : NULL; }
  CRLToSignSeqOfSeq	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  CRLToSignSeqOfSeq	*Curr() const	{ return curr ? curr->elmt : NULL; }
  CRLToSignSeqOfSeq	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  CRLToSignSeqOfSeq	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  CRLToSignSeqOfSeq	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  CRLToSignSeqOfSeq	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  CRLToSignSeqOfSeq	*Append();  // add elmt to end of list
  CRLToSignSeqOfSeq	*Prepend(); // add elmt to beginning of list
  CRLToSignSeqOfSeq	*InsertBefore(); //insert elmt before current elmt
  CRLToSignSeqOfSeq	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  CRLToSignSeqOf	&AppendCopy (CRLToSignSeqOfSeq &elmt);  // add elmt to end of list
  CRLToSignSeqOf	&PrependCopy (CRLToSignSeqOfSeq &elmt); // add elmt to beginning of list
  CRLToSignSeqOf	&InsertBeforeAndCopy (CRLToSignSeqOfSeq &elmt); //insert elmt before current elmt
  CRLToSignSeqOf	&InsertAfterAndCopy (CRLToSignSeqOfSeq &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class CertificateToSign: public AsnType
{
public:
  Version		*version;
  CertificateSerialNumber		serialNumber;
  AlgorithmIdentifier		*signature;
  Name		*issuer;
  Validity		*validity;
  Name		*subject;
  SubjectPublicKeyInfo		*subjectPublicKeyInfo;
  UniqueIdentifier		*issuerUniqueIdentifier;
  UniqueIdentifier		*subjectUniqueIdentifier;
  Extensions		*extensions;

			CertificateToSign();
			CertificateToSign (const CertificateToSign &);
  virtual		~CertificateToSign();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertificateToSign		&operator = (const CertificateToSign &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class CRLToSign: public AsnType
{
public:
  Version		*version;
  AlgorithmIdentifier		*signature;
  Name		*issuer;
  Time		*thisUpdate;
  Time		*nextUpdate;
  CRLToSignSeqOf		*revokedCertificates;
  Extensions		*crlExtensions;

			CRLToSign();
			CRLToSign (const CRLToSign &);
  virtual		~CRLToSign();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CRLToSign		&operator = (const CRLToSign &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class AttributeCertificateInfo: public AsnType
{
public:
  Version		*version;
  AttributeCertificateInfoChoice		*subject;
  GeneralNames		issuer;
  AlgorithmIdentifier		*signature;
  CertificateSerialNumber		serialNumber;
  AttCertValidityPeriod		*attCertValidityPeriod;
  AttributeCertificateInfoSeqOf		attributes;
  UniqueIdentifier		*issuerUniqueID;
  Extensions		*extensions;

			AttributeCertificateInfo();
			AttributeCertificateInfo (const AttributeCertificateInfo &);
  virtual		~AttributeCertificateInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributeCertificateInfo		&operator = (const AttributeCertificateInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class Certificate: public AsnType
{
public:
  CertificateToSign		*certificateToSign;
  AlgorithmIdentifier		*algorithmIdentifier;
  AsnBits		signatureValue;

			Certificate();
			Certificate (const Certificate &);
  virtual		~Certificate();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  Certificate		&operator = (const Certificate &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class CrossCertificates: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    Certificate	*elmt;
  }			*first, *curr, *last;

public:
			CrossCertificates() { count = 0; first = curr = last = NULL; }
			CrossCertificates (const CrossCertificates &);
  virtual		~CrossCertificates();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CrossCertificates		&operator = (const CrossCertificates &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  Certificate	*First() const	{ return count > 0 ? first->elmt : NULL; }
  Certificate	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  Certificate	*Curr() const	{ return curr ? curr->elmt : NULL; }
  Certificate	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  Certificate	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  Certificate	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  Certificate	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  Certificate	*Append();  // add elmt to end of list
  Certificate	*Prepend(); // add elmt to beginning of list
  Certificate	*InsertBefore(); //insert elmt before current elmt
  Certificate	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  CrossCertificates	&AppendCopy (Certificate &elmt);  // add elmt to end of list
  CrossCertificates	&PrependCopy (Certificate &elmt); // add elmt to beginning of list
  CrossCertificates	&InsertBeforeAndCopy (Certificate &elmt); //insert elmt before current elmt
  CrossCertificates	&InsertAfterAndCopy (Certificate &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class CertificatePair: public AsnType
{
public:
  Certificate		*forward;
  Certificate		*reverse;

			CertificatePair();
			CertificatePair (const CertificatePair &);
  virtual		~CertificatePair();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertificatePair		&operator = (const CertificatePair &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class CertificateList: public AsnType
{
public:
  CRLToSign		*crlToSign;
  AlgorithmIdentifier		*algorithmIdentifier;
  AsnBits		signatureValue;

			CertificateList();
			CertificateList (const CertificateList &);
  virtual		~CertificateList();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertificateList		&operator = (const CertificateList &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class AttributeCertificate: public AsnType
{
public:
  AttributeCertificateInfo		*attributeCertificateInfo;
  AlgorithmIdentifier		*algorithmIdentifier;
  AsnBits		signatureValue;

			AttributeCertificate();
			AttributeCertificate (const AttributeCertificate &);
  virtual		~AttributeCertificate();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributeCertificate		&operator = (const AttributeCertificate &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class CertificationPathSeqOf: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    CertificatePair	*elmt;
  }			*first, *curr, *last;

public:
			CertificationPathSeqOf() { count = 0; first = curr = last = NULL; }
			CertificationPathSeqOf (const CertificationPathSeqOf &);
  virtual		~CertificationPathSeqOf();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertificationPathSeqOf		&operator = (const CertificationPathSeqOf &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  CertificatePair	*First() const	{ return count > 0 ? first->elmt : NULL; }
  CertificatePair	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  CertificatePair	*Curr() const	{ return curr ? curr->elmt : NULL; }
  CertificatePair	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  CertificatePair	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  CertificatePair	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  CertificatePair	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  CertificatePair	*Append();  // add elmt to end of list
  CertificatePair	*Prepend(); // add elmt to beginning of list
  CertificatePair	*InsertBefore(); //insert elmt before current elmt
  CertificatePair	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  CertificationPathSeqOf	&AppendCopy (CertificatePair &elmt);  // add elmt to end of list
  CertificationPathSeqOf	&PrependCopy (CertificatePair &elmt); // add elmt to beginning of list
  CertificationPathSeqOf	&InsertBeforeAndCopy (CertificatePair &elmt); //insert elmt before current elmt
  CertificationPathSeqOf	&InsertAfterAndCopy (CertificatePair &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class ForwardCertificationPath: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    CrossCertificates	*elmt;
  }			*first, *curr, *last;

public:
			ForwardCertificationPath() { count = 0; first = curr = last = NULL; }
			ForwardCertificationPath (const ForwardCertificationPath &);
  virtual		~ForwardCertificationPath();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  ForwardCertificationPath		&operator = (const ForwardCertificationPath &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  CrossCertificates	*First() const	{ return count > 0 ? first->elmt : NULL; }
  CrossCertificates	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  CrossCertificates	*Curr() const	{ return curr ? curr->elmt : NULL; }
  CrossCertificates	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  CrossCertificates	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  CrossCertificates	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  CrossCertificates	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  CrossCertificates	*Append();  // add elmt to end of list
  CrossCertificates	*Prepend(); // add elmt to beginning of list
  CrossCertificates	*InsertBefore(); //insert elmt before current elmt
  CrossCertificates	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  ForwardCertificationPath	&AppendCopy (CrossCertificates &elmt);  // add elmt to end of list
  ForwardCertificationPath	&PrependCopy (CrossCertificates &elmt); // add elmt to beginning of list
  ForwardCertificationPath	&InsertBeforeAndCopy (CrossCertificates &elmt); //insert elmt before current elmt
  ForwardCertificationPath	&InsertAfterAndCopy (CrossCertificates &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class ACPathData: public AsnType
{
public:
  Certificate		*certificate;
  AttributeCertificate		*attributeCertificate;

			ACPathData();
			ACPathData (const ACPathData &);
  virtual		~ACPathData();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  ACPathData		&operator = (const ACPathData &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class AttributeCertificationPathSeqOf: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    ACPathData	*elmt;
  }			*first, *curr, *last;

public:
			AttributeCertificationPathSeqOf() { count = 0; first = curr = last = NULL; }
			AttributeCertificationPathSeqOf (const AttributeCertificationPathSeqOf &);
  virtual		~AttributeCertificationPathSeqOf();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributeCertificationPathSeqOf		&operator = (const AttributeCertificationPathSeqOf &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  ACPathData	*First() const	{ return count > 0 ? first->elmt : NULL; }
  ACPathData	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  ACPathData	*Curr() const	{ return curr ? curr->elmt : NULL; }
  ACPathData	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  ACPathData	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  ACPathData	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  ACPathData	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  ACPathData	*Append();  // add elmt to end of list
  ACPathData	*Prepend(); // add elmt to beginning of list
  ACPathData	*InsertBefore(); //insert elmt before current elmt
  ACPathData	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  AttributeCertificationPathSeqOf	&AppendCopy (ACPathData &elmt);  // add elmt to end of list
  AttributeCertificationPathSeqOf	&PrependCopy (ACPathData &elmt); // add elmt to beginning of list
  AttributeCertificationPathSeqOf	&InsertBeforeAndCopy (ACPathData &elmt); //insert elmt before current elmt
  AttributeCertificationPathSeqOf	&InsertAfterAndCopy (ACPathData &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class Certificates: public AsnType
{
public:
  Certificate		*userCertificate;
  ForwardCertificationPath		*certificationPath;

			Certificates();
			Certificates (const Certificates &);
  virtual		~Certificates();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  Certificates		&operator = (const Certificates &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class CertificationPath: public AsnType
{
public:
  Certificate		*userCertificate;
  CertificationPathSeqOf		*theCACertificates;

			CertificationPath();
			CertificationPath (const CertificationPath &);
  virtual		~CertificationPath();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertificationPath		&operator = (const CertificationPath &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class AttributeCertificationPath: public AsnType
{
public:
  AttributeCertificate		*attributeCertificate;
  AttributeCertificationPathSeqOf		*acPath;

			AttributeCertificationPath();
			AttributeCertificationPath (const AttributeCertificationPath &);
  virtual		~AttributeCertificationPath();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributeCertificationPath		&operator = (const AttributeCertificationPath &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class AttributeCertificateAssertion: public AsnType
{
public:
  AttributeCertificateAssertionChoice		*subject;
  Name		*issuer;
  GeneralizedTime		*attCertValidity;
  AttributeCertificateAssertionSetOf		*attType;

			AttributeCertificateAssertion();
			AttributeCertificateAssertion (const AttributeCertificateAssertion &);
  virtual		~AttributeCertificateAssertion();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributeCertificateAssertion		&operator = (const AttributeCertificateAssertion &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


/* Certificate */
typedef Certificate UserCertificate;

/* Certificate */
typedef Certificate CACertificate;

/* CertificatePair */
typedef CertificatePair CrossCertificatePair;

/* CertificateList */
typedef CertificateList AuthorityRevocationList;

/* CertificateList */
typedef CertificateList CertificateRevocationList;

/* CertificateList */
typedef CertificateList AttributeCertificateRevocationList;

//------------------------------------------------------------------------------
// externs for value defs

#define id_at_userPassword_arc 2, 5, 4, 35
#define id_at_userPassword     AsnOid(id_at_userPassword_arc)
#define id_at_userCertificate_arc 2, 5, 4, 36
#define id_at_userCertificate     AsnOid(id_at_userCertificate_arc)
#define id_at_cAcertificate_arc 2, 5, 4, 37
#define id_at_cAcertificate     AsnOid(id_at_cAcertificate_arc)
#define id_at_authorityRevocationList_arc 2, 5, 4, 38
#define id_at_authorityRevocationList     AsnOid(id_at_authorityRevocationList_arc)
#define id_at_certificateRevocationList_arc 2, 5, 4, 39
#define id_at_certificateRevocationList     AsnOid(id_at_certificateRevocationList_arc)
#define id_at_crossCertificatePair_arc 2, 5, 4, 40
#define id_at_crossCertificatePair     AsnOid(id_at_crossCertificatePair_arc)
#define id_at_attributeCertificate_arc 2, 5, 4, 58
#define id_at_attributeCertificate     AsnOid(id_at_attributeCertificate_arc)
//------------------------------------------------------------------------------

#endif /* conditional include of sm_x509af.h */
