divert(-1)
changecom(/*, */)
/*
 * Copyright (c) 2000-2001 Apple Computer, Inc. All Rights Reserved.
 * 
 * The contents of this file constitute Original Code as defined in and are
 * subject to the Apple Public Source License Version 1.2 (the 'License').
 * You may not use this file except in compliance with the License. Please obtain
 * a copy of the License at http://www.apple.com/publicsource and read it before
 * using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS
 * OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see the License for the
 * specific language governing rights and limitations under the License.
 */

define(`startClass',
`define(`arrayIndex', 0)dnl
define(`class', $1)dnl
divert(0)dnl
// $1 password attributes
static const CSSM_DB_ATTRIBUTE_INFO $1Attributes[] =
{
divert(1)dnl
// $1 password indices
static const CSSM_DB_INDEX_INFO $1Indices[] =
{')

define(`endClass',
`divert(0)dnl
};

divert(1)dnl
`  // Unique (primary) index'
undivert(3)
`  // Secondary indices'
undivert(4)dnl
};

divert(-1)')

define(`attributeBody',
`    {
ifelse(index(`$1',`s'),-1,
`        CSSM_DB_ATTRIBUTE_NAME_AS_INTEGER,
        {(char *)$3},',
`        CSSM_DB_ATTRIBUTE_NAME_AS_STRING,
        {$4},')
        CSSM_DB_ATTRIBUTE_FORMAT_$7
    }')

define(`simpleAttribute',
`const CSSM_DB_ATTRIBUTE_INFO $2 =
attributeBody($*);
')

define(`attribute',
`ifelse(index(`$1',`U'),-1,`',
`divert(3)dnl
  {
    CSSM_DB_INDEX_UNIQUE,
    CSSM_DB_INDEX_ON_ATTRIBUTE,
attributeBody($*)
  },
')dnl
ifelse(index(`$1',`I'),-1,`',
`divert(4)dnl
  {
    CSSM_DB_INDEX_NONUNIQUE,
    CSSM_DB_INDEX_ON_ATTRIBUTE,
attributeBody($*)
  },
')dnl
divert(2)dnl
dnl const CSSM_DB_ATTRIBUTE_INFO &`k'class()$2 = class()Attributes[arrayIndex()];
`#define k'class()$2 class()Attributes[arrayIndex()];
divert(0)dnl
attributeBody($*),dnl
define(`arrayIndex', incr(arrayIndex))dnl
')

define(`attrInfo',
`{
        $1,
        sizeof($2Attributes) / sizeof(CSSM_DB_ATTRIBUTE_INFO),
        const_cast<CSSM_DB_ATTRIBUTE_INFO_PTR>($2Attributes)
    }')

define(`indexInfo',
`{
        $1,
        sizeof($2Indices) / sizeof(CSSM_DB_INDEX_INFO),
        const_cast<CSSM_DB_INDEX_INFO_PTR>($2Indices)
    }')

define(`parseInfo',
`{
        CSSM_DB_RECORDTYPE_APP_DEFINED_START,
        {
            {0,0,0,{0}},
            {0,0},
            0,
            0
        }
    }')

/* Start of actual output */
divert(0)dnl
/*
 * Generated by m4 from Schema.m4 please do not edit this file.
 */

`#include <Security/Schema.h>'

`#include <Security/SecKeychainAPIPriv.h>'
`#include <Security/cssmapple.h>'
`#include <Security/utilities.h>'

namespace Security {

namespace KeychainCore {

namespace Schema {

// Meta attributes
simpleAttribute(`  s', RelationID, 0, "RelationID", 0, NULL, UINT32)
simpleAttribute(`  s', RelationName, 1, "RelationName", 0, NULL, STRING)
simpleAttribute(`  s', AttributeID, 1, "AttributeID", 0, NULL, UINT32)
simpleAttribute(`  s', AttributeNameFormat, 2, "AttributeNameFormat", 0, NULL, UINT32)
simpleAttribute(`  s', AttributeName, 3, "AttributeName", 0, NULL, STRING)
simpleAttribute(`  s', AttributeNameID, 4, "AttributeNameID", 0, NULL, BLOB)
simpleAttribute(`  s', AttributeFormat, 5, "AttributeFormat", 0, NULL, UINT32)
simpleAttribute(`  s', IndexType, 3, "IndexType", 0, NULL, UINT32)

divert(-1)
startClass(Generic)
attribute(`  i', CreationDate, kSecCreationDateItemAttr, "CreationDate", 0, NULL, TIME_DATE)
attribute(`  i', ModDate, kSecModDateItemAttr, "ModDate", 0, NULL, TIME_DATE)
attribute(`  i', Description, kSecDescriptionItemAttr, "Description", 0, NULL, BLOB)
attribute(`  i', Comment, kSecCommentItemAttr, "Comment", 0, NULL, BLOB)
attribute(`  i', Creator, kSecCreatorItemAttr, "Creator", 0, NULL, UINT32)
attribute(`  i', Type, kSecTypeItemAttr, "Type", 0, NULL, UINT32)
attribute(`  i', ScriptCode, kSecScriptCodeItemAttr, "ScriptCode", 0, NULL, SINT32)
attribute(`  s', PrintName, kSecLabelItemAttr, "PrintName", 0, NULL, BLOB)
attribute(`  s', Alias, kSecAliasItemAttr, "Alias", 0, NULL, BLOB)
attribute(`  i', Invisible, kSecInvisibleItemAttr, "Invisible", 0, NULL, SINT32)
attribute(`  i', Negative, kSecNegativeItemAttr, "Negative", 0, NULL, SINT32)
attribute(`  i', CustomIcon, kSecCustomIconItemAttr, "CustomIcon", 0, NULL, SINT32)
attribute(`  i', Protected, kSecProtectedDataItemAttr, "Protected", 0, NULL, BLOB)
attribute(`UIi', Account, kSecAccountItemAttr, "Account", 0, NULL, BLOB)
attribute(`UIi', Service, kSecServiceItemAttr, "Service", 0, NULL, BLOB)
attribute(`  i', Generic, kSecGenericItemAttr, "Generic", 0, NULL, BLOB)
endClass()

startClass(Appleshare)
attribute(`  i', CreationDate, kSecCreationDateItemAttr, "CreationDate", 0, NULL, TIME_DATE)
attribute(`  i', ModDate, kSecModDateItemAttr, "ModDate", 0, NULL, TIME_DATE)
attribute(`  i', Description, kSecDescriptionItemAttr, "Description", 0, NULL, BLOB)
attribute(`  i', Comment, kSecCommentItemAttr, "Comment", 0, NULL, BLOB)
attribute(`  i', Creator, kSecCreatorItemAttr, "Creator", 0, NULL, UINT32)
attribute(`  i', Type, kSecTypeItemAttr, "Type", 0, NULL, UINT32)
attribute(`  i', ScriptCode, kSecScriptCodeItemAttr, "ScriptCode", 0, NULL, SINT32)
attribute(`  s', PrintName, kSecLabelItemAttr, "PrintName", 0, NULL, BLOB)
attribute(`  s', Alias, kSecAliasItemAttr, "Alias", 0, NULL, BLOB)
attribute(`  i', Invisible, kSecInvisibleItemAttr, "Invisible", 0, NULL, SINT32)
attribute(`  i', Negative, kSecNegativeItemAttr, "Negative", 0, NULL, SINT32)
attribute(`  i', CustomIcon, kSecCustomIconItemAttr, "CustomIcon", 0, NULL, SINT32)
attribute(`  i', Protected, kSecProtectedDataItemAttr, "Protected", 0, NULL, BLOB)
attribute(`UIi', Account, kSecAccountItemAttr, "Account", 0, NULL, BLOB)
attribute(`UIi', Volume, kSecVolumeItemAttr, "Volume", 0, NULL, BLOB)
attribute(`  i', Server, kSecServerItemAttr, "Server", 0, NULL, BLOB)
attribute(`  i', Protocol, kSecProtocolItemAttr, "Protocol", 0, NULL, UINT32)
attribute(`UIi', Address, kSecAddressItemAttr, "Address", 0, NULL, BLOB)
attribute(`UIi', Signature, kSecSignatureItemAttr, "Signature", 0, NULL, BLOB)
endClass()

startClass(Internet)
attribute(`  i', CreationDate, kSecCreationDateItemAttr, "CreationDate", 0, NULL, TIME_DATE)
attribute(`  i', ModDate, kSecModDateItemAttr, "ModDate", 0, NULL, TIME_DATE)
attribute(`  i', Description, kSecDescriptionItemAttr, "Description", 0, NULL, BLOB)
attribute(`  i', Comment, kSecCommentItemAttr, "Comment", 0, NULL, BLOB)
attribute(`  i', Creator, kSecCreatorItemAttr, "Creator", 0, NULL, UINT32)
attribute(`  i', Type, kSecTypeItemAttr, "Type", 0, NULL, UINT32)
attribute(`  i', ScriptCode, kSecScriptCodeItemAttr, "ScriptCode", 0, NULL, SINT32)
attribute(`  s', PrintName, kSecLabelItemAttr, "PrintName", 0, NULL, BLOB)
attribute(`  s', Alias, kSecAliasItemAttr, "Alias", 0, NULL, BLOB)
attribute(`  i', Invisible, kSecInvisibleItemAttr, "Invisible", 0, NULL, SINT32)
attribute(`  i', Negative, kSecNegativeItemAttr, "Negative", 0, NULL, SINT32)
attribute(`  i', CustomIcon, kSecCustomIconItemAttr, "CustomIcon", 0, NULL, SINT32)
attribute(`  i', Protected, kSecProtectedDataItemAttr, "Protected", 0, NULL, BLOB)
attribute(`UIi', Account, kSecAccountItemAttr, "Account", 0, NULL, BLOB)
attribute(`UIi', SecurityDomain, kSecSecurityDomainItemAttr, "SecurityDomain", 0, NULL, BLOB)
attribute(`UIi', Server, kSecServerItemAttr, "Server", 0, NULL, BLOB)
attribute(`UIi', Protocol, kSecProtocolItemAttr, "Protocol", 0, NULL, UINT32)
attribute(`UIi', AuthType, kSecAuthTypeItemAttr, "AuthType", 0, NULL, BLOB)
attribute(`UIi', Port, kSecPortItemAttr, "Port", 0, NULL, UINT32)
attribute(`UIi', Path, kSecPathItemAttr, "Path", 0, NULL, BLOB)
endClass()

divert(3)
static const CSSM_DB_RECORD_ATTRIBUTE_INFO Attributes[] =
{
    attrInfo(CSSM_DL_DB_RECORD_GENERIC_PASSWORD, Generic),
    attrInfo(CSSM_DL_DB_RECORD_APPLESHARE_PASSWORD, Appleshare),
    attrInfo(CSSM_DL_DB_RECORD_INTERNET_PASSWORD, Internet)
};

static const CSSM_DB_RECORD_INDEX_INFO Indices[] =
{
    indexInfo(CSSM_DL_DB_RECORD_GENERIC_PASSWORD, Generic),
    indexInfo(CSSM_DL_DB_RECORD_APPLESHARE_PASSWORD, Appleshare),
    indexInfo(CSSM_DL_DB_RECORD_INTERNET_PASSWORD, Internet)
};

static const CSSM_DB_PARSING_MODULE_INFO ParseInfos[] =
{
    parseInfo(),
    parseInfo(),
    parseInfo()
};

//
// Public stuff
//
const CSSM_DBINFO DBInfo =
{
    sizeof(Attributes) / sizeof(CSSM_DB_RECORD_ATTRIBUTE_INFO),
    const_cast<CSSM_DB_PARSING_MODULE_INFO_PTR>(ParseInfos),
    const_cast<CSSM_DB_RECORD_ATTRIBUTE_INFO_PTR>(Attributes),
    const_cast<CSSM_DB_RECORD_INDEX_INFO_PTR>(Indices),
    CSSM_TRUE,
    NULL,
    NULL
};

//
// Schema methods
//
CSSM_DB_RECORDTYPE
recordTypeFor(SecItemClass itemClass)
{
    switch (itemClass)
    {
    case kSecGenericPasswordItemClass: return CSSM_DL_DB_RECORD_GENERIC_PASSWORD;
    case kSecInternetPasswordItemClass: return CSSM_DL_DB_RECORD_INTERNET_PASSWORD;
    case kSecAppleSharePasswordItemClass: return CSSM_DL_DB_RECORD_APPLESHARE_PASSWORD;
    default: MacOSError::throwMe(errSecNoSuchClass);
    }
}

SecItemClass
itemClassFor(CSSM_DB_RECORDTYPE recordType)
{
    switch (recordType)
    {
    case CSSM_DL_DB_RECORD_GENERIC_PASSWORD: return kSecGenericPasswordItemClass;
    case CSSM_DL_DB_RECORD_INTERNET_PASSWORD: return kSecInternetPasswordItemClass;
    case CSSM_DL_DB_RECORD_APPLESHARE_PASSWORD: return kSecAppleSharePasswordItemClass;
    default: return 0; // MacOSError::throwMe(errSecNoSuchClass);
    }
}

const CSSM_DB_ATTRIBUTE_INFO &
attributeInfo(SecKeychainAttrType attrType)
{
    switch (attrType) 
    {
    case kSecCreationDateItemAttr: return kGenericCreationDate;
    case kSecModDateItemAttr: return kGenericModDate;
    case kSecDescriptionItemAttr: return kGenericDescription;
    case kSecCommentItemAttr: return kGenericComment;
    case kSecCreatorItemAttr: return kGenericCreator;
    case kSecTypeItemAttr: return kGenericType;
    case kSecScriptCodeItemAttr: return kGenericScriptCode;
    case kSecLabelItemAttr: return kGenericPrintName;
    case kSecAliasItemAttr: return kGenericAlias;
    case kSecInvisibleItemAttr: return kGenericInvisible;
    case kSecNegativeItemAttr: return kGenericNegative;
    case kSecCustomIconItemAttr: return kGenericCustomIcon;
    /* Unique Generic password attributes */
    case kSecAccountItemAttr: return kGenericAccount;
    case kSecServiceItemAttr: return kGenericService;
    case kSecGenericItemAttr: return kGenericGeneric;
    /* Unique Appleshare password attributes */
    case kSecVolumeItemAttr: return kAppleshareVolume;
    case kSecAddressItemAttr: return kAppleshareAddress;
    case kSecSignatureItemAttr: return kAppleshareSignature;
    /* Unique AppleShare and Internet attributes */
    case kSecServerItemAttr: return kAppleshareServer;
    case kSecProtocolItemAttr: return kAppleshareProtocol;
    /* Unique Internet password attributes */
    case kSecSecurityDomainItemAttr: return kInternetSecurityDomain;
    case kSecAuthTypeItemAttr: return kInternetAuthType;
    case kSecPortItemAttr: return kInternetPort;
    case kSecPathItemAttr: return kInternetPath;
    default: MacOSError::throwMe(errSecNoSuchAttr); // @@@ Not really but whatever.
    }
}

} // end namespace Schema

} // end namespace KeychainCore

} // end namespace Security
