/*
 * Copyright (c) 2000-2001 Apple Computer, Inc. All Rights Reserved.
 * 
 * The contents of this file constitute Original Code as defined in and are
 * subject to the Apple Public Source License Version 1.2 (the 'License').
 * You may not use this file except in compliance with the License. Please obtain
 * a copy of the License at http://www.apple.com/publicsource and read it before
 * using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS
 * OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see the License for the
 * specific language governing rights and limitations under the License.
 */


/*
 *    tbl.c
 *
 *    "TBL" ASN.1 module encode/decode/print/free C src.
 *
 *    This file was generated by snacc on Thu Jun  8 12:35:09 2000
 *
 *    UBC snacc written by Mike Sample
 *
 *    NOTE: This is a machine generated file - editing not recommended
 */



#include "asn-incl.h"
#include "tbl.h"


AsnLen
BEncTBLRangeContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLRange *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    itemLen = BEncAsnIntContent (b, (&v->to));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 1);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->from));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLRangeContent */




AsnLen
BEncTBLNamedNumberContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLNamedNumber *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    itemLen = BEncAsnIntContent (b, (&v->value));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 1);

    totalLen += itemLen;

    itemLen = BEncPrintableStringContent (b, (&v->name));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLNamedNumberContent */




AsnLen
BEncTBLNamedNumberListContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLNamedNumberList *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLNamedNumberContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLNamedNumberListContent */




AsnLen
BEncTBLTypeRefContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeRef *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    itemLen = BEncAsnBoolContent (b, (&v->implicit));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 1);

    totalLen += itemLen;

    itemLen = BEncTBLTypeDefIdContent (b, (&v->typeDef));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLTypeRefContent */




AsnLen
BEncTBLTagContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTag *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    itemLen = BEncAsnIntContent (b, (&v->code));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncTBLTagClassContent (b, (&v->tclass));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 10);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLTagContent */




AsnLen
BEncTBLTypeSeqOfContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeSeqOf *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLTagContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLTypeSeqOfContent */




AsnLen
BEncTBLTypeContentSeqOfContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeContentSeqOf *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLTypeContentSeqOfContent */




AsnLen
BEncTBLTypeContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLType *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    if (NOT_NULL ((v->values)))
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLNamedNumberListContent (b, (v->values));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 6);

    totalLen += itemLen;
    }

    if (NOT_NULL ((v->constraint)))
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLRangeContent (b, (v->constraint));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 5);

    totalLen += itemLen;
    }

    if (ASNOCTS_PRESENT ((&v->fieldName)))
    {
    itemLen = BEncPrintableStringContent (b, (&v->fieldName));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 4);

    totalLen += itemLen;
    }

    BEncEocIfNec (b);
    itemLen = BEncTBLTypeContentContent (b, (v->content));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 3);

    totalLen += itemLen;

    if (NOT_NULL ((v->tagList)))
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeSeqOfContent (b, (v->tagList));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 2);

    totalLen += itemLen;
    }

    itemLen = BEncAsnBoolContent (b, (&v->optional));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 1);

    totalLen += itemLen;

    itemLen = BEncTBLTypeIdContent (b, (&v->typeId));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLTypeContent */




AsnLen
BEncTBLTypeContentContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeContent *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    switch (v->choiceId)
    {
       case TBLTYPECONTENT_PRIMTYPE:
    itemLen = BEncAsnNullContent (b, (&v->a.primType));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    break;

       case TBLTYPECONTENT_ELMTS:
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeContentSeqOfContent (b, (v->a.elmts));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 1);

    totalLen += itemLen;

    break;

       case TBLTYPECONTENT_TYPEREF:
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeRefContent (b, (v->a.typeRef));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 2);

    totalLen += itemLen;

    break;

    }
    return totalLen;

}  /* BEncTBLTypeContentContent */




AsnLen
BEncTBLTypeDefContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeDef *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    if (NOT_NULL ((v->isPdu)))
    {
    itemLen = BEncAsnNullContent (b, (v->isPdu));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 5);

    totalLen += itemLen;
    }

    BEncEocIfNec (b);
    itemLen = BEncTBLTypeContent (b, (v->type));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

    totalLen += itemLen;

    itemLen = BEncPrintableStringContent (b, (&v->typeName));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, PRIM, 19);

    totalLen += itemLen;

    itemLen = BEncTBLTypeDefIdContent (b, (&v->typeDefId));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLTypeDefContent */




AsnLen
BEncTBLModuleSeqOfContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLModuleSeqOf *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeDefContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLModuleSeqOfContent */




AsnLen
BEncTBLModuleContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLModule *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    BEncEocIfNec (b);
    itemLen = BEncTBLModuleSeqOfContent (b, (v->typeDefs));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 3);

    totalLen += itemLen;

    itemLen = BEncAsnBoolContent (b, (&v->isUseful));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 2);

    totalLen += itemLen;

    if (ASNOID_PRESENT ((&v->id)))
    {
    itemLen = BEncAsnOidContent (b, (&v->id));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 1);

    totalLen += itemLen;
    }

    itemLen = BEncPrintableStringContent (b, (&v->name));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLModuleContent */




AsnLen
BEncTBLSeqOfContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLSeqOf *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLModuleContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLSeqOfContent */




AsnLen BEncTBL PARAMS ((b, v),
BUF_TYPE b _AND_
TBL *v)
{
    AsnLen l;
    BEncEocIfNec (b);
    l = BEncTBLContent (b, v);
    l += BEncConsLen (b, l);
    l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
    return l;
} /* BEncTBL */

AsnLen
BEncTBLContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBL *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    BEncEocIfNec (b);
    itemLen = BEncTBLSeqOfContent (b, (v->modules));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalLenStrings));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumStrings));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumTags));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumTypes));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumTypeDefs));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumModules));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLContent */




