//   NOTE: this is a machine generated file--editing not recommended
//
// sm_x509ce.cpp - class member functions for ASN.1 module CertificateExtensions
//
//   This file was generated by snacc on Wed Jun 27 16:40:55 2001
//   UBC snacc written by Mike Sample
//   A couple of enhancements made by IBM European Networking Center


#include "asn-incl.h"
#include "sm_vdatypes.h"
#include "sm_x501ud.h"
#include "sm_x411ub.h"
#include "sm_x411mtsas.h"
#include "sm_x501if.h"
#include "sm_x520sa.h"
#include "sm_x509cmn.h"
#include "sm_x509af.h"
#include "sm_x509ce.h"
#include "pkcs1oids.h"
#include "pkcs9oids.h"
#include "sm_cms.h"
#include "sm_ess.h"
#include "pkcs7.h"
#include "pkcs8.h"
#include "appleoids.h"

//------------------------------------------------------------------------------
// value defs


//------------------------------------------------------------------------------
// class member definitions:

PolicyQualifierInfo::PolicyQualifierInfo()
{
  qualifier = NULL;
}

PolicyQualifierInfo::PolicyQualifierInfo (const PolicyQualifierInfo &)
{
  Asn1Error << "use of incompletely defined PolicyQualifierInfo::PolicyQualifierInfo (const PolicyQualifierInfo &)" << endl;
  abort();
}

PolicyQualifierInfo::~PolicyQualifierInfo()
{
  delete qualifier;
}

AsnType *PolicyQualifierInfo::Clone() const
{
  return new PolicyQualifierInfo;
}

AsnType *PolicyQualifierInfo::Copy() const
{
  return new PolicyQualifierInfo (*this);
}

#if SNACC_DEEP_COPY
PolicyQualifierInfo &PolicyQualifierInfo::operator = (const PolicyQualifierInfo &that)
#else // SNACC_DEEP_COPY
PolicyQualifierInfo &PolicyQualifierInfo::operator = (const PolicyQualifierInfo &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    policyQualifierId = that.policyQualifierId;
    if (that.qualifier)
    {
      if (!qualifier)
        qualifier = new AsnAny;
      *qualifier = *that.qualifier;
    }
    else
    {
      delete qualifier;
      qualifier = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined PolicyQualifierInfo &PolicyQualifierInfo::operator = (const PolicyQualifierInfo &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
PolicyQualifierInfo::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (qualifier))
  {
        ENC_LOAD_ANYBUF(qualifier, b, l);
    totalLen += l;
  }

    l = policyQualifierId.BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, OID_TAG_CODE);
    totalLen += l;

  return totalLen;
} // PolicyQualifierInfo::BEncContent


void PolicyQualifierInfo::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  tag1 = BDecTag (b, seqBytesDecoded, env);

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    policyQualifierId.BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = b.PeekByte();

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDecEoc (b, seqBytesDecoded, env);

        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -100);
  }

  // ANY type
    qualifier = new AsnAny;
        DEC_LOAD_ANYBUF(qualifier, b, seqBytesDecoded, env);


  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -101);
  }
  else
    return;
} // PolicyQualifierInfo::BDecContent

AsnLen PolicyQualifierInfo::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void PolicyQualifierInfo::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "PolicyQualifierInfo::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -102);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int PolicyQualifierInfo::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int PolicyQualifierInfo::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void PolicyQualifierInfo::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  {
    Indent (os, indentG);
    os << "policyQualifierId ";
    os << policyQualifierId;
    os << "," << endl;
  }

  if (NOT_NULL (qualifier))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "qualifier ";
    os << *qualifier;
  }
  else
  {
    Indent (os, indentG);
    os << "qualifier ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // PolicyQualifierInfo::Print


AsnType *AttributesSyntax::Clone() const
{
  return new AttributesSyntax;
}

AsnType *AttributesSyntax::Copy() const
{
  return new AttributesSyntax (*this);
}

AsnLen AttributesSyntax::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void AttributesSyntax::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "AttributesSyntax::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -103);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

AttributesSyntax::AttributesSyntax (const AttributesSyntax &)
{
  Asn1Error << "use of incompletely defined AttributesSyntax::AttributesSyntax (const AttributesSyntax &)" << endl;
  abort();
}

AttributesSyntax::~AttributesSyntax()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
AttributesSyntax &AttributesSyntax::operator = (const AttributesSyntax &that)
#else // SNACC_DEEP_COPY
AttributesSyntax &AttributesSyntax::operator = (const AttributesSyntax &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined AttributesSyntax &AttributesSyntax::operator = (const AttributesSyntax &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void AttributesSyntax::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  AttributesSyntax::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // AttributesSyntax::SetCurrElmt


unsigned long int  AttributesSyntax::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // AttributesSyntax::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
Attribute *AttributesSyntax::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new Attribute;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // AttributesSyntax::Append


// alloc new list elmt, put at begining of list
//  and return the component type
Attribute  *AttributesSyntax::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new Attribute;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // AttributesSyntax::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
Attribute  *AttributesSyntax::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new Attribute;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // AttributesSyntax::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
Attribute *AttributesSyntax::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new Attribute;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // AttributesSyntax::InsertAfter


AttributesSyntax  &AttributesSyntax::AppendCopy (Attribute &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new Attribute;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


AttributesSyntax  &AttributesSyntax::PrependCopy (Attribute &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new Attribute;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // AttributesSyntax::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
AttributesSyntax &AttributesSyntax::InsertBeforeAndCopy (Attribute &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new Attribute;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // AttributesSyntax::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
AttributesSyntax  &AttributesSyntax::InsertAfterAndCopy (Attribute &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new Attribute;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // AttributesSyntax::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void AttributesSyntax::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen AttributesSyntax::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
      BEncEocIfNec (b);
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncConsLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // AttributesSyntax::BEncContent


void  AttributesSyntax::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    Attribute *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -104);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // AttributesSyntax::BDecContent


DistributionPointName::DistributionPointName()
{
  choiceId = fullNameCid;
#if TCL
  fullName = new GeneralNames;
#else
  fullName = NULL; // incomplete initialization of mandatory element!
#endif // TCL
}

DistributionPointName::DistributionPointName (const DistributionPointName &)
{
  Asn1Error << "use of incompletely defined DistributionPointName::DistributionPointName (const DistributionPointName &)" << endl;
  abort();
}

DistributionPointName::~DistributionPointName()
{
  switch (choiceId)
  {
    case fullNameCid:
      delete fullName;
      break;
    case nameRelativeToCRLIssuerCid:
      delete nameRelativeToCRLIssuer;
      break;
  } // end of switch
} // end of destructor

AsnType *DistributionPointName::Clone() const
{
  return new DistributionPointName;
}

AsnType *DistributionPointName::Copy() const
{
  return new DistributionPointName (*this);
}

#if SNACC_DEEP_COPY
DistributionPointName &DistributionPointName::operator = (const DistributionPointName &that)
#else // SNACC_DEEP_COPY
DistributionPointName &DistributionPointName::operator = (const DistributionPointName &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    switch (choiceId)
    {
      case fullNameCid:
        delete fullName;
        break;
      case nameRelativeToCRLIssuerCid:
        delete nameRelativeToCRLIssuer;
        break;
    }
    switch (choiceId = that.choiceId)
    {
      case fullNameCid:
        fullName = new GeneralNames;
        *fullName = *that.fullName;
        break;
      case nameRelativeToCRLIssuerCid:
        nameRelativeToCRLIssuer = new RelativeDistinguishedName;
        *nameRelativeToCRLIssuer = *that.nameRelativeToCRLIssuer;
        break;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined DistributionPointName &DistributionPointName::operator = (const DistributionPointName &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
DistributionPointName::BEncContent (BUF_TYPE b)
{
  AsnLen l;
  switch (choiceId)
  {
    case fullNameCid:
      BEncEocIfNec (b);
      l = fullName->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 0);
      break;

    case nameRelativeToCRLIssuerCid:
      BEncEocIfNec (b);
      l = nameRelativeToCRLIssuer->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 1);
      break;

  } // end switch
  return l;
} // DistributionPointName::BEncContent


void DistributionPointName::BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  switch (tag)
  {
    case MAKE_TAG_ID (CNTX, CONS, 0):
      choiceId = fullNameCid;
      fullName = new GeneralNames;
        fullName->BDecContent (b, tag, elmtLen0, bytesDecoded, env);
      break;

    case MAKE_TAG_ID (CNTX, CONS, 1):
      choiceId = nameRelativeToCRLIssuerCid;
      nameRelativeToCRLIssuer = new RelativeDistinguishedName;
        nameRelativeToCRLIssuer->BDecContent (b, tag, elmtLen0, bytesDecoded, env);
      break;

    default:
      Asn1Error << "ERROR - unexpected tag in CHOICE" << endl;
      longjmp (env, -105);
      break;
  } // end switch
} // DistributionPointName::BDecContent


AsnLen DistributionPointName::BEnc (BUF_TYPE b)
{
    AsnLen l;
    l = BEncContent (b);
    return l;
}

void DistributionPointName::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
    AsnLen elmtLen;
    AsnTag tag;

    /*  CHOICEs are a special case - grab identifying tag */
    /*  this allows easier handling of nested CHOICEs */
    tag = BDecTag (b, bytesDecoded, env);
    elmtLen = BDecLen (b, bytesDecoded, env);
    BDecContent (b, tag, elmtLen, bytesDecoded, env);
}

int DistributionPointName::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int DistributionPointName::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void DistributionPointName::Print (ostream &os) const
{
#ifndef NDEBUG
  switch (choiceId)
  {
    case fullNameCid:
      os << "fullName ";
      if (fullName)
        os << *fullName;
      else
        os << "-- void3 --\n";
      break;

    case nameRelativeToCRLIssuerCid:
      os << "nameRelativeToCRLIssuer ";
      if (nameRelativeToCRLIssuer)
        os << *nameRelativeToCRLIssuer;
      else
        os << "-- void3 --\n";
      break;

  } // end of switch
#endif /* NDEBUG */
} // DistributionPointName::Print

PolicyMappingsSyntaxSeq::PolicyMappingsSyntaxSeq()
{
}

PolicyMappingsSyntaxSeq::PolicyMappingsSyntaxSeq (const PolicyMappingsSyntaxSeq &)
{
  Asn1Error << "use of incompletely defined PolicyMappingsSyntaxSeq::PolicyMappingsSyntaxSeq (const PolicyMappingsSyntaxSeq &)" << endl;
  abort();
}

PolicyMappingsSyntaxSeq::~PolicyMappingsSyntaxSeq()
{
}

AsnType *PolicyMappingsSyntaxSeq::Clone() const
{
  return new PolicyMappingsSyntaxSeq;
}

AsnType *PolicyMappingsSyntaxSeq::Copy() const
{
  return new PolicyMappingsSyntaxSeq (*this);
}

#if SNACC_DEEP_COPY
PolicyMappingsSyntaxSeq &PolicyMappingsSyntaxSeq::operator = (const PolicyMappingsSyntaxSeq &that)
#else // SNACC_DEEP_COPY
PolicyMappingsSyntaxSeq &PolicyMappingsSyntaxSeq::operator = (const PolicyMappingsSyntaxSeq &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    issuerDomainPolicy = that.issuerDomainPolicy;
    subjectDomainPolicy = that.subjectDomainPolicy;
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined PolicyMappingsSyntaxSeq &PolicyMappingsSyntaxSeq::operator = (const PolicyMappingsSyntaxSeq &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
PolicyMappingsSyntaxSeq::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

    l = subjectDomainPolicy.BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, OID_TAG_CODE);
    totalLen += l;

    l = issuerDomainPolicy.BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, OID_TAG_CODE);
    totalLen += l;

  return totalLen;
} // PolicyMappingsSyntaxSeq::BEncContent


void PolicyMappingsSyntaxSeq::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  tag1 = BDecTag (b, seqBytesDecoded, env);

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    issuerDomainPolicy.BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    tag1 = BDecTag (b, seqBytesDecoded, env);
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -106);
  }

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    subjectDomainPolicy.BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -107);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -108);
  }
  else
    return;
} // PolicyMappingsSyntaxSeq::BDecContent

AsnLen PolicyMappingsSyntaxSeq::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void PolicyMappingsSyntaxSeq::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "PolicyMappingsSyntaxSeq::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -109);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int PolicyMappingsSyntaxSeq::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int PolicyMappingsSyntaxSeq::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void PolicyMappingsSyntaxSeq::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  {
    Indent (os, indentG);
    os << "issuerDomainPolicy ";
    os << issuerDomainPolicy;
    os << "," << endl;
  }

  {
    Indent (os, indentG);
    os << "subjectDomainPolicy ";
    os << subjectDomainPolicy;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // PolicyMappingsSyntaxSeq::Print


AsnType *PolicyInformationSeqOf::Clone() const
{
  return new PolicyInformationSeqOf;
}

AsnType *PolicyInformationSeqOf::Copy() const
{
  return new PolicyInformationSeqOf (*this);
}

AsnLen PolicyInformationSeqOf::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void PolicyInformationSeqOf::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "PolicyInformationSeqOf::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -110);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

PolicyInformationSeqOf::PolicyInformationSeqOf (const PolicyInformationSeqOf &)
{
  Asn1Error << "use of incompletely defined PolicyInformationSeqOf::PolicyInformationSeqOf (const PolicyInformationSeqOf &)" << endl;
  abort();
}

PolicyInformationSeqOf::~PolicyInformationSeqOf()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
PolicyInformationSeqOf &PolicyInformationSeqOf::operator = (const PolicyInformationSeqOf &that)
#else // SNACC_DEEP_COPY
PolicyInformationSeqOf &PolicyInformationSeqOf::operator = (const PolicyInformationSeqOf &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined PolicyInformationSeqOf &PolicyInformationSeqOf::operator = (const PolicyInformationSeqOf &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void PolicyInformationSeqOf::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  PolicyInformationSeqOf::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // PolicyInformationSeqOf::SetCurrElmt


unsigned long int  PolicyInformationSeqOf::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // PolicyInformationSeqOf::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
PolicyQualifierInfo *PolicyInformationSeqOf::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new PolicyQualifierInfo;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // PolicyInformationSeqOf::Append


// alloc new list elmt, put at begining of list
//  and return the component type
PolicyQualifierInfo  *PolicyInformationSeqOf::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyQualifierInfo;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // PolicyInformationSeqOf::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
PolicyQualifierInfo  *PolicyInformationSeqOf::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyQualifierInfo;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // PolicyInformationSeqOf::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
PolicyQualifierInfo *PolicyInformationSeqOf::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyQualifierInfo;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // PolicyInformationSeqOf::InsertAfter


PolicyInformationSeqOf  &PolicyInformationSeqOf::AppendCopy (PolicyQualifierInfo &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyQualifierInfo;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


PolicyInformationSeqOf  &PolicyInformationSeqOf::PrependCopy (PolicyQualifierInfo &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyQualifierInfo;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // PolicyInformationSeqOf::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
PolicyInformationSeqOf &PolicyInformationSeqOf::InsertBeforeAndCopy (PolicyQualifierInfo &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyQualifierInfo;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // PolicyInformationSeqOf::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
PolicyInformationSeqOf  &PolicyInformationSeqOf::InsertAfterAndCopy (PolicyQualifierInfo &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyQualifierInfo;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // PolicyInformationSeqOf::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void PolicyInformationSeqOf::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen PolicyInformationSeqOf::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
      BEncEocIfNec (b);
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncConsLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // PolicyInformationSeqOf::BEncContent


void  PolicyInformationSeqOf::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    PolicyQualifierInfo *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -111);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // PolicyInformationSeqOf::BDecContent


PolicyInformation::PolicyInformation()
{
  policyQualifiers = NULL;
}

PolicyInformation::PolicyInformation (const PolicyInformation &)
{
  Asn1Error << "use of incompletely defined PolicyInformation::PolicyInformation (const PolicyInformation &)" << endl;
  abort();
}

PolicyInformation::~PolicyInformation()
{
  delete policyQualifiers;
}

AsnType *PolicyInformation::Clone() const
{
  return new PolicyInformation;
}

AsnType *PolicyInformation::Copy() const
{
  return new PolicyInformation (*this);
}

#if SNACC_DEEP_COPY
PolicyInformation &PolicyInformation::operator = (const PolicyInformation &that)
#else // SNACC_DEEP_COPY
PolicyInformation &PolicyInformation::operator = (const PolicyInformation &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    policyIdentifier = that.policyIdentifier;
    if (that.policyQualifiers)
    {
      if (!policyQualifiers)
        policyQualifiers = new PolicyInformationSeqOf;
      *policyQualifiers = *that.policyQualifiers;
    }
    else
    {
      delete policyQualifiers;
      policyQualifiers = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined PolicyInformation &PolicyInformation::operator = (const PolicyInformation &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
PolicyInformation::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (policyQualifiers))
  {
      BEncEocIfNec (b);
    l = policyQualifiers->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
    totalLen += l;
  }

    l = policyIdentifier.BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, UNIV, PRIM, OID_TAG_CODE);
    totalLen += l;

  return totalLen;
} // PolicyInformation::BEncContent


void PolicyInformation::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  tag1 = BDecTag (b, seqBytesDecoded, env);

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    policyIdentifier.BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -112);
  }

  if ((tag1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    policyQualifiers = new PolicyInformationSeqOf;
    policyQualifiers->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -113);
  }
  else
    return;
} // PolicyInformation::BDecContent

AsnLen PolicyInformation::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void PolicyInformation::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "PolicyInformation::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -114);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int PolicyInformation::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int PolicyInformation::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void PolicyInformation::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  {
    Indent (os, indentG);
    os << "policyIdentifier ";
    os << policyIdentifier;
    os << "," << endl;
  }

  if (NOT_NULL (policyQualifiers))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "policyQualifiers ";
    os << *policyQualifiers;
  }
  else
  {
    Indent (os, indentG);
    os << "policyQualifiers ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // PolicyInformation::Print


GeneralSubtree::GeneralSubtree()
{
#if TCL
  base = new GeneralName;
#else
  base = NULL; // incomplete initialization of mandatory element!
#endif // TCL
  minimum = NULL;
  maximum = NULL;
}

GeneralSubtree::GeneralSubtree (const GeneralSubtree &)
{
  Asn1Error << "use of incompletely defined GeneralSubtree::GeneralSubtree (const GeneralSubtree &)" << endl;
  abort();
}

GeneralSubtree::~GeneralSubtree()
{
  delete base;
  delete minimum;
  delete maximum;
}

AsnType *GeneralSubtree::Clone() const
{
  return new GeneralSubtree;
}

AsnType *GeneralSubtree::Copy() const
{
  return new GeneralSubtree (*this);
}

#if SNACC_DEEP_COPY
GeneralSubtree &GeneralSubtree::operator = (const GeneralSubtree &that)
#else // SNACC_DEEP_COPY
GeneralSubtree &GeneralSubtree::operator = (const GeneralSubtree &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.base)
    {
      if (!base)
        base = new GeneralName;
      *base = *that.base;
    }
    else
    {
      delete base;
      base = NULL;
    }
    if (that.minimum)
    {
      if (!minimum)
        minimum = new BaseDistance;
      *minimum = *that.minimum;
    }
    else
    {
      delete minimum;
      minimum = NULL;
    }
    if (that.maximum)
    {
      if (!maximum)
        maximum = new BaseDistance;
      *maximum = *that.maximum;
    }
    else
    {
      delete maximum;
      maximum = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined GeneralSubtree &GeneralSubtree::operator = (const GeneralSubtree &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
GeneralSubtree::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (maximum))
  {
    l = maximum->BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, CNTX, PRIM, 1);
    totalLen += l;
  }

  if (NOT_NULL (minimum))
  {
    l = minimum->BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, CNTX, PRIM, 0);
    totalLen += l;
  }

    l = base->BEncContent (b);
    totalLen += l;

  return totalLen;
} // GeneralSubtree::BEncContent


void GeneralSubtree::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  tag1 = BDecTag (b, seqBytesDecoded, env);

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 0))
    || (tag1 == MAKE_TAG_ID (CNTX, PRIM, 1))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 1))
    || (tag1 == MAKE_TAG_ID (CNTX, PRIM, 2))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 2))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 3))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 4))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 5))
    || (tag1 == MAKE_TAG_ID (CNTX, PRIM, 6))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 6))
    || (tag1 == MAKE_TAG_ID (CNTX, PRIM, 7))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 7))
    || (tag1 == MAKE_TAG_ID (CNTX, PRIM, 8)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    base = new GeneralName;
    base->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -115);
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    minimum = new BaseDistance;
    minimum->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    maximum = new BaseDistance;
    maximum->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -116);
  }
  else
    return;
} // GeneralSubtree::BDecContent

AsnLen GeneralSubtree::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void GeneralSubtree::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "GeneralSubtree::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -117);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int GeneralSubtree::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int GeneralSubtree::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void GeneralSubtree::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (base))
  {
    Indent (os, indentG);
    os << "base ";
    os << *base;
  }
  else
  {
    Indent (os, indentG);
    os << "base ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (minimum))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "minimum ";
    os << *minimum;
  }
  else
  {
    Indent (os, indentG);
    os << "minimum ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (maximum))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "maximum ";
    os << *maximum;
  }
  else
  {
    Indent (os, indentG);
    os << "maximum ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // GeneralSubtree::Print


DistributionPoint::DistributionPoint()
{
  distributionPoint = NULL;
  reasons = NULL;
  cRLIssuer = NULL;
}

DistributionPoint::DistributionPoint (const DistributionPoint &)
{
  Asn1Error << "use of incompletely defined DistributionPoint::DistributionPoint (const DistributionPoint &)" << endl;
  abort();
}

DistributionPoint::~DistributionPoint()
{
  delete distributionPoint;
  delete reasons;
  delete cRLIssuer;
}

AsnType *DistributionPoint::Clone() const
{
  return new DistributionPoint;
}

AsnType *DistributionPoint::Copy() const
{
  return new DistributionPoint (*this);
}

#if SNACC_DEEP_COPY
DistributionPoint &DistributionPoint::operator = (const DistributionPoint &that)
#else // SNACC_DEEP_COPY
DistributionPoint &DistributionPoint::operator = (const DistributionPoint &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.distributionPoint)
    {
      if (!distributionPoint)
        distributionPoint = new DistributionPointName;
      *distributionPoint = *that.distributionPoint;
    }
    else
    {
      delete distributionPoint;
      distributionPoint = NULL;
    }
    if (that.reasons)
    {
      if (!reasons)
        reasons = new ReasonFlags;
      *reasons = *that.reasons;
    }
    else
    {
      delete reasons;
      reasons = NULL;
    }
    if (that.cRLIssuer)
    {
      if (!cRLIssuer)
        cRLIssuer = new GeneralNames;
      *cRLIssuer = *that.cRLIssuer;
    }
    else
    {
      delete cRLIssuer;
      cRLIssuer = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined DistributionPoint &DistributionPoint::operator = (const DistributionPoint &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
DistributionPoint::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (cRLIssuer))
  {
      BEncEocIfNec (b);
    l = cRLIssuer->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 2);
    totalLen += l;
  }

  if (NOT_NULL (reasons))
  {
    l = reasons->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 1);
    totalLen += l;
  }

  if (NOT_NULL (distributionPoint))
  {
      BEncEocIfNec (b);
    l = distributionPoint->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 0);
    totalLen += l;
  }

  return totalLen;
} // DistributionPoint::BEncContent


void DistributionPoint::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  AsnLen elmtLen2;
  if (elmtLen0 == 0)
    return;
  else
  {
    tag1 = BDecTag (b, seqBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
      bytesDecoded += seqBytesDecoded;
      return;
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    tag1 = BDecTag (b, seqBytesDecoded, env);
    elmtLen2 = BDecLen (b, seqBytesDecoded, env);
    distributionPoint = new DistributionPointName;
    distributionPoint->BDecContent (b, tag1, elmtLen2, seqBytesDecoded, env);
    if (elmtLen1 == INDEFINITE_LEN)
      BDecEoc (b, seqBytesDecoded, env);

    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 1))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    reasons = new ReasonFlags;
    reasons->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 2)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    cRLIssuer = new GeneralNames;
    cRLIssuer->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -118);
  }
  else
    return;
} // DistributionPoint::BDecContent

AsnLen DistributionPoint::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void DistributionPoint::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "DistributionPoint::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -119);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int DistributionPoint::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int DistributionPoint::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void DistributionPoint::Print (ostream &os) const
{
#ifndef NDEBUG
  int nonePrinted = true;
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (distributionPoint))
  {
    nonePrinted = false;
    Indent (os, indentG);
    os << "distributionPoint ";
    os << *distributionPoint;
  }
  else
  {
    Indent (os, indentG);
    os << "distributionPoint ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (reasons))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "reasons ";
    os << *reasons;
  }
  else
  {
    Indent (os, indentG);
    os << "reasons ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (cRLIssuer))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "cRLIssuer ";
    os << *cRLIssuer;
  }
  else
  {
    Indent (os, indentG);
    os << "cRLIssuer ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // DistributionPoint::Print


AsnType *CertificatePoliciesSyntax::Clone() const
{
  return new CertificatePoliciesSyntax;
}

AsnType *CertificatePoliciesSyntax::Copy() const
{
  return new CertificatePoliciesSyntax (*this);
}

AsnLen CertificatePoliciesSyntax::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void CertificatePoliciesSyntax::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "CertificatePoliciesSyntax::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -120);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

CertificatePoliciesSyntax::CertificatePoliciesSyntax (const CertificatePoliciesSyntax &)
{
  Asn1Error << "use of incompletely defined CertificatePoliciesSyntax::CertificatePoliciesSyntax (const CertificatePoliciesSyntax &)" << endl;
  abort();
}

CertificatePoliciesSyntax::~CertificatePoliciesSyntax()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
CertificatePoliciesSyntax &CertificatePoliciesSyntax::operator = (const CertificatePoliciesSyntax &that)
#else // SNACC_DEEP_COPY
CertificatePoliciesSyntax &CertificatePoliciesSyntax::operator = (const CertificatePoliciesSyntax &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined CertificatePoliciesSyntax &CertificatePoliciesSyntax::operator = (const CertificatePoliciesSyntax &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void CertificatePoliciesSyntax::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  CertificatePoliciesSyntax::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // CertificatePoliciesSyntax::SetCurrElmt


unsigned long int  CertificatePoliciesSyntax::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // CertificatePoliciesSyntax::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
PolicyInformation *CertificatePoliciesSyntax::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new PolicyInformation;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CertificatePoliciesSyntax::Append


// alloc new list elmt, put at begining of list
//  and return the component type
PolicyInformation  *CertificatePoliciesSyntax::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyInformation;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CertificatePoliciesSyntax::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
PolicyInformation  *CertificatePoliciesSyntax::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyInformation;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CertificatePoliciesSyntax::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
PolicyInformation *CertificatePoliciesSyntax::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyInformation;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CertificatePoliciesSyntax::InsertAfter


CertificatePoliciesSyntax  &CertificatePoliciesSyntax::AppendCopy (PolicyInformation &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyInformation;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


CertificatePoliciesSyntax  &CertificatePoliciesSyntax::PrependCopy (PolicyInformation &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyInformation;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // CertificatePoliciesSyntax::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
CertificatePoliciesSyntax &CertificatePoliciesSyntax::InsertBeforeAndCopy (PolicyInformation &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyInformation;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // CertificatePoliciesSyntax::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
CertificatePoliciesSyntax  &CertificatePoliciesSyntax::InsertAfterAndCopy (PolicyInformation &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyInformation;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // CertificatePoliciesSyntax::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void CertificatePoliciesSyntax::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen CertificatePoliciesSyntax::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
      BEncEocIfNec (b);
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncConsLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // CertificatePoliciesSyntax::BEncContent


void  CertificatePoliciesSyntax::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    PolicyInformation *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -121);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // CertificatePoliciesSyntax::BDecContent


AsnType *GeneralSubtrees::Clone() const
{
  return new GeneralSubtrees;
}

AsnType *GeneralSubtrees::Copy() const
{
  return new GeneralSubtrees (*this);
}

AsnLen GeneralSubtrees::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void GeneralSubtrees::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "GeneralSubtrees::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -122);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

GeneralSubtrees::GeneralSubtrees (const GeneralSubtrees &)
{
  Asn1Error << "use of incompletely defined GeneralSubtrees::GeneralSubtrees (const GeneralSubtrees &)" << endl;
  abort();
}

GeneralSubtrees::~GeneralSubtrees()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
GeneralSubtrees &GeneralSubtrees::operator = (const GeneralSubtrees &that)
#else // SNACC_DEEP_COPY
GeneralSubtrees &GeneralSubtrees::operator = (const GeneralSubtrees &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined GeneralSubtrees &GeneralSubtrees::operator = (const GeneralSubtrees &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void GeneralSubtrees::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  GeneralSubtrees::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // GeneralSubtrees::SetCurrElmt


unsigned long int  GeneralSubtrees::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // GeneralSubtrees::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
GeneralSubtree *GeneralSubtrees::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new GeneralSubtree;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // GeneralSubtrees::Append


// alloc new list elmt, put at begining of list
//  and return the component type
GeneralSubtree  *GeneralSubtrees::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new GeneralSubtree;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // GeneralSubtrees::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
GeneralSubtree  *GeneralSubtrees::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new GeneralSubtree;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // GeneralSubtrees::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
GeneralSubtree *GeneralSubtrees::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new GeneralSubtree;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // GeneralSubtrees::InsertAfter


GeneralSubtrees  &GeneralSubtrees::AppendCopy (GeneralSubtree &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new GeneralSubtree;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


GeneralSubtrees  &GeneralSubtrees::PrependCopy (GeneralSubtree &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new GeneralSubtree;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // GeneralSubtrees::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
GeneralSubtrees &GeneralSubtrees::InsertBeforeAndCopy (GeneralSubtree &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new GeneralSubtree;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // GeneralSubtrees::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
GeneralSubtrees  &GeneralSubtrees::InsertAfterAndCopy (GeneralSubtree &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new GeneralSubtree;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // GeneralSubtrees::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void GeneralSubtrees::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen GeneralSubtrees::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
      BEncEocIfNec (b);
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncConsLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // GeneralSubtrees::BEncContent


void  GeneralSubtrees::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    GeneralSubtree *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -123);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // GeneralSubtrees::BDecContent


AuthorityKeyIdentifier::AuthorityKeyIdentifier()
{
  keyIdentifier = NULL;
  authorityCertIssuer = NULL;
  authorityCertSerialNumber = NULL;
}

AuthorityKeyIdentifier::AuthorityKeyIdentifier (const AuthorityKeyIdentifier &)
{
  Asn1Error << "use of incompletely defined AuthorityKeyIdentifier::AuthorityKeyIdentifier (const AuthorityKeyIdentifier &)" << endl;
  abort();
}

AuthorityKeyIdentifier::~AuthorityKeyIdentifier()
{
  delete keyIdentifier;
  delete authorityCertIssuer;
  delete authorityCertSerialNumber;
}

AsnType *AuthorityKeyIdentifier::Clone() const
{
  return new AuthorityKeyIdentifier;
}

AsnType *AuthorityKeyIdentifier::Copy() const
{
  return new AuthorityKeyIdentifier (*this);
}

#if SNACC_DEEP_COPY
AuthorityKeyIdentifier &AuthorityKeyIdentifier::operator = (const AuthorityKeyIdentifier &that)
#else // SNACC_DEEP_COPY
AuthorityKeyIdentifier &AuthorityKeyIdentifier::operator = (const AuthorityKeyIdentifier &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.keyIdentifier)
    {
      if (!keyIdentifier)
        keyIdentifier = new KeyIdentifier;
      *keyIdentifier = *that.keyIdentifier;
    }
    else
    {
      delete keyIdentifier;
      keyIdentifier = NULL;
    }
    if (that.authorityCertIssuer)
    {
      if (!authorityCertIssuer)
        authorityCertIssuer = new GeneralNames;
      *authorityCertIssuer = *that.authorityCertIssuer;
    }
    else
    {
      delete authorityCertIssuer;
      authorityCertIssuer = NULL;
    }
    if (that.authorityCertSerialNumber)
    {
      if (!authorityCertSerialNumber)
        authorityCertSerialNumber = new CertificateSerialNumber;
      *authorityCertSerialNumber = *that.authorityCertSerialNumber;
    }
    else
    {
      delete authorityCertSerialNumber;
      authorityCertSerialNumber = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined AuthorityKeyIdentifier &AuthorityKeyIdentifier::operator = (const AuthorityKeyIdentifier &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
AuthorityKeyIdentifier::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (authorityCertSerialNumber))
  {
    l = authorityCertSerialNumber->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 2);
    totalLen += l;
  }

  if (NOT_NULL (authorityCertIssuer))
  {
      BEncEocIfNec (b);
    l = authorityCertIssuer->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 1);
    totalLen += l;
  }

  if (NOT_NULL (keyIdentifier))
  {
    l = keyIdentifier->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 0);
    totalLen += l;
  }

  return totalLen;
} // AuthorityKeyIdentifier::BEncContent


void AuthorityKeyIdentifier::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  if (elmtLen0 == 0)
    return;
  else
  {
    tag1 = BDecTag (b, seqBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
      bytesDecoded += seqBytesDecoded;
      return;
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 0))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    keyIdentifier = new KeyIdentifier;
    keyIdentifier->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    authorityCertIssuer = new GeneralNames;
    authorityCertIssuer->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 2))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 2)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    authorityCertSerialNumber = new CertificateSerialNumber;
    authorityCertSerialNumber->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -124);
  }
  else
    return;
} // AuthorityKeyIdentifier::BDecContent

AsnLen AuthorityKeyIdentifier::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void AuthorityKeyIdentifier::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "AuthorityKeyIdentifier::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -125);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int AuthorityKeyIdentifier::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int AuthorityKeyIdentifier::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void AuthorityKeyIdentifier::Print (ostream &os) const
{
#ifndef NDEBUG
  int nonePrinted = true;
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (keyIdentifier))
  {
    nonePrinted = false;
    Indent (os, indentG);
    os << "keyIdentifier ";
    os << *keyIdentifier;
  }
  else
  {
    Indent (os, indentG);
    os << "keyIdentifier ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (authorityCertIssuer))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "authorityCertIssuer ";
    os << *authorityCertIssuer;
  }
  else
  {
    Indent (os, indentG);
    os << "authorityCertIssuer ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (authorityCertSerialNumber))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "authorityCertSerialNumber ";
    os << *authorityCertSerialNumber;
  }
  else
  {
    Indent (os, indentG);
    os << "authorityCertSerialNumber ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // AuthorityKeyIdentifier::Print


AsnType *ExtKeyUsageSyntax::Clone() const
{
  return new ExtKeyUsageSyntax;
}

AsnType *ExtKeyUsageSyntax::Copy() const
{
  return new ExtKeyUsageSyntax (*this);
}

AsnLen ExtKeyUsageSyntax::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void ExtKeyUsageSyntax::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "ExtKeyUsageSyntax::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -126);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

ExtKeyUsageSyntax::ExtKeyUsageSyntax (const ExtKeyUsageSyntax &)
{
  Asn1Error << "use of incompletely defined ExtKeyUsageSyntax::ExtKeyUsageSyntax (const ExtKeyUsageSyntax &)" << endl;
  abort();
}

ExtKeyUsageSyntax::~ExtKeyUsageSyntax()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
ExtKeyUsageSyntax &ExtKeyUsageSyntax::operator = (const ExtKeyUsageSyntax &that)
#else // SNACC_DEEP_COPY
ExtKeyUsageSyntax &ExtKeyUsageSyntax::operator = (const ExtKeyUsageSyntax &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined ExtKeyUsageSyntax &ExtKeyUsageSyntax::operator = (const ExtKeyUsageSyntax &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void ExtKeyUsageSyntax::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  ExtKeyUsageSyntax::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // ExtKeyUsageSyntax::SetCurrElmt


unsigned long int  ExtKeyUsageSyntax::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // ExtKeyUsageSyntax::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
KeyPurposeId *ExtKeyUsageSyntax::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new KeyPurposeId;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // ExtKeyUsageSyntax::Append


// alloc new list elmt, put at begining of list
//  and return the component type
KeyPurposeId  *ExtKeyUsageSyntax::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new KeyPurposeId;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // ExtKeyUsageSyntax::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
KeyPurposeId  *ExtKeyUsageSyntax::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new KeyPurposeId;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // ExtKeyUsageSyntax::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
KeyPurposeId *ExtKeyUsageSyntax::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new KeyPurposeId;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // ExtKeyUsageSyntax::InsertAfter


ExtKeyUsageSyntax  &ExtKeyUsageSyntax::AppendCopy (KeyPurposeId &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new KeyPurposeId;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


ExtKeyUsageSyntax  &ExtKeyUsageSyntax::PrependCopy (KeyPurposeId &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new KeyPurposeId;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // ExtKeyUsageSyntax::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
ExtKeyUsageSyntax &ExtKeyUsageSyntax::InsertBeforeAndCopy (KeyPurposeId &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new KeyPurposeId;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // ExtKeyUsageSyntax::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
ExtKeyUsageSyntax  &ExtKeyUsageSyntax::InsertAfterAndCopy (KeyPurposeId &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new KeyPurposeId;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // ExtKeyUsageSyntax::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void ExtKeyUsageSyntax::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen ExtKeyUsageSyntax::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncDefLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, PRIM, OID_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // ExtKeyUsageSyntax::BEncContent


void  ExtKeyUsageSyntax::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    KeyPurposeId *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -127);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // ExtKeyUsageSyntax::BDecContent


PrivateKeyUsagePeriod::PrivateKeyUsagePeriod()
{
  notBefore = NULL;
  notAfter = NULL;
}

PrivateKeyUsagePeriod::PrivateKeyUsagePeriod (const PrivateKeyUsagePeriod &)
{
  Asn1Error << "use of incompletely defined PrivateKeyUsagePeriod::PrivateKeyUsagePeriod (const PrivateKeyUsagePeriod &)" << endl;
  abort();
}

PrivateKeyUsagePeriod::~PrivateKeyUsagePeriod()
{
  delete notBefore;
  delete notAfter;
}

AsnType *PrivateKeyUsagePeriod::Clone() const
{
  return new PrivateKeyUsagePeriod;
}

AsnType *PrivateKeyUsagePeriod::Copy() const
{
  return new PrivateKeyUsagePeriod (*this);
}

#if SNACC_DEEP_COPY
PrivateKeyUsagePeriod &PrivateKeyUsagePeriod::operator = (const PrivateKeyUsagePeriod &that)
#else // SNACC_DEEP_COPY
PrivateKeyUsagePeriod &PrivateKeyUsagePeriod::operator = (const PrivateKeyUsagePeriod &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.notBefore)
    {
      if (!notBefore)
        notBefore = new GeneralizedTime;
      *notBefore = *that.notBefore;
    }
    else
    {
      delete notBefore;
      notBefore = NULL;
    }
    if (that.notAfter)
    {
      if (!notAfter)
        notAfter = new GeneralizedTime;
      *notAfter = *that.notAfter;
    }
    else
    {
      delete notAfter;
      notAfter = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined PrivateKeyUsagePeriod &PrivateKeyUsagePeriod::operator = (const PrivateKeyUsagePeriod &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
PrivateKeyUsagePeriod::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (notAfter))
  {
    l = notAfter->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 1);
    totalLen += l;
  }

  if (NOT_NULL (notBefore))
  {
    l = notBefore->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 0);
    totalLen += l;
  }

  return totalLen;
} // PrivateKeyUsagePeriod::BEncContent


void PrivateKeyUsagePeriod::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  if (elmtLen0 == 0)
    return;
  else
  {
    tag1 = BDecTag (b, seqBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
      bytesDecoded += seqBytesDecoded;
      return;
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 0))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    notBefore = new GeneralizedTime;
    notBefore->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 1))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    notAfter = new GeneralizedTime;
    notAfter->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -128);
  }
  else
    return;
} // PrivateKeyUsagePeriod::BDecContent

AsnLen PrivateKeyUsagePeriod::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void PrivateKeyUsagePeriod::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "PrivateKeyUsagePeriod::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -129);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int PrivateKeyUsagePeriod::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int PrivateKeyUsagePeriod::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void PrivateKeyUsagePeriod::Print (ostream &os) const
{
#ifndef NDEBUG
  int nonePrinted = true;
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (notBefore))
  {
    nonePrinted = false;
    Indent (os, indentG);
    os << "notBefore ";
    os << *notBefore;
  }
  else
  {
    Indent (os, indentG);
    os << "notBefore ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (notAfter))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "notAfter ";
    os << *notAfter;
  }
  else
  {
    Indent (os, indentG);
    os << "notAfter ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // PrivateKeyUsagePeriod::Print


AsnType *PolicyMappingsSyntax::Clone() const
{
  return new PolicyMappingsSyntax;
}

AsnType *PolicyMappingsSyntax::Copy() const
{
  return new PolicyMappingsSyntax (*this);
}

AsnLen PolicyMappingsSyntax::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void PolicyMappingsSyntax::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "PolicyMappingsSyntax::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -130);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

PolicyMappingsSyntax::PolicyMappingsSyntax (const PolicyMappingsSyntax &)
{
  Asn1Error << "use of incompletely defined PolicyMappingsSyntax::PolicyMappingsSyntax (const PolicyMappingsSyntax &)" << endl;
  abort();
}

PolicyMappingsSyntax::~PolicyMappingsSyntax()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
PolicyMappingsSyntax &PolicyMappingsSyntax::operator = (const PolicyMappingsSyntax &that)
#else // SNACC_DEEP_COPY
PolicyMappingsSyntax &PolicyMappingsSyntax::operator = (const PolicyMappingsSyntax &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined PolicyMappingsSyntax &PolicyMappingsSyntax::operator = (const PolicyMappingsSyntax &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void PolicyMappingsSyntax::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  PolicyMappingsSyntax::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // PolicyMappingsSyntax::SetCurrElmt


unsigned long int  PolicyMappingsSyntax::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // PolicyMappingsSyntax::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
PolicyMappingsSyntaxSeq *PolicyMappingsSyntax::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new PolicyMappingsSyntaxSeq;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // PolicyMappingsSyntax::Append


// alloc new list elmt, put at begining of list
//  and return the component type
PolicyMappingsSyntaxSeq  *PolicyMappingsSyntax::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyMappingsSyntaxSeq;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // PolicyMappingsSyntax::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
PolicyMappingsSyntaxSeq  *PolicyMappingsSyntax::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyMappingsSyntaxSeq;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // PolicyMappingsSyntax::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
PolicyMappingsSyntaxSeq *PolicyMappingsSyntax::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyMappingsSyntaxSeq;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // PolicyMappingsSyntax::InsertAfter


PolicyMappingsSyntax  &PolicyMappingsSyntax::AppendCopy (PolicyMappingsSyntaxSeq &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyMappingsSyntaxSeq;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


PolicyMappingsSyntax  &PolicyMappingsSyntax::PrependCopy (PolicyMappingsSyntaxSeq &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyMappingsSyntaxSeq;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // PolicyMappingsSyntax::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
PolicyMappingsSyntax &PolicyMappingsSyntax::InsertBeforeAndCopy (PolicyMappingsSyntaxSeq &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyMappingsSyntaxSeq;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // PolicyMappingsSyntax::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
PolicyMappingsSyntax  &PolicyMappingsSyntax::InsertAfterAndCopy (PolicyMappingsSyntaxSeq &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new PolicyMappingsSyntaxSeq;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // PolicyMappingsSyntax::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void PolicyMappingsSyntax::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen PolicyMappingsSyntax::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
      BEncEocIfNec (b);
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncConsLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // PolicyMappingsSyntax::BEncContent


void  PolicyMappingsSyntax::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    PolicyMappingsSyntaxSeq *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -131);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // PolicyMappingsSyntax::BDecContent


SupportedAlgorithm::SupportedAlgorithm()
{
#if TCL
  algorithmIdentifier = new AlgorithmIdentifier;
#else
  algorithmIdentifier = NULL; // incomplete initialization of mandatory element!
#endif // TCL
  intendedUsage = NULL;
  intendedCertificatePolicies = NULL;
}

SupportedAlgorithm::SupportedAlgorithm (const SupportedAlgorithm &)
{
  Asn1Error << "use of incompletely defined SupportedAlgorithm::SupportedAlgorithm (const SupportedAlgorithm &)" << endl;
  abort();
}

SupportedAlgorithm::~SupportedAlgorithm()
{
  delete algorithmIdentifier;
  delete intendedUsage;
  delete intendedCertificatePolicies;
}

AsnType *SupportedAlgorithm::Clone() const
{
  return new SupportedAlgorithm;
}

AsnType *SupportedAlgorithm::Copy() const
{
  return new SupportedAlgorithm (*this);
}

#if SNACC_DEEP_COPY
SupportedAlgorithm &SupportedAlgorithm::operator = (const SupportedAlgorithm &that)
#else // SNACC_DEEP_COPY
SupportedAlgorithm &SupportedAlgorithm::operator = (const SupportedAlgorithm &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.algorithmIdentifier)
    {
      if (!algorithmIdentifier)
        algorithmIdentifier = new AlgorithmIdentifier;
      *algorithmIdentifier = *that.algorithmIdentifier;
    }
    else
    {
      delete algorithmIdentifier;
      algorithmIdentifier = NULL;
    }
    if (that.intendedUsage)
    {
      if (!intendedUsage)
        intendedUsage = new KeyUsage;
      *intendedUsage = *that.intendedUsage;
    }
    else
    {
      delete intendedUsage;
      intendedUsage = NULL;
    }
    if (that.intendedCertificatePolicies)
    {
      if (!intendedCertificatePolicies)
        intendedCertificatePolicies = new CertificatePoliciesSyntax;
      *intendedCertificatePolicies = *that.intendedCertificatePolicies;
    }
    else
    {
      delete intendedCertificatePolicies;
      intendedCertificatePolicies = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined SupportedAlgorithm &SupportedAlgorithm::operator = (const SupportedAlgorithm &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
SupportedAlgorithm::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (intendedCertificatePolicies))
  {
      BEncEocIfNec (b);
    l = intendedCertificatePolicies->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 1);
    totalLen += l;
  }

  if (NOT_NULL (intendedUsage))
  {
    l = intendedUsage->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 0);
    totalLen += l;
  }

      BEncEocIfNec (b);
    l = algorithmIdentifier->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
    totalLen += l;

  return totalLen;
} // SupportedAlgorithm::BEncContent


void SupportedAlgorithm::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  tag1 = BDecTag (b, seqBytesDecoded, env);

  if ((tag1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    algorithmIdentifier = new AlgorithmIdentifier;
    algorithmIdentifier->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }
  else
  {
    Asn1Error << "ERROR - SEQUENCE is missing non-optional elmt." << endl;
    longjmp (env, -132);
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 0))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    intendedUsage = new KeyUsage;
    intendedUsage->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    intendedCertificatePolicies = new CertificatePoliciesSyntax;
    intendedCertificatePolicies->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -133);
  }
  else
    return;
} // SupportedAlgorithm::BDecContent

AsnLen SupportedAlgorithm::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void SupportedAlgorithm::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "SupportedAlgorithm::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -134);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int SupportedAlgorithm::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int SupportedAlgorithm::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void SupportedAlgorithm::Print (ostream &os) const
{
#ifndef NDEBUG
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (algorithmIdentifier))
  {
    Indent (os, indentG);
    os << "algorithmIdentifier ";
    os << *algorithmIdentifier;
  }
  else
  {
    Indent (os, indentG);
    os << "algorithmIdentifier ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (intendedUsage))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "intendedUsage ";
    os << *intendedUsage;
  }
  else
  {
    Indent (os, indentG);
    os << "intendedUsage ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (intendedCertificatePolicies))
  {
    os << ","<< endl;
    Indent (os, indentG);
    os << "intendedCertificatePolicies ";
    os << *intendedCertificatePolicies;
  }
  else
  {
    Indent (os, indentG);
    os << "intendedCertificatePolicies ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // SupportedAlgorithm::Print


BasicConstraintsSyntax::BasicConstraintsSyntax()
{
  cA = NULL;
  pathLenConstraint = NULL;
}

BasicConstraintsSyntax::BasicConstraintsSyntax (const BasicConstraintsSyntax &)
{
  Asn1Error << "use of incompletely defined BasicConstraintsSyntax::BasicConstraintsSyntax (const BasicConstraintsSyntax &)" << endl;
  abort();
}

BasicConstraintsSyntax::~BasicConstraintsSyntax()
{
  delete cA;
  delete pathLenConstraint;
}

AsnType *BasicConstraintsSyntax::Clone() const
{
  return new BasicConstraintsSyntax;
}

AsnType *BasicConstraintsSyntax::Copy() const
{
  return new BasicConstraintsSyntax (*this);
}

#if SNACC_DEEP_COPY
BasicConstraintsSyntax &BasicConstraintsSyntax::operator = (const BasicConstraintsSyntax &that)
#else // SNACC_DEEP_COPY
BasicConstraintsSyntax &BasicConstraintsSyntax::operator = (const BasicConstraintsSyntax &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.cA)
    {
      if (!cA)
        cA = new AsnBool;
      *cA = *that.cA;
    }
    else
    {
      delete cA;
      cA = NULL;
    }
    if (that.pathLenConstraint)
    {
      if (!pathLenConstraint)
        pathLenConstraint = new AsnInt;
      *pathLenConstraint = *that.pathLenConstraint;
    }
    else
    {
      delete pathLenConstraint;
      pathLenConstraint = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined BasicConstraintsSyntax &BasicConstraintsSyntax::operator = (const BasicConstraintsSyntax &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
BasicConstraintsSyntax::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (pathLenConstraint))
  {
    l = pathLenConstraint->BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, UNIV, PRIM, INTEGER_TAG_CODE);
    totalLen += l;
  }

  if (NOT_NULL (cA))
  {
    l = cA->BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, UNIV, PRIM, BOOLEAN_TAG_CODE);
    totalLen += l;
  }

  return totalLen;
} // BasicConstraintsSyntax::BEncContent


void BasicConstraintsSyntax::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  if (elmtLen0 == 0)
    return;
  else
  {
    tag1 = BDecTag (b, seqBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
      bytesDecoded += seqBytesDecoded;
      return;
    }
  }

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, BOOLEAN_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    cA = new AsnBool;
    cA->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    pathLenConstraint = new AsnInt;
    pathLenConstraint->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -135);
  }
  else
    return;
} // BasicConstraintsSyntax::BDecContent

AsnLen BasicConstraintsSyntax::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void BasicConstraintsSyntax::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "BasicConstraintsSyntax::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -136);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int BasicConstraintsSyntax::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int BasicConstraintsSyntax::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void BasicConstraintsSyntax::Print (ostream &os) const
{
#ifndef NDEBUG
  int nonePrinted = true;
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (cA))
  {
    nonePrinted = false;
    Indent (os, indentG);
    os << "cA ";
    os << *cA;
  }
  else
  {
    Indent (os, indentG);
    os << "cA ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (pathLenConstraint))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "pathLenConstraint ";
    os << *pathLenConstraint;
  }
  else
  {
    Indent (os, indentG);
    os << "pathLenConstraint ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // BasicConstraintsSyntax::Print


NameConstraintsSyntax::NameConstraintsSyntax()
{
  permittedSubtrees = NULL;
  excludedSubtrees = NULL;
}

NameConstraintsSyntax::NameConstraintsSyntax (const NameConstraintsSyntax &)
{
  Asn1Error << "use of incompletely defined NameConstraintsSyntax::NameConstraintsSyntax (const NameConstraintsSyntax &)" << endl;
  abort();
}

NameConstraintsSyntax::~NameConstraintsSyntax()
{
  delete permittedSubtrees;
  delete excludedSubtrees;
}

AsnType *NameConstraintsSyntax::Clone() const
{
  return new NameConstraintsSyntax;
}

AsnType *NameConstraintsSyntax::Copy() const
{
  return new NameConstraintsSyntax (*this);
}

#if SNACC_DEEP_COPY
NameConstraintsSyntax &NameConstraintsSyntax::operator = (const NameConstraintsSyntax &that)
#else // SNACC_DEEP_COPY
NameConstraintsSyntax &NameConstraintsSyntax::operator = (const NameConstraintsSyntax &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.permittedSubtrees)
    {
      if (!permittedSubtrees)
        permittedSubtrees = new GeneralSubtrees;
      *permittedSubtrees = *that.permittedSubtrees;
    }
    else
    {
      delete permittedSubtrees;
      permittedSubtrees = NULL;
    }
    if (that.excludedSubtrees)
    {
      if (!excludedSubtrees)
        excludedSubtrees = new GeneralSubtrees;
      *excludedSubtrees = *that.excludedSubtrees;
    }
    else
    {
      delete excludedSubtrees;
      excludedSubtrees = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined NameConstraintsSyntax &NameConstraintsSyntax::operator = (const NameConstraintsSyntax &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
NameConstraintsSyntax::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (excludedSubtrees))
  {
      BEncEocIfNec (b);
    l = excludedSubtrees->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 1);
    totalLen += l;
  }

  if (NOT_NULL (permittedSubtrees))
  {
      BEncEocIfNec (b);
    l = permittedSubtrees->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 0);
    totalLen += l;
  }

  return totalLen;
} // NameConstraintsSyntax::BEncContent


void NameConstraintsSyntax::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  if (elmtLen0 == 0)
    return;
  else
  {
    tag1 = BDecTag (b, seqBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
      bytesDecoded += seqBytesDecoded;
      return;
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    permittedSubtrees = new GeneralSubtrees;
    permittedSubtrees->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    excludedSubtrees = new GeneralSubtrees;
    excludedSubtrees->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -137);
  }
  else
    return;
} // NameConstraintsSyntax::BDecContent

AsnLen NameConstraintsSyntax::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void NameConstraintsSyntax::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "NameConstraintsSyntax::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -138);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int NameConstraintsSyntax::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int NameConstraintsSyntax::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void NameConstraintsSyntax::Print (ostream &os) const
{
#ifndef NDEBUG
  int nonePrinted = true;
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (permittedSubtrees))
  {
    nonePrinted = false;
    Indent (os, indentG);
    os << "permittedSubtrees ";
    os << *permittedSubtrees;
  }
  else
  {
    Indent (os, indentG);
    os << "permittedSubtrees ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (excludedSubtrees))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "excludedSubtrees ";
    os << *excludedSubtrees;
  }
  else
  {
    Indent (os, indentG);
    os << "excludedSubtrees ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // NameConstraintsSyntax::Print


PolicyConstraintsSyntax::PolicyConstraintsSyntax()
{
  requireExplicitPolicy = NULL;
  inhibitPolicyMapping = NULL;
}

PolicyConstraintsSyntax::PolicyConstraintsSyntax (const PolicyConstraintsSyntax &)
{
  Asn1Error << "use of incompletely defined PolicyConstraintsSyntax::PolicyConstraintsSyntax (const PolicyConstraintsSyntax &)" << endl;
  abort();
}

PolicyConstraintsSyntax::~PolicyConstraintsSyntax()
{
  delete requireExplicitPolicy;
  delete inhibitPolicyMapping;
}

AsnType *PolicyConstraintsSyntax::Clone() const
{
  return new PolicyConstraintsSyntax;
}

AsnType *PolicyConstraintsSyntax::Copy() const
{
  return new PolicyConstraintsSyntax (*this);
}

#if SNACC_DEEP_COPY
PolicyConstraintsSyntax &PolicyConstraintsSyntax::operator = (const PolicyConstraintsSyntax &that)
#else // SNACC_DEEP_COPY
PolicyConstraintsSyntax &PolicyConstraintsSyntax::operator = (const PolicyConstraintsSyntax &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.requireExplicitPolicy)
    {
      if (!requireExplicitPolicy)
        requireExplicitPolicy = new SkipCerts;
      *requireExplicitPolicy = *that.requireExplicitPolicy;
    }
    else
    {
      delete requireExplicitPolicy;
      requireExplicitPolicy = NULL;
    }
    if (that.inhibitPolicyMapping)
    {
      if (!inhibitPolicyMapping)
        inhibitPolicyMapping = new SkipCerts;
      *inhibitPolicyMapping = *that.inhibitPolicyMapping;
    }
    else
    {
      delete inhibitPolicyMapping;
      inhibitPolicyMapping = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined PolicyConstraintsSyntax &PolicyConstraintsSyntax::operator = (const PolicyConstraintsSyntax &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
PolicyConstraintsSyntax::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (inhibitPolicyMapping))
  {
    l = inhibitPolicyMapping->BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, CNTX, PRIM, 1);
    totalLen += l;
  }

  if (NOT_NULL (requireExplicitPolicy))
  {
    l = requireExplicitPolicy->BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, CNTX, PRIM, 0);
    totalLen += l;
  }

  return totalLen;
} // PolicyConstraintsSyntax::BEncContent


void PolicyConstraintsSyntax::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  if (elmtLen0 == 0)
    return;
  else
  {
    tag1 = BDecTag (b, seqBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
      bytesDecoded += seqBytesDecoded;
      return;
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    requireExplicitPolicy = new SkipCerts;
    requireExplicitPolicy->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    inhibitPolicyMapping = new SkipCerts;
    inhibitPolicyMapping->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -139);
  }
  else
    return;
} // PolicyConstraintsSyntax::BDecContent

AsnLen PolicyConstraintsSyntax::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void PolicyConstraintsSyntax::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "PolicyConstraintsSyntax::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -140);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int PolicyConstraintsSyntax::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int PolicyConstraintsSyntax::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void PolicyConstraintsSyntax::Print (ostream &os) const
{
#ifndef NDEBUG
  int nonePrinted = true;
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (requireExplicitPolicy))
  {
    nonePrinted = false;
    Indent (os, indentG);
    os << "requireExplicitPolicy ";
    os << *requireExplicitPolicy;
  }
  else
  {
    Indent (os, indentG);
    os << "requireExplicitPolicy ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (inhibitPolicyMapping))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "inhibitPolicyMapping ";
    os << *inhibitPolicyMapping;
  }
  else
  {
    Indent (os, indentG);
    os << "inhibitPolicyMapping ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // PolicyConstraintsSyntax::Print


AsnType *CertPolicySet::Clone() const
{
  return new CertPolicySet;
}

AsnType *CertPolicySet::Copy() const
{
  return new CertPolicySet (*this);
}

AsnLen CertPolicySet::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void CertPolicySet::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "CertPolicySet::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -141);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

CertPolicySet::CertPolicySet (const CertPolicySet &)
{
  Asn1Error << "use of incompletely defined CertPolicySet::CertPolicySet (const CertPolicySet &)" << endl;
  abort();
}

CertPolicySet::~CertPolicySet()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
CertPolicySet &CertPolicySet::operator = (const CertPolicySet &that)
#else // SNACC_DEEP_COPY
CertPolicySet &CertPolicySet::operator = (const CertPolicySet &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined CertPolicySet &CertPolicySet::operator = (const CertPolicySet &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void CertPolicySet::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  CertPolicySet::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // CertPolicySet::SetCurrElmt


unsigned long int  CertPolicySet::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // CertPolicySet::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
CertPolicyId *CertPolicySet::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new CertPolicyId;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CertPolicySet::Append


// alloc new list elmt, put at begining of list
//  and return the component type
CertPolicyId  *CertPolicySet::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new CertPolicyId;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CertPolicySet::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
CertPolicyId  *CertPolicySet::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new CertPolicyId;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CertPolicySet::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
CertPolicyId *CertPolicySet::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new CertPolicyId;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CertPolicySet::InsertAfter


CertPolicySet  &CertPolicySet::AppendCopy (CertPolicyId &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new CertPolicyId;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


CertPolicySet  &CertPolicySet::PrependCopy (CertPolicyId &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new CertPolicyId;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // CertPolicySet::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
CertPolicySet &CertPolicySet::InsertBeforeAndCopy (CertPolicyId &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new CertPolicyId;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // CertPolicySet::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
CertPolicySet  &CertPolicySet::InsertAfterAndCopy (CertPolicyId &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new CertPolicyId;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // CertPolicySet::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void CertPolicySet::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen CertPolicySet::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncDefLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, PRIM, OID_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // CertPolicySet::BEncContent


void  CertPolicySet::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    CertPolicyId *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -142);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // CertPolicySet::BDecContent


AsnType *CRLDistPointsSyntax::Clone() const
{
  return new CRLDistPointsSyntax;
}

AsnType *CRLDistPointsSyntax::Copy() const
{
  return new CRLDistPointsSyntax (*this);
}

AsnLen CRLDistPointsSyntax::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void CRLDistPointsSyntax::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "CRLDistPointsSyntax::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -143);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

CRLDistPointsSyntax::CRLDistPointsSyntax (const CRLDistPointsSyntax &)
{
  Asn1Error << "use of incompletely defined CRLDistPointsSyntax::CRLDistPointsSyntax (const CRLDistPointsSyntax &)" << endl;
  abort();
}

CRLDistPointsSyntax::~CRLDistPointsSyntax()
{
  SetCurrToFirst();
  for (; Curr() != NULL; RemoveCurrFromList())
    ;
} // end of destructor

#if SNACC_DEEP_COPY
CRLDistPointsSyntax &CRLDistPointsSyntax::operator = (const CRLDistPointsSyntax &that)
#else // SNACC_DEEP_COPY
CRLDistPointsSyntax &CRLDistPointsSyntax::operator = (const CRLDistPointsSyntax &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    SetCurrToFirst();
    for (; Curr(); RemoveCurrFromList())
      ;

    //that.SetCurrToFirst();
    //for (; that.Curr(); that.GoNext())
    //  AppendCopy (*that.Curr());
    for (const AsnListElmt *run=that.first; run; run=run->next)
      AppendCopy (*run->elmt);
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined CRLDistPointsSyntax &CRLDistPointsSyntax::operator = (const CRLDistPointsSyntax &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

void CRLDistPointsSyntax::Print (ostream &os) const
{
#ifndef NDEBUG
    os << "{ -- SEQUENCE/SET OF -- " << endl;
    indentG += stdIndentG;
    //SetCurrToFirst();
    //for (; Curr() != NULL; GoNext())
    for (const AsnListElmt *run=first; run; run=run->next)
    {
        Indent (os, indentG);
        //os << *Curr();
        os << *run->elmt;
        //if (Curr() != Last())
        if (run != last)
            os << ",";
        os << endl;
    }
    indentG -= stdIndentG;
    Indent (os, indentG);
    os << "}\n";
#endif /* NDEBUG */


} // Print


void  CRLDistPointsSyntax::SetCurrElmt (unsigned long int index)
{
  unsigned long int i;
  curr = first;
  if (count)
    for (i = 0; (i < (count-1)) && (i < index); i++)
      curr = curr->next;
} // CRLDistPointsSyntax::SetCurrElmt


unsigned long int  CRLDistPointsSyntax::GetCurrElmtIndex()
{
    unsigned long int i;
    AsnListElmt *tmp;
    if (curr != NULL)
    {
        for (i = 0, tmp = first; tmp != NULL; i++)
        {
            if (tmp == curr)
                return i;
            else
                tmp = tmp->next;
        }
    }
    return count;
} // CRLDistPointsSyntax::GetCurrElmtIndex


// alloc new list elmt, put at end of list
//  and return the component type
DistributionPoint *CRLDistPointsSyntax::Append()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt  = new DistributionPoint;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CRLDistPointsSyntax::Append


// alloc new list elmt, put at begining of list
//  and return the component type
DistributionPoint  *CRLDistPointsSyntax::Prepend()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DistributionPoint;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CRLDistPointsSyntax::Prepend


// alloc new list elmt, insert it before the
// current element and return the component type
// if the current element is null, the new element
// is placed at the beginning of the list.
DistributionPoint  *CRLDistPointsSyntax::InsertBefore()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DistributionPoint;
    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CRLDistPointsSyntax::InsertBefore


// alloc new list elmt, insert it after the
// current element and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
DistributionPoint *CRLDistPointsSyntax::InsertAfter()
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DistributionPoint;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return (curr = newElmt)->elmt;
} // CRLDistPointsSyntax::InsertAfter


CRLDistPointsSyntax  &CRLDistPointsSyntax::AppendCopy (DistributionPoint &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DistributionPoint;
    *newElmt->elmt = elmt;
    newElmt->next = NULL;
    if (last == NULL)
    {
        newElmt->prev = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->prev = last;
        last->next    = newElmt;
        last          = newElmt;
    }
    count++;
    return *this;
} // AppendCopy


CRLDistPointsSyntax  &CRLDistPointsSyntax::PrependCopy (DistributionPoint &elmt)
{
    AsnListElmt *newElmt;
    newElmt  = new AsnListElmt;
    newElmt->elmt = new DistributionPoint;
    *newElmt->elmt = elmt;
    newElmt->prev = NULL;
    if (first == NULL)
    {
        newElmt->next = NULL;
        first = last  = newElmt;
    }
    else
    {
        newElmt->next = first;
        first->prev   = newElmt;
        first         = newElmt;
    }
    count++;
    return *this;
} // CRLDistPointsSyntax::PrependCopy


// alloc new list elmt, insert it before the
// current element, copy the given elmt into the new elmt
// and return the component type.
// if the current element is null, the new element
// is placed at the beginning of the list.
CRLDistPointsSyntax &CRLDistPointsSyntax::InsertBeforeAndCopy (DistributionPoint &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new DistributionPoint;
    *newElmt->elmt = elmt;

    if (curr == NULL)
    {
        newElmt->next = first;
        newElmt->prev = NULL;
        first = newElmt;
        if (last == NULL)
            last = newElmt;
    }
    else
    {
        newElmt->next = curr;
        newElmt->prev = curr->prev;
        curr->prev = newElmt;
        if (curr == first)
            first = newElmt;
        else
            newElmt->prev->next = newElmt;
    }
    count++;
    return *this;
} // CRLDistPointsSyntax::InsertBeforeAndCopy


// alloc new list elmt, insert it after the
// current element, copy given elmt in to new elmt
//  and return the component type
// if the current element is null, the new element
// is placed at the end of the list.
CRLDistPointsSyntax  &CRLDistPointsSyntax::InsertAfterAndCopy (DistributionPoint &elmt)
{
    AsnListElmt *newElmt;

    newElmt  = new AsnListElmt;
    newElmt->elmt = new DistributionPoint;
    *newElmt->elmt = elmt;
    if (curr == NULL)
    {
        newElmt->prev = last;
        newElmt->next = NULL;
        last = newElmt;
        if (first == NULL)
            first = newElmt;
    }
    else
    {
        newElmt->prev = curr;
        newElmt->next = curr->next;
        curr->next = newElmt;
        if (curr == last)
            last = newElmt;
        else
            newElmt->next->prev = newElmt;
    }
    count++;
    return *this;
} // CRLDistPointsSyntax::InsertAfterAndCopy


// remove current element from list if current element is not NULL 
// The new current element will be the next element.
// If the current element is the last element in the list
// the second but last element will become the new current element.
void CRLDistPointsSyntax::RemoveCurrFromList()
{
    AsnListElmt *del_elmt;

    if (curr != NULL)
    {
        del_elmt = curr;
        count--;

        if (count == 0)
            first = last = curr = NULL;
        else if (curr == first)
        {
            curr = first= first->next;
            first->prev = NULL;
        }
        else if (curr == last)
        {
            curr = last = last->prev;
            last->next = NULL;
        }
        else
        {
            curr->prev->next = curr->next;
            curr->next->prev = curr->prev;
        }

        delete del_elmt->elmt;
        delete del_elmt;
    }
}


AsnLen CRLDistPointsSyntax::BEncContent (BUF_TYPE b)
{
    AsnListElmt *currElmt;
    AsnLen elmtLen;
    AsnLen totalLen = 0;
    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
    {
      BEncEocIfNec (b);
        elmtLen = currElmt->elmt->BEncContent (b);
    elmtLen += BEncConsLen (b, elmtLen);

    elmtLen += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
        totalLen += elmtLen;
    }
    return totalLen;
} // CRLDistPointsSyntax::BEncContent


void  CRLDistPointsSyntax::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0,
                                  AsnLen &bytesDecoded, ENV_TYPE env)
{
    DistributionPoint *listElmt;
    AsnTag tag1;
    AsnLen listBytesDecoded = 0;
    AsnLen elmtLen1;

    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))
    {
        tag1 = BDecTag (b, listBytesDecoded, env);
        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
        {
            BDEC_2ND_EOC_OCTET (b, listBytesDecoded, env);
            break;
        }
        if ((tag1 != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
        {
            Asn1Error << "Unexpected Tag" << endl;
            longjmp (env, -144);
        }

        elmtLen1 = BDecLen (b, listBytesDecoded, env);
        listElmt = Append();
        listElmt->BDecContent (b, tag1, elmtLen1, listBytesDecoded, env);
    }

    bytesDecoded += listBytesDecoded;
} // CRLDistPointsSyntax::BDecContent


IssuingDistPointSyntax::IssuingDistPointSyntax()
{
  distributionPoint = NULL;
  onlyContainsUserCerts = NULL;
  onlyContainsCACerts = NULL;
  onlySomeReasons = NULL;
  indirectCRL = NULL;
}

IssuingDistPointSyntax::IssuingDistPointSyntax (const IssuingDistPointSyntax &)
{
  Asn1Error << "use of incompletely defined IssuingDistPointSyntax::IssuingDistPointSyntax (const IssuingDistPointSyntax &)" << endl;
  abort();
}

IssuingDistPointSyntax::~IssuingDistPointSyntax()
{
  delete distributionPoint;
  delete onlyContainsUserCerts;
  delete onlyContainsCACerts;
  delete onlySomeReasons;
  delete indirectCRL;
}

AsnType *IssuingDistPointSyntax::Clone() const
{
  return new IssuingDistPointSyntax;
}

AsnType *IssuingDistPointSyntax::Copy() const
{
  return new IssuingDistPointSyntax (*this);
}

#if SNACC_DEEP_COPY
IssuingDistPointSyntax &IssuingDistPointSyntax::operator = (const IssuingDistPointSyntax &that)
#else // SNACC_DEEP_COPY
IssuingDistPointSyntax &IssuingDistPointSyntax::operator = (const IssuingDistPointSyntax &)
#endif // SNACC_DEEP_COPY
{
#if SNACC_DEEP_COPY
  if (this != &that)
  {
    if (that.distributionPoint)
    {
      if (!distributionPoint)
        distributionPoint = new DistributionPointName;
      *distributionPoint = *that.distributionPoint;
    }
    else
    {
      delete distributionPoint;
      distributionPoint = NULL;
    }
    if (that.onlyContainsUserCerts)
    {
      if (!onlyContainsUserCerts)
        onlyContainsUserCerts = new AsnBool;
      *onlyContainsUserCerts = *that.onlyContainsUserCerts;
    }
    else
    {
      delete onlyContainsUserCerts;
      onlyContainsUserCerts = NULL;
    }
    if (that.onlyContainsCACerts)
    {
      if (!onlyContainsCACerts)
        onlyContainsCACerts = new AsnBool;
      *onlyContainsCACerts = *that.onlyContainsCACerts;
    }
    else
    {
      delete onlyContainsCACerts;
      onlyContainsCACerts = NULL;
    }
    if (that.onlySomeReasons)
    {
      if (!onlySomeReasons)
        onlySomeReasons = new ReasonFlags;
      *onlySomeReasons = *that.onlySomeReasons;
    }
    else
    {
      delete onlySomeReasons;
      onlySomeReasons = NULL;
    }
    if (that.indirectCRL)
    {
      if (!indirectCRL)
        indirectCRL = new AsnBool;
      *indirectCRL = *that.indirectCRL;
    }
    else
    {
      delete indirectCRL;
      indirectCRL = NULL;
    }
  }

  return *this;
#else // SNACC_DEEP_COPY
  Asn1Error << "use of incompletely defined IssuingDistPointSyntax &IssuingDistPointSyntax::operator = (const IssuingDistPointSyntax &)" << endl;
  abort();
  // if your compiler complains here, check the -novolat option
#endif // SNACC_DEEP_COPY
}

AsnLen
IssuingDistPointSyntax::BEncContent (BUF_TYPE b)
{
  AsnLen totalLen = 0;
  AsnLen l;

  if (NOT_NULL (indirectCRL))
  {
    l = indirectCRL->BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, CNTX, PRIM, 4);
    totalLen += l;
  }

  if (NOT_NULL (onlySomeReasons))
  {
    l = onlySomeReasons->BEncContent (b);
    l += BEncDefLen (b, l);

    l += BEncTag1 (b, CNTX, PRIM, 3);
    totalLen += l;
  }

  if (NOT_NULL (onlyContainsCACerts))
  {
    l = onlyContainsCACerts->BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, CNTX, PRIM, 2);
    totalLen += l;
  }

  if (NOT_NULL (onlyContainsUserCerts))
  {
    l = onlyContainsUserCerts->BEncContent (b);
    BEncDefLenTo127 (b, l);
    l++;

    l += BEncTag1 (b, CNTX, PRIM, 1);
    totalLen += l;
  }

  if (NOT_NULL (distributionPoint))
  {
      BEncEocIfNec (b);
    l = distributionPoint->BEncContent (b);
    l += BEncConsLen (b, l);

    l += BEncTag1 (b, CNTX, CONS, 0);
    totalLen += l;
  }

  return totalLen;
} // IssuingDistPointSyntax::BEncContent


void IssuingDistPointSyntax::BDecContent (BUF_TYPE b, AsnTag /*tag0*/, AsnLen elmtLen0, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag1;
  AsnLen seqBytesDecoded = 0;
  AsnLen elmtLen1;
  AsnLen elmtLen2;
  if (elmtLen0 == 0)
    return;
  else
  {
    tag1 = BDecTag (b, seqBytesDecoded, env);

    if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
    {
      BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
      bytesDecoded += seqBytesDecoded;
      return;
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, CONS, 0)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    tag1 = BDecTag (b, seqBytesDecoded, env);
    elmtLen2 = BDecLen (b, seqBytesDecoded, env);
    distributionPoint = new DistributionPointName;
    distributionPoint->BDecContent (b, tag1, elmtLen2, seqBytesDecoded, env);
    if (elmtLen1 == INDEFINITE_LEN)
      BDecEoc (b, seqBytesDecoded, env);

    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 1)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    onlyContainsUserCerts = new AsnBool;
    onlyContainsUserCerts->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 2)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    onlyContainsCACerts = new AsnBool;
    onlyContainsCACerts->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 3))
    || (tag1 == MAKE_TAG_ID (CNTX, CONS, 3)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    onlySomeReasons = new ReasonFlags;
    onlySomeReasons->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
    if (seqBytesDecoded == elmtLen0)
    {
      bytesDecoded += seqBytesDecoded;
      return;
    }
    else
    {
      tag1 = BDecTag (b, seqBytesDecoded, env);

      if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))
      {
        BDEC_2ND_EOC_OCTET (b, seqBytesDecoded, env)
        bytesDecoded += seqBytesDecoded;
        return;
      }
    }
  }

  if ((tag1 == MAKE_TAG_ID (CNTX, PRIM, 4)))
  {
    elmtLen1 = BDecLen (b, seqBytesDecoded, env);
    indirectCRL = new AsnBool;
    indirectCRL->BDecContent (b, tag1, elmtLen1, seqBytesDecoded, env);
  }

  bytesDecoded += seqBytesDecoded;
  if (elmtLen0 == INDEFINITE_LEN)
  {
    BDecEoc (b, bytesDecoded, env);
    return;
  }
  else if (seqBytesDecoded != elmtLen0)
  {
    Asn1Error << "ERROR - Length discrepancy on sequence." << endl;
    longjmp (env, -145);
  }
  else
    return;
} // IssuingDistPointSyntax::BDecContent

AsnLen IssuingDistPointSyntax::BEnc (BUF_TYPE b)
{
  AsnLen l;
  l = BEncContent (b);
  l += BEncConsLen (b, l);
  l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
  return l;
}

void IssuingDistPointSyntax::BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env)
{
  AsnTag tag;
  AsnLen elmtLen1;

  if ((tag = BDecTag (b, bytesDecoded, env)) != MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))
  {
    Asn1Error << "IssuingDistPointSyntax::BDec: ERROR - wrong tag" << endl;
    longjmp (env, -146);
  }
  elmtLen1 = BDecLen (b, bytesDecoded, env);
  BDecContent (b, tag, elmtLen1, bytesDecoded, env);
}

int IssuingDistPointSyntax::BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded)
{
    bytesEncoded = BEnc (b);
    return !b.WriteError();
}

int IssuingDistPointSyntax::BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded)
{
    ENV_TYPE env;
    int val;

    bytesDecoded = 0;
    if ((val = setjmp (env)) == 0)
    {
         BDec (b, bytesDecoded, env);
         return !b.ReadError();
    }
    else
        return false;
}

void IssuingDistPointSyntax::Print (ostream &os) const
{
#ifndef NDEBUG
  int nonePrinted = true;
  os << "{ -- SEQUENCE --" << endl;
  indentG += stdIndentG;

  if (NOT_NULL (distributionPoint))
  {
    nonePrinted = false;
    Indent (os, indentG);
    os << "distributionPoint ";
    os << *distributionPoint;
  }
  else
  {
    Indent (os, indentG);
    os << "distributionPoint ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (onlyContainsUserCerts))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "onlyContainsUserCerts ";
    os << *onlyContainsUserCerts;
  }
  else
  {
    Indent (os, indentG);
    os << "onlyContainsUserCerts ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (onlyContainsCACerts))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "onlyContainsCACerts ";
    os << *onlyContainsCACerts;
  }
  else
  {
    Indent (os, indentG);
    os << "onlyContainsCACerts ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (onlySomeReasons))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "onlySomeReasons ";
    os << *onlySomeReasons;
  }
  else
  {
    Indent (os, indentG);
    os << "onlySomeReasons ";
    os << "-- void --";
    os << "," << endl;
  }

  if (NOT_NULL (indirectCRL))
  {
    if (!nonePrinted)
      os << "," << endl;
    nonePrinted = false;
    Indent (os, indentG);
    os << "indirectCRL ";
    os << *indirectCRL;
  }
  else
  {
    Indent (os, indentG);
    os << "indirectCRL ";
    os << "-- void --";
    os << endl;
  }

  os << endl;
  indentG -= stdIndentG;
  Indent (os, indentG);
  os << "}";
#endif /* NDEBUG */
} // IssuingDistPointSyntax::Print


