//   NOTE: this is a machine generated file--editing not recommended
//
// sm_x509ce.h - class definitions for ASN.1 module CertificateExtensions
//
//   This file was generated by snacc on Wed Jun 27 16:40:55 2001
//   UBC snacc by Mike Sample
//   A couple of enhancements made by IBM European Networking Center

#ifndef _sm_x509ce_h_
#define _sm_x509ce_h_


//------------------------------------------------------------------------------
// class declarations:

class KeyUsage;
class CRLReason;
class ReasonFlags;
class PolicyQualifierInfo;
class AttributesSyntax;
class DistributionPointName;
class PolicyMappingsSyntaxSeq;
class PolicyInformationSeqOf;
class PolicyInformation;
class GeneralSubtree;
class DistributionPoint;
class CertificatePoliciesSyntax;
class GeneralSubtrees;
class AuthorityKeyIdentifier;
class ExtKeyUsageSyntax;
class PrivateKeyUsagePeriod;
class PolicyMappingsSyntax;
class SupportedAlgorithm;
class BasicConstraintsSyntax;
class NameConstraintsSyntax;
class PolicyConstraintsSyntax;
class CertPolicySet;
class CRLDistPointsSyntax;
class IssuingDistPointSyntax;

//------------------------------------------------------------------------------
// class definitions:

typedef enum CertificateExtensionsAnyId
{

} CertificateExtensionsAnyId;


/* OCTET STRING */
typedef AsnOcts KeyIdentifier;

/* BIT STRING { digitalSignature (0), nonRepudiation (1), keyEncipherment (2), dataEncipherment (3), keyAgreement (4), keyCertSign (5), cRLSign (6), encipherOnly (7), decipherOnly (8) }  */
class KeyUsage: public AsnBits
{
public:
			KeyUsage(): AsnBits() {}
			KeyUsage (const size_t bits): AsnBits (bits) {}
			KeyUsage (const char *str, const size_t bitLen): AsnBits (str, bitLen) {}
			KeyUsage (const AsnBits &b): AsnBits (b) {}
  enum
  {
    digitalSignature = 0,
    nonRepudiation = 1,
    keyEncipherment = 2,
    dataEncipherment = 3,
    keyAgreement = 4,
    keyCertSign = 5,
    cRLSign = 6,
    encipherOnly = 7,
    decipherOnly = 8
  };
};


/* OBJECT IDENTIFIER */
typedef AsnOid KeyPurposeId;

/* OBJECT IDENTIFIER */
typedef AsnOid CertPolicyId;

/* INTEGER (0..MAX) */
typedef AsnInt BaseDistance;

/* INTEGER (0..MAX) */
typedef AsnInt SkipCerts;

/* INTEGER (0..MAX) */
typedef AsnInt CRLNumber;

/* ENUMERATED { unspecified (0), keyCompromise (1), cACompromise (2), affiliationChanged (3), superseded (4), cessationOfOperation (5), certificateHold (6), removeFromCRL (8) }  */
class CRLReason: public AsnEnum
{
public:
			CRLReason(): AsnEnum() {}
			CRLReason (int i): AsnEnum (i) {}
  enum
  {
    unspecified = 0,
    keyCompromise = 1,
    cACompromise = 2,
    affiliationChanged = 3,
    superseded = 4,
    cessationOfOperation = 5,
    certificateHold = 6,
    removeFromCRL = 8
  };
};


/* OBJECT IDENTIFIER */
typedef AsnOid HoldInstruction;

/* BIT STRING { unused (0), keyCompromise (1), caCompromise (2), affiliationChanged (3), superseded (4), cessationOfOperation (5), certificateHold (6) }  */
class ReasonFlags: public AsnBits
{
public:
			ReasonFlags(): AsnBits() {}
			ReasonFlags (const size_t bits): AsnBits (bits) {}
			ReasonFlags (const char *str, const size_t bitLen): AsnBits (str, bitLen) {}
			ReasonFlags (const AsnBits &b): AsnBits (b) {}
  enum
  {
    unused = 0,
    keyCompromise = 1,
    caCompromise = 2,
    affiliationChanged = 3,
    superseded = 4,
    cessationOfOperation = 5,
    certificateHold = 6
  };
};


class PolicyQualifierInfo: public AsnType
{
public:
  AsnOid		policyQualifierId;
  AsnAny		*qualifier;

			PolicyQualifierInfo();
			PolicyQualifierInfo (const PolicyQualifierInfo &);
  virtual		~PolicyQualifierInfo();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  PolicyQualifierInfo		&operator = (const PolicyQualifierInfo &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class AttributesSyntax: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    Attribute	*elmt;
  }			*first, *curr, *last;

public:
			AttributesSyntax() { count = 0; first = curr = last = NULL; }
			AttributesSyntax (const AttributesSyntax &);
  virtual		~AttributesSyntax();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AttributesSyntax		&operator = (const AttributesSyntax &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  Attribute	*First() const	{ return count > 0 ? first->elmt : NULL; }
  Attribute	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  Attribute	*Curr() const	{ return curr ? curr->elmt : NULL; }
  Attribute	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  Attribute	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  Attribute	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  Attribute	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  Attribute	*Append();  // add elmt to end of list
  Attribute	*Prepend(); // add elmt to beginning of list
  Attribute	*InsertBefore(); //insert elmt before current elmt
  Attribute	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  AttributesSyntax	&AppendCopy (Attribute &elmt);  // add elmt to end of list
  AttributesSyntax	&PrependCopy (Attribute &elmt); // add elmt to beginning of list
  AttributesSyntax	&InsertBeforeAndCopy (Attribute &elmt); //insert elmt before current elmt
  AttributesSyntax	&InsertAfterAndCopy (Attribute &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class DistributionPointName: public AsnType
{
public:
  enum ChoiceIdEnum
  {
     fullNameCid = 0,
     nameRelativeToCRLIssuerCid = 1
  };

  enum ChoiceIdEnum	choiceId;
  union
  {
     GeneralNames		*fullName;
     RelativeDistinguishedName		*nameRelativeToCRLIssuer;
  };


			DistributionPointName();
			DistributionPointName (const DistributionPointName &);
  virtual		~DistributionPointName();

  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  DistributionPointName		&operator = (const DistributionPointName &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void			Print (ostream &os) const;
};


class PolicyMappingsSyntaxSeq: public AsnType
{
public:
  CertPolicyId		issuerDomainPolicy;
  CertPolicyId		subjectDomainPolicy;

			PolicyMappingsSyntaxSeq();
			PolicyMappingsSyntaxSeq (const PolicyMappingsSyntaxSeq &);
  virtual		~PolicyMappingsSyntaxSeq();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  PolicyMappingsSyntaxSeq		&operator = (const PolicyMappingsSyntaxSeq &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class PolicyInformationSeqOf: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    PolicyQualifierInfo	*elmt;
  }			*first, *curr, *last;

public:
			PolicyInformationSeqOf() { count = 0; first = curr = last = NULL; }
			PolicyInformationSeqOf (const PolicyInformationSeqOf &);
  virtual		~PolicyInformationSeqOf();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  PolicyInformationSeqOf		&operator = (const PolicyInformationSeqOf &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  PolicyQualifierInfo	*First() const	{ return count > 0 ? first->elmt : NULL; }
  PolicyQualifierInfo	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  PolicyQualifierInfo	*Curr() const	{ return curr ? curr->elmt : NULL; }
  PolicyQualifierInfo	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  PolicyQualifierInfo	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  PolicyQualifierInfo	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  PolicyQualifierInfo	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  PolicyQualifierInfo	*Append();  // add elmt to end of list
  PolicyQualifierInfo	*Prepend(); // add elmt to beginning of list
  PolicyQualifierInfo	*InsertBefore(); //insert elmt before current elmt
  PolicyQualifierInfo	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  PolicyInformationSeqOf	&AppendCopy (PolicyQualifierInfo &elmt);  // add elmt to end of list
  PolicyInformationSeqOf	&PrependCopy (PolicyQualifierInfo &elmt); // add elmt to beginning of list
  PolicyInformationSeqOf	&InsertBeforeAndCopy (PolicyQualifierInfo &elmt); //insert elmt before current elmt
  PolicyInformationSeqOf	&InsertAfterAndCopy (PolicyQualifierInfo &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class PolicyInformation: public AsnType
{
public:
  CertPolicyId		policyIdentifier;
  PolicyInformationSeqOf		*policyQualifiers;

			PolicyInformation();
			PolicyInformation (const PolicyInformation &);
  virtual		~PolicyInformation();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  PolicyInformation		&operator = (const PolicyInformation &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class GeneralSubtree: public AsnType
{
public:
  GeneralName		*base;
  BaseDistance		*minimum;
  BaseDistance		*maximum;

			GeneralSubtree();
			GeneralSubtree (const GeneralSubtree &);
  virtual		~GeneralSubtree();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  GeneralSubtree		&operator = (const GeneralSubtree &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class DistributionPoint: public AsnType
{
public:
  DistributionPointName		*distributionPoint;
  ReasonFlags		*reasons;
  GeneralNames		*cRLIssuer;

			DistributionPoint();
			DistributionPoint (const DistributionPoint &);
  virtual		~DistributionPoint();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  DistributionPoint		&operator = (const DistributionPoint &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class CertificatePoliciesSyntax: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    PolicyInformation	*elmt;
  }			*first, *curr, *last;

public:
			CertificatePoliciesSyntax() { count = 0; first = curr = last = NULL; }
			CertificatePoliciesSyntax (const CertificatePoliciesSyntax &);
  virtual		~CertificatePoliciesSyntax();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertificatePoliciesSyntax		&operator = (const CertificatePoliciesSyntax &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  PolicyInformation	*First() const	{ return count > 0 ? first->elmt : NULL; }
  PolicyInformation	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  PolicyInformation	*Curr() const	{ return curr ? curr->elmt : NULL; }
  PolicyInformation	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  PolicyInformation	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  PolicyInformation	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  PolicyInformation	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  PolicyInformation	*Append();  // add elmt to end of list
  PolicyInformation	*Prepend(); // add elmt to beginning of list
  PolicyInformation	*InsertBefore(); //insert elmt before current elmt
  PolicyInformation	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  CertificatePoliciesSyntax	&AppendCopy (PolicyInformation &elmt);  // add elmt to end of list
  CertificatePoliciesSyntax	&PrependCopy (PolicyInformation &elmt); // add elmt to beginning of list
  CertificatePoliciesSyntax	&InsertBeforeAndCopy (PolicyInformation &elmt); //insert elmt before current elmt
  CertificatePoliciesSyntax	&InsertAfterAndCopy (PolicyInformation &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class GeneralSubtrees: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    GeneralSubtree	*elmt;
  }			*first, *curr, *last;

public:
			GeneralSubtrees() { count = 0; first = curr = last = NULL; }
			GeneralSubtrees (const GeneralSubtrees &);
  virtual		~GeneralSubtrees();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  GeneralSubtrees		&operator = (const GeneralSubtrees &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  GeneralSubtree	*First() const	{ return count > 0 ? first->elmt : NULL; }
  GeneralSubtree	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  GeneralSubtree	*Curr() const	{ return curr ? curr->elmt : NULL; }
  GeneralSubtree	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  GeneralSubtree	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  GeneralSubtree	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  GeneralSubtree	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  GeneralSubtree	*Append();  // add elmt to end of list
  GeneralSubtree	*Prepend(); // add elmt to beginning of list
  GeneralSubtree	*InsertBefore(); //insert elmt before current elmt
  GeneralSubtree	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  GeneralSubtrees	&AppendCopy (GeneralSubtree &elmt);  // add elmt to end of list
  GeneralSubtrees	&PrependCopy (GeneralSubtree &elmt); // add elmt to beginning of list
  GeneralSubtrees	&InsertBeforeAndCopy (GeneralSubtree &elmt); //insert elmt before current elmt
  GeneralSubtrees	&InsertAfterAndCopy (GeneralSubtree &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class AuthorityKeyIdentifier: public AsnType
{
public:
  KeyIdentifier		*keyIdentifier;
  GeneralNames		*authorityCertIssuer;
  CertificateSerialNumber		*authorityCertSerialNumber;

			AuthorityKeyIdentifier();
			AuthorityKeyIdentifier (const AuthorityKeyIdentifier &);
  virtual		~AuthorityKeyIdentifier();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  AuthorityKeyIdentifier		&operator = (const AuthorityKeyIdentifier &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


/* KeyIdentifier */
typedef KeyIdentifier SubjectKeyIdentifier;

class ExtKeyUsageSyntax: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    KeyPurposeId	*elmt;
  }			*first, *curr, *last;

public:
			ExtKeyUsageSyntax() { count = 0; first = curr = last = NULL; }
			ExtKeyUsageSyntax (const ExtKeyUsageSyntax &);
  virtual		~ExtKeyUsageSyntax();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  ExtKeyUsageSyntax		&operator = (const ExtKeyUsageSyntax &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  KeyPurposeId	*First() const	{ return count > 0 ? first->elmt : NULL; }
  KeyPurposeId	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  KeyPurposeId	*Curr() const	{ return curr ? curr->elmt : NULL; }
  KeyPurposeId	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  KeyPurposeId	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  KeyPurposeId	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  KeyPurposeId	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  KeyPurposeId	*Append();  // add elmt to end of list
  KeyPurposeId	*Prepend(); // add elmt to beginning of list
  KeyPurposeId	*InsertBefore(); //insert elmt before current elmt
  KeyPurposeId	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  ExtKeyUsageSyntax	&AppendCopy (KeyPurposeId &elmt);  // add elmt to end of list
  ExtKeyUsageSyntax	&PrependCopy (KeyPurposeId &elmt); // add elmt to beginning of list
  ExtKeyUsageSyntax	&InsertBeforeAndCopy (KeyPurposeId &elmt); //insert elmt before current elmt
  ExtKeyUsageSyntax	&InsertAfterAndCopy (KeyPurposeId &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class PrivateKeyUsagePeriod: public AsnType
{
public:
  GeneralizedTime		*notBefore;
  GeneralizedTime		*notAfter;

			PrivateKeyUsagePeriod();
			PrivateKeyUsagePeriod (const PrivateKeyUsagePeriod &);
  virtual		~PrivateKeyUsagePeriod();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  PrivateKeyUsagePeriod		&operator = (const PrivateKeyUsagePeriod &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class PolicyMappingsSyntax: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    PolicyMappingsSyntaxSeq	*elmt;
  }			*first, *curr, *last;

public:
			PolicyMappingsSyntax() { count = 0; first = curr = last = NULL; }
			PolicyMappingsSyntax (const PolicyMappingsSyntax &);
  virtual		~PolicyMappingsSyntax();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  PolicyMappingsSyntax		&operator = (const PolicyMappingsSyntax &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  PolicyMappingsSyntaxSeq	*First() const	{ return count > 0 ? first->elmt : NULL; }
  PolicyMappingsSyntaxSeq	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  PolicyMappingsSyntaxSeq	*Curr() const	{ return curr ? curr->elmt : NULL; }
  PolicyMappingsSyntaxSeq	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  PolicyMappingsSyntaxSeq	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  PolicyMappingsSyntaxSeq	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  PolicyMappingsSyntaxSeq	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  PolicyMappingsSyntaxSeq	*Append();  // add elmt to end of list
  PolicyMappingsSyntaxSeq	*Prepend(); // add elmt to beginning of list
  PolicyMappingsSyntaxSeq	*InsertBefore(); //insert elmt before current elmt
  PolicyMappingsSyntaxSeq	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  PolicyMappingsSyntax	&AppendCopy (PolicyMappingsSyntaxSeq &elmt);  // add elmt to end of list
  PolicyMappingsSyntax	&PrependCopy (PolicyMappingsSyntaxSeq &elmt); // add elmt to beginning of list
  PolicyMappingsSyntax	&InsertBeforeAndCopy (PolicyMappingsSyntaxSeq &elmt); //insert elmt before current elmt
  PolicyMappingsSyntax	&InsertAfterAndCopy (PolicyMappingsSyntaxSeq &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class SupportedAlgorithm: public AsnType
{
public:
  AlgorithmIdentifier		*algorithmIdentifier;
  KeyUsage		*intendedUsage;
  CertificatePoliciesSyntax		*intendedCertificatePolicies;

			SupportedAlgorithm();
			SupportedAlgorithm (const SupportedAlgorithm &);
  virtual		~SupportedAlgorithm();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  SupportedAlgorithm		&operator = (const SupportedAlgorithm &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


/* GeneralNames */
typedef GeneralNames SubjectName;

/* GeneralNames */
typedef GeneralNames IssuerAltName;

/* AttributesSyntax */
typedef AttributesSyntax SubjectDirectoryAttributes;

class BasicConstraintsSyntax: public AsnType
{
public:
  AsnBool		*cA;
  AsnInt		*pathLenConstraint;

			BasicConstraintsSyntax();
			BasicConstraintsSyntax (const BasicConstraintsSyntax &);
  virtual		~BasicConstraintsSyntax();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  BasicConstraintsSyntax		&operator = (const BasicConstraintsSyntax &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class NameConstraintsSyntax: public AsnType
{
public:
  GeneralSubtrees		*permittedSubtrees;
  GeneralSubtrees		*excludedSubtrees;

			NameConstraintsSyntax();
			NameConstraintsSyntax (const NameConstraintsSyntax &);
  virtual		~NameConstraintsSyntax();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  NameConstraintsSyntax		&operator = (const NameConstraintsSyntax &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class PolicyConstraintsSyntax: public AsnType
{
public:
  SkipCerts		*requireExplicitPolicy;
  SkipCerts		*inhibitPolicyMapping;

			PolicyConstraintsSyntax();
			PolicyConstraintsSyntax (const PolicyConstraintsSyntax &);
  virtual		~PolicyConstraintsSyntax();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  PolicyConstraintsSyntax		&operator = (const PolicyConstraintsSyntax &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


class CertPolicySet: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    CertPolicyId	*elmt;
  }			*first, *curr, *last;

public:
			CertPolicySet() { count = 0; first = curr = last = NULL; }
			CertPolicySet (const CertPolicySet &);
  virtual		~CertPolicySet();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CertPolicySet		&operator = (const CertPolicySet &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  CertPolicyId	*First() const	{ return count > 0 ? first->elmt : NULL; }
  CertPolicyId	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  CertPolicyId	*Curr() const	{ return curr ? curr->elmt : NULL; }
  CertPolicyId	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  CertPolicyId	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  CertPolicyId	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  CertPolicyId	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  CertPolicyId	*Append();  // add elmt to end of list
  CertPolicyId	*Prepend(); // add elmt to beginning of list
  CertPolicyId	*InsertBefore(); //insert elmt before current elmt
  CertPolicyId	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  CertPolicySet	&AppendCopy (CertPolicyId &elmt);  // add elmt to end of list
  CertPolicySet	&PrependCopy (CertPolicyId &elmt); // add elmt to beginning of list
  CertPolicySet	&InsertBeforeAndCopy (CertPolicyId &elmt); //insert elmt before current elmt
  CertPolicySet	&InsertAfterAndCopy (CertPolicyId &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


/* GeneralizedTime */
typedef GeneralizedTime InvalidityDate;

class CRLDistPointsSyntax: public AsnType
{
protected:
  unsigned long int	count;
  struct AsnListElmt
  {
    AsnListElmt	*next;
    AsnListElmt	*prev;
    DistributionPoint	*elmt;
  }			*first, *curr, *last;

public:
			CRLDistPointsSyntax() { count = 0; first = curr = last = NULL; }
			CRLDistPointsSyntax (const CRLDistPointsSyntax &);
  virtual		~CRLDistPointsSyntax();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  CRLDistPointsSyntax		&operator = (const CRLDistPointsSyntax &);
  void		SetCurrElmt (unsigned long int index);
  unsigned long int	GetCurrElmtIndex();
  void		SetCurrToFirst() { curr = first; }
  void		SetCurrToLast()  { curr = last; }
  // reading member fcns
  int			Count() const	{ return count; }
  // NOTE: if your compiler complains about these NULLs, its definition of NULL is broken (and you better change it there!)
  DistributionPoint	*First() const	{ return count > 0 ? first->elmt : NULL; }
  DistributionPoint	*Last() const	{ return count > 0 ? last->elmt : NULL; }
  DistributionPoint	*Curr() const	{ return curr ? curr->elmt : NULL; }
  DistributionPoint	*Next() const	{ return curr && curr->next ? curr->next->elmt : NULL; }
  DistributionPoint	*Prev() const	{ return curr && curr->prev ? curr->prev->elmt : NULL; }

  // routines that move the curr elmt
  DistributionPoint	*GoNext() { if (curr) curr = curr->next; return Curr(); }
  DistributionPoint	*GoPrev() { if (curr) curr = curr->prev; return Curr(); }

  // write & alloc fcns - returns new elmt
  DistributionPoint	*Append();  // add elmt to end of list
  DistributionPoint	*Prepend(); // add elmt to beginning of list
  DistributionPoint	*InsertBefore(); //insert elmt before current elmt
  DistributionPoint	*InsertAfter(); //insert elmt after current elmt

  // write & alloc & copy - returns list after copying elmt
  CRLDistPointsSyntax	&AppendCopy (DistributionPoint &elmt);  // add elmt to end of list
  CRLDistPointsSyntax	&PrependCopy (DistributionPoint &elmt); // add elmt to beginning of list
  CRLDistPointsSyntax	&InsertBeforeAndCopy (DistributionPoint &elmt); //insert elmt before current elmt
  CRLDistPointsSyntax	&InsertAfterAndCopy (DistributionPoint &elmt); //insert elmt after current elmt

  // removing the current elmt from the list
  void		RemoveCurrFromList();

  // encode and decode routines    
  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  PDU_MEMBER_MACROS
  void		Print (ostream &os) const;
};


class IssuingDistPointSyntax: public AsnType
{
public:
  DistributionPointName		*distributionPoint;
  AsnBool		*onlyContainsUserCerts;
  AsnBool		*onlyContainsCACerts;
  ReasonFlags		*onlySomeReasons;
  AsnBool		*indirectCRL;

			IssuingDistPointSyntax();
			IssuingDistPointSyntax (const IssuingDistPointSyntax &);
  virtual		~IssuingDistPointSyntax();
  virtual AsnType	*Clone() const;

  virtual AsnType	*Copy() const;

  IssuingDistPointSyntax		&operator = (const IssuingDistPointSyntax &);
  AsnLen		BEncContent (BUF_TYPE b);
  void			BDecContent (BUF_TYPE b, AsnTag tag, AsnLen elmtLen, AsnLen &bytesDecoded, ENV_TYPE env);

  AsnLen		BEnc (BUF_TYPE b);
  void			BDec (BUF_TYPE b, AsnLen &bytesDecoded, ENV_TYPE env);
  int			BEncPdu (BUF_TYPE b, AsnLen &bytesEncoded);
  int			BDecPdu (BUF_TYPE b, AsnLen &bytesDecoded);

  void		Print (ostream &os) const;
};


/* GeneralNames */
typedef GeneralNames CertificateIssuer;

/* CRLNumber */
typedef CRLNumber BaseCRLNumber;

/* CertificateList */
typedef CertificateList DeltaRevocationList;

//------------------------------------------------------------------------------
// externs for value defs

#define id_at_supportedAlgorithms_arc 2, 5, 4, 52
#define id_at_supportedAlgorithms     AsnOid(id_at_supportedAlgorithms_arc)
#define id_at_deltaRevocationList_arc 2, 5, 4, 53
#define id_at_deltaRevocationList     AsnOid(id_at_deltaRevocationList_arc)
#define id_ce_subjectDirectoryAttributes_arc 2, 5, 29, 9
#define id_ce_subjectDirectoryAttributes     AsnOid(id_ce_subjectDirectoryAttributes_arc)
#define id_ce_subjectKeyIdentifier_arc 2, 5, 29, 14
#define id_ce_subjectKeyIdentifier     AsnOid(id_ce_subjectKeyIdentifier_arc)
#define id_ce_keyUsage_arc 2, 5, 29, 15
#define id_ce_keyUsage     AsnOid(id_ce_keyUsage_arc)
#define id_ce_privateKeyUsagePeriod_arc 2, 5, 29, 16
#define id_ce_privateKeyUsagePeriod     AsnOid(id_ce_privateKeyUsagePeriod_arc)
#define id_ce_subjectAltName_arc 2, 5, 29, 17
#define id_ce_subjectAltName     AsnOid(id_ce_subjectAltName_arc)
#define id_ce_issuerAltName_arc 2, 5, 29, 18
#define id_ce_issuerAltName     AsnOid(id_ce_issuerAltName_arc)
#define id_ce_basicConstraints_arc 2, 5, 29, 19
#define id_ce_basicConstraints     AsnOid(id_ce_basicConstraints_arc)
#define id_ce_cRLNumber_arc 2, 5, 29, 20
#define id_ce_cRLNumber     AsnOid(id_ce_cRLNumber_arc)
#define id_ce_reasonCode_arc 2, 5, 29, 21
#define id_ce_reasonCode     AsnOid(id_ce_reasonCode_arc)
#define id_ce_instructionCode_arc 2, 5, 29, 23
#define id_ce_instructionCode     AsnOid(id_ce_instructionCode_arc)
#define id_ce_invalidityDate_arc 2, 5, 29, 24
#define id_ce_invalidityDate     AsnOid(id_ce_invalidityDate_arc)
#define id_ce_deltaCRLIndicator_arc 2, 5, 29, 27
#define id_ce_deltaCRLIndicator     AsnOid(id_ce_deltaCRLIndicator_arc)
#define id_ce_issuingDistributionPoint_arc 2, 5, 29, 28
#define id_ce_issuingDistributionPoint     AsnOid(id_ce_issuingDistributionPoint_arc)
#define id_ce_certificateIssuer_arc 2, 5, 29, 29
#define id_ce_certificateIssuer     AsnOid(id_ce_certificateIssuer_arc)
#define id_ce_nameConstraints_arc 2, 5, 29, 30
#define id_ce_nameConstraints     AsnOid(id_ce_nameConstraints_arc)
#define id_ce_cRLDistributionPoints_arc 2, 5, 29, 31
#define id_ce_cRLDistributionPoints     AsnOid(id_ce_cRLDistributionPoints_arc)
#define id_ce_certificatePolicies_arc 2, 5, 29, 32
#define id_ce_certificatePolicies     AsnOid(id_ce_certificatePolicies_arc)
#define id_ce_policyMappings_arc 2, 5, 29, 33
#define id_ce_policyMappings     AsnOid(id_ce_policyMappings_arc)
#define id_ce_authorityKeyIdentifier_arc 2, 5, 29, 35
#define id_ce_authorityKeyIdentifier     AsnOid(id_ce_authorityKeyIdentifier_arc)
#define id_ce_policyConstraints_arc 2, 5, 29, 36
#define id_ce_policyConstraints     AsnOid(id_ce_policyConstraints_arc)
#define id_ce_extKeyUsage_arc 2, 5, 29, 37
#define id_ce_extKeyUsage     AsnOid(id_ce_extKeyUsage_arc)
#define id_mr_certificateExactMatch_arc 2, 5, 13, 34
#define id_mr_certificateExactMatch     AsnOid(id_mr_certificateExactMatch_arc)
#define id_mr_certificateMatch_arc 2, 5, 13, 35
#define id_mr_certificateMatch     AsnOid(id_mr_certificateMatch_arc)
#define id_mr_certificatePairExactMatch_arc 2, 5, 13, 36
#define id_mr_certificatePairExactMatch     AsnOid(id_mr_certificatePairExactMatch_arc)
#define id_mr_certificatePairMatch_arc 2, 5, 13, 37
#define id_mr_certificatePairMatch     AsnOid(id_mr_certificatePairMatch_arc)
#define id_mr_certificateListExactMatch_arc 2, 5, 13, 38
#define id_mr_certificateListExactMatch     AsnOid(id_mr_certificateListExactMatch_arc)
#define id_mr_certificateListMatch_arc 2, 5, 13, 39
#define id_mr_certificateListMatch     AsnOid(id_mr_certificateListMatch_arc)
#define id_mr_algorithmIdentifierMatch_arc 2, 5, 13, 40
#define id_mr_algorithmIdentifierMatch     AsnOid(id_mr_algorithmIdentifierMatch_arc)
#define id_kp_arc 1, 3, 6, 1, 5, 5, 7, 3
#define id_kp     AsnOid(id_kp_arc)
#define id_kp_serverAuth_arc 1, 3, 6, 1, 5, 5, 7, 3, 1
#define id_kp_serverAuth     AsnOid(id_kp_serverAuth_arc)
#define id_kp_clientAuth_arc 1, 3, 6, 1, 5, 5, 7, 3, 2
#define id_kp_clientAuth     AsnOid(id_kp_clientAuth_arc)
#define id_kp_codeSigning_arc 1, 3, 6, 1, 5, 5, 7, 3, 3
#define id_kp_codeSigning     AsnOid(id_kp_codeSigning_arc)
#define id_kp_emailProtection_arc 1, 3, 6, 1, 5, 5, 7, 3, 4
#define id_kp_emailProtection     AsnOid(id_kp_emailProtection_arc)
#define id_kp_timeStamping_arc 1, 3, 6, 1, 5, 5, 7, 3, 8
#define id_kp_timeStamping     AsnOid(id_kp_timeStamping_arc)
#define id_netscape_cert_type_arc 2, 16, 840, 1, 113730, 1, 1
#define id_netscape_cert_type     AsnOid(id_netscape_cert_type_arc)
//------------------------------------------------------------------------------

#endif /* conditional include of sm_x509ce.h */
