/*
 * Copyright (c) 2000-2001 Apple Computer, Inc. All Rights Reserved.
 * 
 * The contents of this file constitute Original Code as defined in and are
 * subject to the Apple Public Source License Version 1.2 (the 'License').
 * You may not use this file except in compliance with the License. Please obtain
 * a copy of the License at http://www.apple.com/publicsource and read it before
 * using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS
 * OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see the License for the
 * specific language governing rights and limitations under the License.
 */


/*
 *    asn-useful.c
 *
 *    "ASN-USEFUL" ASN.1 module encode/decode/print/free C src.
 *
 *    This file was generated by snacc on Mon Mar  3 11:08:41 1997
 *
 *    UBC snacc written by Mike Sample
 *
 *    NOTE: This is a machine generated file - editing not recommended
 */



#include "asn-incl.h"
#include "asn-useful.h"


AsnLen BEncNumericString PARAMS ((b, v),
BUF_TYPE b _AND_
NumericString *v)
{
    AsnLen l;
    l = BEncNumericStringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, NUMERICSTRING_TAG_CODE);
    return l;
} /* BEncNumericString */

void BDecNumericString PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
NumericString *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, NUMERICSTRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, NUMERICSTRING_TAG_CODE)))
    {
        Asn1Error ("BDecNumericString: ERROR - wrong tag\n");
        longjmp (env, 50);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecNumericStringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecNumericString */

AsnLen BEncPrintableString PARAMS ((b, v),
BUF_TYPE b _AND_
PrintableString *v)
{
    AsnLen l;
    l = BEncPrintableStringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, PRINTABLESTRING_TAG_CODE);
    return l;
} /* BEncPrintableString */

void BDecPrintableString PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
PrintableString *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, PRINTABLESTRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, PRINTABLESTRING_TAG_CODE)))
    {
        Asn1Error ("BDecPrintableString: ERROR - wrong tag\n");
        longjmp (env, 49);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecPrintableStringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecPrintableString */

AsnLen BEncTeletexString PARAMS ((b, v),
BUF_TYPE b _AND_
TeletexString *v)
{
    AsnLen l;
    l = BEncTeletexStringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, TELETEXSTRING_TAG_CODE);
    return l;
} /* BEncTeletexString */

void BDecTeletexString PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
TeletexString *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, TELETEXSTRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, TELETEXSTRING_TAG_CODE)))
    {
        Asn1Error ("BDecTeletexString: ERROR - wrong tag\n");
        longjmp (env, 48);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecTeletexStringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecTeletexString */

AsnLen BEncT61String PARAMS ((b, v),
BUF_TYPE b _AND_
T61String *v)
{
    AsnLen l;
    l = BEncT61StringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, TELETEXSTRING_TAG_CODE);
    return l;
} /* BEncT61String */

void BDecT61String PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
T61String *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, TELETEXSTRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, TELETEXSTRING_TAG_CODE)))
    {
        Asn1Error ("BDecT61String: ERROR - wrong tag\n");
        longjmp (env, 47);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecT61StringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecT61String */

AsnLen BEncVideotexString PARAMS ((b, v),
BUF_TYPE b _AND_
VideotexString *v)
{
    AsnLen l;
    l = BEncVideotexStringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, VIDEOTEXSTRING_TAG_CODE);
    return l;
} /* BEncVideotexString */

void BDecVideotexString PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
VideotexString *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, VIDEOTEXSTRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, VIDEOTEXSTRING_TAG_CODE)))
    {
        Asn1Error ("BDecVideotexString: ERROR - wrong tag\n");
        longjmp (env, 46);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecVideotexStringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecVideotexString */

AsnLen BEncIA5String PARAMS ((b, v),
BUF_TYPE b _AND_
IA5String *v)
{
    AsnLen l;
    l = BEncIA5StringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, IA5STRING_TAG_CODE);
    return l;
} /* BEncIA5String */

void BDecIA5String PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
IA5String *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, IA5STRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, IA5STRING_TAG_CODE)))
    {
        Asn1Error ("BDecIA5String: ERROR - wrong tag\n");
        longjmp (env, 45);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecIA5StringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecIA5String */

AsnLen BEncGraphicString PARAMS ((b, v),
BUF_TYPE b _AND_
GraphicString *v)
{
    AsnLen l;
    l = BEncGraphicStringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, GRAPHICSTRING_TAG_CODE);
    return l;
} /* BEncGraphicString */

void BDecGraphicString PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
GraphicString *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, GRAPHICSTRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, GRAPHICSTRING_TAG_CODE)))
    {
        Asn1Error ("BDecGraphicString: ERROR - wrong tag\n");
        longjmp (env, 44);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecGraphicStringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecGraphicString */

AsnLen BEncVisibleString PARAMS ((b, v),
BUF_TYPE b _AND_
VisibleString *v)
{
    AsnLen l;
    l = BEncVisibleStringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, VISIBLESTRING_TAG_CODE);
    return l;
} /* BEncVisibleString */

void BDecVisibleString PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
VisibleString *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, VISIBLESTRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, VISIBLESTRING_TAG_CODE)))
    {
        Asn1Error ("BDecVisibleString: ERROR - wrong tag\n");
        longjmp (env, 43);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecVisibleStringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecVisibleString */

AsnLen BEncISO646String PARAMS ((b, v),
BUF_TYPE b _AND_
ISO646String *v)
{
    AsnLen l;
    l = BEncISO646StringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, VISIBLESTRING_TAG_CODE);
    return l;
} /* BEncISO646String */

void BDecISO646String PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
ISO646String *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, VISIBLESTRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, VISIBLESTRING_TAG_CODE)))
    {
        Asn1Error ("BDecISO646String: ERROR - wrong tag\n");
        longjmp (env, 42);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecISO646StringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecISO646String */

AsnLen BEncGeneralString PARAMS ((b, v),
BUF_TYPE b _AND_
GeneralString *v)
{
    AsnLen l;
    l = BEncGeneralStringContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, GENERALSTRING_TAG_CODE);
    return l;
} /* BEncGeneralString */

void BDecGeneralString PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
GeneralString *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, GENERALSTRING_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, GENERALSTRING_TAG_CODE)))
    {
        Asn1Error ("BDecGeneralString: ERROR - wrong tag\n");
        longjmp (env, 41);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecGeneralStringContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecGeneralString */

AsnLen BEncUTCTime PARAMS ((b, v),
BUF_TYPE b _AND_
UTCTime *v)
{
    AsnLen l;
    l = BEncUTCTimeContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, UTCTIME_TAG_CODE);
    return l;
} /* BEncUTCTime */

void BDecUTCTime PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
UTCTime *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, UTCTIME_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, UTCTIME_TAG_CODE)))
    {
        Asn1Error ("BDecUTCTime: ERROR - wrong tag\n");
        longjmp (env, 40);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecUTCTimeContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecUTCTime */

AsnLen BEncGeneralizedTime PARAMS ((b, v),
BUF_TYPE b _AND_
GeneralizedTime *v)
{
    AsnLen l;
    l = BEncGeneralizedTimeContent (b, v);
    l += BEncDefLen (b, l);
    l += BEncTag1 (b, UNIV, PRIM, GENERALIZEDTIME_TAG_CODE);
    return l;
} /* BEncGeneralizedTime */

void BDecGeneralizedTime PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
GeneralizedTime *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, PRIM, GENERALIZEDTIME_TAG_CODE))&&
         (tag != MAKE_TAG_ID (UNIV, CONS, GENERALIZEDTIME_TAG_CODE)))
    {
        Asn1Error ("BDecGeneralizedTime: ERROR - wrong tag\n");
        longjmp (env, 39);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecGeneralizedTimeContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecGeneralizedTime */

AsnLen
BEncEXTERNALChoiceContent PARAMS ((b, v),
BUF_TYPE b _AND_
EXTERNALChoice *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    switch (v->choiceId)
    {
       case EXTERNALCHOICE_SINGLE_ASN1_TYPE:
    BEncEocIfNec (b);
    itemLen = BEncAsnOctsContent (b, (v->a.single_ASN1_type));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, PRIM, 4);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 0);

    totalLen += itemLen;

    break;

       case EXTERNALCHOICE_OCTET_ALIGNED:
    itemLen = BEncAsnOctsContent (b, (v->a.octet_aligned));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 1);

    totalLen += itemLen;

    break;

       case EXTERNALCHOICE_ARBITRARY:
    itemLen = BEncAsnBitsContent (b, (v->a.arbitrary));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 2);

    totalLen += itemLen;

    break;

    }
    return totalLen;

}  /* BEncEXTERNALChoiceContent */

void
BDecEXTERNALChoiceContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
EXTERNALChoice *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;
    AsnLen totalElmtsLen2 = 0;
    AsnLen elmtLen2;
    AsnTag tagId2;


    switch (tagId0)
    {
       case MAKE_TAG_ID (CNTX, CONS, 0):
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
if ((tagId1 != MAKE_TAG_ID (UNIV, PRIM, OCTETSTRING_TAG_CODE)) &&
   (tagId1 != MAKE_TAG_ID (UNIV, CONS, OCTETSTRING_TAG_CODE)))
    {
         Asn1Error ("Unexpected Tag\n");
         longjmp (env, 38);
    }

    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
        (v->choiceId) = EXTERNALCHOICE_SINGLE_ASN1_TYPE;
    (v->a.single_ASN1_type) = (AsnOcts*) Asn1Alloc (sizeof (AsnOcts));
    CheckAsn1Alloc ((v->a.single_ASN1_type), env);
    BDecAsnOctsContent (b, tagId1, elmtLen1, (v->a.single_ASN1_type), &totalElmtsLen1, env);
    if (elmtLen0 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1, env);
    break;

       case MAKE_TAG_ID (CNTX, PRIM, 1):
       case MAKE_TAG_ID (CNTX, CONS, 1):
        (v->choiceId) = EXTERNALCHOICE_OCTET_ALIGNED;
    (v->a.octet_aligned) = (AsnOcts*) Asn1Alloc (sizeof (AsnOcts));
    CheckAsn1Alloc ((v->a.octet_aligned), env);
    BDecAsnOctsContent (b, tagId0, elmtLen0, (v->a.octet_aligned), &totalElmtsLen1, env);
    break;

       case MAKE_TAG_ID (CNTX, PRIM, 2):
       case MAKE_TAG_ID (CNTX, CONS, 2):
        (v->choiceId) = EXTERNALCHOICE_ARBITRARY;
    (v->a.arbitrary) = (AsnBits*) Asn1Alloc (sizeof (AsnBits));
    CheckAsn1Alloc ((v->a.arbitrary), env);
    BDecAsnBitsContent (b, tagId0, elmtLen0, (v->a.arbitrary), &totalElmtsLen1, env);
    break;

    default:
        Asn1Error ("ERROR - unexpected tag in CHOICE\n");
        longjmp (env, 37);
        break;
    } /* end switch */
    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecEXTERNALChoiceContent */

void
PrintEXTERNALChoice PARAMS ((f, v, indent),
FILE* f _AND_
EXTERNALChoice *v _AND_
unsigned short int indent)
{
    switch (v->choiceId)
    {
      case EXTERNALCHOICE_SINGLE_ASN1_TYPE:
          fprintf (f,"single-ASN1-type ");
    PrintAsnOcts (f, (v->a.single_ASN1_type), indent + stdIndentG);
          break;

      case EXTERNALCHOICE_OCTET_ALIGNED:
          fprintf (f,"octet-aligned ");
    PrintAsnOcts (f, (v->a.octet_aligned), indent + stdIndentG);
          break;

      case EXTERNALCHOICE_ARBITRARY:
          fprintf (f,"arbitrary ");
    PrintAsnBits (f, (v->a.arbitrary), indent + stdIndentG);
          break;

    }
}  /* PrintEXTERNALChoice */

void
FreeEXTERNALChoice PARAMS ((v),
EXTERNALChoice *v)
{

    if (v == NULL)
        return;
    switch (v->choiceId)
    {
       case EXTERNALCHOICE_SINGLE_ASN1_TYPE:
    FreeAsnOcts ((v->a.single_ASN1_type));
    Asn1Free ((v->a.single_ASN1_type));

    break;

       case EXTERNALCHOICE_OCTET_ALIGNED:
    FreeAsnOcts ((v->a.octet_aligned));
    Asn1Free ((v->a.octet_aligned));

    break;

       case EXTERNALCHOICE_ARBITRARY:
    FreeAsnBits ((v->a.arbitrary));
    Asn1Free ((v->a.arbitrary));

    break;

    }
}  /* FreeEXTERNALChoice */




AsnLen BEncEXTERNAL PARAMS ((b, v),
BUF_TYPE b _AND_
EXTERNAL *v)
{
    AsnLen l;
    BEncEocIfNec (b);
    l = BEncEXTERNALContent (b, v);
    l += BEncConsLen (b, l);
    l += BEncTag1 (b, UNIV, CONS, EXTERNAL_TAG_CODE);
    return l;
} /* BEncEXTERNAL */

void BDecEXTERNAL PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
EXTERNAL *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, CONS, EXTERNAL_TAG_CODE)))
    {
        Asn1Error ("BDecEXTERNAL: ERROR - wrong tag\n");
        longjmp (env, 36);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecEXTERNALContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecEXTERNAL */

AsnLen
BEncEXTERNALContent PARAMS ((b, v),
BUF_TYPE b _AND_
EXTERNAL *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    itemLen = BEncEXTERNALChoiceContent (b, (v->encoding));

    totalLen += itemLen;

    if (ASNOCTS_PRESENT ((&v->data_value_descriptor)))
    {
    itemLen = BEncObjectDescriptorContent (b, (&v->data_value_descriptor));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, PRIM, 7);

    totalLen += itemLen;
    }

    if (NOT_NULL ((v->indirect_reference)))
    {
    itemLen = BEncAsnIntContent (b, (v->indirect_reference));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;
    }

    if (ASNOID_PRESENT ((&v->direct_reference)))
    {
    itemLen = BEncAsnOidContent (b, (&v->direct_reference));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, PRIM, 6);

    totalLen += itemLen;
    }

    return totalLen;

}  /* BEncEXTERNALContent */

void
BDecEXTERNALContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
EXTERNAL *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;
    AsnLen totalElmtsLen2 = 0;
    AsnLen elmtLen2;
    AsnTag tagId2;


    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, OID_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnOidContent (b, tagId1, elmtLen1, (&v->direct_reference), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->indirect_reference) = (AsnInt*) Asn1Alloc (sizeof (AsnInt));
    CheckAsn1Alloc ((v->indirect_reference), env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (v->indirect_reference), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, OD_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, OD_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecObjectDescriptorContent (b, tagId1, elmtLen1, (&v->data_value_descriptor), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }


    if (((tagId1 == MAKE_TAG_ID (CNTX, CONS, 0)) ||
    (tagId1 == MAKE_TAG_ID (CNTX, PRIM, 1))||
    (tagId1 == MAKE_TAG_ID (CNTX, CONS, 1)) ||
    (tagId1 == MAKE_TAG_ID (CNTX, PRIM, 2))||
    (tagId1 == MAKE_TAG_ID (CNTX, CONS, 2))))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->encoding) = (EXTERNALChoice*) Asn1Alloc (sizeof (EXTERNALChoice));
    CheckAsn1Alloc ((v->encoding), env);
    BDecEXTERNALChoiceContent (b, tagId1, elmtLen1, (v->encoding), &totalElmtsLen1, env);
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1, env);
        else if (totalElmtsLen1 != elmtLen0)
            longjmp (env, 35);
    }
    else
        longjmp (env, 34);


    if (!seqDone)
        longjmp (env, 33);

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecEXTERNALContent */

void
PrintEXTERNAL PARAMS ((f, v, indent),
FILE* f _AND_
EXTERNAL *v _AND_
unsigned short int indent)
{
    if (v == NULL)
        return;

    fprintf (f,"{ -- SEQUENCE --\n");

    if (ASNOID_PRESENT ((&v->direct_reference)))
    {
    Indent (f, indent + stdIndentG);
    fprintf (f,"direct-reference ");
    PrintAsnOid (f, (&v->direct_reference), indent + stdIndentG);
    fprintf (f, ",\n");
    }
    if (NOT_NULL ((v->indirect_reference)))
    {
    Indent (f, indent + stdIndentG);
    fprintf (f,"indirect-reference ");
    PrintAsnInt (f, (v->indirect_reference), indent + stdIndentG);
    fprintf (f, ",\n");
    }
    if (ASNOCTS_PRESENT ((&v->data_value_descriptor)))
    {
    Indent (f, indent + stdIndentG);
    fprintf (f,"data-value-descriptor ");
    PrintObjectDescriptor (f, (&v->data_value_descriptor), indent + stdIndentG);
    fprintf (f, ",\n");
    }
    Indent (f, indent + stdIndentG);
    fprintf (f,"encoding ");
    PrintEXTERNALChoice (f, (v->encoding), indent + stdIndentG);
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintEXTERNAL */

void
FreeEXTERNAL PARAMS ((v),
EXTERNAL *v)
{

    if (v == NULL)
        return;
    if (ASNOID_PRESENT ((&v->direct_reference)))
    {
    FreeAsnOid ((&v->direct_reference));
    }

    if (NOT_NULL ((v->indirect_reference)))
    {
    FreeAsnInt ((v->indirect_reference));
    Asn1Free ((v->indirect_reference));
    }

    if (ASNOCTS_PRESENT ((&v->data_value_descriptor)))
    {
    FreeObjectDescriptor ((&v->data_value_descriptor));
    }

    FreeEXTERNALChoice ((v->encoding));
    Asn1Free ((v->encoding));

}  /* FreeEXTERNAL */




