/**
 * SystemStarter.h - System Starter driver
 * Wilfredo Sanchez | wsanchez@opensource.apple.com
 * $Apple$
 **
 * Copyright (c) 1999-2001 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Copyright (c) 1999-2003 Apple Computer, Inc.  All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 **/

#ifndef _SYSTEM_STARTER_H_
#define _SYSTEM_STARTER_H_

#include "StartupDisplay.h"


#define kWelcomeToMacintoshKey  CFSTR("Welcome to Macintosh.")
#define kStartupCompleteKey     CFSTR("Startup complete.")
#define kResourcesBundleName    CFSTR("SystemStarterResources")
#define kSafeBootKey            CFSTR("Safe Boot")

#define LocalizedString(bundlePath,string) StartupItemCreateLocalizedStringWithPath((bundlePath),(string))


/* Structure to pass common objects from system_starter to the IPC handlers */
typedef struct StartupContextStorage {
    CFMutableArrayRef           aWaitingList;
    CFMutableDictionaryRef      aStatusDict;
    DisplayContext              aDisplayContext;
    int                         aServicesCount;
    int                         aRunningCount;
    CFStringRef                 aResourcesBundlePath;
} *StartupContext;

/* Action types */
typedef enum {
  kActionNone = 0,
  kActionStart,
  kActionStop,
  kActionRestart
} Action;

/* Driver */
int system_starter (Action anAction, CFStringRef aService);

#endif /* _SYSTEM_STARTER_H_ */
