/**
 * QuartzProgressBarData.c - Quartz Progress Bar Image Data
 * $Apple$
 **
 * Copyright (c) 1999-2001 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 **/

/* End caps */

#define gEndCapWidth	  8
#define gEndCapHeight	 20

static const unsigned char gEndcapData [4 * gEndCapWidth * gEndCapHeight] = {
    0, 0, 0, 1, 0, 0, 0, 3, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 
    255, 163, 163, 163, 255, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 9, 210, 
    210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 0, 
    0, 0, 9, 0, 0, 0, 3, 0, 0, 0, 6, 0, 0, 0, 19, 227, 227, 227, 255, 227, 227, 
    227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 0, 0, 0, 19, 0, 0, 0, 6, 0, 
    0, 0, 8, 0, 0, 0, 25, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 
    255, 231, 231, 231, 255, 0, 0, 0, 25, 0, 0, 0, 8, 0, 0, 0, 9, 0, 0, 0, 28, 231, 
    231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 0, 
    0, 0, 28, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 28, 222, 222, 222, 255, 222, 222, 
    222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 0, 0, 0, 28, 0, 0, 0, 9, 0, 
    0, 0, 9, 0, 0, 0, 28, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 
    255, 217, 217, 217, 255, 0, 0, 0, 28, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 28, 222, 
    222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 0, 
    0, 0, 28, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 28, 227, 227, 227, 255, 227, 227, 
    227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 0, 0, 0, 28, 0, 0, 0, 9, 0, 
    0, 0, 9, 0, 0, 0, 28, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 
    255, 233, 233, 233, 255, 0, 0, 0, 28, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 28, 240, 
    240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 0, 
    0, 0, 28, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 28, 244, 244, 244, 255, 244, 244, 
    244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 0, 0, 0, 28, 0, 0, 0, 9, 0, 
    0, 0, 9, 0, 0, 0, 28, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 
    255, 246, 246, 246, 255, 0, 0, 0, 28, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 28, 247, 
    247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 0, 
    0, 0, 28, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 28, 248, 248, 248, 255, 248, 248, 
    248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 0, 0, 0, 28, 0, 0, 0, 9, 0, 
    0, 0, 9, 0, 0, 0, 28, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 
    255, 206, 206, 206, 255, 0, 0, 0, 28, 0, 0, 0, 9, 0, 0, 0, 8, 0, 0, 0, 25, 0, 
    0, 0, 50, 0, 0, 0, 66, 0, 0, 0, 66, 0, 0, 0, 50, 0, 0, 0, 25, 0, 0, 0, 8, 0, 0, 
    0, 6, 0, 0, 0, 19, 0, 0, 0, 37, 0, 0, 0, 50, 0, 0, 0, 50, 0, 0, 0, 37, 0, 0, 0, 
    19, 0, 0, 0, 6, 0, 0, 0, 3, 0, 0, 0, 9, 0, 0, 0, 19, 0, 0, 0, 25, 0, 0, 0, 25, 
    0, 0, 0, 19, 0, 0, 0, 9, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 6, 0, 0, 
    0, 8, 0, 0, 0, 8, 0, 0, 0, 6, 0, 0, 0, 3, 0, 0, 0, 1
};


/* Back fill */

#define gBackFillWidth	128
#define gBackFillHeight	 20

static const unsigned char gBackfillData [4 * gBackFillWidth * gBackFillHeight] = {
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 163, 163, 163, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 75, 
    0, 0, 0, 75, 0, 0, 0, 75, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 
    0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 56, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 28, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 
    0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 
    0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9, 0, 0, 0, 9
};


/* Fill */

#define gFillWidth	128
#define gFillHeight	 16

static const unsigned char gFillData [4 * gFillWidth * gFillHeight] = {
    34, 71, 178, 255, 32, 69, 179, 255, 31, 71, 180, 255, 31, 74, 179, 255, 34, 80, 
    184, 255, 33, 85, 185, 255, 32, 84, 185, 255, 30, 88, 185, 255, 32, 90, 187, 
    255, 33, 89, 185, 255, 33, 84, 185, 255, 34, 83, 184, 255, 31, 78, 184, 255, 
    32, 75, 180, 255, 32, 70, 180, 255, 33, 70, 177, 255, 34, 71, 178, 255, 32, 69, 
    179, 255, 31, 71, 180, 255, 31, 74, 179, 255, 34, 80, 184, 255, 33, 85, 185, 
    255, 32, 84, 185, 255, 30, 88, 185, 255, 32, 90, 187, 255, 33, 89, 185, 255, 
    33, 84, 185, 255, 34, 83, 184, 255, 31, 78, 184, 255, 32, 75, 180, 255, 32, 70, 
    180, 255, 33, 70, 177, 255, 34, 71, 178, 255, 32, 69, 179, 255, 31, 71, 180, 
    255, 31, 74, 179, 255, 34, 80, 184, 255, 33, 85, 185, 255, 32, 84, 185, 255, 
    30, 88, 185, 255, 32, 90, 187, 255, 33, 89, 185, 255, 33, 84, 185, 255, 34, 83, 
    184, 255, 31, 78, 184, 255, 32, 75, 180, 255, 32, 70, 180, 255, 33, 70, 177, 
    255, 34, 71, 178, 255, 32, 69, 179, 255, 31, 71, 180, 255, 31, 74, 179, 255, 
    34, 80, 184, 255, 33, 85, 185, 255, 32, 84, 185, 255, 30, 88, 185, 255, 32, 90, 
    187, 255, 33, 89, 185, 255, 33, 84, 185, 255, 34, 83, 184, 255, 31, 78, 184, 
    255, 32, 75, 180, 255, 32, 70, 180, 255, 33, 70, 177, 255, 34, 71, 178, 255, 
    32, 69, 179, 255, 31, 71, 180, 255, 31, 74, 179, 255, 34, 80, 184, 255, 33, 85, 
    185, 255, 32, 84, 185, 255, 30, 88, 185, 255, 32, 90, 187, 255, 33, 89, 185, 
    255, 33, 84, 185, 255, 34, 83, 184, 255, 31, 78, 184, 255, 32, 75, 180, 255, 
    32, 70, 180, 255, 33, 70, 177, 255, 34, 71, 178, 255, 32, 69, 179, 255, 31, 71, 
    180, 255, 31, 74, 179, 255, 34, 80, 184, 255, 33, 85, 185, 255, 32, 84, 185, 
    255, 30, 88, 185, 255, 32, 90, 187, 255, 33, 89, 185, 255, 33, 84, 185, 255, 
    34, 83, 184, 255, 31, 78, 184, 255, 32, 75, 180, 255, 32, 70, 180, 255, 33, 70, 
    177, 255, 34, 71, 178, 255, 32, 69, 179, 255, 31, 71, 180, 255, 31, 74, 179, 
    255, 34, 80, 184, 255, 33, 85, 185, 255, 32, 84, 185, 255, 30, 88, 185, 255, 
    32, 90, 187, 255, 33, 89, 185, 255, 33, 84, 185, 255, 34, 83, 184, 255, 31, 78, 
    184, 255, 32, 75, 180, 255, 32, 70, 180, 255, 33, 70, 177, 255, 34, 71, 178, 
    255, 32, 69, 179, 255, 31, 71, 180, 255, 31, 74, 179, 255, 34, 80, 184, 255, 
    33, 85, 185, 255, 32, 84, 185, 255, 30, 88, 185, 255, 32, 90, 187, 255, 33, 89, 
    185, 255, 33, 84, 185, 255, 34, 83, 184, 255, 31, 78, 184, 255, 32, 75, 180, 
    255, 32, 70, 180, 255, 33, 70, 177, 255, 95, 129, 203, 255, 92, 129, 204, 255, 
    88, 130, 205, 255, 89, 131, 204, 255, 92, 135, 208, 255, 92, 139, 208, 255, 89, 
    138, 209, 255, 89, 139, 208, 255, 89, 142, 209, 255, 89, 141, 209, 255, 91, 
    140, 209, 255, 92, 139, 209, 255, 91, 135, 206, 255, 89, 130, 204, 255, 90, 
    128, 205, 255, 93, 128, 204, 255, 95, 129, 203, 255, 92, 129, 204, 255, 88, 
    130, 205, 255, 89, 131, 204, 255, 92, 135, 208, 255, 92, 139, 208, 255, 89, 
    138, 209, 255, 89, 139, 208, 255, 89, 142, 209, 255, 89, 141, 209, 255, 91, 
    140, 209, 255, 92, 139, 209, 255, 91, 135, 206, 255, 89, 130, 204, 255, 90, 
    128, 205, 255, 93, 128, 204, 255, 95, 129, 203, 255, 92, 129, 204, 255, 88, 
    130, 205, 255, 89, 131, 204, 255, 92, 135, 208, 255, 92, 139, 208, 255, 89, 
    138, 209, 255, 89, 139, 208, 255, 89, 142, 209, 255, 89, 141, 209, 255, 91, 
    140, 209, 255, 92, 139, 209, 255, 91, 135, 206, 255, 89, 130, 204, 255, 90, 
    128, 205, 255, 93, 128, 204, 255, 95, 129, 203, 255, 92, 129, 204, 255, 88, 
    130, 205, 255, 89, 131, 204, 255, 92, 135, 208, 255, 92, 139, 208, 255, 89, 
    138, 209, 255, 89, 139, 208, 255, 89, 142, 209, 255, 89, 141, 209, 255, 91, 
    140, 209, 255, 92, 139, 209, 255, 91, 135, 206, 255, 89, 130, 204, 255, 90, 
    128, 205, 255, 93, 128, 204, 255, 95, 129, 203, 255, 92, 129, 204, 255, 88, 
    130, 205, 255, 89, 131, 204, 255, 92, 135, 208, 255, 92, 139, 208, 255, 89, 
    138, 209, 255, 89, 139, 208, 255, 89, 142, 209, 255, 89, 141, 209, 255, 91, 
    140, 209, 255, 92, 139, 209, 255, 91, 135, 206, 255, 89, 130, 204, 255, 90, 
    128, 205, 255, 93, 128, 204, 255, 95, 129, 203, 255, 92, 129, 204, 255, 88, 
    130, 205, 255, 89, 131, 204, 255, 92, 135, 208, 255, 92, 139, 208, 255, 89, 
    138, 209, 255, 89, 139, 208, 255, 89, 142, 209, 255, 89, 141, 209, 255, 91, 
    140, 209, 255, 92, 139, 209, 255, 91, 135, 206, 255, 89, 130, 204, 255, 90, 
    128, 205, 255, 93, 128, 204, 255, 95, 129, 203, 255, 92, 129, 204, 255, 88, 
    130, 205, 255, 89, 131, 204, 255, 92, 135, 208, 255, 92, 139, 208, 255, 89, 
    138, 209, 255, 89, 139, 208, 255, 89, 142, 209, 255, 89, 141, 209, 255, 91, 
    140, 209, 255, 92, 139, 209, 255, 91, 135, 206, 255, 89, 130, 204, 255, 90, 
    128, 205, 255, 93, 128, 204, 255, 95, 129, 203, 255, 92, 129, 204, 255, 88, 
    130, 205, 255, 89, 131, 204, 255, 92, 135, 208, 255, 92, 139, 208, 255, 89, 
    138, 209, 255, 89, 139, 208, 255, 89, 142, 209, 255, 89, 141, 209, 255, 91, 
    140, 209, 255, 92, 139, 209, 255, 91, 135, 206, 255, 89, 130, 204, 255, 90, 
    128, 205, 255, 93, 128, 204, 255, 131, 165, 220, 255, 129, 166, 221, 255, 129, 
    169, 222, 255, 130, 171, 222, 255, 130, 171, 222, 255, 131, 174, 223, 255, 129, 
    173, 224, 255, 130, 175, 224, 255, 133, 177, 225, 255, 132, 177, 224, 255, 129, 
    174, 224, 255, 130, 174, 224, 255, 128, 171, 222, 255, 127, 169, 221, 255, 128, 
    168, 221, 255, 131, 168, 221, 255, 131, 165, 220, 255, 129, 166, 221, 255, 129, 
    169, 222, 255, 130, 171, 222, 255, 130, 171, 222, 255, 131, 174, 223, 255, 129, 
    173, 224, 255, 130, 175, 224, 255, 133, 177, 225, 255, 132, 177, 224, 255, 129, 
    174, 224, 255, 130, 174, 224, 255, 128, 171, 222, 255, 127, 169, 221, 255, 128, 
    168, 221, 255, 131, 168, 221, 255, 131, 165, 220, 255, 129, 166, 221, 255, 129, 
    169, 222, 255, 130, 171, 222, 255, 130, 171, 222, 255, 131, 174, 223, 255, 129, 
    173, 224, 255, 130, 175, 224, 255, 133, 177, 225, 255, 132, 177, 224, 255, 129, 
    174, 224, 255, 130, 174, 224, 255, 128, 171, 222, 255, 127, 169, 221, 255, 128, 
    168, 221, 255, 131, 168, 221, 255, 131, 165, 220, 255, 129, 166, 221, 255, 129, 
    169, 222, 255, 130, 171, 222, 255, 130, 171, 222, 255, 131, 174, 223, 255, 129, 
    173, 224, 255, 130, 175, 224, 255, 133, 177, 225, 255, 132, 177, 224, 255, 129, 
    174, 224, 255, 130, 174, 224, 255, 128, 171, 222, 255, 127, 169, 221, 255, 128, 
    168, 221, 255, 131, 168, 221, 255, 131, 165, 220, 255, 129, 166, 221, 255, 129, 
    169, 222, 255, 130, 171, 222, 255, 130, 171, 222, 255, 131, 174, 223, 255, 129, 
    173, 224, 255, 130, 175, 224, 255, 133, 177, 225, 255, 132, 177, 224, 255, 129, 
    174, 224, 255, 130, 174, 224, 255, 128, 171, 222, 255, 127, 169, 221, 255, 128, 
    168, 221, 255, 131, 168, 221, 255, 131, 165, 220, 255, 129, 166, 221, 255, 129, 
    169, 222, 255, 130, 171, 222, 255, 130, 171, 222, 255, 131, 174, 223, 255, 129, 
    173, 224, 255, 130, 175, 224, 255, 133, 177, 225, 255, 132, 177, 224, 255, 129, 
    174, 224, 255, 130, 174, 224, 255, 128, 171, 222, 255, 127, 169, 221, 255, 128, 
    168, 221, 255, 131, 168, 221, 255, 131, 165, 220, 255, 129, 166, 221, 255, 129, 
    169, 222, 255, 130, 171, 222, 255, 130, 171, 222, 255, 131, 174, 223, 255, 129, 
    173, 224, 255, 130, 175, 224, 255, 133, 177, 225, 255, 132, 177, 224, 255, 129, 
    174, 224, 255, 130, 174, 224, 255, 128, 171, 222, 255, 127, 169, 221, 255, 128, 
    168, 221, 255, 131, 168, 221, 255, 131, 165, 220, 255, 129, 166, 221, 255, 129, 
    169, 222, 255, 130, 171, 222, 255, 130, 171, 222, 255, 131, 174, 223, 255, 129, 
    173, 224, 255, 130, 175, 224, 255, 133, 177, 225, 255, 132, 177, 224, 255, 129, 
    174, 224, 255, 130, 174, 224, 255, 128, 171, 222, 255, 127, 169, 221, 255, 128, 
    168, 221, 255, 131, 168, 221, 255, 137, 176, 224, 255, 137, 177, 225, 255, 142, 
    181, 227, 255, 143, 184, 228, 255, 140, 182, 227, 255, 143, 185, 228, 255, 145, 
    186, 229, 255, 147, 188, 230, 255, 150, 189, 231, 255, 149, 189, 229, 255, 142, 
    184, 229, 255, 141, 184, 228, 255, 140, 182, 229, 255, 139, 182, 227, 255, 138, 
    180, 227, 255, 140, 180, 227, 255, 137, 176, 224, 255, 137, 177, 225, 255, 142, 
    181, 227, 255, 143, 184, 228, 255, 140, 182, 227, 255, 143, 185, 228, 255, 145, 
    186, 229, 255, 147, 188, 230, 255, 150, 189, 231, 255, 149, 189, 229, 255, 142, 
    184, 229, 255, 141, 184, 228, 255, 140, 182, 229, 255, 139, 182, 227, 255, 138, 
    180, 227, 255, 140, 180, 227, 255, 137, 176, 224, 255, 137, 177, 225, 255, 142, 
    181, 227, 255, 143, 184, 228, 255, 140, 182, 227, 255, 143, 185, 228, 255, 145, 
    186, 229, 255, 147, 188, 230, 255, 150, 189, 231, 255, 149, 189, 229, 255, 142, 
    184, 229, 255, 141, 184, 228, 255, 140, 182, 229, 255, 139, 182, 227, 255, 138, 
    180, 227, 255, 140, 180, 227, 255, 137, 176, 224, 255, 137, 177, 225, 255, 142, 
    181, 227, 255, 143, 184, 228, 255, 140, 182, 227, 255, 143, 185, 228, 255, 145, 
    186, 229, 255, 147, 188, 230, 255, 150, 189, 231, 255, 149, 189, 229, 255, 142, 
    184, 229, 255, 141, 184, 228, 255, 140, 182, 229, 255, 139, 182, 227, 255, 138, 
    180, 227, 255, 140, 180, 227, 255, 137, 176, 224, 255, 137, 177, 225, 255, 142, 
    181, 227, 255, 143, 184, 228, 255, 140, 182, 227, 255, 143, 185, 228, 255, 145, 
    186, 229, 255, 147, 188, 230, 255, 150, 189, 231, 255, 149, 189, 229, 255, 142, 
    184, 229, 255, 141, 184, 228, 255, 140, 182, 229, 255, 139, 182, 227, 255, 138, 
    180, 227, 255, 140, 180, 227, 255, 137, 176, 224, 255, 137, 177, 225, 255, 142, 
    181, 227, 255, 143, 184, 228, 255, 140, 182, 227, 255, 143, 185, 228, 255, 145, 
    186, 229, 255, 147, 188, 230, 255, 150, 189, 231, 255, 149, 189, 229, 255, 142, 
    184, 229, 255, 141, 184, 228, 255, 140, 182, 229, 255, 139, 182, 227, 255, 138, 
    180, 227, 255, 140, 180, 227, 255, 137, 176, 224, 255, 137, 177, 225, 255, 142, 
    181, 227, 255, 143, 184, 228, 255, 140, 182, 227, 255, 143, 185, 228, 255, 145, 
    186, 229, 255, 147, 188, 230, 255, 150, 189, 231, 255, 149, 189, 229, 255, 142, 
    184, 229, 255, 141, 184, 228, 255, 140, 182, 229, 255, 139, 182, 227, 255, 138, 
    180, 227, 255, 140, 180, 227, 255, 137, 176, 224, 255, 137, 177, 225, 255, 142, 
    181, 227, 255, 143, 184, 228, 255, 140, 182, 227, 255, 143, 185, 228, 255, 145, 
    186, 229, 255, 147, 188, 230, 255, 150, 189, 231, 255, 149, 189, 229, 255, 142, 
    184, 229, 255, 141, 184, 228, 255, 140, 182, 229, 255, 139, 182, 227, 255, 138, 
    180, 227, 255, 140, 180, 227, 255, 130, 178, 225, 255, 130, 178, 225, 255, 136, 
    180, 228, 255, 138, 183, 228, 255, 137, 180, 228, 255, 141, 184, 229, 255, 146, 
    186, 230, 255, 148, 188, 230, 255, 149, 188, 231, 255, 147, 187, 230, 255, 143, 
    185, 230, 255, 141, 184, 229, 255, 140, 181, 229, 255, 137, 181, 228, 255, 134, 
    179, 228, 255, 135, 179, 228, 255, 130, 178, 225, 255, 130, 178, 225, 255, 136, 
    180, 228, 255, 138, 183, 228, 255, 137, 180, 228, 255, 141, 184, 229, 255, 146, 
    186, 230, 255, 148, 188, 230, 255, 149, 188, 231, 255, 147, 187, 230, 255, 143, 
    185, 230, 255, 141, 184, 229, 255, 140, 181, 229, 255, 137, 181, 228, 255, 134, 
    179, 228, 255, 135, 179, 228, 255, 130, 178, 225, 255, 130, 178, 225, 255, 136, 
    180, 228, 255, 138, 183, 228, 255, 137, 180, 228, 255, 141, 184, 229, 255, 146, 
    186, 230, 255, 148, 188, 230, 255, 149, 188, 231, 255, 147, 187, 230, 255, 143, 
    185, 230, 255, 141, 184, 229, 255, 140, 181, 229, 255, 137, 181, 228, 255, 134, 
    179, 228, 255, 135, 179, 228, 255, 130, 178, 225, 255, 130, 178, 225, 255, 136, 
    180, 228, 255, 138, 183, 228, 255, 137, 180, 228, 255, 141, 184, 229, 255, 146, 
    186, 230, 255, 148, 188, 230, 255, 149, 188, 231, 255, 147, 187, 230, 255, 143, 
    185, 230, 255, 141, 184, 229, 255, 140, 181, 229, 255, 137, 181, 228, 255, 134, 
    179, 228, 255, 135, 179, 228, 255, 130, 178, 225, 255, 130, 178, 225, 255, 136, 
    180, 228, 255, 138, 183, 228, 255, 137, 180, 228, 255, 141, 184, 229, 255, 146, 
    186, 230, 255, 148, 188, 230, 255, 149, 188, 231, 255, 147, 187, 230, 255, 143, 
    185, 230, 255, 141, 184, 229, 255, 140, 181, 229, 255, 137, 181, 228, 255, 134, 
    179, 228, 255, 135, 179, 228, 255, 130, 178, 225, 255, 130, 178, 225, 255, 136, 
    180, 228, 255, 138, 183, 228, 255, 137, 180, 228, 255, 141, 184, 229, 255, 146, 
    186, 230, 255, 148, 188, 230, 255, 149, 188, 231, 255, 147, 187, 230, 255, 143, 
    185, 230, 255, 141, 184, 229, 255, 140, 181, 229, 255, 137, 181, 228, 255, 134, 
    179, 228, 255, 135, 179, 228, 255, 130, 178, 225, 255, 130, 178, 225, 255, 136, 
    180, 228, 255, 138, 183, 228, 255, 137, 180, 228, 255, 141, 184, 229, 255, 146, 
    186, 230, 255, 148, 188, 230, 255, 149, 188, 231, 255, 147, 187, 230, 255, 143, 
    185, 230, 255, 141, 184, 229, 255, 140, 181, 229, 255, 137, 181, 228, 255, 134, 
    179, 228, 255, 135, 179, 228, 255, 130, 178, 225, 255, 130, 178, 225, 255, 136, 
    180, 228, 255, 138, 183, 228, 255, 137, 180, 228, 255, 141, 184, 229, 255, 146, 
    186, 230, 255, 148, 188, 230, 255, 149, 188, 231, 255, 147, 187, 230, 255, 143, 
    185, 230, 255, 141, 184, 229, 255, 140, 181, 229, 255, 137, 181, 228, 255, 134, 
    179, 228, 255, 135, 179, 228, 255, 119, 171, 224, 255, 120, 171, 227, 255, 124, 
    173, 227, 255, 124, 174, 227, 255, 129, 175, 228, 255, 130, 178, 228, 255, 131, 
    178, 229, 255, 133, 180, 228, 255, 136, 180, 229, 255, 136, 180, 229, 255, 135, 
    180, 229, 255, 131, 178, 228, 255, 127, 174, 228, 255, 124, 173, 225, 255, 123, 
    173, 227, 255, 119, 171, 225, 255, 119, 171, 224, 255, 120, 171, 227, 255, 124, 
    173, 227, 255, 124, 174, 227, 255, 129, 175, 228, 255, 130, 178, 228, 255, 131, 
    178, 229, 255, 133, 180, 228, 255, 136, 180, 229, 255, 136, 180, 229, 255, 135, 
    180, 229, 255, 131, 178, 228, 255, 127, 174, 228, 255, 124, 173, 225, 255, 123, 
    173, 227, 255, 119, 171, 225, 255, 119, 171, 224, 255, 120, 171, 227, 255, 124, 
    173, 227, 255, 124, 174, 227, 255, 129, 175, 228, 255, 130, 178, 228, 255, 131, 
    178, 229, 255, 133, 180, 228, 255, 136, 180, 229, 255, 136, 180, 229, 255, 135, 
    180, 229, 255, 131, 178, 228, 255, 127, 174, 228, 255, 124, 173, 225, 255, 123, 
    173, 227, 255, 119, 171, 225, 255, 119, 171, 224, 255, 120, 171, 227, 255, 124, 
    173, 227, 255, 124, 174, 227, 255, 129, 175, 228, 255, 130, 178, 228, 255, 131, 
    178, 229, 255, 133, 180, 228, 255, 136, 180, 229, 255, 136, 180, 229, 255, 135, 
    180, 229, 255, 131, 178, 228, 255, 127, 174, 228, 255, 124, 173, 225, 255, 123, 
    173, 227, 255, 119, 171, 225, 255, 119, 171, 224, 255, 120, 171, 227, 255, 124, 
    173, 227, 255, 124, 174, 227, 255, 129, 175, 228, 255, 130, 178, 228, 255, 131, 
    178, 229, 255, 133, 180, 228, 255, 136, 180, 229, 255, 136, 180, 229, 255, 135, 
    180, 229, 255, 131, 178, 228, 255, 127, 174, 228, 255, 124, 173, 225, 255, 123, 
    173, 227, 255, 119, 171, 225, 255, 119, 171, 224, 255, 120, 171, 227, 255, 124, 
    173, 227, 255, 124, 174, 227, 255, 129, 175, 228, 255, 130, 178, 228, 255, 131, 
    178, 229, 255, 133, 180, 228, 255, 136, 180, 229, 255, 136, 180, 229, 255, 135, 
    180, 229, 255, 131, 178, 228, 255, 127, 174, 228, 255, 124, 173, 225, 255, 123, 
    173, 227, 255, 119, 171, 225, 255, 119, 171, 224, 255, 120, 171, 227, 255, 124, 
    173, 227, 255, 124, 174, 227, 255, 129, 175, 228, 255, 130, 178, 228, 255, 131, 
    178, 229, 255, 133, 180, 228, 255, 136, 180, 229, 255, 136, 180, 229, 255, 135, 
    180, 229, 255, 131, 178, 228, 255, 127, 174, 228, 255, 124, 173, 225, 255, 123, 
    173, 227, 255, 119, 171, 225, 255, 119, 171, 224, 255, 120, 171, 227, 255, 124, 
    173, 227, 255, 124, 174, 227, 255, 129, 175, 228, 255, 130, 178, 228, 255, 131, 
    178, 229, 255, 133, 180, 228, 255, 136, 180, 229, 255, 136, 180, 229, 255, 135, 
    180, 229, 255, 131, 178, 228, 255, 127, 174, 228, 255, 124, 173, 225, 255, 123, 
    173, 227, 255, 119, 171, 225, 255, 92, 153, 220, 255, 97, 156, 223, 255, 93, 
    154, 224, 255, 96, 157, 224, 255, 104, 160, 226, 255, 108, 164, 226, 255, 108, 
    164, 228, 255, 111, 166, 225, 255, 113, 169, 227, 255, 111, 167, 227, 255, 112, 
    167, 228, 255, 106, 163, 225, 255, 103, 160, 225, 255, 100, 159, 224, 255, 94, 
    155, 222, 255, 94, 155, 223, 255, 92, 153, 220, 255, 97, 156, 223, 255, 93, 
    154, 224, 255, 96, 157, 224, 255, 104, 160, 226, 255, 108, 164, 226, 255, 108, 
    164, 228, 255, 111, 166, 225, 255, 113, 169, 227, 255, 111, 167, 227, 255, 112, 
    167, 228, 255, 106, 163, 225, 255, 103, 160, 225, 255, 100, 159, 224, 255, 94, 
    155, 222, 255, 94, 155, 223, 255, 92, 153, 220, 255, 97, 156, 223, 255, 93, 
    154, 224, 255, 96, 157, 224, 255, 104, 160, 226, 255, 108, 164, 226, 255, 108, 
    164, 228, 255, 111, 166, 225, 255, 113, 169, 227, 255, 111, 167, 227, 255, 112, 
    167, 228, 255, 106, 163, 225, 255, 103, 160, 225, 255, 100, 159, 224, 255, 94, 
    155, 222, 255, 94, 155, 223, 255, 92, 153, 220, 255, 97, 156, 223, 255, 93, 
    154, 224, 255, 96, 157, 224, 255, 104, 160, 226, 255, 108, 164, 226, 255, 108, 
    164, 228, 255, 111, 166, 225, 255, 113, 169, 227, 255, 111, 167, 227, 255, 112, 
    167, 228, 255, 106, 163, 225, 255, 103, 160, 225, 255, 100, 159, 224, 255, 94, 
    155, 222, 255, 94, 155, 223, 255, 92, 153, 220, 255, 97, 156, 223, 255, 93, 
    154, 224, 255, 96, 157, 224, 255, 104, 160, 226, 255, 108, 164, 226, 255, 108, 
    164, 228, 255, 111, 166, 225, 255, 113, 169, 227, 255, 111, 167, 227, 255, 112, 
    167, 228, 255, 106, 163, 225, 255, 103, 160, 225, 255, 100, 159, 224, 255, 94, 
    155, 222, 255, 94, 155, 223, 255, 92, 153, 220, 255, 97, 156, 223, 255, 93, 
    154, 224, 255, 96, 157, 224, 255, 104, 160, 226, 255, 108, 164, 226, 255, 108, 
    164, 228, 255, 111, 166, 225, 255, 113, 169, 227, 255, 111, 167, 227, 255, 112, 
    167, 228, 255, 106, 163, 225, 255, 103, 160, 225, 255, 100, 159, 224, 255, 94, 
    155, 222, 255, 94, 155, 223, 255, 92, 153, 220, 255, 97, 156, 223, 255, 93, 
    154, 224, 255, 96, 157, 224, 255, 104, 160, 226, 255, 108, 164, 226, 255, 108, 
    164, 228, 255, 111, 166, 225, 255, 113, 169, 227, 255, 111, 167, 227, 255, 112, 
    167, 228, 255, 106, 163, 225, 255, 103, 160, 225, 255, 100, 159, 224, 255, 94, 
    155, 222, 255, 94, 155, 223, 255, 92, 153, 220, 255, 97, 156, 223, 255, 93, 
    154, 224, 255, 96, 157, 224, 255, 104, 160, 226, 255, 108, 164, 226, 255, 108, 
    164, 228, 255, 111, 166, 225, 255, 113, 169, 227, 255, 111, 167, 227, 255, 112, 
    167, 228, 255, 106, 163, 225, 255, 103, 160, 225, 255, 100, 159, 224, 255, 94, 
    155, 222, 255, 94, 155, 223, 255, 61, 134, 218, 255, 65, 137, 222, 255, 67, 
    139, 223, 255, 69, 140, 223, 255, 75, 144, 224, 255, 81, 149, 224, 255, 81, 
    149, 226, 255, 82, 151, 225, 255, 88, 154, 227, 255, 83, 152, 226, 255, 82, 
    150, 227, 255, 81, 149, 226, 255, 76, 146, 225, 255, 71, 143, 223, 255, 68, 
    140, 225, 255, 66, 139, 223, 255, 61, 134, 218, 255, 65, 137, 222, 255, 67, 
    139, 223, 255, 69, 140, 223, 255, 75, 144, 224, 255, 81, 149, 224, 255, 81, 
    149, 226, 255, 82, 151, 225, 255, 88, 154, 227, 255, 83, 152, 226, 255, 82, 
    150, 227, 255, 81, 149, 226, 255, 76, 146, 225, 255, 71, 143, 223, 255, 68, 
    140, 225, 255, 66, 139, 223, 255, 61, 134, 218, 255, 65, 137, 222, 255, 67, 
    139, 223, 255, 69, 140, 223, 255, 75, 144, 224, 255, 81, 149, 224, 255, 81, 
    149, 226, 255, 82, 151, 225, 255, 88, 154, 227, 255, 83, 152, 226, 255, 82, 
    150, 227, 255, 81, 149, 226, 255, 76, 146, 225, 255, 71, 143, 223, 255, 68, 
    140, 225, 255, 66, 139, 223, 255, 61, 134, 218, 255, 65, 137, 222, 255, 67, 
    139, 223, 255, 69, 140, 223, 255, 75, 144, 224, 255, 81, 149, 224, 255, 81, 
    149, 226, 255, 82, 151, 225, 255, 88, 154, 227, 255, 83, 152, 226, 255, 82, 
    150, 227, 255, 81, 149, 226, 255, 76, 146, 225, 255, 71, 143, 223, 255, 68, 
    140, 225, 255, 66, 139, 223, 255, 61, 134, 218, 255, 65, 137, 222, 255, 67, 
    139, 223, 255, 69, 140, 223, 255, 75, 144, 224, 255, 81, 149, 224, 255, 81, 
    149, 226, 255, 82, 151, 225, 255, 88, 154, 227, 255, 83, 152, 226, 255, 82, 
    150, 227, 255, 81, 149, 226, 255, 76, 146, 225, 255, 71, 143, 223, 255, 68, 
    140, 225, 255, 66, 139, 223, 255, 61, 134, 218, 255, 65, 137, 222, 255, 67, 
    139, 223, 255, 69, 140, 223, 255, 75, 144, 224, 255, 81, 149, 224, 255, 81, 
    149, 226, 255, 82, 151, 225, 255, 88, 154, 227, 255, 83, 152, 226, 255, 82, 
    150, 227, 255, 81, 149, 226, 255, 76, 146, 225, 255, 71, 143, 223, 255, 68, 
    140, 225, 255, 66, 139, 223, 255, 61, 134, 218, 255, 65, 137, 222, 255, 67, 
    139, 223, 255, 69, 140, 223, 255, 75, 144, 224, 255, 81, 149, 224, 255, 81, 
    149, 226, 255, 82, 151, 225, 255, 88, 154, 227, 255, 83, 152, 226, 255, 82, 
    150, 227, 255, 81, 149, 226, 255, 76, 146, 225, 255, 71, 143, 223, 255, 68, 
    140, 225, 255, 66, 139, 223, 255, 61, 134, 218, 255, 65, 137, 222, 255, 67, 
    139, 223, 255, 69, 140, 223, 255, 75, 144, 224, 255, 81, 149, 224, 255, 81, 
    149, 226, 255, 82, 151, 225, 255, 88, 154, 227, 255, 83, 152, 226, 255, 82, 
    150, 227, 255, 81, 149, 226, 255, 76, 146, 225, 255, 71, 143, 223, 255, 68, 
    140, 225, 255, 66, 139, 223, 255, 50, 130, 222, 255, 54, 132, 226, 255, 59, 
    136, 228, 255, 61, 139, 228, 255, 65, 140, 228, 255, 70, 146, 229, 255, 71, 
    147, 232, 255, 74, 150, 231, 255, 79, 151, 233, 255, 75, 150, 232, 255, 71, 
    147, 231, 255, 71, 146, 231, 255, 67, 143, 231, 255, 60, 140, 228, 255, 60, 
    137, 230, 255, 55, 134, 228, 255, 50, 130, 222, 255, 54, 132, 226, 255, 59, 
    136, 228, 255, 61, 139, 228, 255, 65, 140, 228, 255, 70, 146, 229, 255, 71, 
    147, 232, 255, 74, 150, 231, 255, 79, 151, 233, 255, 75, 150, 232, 255, 71, 
    147, 231, 255, 71, 146, 231, 255, 67, 143, 231, 255, 60, 140, 228, 255, 60, 
    137, 230, 255, 55, 134, 228, 255, 50, 130, 222, 255, 54, 132, 226, 255, 59, 
    136, 228, 255, 61, 139, 228, 255, 65, 140, 228, 255, 70, 146, 229, 255, 71, 
    147, 232, 255, 74, 150, 231, 255, 79, 151, 233, 255, 75, 150, 232, 255, 71, 
    147, 231, 255, 71, 146, 231, 255, 67, 143, 231, 255, 60, 140, 228, 255, 60, 
    137, 230, 255, 55, 134, 228, 255, 50, 130, 222, 255, 54, 132, 226, 255, 59, 
    136, 228, 255, 61, 139, 228, 255, 65, 140, 228, 255, 70, 146, 229, 255, 71, 
    147, 232, 255, 74, 150, 231, 255, 79, 151, 233, 255, 75, 150, 232, 255, 71, 
    147, 231, 255, 71, 146, 231, 255, 67, 143, 231, 255, 60, 140, 228, 255, 60, 
    137, 230, 255, 55, 134, 228, 255, 50, 130, 222, 255, 54, 132, 226, 255, 59, 
    136, 228, 255, 61, 139, 228, 255, 65, 140, 228, 255, 70, 146, 229, 255, 71, 
    147, 232, 255, 74, 150, 231, 255, 79, 151, 233, 255, 75, 150, 232, 255, 71, 
    147, 231, 255, 71, 146, 231, 255, 67, 143, 231, 255, 60, 140, 228, 255, 60, 
    137, 230, 255, 55, 134, 228, 255, 50, 130, 222, 255, 54, 132, 226, 255, 59, 
    136, 228, 255, 61, 139, 228, 255, 65, 140, 228, 255, 70, 146, 229, 255, 71, 
    147, 232, 255, 74, 150, 231, 255, 79, 151, 233, 255, 75, 150, 232, 255, 71, 
    147, 231, 255, 71, 146, 231, 255, 67, 143, 231, 255, 60, 140, 228, 255, 60, 
    137, 230, 255, 55, 134, 228, 255, 50, 130, 222, 255, 54, 132, 226, 255, 59, 
    136, 228, 255, 61, 139, 228, 255, 65, 140, 228, 255, 70, 146, 229, 255, 71, 
    147, 232, 255, 74, 150, 231, 255, 79, 151, 233, 255, 75, 150, 232, 255, 71, 
    147, 231, 255, 71, 146, 231, 255, 67, 143, 231, 255, 60, 140, 228, 255, 60, 
    137, 230, 255, 55, 134, 228, 255, 50, 130, 222, 255, 54, 132, 226, 255, 59, 
    136, 228, 255, 61, 139, 228, 255, 65, 140, 228, 255, 70, 146, 229, 255, 71, 
    147, 232, 255, 74, 150, 231, 255, 79, 151, 233, 255, 75, 150, 232, 255, 71, 
    147, 231, 255, 71, 146, 231, 255, 67, 143, 231, 255, 60, 140, 228, 255, 60, 
    137, 230, 255, 55, 134, 228, 255, 60, 141, 233, 255, 64, 142, 236, 255, 68, 
    145, 238, 255, 71, 151, 239, 255, 74, 150, 240, 255, 77, 154, 241, 255, 80, 
    157, 244, 255, 88, 161, 242, 255, 88, 162, 243, 255, 87, 161, 244, 255, 81, 
    158, 243, 255, 76, 154, 239, 255, 77, 153, 241, 255, 70, 150, 239, 255, 67, 
    144, 238, 255, 62, 142, 238, 255, 60, 141, 233, 255, 64, 142, 236, 255, 68, 
    145, 238, 255, 71, 151, 239, 255, 74, 150, 240, 255, 77, 154, 241, 255, 80, 
    157, 244, 255, 88, 161, 242, 255, 88, 162, 243, 255, 87, 161, 244, 255, 81, 
    158, 243, 255, 76, 154, 239, 255, 77, 153, 241, 255, 70, 150, 239, 255, 67, 
    144, 238, 255, 62, 142, 238, 255, 60, 141, 233, 255, 64, 142, 236, 255, 68, 
    145, 238, 255, 71, 151, 239, 255, 74, 150, 240, 255, 77, 154, 241, 255, 80, 
    157, 244, 255, 88, 161, 242, 255, 88, 162, 243, 255, 87, 161, 244, 255, 81, 
    158, 243, 255, 76, 154, 239, 255, 77, 153, 241, 255, 70, 150, 239, 255, 67, 
    144, 238, 255, 62, 142, 238, 255, 60, 141, 233, 255, 64, 142, 236, 255, 68, 
    145, 238, 255, 71, 151, 239, 255, 74, 150, 240, 255, 77, 154, 241, 255, 80, 
    157, 244, 255, 88, 161, 242, 255, 88, 162, 243, 255, 87, 161, 244, 255, 81, 
    158, 243, 255, 76, 154, 239, 255, 77, 153, 241, 255, 70, 150, 239, 255, 67, 
    144, 238, 255, 62, 142, 238, 255, 60, 141, 233, 255, 64, 142, 236, 255, 68, 
    145, 238, 255, 71, 151, 239, 255, 74, 150, 240, 255, 77, 154, 241, 255, 80, 
    157, 244, 255, 88, 161, 242, 255, 88, 162, 243, 255, 87, 161, 244, 255, 81, 
    158, 243, 255, 76, 154, 239, 255, 77, 153, 241, 255, 70, 150, 239, 255, 67, 
    144, 238, 255, 62, 142, 238, 255, 60, 141, 233, 255, 64, 142, 236, 255, 68, 
    145, 238, 255, 71, 151, 239, 255, 74, 150, 240, 255, 77, 154, 241, 255, 80, 
    157, 244, 255, 88, 161, 242, 255, 88, 162, 243, 255, 87, 161, 244, 255, 81, 
    158, 243, 255, 76, 154, 239, 255, 77, 153, 241, 255, 70, 150, 239, 255, 67, 
    144, 238, 255, 62, 142, 238, 255, 60, 141, 233, 255, 64, 142, 236, 255, 68, 
    145, 238, 255, 71, 151, 239, 255, 74, 150, 240, 255, 77, 154, 241, 255, 80, 
    157, 244, 255, 88, 161, 242, 255, 88, 162, 243, 255, 87, 161, 244, 255, 81, 
    158, 243, 255, 76, 154, 239, 255, 77, 153, 241, 255, 70, 150, 239, 255, 67, 
    144, 238, 255, 62, 142, 238, 255, 60, 141, 233, 255, 64, 142, 236, 255, 68, 
    145, 238, 255, 71, 151, 239, 255, 74, 150, 240, 255, 77, 154, 241, 255, 80, 
    157, 244, 255, 88, 161, 242, 255, 88, 162, 243, 255, 87, 161, 244, 255, 81, 
    158, 243, 255, 76, 154, 239, 255, 77, 153, 241, 255, 70, 150, 239, 255, 67, 
    144, 238, 255, 62, 142, 238, 255, 71, 152, 246, 255, 74, 155, 248, 255, 80, 
    160, 250, 255, 83, 161, 249, 255, 88, 165, 253, 255, 87, 165, 250, 255, 94, 
    171, 254, 255, 97, 172, 254, 255, 104, 178, 255, 255, 96, 171, 253, 255, 93, 
    169, 255, 255, 88, 166, 251, 255, 88, 165, 253, 255, 82, 161, 250, 255, 75, 
    154, 248, 255, 74, 155, 248, 255, 71, 152, 246, 255, 74, 155, 248, 255, 80, 
    160, 250, 255, 83, 161, 249, 255, 88, 165, 253, 255, 87, 165, 250, 255, 94, 
    171, 254, 255, 97, 172, 254, 255, 104, 178, 255, 255, 96, 171, 253, 255, 93, 
    169, 255, 255, 88, 166, 251, 255, 88, 165, 253, 255, 82, 161, 250, 255, 75, 
    154, 248, 255, 74, 155, 248, 255, 71, 152, 246, 255, 74, 155, 248, 255, 80, 
    160, 250, 255, 83, 161, 249, 255, 88, 165, 253, 255, 87, 165, 250, 255, 94, 
    171, 254, 255, 97, 172, 254, 255, 104, 178, 255, 255, 96, 171, 253, 255, 93, 
    169, 255, 255, 88, 166, 251, 255, 88, 165, 253, 255, 82, 161, 250, 255, 75, 
    154, 248, 255, 74, 155, 248, 255, 71, 152, 246, 255, 74, 155, 248, 255, 80, 
    160, 250, 255, 83, 161, 249, 255, 88, 165, 253, 255, 87, 165, 250, 255, 94, 
    171, 254, 255, 97, 172, 254, 255, 104, 178, 255, 255, 96, 171, 253, 255, 93, 
    169, 255, 255, 88, 166, 251, 255, 88, 165, 253, 255, 82, 161, 250, 255, 75, 
    154, 248, 255, 74, 155, 248, 255, 71, 152, 246, 255, 74, 155, 248, 255, 80, 
    160, 250, 255, 83, 161, 249, 255, 88, 165, 253, 255, 87, 165, 250, 255, 94, 
    171, 254, 255, 97, 172, 254, 255, 104, 178, 255, 255, 96, 171, 253, 255, 93, 
    169, 255, 255, 88, 166, 251, 255, 88, 165, 253, 255, 82, 161, 250, 255, 75, 
    154, 248, 255, 74, 155, 248, 255, 71, 152, 246, 255, 74, 155, 248, 255, 80, 
    160, 250, 255, 83, 161, 249, 255, 88, 165, 253, 255, 87, 165, 250, 255, 94, 
    171, 254, 255, 97, 172, 254, 255, 104, 178, 255, 255, 96, 171, 253, 255, 93, 
    169, 255, 255, 88, 166, 251, 255, 88, 165, 253, 255, 82, 161, 250, 255, 75, 
    154, 248, 255, 74, 155, 248, 255, 71, 152, 246, 255, 74, 155, 248, 255, 80, 
    160, 250, 255, 83, 161, 249, 255, 88, 165, 253, 255, 87, 165, 250, 255, 94, 
    171, 254, 255, 97, 172, 254, 255, 104, 178, 255, 255, 96, 171, 253, 255, 93, 
    169, 255, 255, 88, 166, 251, 255, 88, 165, 253, 255, 82, 161, 250, 255, 75, 
    154, 248, 255, 74, 155, 248, 255, 71, 152, 246, 255, 74, 155, 248, 255, 80, 
    160, 250, 255, 83, 161, 249, 255, 88, 165, 253, 255, 87, 165, 250, 255, 94, 
    171, 254, 255, 97, 172, 254, 255, 104, 178, 255, 255, 96, 171, 253, 255, 93, 
    169, 255, 255, 88, 166, 251, 255, 88, 165, 253, 255, 82, 161, 250, 255, 75, 
    154, 248, 255, 74, 155, 248, 255, 82, 164, 254, 255, 84, 165, 254, 255, 92, 
    171, 254, 255, 93, 175, 254, 255, 96, 174, 255, 255, 100, 178, 254, 255, 103, 
    181, 255, 255, 110, 186, 255, 255, 114, 189, 255, 255, 112, 186, 255, 255, 106, 
    182, 255, 255, 101, 181, 255, 255, 98, 176, 255, 255, 92, 174, 254, 255, 88, 
    170, 254, 255, 85, 167, 254, 255, 82, 164, 254, 255, 84, 165, 254, 255, 92, 
    171, 254, 255, 93, 175, 254, 255, 96, 174, 255, 255, 100, 178, 254, 255, 103, 
    181, 255, 255, 110, 186, 255, 255, 114, 189, 255, 255, 112, 186, 255, 255, 106, 
    182, 255, 255, 101, 181, 255, 255, 98, 176, 255, 255, 92, 174, 254, 255, 88, 
    170, 254, 255, 85, 167, 254, 255, 82, 164, 254, 255, 84, 165, 254, 255, 92, 
    171, 254, 255, 93, 175, 254, 255, 96, 174, 255, 255, 100, 178, 254, 255, 103, 
    181, 255, 255, 110, 186, 255, 255, 114, 189, 255, 255, 112, 186, 255, 255, 106, 
    182, 255, 255, 101, 181, 255, 255, 98, 176, 255, 255, 92, 174, 254, 255, 88, 
    170, 254, 255, 85, 167, 254, 255, 82, 164, 254, 255, 84, 165, 254, 255, 92, 
    171, 254, 255, 93, 175, 254, 255, 96, 174, 255, 255, 100, 178, 254, 255, 103, 
    181, 255, 255, 110, 186, 255, 255, 114, 189, 255, 255, 112, 186, 255, 255, 106, 
    182, 255, 255, 101, 181, 255, 255, 98, 176, 255, 255, 92, 174, 254, 255, 88, 
    170, 254, 255, 85, 167, 254, 255, 82, 164, 254, 255, 84, 165, 254, 255, 92, 
    171, 254, 255, 93, 175, 254, 255, 96, 174, 255, 255, 100, 178, 254, 255, 103, 
    181, 255, 255, 110, 186, 255, 255, 114, 189, 255, 255, 112, 186, 255, 255, 106, 
    182, 255, 255, 101, 181, 255, 255, 98, 176, 255, 255, 92, 174, 254, 255, 88, 
    170, 254, 255, 85, 167, 254, 255, 82, 164, 254, 255, 84, 165, 254, 255, 92, 
    171, 254, 255, 93, 175, 254, 255, 96, 174, 255, 255, 100, 178, 254, 255, 103, 
    181, 255, 255, 110, 186, 255, 255, 114, 189, 255, 255, 112, 186, 255, 255, 106, 
    182, 255, 255, 101, 181, 255, 255, 98, 176, 255, 255, 92, 174, 254, 255, 88, 
    170, 254, 255, 85, 167, 254, 255, 82, 164, 254, 255, 84, 165, 254, 255, 92, 
    171, 254, 255, 93, 175, 254, 255, 96, 174, 255, 255, 100, 178, 254, 255, 103, 
    181, 255, 255, 110, 186, 255, 255, 114, 189, 255, 255, 112, 186, 255, 255, 106, 
    182, 255, 255, 101, 181, 255, 255, 98, 176, 255, 255, 92, 174, 254, 255, 88, 
    170, 254, 255, 85, 167, 254, 255, 82, 164, 254, 255, 84, 165, 254, 255, 92, 
    171, 254, 255, 93, 175, 254, 255, 96, 174, 255, 255, 100, 178, 254, 255, 103, 
    181, 255, 255, 110, 186, 255, 255, 114, 189, 255, 255, 112, 186, 255, 255, 106, 
    182, 255, 255, 101, 181, 255, 255, 98, 176, 255, 255, 92, 174, 254, 255, 88, 
    170, 254, 255, 85, 167, 254, 255, 94, 180, 255, 255, 95, 178, 255, 255, 101, 
    183, 255, 255, 102, 185, 255, 255, 109, 187, 255, 255, 114, 194, 255, 255, 114, 
    193, 255, 255, 121, 197, 255, 255, 122, 197, 255, 255, 123, 198, 255, 255, 115, 
    194, 255, 255, 111, 191, 255, 255, 109, 189, 255, 255, 106, 188, 255, 255, 102, 
    182, 255, 255, 96, 179, 255, 255, 94, 180, 255, 255, 95, 178, 255, 255, 101, 
    183, 255, 255, 102, 185, 255, 255, 109, 187, 255, 255, 114, 194, 255, 255, 114, 
    193, 255, 255, 121, 197, 255, 255, 122, 197, 255, 255, 123, 198, 255, 255, 115, 
    194, 255, 255, 111, 191, 255, 255, 109, 189, 255, 255, 106, 188, 255, 255, 102, 
    182, 255, 255, 96, 179, 255, 255, 94, 180, 255, 255, 95, 178, 255, 255, 101, 
    183, 255, 255, 102, 185, 255, 255, 109, 187, 255, 255, 114, 194, 255, 255, 114, 
    193, 255, 255, 121, 197, 255, 255, 122, 197, 255, 255, 123, 198, 255, 255, 115, 
    194, 255, 255, 111, 191, 255, 255, 109, 189, 255, 255, 106, 188, 255, 255, 102, 
    182, 255, 255, 96, 179, 255, 255, 94, 180, 255, 255, 95, 178, 255, 255, 101, 
    183, 255, 255, 102, 185, 255, 255, 109, 187, 255, 255, 114, 194, 255, 255, 114, 
    193, 255, 255, 121, 197, 255, 255, 122, 197, 255, 255, 123, 198, 255, 255, 115, 
    194, 255, 255, 111, 191, 255, 255, 109, 189, 255, 255, 106, 188, 255, 255, 102, 
    182, 255, 255, 96, 179, 255, 255, 94, 180, 255, 255, 95, 178, 255, 255, 101, 
    183, 255, 255, 102, 185, 255, 255, 109, 187, 255, 255, 114, 194, 255, 255, 114, 
    193, 255, 255, 121, 197, 255, 255, 122, 197, 255, 255, 123, 198, 255, 255, 115, 
    194, 255, 255, 111, 191, 255, 255, 109, 189, 255, 255, 106, 188, 255, 255, 102, 
    182, 255, 255, 96, 179, 255, 255, 94, 180, 255, 255, 95, 178, 255, 255, 101, 
    183, 255, 255, 102, 185, 255, 255, 109, 187, 255, 255, 114, 194, 255, 255, 114, 
    193, 255, 255, 121, 197, 255, 255, 122, 197, 255, 255, 123, 198, 255, 255, 115, 
    194, 255, 255, 111, 191, 255, 255, 109, 189, 255, 255, 106, 188, 255, 255, 102, 
    182, 255, 255, 96, 179, 255, 255, 94, 180, 255, 255, 95, 178, 255, 255, 101, 
    183, 255, 255, 102, 185, 255, 255, 109, 187, 255, 255, 114, 194, 255, 255, 114, 
    193, 255, 255, 121, 197, 255, 255, 122, 197, 255, 255, 123, 198, 255, 255, 115, 
    194, 255, 255, 111, 191, 255, 255, 109, 189, 255, 255, 106, 188, 255, 255, 102, 
    182, 255, 255, 96, 179, 255, 255, 94, 180, 255, 255, 95, 178, 255, 255, 101, 
    183, 255, 255, 102, 185, 255, 255, 109, 187, 255, 255, 114, 194, 255, 255, 114, 
    193, 255, 255, 121, 197, 255, 255, 122, 197, 255, 255, 123, 198, 255, 255, 115, 
    194, 255, 255, 111, 191, 255, 255, 109, 189, 255, 255, 106, 188, 255, 255, 102, 
    182, 255, 255, 96, 179, 255, 255, 103, 191, 255, 255, 106, 189, 255, 255, 110, 
    192, 255, 255, 112, 194, 255, 255, 119, 198, 255, 255, 124, 204, 255, 255, 124, 
    203, 255, 255, 131, 207, 255, 255, 132, 209, 255, 255, 132, 209, 255, 255, 123, 
    203, 255, 255, 119, 200, 255, 255, 119, 198, 255, 255, 113, 195, 255, 255, 110, 
    191, 255, 255, 106, 191, 255, 255, 103, 191, 255, 255, 106, 189, 255, 255, 110, 
    192, 255, 255, 112, 194, 255, 255, 119, 198, 255, 255, 124, 204, 255, 255, 124, 
    203, 255, 255, 131, 207, 255, 255, 132, 209, 255, 255, 132, 209, 255, 255, 123, 
    203, 255, 255, 119, 200, 255, 255, 119, 198, 255, 255, 113, 195, 255, 255, 110, 
    191, 255, 255, 106, 191, 255, 255, 103, 191, 255, 255, 106, 189, 255, 255, 110, 
    192, 255, 255, 112, 194, 255, 255, 119, 198, 255, 255, 124, 204, 255, 255, 124, 
    203, 255, 255, 131, 207, 255, 255, 132, 209, 255, 255, 132, 209, 255, 255, 123, 
    203, 255, 255, 119, 200, 255, 255, 119, 198, 255, 255, 113, 195, 255, 255, 110, 
    191, 255, 255, 106, 191, 255, 255, 103, 191, 255, 255, 106, 189, 255, 255, 110, 
    192, 255, 255, 112, 194, 255, 255, 119, 198, 255, 255, 124, 204, 255, 255, 124, 
    203, 255, 255, 131, 207, 255, 255, 132, 209, 255, 255, 132, 209, 255, 255, 123, 
    203, 255, 255, 119, 200, 255, 255, 119, 198, 255, 255, 113, 195, 255, 255, 110, 
    191, 255, 255, 106, 191, 255, 255, 103, 191, 255, 255, 106, 189, 255, 255, 110, 
    192, 255, 255, 112, 194, 255, 255, 119, 198, 255, 255, 124, 204, 255, 255, 124, 
    203, 255, 255, 131, 207, 255, 255, 132, 209, 255, 255, 132, 209, 255, 255, 123, 
    203, 255, 255, 119, 200, 255, 255, 119, 198, 255, 255, 113, 195, 255, 255, 110, 
    191, 255, 255, 106, 191, 255, 255, 103, 191, 255, 255, 106, 189, 255, 255, 110, 
    192, 255, 255, 112, 194, 255, 255, 119, 198, 255, 255, 124, 204, 255, 255, 124, 
    203, 255, 255, 131, 207, 255, 255, 132, 209, 255, 255, 132, 209, 255, 255, 123, 
    203, 255, 255, 119, 200, 255, 255, 119, 198, 255, 255, 113, 195, 255, 255, 110, 
    191, 255, 255, 106, 191, 255, 255, 103, 191, 255, 255, 106, 189, 255, 255, 110, 
    192, 255, 255, 112, 194, 255, 255, 119, 198, 255, 255, 124, 204, 255, 255, 124, 
    203, 255, 255, 131, 207, 255, 255, 132, 209, 255, 255, 132, 209, 255, 255, 123, 
    203, 255, 255, 119, 200, 255, 255, 119, 198, 255, 255, 113, 195, 255, 255, 110, 
    191, 255, 255, 106, 191, 255, 255, 103, 191, 255, 255, 106, 189, 255, 255, 110, 
    192, 255, 255, 112, 194, 255, 255, 119, 198, 255, 255, 124, 204, 255, 255, 124, 
    203, 255, 255, 131, 207, 255, 255, 132, 209, 255, 255, 132, 209, 255, 255, 123, 
    203, 255, 255, 119, 200, 255, 255, 119, 198, 255, 255, 113, 195, 255, 255, 110, 
    191, 255, 255, 106, 191, 255, 255, 107, 191, 255, 255, 112, 193, 255, 255, 116, 
    195, 255, 255, 117, 197, 255, 255, 122, 200, 255, 255, 128, 204, 255, 255, 130, 
    205, 255, 255, 135, 210, 255, 255, 139, 214, 255, 255, 136, 211, 255, 255, 127, 
    205, 255, 255, 125, 202, 255, 255, 123, 199, 255, 255, 115, 195, 255, 255, 113, 
    194, 255, 255, 111, 193, 255, 255, 107, 191, 255, 255, 112, 193, 255, 255, 116, 
    195, 255, 255, 117, 197, 255, 255, 122, 200, 255, 255, 128, 204, 255, 255, 130, 
    205, 255, 255, 135, 210, 255, 255, 139, 214, 255, 255, 136, 211, 255, 255, 127, 
    205, 255, 255, 125, 202, 255, 255, 123, 199, 255, 255, 115, 195, 255, 255, 113, 
    194, 255, 255, 111, 193, 255, 255, 107, 191, 255, 255, 112, 193, 255, 255, 116, 
    195, 255, 255, 117, 197, 255, 255, 122, 200, 255, 255, 128, 204, 255, 255, 130, 
    205, 255, 255, 135, 210, 255, 255, 139, 214, 255, 255, 136, 211, 255, 255, 127, 
    205, 255, 255, 125, 202, 255, 255, 123, 199, 255, 255, 115, 195, 255, 255, 113, 
    194, 255, 255, 111, 193, 255, 255, 107, 191, 255, 255, 112, 193, 255, 255, 116, 
    195, 255, 255, 117, 197, 255, 255, 122, 200, 255, 255, 128, 204, 255, 255, 130, 
    205, 255, 255, 135, 210, 255, 255, 139, 214, 255, 255, 136, 211, 255, 255, 127, 
    205, 255, 255, 125, 202, 255, 255, 123, 199, 255, 255, 115, 195, 255, 255, 113, 
    194, 255, 255, 111, 193, 255, 255, 107, 191, 255, 255, 112, 193, 255, 255, 116, 
    195, 255, 255, 117, 197, 255, 255, 122, 200, 255, 255, 128, 204, 255, 255, 130, 
    205, 255, 255, 135, 210, 255, 255, 139, 214, 255, 255, 136, 211, 255, 255, 127, 
    205, 255, 255, 125, 202, 255, 255, 123, 199, 255, 255, 115, 195, 255, 255, 113, 
    194, 255, 255, 111, 193, 255, 255, 107, 191, 255, 255, 112, 193, 255, 255, 116, 
    195, 255, 255, 117, 197, 255, 255, 122, 200, 255, 255, 128, 204, 255, 255, 130, 
    205, 255, 255, 135, 210, 255, 255, 139, 214, 255, 255, 136, 211, 255, 255, 127, 
    205, 255, 255, 125, 202, 255, 255, 123, 199, 255, 255, 115, 195, 255, 255, 113, 
    194, 255, 255, 111, 193, 255, 255, 107, 191, 255, 255, 112, 193, 255, 255, 116, 
    195, 255, 255, 117, 197, 255, 255, 122, 200, 255, 255, 128, 204, 255, 255, 130, 
    205, 255, 255, 135, 210, 255, 255, 139, 214, 255, 255, 136, 211, 255, 255, 127, 
    205, 255, 255, 125, 202, 255, 255, 123, 199, 255, 255, 115, 195, 255, 255, 113, 
    194, 255, 255, 111, 193, 255, 255, 107, 191, 255, 255, 112, 193, 255, 255, 116, 
    195, 255, 255, 117, 197, 255, 255, 122, 200, 255, 255, 128, 204, 255, 255, 130, 
    205, 255, 255, 135, 210, 255, 255, 139, 214, 255, 255, 136, 211, 255, 255, 127, 
    205, 255, 255, 125, 202, 255, 255, 123, 199, 255, 255, 115, 195, 255, 255, 113, 
    194, 255, 255, 111, 193, 255, 255, 106, 182, 255, 255, 111, 186, 255, 255, 114, 
    188, 255, 255, 113, 189, 255, 255, 119, 192, 255, 255, 124, 195, 255, 255, 129, 
    200, 255, 255, 129, 199, 255, 255, 135, 200, 255, 255, 131, 199, 255, 255, 126, 
    198, 255, 255, 124, 194, 255, 255, 119, 192, 255, 255, 115, 189, 255, 255, 112, 
    186, 255, 255, 107, 181, 255, 255, 106, 182, 255, 255, 111, 186, 255, 255, 114, 
    188, 255, 255, 113, 189, 255, 255, 119, 192, 255, 255, 124, 195, 255, 255, 129, 
    200, 255, 255, 129, 199, 255, 255, 135, 200, 255, 255, 131, 199, 255, 255, 126, 
    198, 255, 255, 124, 194, 255, 255, 119, 192, 255, 255, 115, 189, 255, 255, 112, 
    186, 255, 255, 107, 181, 255, 255, 106, 182, 255, 255, 111, 186, 255, 255, 114, 
    188, 255, 255, 113, 189, 255, 255, 119, 192, 255, 255, 124, 195, 255, 255, 129, 
    200, 255, 255, 129, 199, 255, 255, 135, 200, 255, 255, 131, 199, 255, 255, 126, 
    198, 255, 255, 124, 194, 255, 255, 119, 192, 255, 255, 115, 189, 255, 255, 112, 
    186, 255, 255, 107, 181, 255, 255, 106, 182, 255, 255, 111, 186, 255, 255, 114, 
    188, 255, 255, 113, 189, 255, 255, 119, 192, 255, 255, 124, 195, 255, 255, 129, 
    200, 255, 255, 129, 199, 255, 255, 135, 200, 255, 255, 131, 199, 255, 255, 126, 
    198, 255, 255, 124, 194, 255, 255, 119, 192, 255, 255, 115, 189, 255, 255, 112, 
    186, 255, 255, 107, 181, 255, 255, 106, 182, 255, 255, 111, 186, 255, 255, 114, 
    188, 255, 255, 113, 189, 255, 255, 119, 192, 255, 255, 124, 195, 255, 255, 129, 
    200, 255, 255, 129, 199, 255, 255, 135, 200, 255, 255, 131, 199, 255, 255, 126, 
    198, 255, 255, 124, 194, 255, 255, 119, 192, 255, 255, 115, 189, 255, 255, 112, 
    186, 255, 255, 107, 181, 255, 255, 106, 182, 255, 255, 111, 186, 255, 255, 114, 
    188, 255, 255, 113, 189, 255, 255, 119, 192, 255, 255, 124, 195, 255, 255, 129, 
    200, 255, 255, 129, 199, 255, 255, 135, 200, 255, 255, 131, 199, 255, 255, 126, 
    198, 255, 255, 124, 194, 255, 255, 119, 192, 255, 255, 115, 189, 255, 255, 112, 
    186, 255, 255, 107, 181, 255, 255, 106, 182, 255, 255, 111, 186, 255, 255, 114, 
    188, 255, 255, 113, 189, 255, 255, 119, 192, 255, 255, 124, 195, 255, 255, 129, 
    200, 255, 255, 129, 199, 255, 255, 135, 200, 255, 255, 131, 199, 255, 255, 126, 
    198, 255, 255, 124, 194, 255, 255, 119, 192, 255, 255, 115, 189, 255, 255, 112, 
    186, 255, 255, 107, 181, 255, 255, 106, 182, 255, 255, 111, 186, 255, 255, 114, 
    188, 255, 255, 113, 189, 255, 255, 119, 192, 255, 255, 124, 195, 255, 255, 129, 
    200, 255, 255, 129, 199, 255, 255, 135, 200, 255, 255, 131, 199, 255, 255, 126, 
    198, 255, 255, 124, 194, 255, 255, 119, 192, 255, 255, 115, 189, 255, 255, 112, 
    186, 255, 255, 107, 181, 255, 255
};
