/*
 *  Copyright (c) 2004 Apple Computer, Inc. All Rights Reserved.
 * 
 *  @APPLE_LICENSE_HEADER_START@
 *  
 *  This file contains Original Code and/or Modifications of Original Code
 *  as defined in and that are subject to the Apple Public Source License
 *  Version 2.0 (the 'License'). You may not use this file except in
 *  compliance with the License. Please obtain a copy of the License at
 *  http://www.opensource.apple.com/apsl/ and read it before using this
 *  file.
 *  
 *  The Original Code and all software distributed under the License are
 *  distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 *  EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 *  INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 *  Please see the License for the specific language governing rights and
 *  limitations under the License.
 *  
 *  @APPLE_LICENSE_HEADER_END@
 */

/*
 *  KeyRecord.h
 *  TokendMuscle
 */

#ifndef _KEYRECORD_H_
#define _KEYRECORD_H_

#include "Msc/MscKey.h"
#include "Record.h"

#include <string>

class MscObject;

class KeyRecord : public Tokend::Record
{
	NOCOPY(KeyRecord)
public:
    KeyRecord(MscKey& key) : mKey(key) {}
    //KeyRecord(const MSCKeyInfo& keyInfo,MscTokenConnection *connection) : MscKey(keyInfo,connection) {}
	virtual ~KeyRecord();

	MscKey &key() { return mKey; }
private:
	MscKey &mKey;
};

#endif /* !_KEYRECORD_H_ */


/* arch-tag: BB95F5A0-F573-11D8-951B-000A95C4302E */
