/* 
 * Copyright (c) 1995 NeXT Computer, Inc. All Rights Reserved
 *
 * Copyright (c) 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * The NEXTSTEP Software License Agreement specifies the terms
 * and conditions for redistribution.
 *
 *	@(#)util.c	8.3 (Berkeley) 4/2/94
 */


#include <sys/types.h>
#include <sys/stat.h>

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "stty.h"
#include "extern.h"

/*
 * Gross, but since we're changing the control descriptor from 1 to 0, most
 * users will be probably be doing "stty > /dev/sometty" by accident.  If 1
 * and 2 are both ttys, but not the same, assume that 1 was incorrectly
 * redirected.
 */
void
checkredirect()
{
	struct stat sb1, sb2;

	if (isatty(STDOUT_FILENO) && isatty(STDERR_FILENO) &&
	    !fstat(STDOUT_FILENO, &sb1) && !fstat(STDERR_FILENO, &sb2) &&
	    (sb1.st_rdev != sb2.st_rdev))
warn("stdout appears redirected, but stdin is the control descriptor");
}
