/*
 * Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 *  appleboot.h - Apple logo shown durring boot
 *
 *  Copyright (c) 2002 Apple Computer, Inc.
 *
 *  DRI: Josh de Cesare
 */

#define kAppleBootWidth		(128)
#define kAppleBootHeight	(128)
#define kAppleBootOffset	(0)
#define kAppleBootFrames	(1)
#define kAppleBootFPS		(0)
#define kAppleBootRLEBlocks (686)

// The original data was 16K in size (128x128) and would make the booter
// cross a 64K segment boundary. boot0 cannot load more than 127 sectors
// without changes. To eiminate that complexity, the data was run length
// encoded to save space. The reduced size is 1372 bytes.

const unsigned char gAppleBootPictRLE[] =
{
    0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0x50, 0x01, 0x01, 0x02, 0x01, 0x17,
    0x01, 0x34, 0x01, 0x47, 0x03, 0x50, 0x01, 0x13, 0x76, 0x01, 0x01, 0x03,
    0x01, 0x20, 0x01, 0x40, 0x06, 0x50, 0x01, 0x13, 0x75, 0x01, 0x01, 0x1a,
    0x01, 0x42, 0x07, 0x50, 0x01, 0xfa, 0x01, 0x0a, 0x73, 0x01, 0x01, 0x07,
    0x01, 0x34, 0x09, 0x50, 0x01, 0x43, 0x01, 0x02, 0x72, 0x01, 0x01, 0x0e,
    0x01, 0x43, 0x0a, 0x50, 0x01, 0x36, 0x72, 0x01, 0x01, 0x14, 0x01, 0x4a,
    0x0b, 0x50, 0x01, 0x20, 0x71, 0x01, 0x01, 0x12, 0x01, 0x4b, 0x0b, 0x50,
    0x01, 0x4d, 0x01, 0x0b, 0x70, 0x01, 0x01, 0x0b, 0x01, 0x48, 0x0c, 0x50,
    0x01, 0xf9, 0x70, 0x01, 0x01, 0x03, 0x01, 0x3e, 0x0d, 0x50, 0x01, 0x1f,
    0x70, 0x01, 0x01, 0x2f, 0x0d, 0x50, 0x01, 0x48, 0x01, 0x06, 0x6f, 0x01,
    0x01, 0x15, 0x01, 0x4f, 0x0d, 0x50, 0x01, 0x27, 0x6f, 0x01, 0x01, 0x02,
    0x01, 0x3f, 0x0d, 0x50, 0x01, 0x45, 0x01, 0xf7, 0x6f, 0x01, 0x01, 0x1d,
    0x0e, 0x50, 0x01, 0x19, 0x6f, 0x01, 0x01, 0x02, 0x01, 0x40, 0x0d, 0x50,
    0x01, 0x2f, 0x70, 0x01, 0x01, 0x15, 0x0d, 0x50, 0x01, 0x3b, 0x01, 0x03,
    0x70, 0x01, 0x01, 0x34, 0x0c, 0x50, 0x01, 0x3f, 0x01, 0x07, 0x70, 0x01,
    0x01, 0xf7, 0x01, 0x47, 0x0b, 0x50, 0x01, 0xf9, 0x01, 0x07, 0x71, 0x01,
    0x01, 0x14, 0x0b, 0x50, 0x01, 0x36, 0x01, 0xf7, 0x72, 0x01, 0x01, 0x24,
    0x09, 0x50, 0x01, 0x4d, 0x01, 0x28, 0x74, 0x01, 0x01, 0x33, 0x08, 0x50,
    0x01, 0x3f, 0x01, 0x14, 0x75, 0x01, 0x01, 0x3a, 0x06, 0x50, 0x01, 0x41,
    0x01, 0x1f, 0x01, 0x02, 0x76, 0x01, 0x01, 0x3a, 0x03, 0x50, 0x01, 0x48,
    0x01, 0x35, 0x01, 0x17, 0x01, 0x02, 0x78, 0x01, 0x01, 0x15, 0x01, 0x33,
    0x01, 0x27, 0x01, 0x15, 0x01, 0xf7, 0x67, 0x01, 0x01, 0x02, 0x01, 0x08,
    0x01, 0x0e, 0x01, 0x13, 0x01, 0x14, 0x01, 0x12, 0x01, 0x0d, 0x01, 0x06,
    0x01, 0x02, 0x1c, 0x01, 0x01, 0x04, 0x01, 0x0b, 0x01, 0x12, 0x01, 0x17,
    0x01, 0x19, 0x01, 0x15, 0x01, 0x11, 0x01, 0x08, 0x01, 0x02, 0x4e, 0x01,
    0x01, 0x02, 0x01, 0x11, 0x01, 0x26, 0x01, 0x39, 0x01, 0x44, 0x01, 0x4c,
    0x01, 0x4f, 0x02, 0x50, 0x01, 0x4f, 0x01, 0x4d, 0x01, 0x4a, 0x01, 0x3f,
    0x01, 0x31, 0x01, 0x19, 0x01, 0xf7, 0x15, 0x01, 0x01, 0x0b, 0x01, 0x1c,
    0x01, 0x2e, 0x01, 0xf9, 0x01, 0x46, 0x01, 0x4d, 0x04, 0x50, 0x01, 0x4f,
    0x01, 0x4b, 0x01, 0x42, 0x01, 0x34, 0x01, 0x1f, 0x01, 0x0a, 0x49, 0x01,
    0x01, 0xf7, 0x01, 0x21, 0x01, 0x3f, 0x01, 0x4f, 0x0d, 0x50, 0x01, 0x47,
    0x01, 0x2d, 0x01, 0x0d, 0x10, 0x01, 0x01, 0x0d, 0x01, 0x25, 0x01, 0x3d,
    0x01, 0xfa, 0x0e, 0x50, 0x01, 0x4c, 0x01, 0x37, 0x01, 0x15, 0x45, 0x01,
    0x01, 0x04, 0x01, 0x25, 0x01, 0x45, 0x12, 0x50, 0x01, 0x4d, 0x01, 0x39,
    0x01, 0x19, 0x01, 0x02, 0x0a, 0x01, 0x01, 0x09, 0x01, 0x21, 0x01, 0xf9,
    0x01, 0x4d, 0x14, 0x50, 0x01, 0xf9, 0x01, 0x15, 0x42, 0x01, 0x01, 0x17,
    0x01, 0x42, 0x17, 0x50, 0x01, 0x42, 0x01, 0x27, 0x01, 0x0e, 0x01, 0x02,
    0x03, 0x01, 0x01, 0x02, 0x01, 0x0b, 0x01, 0x1f, 0x01, 0x38, 0x01, 0x4b,
    0x19, 0x50, 0x01, 0x33, 0x01, 0x06, 0x3e, 0x01, 0x01, 0x03, 0x01, 0x2e,
    0x1b, 0x50, 0x01, 0x4d, 0x01, 0x43, 0x01, 0x3a, 0x01, 0x37, 0x01, 0x3a,
    0x01, 0x42, 0x01, 0x4d, 0x1d, 0x50, 0x01, 0x42, 0x01, 0x0e, 0x3c, 0x01,
    0x01, 0x0a, 0x01, 0xf9, 0x41, 0x50, 0x01, 0x48, 0x01, 0x13, 0x3a, 0x01,
    0x01, 0x0d, 0x01, 0x45, 0x43, 0x50, 0x01, 0x4b, 0x01, 0x12, 0x38, 0x01,
    0x01, 0x10, 0x01, 0x48, 0x45, 0x50, 0x01, 0x48, 0x01, 0x0b, 0x36, 0x01,
    0x01, 0x0c, 0x01, 0x48, 0x47, 0x50, 0x01, 0x3d, 0x01, 0x03, 0x34, 0x01,
    0x01, 0x07, 0x01, 0x42, 0x49, 0x50, 0x01, 0x21, 0x34, 0x01, 0x01, 0x37,
    0x49, 0x50, 0x01, 0x42, 0x01, 0x12, 0x33, 0x01, 0x01, 0x22, 0x49, 0x50,
    0x01, 0x34, 0x01, 0xf7, 0x33, 0x01, 0x01, 0x0b, 0x01, 0x4b, 0x48, 0x50,
    0x01, 0x2c, 0x35, 0x01, 0x01, 0x36, 0x48, 0x50, 0x01, 0x29, 0x35, 0x01,
    0x01, 0x11, 0x01, 0x4f, 0x47, 0x50, 0x01, 0x2e, 0x36, 0x01, 0x01, 0x36,
    0x47, 0x50, 0x01, 0x3a, 0x01, 0x02, 0x35, 0x01, 0x01, 0x0b, 0x01, 0xfa,
    0x46, 0x50, 0x01, 0x46, 0x01, 0x08, 0x36, 0x01, 0x01, 0x26, 0x46, 0x50,
    0x01, 0x4e, 0x01, 0x15, 0x36, 0x01, 0x01, 0x02, 0x01, 0x40, 0x46, 0x50,
    0x01, 0x31, 0x37, 0x01, 0x01, 0x0e, 0x01, 0x4e, 0x45, 0x50, 0x01, 0x49,
    0x01, 0x08, 0x37, 0x01, 0x01, 0x25, 0x46, 0x50, 0x01, 0x29, 0x38, 0x01,
    0x01, 0x39, 0x45, 0x50, 0x01, 0x4c, 0x01, 0x0a, 0x37, 0x01, 0x01, 0xf7,
    0x01, 0x47, 0x45, 0x50, 0x01, 0x3a, 0x38, 0x01, 0x01, 0x10, 0x01, 0x4f,
    0x45, 0x50, 0x01, 0x22, 0x38, 0x01, 0x01, 0x1d, 0x46, 0x50, 0x01, 0x12,
    0x38, 0x01, 0x01, 0x29, 0x45, 0x50, 0x01, 0x4b, 0x01, 0x07, 0x38, 0x01,
    0x01, 0x36, 0x45, 0x50, 0x01, 0x42, 0x01, 0x02, 0x38, 0x01, 0x01, 0xf9,
    0x45, 0x50, 0x01, 0x3e, 0x39, 0x01, 0x01, 0x42, 0x45, 0x50, 0x01, 0x3c,
    0x39, 0x01, 0x01, 0x46, 0x45, 0x50, 0x01, 0x3b, 0x39, 0x01, 0x01, 0x48,
    0x45, 0x50, 0x01, 0xf9, 0x39, 0x01, 0x01, 0x48, 0x45, 0x50, 0x01, 0x3f,
    0x01, 0x02, 0x38, 0x01, 0x01, 0x46, 0x45, 0x50, 0x01, 0x48, 0x01, 0xf7,
    0x38, 0x01, 0x01, 0x43, 0x45, 0x50, 0x01, 0x4e, 0x01, 0x0e, 0x38, 0x01,
    0x01, 0x3f, 0x46, 0x50, 0x01, 0x1c, 0x38, 0x01, 0x01, 0x3a, 0x46, 0x50,
    0x01, 0x33, 0x38, 0x01, 0x01, 0x34, 0x46, 0x50, 0x01, 0x46, 0x01, 0x04,
    0x37, 0x01, 0x01, 0x2c, 0x47, 0x50, 0x01, 0x19, 0x37, 0x01, 0x01, 0x1f,
    0x47, 0x50, 0x01, 0x3a, 0x37, 0x01, 0x01, 0x15, 0x47, 0x50, 0x01, 0x4e,
    0x01, 0x11, 0x36, 0x01, 0x01, 0x0a, 0x01, 0xfa, 0x47, 0x50, 0x01, 0x37,
    0x36, 0x01, 0x01, 0x02, 0x01, 0x42, 0x47, 0x50, 0x01, 0x4f, 0x01, 0x15,
    0x36, 0x01, 0x01, 0x37, 0x48, 0x50, 0x01, 0x42, 0x01, 0x04, 0x35, 0x01,
    0x01, 0x25, 0x49, 0x50, 0x01, 0x2c, 0x35, 0x01, 0x01, 0x13, 0x49, 0x50,
    0x01, 0x4e, 0x01, 0x15, 0x34, 0x01, 0x01, 0xf7, 0x01, 0x47, 0x49, 0x50,
    0x01, 0x48, 0x01, 0x0b, 0x34, 0x01, 0x01, 0x37, 0x4a, 0x50, 0x01, 0x44,
    0x01, 0x0a, 0x33, 0x01, 0x01, 0x1f, 0x4b, 0x50, 0x01, 0x44, 0x01, 0x0d,
    0x32, 0x01, 0x01, 0x0a, 0x01, 0xfa, 0x4b, 0x50, 0x01, 0x48, 0x01, 0x17,
    0x32, 0x01, 0x01, 0x3a, 0x4c, 0x50, 0x01, 0x4f, 0x01, 0x2c, 0x01, 0x04,
    0x30, 0x01, 0x01, 0x1f, 0x4e, 0x50, 0x01, 0x41, 0x01, 0x19, 0x2f, 0x01,
    0x01, 0x07, 0x01, 0x4a, 0x4e, 0x50, 0x01, 0x44, 0x30, 0x01, 0x01, 0x33,
    0x4e, 0x50, 0x01, 0x36, 0x30, 0x01, 0x01, 0x14, 0x4e, 0x50, 0x01, 0x1f,
    0x30, 0x01, 0x01, 0x02, 0x01, 0x3f, 0x4c, 0x50, 0x01, 0x4d, 0x01, 0x0b,
    0x31, 0x01, 0x01, 0x1e, 0x4c, 0x50, 0x01, 0x3c, 0x32, 0x01, 0x01, 0x04,
    0x01, 0x44, 0x4b, 0x50, 0x01, 0x20, 0x33, 0x01, 0x01, 0x20, 0x4a, 0x50,
    0x01, 0x4a, 0x01, 0x07, 0x33, 0x01, 0x01, 0x04, 0x01, 0x43, 0x49, 0x50,
    0x01, 0x30, 0x35, 0x01, 0x01, 0x1c, 0x48, 0x50, 0x01, 0x4d, 0x01, 0x0e,
    0x35, 0x01, 0x01, 0x02, 0x01, 0x3e, 0x47, 0x50, 0x01, 0x36, 0x37, 0x01,
    0x01, 0x14, 0x01, 0x4f, 0x45, 0x50, 0x01, 0x4d, 0x01, 0x0e, 0x38, 0x01,
    0x01, 0x32, 0x45, 0x50, 0x01, 0x33, 0x39, 0x01, 0x01, 0x07, 0x01, 0x47,
    0x43, 0x50, 0x01, 0x4b, 0x01, 0x0b, 0x3a, 0x01, 0x01, 0x1c, 0x43, 0x50,
    0x01, 0x26, 0x3c, 0x01, 0x01, 0x37, 0x41, 0x50, 0x01, 0x41, 0x01, 0x04,
    0x3c, 0x01, 0x01, 0x08, 0x01, 0x48, 0x3f, 0x50, 0x01, 0x4e, 0x01, 0x13,
    0x3e, 0x01, 0x01, 0x19, 0x3f, 0x50, 0x01, 0x2d, 0x40, 0x01, 0x01, 0x2e,
    0x3d, 0x50, 0x01, 0x3f, 0x01, 0x03, 0x40, 0x01, 0x01, 0x03, 0x01, 0xf9,
    0x3b, 0x50, 0x01, 0x4a, 0x01, 0x0d, 0x42, 0x01, 0x01, 0x09, 0x01, 0x46,
    0x39, 0x50, 0x01, 0x4e, 0x01, 0x19, 0x44, 0x01, 0x01, 0x11, 0x01, 0x4b,
    0x38, 0x50, 0x01, 0x25, 0x46, 0x01, 0x01, 0x17, 0x01, 0x4d, 0x36, 0x50,
    0x01, 0x2e, 0x48, 0x01, 0x01, 0x1b, 0x01, 0x4d, 0x34, 0x50, 0x01, 0x31,
    0x4a, 0x01, 0x01, 0x17, 0x01, 0x4a, 0x14, 0x50, 0x01, 0x4d, 0x01, 0x44,
    0x01, 0x3b, 0x01, 0x34, 0x01, 0x2e, 0x01, 0x2c, 0x01, 0x2e, 0x01, 0x35,
    0x01, 0x3e, 0x01, 0x4a, 0x14, 0x50, 0x01, 0x2e, 0x4c, 0x01, 0x01, 0x0e,
    0x01, 0x41, 0x10, 0x50, 0x01, 0x4a, 0x01, 0x37, 0x01, 0x1f, 0x01, 0x0c,
    0x01, 0x03, 0x07, 0x01, 0x01, 0x06, 0x01, 0x15, 0x01, 0x2d, 0x01, 0x41,
    0x0f, 0x50, 0x01, 0x4a, 0x01, 0x1f, 0x4e, 0x01, 0x01, 0xf7, 0x01, 0x2e,
    0x01, 0xfa, 0x0b, 0x50, 0x01, 0x4f, 0x01, 0xf9, 0x01, 0x1e, 0x01, 0x07,
    0x0e, 0x01, 0x01, 0x02, 0x01, 0x14, 0x01, 0x31, 0x01, 0x48, 0x0b, 0x50,
    0x01, 0x37, 0x01, 0x0c, 0x51, 0x01, 0x01, 0x0d, 0x01, 0x2f, 0x01, 0x45,
    0x01, 0x4f, 0x05, 0x50, 0x01, 0x4f, 0x01, 0x43, 0x01, 0x2e, 0x01, 0x11,
    0x14, 0x01, 0x01, 0x07, 0x01, 0x1f, 0x01, 0x3c, 0x01, 0x4c, 0x04, 0x50,
    0x01, 0x4f, 0x01, 0x46, 0x01, 0x33, 0x01, 0x13, 0x55, 0x01, 0x01, 0x04,
    0x01, 0x12, 0x01, 0x1f, 0x01, 0x26, 0x01, 0x28, 0x01, 0x26, 0x01, 0x1e,
    0x01, 0x10, 0x01, 0x02, 0x19, 0x01, 0x01, 0x09, 0x01, 0x16, 0x01, 0x1e,
    0x01, 0x1f, 0x01, 0x1c, 0x01, 0x11, 0x01, 0x04, 0xff, 0x01, 0xff, 0x01,
    0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xff, 0x01,
    0xff, 0x01, 0xb3, 0x01
};
