/*
 * Copyright (c) 2000-2004 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

/*
 * This file is automatically generated
 * DO NOT EDIT!
 */

/*
 * Reserved Keys
 *
 *   kSCResvLink                                        "__LINK__"                     CFString
 *   kSCResvInactive                                    "__INACTIVE__"
 *   
 * Generic Keys
 *
 *   kSCPropInterfaceName                               "InterfaceName"                CFString
 *   kSCPropMACAddress                                  "MACAddress"                   CFString
 *   kSCPropUserDefinedName                             "UserDefinedName"              CFString
 *   kSCPropVersion                                     "Version"                      CFString
 *   
 * Preference Keys
 *
 *   kSCPrefCurrentSet                                  "CurrentSet"                   CFString
 *   kSCPrefNetworkServices                             "NetworkServices"              CFDictionary
 *   kSCPrefSets                                        "Sets"                         CFDictionary
 *   kSCPrefSystem                                      "System"                       CFDictionary
 *   
 * Component Keys
 *
 *   kSCCompNetwork                                     "Network"
 *   kSCCompService                                     "Service"
 *   kSCCompGlobal                                      "Global"
 *   kSCCompHostNames                                   "HostNames"
 *   kSCCompInterface                                   "Interface"
 *   kSCCompSystem                                      "System"
 *   kSCCompUsers                                       "Users"
 *   
 *   --- Regex pattern which matches any component ---
 *   kSCCompAnyRegex                                    "[^/]+"
 *   
 * Network Entity Keys
 *
 *   kSCEntNetAirPort                                   "AirPort"                      CFDictionary
 *   kSCEntNetAppleTalk                                 "AppleTalk"                    CFDictionary
 *   kSCEntNetDHCP                                      "DHCP"                         CFDictionary
 *   kSCEntNetDNS                                       "DNS"                          CFDictionary
 *   kSCEntNetEthernet                                  "Ethernet"                     CFDictionary
 *   kSCEntNetFireWire                                  "FireWire"                     CFDictionary
 *   kSCEntNetInterface                                 "Interface"                    CFDictionary
 *   kSCEntNetIPv4                                      "IPv4"                         CFDictionary
 *   kSCEntNetIPv6                                      "IPv6"                         CFDictionary
 *   kSCEntNetL2TP                                      "L2TP"                         CFDictionary
 *   kSCEntNetLink                                      "Link"                         CFDictionary
 *   kSCEntNetModem                                     "Modem"                        CFDictionary
 *   kSCEntNetNetInfo                                   "NetInfo"                      CFDictionary
 *   kSCEntNetPPP                                       "PPP"                          CFDictionary
 *   kSCEntNetPPPoE                                     "PPPoE"                        CFDictionary
 *   kSCEntNetPPPSerial                                 "PPPSerial"                    CFDictionary
 *   kSCEntNetPPTP                                      "PPTP"                         CFDictionary
 *   kSCEntNetProxies                                   "Proxies"                      CFDictionary
 *   kSCEntNet6to4                                      "6to4"                         CFDictionary
 *   
 * kSCCompNetwork Properties
 *
 *   kSCPropNetOverridePrimary                          "OverridePrimary"              CFNumber (0 or 1)
 *   kSCPropNetServiceOrder                             "ServiceOrder"                 CFArray[CFString]
 *   kSCPropNetPPPOverridePrimary                       "PPPOverridePrimary"           CFNumber (0 or 1)
 *   
 * kSCCompNetworkInterface Properties
 *
 *   kSCPropNetInterfaces                               "Interfaces"                   CFArray[CFString]
 *   
 * kSCCompNetworkHostNames Properties
 *
 *   kSCPropNetLocalHostName                            "LocalHostName"                CFString
 *   
 * kSCEntNetAirPort (Hardware) Entity Keys
 *
 *   kSCPropNetAirPortAllowNetCreation                  "AllowNetCreation"             CFNumber (0 or 1)
 *   kSCPropNetAirPortAuthPassword                      "AuthPassword"                 CFData
 *   kSCPropNetAirPortAuthPasswordEncryption            "AuthPasswordEncryption"       CFString
 *   kSCPropNetAirPortJoinMode                          "JoinMode"                     CFString
 *   kSCPropNetAirPortPowerEnabled                      "PowerEnabled"                 CFNumber (0 or 1)
 *   kSCPropNetAirPortPreferredNetwork                  "PreferredNetwork"             CFString
 *   kSCPropNetAirPortSavePasswords                     "SavePasswords"                CFNumber (0 or 1)
 *   
 *   --- kSCPropNetAirPortJoinMode values ---
 *   kSCValNetAirPortJoinModeAutomatic                  "Automatic"
 *   kSCValNetAirPortJoinModePreferred                  "Preferred"
 *   kSCValNetAirPortJoinModeRecent                     "Recent"
 *   kSCValNetAirPortJoinModeStrongest                  "Strongest"
 *   
 *   --- kSCPropNetAirPortPasswordEncryption values ---
 *   kSCValNetAirPortAuthPasswordEncryptionKeychain     "Keychain"
 *   
 * kSCEntNetAppleTalk Entity Keys
 *
 *   kSCPropNetAppleTalkComputerName                    "ComputerName"                 CFString
 *   kSCPropNetAppleTalkComputerNameEncoding            "ComputerNameEncoding"         CFNumber
 *   kSCPropNetAppleTalkConfigMethod                    "ConfigMethod"                 CFString
 *   kSCPropNetAppleTalkDefaultZone                     "DefaultZone"                  CFString
 *   kSCPropNetAppleTalkNetworkID                       "NetworkID"                    CFNumber
 *   kSCPropNetAppleTalkNetworkRange                    "NetworkRange"                 CFArray[CFNumber]
 *   kSCPropNetAppleTalkNodeID                          "NodeID"                       CFNumber
 *   kSCPropNetAppleTalkSeedNetworkRange                "SeedNetworkRange"             CFArray[CFNumber]
 *   kSCPropNetAppleTalkSeedZones                       "SeedZones"                    CFArray[CFString]
 *   
 *   --- kSCPropNetAppleTalkConfigMethod values ---
 *   kSCValNetAppleTalkConfigMethodNode                 "Node"
 *   kSCValNetAppleTalkConfigMethodRouter               "Router"
 *   kSCValNetAppleTalkConfigMethodSeedRouter           "SeedRouter"
 *   
 * kSCEntNetDNS Entity Keys
 *
 *   kSCPropNetDNSDomainName                            "DomainName"                   CFString
 *   kSCPropNetDNSOptions                               "Options"                      CFString
 *   kSCPropNetDNSSearchDomains                         "SearchDomains"                CFArray[CFString]
 *   kSCPropNetDNSSearchOrder                           "SearchOrder"                  CFNumber
 *   kSCPropNetDNSServerAddresses                       "ServerAddresses"              CFArray[CFString]
 *   kSCPropNetDNSServerPort                            "ServerPort"                   CFNumber
 *   kSCPropNetDNSServerTimeout                         "ServerTimeout"                CFNumber
 *   kSCPropNetDNSSortList                              "SortList"                     CFArray[CFString]
 *   kSCPropNetDNSSupplementalMatchDomains              "SupplementalMatchDomains"     CFArray[CFString]
 *   kSCPropNetDNSSupplementalMatchOrders               "SupplementalMatchOrders"      CFArray[CFNumber]
 *   
 * kSCEntNetEthernet (Hardware) Entity Keys
 *
 *   kSCPropNetEthernetMediaSubType                     "MediaSubType"                 CFString
 *   kSCPropNetEthernetMediaOptions                     "MediaOptions"                 CFArray[CFString]
 *   kSCPropNetEthernetMTU                              "MTU"                          CFNumber
 *   
 * kSCEntNetFireWire (Hardware) Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *   
 * kSCEntNetInterface Entity Keys
 *
 *   kSCPropNetInterfaceDeviceName                      "DeviceName"                   CFString
 *   kSCPropNetInterfaceHardware                        "Hardware"                     CFString
 *   kSCPropNetInterfaceType                            "Type"                         CFString
 *   kSCPropNetInterfaceSubType                         "SubType"                      CFString
 *   kSCPropNetInterfaceSupportsModemOnHold             "SupportsModemOnHold"          CFNumber (0 or 1)
 *   
 *   --- kSCPropNetInterfaceType values ---
 *   kSCValNetInterfaceTypeEthernet                     "Ethernet"
 *   kSCValNetInterfaceTypeFireWire                     "FireWire"
 *   kSCValNetInterfaceTypePPP                          "PPP"
 *   kSCValNetInterfaceType6to4                         "6to4"
 *   
 *   --- kSCPropNetServiceSubType values (for PPP) ---
 *   kSCValNetInterfaceSubTypePPPoE                     "PPPoE"
 *   kSCValNetInterfaceSubTypePPPSerial                 "PPPSerial"
 *   kSCValNetInterfaceSubTypePPTP                      "PPTP"
 *   kSCValNetInterfaceSubTypeL2TP                      "L2TP"
 *   
 * kSCEntNetIPv4 Entity Keys
 *
 *   kSCPropNetIPv4Addresses                            "Addresses"                    CFArray[CFString]
 *   kSCPropNetIPv4ConfigMethod                         "ConfigMethod"                 CFString
 *   kSCPropNetIPv4DHCPClientID                         "DHCPClientID"                 CFString
 *   kSCPropNetIPv4Router                               "Router"                       CFString
 *   kSCPropNetIPv4SubnetMasks                          "SubnetMasks"                  CFArray[CFString]
 *   kSCPropNetIPv4DestAddresses                        "DestAddresses"                CFArray[CFString]
 *   kSCPropNetIPv4BroadcastAddresses                   "BroadcastAddresses"           CFArray[CFString]
 *   
 *   --- kSCPropNetIPv4ConfigMethod values ---
 *   kSCValNetIPv4ConfigMethodBOOTP                     "BOOTP"
 *   kSCValNetIPv4ConfigMethodDHCP                      "DHCP"
 *   kSCValNetIPv4ConfigMethodINFORM                    "INFORM"
 *   kSCValNetIPv4ConfigMethodLinkLocal                 "LinkLocal"
 *   kSCValNetIPv4ConfigMethodManual                    "Manual"
 *   kSCValNetIPv4ConfigMethodPPP                       "PPP"
 *   
 * kSCEntNetIPv6 Entity Keys
 *
 *   kSCPropNetIPv6Addresses                            "Addresses"                    CFArray[CFString]
 *   kSCPropNetIPv6ConfigMethod                         "ConfigMethod"                 CFString
 *   kSCPropNetIPv6DestAddresses                        "DestAddresses"                CFArray[CFString]
 *   kSCPropNetIPv6Flags                                "Flags"                        CFNumber
 *   kSCPropNetIPv6PrefixLength                         "PrefixLength"                 CFArray[CFNumber]
 *   kSCPropNetIPv6Router                               "Router"                       CFString
 *   
 *   --- kSCPropNetIPv6ConfigMethod values ---
 *   kSCValNetIPv6ConfigMethodAutomatic                 "Automatic"
 *   kSCValNetIPv6ConfigMethodManual                    "Manual"
 *   kSCValNetIPv6ConfigMethodRouterAdvertisement       "RouterAdvertisement"
 *   kSCValNetIPv6ConfigMethod6to4                      "6to4"
 *   
 * kSCEntNet6to4 Entity Keys
 *
 *   kSCPropNet6to4Relay                                "Relay"                        CFString
 *   
 * kSCEntNetLink Entity Keys
 *
 *   kSCPropNetLinkActive                               "Active"                       CFBoolean
 *   kSCPropNetLinkDetaching                            "Detaching"                    CFBoolean
 *   
 * kSCEntNetModem (Hardware) Entity Keys
 *
 *   kSCPropNetModemConnectionScript                    "ConnectionScript"             CFString
 *   kSCPropNetModemConnectSpeed                        "ConnectSpeed"                 CFNumber
 *   kSCPropNetModemDataCompression                     "DataCompression"              CFNumber (0 or 1)
 *   kSCPropNetModemDialMode                            "DialMode"                     CFString
 *   kSCPropNetModemErrorCorrection                     "ErrorCorrection"              CFNumber (0 or 1)
 *   kSCPropNetModemHoldCallWaitingAudibleAlert         "HoldCallWaitingAudibleAlert"  CFNumber (0 or 1)
 *   kSCPropNetModemHoldDisconnectOnAnswer              "HoldDisconnectOnAnswer"       CFNumber (0 or 1)
 *   kSCPropNetModemHoldEnabled                         "HoldEnabled"                  CFNumber (0 or 1)
 *   kSCPropNetModemHoldReminder                        "HoldReminder"                 CFNumber (0 or 1)
 *   kSCPropNetModemHoldReminderTime                    "HoldReminderTime"             CFNumber
 *   kSCPropNetModemNote                                "Note"                         CFString
 *   kSCPropNetModemPulseDial                           "PulseDial"                    CFNumber (0 or 1)
 *   kSCPropNetModemSpeaker                             "Speaker"                      CFNumber (0 or 1)
 *   kSCPropNetModemSpeed                               "Speed"                        CFNumber
 *   
 *   --- kSCPropNetModemDialMode values ---
 *   kSCValNetModemDialModeIgnoreDialTone               "IgnoreDialTone"
 *   kSCValNetModemDialModeManual                       "Manual"
 *   kSCValNetModemDialModeWaitForDialTone              "WaitForDialTone"
 *   
 * kSCEntNetNetInfo Entity Keys
 *
 *   kSCPropNetNetInfoBindingMethods                    "BindingMethods"               CFString
 *   kSCPropNetNetInfoServerAddresses                   "ServerAddresses"              CFArray[CFString]
 *   kSCPropNetNetInfoServerTags                        "ServerTags"                   CFArray[CFString]
 *   kSCPropNetNetInfoBroadcastServerTag                "BroadcastServerTag"           CFString
 *   
 *   --- kSCPropNetNetInfoBindingMethods values ---
 *   kSCValNetNetInfoBindingMethodsBroadcast            "Broadcast"
 *   kSCValNetNetInfoBindingMethodsDHCP                 "DHCP"
 *   kSCValNetNetInfoBindingMethodsManual               "Manual"
 *   
 *   --- kSCPropNetNetInfoBroadcastServerTag default value ---
 *   kSCValNetNetInfoDefaultServerTag                   "network"
 *   
 * kSCEntNetPPP Entity Keys
 *
 *   kSCPropNetPPPACSPEnabled                           "ACSPEnabled"                  CFNumber (0 or 1)
 *   kSCPropNetPPPConnectTime                           "ConnectTime"                  CFNumber
 *   kSCPropNetPPPDeviceLastCause                       "DeviceLastCause"              CFNumber
 *   kSCPropNetPPPDialOnDemand                          "DialOnDemand"                 CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnFastUserSwitch            "DisconnectOnFastUserSwitch"   CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnIdle                      "DisconnectOnIdle"             CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnIdleTimer                 "DisconnectOnIdleTimer"        CFNumber
 *   kSCPropNetPPPDisconnectOnLogout                    "DisconnectOnLogout"           CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnSleep                     "DisconnectOnSleep"            CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectTime                        "DisconnectTime"               CFNumber
 *   kSCPropNetPPPIdleReminderTimer                     "IdleReminderTimer"            CFNumber
 *   kSCPropNetPPPIdleReminder                          "IdleReminder"                 CFNumber (0 or 1)
 *   kSCPropNetPPPLastCause                             "LastCause"                    CFNumber
 *   kSCPropNetPPPLogfile                               "Logfile"                      CFString
 *   kSCPropNetPPPPlugins                               "Plugins"                      CFArray[CFString]
 *   kSCPropNetPPPRetryConnectTime                      "RetryConnectTime"             CFNumber
 *   kSCPropNetPPPSessionTimer                          "SessionTimer"                 CFNumber
 *   kSCPropNetPPPStatus                                "Status"                       CFNumber
 *   kSCPropNetPPPUseSessionTimer                       "UseSessionTimer"              CFNumber (0 or 1)
 *   kSCPropNetPPPVerboseLogging                        "VerboseLogging"               CFNumber (0 or 1)
 *   
 *   --- Auth: ---
 *   kSCPropNetPPPAuthEAPPlugins                        "AuthEAPPlugins"               CFArray[CFString]
 *   kSCPropNetPPPAuthName                              "AuthName"                     CFString
 *   kSCPropNetPPPAuthPassword                          "AuthPassword"                 CFString
 *   kSCPropNetPPPAuthPasswordEncryption                "AuthPasswordEncryption"       CFString
 *   kSCPropNetPPPAuthPrompt                            "AuthPrompt"                   CFString
 *   kSCPropNetPPPAuthProtocol                          "AuthProtocol"                 CFArray[CFString]
 *   
 *   --- kSCPropNetPPPAuthPasswordEncryption values ---
 *   kSCValNetPPPAuthPasswordEncryptionKeychain         "Keychain"
 *   
 *   --- kSCPropNetPPPAuthPrompt values ---
 *   kSCValNetPPPAuthPromptBefore                       "Before"                       CFString
 *   kSCValNetPPPAuthPromptAfter                        "After"                        CFString
 *   
 *   --- kSCPropNetPPPAuthProtocol values ---
 *   kSCValNetPPPAuthProtocolCHAP                       "CHAP"                         CFString
 *   kSCValNetPPPAuthProtocolEAP                        "EAP"                          CFString
 *   kSCValNetPPPAuthProtocolMSCHAP1                    "MSCHAP1"                      CFString
 *   kSCValNetPPPAuthProtocolMSCHAP2                    "MSCHAP2"                      CFString
 *   kSCValNetPPPAuthProtocolPAP                        "PAP"                          CFString
 *   
 *   --- Comm: ---
 *   kSCPropNetPPPCommAlternateRemoteAddress            "CommAlternateRemoteAddress"   CFString
 *   kSCPropNetPPPCommConnectDelay                      "CommConnectDelay"             CFNumber
 *   kSCPropNetPPPCommDisplayTerminalWindow             "CommDisplayTerminalWindow"    CFNumber (0 or 1)
 *   kSCPropNetPPPCommRedialCount                       "CommRedialCount"              CFNumber
 *   kSCPropNetPPPCommRedialEnabled                     "CommRedialEnabled"            CFNumber (0 or 1)
 *   kSCPropNetPPPCommRedialInterval                    "CommRedialInterval"           CFNumber
 *   kSCPropNetPPPCommRemoteAddress                     "CommRemoteAddress"            CFString
 *   kSCPropNetPPPCommTerminalScript                    "CommTerminalScript"           CFString
 *   kSCPropNetPPPCommUseTerminalScript                 "CommUseTerminalScript"        CFNumber (0 or 1)
 *   
 *   --- CCP: ---
 *   kSCPropNetPPPCCPEnabled                            "CCPEnabled"                   CFNumber (0 or 1)
 *   kSCPropNetPPPCCPMPPE40Enabled                      "CCPMPPE40Enabled"             CFNumber (0 or 1)
 *   kSCPropNetPPPCCPMPPE128Enabled                     "CCPMPPE128Enabled"            CFNumber (0 or 1)
 *   
 *   --- IPCP: ---
 *   kSCPropNetPPPIPCPCompressionVJ                     "IPCPCompressionVJ"            CFNumber (0 or 1)
 *   kSCPropNetPPPIPCPUsePeerDNS                        "IPCPUsePeerDNS"               CFNumber (0 or 1)
 *   
 *   --- LCP: ---
 *   kSCPropNetPPPLCPEchoEnabled                        "LCPEchoEnabled"               CFNumber (0 or 1)
 *   kSCPropNetPPPLCPEchoFailure                        "LCPEchoFailure"               CFNumber
 *   kSCPropNetPPPLCPEchoInterval                       "LCPEchoInterval"              CFNumber
 *   kSCPropNetPPPLCPCompressionACField                 "LCPCompressionACField"        CFNumber (0 or 1)
 *   kSCPropNetPPPLCPCompressionPField                  "LCPCompressionPField"         CFNumber (0 or 1)
 *   kSCPropNetPPPLCPMRU                                "LCPMRU"                       CFNumber
 *   kSCPropNetPPPLCPMTU                                "LCPMTU"                       CFNumber
 *   kSCPropNetPPPLCPReceiveACCM                        "LCPReceiveACCM"               CFNumber
 *   kSCPropNetPPPLCPTransmitACCM                       "LCPTransmitACCM"              CFNumber
 *   
 * kSCEntNetPPPoE Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *   
 * kSCEntNetPPPSerial Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *   
 * kSCEntNetPPTP Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *   
 * kSCEntNetL2TP Entity Keys
 *
 *   kSCPropNetL2TPIPSecSharedSecret                    "IPSecSharedSecret"            CFString
 *   kSCPropNetL2TPIPSecSharedSecretEncryption          "IPSecSharedSecretEncryption"  CFString
 *   kSCPropNetL2TPTransport                            "Transport"                    CFString
 *   
 *   --- kSCPropNetL2TPIPSecSharedSecretEncryption values ---
 *   kSCValNetL2TPIPSecSharedSecretEncryptionKeychain   "Keychain"
 *   
 *   --- kSCPropNetL2TPTransport values ---
 *   kSCValNetL2TPTransportIP                           "IP"
 *   kSCValNetL2TPTransportIPSec                        "IPSec"
 *   
 * kSCEntNetProxies Entity Keys
 *
 *   kSCPropNetProxiesExceptionsList                    "ExceptionsList"               CFArray[CFString]
 *   kSCPropNetProxiesExcludeSimpleHostnames            "ExcludeSimpleHostnames"       CFNumber (0 or 1)
 *   kSCPropNetProxiesFTPEnable                         "FTPEnable"                    CFNumber (0 or 1)
 *   kSCPropNetProxiesFTPPassive                        "FTPPassive"                   CFNumber (0 or 1)
 *   kSCPropNetProxiesFTPPort                           "FTPPort"                      CFNumber
 *   kSCPropNetProxiesFTPProxy                          "FTPProxy"                     CFString
 *   kSCPropNetProxiesGopherEnable                      "GopherEnable"                 CFNumber (0 or 1)
 *   kSCPropNetProxiesGopherPort                        "GopherPort"                   CFNumber
 *   kSCPropNetProxiesGopherProxy                       "GopherProxy"                  CFString
 *   kSCPropNetProxiesHTTPEnable                        "HTTPEnable"                   CFNumber (0 or 1)
 *   kSCPropNetProxiesHTTPPort                          "HTTPPort"                     CFNumber
 *   kSCPropNetProxiesHTTPProxy                         "HTTPProxy"                    CFString
 *   kSCPropNetProxiesHTTPSEnable                       "HTTPSEnable"                  CFNumber (0 or 1)
 *   kSCPropNetProxiesHTTPSPort                         "HTTPSPort"                    CFNumber
 *   kSCPropNetProxiesHTTPSProxy                        "HTTPSProxy"                   CFString
 *   kSCPropNetProxiesRTSPEnable                        "RTSPEnable"                   CFNumber (0 or 1)
 *   kSCPropNetProxiesRTSPPort                          "RTSPPort"                     CFNumber
 *   kSCPropNetProxiesRTSPProxy                         "RTSPProxy"                    CFString
 *   kSCPropNetProxiesSOCKSEnable                       "SOCKSEnable"                  CFNumber (0 or 1)
 *   kSCPropNetProxiesSOCKSPort                         "SOCKSPort"                    CFNumber
 *   kSCPropNetProxiesSOCKSProxy                        "SOCKSProxy"                   CFString
 *   kSCPropNetProxiesProxyAutoConfigEnable             "ProxyAutoConfigEnable"        CFNumber (0 or 1)
 *   kSCPropNetProxiesProxyAutoConfigURLString          "ProxyAutoConfigURLString"     CFString
 *   kSCPropNetProxiesProxyAutoDiscoveryEnable          "ProxyAutoDiscoveryEnable"     CFNumber (0 or 1)
 *   
 * kSCCompUsers Entity Keys
 *
 *   kSCEntUsersConsoleUser                             "ConsoleUser"
 *   
 * kSCCompSystem Properties
 *
 *   kSCPropSystemComputerName                          "ComputerName"                 CFString
 *   kSCPropSystemComputerNameEncoding                  "ComputerNameEncoding"         CFNumber
 *   
 * SCDynamicStore "domain" prefixes
 *
 *   kSCDynamicStoreDomainFile                          "File:"
 *   kSCDynamicStoreDomainPlugin                        "Plugin:"
 *   kSCDynamicStoreDomainSetup                         "Setup:"
 *   kSCDynamicStoreDomainState                         "State:"
 *   kSCDynamicStoreDomainPrefs                         "Prefs:"
 *   
 * Preference ("location") Keys
 *
 *   kSCDynamicStorePropSetupCurrentSet                 "CurrentSet"                   CFString
 *   kSCDynamicStorePropSetupLastUpdated                "LastUpdated"
 *   
 * Common/shared Keys
 *
 *   kSCDynamicStorePropNetInterfaces                   "Interfaces"                   CFArray[CFString]
 *   kSCDynamicStorePropNetPrimaryInterface             "PrimaryInterface"             CFString
 *   kSCDynamicStorePropNetPrimaryService               "PrimaryService"               CFString
 *   kSCDynamicStorePropNetServiceIDs                   "ServiceIDs"                   CFArray[CFString]
 */


/*
 * Note: The MACOSX_DEPLOYMENT_TARGET environment variable should be used
 *       when building an application targeted for an earlier version of
 *       Mac OS X.  Please reference Technical Note TN2064 for more details.
 */

/*
 * Note: For Cocoa/Obj-C/Foundation applications accessing these preference
 *       keys you may want to consider the following :
 *
 *       #define SC_SCHEMA_DECLARATION(k,q)	extern NSString * k
 *       #import <SystemConfiguration/SystemConfiguration.h>
 */

/*
 * Note: For CFM applications using these schema keys you may want to
 *       consider the following :
 *
 *       #define SC_SCHEMA_KV(k,v,t)	lookup_SC_key( CFSTR( #k ) )
 *       #define SC_SCHEMA_DECLARATION(k,q)
 *       #include <SystemConfiguration/SystemConfiguration.h>
 *
 *       CFStringRef lookup_SC_key(CFStringRef key)
 *       {
 *         // this function should [dynamically, on-demand] load the
 *         // SystemConfiguration.framework, look up the provided key,
 *         // and return the associated value.
 *       }
 */

/*
 * Note: Earlier versions of this header file defined a "SCSTR" macro
 *       which helped to facilitate Obj-C development. Use of this macro
 *       has been deprecated (in Mac OS X 10.4) in favor of the newer
 *       "SC_SCHEMA_KV" and "SC_SCHEMA_DECLARATION" macros
 */


#ifndef _SCSCHEMADEFINITIONS_H
#define _SCSCHEMADEFINITIONS_H

/* -------------------- Macro declarations -------------------- */

#include <AvailabilityMacros.h>

/*
 * let's "do the right thing" for those wishing to build for
 * Mac OS X 10.1 and 10.2
 */
#if MAC_OS_X_VERSION_10_3 > MAC_OS_X_VERSION_MIN_REQUIRED
  #if MAC_OS_X_VERSION_10_1 <= MAC_OS_X_VERSION_MIN_REQUIRED
    #ifndef SCSTR
      #include <CoreFoundation/CFString.h>
      #define SCSTR(s) CFSTR(s)
    #endif
    #ifndef SC_SCHEMA_KV
      #define SC_SCHEMA_KV(k,v,t)	SCSTR( v )
    #endif
    #ifndef SC_SCHEMA_DECLARATION
      #define SC_SCHEMA_DECLARATION(k,q)
    #endif
  #endif
#endif

/*
 * Define a schema key/value/type tuple
 */
#ifndef SC_SCHEMA_KV
  #define SC_SCHEMA_KV(k,v,t)	k
#endif

/*
 * Provide an "extern" for the key/value
 */
#ifndef SC_SCHEMA_DECLARATION
  #ifndef SCSTR
    #include <CoreFoundation/CFString.h>
    #define SC_SCHEMA_DECLARATION(k,q)	extern const CFStringRef k q
  #else
    #import <Foundation/NSString.h>
    #define SC_SCHEMA_DECLARATION(k,q)	extern NSString * k q
  #endif
#endif
#if MAC_OS_X_VERSION_10_4 >= MAC_OS_X_VERSION_MIN_REQUIRED
  #if MAC_OS_X_VERSION_10_1 <= MAC_OS_X_VERSION_MIN_REQUIRED
    #ifndef SCSTR
      #include <CoreFoundation/CFString.h>
      #define SCSTR(s) CFSTR(s)
    #endif
  #endif
#endif


/* -------------------- HeaderDoc comments -------------------- */


#if	0
/*!
 *	@header SCSchemaDefinitions
 */

/*!
  @const kSCResvLink
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCResvLink;

/*!
  @const kSCResvInactive
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCResvInactive;

/*!
  @const kSCPropInterfaceName
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropInterfaceName;

/*!
  @const kSCPropMACAddress
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropMACAddress;

/*!
  @const kSCPropUserDefinedName
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropUserDefinedName;

/*!
  @const kSCPropVersion
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropVersion;

/*!
  @group Preference Keys
 */

/*!
  @const kSCPrefCurrentSet
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPrefCurrentSet;

/*!
  @const kSCPrefNetworkServices
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPrefNetworkServices;

/*!
  @const kSCPrefSets
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPrefSets;

/*!
  @const kSCPrefSystem
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPrefSystem;

/*!
  @group Component Keys
 */

/*!
  @const kSCCompNetwork
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCCompNetwork;

/*!
  @const kSCCompService
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCCompService;

/*!
  @const kSCCompGlobal
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCCompGlobal;

/*!
  @const kSCCompHostNames
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCCompHostNames;

/*!
  @const kSCCompInterface
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCCompInterface;

/*!
  @const kSCCompSystem
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCCompSystem;

/*!
  @const kSCCompUsers
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCCompUsers;

/*!
  @const kSCCompAnyRegex
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCCompAnyRegex;

/*!
  @group Network Entity Keys
 */

/*!
  @const kSCEntNetAirPort
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetAirPort;

/*!
  @const kSCEntNetAppleTalk
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetAppleTalk;

/*!
  @const kSCEntNetDHCP
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetDHCP;

/*!
  @const kSCEntNetDNS
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetDNS;

/*!
  @const kSCEntNetEthernet
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetEthernet;

/*!
  @const kSCEntNetFireWire
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCEntNetFireWire;

/*!
  @const kSCEntNetInterface
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetInterface;

/*!
  @const kSCEntNetIPv4
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetIPv4;

/*!
  @const kSCEntNetIPv6
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetIPv6;

/*!
  @const kSCEntNetL2TP
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCEntNetL2TP;

/*!
  @const kSCEntNetLink
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetLink;

/*!
  @const kSCEntNetModem
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetModem;

/*!
  @const kSCEntNetNetInfo
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetNetInfo;

/*!
  @const kSCEntNetPPP
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetPPP;

/*!
  @const kSCEntNetPPPoE
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetPPPoE;

/*!
  @const kSCEntNetPPPSerial
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCEntNetPPPSerial;

/*!
  @const kSCEntNetPPTP
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCEntNetPPTP;

/*!
  @const kSCEntNetProxies
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntNetProxies;

/*!
  @const kSCEntNet6to4
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCEntNet6to4;

/*!
  @group kSCCompNetwork Properties
 */

/*!
  @const kSCPropNetOverridePrimary
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetOverridePrimary;

/*!
  @const kSCPropNetServiceOrder
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetServiceOrder;

/*!
  @const kSCPropNetPPPOverridePrimary
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPOverridePrimary;

/*!
  @group kSCCompNetworkInterface Properties
 */

/*!
  @const kSCPropNetInterfaces
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetInterfaces;

/*!
  @group kSCCompNetworkHostNames Properties
 */

/*!
  @const kSCPropNetLocalHostName
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetLocalHostName;

/*!
  @group kSCEntNetAirPort (Hardware) Entity Keys
 */

/*!
  @const kSCPropNetAirPortAllowNetCreation
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetAirPortAllowNetCreation;

/*!
  @const kSCPropNetAirPortAuthPassword
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAirPortAuthPassword;

/*!
  @const kSCPropNetAirPortAuthPasswordEncryption
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAirPortAuthPasswordEncryption;

/*!
  @const kSCPropNetAirPortJoinMode
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetAirPortJoinMode;

/*!
  @const kSCPropNetAirPortPowerEnabled
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAirPortPowerEnabled;

/*!
  @const kSCPropNetAirPortPreferredNetwork
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAirPortPreferredNetwork;

/*!
  @const kSCPropNetAirPortSavePasswords
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetAirPortSavePasswords;

/*!
  @const kSCValNetAirPortJoinModeAutomatic
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetAirPortJoinModeAutomatic;

/*!
  @const kSCValNetAirPortJoinModePreferred
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCValNetAirPortJoinModePreferred;

/*!
  @const kSCValNetAirPortJoinModeRecent
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCValNetAirPortJoinModeRecent;

/*!
  @const kSCValNetAirPortJoinModeStrongest
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCValNetAirPortJoinModeStrongest;

/*!
  @const kSCValNetAirPortAuthPasswordEncryptionKeychain
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetAirPortAuthPasswordEncryptionKeychain;

/*!
  @group kSCEntNetAppleTalk Entity Keys
 */

/*!
  @const kSCPropNetAppleTalkComputerName
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAppleTalkComputerName;

/*!
  @const kSCPropNetAppleTalkComputerNameEncoding
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAppleTalkComputerNameEncoding;

/*!
  @const kSCPropNetAppleTalkConfigMethod
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAppleTalkConfigMethod;

/*!
  @const kSCPropNetAppleTalkDefaultZone
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAppleTalkDefaultZone;

/*!
  @const kSCPropNetAppleTalkNetworkID
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAppleTalkNetworkID;

/*!
  @const kSCPropNetAppleTalkNetworkRange
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetAppleTalkNetworkRange;

/*!
  @const kSCPropNetAppleTalkNodeID
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAppleTalkNodeID;

/*!
  @const kSCPropNetAppleTalkSeedNetworkRange
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAppleTalkSeedNetworkRange;

/*!
  @const kSCPropNetAppleTalkSeedZones
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetAppleTalkSeedZones;

/*!
  @const kSCValNetAppleTalkConfigMethodNode
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetAppleTalkConfigMethodNode;

/*!
  @const kSCValNetAppleTalkConfigMethodRouter
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetAppleTalkConfigMethodRouter;

/*!
  @const kSCValNetAppleTalkConfigMethodSeedRouter
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetAppleTalkConfigMethodSeedRouter;

/*!
  @group kSCEntNetDNS Entity Keys
 */

/*!
  @const kSCPropNetDNSDomainName
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetDNSDomainName;

/*!
  @const kSCPropNetDNSOptions
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetDNSOptions;

/*!
  @const kSCPropNetDNSSearchDomains
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetDNSSearchDomains;

/*!
  @const kSCPropNetDNSSearchOrder
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetDNSSearchOrder;

/*!
  @const kSCPropNetDNSServerAddresses
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetDNSServerAddresses;

/*!
  @const kSCPropNetDNSServerPort
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetDNSServerPort;

/*!
  @const kSCPropNetDNSServerTimeout
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetDNSServerTimeout;

/*!
  @const kSCPropNetDNSSortList
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetDNSSortList;

/*!
  @const kSCPropNetDNSSupplementalMatchDomains
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetDNSSupplementalMatchDomains;

/*!
  @const kSCPropNetDNSSupplementalMatchOrders
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetDNSSupplementalMatchOrders;

/*!
  @group kSCEntNetEthernet (Hardware) Entity Keys
 */

/*!
  @const kSCPropNetEthernetMediaSubType
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetEthernetMediaSubType;

/*!
  @const kSCPropNetEthernetMediaOptions
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetEthernetMediaOptions;

/*!
  @const kSCPropNetEthernetMTU
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetEthernetMTU;

/*!
  @group kSCEntNetFireWire (Hardware) Entity Keys
 */

/*!
  @group kSCEntNetInterface Entity Keys
 */

/*!
  @const kSCPropNetInterfaceDeviceName
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetInterfaceDeviceName;

/*!
  @const kSCPropNetInterfaceHardware
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetInterfaceHardware;

/*!
  @const kSCPropNetInterfaceType
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetInterfaceType;

/*!
  @const kSCPropNetInterfaceSubType
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetInterfaceSubType;

/*!
  @const kSCPropNetInterfaceSupportsModemOnHold
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetInterfaceSupportsModemOnHold;

/*!
  @const kSCValNetInterfaceTypeEthernet
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetInterfaceTypeEthernet;

/*!
  @const kSCValNetInterfaceTypeFireWire
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetInterfaceTypeFireWire;

/*!
  @const kSCValNetInterfaceTypePPP
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetInterfaceTypePPP;

/*!
  @const kSCValNetInterfaceType6to4
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetInterfaceType6to4;

/*!
  @const kSCValNetInterfaceSubTypePPPoE
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetInterfaceSubTypePPPoE;

/*!
  @const kSCValNetInterfaceSubTypePPPSerial
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetInterfaceSubTypePPPSerial;

/*!
  @const kSCValNetInterfaceSubTypePPTP
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCValNetInterfaceSubTypePPTP;

/*!
  @const kSCValNetInterfaceSubTypeL2TP
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetInterfaceSubTypeL2TP;

/*!
  @group kSCEntNetIPv4 Entity Keys
 */

/*!
  @const kSCPropNetIPv4Addresses
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetIPv4Addresses;

/*!
  @const kSCPropNetIPv4ConfigMethod
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetIPv4ConfigMethod;

/*!
  @const kSCPropNetIPv4DHCPClientID
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetIPv4DHCPClientID;

/*!
  @const kSCPropNetIPv4Router
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetIPv4Router;

/*!
  @const kSCPropNetIPv4SubnetMasks
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetIPv4SubnetMasks;

/*!
  @const kSCPropNetIPv4DestAddresses
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetIPv4DestAddresses;

/*!
  @const kSCPropNetIPv4BroadcastAddresses
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetIPv4BroadcastAddresses;

/*!
  @const kSCValNetIPv4ConfigMethodBOOTP
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodBOOTP;

/*!
  @const kSCValNetIPv4ConfigMethodDHCP
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodDHCP;

/*!
  @const kSCValNetIPv4ConfigMethodINFORM
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodINFORM;

/*!
  @const kSCValNetIPv4ConfigMethodLinkLocal
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodLinkLocal;

/*!
  @const kSCValNetIPv4ConfigMethodManual
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodManual;

/*!
  @const kSCValNetIPv4ConfigMethodPPP
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodPPP;

/*!
  @group kSCEntNetIPv6 Entity Keys
 */

/*!
  @const kSCPropNetIPv6Addresses
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetIPv6Addresses;

/*!
  @const kSCPropNetIPv6ConfigMethod
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetIPv6ConfigMethod;

/*!
  @const kSCPropNetIPv6DestAddresses
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetIPv6DestAddresses;

/*!
  @const kSCPropNetIPv6Flags
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetIPv6Flags;

/*!
  @const kSCPropNetIPv6PrefixLength
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetIPv6PrefixLength;

/*!
  @const kSCPropNetIPv6Router
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetIPv6Router;

/*!
  @const kSCValNetIPv6ConfigMethodAutomatic
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodAutomatic;

/*!
  @const kSCValNetIPv6ConfigMethodManual
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodManual;

/*!
  @const kSCValNetIPv6ConfigMethodRouterAdvertisement
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodRouterAdvertisement;

/*!
  @const kSCValNetIPv6ConfigMethod6to4
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetIPv6ConfigMethod6to4;

/*!
  @group kSCEntNet6to4 Entity Keys
 */

/*!
  @const kSCPropNet6to4Relay
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNet6to4Relay;

/*!
  @group kSCEntNetLink Entity Keys
 */

/*!
  @const kSCPropNetLinkActive
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetLinkActive;

/*!
  @const kSCPropNetLinkDetaching
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetLinkDetaching;

/*!
  @group kSCEntNetModem (Hardware) Entity Keys
 */

/*!
  @const kSCPropNetModemConnectionScript
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetModemConnectionScript;

/*!
  @const kSCPropNetModemConnectSpeed
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetModemConnectSpeed;

/*!
  @const kSCPropNetModemDataCompression
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetModemDataCompression;

/*!
  @const kSCPropNetModemDialMode
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetModemDialMode;

/*!
  @const kSCPropNetModemErrorCorrection
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetModemErrorCorrection;

/*!
  @const kSCPropNetModemHoldCallWaitingAudibleAlert
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetModemHoldCallWaitingAudibleAlert;

/*!
  @const kSCPropNetModemHoldDisconnectOnAnswer
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetModemHoldDisconnectOnAnswer;

/*!
  @const kSCPropNetModemHoldEnabled
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetModemHoldEnabled;

/*!
  @const kSCPropNetModemHoldReminder
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetModemHoldReminder;

/*!
  @const kSCPropNetModemHoldReminderTime
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetModemHoldReminderTime;

/*!
  @const kSCPropNetModemNote
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetModemNote;

/*!
  @const kSCPropNetModemPulseDial
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetModemPulseDial;

/*!
  @const kSCPropNetModemSpeaker
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetModemSpeaker;

/*!
  @const kSCPropNetModemSpeed
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetModemSpeed;

/*!
  @const kSCValNetModemDialModeIgnoreDialTone
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetModemDialModeIgnoreDialTone;

/*!
  @const kSCValNetModemDialModeManual
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetModemDialModeManual;

/*!
  @const kSCValNetModemDialModeWaitForDialTone
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetModemDialModeWaitForDialTone;

/*!
  @group kSCEntNetNetInfo Entity Keys
 */

/*!
  @const kSCPropNetNetInfoBindingMethods
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetNetInfoBindingMethods;

/*!
  @const kSCPropNetNetInfoServerAddresses
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetNetInfoServerAddresses;

/*!
  @const kSCPropNetNetInfoServerTags
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetNetInfoServerTags;

/*!
  @const kSCPropNetNetInfoBroadcastServerTag
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetNetInfoBroadcastServerTag;

/*!
  @const kSCValNetNetInfoBindingMethodsBroadcast
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetNetInfoBindingMethodsBroadcast;

/*!
  @const kSCValNetNetInfoBindingMethodsDHCP
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetNetInfoBindingMethodsDHCP;

/*!
  @const kSCValNetNetInfoBindingMethodsManual
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetNetInfoBindingMethodsManual;

/*!
  @const kSCValNetNetInfoDefaultServerTag
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetNetInfoDefaultServerTag;

/*!
  @group kSCEntNetPPP Entity Keys
 */

/*!
  @const kSCPropNetPPPACSPEnabled
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetPPPACSPEnabled;

/*!
  @const kSCPropNetPPPConnectTime
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetPPPConnectTime;

/*!
  @const kSCPropNetPPPDeviceLastCause
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetPPPDeviceLastCause;

/*!
  @const kSCPropNetPPPDialOnDemand
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPDialOnDemand;

/*!
  @const kSCPropNetPPPDisconnectOnFastUserSwitch
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnFastUserSwitch;

/*!
  @const kSCPropNetPPPDisconnectOnIdle
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnIdle;

/*!
  @const kSCPropNetPPPDisconnectOnIdleTimer
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnIdleTimer;

/*!
  @const kSCPropNetPPPDisconnectOnLogout
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnLogout;

/*!
  @const kSCPropNetPPPDisconnectOnSleep
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnSleep;

/*!
  @const kSCPropNetPPPDisconnectTime
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetPPPDisconnectTime;

/*!
  @const kSCPropNetPPPIdleReminderTimer
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPIdleReminderTimer;

/*!
  @const kSCPropNetPPPIdleReminder
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPIdleReminder;

/*!
  @const kSCPropNetPPPLastCause
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetPPPLastCause;

/*!
  @const kSCPropNetPPPLogfile
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLogfile;

/*!
  @const kSCPropNetPPPPlugins
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetPPPPlugins;

/*!
  @const kSCPropNetPPPRetryConnectTime
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetPPPRetryConnectTime;

/*!
  @const kSCPropNetPPPSessionTimer
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPSessionTimer;

/*!
  @const kSCPropNetPPPStatus
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetPPPStatus;

/*!
  @const kSCPropNetPPPUseSessionTimer
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetPPPUseSessionTimer;

/*!
  @const kSCPropNetPPPVerboseLogging
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPVerboseLogging;

/*!
  @const kSCPropNetPPPAuthEAPPlugins
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetPPPAuthEAPPlugins;

/*!
  @const kSCPropNetPPPAuthName
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPAuthName;

/*!
  @const kSCPropNetPPPAuthPassword
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPAuthPassword;

/*!
  @const kSCPropNetPPPAuthPasswordEncryption
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPAuthPasswordEncryption;

/*!
  @const kSCPropNetPPPAuthPrompt
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetPPPAuthPrompt;

/*!
  @const kSCPropNetPPPAuthProtocol
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPAuthProtocol;

/*!
  @const kSCValNetPPPAuthPasswordEncryptionKeychain
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetPPPAuthPasswordEncryptionKeychain;

/*!
  @const kSCValNetPPPAuthPromptBefore
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetPPPAuthPromptBefore;

/*!
  @const kSCValNetPPPAuthPromptAfter
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetPPPAuthPromptAfter;

/*!
  @const kSCValNetPPPAuthProtocolCHAP
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetPPPAuthProtocolCHAP;

/*!
  @const kSCValNetPPPAuthProtocolEAP
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetPPPAuthProtocolEAP;

/*!
  @const kSCValNetPPPAuthProtocolMSCHAP1
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetPPPAuthProtocolMSCHAP1;

/*!
  @const kSCValNetPPPAuthProtocolMSCHAP2
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetPPPAuthProtocolMSCHAP2;

/*!
  @const kSCValNetPPPAuthProtocolPAP
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCValNetPPPAuthProtocolPAP;

/*!
  @const kSCPropNetPPPCommAlternateRemoteAddress
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPCommAlternateRemoteAddress;

/*!
  @const kSCPropNetPPPCommConnectDelay
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPCommConnectDelay;

/*!
  @const kSCPropNetPPPCommDisplayTerminalWindow
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPCommDisplayTerminalWindow;

/*!
  @const kSCPropNetPPPCommRedialCount
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPCommRedialCount;

/*!
  @const kSCPropNetPPPCommRedialEnabled
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPCommRedialEnabled;

/*!
  @const kSCPropNetPPPCommRedialInterval
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPCommRedialInterval;

/*!
  @const kSCPropNetPPPCommRemoteAddress
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPCommRemoteAddress;

/*!
  @const kSCPropNetPPPCommTerminalScript
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPCommTerminalScript;

/*!
  @const kSCPropNetPPPCommUseTerminalScript
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetPPPCommUseTerminalScript;

/*!
  @const kSCPropNetPPPCCPEnabled
  @availability Introduced in Mac OS X 10.2.
 */
extern const CFStringRef kSCPropNetPPPCCPEnabled;

/*!
  @const kSCPropNetPPPCCPMPPE40Enabled
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetPPPCCPMPPE40Enabled;

/*!
  @const kSCPropNetPPPCCPMPPE128Enabled
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetPPPCCPMPPE128Enabled;

/*!
  @const kSCPropNetPPPIPCPCompressionVJ
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPIPCPCompressionVJ;

/*!
  @const kSCPropNetPPPIPCPUsePeerDNS
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetPPPIPCPUsePeerDNS;

/*!
  @const kSCPropNetPPPLCPEchoEnabled
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLCPEchoEnabled;

/*!
  @const kSCPropNetPPPLCPEchoFailure
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLCPEchoFailure;

/*!
  @const kSCPropNetPPPLCPEchoInterval
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLCPEchoInterval;

/*!
  @const kSCPropNetPPPLCPCompressionACField
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLCPCompressionACField;

/*!
  @const kSCPropNetPPPLCPCompressionPField
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLCPCompressionPField;

/*!
  @const kSCPropNetPPPLCPMRU
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLCPMRU;

/*!
  @const kSCPropNetPPPLCPMTU
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLCPMTU;

/*!
  @const kSCPropNetPPPLCPReceiveACCM
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLCPReceiveACCM;

/*!
  @const kSCPropNetPPPLCPTransmitACCM
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetPPPLCPTransmitACCM;

/*!
  @group kSCEntNetPPPoE Entity Keys
 */

/*!
  @group kSCEntNetPPPSerial Entity Keys
 */

/*!
  @group kSCEntNetPPTP Entity Keys
 */

/*!
  @group kSCEntNetL2TP Entity Keys
 */

/*!
  @const kSCPropNetL2TPIPSecSharedSecret
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetL2TPIPSecSharedSecret;

/*!
  @const kSCPropNetL2TPIPSecSharedSecretEncryption
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetL2TPIPSecSharedSecretEncryption;

/*!
  @const kSCPropNetL2TPTransport
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCPropNetL2TPTransport;

/*!
  @const kSCValNetL2TPIPSecSharedSecretEncryptionKeychain
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetL2TPIPSecSharedSecretEncryptionKeychain;

/*!
  @const kSCValNetL2TPTransportIP
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetL2TPTransportIP;

/*!
  @const kSCValNetL2TPTransportIPSec
  @availability Introduced in Mac OS X 10.3.
 */
extern const CFStringRef kSCValNetL2TPTransportIPSec;

/*!
  @group kSCEntNetProxies Entity Keys
 */

/*!
  @const kSCPropNetProxiesExceptionsList
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesExceptionsList;

/*!
  @const kSCPropNetProxiesExcludeSimpleHostnames
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetProxiesExcludeSimpleHostnames;

/*!
  @const kSCPropNetProxiesFTPEnable
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesFTPEnable;

/*!
  @const kSCPropNetProxiesFTPPassive
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesFTPPassive;

/*!
  @const kSCPropNetProxiesFTPPort
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesFTPPort;

/*!
  @const kSCPropNetProxiesFTPProxy
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesFTPProxy;

/*!
  @const kSCPropNetProxiesGopherEnable
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesGopherEnable;

/*!
  @const kSCPropNetProxiesGopherPort
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesGopherPort;

/*!
  @const kSCPropNetProxiesGopherProxy
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesGopherProxy;

/*!
  @const kSCPropNetProxiesHTTPEnable
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesHTTPEnable;

/*!
  @const kSCPropNetProxiesHTTPPort
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesHTTPPort;

/*!
  @const kSCPropNetProxiesHTTPProxy
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesHTTPProxy;

/*!
  @const kSCPropNetProxiesHTTPSEnable
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesHTTPSEnable;

/*!
  @const kSCPropNetProxiesHTTPSPort
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesHTTPSPort;

/*!
  @const kSCPropNetProxiesHTTPSProxy
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesHTTPSProxy;

/*!
  @const kSCPropNetProxiesRTSPEnable
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesRTSPEnable;

/*!
  @const kSCPropNetProxiesRTSPPort
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesRTSPPort;

/*!
  @const kSCPropNetProxiesRTSPProxy
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesRTSPProxy;

/*!
  @const kSCPropNetProxiesSOCKSEnable
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesSOCKSEnable;

/*!
  @const kSCPropNetProxiesSOCKSPort
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesSOCKSPort;

/*!
  @const kSCPropNetProxiesSOCKSProxy
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropNetProxiesSOCKSProxy;

/*!
  @const kSCPropNetProxiesProxyAutoConfigEnable
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoConfigEnable;

/*!
  @const kSCPropNetProxiesProxyAutoConfigURLString
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoConfigURLString;

/*!
  @const kSCPropNetProxiesProxyAutoDiscoveryEnable
  @availability Introduced in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoDiscoveryEnable;

/*!
  @group kSCCompUsers Entity Keys
 */

/*!
  @const kSCEntUsersConsoleUser
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCEntUsersConsoleUser;

/*!
  @group kSCCompSystem Properties
 */

/*!
  @const kSCPropSystemComputerName
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropSystemComputerName;

/*!
  @const kSCPropSystemComputerNameEncoding
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCPropSystemComputerNameEncoding;

/*!
  @group SCDynamicStore "domain" prefixes
 */

/*!
  @const kSCDynamicStoreDomainFile
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStoreDomainFile;

/*!
  @const kSCDynamicStoreDomainPlugin
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStoreDomainPlugin;

/*!
  @const kSCDynamicStoreDomainSetup
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStoreDomainSetup;

/*!
  @const kSCDynamicStoreDomainState
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStoreDomainState;

/*!
  @const kSCDynamicStoreDomainPrefs
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStoreDomainPrefs;

/*!
  @group Preference ("location") Keys
 */

/*!
  @const kSCDynamicStorePropSetupCurrentSet
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStorePropSetupCurrentSet;

/*!
  @const kSCDynamicStorePropSetupLastUpdated
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStorePropSetupLastUpdated;

/*!
  @group Common/shared Keys
 */

/*!
  @const kSCDynamicStorePropNetInterfaces
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStorePropNetInterfaces;

/*!
  @const kSCDynamicStorePropNetPrimaryInterface
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStorePropNetPrimaryInterface;

/*!
  @const kSCDynamicStorePropNetPrimaryService
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStorePropNetPrimaryService;

/*!
  @const kSCDynamicStorePropNetServiceIDs
  @availability Introduced in Mac OS X 10.1.
 */
extern const CFStringRef kSCDynamicStorePropNetServiceIDs;

/*!
  @const kSCPropUsersConsoleUserName
  @availability Introduced in Mac OS X 10.1, but later deprecated in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropUsersConsoleUserName;

/*!
  @const kSCPropUsersConsoleUserUID
  @availability Introduced in Mac OS X 10.1, but later deprecated in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropUsersConsoleUserUID;

/*!
  @const kSCPropUsersConsoleUserGID
  @availability Introduced in Mac OS X 10.1, but later deprecated in Mac OS X 10.4.
 */
extern const CFStringRef kSCPropUsersConsoleUserGID;

#endif	/* 0 */


/* -------------------- Schema declarations -------------------- */


#define kSCResvLink                                                   \
	SC_SCHEMA_KV(kSCResvLink                                      \
	            ,"__LINK__"                                       \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCResvLink,);

#define kSCResvInactive                                               \
	SC_SCHEMA_KV(kSCResvInactive                                  \
	            ,"__INACTIVE__"                                   \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCResvInactive,);

#define kSCPropInterfaceName                                          \
	SC_SCHEMA_KV(kSCPropInterfaceName                             \
	            ,"InterfaceName"                                  \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropInterfaceName,);

#define kSCPropMACAddress                                             \
	SC_SCHEMA_KV(kSCPropMACAddress                                \
	            ,"MACAddress"                                     \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropMACAddress,);

#define kSCPropUserDefinedName                                        \
	SC_SCHEMA_KV(kSCPropUserDefinedName                           \
	            ,"UserDefinedName"                                \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropUserDefinedName,);

#define kSCPropVersion                                                \
	SC_SCHEMA_KV(kSCPropVersion                                   \
	            ,"Version"                                        \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropVersion,);

#define kSCPrefCurrentSet                                             \
	SC_SCHEMA_KV(kSCPrefCurrentSet                                \
	            ,"CurrentSet"                                     \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPrefCurrentSet,);

#define kSCPrefNetworkServices                                        \
	SC_SCHEMA_KV(kSCPrefNetworkServices                           \
	            ,"NetworkServices"                                \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCPrefNetworkServices,);

#define kSCPrefSets                                                   \
	SC_SCHEMA_KV(kSCPrefSets                                      \
	            ,"Sets"                                           \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCPrefSets,);

#define kSCPrefSystem                                                 \
	SC_SCHEMA_KV(kSCPrefSystem                                    \
	            ,"System"                                         \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCPrefSystem,);

#define kSCCompNetwork                                                \
	SC_SCHEMA_KV(kSCCompNetwork                                   \
	            ,"Network"                                        \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCCompNetwork,);

#define kSCCompService                                                \
	SC_SCHEMA_KV(kSCCompService                                   \
	            ,"Service"                                        \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCCompService,);

#define kSCCompGlobal                                                 \
	SC_SCHEMA_KV(kSCCompGlobal                                    \
	            ,"Global"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCCompGlobal,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCCompHostNames                                              \
	SC_SCHEMA_KV(kSCCompHostNames                                 \
	            ,"HostNames"                                      \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCCompHostNames, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCCompInterface                                              \
	SC_SCHEMA_KV(kSCCompInterface                                 \
	            ,"Interface"                                      \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCCompInterface,);

#define kSCCompSystem                                                 \
	SC_SCHEMA_KV(kSCCompSystem                                    \
	            ,"System"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCCompSystem,);

#define kSCCompUsers                                                  \
	SC_SCHEMA_KV(kSCCompUsers                                     \
	            ,"Users"                                          \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCCompUsers,);

#define kSCCompAnyRegex                                               \
	SC_SCHEMA_KV(kSCCompAnyRegex                                  \
	            ,"[^/]+"                                          \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCCompAnyRegex,);

#define kSCEntNetAirPort                                              \
	SC_SCHEMA_KV(kSCEntNetAirPort                                 \
	            ,"AirPort"                                        \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetAirPort,);

#define kSCEntNetAppleTalk                                            \
	SC_SCHEMA_KV(kSCEntNetAppleTalk                               \
	            ,"AppleTalk"                                      \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetAppleTalk,);

#define kSCEntNetDHCP                                                 \
	SC_SCHEMA_KV(kSCEntNetDHCP                                    \
	            ,"DHCP"                                           \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetDHCP,);

#define kSCEntNetDNS                                                  \
	SC_SCHEMA_KV(kSCEntNetDNS                                     \
	            ,"DNS"                                            \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetDNS,);

#define kSCEntNetEthernet                                             \
	SC_SCHEMA_KV(kSCEntNetEthernet                                \
	            ,"Ethernet"                                       \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetEthernet,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCEntNetFireWire                                             \
	SC_SCHEMA_KV(kSCEntNetFireWire                                \
	            ,"FireWire"                                       \
	            ,CFDictionary                                     )
#endif
	SC_SCHEMA_DECLARATION(kSCEntNetFireWire, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCEntNetInterface                                            \
	SC_SCHEMA_KV(kSCEntNetInterface                               \
	            ,"Interface"                                      \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetInterface,);

#define kSCEntNetIPv4                                                 \
	SC_SCHEMA_KV(kSCEntNetIPv4                                    \
	            ,"IPv4"                                           \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetIPv4,);

#define kSCEntNetIPv6                                                 \
	SC_SCHEMA_KV(kSCEntNetIPv6                                    \
	            ,"IPv6"                                           \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetIPv6,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCEntNetL2TP                                                 \
	SC_SCHEMA_KV(kSCEntNetL2TP                                    \
	            ,"L2TP"                                           \
	            ,CFDictionary                                     )
#endif
	SC_SCHEMA_DECLARATION(kSCEntNetL2TP, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCEntNetLink                                                 \
	SC_SCHEMA_KV(kSCEntNetLink                                    \
	            ,"Link"                                           \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetLink,);

#define kSCEntNetModem                                                \
	SC_SCHEMA_KV(kSCEntNetModem                                   \
	            ,"Modem"                                          \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetModem,);

#define kSCEntNetNetInfo                                              \
	SC_SCHEMA_KV(kSCEntNetNetInfo                                 \
	            ,"NetInfo"                                        \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetNetInfo,);

#define kSCEntNetPPP                                                  \
	SC_SCHEMA_KV(kSCEntNetPPP                                     \
	            ,"PPP"                                            \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetPPP,);

#define kSCEntNetPPPoE                                                \
	SC_SCHEMA_KV(kSCEntNetPPPoE                                   \
	            ,"PPPoE"                                          \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetPPPoE,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCEntNetPPPSerial                                            \
	SC_SCHEMA_KV(kSCEntNetPPPSerial                               \
	            ,"PPPSerial"                                      \
	            ,CFDictionary                                     )
#endif
	SC_SCHEMA_DECLARATION(kSCEntNetPPPSerial, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCEntNetPPTP                                                 \
	SC_SCHEMA_KV(kSCEntNetPPTP                                    \
	            ,"PPTP"                                           \
	            ,CFDictionary                                     )
#endif
	SC_SCHEMA_DECLARATION(kSCEntNetPPTP, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCEntNetProxies                                              \
	SC_SCHEMA_KV(kSCEntNetProxies                                 \
	            ,"Proxies"                                        \
	            ,CFDictionary                                     )
	SC_SCHEMA_DECLARATION(kSCEntNetProxies,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCEntNet6to4                                                 \
	SC_SCHEMA_KV(kSCEntNet6to4                                    \
	            ,"6to4"                                           \
	            ,CFDictionary                                     )
#endif
	SC_SCHEMA_DECLARATION(kSCEntNet6to4, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetOverridePrimary                                     \
	SC_SCHEMA_KV(kSCPropNetOverridePrimary                        \
	            ,"OverridePrimary"                                \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetOverridePrimary, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetServiceOrder                                        \
	SC_SCHEMA_KV(kSCPropNetServiceOrder                           \
	            ,"ServiceOrder"                                   \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetServiceOrder,);

#define kSCPropNetPPPOverridePrimary                                  \
	SC_SCHEMA_KV(kSCPropNetPPPOverridePrimary                     \
	            ,"PPPOverridePrimary"                             \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPOverridePrimary,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetInterfaces                                          \
	SC_SCHEMA_KV(kSCPropNetInterfaces                             \
	            ,"Interfaces"                                     \
	            ,CFArray[CFString]                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetInterfaces, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetLocalHostName                                       \
	SC_SCHEMA_KV(kSCPropNetLocalHostName                          \
	            ,"LocalHostName"                                  \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetLocalHostName, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetAirPortAllowNetCreation                             \
	SC_SCHEMA_KV(kSCPropNetAirPortAllowNetCreation                \
	            ,"AllowNetCreation"                               \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetAirPortAllowNetCreation, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetAirPortAuthPassword                                 \
	SC_SCHEMA_KV(kSCPropNetAirPortAuthPassword                    \
	            ,"AuthPassword"                                   \
	            ,CFData                                           )
	SC_SCHEMA_DECLARATION(kSCPropNetAirPortAuthPassword,);

#define kSCPropNetAirPortAuthPasswordEncryption                       \
	SC_SCHEMA_KV(kSCPropNetAirPortAuthPasswordEncryption          \
	            ,"AuthPasswordEncryption"                         \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetAirPortAuthPasswordEncryption,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetAirPortJoinMode                                     \
	SC_SCHEMA_KV(kSCPropNetAirPortJoinMode                        \
	            ,"JoinMode"                                       \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetAirPortJoinMode, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetAirPortPowerEnabled                                 \
	SC_SCHEMA_KV(kSCPropNetAirPortPowerEnabled                    \
	            ,"PowerEnabled"                                   \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetAirPortPowerEnabled,);

#define kSCPropNetAirPortPreferredNetwork                             \
	SC_SCHEMA_KV(kSCPropNetAirPortPreferredNetwork                \
	            ,"PreferredNetwork"                               \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetAirPortPreferredNetwork,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetAirPortSavePasswords                                \
	SC_SCHEMA_KV(kSCPropNetAirPortSavePasswords                   \
	            ,"SavePasswords"                                  \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetAirPortSavePasswords, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetAirPortJoinModeAutomatic                             \
	SC_SCHEMA_KV(kSCValNetAirPortJoinModeAutomatic                \
	            ,"Automatic"                                      \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetAirPortJoinModeAutomatic, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCValNetAirPortJoinModePreferred                             \
	SC_SCHEMA_KV(kSCValNetAirPortJoinModePreferred                \
	            ,"Preferred"                                      \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetAirPortJoinModePreferred, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCValNetAirPortJoinModeRecent                                \
	SC_SCHEMA_KV(kSCValNetAirPortJoinModeRecent                   \
	            ,"Recent"                                         \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetAirPortJoinModeRecent, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCValNetAirPortJoinModeStrongest                             \
	SC_SCHEMA_KV(kSCValNetAirPortJoinModeStrongest                \
	            ,"Strongest"                                      \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetAirPortJoinModeStrongest, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetAirPortAuthPasswordEncryptionKeychain                \
	SC_SCHEMA_KV(kSCValNetAirPortAuthPasswordEncryptionKeychain   \
	            ,"Keychain"                                       \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetAirPortAuthPasswordEncryptionKeychain, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCPropNetAppleTalkComputerName                               \
	SC_SCHEMA_KV(kSCPropNetAppleTalkComputerName                  \
	            ,"ComputerName"                                   \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetAppleTalkComputerName,);

#define kSCPropNetAppleTalkComputerNameEncoding                       \
	SC_SCHEMA_KV(kSCPropNetAppleTalkComputerNameEncoding          \
	            ,"ComputerNameEncoding"                           \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetAppleTalkComputerNameEncoding,);

#define kSCPropNetAppleTalkConfigMethod                               \
	SC_SCHEMA_KV(kSCPropNetAppleTalkConfigMethod                  \
	            ,"ConfigMethod"                                   \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetAppleTalkConfigMethod,);

#define kSCPropNetAppleTalkDefaultZone                                \
	SC_SCHEMA_KV(kSCPropNetAppleTalkDefaultZone                   \
	            ,"DefaultZone"                                    \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetAppleTalkDefaultZone,);

#define kSCPropNetAppleTalkNetworkID                                  \
	SC_SCHEMA_KV(kSCPropNetAppleTalkNetworkID                     \
	            ,"NetworkID"                                      \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetAppleTalkNetworkID,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetAppleTalkNetworkRange                               \
	SC_SCHEMA_KV(kSCPropNetAppleTalkNetworkRange                  \
	            ,"NetworkRange"                                   \
	            ,CFArray[CFNumber]                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetAppleTalkNetworkRange, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetAppleTalkNodeID                                     \
	SC_SCHEMA_KV(kSCPropNetAppleTalkNodeID                        \
	            ,"NodeID"                                         \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetAppleTalkNodeID,);

#define kSCPropNetAppleTalkSeedNetworkRange                           \
	SC_SCHEMA_KV(kSCPropNetAppleTalkSeedNetworkRange              \
	            ,"SeedNetworkRange"                               \
	            ,CFArray[CFNumber]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetAppleTalkSeedNetworkRange,);

#define kSCPropNetAppleTalkSeedZones                                  \
	SC_SCHEMA_KV(kSCPropNetAppleTalkSeedZones                     \
	            ,"SeedZones"                                      \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetAppleTalkSeedZones,);

#define kSCValNetAppleTalkConfigMethodNode                            \
	SC_SCHEMA_KV(kSCValNetAppleTalkConfigMethodNode               \
	            ,"Node"                                           \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetAppleTalkConfigMethodNode,);

#define kSCValNetAppleTalkConfigMethodRouter                          \
	SC_SCHEMA_KV(kSCValNetAppleTalkConfigMethodRouter             \
	            ,"Router"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetAppleTalkConfigMethodRouter,);

#define kSCValNetAppleTalkConfigMethodSeedRouter                      \
	SC_SCHEMA_KV(kSCValNetAppleTalkConfigMethodSeedRouter         \
	            ,"SeedRouter"                                     \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetAppleTalkConfigMethodSeedRouter,);

#define kSCPropNetDNSDomainName                                       \
	SC_SCHEMA_KV(kSCPropNetDNSDomainName                          \
	            ,"DomainName"                                     \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetDNSDomainName,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetDNSOptions                                          \
	SC_SCHEMA_KV(kSCPropNetDNSOptions                             \
	            ,"Options"                                        \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetDNSOptions, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#define kSCPropNetDNSSearchDomains                                    \
	SC_SCHEMA_KV(kSCPropNetDNSSearchDomains                       \
	            ,"SearchDomains"                                  \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetDNSSearchDomains,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetDNSSearchOrder                                      \
	SC_SCHEMA_KV(kSCPropNetDNSSearchOrder                         \
	            ,"SearchOrder"                                    \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetDNSSearchOrder, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#define kSCPropNetDNSServerAddresses                                  \
	SC_SCHEMA_KV(kSCPropNetDNSServerAddresses                     \
	            ,"ServerAddresses"                                \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetDNSServerAddresses,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetDNSServerPort                                       \
	SC_SCHEMA_KV(kSCPropNetDNSServerPort                          \
	            ,"ServerPort"                                     \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetDNSServerPort, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetDNSServerTimeout                                    \
	SC_SCHEMA_KV(kSCPropNetDNSServerTimeout                       \
	            ,"ServerTimeout"                                  \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetDNSServerTimeout, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#define kSCPropNetDNSSortList                                         \
	SC_SCHEMA_KV(kSCPropNetDNSSortList                            \
	            ,"SortList"                                       \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetDNSSortList,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetDNSSupplementalMatchDomains                         \
	SC_SCHEMA_KV(kSCPropNetDNSSupplementalMatchDomains            \
	            ,"SupplementalMatchDomains"                       \
	            ,CFArray[CFString]                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetDNSSupplementalMatchDomains, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetDNSSupplementalMatchOrders                          \
	SC_SCHEMA_KV(kSCPropNetDNSSupplementalMatchOrders             \
	            ,"SupplementalMatchOrders"                        \
	            ,CFArray[CFNumber]                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetDNSSupplementalMatchOrders, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetEthernetMediaSubType                                \
	SC_SCHEMA_KV(kSCPropNetEthernetMediaSubType                   \
	            ,"MediaSubType"                                   \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetEthernetMediaSubType, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetEthernetMediaOptions                                \
	SC_SCHEMA_KV(kSCPropNetEthernetMediaOptions                   \
	            ,"MediaOptions"                                   \
	            ,CFArray[CFString]                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetEthernetMediaOptions, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetEthernetMTU                                         \
	SC_SCHEMA_KV(kSCPropNetEthernetMTU                            \
	            ,"MTU"                                            \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetEthernetMTU, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetInterfaceDeviceName                                 \
	SC_SCHEMA_KV(kSCPropNetInterfaceDeviceName                    \
	            ,"DeviceName"                                     \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetInterfaceDeviceName,);

#define kSCPropNetInterfaceHardware                                   \
	SC_SCHEMA_KV(kSCPropNetInterfaceHardware                      \
	            ,"Hardware"                                       \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetInterfaceHardware,);

#define kSCPropNetInterfaceType                                       \
	SC_SCHEMA_KV(kSCPropNetInterfaceType                          \
	            ,"Type"                                           \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetInterfaceType,);

#define kSCPropNetInterfaceSubType                                    \
	SC_SCHEMA_KV(kSCPropNetInterfaceSubType                       \
	            ,"SubType"                                        \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetInterfaceSubType,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetInterfaceSupportsModemOnHold                        \
	SC_SCHEMA_KV(kSCPropNetInterfaceSupportsModemOnHold           \
	            ,"SupportsModemOnHold"                            \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetInterfaceSupportsModemOnHold, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCValNetInterfaceTypeEthernet                                \
	SC_SCHEMA_KV(kSCValNetInterfaceTypeEthernet                   \
	            ,"Ethernet"                                       \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetInterfaceTypeEthernet,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetInterfaceTypeFireWire                                \
	SC_SCHEMA_KV(kSCValNetInterfaceTypeFireWire                   \
	            ,"FireWire"                                       \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetInterfaceTypeFireWire, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCValNetInterfaceTypePPP                                     \
	SC_SCHEMA_KV(kSCValNetInterfaceTypePPP                        \
	            ,"PPP"                                            \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetInterfaceTypePPP,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetInterfaceType6to4                                    \
	SC_SCHEMA_KV(kSCValNetInterfaceType6to4                       \
	            ,"6to4"                                           \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetInterfaceType6to4, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCValNetInterfaceSubTypePPPoE                                \
	SC_SCHEMA_KV(kSCValNetInterfaceSubTypePPPoE                   \
	            ,"PPPoE"                                          \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetInterfaceSubTypePPPoE,);

#define kSCValNetInterfaceSubTypePPPSerial                            \
	SC_SCHEMA_KV(kSCValNetInterfaceSubTypePPPSerial               \
	            ,"PPPSerial"                                      \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetInterfaceSubTypePPPSerial,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCValNetInterfaceSubTypePPTP                                 \
	SC_SCHEMA_KV(kSCValNetInterfaceSubTypePPTP                    \
	            ,"PPTP"                                           \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetInterfaceSubTypePPTP, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetInterfaceSubTypeL2TP                                 \
	SC_SCHEMA_KV(kSCValNetInterfaceSubTypeL2TP                    \
	            ,"L2TP"                                           \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetInterfaceSubTypeL2TP, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCPropNetIPv4Addresses                                       \
	SC_SCHEMA_KV(kSCPropNetIPv4Addresses                          \
	            ,"Addresses"                                      \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetIPv4Addresses,);

#define kSCPropNetIPv4ConfigMethod                                    \
	SC_SCHEMA_KV(kSCPropNetIPv4ConfigMethod                       \
	            ,"ConfigMethod"                                   \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetIPv4ConfigMethod,);

#define kSCPropNetIPv4DHCPClientID                                    \
	SC_SCHEMA_KV(kSCPropNetIPv4DHCPClientID                       \
	            ,"DHCPClientID"                                   \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetIPv4DHCPClientID,);

#define kSCPropNetIPv4Router                                          \
	SC_SCHEMA_KV(kSCPropNetIPv4Router                             \
	            ,"Router"                                         \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetIPv4Router,);

#define kSCPropNetIPv4SubnetMasks                                     \
	SC_SCHEMA_KV(kSCPropNetIPv4SubnetMasks                        \
	            ,"SubnetMasks"                                    \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetIPv4SubnetMasks,);

#define kSCPropNetIPv4DestAddresses                                   \
	SC_SCHEMA_KV(kSCPropNetIPv4DestAddresses                      \
	            ,"DestAddresses"                                  \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetIPv4DestAddresses,);

#define kSCPropNetIPv4BroadcastAddresses                              \
	SC_SCHEMA_KV(kSCPropNetIPv4BroadcastAddresses                 \
	            ,"BroadcastAddresses"                             \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetIPv4BroadcastAddresses,);

#define kSCValNetIPv4ConfigMethodBOOTP                                \
	SC_SCHEMA_KV(kSCValNetIPv4ConfigMethodBOOTP                   \
	            ,"BOOTP"                                          \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetIPv4ConfigMethodBOOTP,);

#define kSCValNetIPv4ConfigMethodDHCP                                 \
	SC_SCHEMA_KV(kSCValNetIPv4ConfigMethodDHCP                    \
	            ,"DHCP"                                           \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetIPv4ConfigMethodDHCP,);

#define kSCValNetIPv4ConfigMethodINFORM                               \
	SC_SCHEMA_KV(kSCValNetIPv4ConfigMethodINFORM                  \
	            ,"INFORM"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetIPv4ConfigMethodINFORM,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCValNetIPv4ConfigMethodLinkLocal                            \
	SC_SCHEMA_KV(kSCValNetIPv4ConfigMethodLinkLocal               \
	            ,"LinkLocal"                                      \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetIPv4ConfigMethodLinkLocal, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCValNetIPv4ConfigMethodManual                               \
	SC_SCHEMA_KV(kSCValNetIPv4ConfigMethodManual                  \
	            ,"Manual"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetIPv4ConfigMethodManual,);

#define kSCValNetIPv4ConfigMethodPPP                                  \
	SC_SCHEMA_KV(kSCValNetIPv4ConfigMethodPPP                     \
	            ,"PPP"                                            \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetIPv4ConfigMethodPPP,);

#define kSCPropNetIPv6Addresses                                       \
	SC_SCHEMA_KV(kSCPropNetIPv6Addresses                          \
	            ,"Addresses"                                      \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetIPv6Addresses,);

#define kSCPropNetIPv6ConfigMethod                                    \
	SC_SCHEMA_KV(kSCPropNetIPv6ConfigMethod                       \
	            ,"ConfigMethod"                                   \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetIPv6ConfigMethod,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetIPv6DestAddresses                                   \
	SC_SCHEMA_KV(kSCPropNetIPv6DestAddresses                      \
	            ,"DestAddresses"                                  \
	            ,CFArray[CFString]                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetIPv6DestAddresses, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetIPv6Flags                                           \
	SC_SCHEMA_KV(kSCPropNetIPv6Flags                              \
	            ,"Flags"                                          \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetIPv6Flags, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetIPv6PrefixLength                                    \
	SC_SCHEMA_KV(kSCPropNetIPv6PrefixLength                       \
	            ,"PrefixLength"                                   \
	            ,CFArray[CFNumber]                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetIPv6PrefixLength, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetIPv6Router                                          \
	SC_SCHEMA_KV(kSCPropNetIPv6Router                             \
	            ,"Router"                                         \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetIPv6Router, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetIPv6ConfigMethodAutomatic                            \
	SC_SCHEMA_KV(kSCValNetIPv6ConfigMethodAutomatic               \
	            ,"Automatic"                                      \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetIPv6ConfigMethodAutomatic, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetIPv6ConfigMethodManual                               \
	SC_SCHEMA_KV(kSCValNetIPv6ConfigMethodManual                  \
	            ,"Manual"                                         \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetIPv6ConfigMethodManual, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetIPv6ConfigMethodRouterAdvertisement                  \
	SC_SCHEMA_KV(kSCValNetIPv6ConfigMethodRouterAdvertisement     \
	            ,"RouterAdvertisement"                            \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetIPv6ConfigMethodRouterAdvertisement, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetIPv6ConfigMethod6to4                                 \
	SC_SCHEMA_KV(kSCValNetIPv6ConfigMethod6to4                    \
	            ,"6to4"                                           \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetIPv6ConfigMethod6to4, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNet6to4Relay                                           \
	SC_SCHEMA_KV(kSCPropNet6to4Relay                              \
	            ,"Relay"                                          \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNet6to4Relay, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCPropNetLinkActive                                          \
	SC_SCHEMA_KV(kSCPropNetLinkActive                             \
	            ,"Active"                                         \
	            ,CFBoolean                                        )
	SC_SCHEMA_DECLARATION(kSCPropNetLinkActive,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetLinkDetaching                                       \
	SC_SCHEMA_KV(kSCPropNetLinkDetaching                          \
	            ,"Detaching"                                      \
	            ,CFBoolean                                        )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetLinkDetaching, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetModemConnectionScript                               \
	SC_SCHEMA_KV(kSCPropNetModemConnectionScript                  \
	            ,"ConnectionScript"                               \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetModemConnectionScript,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetModemConnectSpeed                                   \
	SC_SCHEMA_KV(kSCPropNetModemConnectSpeed                      \
	            ,"ConnectSpeed"                                   \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetModemConnectSpeed, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetModemDataCompression                                \
	SC_SCHEMA_KV(kSCPropNetModemDataCompression                   \
	            ,"DataCompression"                                \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetModemDataCompression,);

#define kSCPropNetModemDialMode                                       \
	SC_SCHEMA_KV(kSCPropNetModemDialMode                          \
	            ,"DialMode"                                       \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetModemDialMode,);

#define kSCPropNetModemErrorCorrection                                \
	SC_SCHEMA_KV(kSCPropNetModemErrorCorrection                   \
	            ,"ErrorCorrection"                                \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetModemErrorCorrection,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetModemHoldCallWaitingAudibleAlert                    \
	SC_SCHEMA_KV(kSCPropNetModemHoldCallWaitingAudibleAlert       \
	            ,"HoldCallWaitingAudibleAlert"                    \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetModemHoldCallWaitingAudibleAlert, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetModemHoldDisconnectOnAnswer                         \
	SC_SCHEMA_KV(kSCPropNetModemHoldDisconnectOnAnswer            \
	            ,"HoldDisconnectOnAnswer"                         \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetModemHoldDisconnectOnAnswer, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetModemHoldEnabled                                    \
	SC_SCHEMA_KV(kSCPropNetModemHoldEnabled                       \
	            ,"HoldEnabled"                                    \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetModemHoldEnabled, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetModemHoldReminder                                   \
	SC_SCHEMA_KV(kSCPropNetModemHoldReminder                      \
	            ,"HoldReminder"                                   \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetModemHoldReminder, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetModemHoldReminderTime                               \
	SC_SCHEMA_KV(kSCPropNetModemHoldReminderTime                  \
	            ,"HoldReminderTime"                               \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetModemHoldReminderTime, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetModemNote                                           \
	SC_SCHEMA_KV(kSCPropNetModemNote                              \
	            ,"Note"                                           \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetModemNote, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetModemPulseDial                                      \
	SC_SCHEMA_KV(kSCPropNetModemPulseDial                         \
	            ,"PulseDial"                                      \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetModemPulseDial,);

#define kSCPropNetModemSpeaker                                        \
	SC_SCHEMA_KV(kSCPropNetModemSpeaker                           \
	            ,"Speaker"                                        \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetModemSpeaker,);

#define kSCPropNetModemSpeed                                          \
	SC_SCHEMA_KV(kSCPropNetModemSpeed                             \
	            ,"Speed"                                          \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetModemSpeed,);

#define kSCValNetModemDialModeIgnoreDialTone                          \
	SC_SCHEMA_KV(kSCValNetModemDialModeIgnoreDialTone             \
	            ,"IgnoreDialTone"                                 \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetModemDialModeIgnoreDialTone,);

#define kSCValNetModemDialModeManual                                  \
	SC_SCHEMA_KV(kSCValNetModemDialModeManual                     \
	            ,"Manual"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetModemDialModeManual,);

#define kSCValNetModemDialModeWaitForDialTone                         \
	SC_SCHEMA_KV(kSCValNetModemDialModeWaitForDialTone            \
	            ,"WaitForDialTone"                                \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetModemDialModeWaitForDialTone,);

#define kSCPropNetNetInfoBindingMethods                               \
	SC_SCHEMA_KV(kSCPropNetNetInfoBindingMethods                  \
	            ,"BindingMethods"                                 \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetNetInfoBindingMethods,);

#define kSCPropNetNetInfoServerAddresses                              \
	SC_SCHEMA_KV(kSCPropNetNetInfoServerAddresses                 \
	            ,"ServerAddresses"                                \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetNetInfoServerAddresses,);

#define kSCPropNetNetInfoServerTags                                   \
	SC_SCHEMA_KV(kSCPropNetNetInfoServerTags                      \
	            ,"ServerTags"                                     \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetNetInfoServerTags,);

#define kSCPropNetNetInfoBroadcastServerTag                           \
	SC_SCHEMA_KV(kSCPropNetNetInfoBroadcastServerTag              \
	            ,"BroadcastServerTag"                             \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetNetInfoBroadcastServerTag,);

#define kSCValNetNetInfoBindingMethodsBroadcast                       \
	SC_SCHEMA_KV(kSCValNetNetInfoBindingMethodsBroadcast          \
	            ,"Broadcast"                                      \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetNetInfoBindingMethodsBroadcast,);

#define kSCValNetNetInfoBindingMethodsDHCP                            \
	SC_SCHEMA_KV(kSCValNetNetInfoBindingMethodsDHCP               \
	            ,"DHCP"                                           \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetNetInfoBindingMethodsDHCP,);

#define kSCValNetNetInfoBindingMethodsManual                          \
	SC_SCHEMA_KV(kSCValNetNetInfoBindingMethodsManual             \
	            ,"Manual"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetNetInfoBindingMethodsManual,);

#define kSCValNetNetInfoDefaultServerTag                              \
	SC_SCHEMA_KV(kSCValNetNetInfoDefaultServerTag                 \
	            ,"network"                                        \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCValNetNetInfoDefaultServerTag,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetPPPACSPEnabled                                      \
	SC_SCHEMA_KV(kSCPropNetPPPACSPEnabled                         \
	            ,"ACSPEnabled"                                    \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPACSPEnabled, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetPPPConnectTime                                      \
	SC_SCHEMA_KV(kSCPropNetPPPConnectTime                         \
	            ,"ConnectTime"                                    \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPConnectTime, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetPPPDeviceLastCause                                  \
	SC_SCHEMA_KV(kSCPropNetPPPDeviceLastCause                     \
	            ,"DeviceLastCause"                                \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPDeviceLastCause, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetPPPDialOnDemand                                     \
	SC_SCHEMA_KV(kSCPropNetPPPDialOnDemand                        \
	            ,"DialOnDemand"                                   \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPDialOnDemand,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetPPPDisconnectOnFastUserSwitch                       \
	SC_SCHEMA_KV(kSCPropNetPPPDisconnectOnFastUserSwitch          \
	            ,"DisconnectOnFastUserSwitch"                     \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPDisconnectOnFastUserSwitch, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#define kSCPropNetPPPDisconnectOnIdle                                 \
	SC_SCHEMA_KV(kSCPropNetPPPDisconnectOnIdle                    \
	            ,"DisconnectOnIdle"                               \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPDisconnectOnIdle,);

#define kSCPropNetPPPDisconnectOnIdleTimer                            \
	SC_SCHEMA_KV(kSCPropNetPPPDisconnectOnIdleTimer               \
	            ,"DisconnectOnIdleTimer"                          \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPDisconnectOnIdleTimer,);

#define kSCPropNetPPPDisconnectOnLogout                               \
	SC_SCHEMA_KV(kSCPropNetPPPDisconnectOnLogout                  \
	            ,"DisconnectOnLogout"                             \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPDisconnectOnLogout,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetPPPDisconnectOnSleep                                \
	SC_SCHEMA_KV(kSCPropNetPPPDisconnectOnSleep                   \
	            ,"DisconnectOnSleep"                              \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPDisconnectOnSleep, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetPPPDisconnectTime                                   \
	SC_SCHEMA_KV(kSCPropNetPPPDisconnectTime                      \
	            ,"DisconnectTime"                                 \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPDisconnectTime, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCPropNetPPPIdleReminderTimer                                \
	SC_SCHEMA_KV(kSCPropNetPPPIdleReminderTimer                   \
	            ,"IdleReminderTimer"                              \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPIdleReminderTimer,);

#define kSCPropNetPPPIdleReminder                                     \
	SC_SCHEMA_KV(kSCPropNetPPPIdleReminder                        \
	            ,"IdleReminder"                                   \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPIdleReminder,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetPPPLastCause                                        \
	SC_SCHEMA_KV(kSCPropNetPPPLastCause                           \
	            ,"LastCause"                                      \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLastCause, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetPPPLogfile                                          \
	SC_SCHEMA_KV(kSCPropNetPPPLogfile                             \
	            ,"Logfile"                                        \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLogfile,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetPPPPlugins                                          \
	SC_SCHEMA_KV(kSCPropNetPPPPlugins                             \
	            ,"Plugins"                                        \
	            ,CFArray[CFString]                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPPlugins, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetPPPRetryConnectTime                                 \
	SC_SCHEMA_KV(kSCPropNetPPPRetryConnectTime                    \
	            ,"RetryConnectTime"                               \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPRetryConnectTime, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCPropNetPPPSessionTimer                                     \
	SC_SCHEMA_KV(kSCPropNetPPPSessionTimer                        \
	            ,"SessionTimer"                                   \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPSessionTimer,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetPPPStatus                                           \
	SC_SCHEMA_KV(kSCPropNetPPPStatus                              \
	            ,"Status"                                         \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPStatus, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetPPPUseSessionTimer                                  \
	SC_SCHEMA_KV(kSCPropNetPPPUseSessionTimer                     \
	            ,"UseSessionTimer"                                \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPUseSessionTimer, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#define kSCPropNetPPPVerboseLogging                                   \
	SC_SCHEMA_KV(kSCPropNetPPPVerboseLogging                      \
	            ,"VerboseLogging"                                 \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPVerboseLogging,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetPPPAuthEAPPlugins                                   \
	SC_SCHEMA_KV(kSCPropNetPPPAuthEAPPlugins                      \
	            ,"AuthEAPPlugins"                                 \
	            ,CFArray[CFString]                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPAuthEAPPlugins, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCPropNetPPPAuthName                                         \
	SC_SCHEMA_KV(kSCPropNetPPPAuthName                            \
	            ,"AuthName"                                       \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPAuthName,);

#define kSCPropNetPPPAuthPassword                                     \
	SC_SCHEMA_KV(kSCPropNetPPPAuthPassword                        \
	            ,"AuthPassword"                                   \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPAuthPassword,);

#define kSCPropNetPPPAuthPasswordEncryption                           \
	SC_SCHEMA_KV(kSCPropNetPPPAuthPasswordEncryption              \
	            ,"AuthPasswordEncryption"                         \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPAuthPasswordEncryption,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetPPPAuthPrompt                                       \
	SC_SCHEMA_KV(kSCPropNetPPPAuthPrompt                          \
	            ,"AuthPrompt"                                     \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPAuthPrompt, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCPropNetPPPAuthProtocol                                     \
	SC_SCHEMA_KV(kSCPropNetPPPAuthProtocol                        \
	            ,"AuthProtocol"                                   \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPAuthProtocol,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetPPPAuthPasswordEncryptionKeychain                    \
	SC_SCHEMA_KV(kSCValNetPPPAuthPasswordEncryptionKeychain       \
	            ,"Keychain"                                       \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetPPPAuthPasswordEncryptionKeychain, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetPPPAuthPromptBefore                                  \
	SC_SCHEMA_KV(kSCValNetPPPAuthPromptBefore                     \
	            ,"Before"                                         \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetPPPAuthPromptBefore, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetPPPAuthPromptAfter                                   \
	SC_SCHEMA_KV(kSCValNetPPPAuthPromptAfter                      \
	            ,"After"                                          \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetPPPAuthPromptAfter, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCValNetPPPAuthProtocolCHAP                                  \
	SC_SCHEMA_KV(kSCValNetPPPAuthProtocolCHAP                     \
	            ,"CHAP"                                           \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCValNetPPPAuthProtocolCHAP,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetPPPAuthProtocolEAP                                   \
	SC_SCHEMA_KV(kSCValNetPPPAuthProtocolEAP                      \
	            ,"EAP"                                            \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetPPPAuthProtocolEAP, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetPPPAuthProtocolMSCHAP1                               \
	SC_SCHEMA_KV(kSCValNetPPPAuthProtocolMSCHAP1                  \
	            ,"MSCHAP1"                                        \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetPPPAuthProtocolMSCHAP1, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetPPPAuthProtocolMSCHAP2                               \
	SC_SCHEMA_KV(kSCValNetPPPAuthProtocolMSCHAP2                  \
	            ,"MSCHAP2"                                        \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetPPPAuthProtocolMSCHAP2, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCValNetPPPAuthProtocolPAP                                   \
	SC_SCHEMA_KV(kSCValNetPPPAuthProtocolPAP                      \
	            ,"PAP"                                            \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCValNetPPPAuthProtocolPAP,);

#define kSCPropNetPPPCommAlternateRemoteAddress                       \
	SC_SCHEMA_KV(kSCPropNetPPPCommAlternateRemoteAddress          \
	            ,"CommAlternateRemoteAddress"                     \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCommAlternateRemoteAddress,);

#define kSCPropNetPPPCommConnectDelay                                 \
	SC_SCHEMA_KV(kSCPropNetPPPCommConnectDelay                    \
	            ,"CommConnectDelay"                               \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCommConnectDelay,);

#define kSCPropNetPPPCommDisplayTerminalWindow                        \
	SC_SCHEMA_KV(kSCPropNetPPPCommDisplayTerminalWindow           \
	            ,"CommDisplayTerminalWindow"                      \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCommDisplayTerminalWindow,);

#define kSCPropNetPPPCommRedialCount                                  \
	SC_SCHEMA_KV(kSCPropNetPPPCommRedialCount                     \
	            ,"CommRedialCount"                                \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCommRedialCount,);

#define kSCPropNetPPPCommRedialEnabled                                \
	SC_SCHEMA_KV(kSCPropNetPPPCommRedialEnabled                   \
	            ,"CommRedialEnabled"                              \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCommRedialEnabled,);

#define kSCPropNetPPPCommRedialInterval                               \
	SC_SCHEMA_KV(kSCPropNetPPPCommRedialInterval                  \
	            ,"CommRedialInterval"                             \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCommRedialInterval,);

#define kSCPropNetPPPCommRemoteAddress                                \
	SC_SCHEMA_KV(kSCPropNetPPPCommRemoteAddress                   \
	            ,"CommRemoteAddress"                              \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCommRemoteAddress,);

#define kSCPropNetPPPCommTerminalScript                               \
	SC_SCHEMA_KV(kSCPropNetPPPCommTerminalScript                  \
	            ,"CommTerminalScript"                             \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCommTerminalScript,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetPPPCommUseTerminalScript                            \
	SC_SCHEMA_KV(kSCPropNetPPPCommUseTerminalScript               \
	            ,"CommUseTerminalScript"                          \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCommUseTerminalScript, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_2
#define kSCPropNetPPPCCPEnabled                                       \
	SC_SCHEMA_KV(kSCPropNetPPPCCPEnabled                          \
	            ,"CCPEnabled"                                     \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCCPEnabled, AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetPPPCCPMPPE40Enabled                                 \
	SC_SCHEMA_KV(kSCPropNetPPPCCPMPPE40Enabled                    \
	            ,"CCPMPPE40Enabled"                               \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCCPMPPE40Enabled, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetPPPCCPMPPE128Enabled                                \
	SC_SCHEMA_KV(kSCPropNetPPPCCPMPPE128Enabled                   \
	            ,"CCPMPPE128Enabled"                              \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPCCPMPPE128Enabled, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#define kSCPropNetPPPIPCPCompressionVJ                                \
	SC_SCHEMA_KV(kSCPropNetPPPIPCPCompressionVJ                   \
	            ,"IPCPCompressionVJ"                              \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPIPCPCompressionVJ,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetPPPIPCPUsePeerDNS                                   \
	SC_SCHEMA_KV(kSCPropNetPPPIPCPUsePeerDNS                      \
	            ,"IPCPUsePeerDNS"                                 \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetPPPIPCPUsePeerDNS, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#define kSCPropNetPPPLCPEchoEnabled                                   \
	SC_SCHEMA_KV(kSCPropNetPPPLCPEchoEnabled                      \
	            ,"LCPEchoEnabled"                                 \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLCPEchoEnabled,);

#define kSCPropNetPPPLCPEchoFailure                                   \
	SC_SCHEMA_KV(kSCPropNetPPPLCPEchoFailure                      \
	            ,"LCPEchoFailure"                                 \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLCPEchoFailure,);

#define kSCPropNetPPPLCPEchoInterval                                  \
	SC_SCHEMA_KV(kSCPropNetPPPLCPEchoInterval                     \
	            ,"LCPEchoInterval"                                \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLCPEchoInterval,);

#define kSCPropNetPPPLCPCompressionACField                            \
	SC_SCHEMA_KV(kSCPropNetPPPLCPCompressionACField               \
	            ,"LCPCompressionACField"                          \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLCPCompressionACField,);

#define kSCPropNetPPPLCPCompressionPField                             \
	SC_SCHEMA_KV(kSCPropNetPPPLCPCompressionPField                \
	            ,"LCPCompressionPField"                           \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLCPCompressionPField,);

#define kSCPropNetPPPLCPMRU                                           \
	SC_SCHEMA_KV(kSCPropNetPPPLCPMRU                              \
	            ,"LCPMRU"                                         \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLCPMRU,);

#define kSCPropNetPPPLCPMTU                                           \
	SC_SCHEMA_KV(kSCPropNetPPPLCPMTU                              \
	            ,"LCPMTU"                                         \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLCPMTU,);

#define kSCPropNetPPPLCPReceiveACCM                                   \
	SC_SCHEMA_KV(kSCPropNetPPPLCPReceiveACCM                      \
	            ,"LCPReceiveACCM"                                 \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLCPReceiveACCM,);

#define kSCPropNetPPPLCPTransmitACCM                                  \
	SC_SCHEMA_KV(kSCPropNetPPPLCPTransmitACCM                     \
	            ,"LCPTransmitACCM"                                \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetPPPLCPTransmitACCM,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetL2TPIPSecSharedSecret                               \
	SC_SCHEMA_KV(kSCPropNetL2TPIPSecSharedSecret                  \
	            ,"IPSecSharedSecret"                              \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetL2TPIPSecSharedSecret, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetL2TPIPSecSharedSecretEncryption                     \
	SC_SCHEMA_KV(kSCPropNetL2TPIPSecSharedSecretEncryption        \
	            ,"IPSecSharedSecretEncryption"                    \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetL2TPIPSecSharedSecretEncryption, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCPropNetL2TPTransport                                       \
	SC_SCHEMA_KV(kSCPropNetL2TPTransport                          \
	            ,"Transport"                                      \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetL2TPTransport, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetL2TPIPSecSharedSecretEncryptionKeychain              \
	SC_SCHEMA_KV(kSCValNetL2TPIPSecSharedSecretEncryptionKeychain \
	            ,"Keychain"                                       \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetL2TPIPSecSharedSecretEncryptionKeychain, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetL2TPTransportIP                                      \
	SC_SCHEMA_KV(kSCValNetL2TPTransportIP                         \
	            ,"IP"                                             \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetL2TPTransportIP, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_3
#define kSCValNetL2TPTransportIPSec                                   \
	SC_SCHEMA_KV(kSCValNetL2TPTransportIPSec                      \
	            ,"IPSec"                                          \
	            ,                                                 )
#endif
	SC_SCHEMA_DECLARATION(kSCValNetL2TPTransportIPSec, AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER);

#define kSCPropNetProxiesExceptionsList                               \
	SC_SCHEMA_KV(kSCPropNetProxiesExceptionsList                  \
	            ,"ExceptionsList"                                 \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesExceptionsList,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetProxiesExcludeSimpleHostnames                       \
	SC_SCHEMA_KV(kSCPropNetProxiesExcludeSimpleHostnames          \
	            ,"ExcludeSimpleHostnames"                         \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesExcludeSimpleHostnames, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#define kSCPropNetProxiesFTPEnable                                    \
	SC_SCHEMA_KV(kSCPropNetProxiesFTPEnable                       \
	            ,"FTPEnable"                                      \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesFTPEnable,);

#define kSCPropNetProxiesFTPPassive                                   \
	SC_SCHEMA_KV(kSCPropNetProxiesFTPPassive                      \
	            ,"FTPPassive"                                     \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesFTPPassive,);

#define kSCPropNetProxiesFTPPort                                      \
	SC_SCHEMA_KV(kSCPropNetProxiesFTPPort                         \
	            ,"FTPPort"                                        \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesFTPPort,);

#define kSCPropNetProxiesFTPProxy                                     \
	SC_SCHEMA_KV(kSCPropNetProxiesFTPProxy                        \
	            ,"FTPProxy"                                       \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesFTPProxy,);

#define kSCPropNetProxiesGopherEnable                                 \
	SC_SCHEMA_KV(kSCPropNetProxiesGopherEnable                    \
	            ,"GopherEnable"                                   \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesGopherEnable,);

#define kSCPropNetProxiesGopherPort                                   \
	SC_SCHEMA_KV(kSCPropNetProxiesGopherPort                      \
	            ,"GopherPort"                                     \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesGopherPort,);

#define kSCPropNetProxiesGopherProxy                                  \
	SC_SCHEMA_KV(kSCPropNetProxiesGopherProxy                     \
	            ,"GopherProxy"                                    \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesGopherProxy,);

#define kSCPropNetProxiesHTTPEnable                                   \
	SC_SCHEMA_KV(kSCPropNetProxiesHTTPEnable                      \
	            ,"HTTPEnable"                                     \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesHTTPEnable,);

#define kSCPropNetProxiesHTTPPort                                     \
	SC_SCHEMA_KV(kSCPropNetProxiesHTTPPort                        \
	            ,"HTTPPort"                                       \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesHTTPPort,);

#define kSCPropNetProxiesHTTPProxy                                    \
	SC_SCHEMA_KV(kSCPropNetProxiesHTTPProxy                       \
	            ,"HTTPProxy"                                      \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesHTTPProxy,);

#define kSCPropNetProxiesHTTPSEnable                                  \
	SC_SCHEMA_KV(kSCPropNetProxiesHTTPSEnable                     \
	            ,"HTTPSEnable"                                    \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesHTTPSEnable,);

#define kSCPropNetProxiesHTTPSPort                                    \
	SC_SCHEMA_KV(kSCPropNetProxiesHTTPSPort                       \
	            ,"HTTPSPort"                                      \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesHTTPSPort,);

#define kSCPropNetProxiesHTTPSProxy                                   \
	SC_SCHEMA_KV(kSCPropNetProxiesHTTPSProxy                      \
	            ,"HTTPSProxy"                                     \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesHTTPSProxy,);

#define kSCPropNetProxiesRTSPEnable                                   \
	SC_SCHEMA_KV(kSCPropNetProxiesRTSPEnable                      \
	            ,"RTSPEnable"                                     \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesRTSPEnable,);

#define kSCPropNetProxiesRTSPPort                                     \
	SC_SCHEMA_KV(kSCPropNetProxiesRTSPPort                        \
	            ,"RTSPPort"                                       \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesRTSPPort,);

#define kSCPropNetProxiesRTSPProxy                                    \
	SC_SCHEMA_KV(kSCPropNetProxiesRTSPProxy                       \
	            ,"RTSPProxy"                                      \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesRTSPProxy,);

#define kSCPropNetProxiesSOCKSEnable                                  \
	SC_SCHEMA_KV(kSCPropNetProxiesSOCKSEnable                     \
	            ,"SOCKSEnable"                                    \
	            ,CFNumber (0 or 1)                                )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesSOCKSEnable,);

#define kSCPropNetProxiesSOCKSPort                                    \
	SC_SCHEMA_KV(kSCPropNetProxiesSOCKSPort                       \
	            ,"SOCKSPort"                                      \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesSOCKSPort,);

#define kSCPropNetProxiesSOCKSProxy                                   \
	SC_SCHEMA_KV(kSCPropNetProxiesSOCKSProxy                      \
	            ,"SOCKSProxy"                                     \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesSOCKSProxy,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetProxiesProxyAutoConfigEnable                        \
	SC_SCHEMA_KV(kSCPropNetProxiesProxyAutoConfigEnable           \
	            ,"ProxyAutoConfigEnable"                          \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesProxyAutoConfigEnable, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetProxiesProxyAutoConfigURLString                     \
	SC_SCHEMA_KV(kSCPropNetProxiesProxyAutoConfigURLString        \
	            ,"ProxyAutoConfigURLString"                       \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesProxyAutoConfigURLString, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_4
#define kSCPropNetProxiesProxyAutoDiscoveryEnable                     \
	SC_SCHEMA_KV(kSCPropNetProxiesProxyAutoDiscoveryEnable        \
	            ,"ProxyAutoDiscoveryEnable"                       \
	            ,CFNumber (0 or 1)                                )
#endif
	SC_SCHEMA_DECLARATION(kSCPropNetProxiesProxyAutoDiscoveryEnable, AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER);

#define kSCEntUsersConsoleUser                                        \
	SC_SCHEMA_KV(kSCEntUsersConsoleUser                           \
	            ,"ConsoleUser"                                    \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCEntUsersConsoleUser,);

#define kSCPropSystemComputerName                                     \
	SC_SCHEMA_KV(kSCPropSystemComputerName                        \
	            ,"ComputerName"                                   \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCPropSystemComputerName,);

#define kSCPropSystemComputerNameEncoding                             \
	SC_SCHEMA_KV(kSCPropSystemComputerNameEncoding                \
	            ,"ComputerNameEncoding"                           \
	            ,CFNumber                                         )
	SC_SCHEMA_DECLARATION(kSCPropSystemComputerNameEncoding,);

#define kSCDynamicStoreDomainFile                                     \
	SC_SCHEMA_KV(kSCDynamicStoreDomainFile                        \
	            ,"File:"                                          \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCDynamicStoreDomainFile,);

#define kSCDynamicStoreDomainPlugin                                   \
	SC_SCHEMA_KV(kSCDynamicStoreDomainPlugin                      \
	            ,"Plugin:"                                        \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCDynamicStoreDomainPlugin,);

#define kSCDynamicStoreDomainSetup                                    \
	SC_SCHEMA_KV(kSCDynamicStoreDomainSetup                       \
	            ,"Setup:"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCDynamicStoreDomainSetup,);

#define kSCDynamicStoreDomainState                                    \
	SC_SCHEMA_KV(kSCDynamicStoreDomainState                       \
	            ,"State:"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCDynamicStoreDomainState,);

#define kSCDynamicStoreDomainPrefs                                    \
	SC_SCHEMA_KV(kSCDynamicStoreDomainPrefs                       \
	            ,"Prefs:"                                         \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCDynamicStoreDomainPrefs,);

#define kSCDynamicStorePropSetupCurrentSet                            \
	SC_SCHEMA_KV(kSCDynamicStorePropSetupCurrentSet               \
	            ,"CurrentSet"                                     \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCDynamicStorePropSetupCurrentSet,);

#define kSCDynamicStorePropSetupLastUpdated                           \
	SC_SCHEMA_KV(kSCDynamicStorePropSetupLastUpdated              \
	            ,"LastUpdated"                                    \
	            ,                                                 )
	SC_SCHEMA_DECLARATION(kSCDynamicStorePropSetupLastUpdated,);

#define kSCDynamicStorePropNetInterfaces                              \
	SC_SCHEMA_KV(kSCDynamicStorePropNetInterfaces                 \
	            ,"Interfaces"                                     \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCDynamicStorePropNetInterfaces,);

#define kSCDynamicStorePropNetPrimaryInterface                        \
	SC_SCHEMA_KV(kSCDynamicStorePropNetPrimaryInterface           \
	            ,"PrimaryInterface"                               \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCDynamicStorePropNetPrimaryInterface,);

#define kSCDynamicStorePropNetPrimaryService                          \
	SC_SCHEMA_KV(kSCDynamicStorePropNetPrimaryService             \
	            ,"PrimaryService"                                 \
	            ,CFString                                         )
	SC_SCHEMA_DECLARATION(kSCDynamicStorePropNetPrimaryService,);

#define kSCDynamicStorePropNetServiceIDs                              \
	SC_SCHEMA_KV(kSCDynamicStorePropNetServiceIDs                 \
	            ,"ServiceIDs"                                     \
	            ,CFArray[CFString]                                )
	SC_SCHEMA_DECLARATION(kSCDynamicStorePropNetServiceIDs,);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_1 && \
    MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_3
#define kSCPropUsersConsoleUserName                                   \
	SC_SCHEMA_KV(kSCPropUsersConsoleUserName                      \
	            ,"Name"                                           \
	            ,CFString                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropUsersConsoleUserName, AVAILABLE_MAC_OS_X_VERSION_10_1_AND_LATER_BUT_DEPRECATED_IN_MAC_OS_X_VERSION_10_4);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_1 && \
    MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_3
#define kSCPropUsersConsoleUserUID                                    \
	SC_SCHEMA_KV(kSCPropUsersConsoleUserUID                       \
	            ,"UID"                                            \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropUsersConsoleUserUID, AVAILABLE_MAC_OS_X_VERSION_10_1_AND_LATER_BUT_DEPRECATED_IN_MAC_OS_X_VERSION_10_4);

#if MAC_OS_X_VERSION_MIN_REQUIRED >= MAC_OS_X_VERSION_10_1 && \
    MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_3
#define kSCPropUsersConsoleUserGID                                    \
	SC_SCHEMA_KV(kSCPropUsersConsoleUserGID                       \
	            ,"GID"                                            \
	            ,CFNumber                                         )
#endif
	SC_SCHEMA_DECLARATION(kSCPropUsersConsoleUserGID, AVAILABLE_MAC_OS_X_VERSION_10_1_AND_LATER_BUT_DEPRECATED_IN_MAC_OS_X_VERSION_10_4);

#endif /* _SCSCHEMADEFINITIONS_H */
