/*
 * Copyright (c) 2000-2004 Apple Computer, Inc. All Rights Reserved.
 * 
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */


//
// ssnotify - constants for Security notifications
//
// This interface is private to the Security system. It is not a public interface,
// and it may change at any time. You have been warned.
//
#ifndef _H_SSNOTIFY
#define _H_SSNOTIFY


#include <Security/cssm.h>

namespace Security {
namespace SecurityServer {


//
// Types
//
typedef uint32 NotificationDomain;  // message domain (group)
typedef uint32 NotificationEvent;   // event number (within a domain)
typedef uint32 NotificationMask;	// mask of events (containing 1 << event number)


//
// Values for notification domains.
//
enum {
	kNotificationDomainAll			= 0, // all domains (useful for testing only)
	kNotificationDomainDatabase		= 1, // something happened to a database (aka keychain)
	kNotificationDomainPCSC			= 2, // pcscd-generated events
	kNotificationDomainCDSA			= 3  // CDSA-layer events (for plugins)
};


//
// Event codes are separate per domain, with a maximum of 32 event codes
// per domain (0-31) so they fit into a uint32 mask set. For each domain,
// this constant will thus select all possible events for that domain:
//
enum {
	kNotificationAllEvents			= uint32(-1)	// mask of all events
};


//
// Notification events for kNotificationDomainDatabase.
// These are public events (vended through the "keychain notifications" API),
// and the event numbers must match the public API.
// The constants below only describe the subset of this domain whose events
// are generated directly by securityd. The full complement is in
// <Security/SecKeychain.h>, including those generated by clients for other
// clients.
//
enum {
	kNotificationEventLocked			= 1,	// a keychain was locked
	kNotificationEventUnlocked			= 2,	// a keychain was unlocked
	kNotificationEventPassphraseChanged = 6		// a keychain password was (possibly) changed
};


//
// PCSC-related notifications.
// These are generated by the PCSC daemon (pcscd), and are generally only
// (directly) listened to by securityd, though they may be useful for other
// programs that want to know when smart-card state is changing. This is
// an Apple-specific feature of pcscd.
//
enum {
	kNotificationPCSCStateChange		= 1		// general PCSC state change
};


//
// CDSA-related notifications.
// These are generated by securityd, and are listened to by CDSA plugins
// that need to generate CDSA-layer event notifications. This feature is
// internal to Apple's smart-card support architecture; the official (CDSA)
// standard events are sent by the plugins to CSSM (as a result of receiving
// these events).
//
enum {
	kNotificationCDSAInsertion			= 1,	// CDSA insertion event
	kNotificationCDSARemoval			= 2,	// CDSA removal event
	kNotificationCDSAFailure			= 3		// CDSA failure event
};


} // end namespace SecurityServer
} // end namespace Security


#endif //_H_SSNOTIFY
